/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessage;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;

public class BTAllowedFast
implements BTMessage {
    private DirectByteBuffer buffer = null;
    private final byte version;
    private String description = null;
    private final int piece_number;

    public BTAllowedFast(int piece_number, byte version) {
        this.piece_number = piece_number;
        this.version = version;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    @Override
    public String getID() {
        return "BT_ALLOWED_FAST";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_ALLOWED_FAST_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 17;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_ALLOWED_FAST piece #" + this.piece_number;
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)33, 4);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 4) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 12");
        }
        int num = data.getInt((byte)11);
        if (num < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        data.returnToPool();
        return new BTAllowedFast(num, version);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

