/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessage;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;

public class BTHashes
implements BTMessage {
    private static int WIRE_SIZE_FIXED = 48;
    private final byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] pieces_root;
    private final int base_layer;
    private final int index;
    private final int length;
    private final int proof_layers;
    private final byte[][] hashes;

    public BTHashes(byte[] _pieces_root, int _base_layer, int _index, int _length, int _proof_layers, byte[][] _hashes, byte _version) {
        this.pieces_root = _pieces_root;
        this.base_layer = _base_layer;
        this.index = _index;
        this.length = _length;
        this.proof_layers = _proof_layers;
        this.hashes = _hashes;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "BT_HASHES";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_HASHES_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 22;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HASHES " + (this.pieces_root == null ? "null" : ByteFormatter.encodeString(this.pieces_root)) + ": b=" + this.base_layer + ",i=" + this.index + ",l=" + this.length + ",p=" + this.proof_layers;
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            int wire_size = WIRE_SIZE_FIXED + this.hashes.length * 32;
            this.buffer = DirectByteBufferPool.getBuffer((byte)38, wire_size);
            this.buffer.put((byte)11, this.pieces_root);
            this.buffer.putInt((byte)11, this.base_layer);
            this.buffer.putInt((byte)11, this.index);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.putInt((byte)11, this.proof_layers);
            byte[][] byArray = this.hashes;
            int n = this.hashes.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] hash = byArray[n2];
                this.buffer.put((byte)11, hash);
                ++n2;
            }
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        int remaining = data.remaining((byte)11);
        if (remaining < WIRE_SIZE_FIXED) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + remaining + "] < " + WIRE_SIZE_FIXED);
        }
        byte[] pieces_root = new byte[32];
        data.get((byte)11, pieces_root);
        int base_layer = data.getInt((byte)11);
        int index = data.getInt((byte)11);
        int length = data.getInt((byte)11);
        int proof_layers = data.getInt((byte)11);
        int hashes_length = data.remaining((byte)11);
        if (hashes_length % 32 != 0) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + hashes_length + "] not multiple of hash size");
        }
        int hash_count = hashes_length / 32;
        byte[][] hashes = new byte[hash_count][];
        int i = 0;
        while (i < hash_count) {
            hashes[i] = new byte[32];
            data.get((byte)11, hashes[i]);
            ++i;
        }
        data.returnToPool();
        return new BTHashes(pieces_root, base_layer, index, length, proof_layers, hashes, version);
    }

    public byte[] getPiecesRoot() {
        return this.pieces_root;
    }

    public int getBaseLayer() {
        return this.base_layer;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public int getProofLayers() {
        return this.proof_layers;
    }

    public byte[][] getHashes() {
        return this.hashes;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

