/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent.ltep;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UTHolePunch
implements LTMessage {
    public static byte MT_RENDEZVOUS = 0;
    public static byte MT_CONNECT = 1;
    public static byte MT_ERROR = (byte)2;
    public static int ERR_NONE = 0;
    public static int ERR_NO_SUCH_PEER = 1;
    public static int ERR_NOT_CONNECTED = 2;
    public static int ERR_NO_SUPPORT = 3;
    public static int ERR_NO_SELF = 4;
    private final byte version;
    private DirectByteBuffer buffer = null;
    private final byte message_type;
    private final InetAddress address;
    private final int port;
    private final int error_code;

    public UTHolePunch(byte _message_type, InetAddress _address, int _port, int _error, byte _version) {
        this.message_type = _message_type;
        this.address = _address;
        this.port = _port;
        this.error_code = _error;
        this.version = _version;
    }

    public UTHolePunch(UTHolePunch _request, int _error_code, byte _version) {
        this.message_type = MT_ERROR;
        this.address = _request.address;
        this.port = _request.port;
        this.error_code = _error_code;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "ut_holepunch";
    }

    @Override
    public byte[] getIDBytes() {
        return ID_UT_HOLEPUNCH_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 5;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return "ut_holepunchtype=" + this.message_type + ", address=" + this.address + ", port=" + this.port + (this.error_code == ERR_NONE ? "" : ", error=" + this.error_code);
    }

    public int getMessageType() {
        return this.message_type;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getErrorCode() {
        return this.error_code;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            boolean v4 = this.address instanceof Inet4Address;
            this.buffer = DirectByteBufferPool.getBuffer((byte)40, 2 + (v4 ? 4 : 16) + 2 + 4);
            this.buffer.put((byte)11, this.message_type);
            this.buffer.put((byte)11, (byte)(!v4 ? 1 : 0));
            this.buffer.put((byte)11, this.address.getAddress());
            this.buffer.putShort((byte)11, (short)this.port);
            if (this.message_type == MT_ERROR) {
                this.buffer.putInt((byte)11, this.error_code);
            }
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        try {
            byte message_type = data.get((byte)11);
            byte address_type = data.get((byte)11);
            byte[] address_bytes = new byte[address_type == 0 ? 4 : 16];
            data.get((byte)11, address_bytes);
            InetAddress address = InetAddress.getByAddress(address_bytes);
            int port = data.getShort((byte)11) & 0xFFFF;
            int error_code = message_type == MT_ERROR ? data.getInt((byte)11) : 0;
            data.returnToPool();
            return new UTHolePunch(message_type, address, port, error_code, version);
        }
        catch (UnknownHostException e) {
            throw new MessageException("invalid address", e);
        }
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

