/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.peerdb;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerDescriptor;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.util.MapUtils;
import java.util.HashMap;
import java.util.Map;

public class PeerItemFactory {
    public static final byte PEER_SOURCE_TRACKER = 0;
    public static final byte PEER_SOURCE_DHT = 1;
    public static final byte PEER_SOURCE_PEER_EXCHANGE = 2;
    public static final byte PEER_SOURCE_PLUGIN = 3;
    public static final byte PEER_SOURCE_INCOMING = 4;
    public static final byte PEER_SOURCE_HOLE_PUNCH = 5;
    public static final byte HANDSHAKE_TYPE_PLAIN = 0;
    public static final byte HANDSHAKE_TYPE_CRYPTO = 1;
    public static final byte CRYPTO_LEVEL_1 = 1;
    public static final byte CRYPTO_LEVEL_2 = 2;
    public static final byte CRYPTO_LEVEL_CURRENT = 2;

    public static void initialise() {
        DataSourceResolver.registerExporter(new DataSourceImporter());
    }

    public static PeerItem createPeerItem(String address, int tcp_port, byte source, byte handshake_type, int udp_port, byte crypto_level, int up_speed) {
        return new PeerItem(address, tcp_port, source, handshake_type, udp_port, crypto_level, up_speed);
    }

    public static PeerItem createPeerItem(byte[] serialization, byte source, byte handshake_type, int udp_port, String network) throws Exception {
        return new PeerItem(serialization, source, handshake_type, udp_port, network);
    }

    public static PeerDescriptor getDescriptor(PEPeer peer) {
        return new PeerDescriptorImpl(peer);
    }

    public static PeerDescriptor getDescriptor(Peer peer) {
        PEPeer pe_peer = PluginCoreUtils.unwrap(peer);
        if (pe_peer != null) {
            return PeerItemFactory.getDescriptor(pe_peer);
        }
        return new PeerDescriptorImpl(peer);
    }

    public static class DataSourceImporter
    implements DataSourceResolver.DataSourceImporter {
        @Override
        public Object importDataSource(Map<String, Object> map) {
            return new PeerDescriptorImpl(map);
        }
    }

    private static class PeerDescriptorImpl
    implements PeerDescriptor {
        private final String ip;
        private final int tcp_port;
        private final int udp_port;
        private final boolean use_crypto;
        private final String peer_source;

        private PeerDescriptorImpl(Peer peer) {
            this.ip = peer.getIp();
            this.tcp_port = peer.getPort();
            this.udp_port = 0;
            this.use_crypto = false;
            this.peer_source = "Plugin";
        }

        private PeerDescriptorImpl(PEPeer peer) {
            this.ip = peer.getIp();
            this.tcp_port = peer.getPort();
            this.udp_port = peer.getUDPListenPort();
            boolean uc = false;
            try {
                uc = peer.getPluginConnection().getTransport().isEncrypted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.use_crypto = uc;
            this.peer_source = peer.getPeerSource();
        }

        private PeerDescriptorImpl(Map<String, Object> map) {
            this.ip = MapUtils.getMapString(map, "ip", "");
            this.tcp_port = MapUtils.getMapInt(map, "tcp", 0);
            this.udp_port = MapUtils.getMapInt(map, "udp", 0);
            this.use_crypto = MapUtils.getMapBoolean(map, "crypto", false);
            this.peer_source = MapUtils.getMapString(map, "ps", "");
        }

        @Override
        public String getIP() {
            return this.ip;
        }

        @Override
        public int getTCPPort() {
            return this.tcp_port;
        }

        @Override
        public int getUDPPort() {
            return this.udp_port;
        }

        @Override
        public boolean useCrypto() {
            return this.use_crypto;
        }

        @Override
        public String getPeerSource() {
            return this.peer_source;
        }

        private Map<String, Object> export() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ip", this.ip);
            result.put("tcp", this.tcp_port);
            result.put("udp", this.udp_port);
            result.put("crypto", this.use_crypto ? 1 : 0);
            result.put("ps", this.peer_source);
            return result;
        }

        @Override
        public DataSourceResolver.ExportedDataSource exportDataSource() {
            final Map<String, Object> map = this.export();
            return new DataSourceResolver.ExportedDataSource(){

                public Class<? extends DataSourceImporter> getExporter() {
                    return DataSourceImporter.class;
                }

                @Override
                public Map<String, Object> getExport() {
                    return map;
                }
            };
        }
    }
}

