/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.piecepicker.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerListenerAdapter;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peer.impl.PEPeerControl;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.impl.PEPieceImpl;
import com.biglybt.core.peermanager.control.PeerControlScheduler;
import com.biglybt.core.peermanager.control.PeerControlSchedulerFactory;
import com.biglybt.core.peermanager.control.SpeedTokenDispenser;
import com.biglybt.core.peermanager.piecepicker.EndGameModeChunk;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.PiecePickerListener;
import com.biglybt.core.peermanager.piecepicker.PiecePriorityProvider;
import com.biglybt.core.peermanager.piecepicker.PieceRTAProvider;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

public class PiecePickerImpl
implements PiecePicker {
    private static final boolean LOG_RTA = false;
    private static final boolean EGM_IS_BLOCK_BASED = true;
    private static final LogIDs LOGID = LogIDs.PIECES;
    private static final long TIME_MIN_AVAILABILITY = 974L;
    private static final long TIME_MIN_FILE_AVAILABILITY = 5000L;
    private static final long TIME_MIN_PRIORITIES = 999L;
    private static final long TIME_AVAIL_REBUILD = 299976L;
    private static final int PRIORITY_W_FIRSTLAST = 999;
    private static final long FIRST_PIECE_MIN_NB = 4L;
    private static final int PRIORITY_W_FILE_BASE = 1000;
    private static final int PRIORITY_W_FILE_RANGE = 1000;
    private static final int PRIORITY_W_COMPLETION = 2000;
    private static final int PRIORITY_W_AGE = 900;
    private static final int PRIORITY_DW_AGE = 60000;
    private static final int PRIORITY_DW_STALE = 120000;
    private static final int PRIORITY_W_PIECE_DONE = 900;
    private static final int PRIORITY_W_SAME_PIECE = 700;
    private static final int PRIORITY_OVERRIDES_RAREST = 9000;
    private static final int PRIORITY_REQUEST_HINT = 3000;
    private static final int PRIORITY_SEQUENTIAL_START = 100000;
    private static final int PRIORITY_REALTIME = 9999999;
    private static final int PRIORITY_FORCED = 1000000;
    private static final int REQUESTS_MIN_MIN = 2;
    private static final int REQUESTS_MIN_MAX = 8;
    private static final int REQUESTS_MAX = 512;
    private static final int SLOPE_REQUESTS = 4096;
    private static final long RTA_END_GAME_MODE_SIZE_TRIGGER = 262144L;
    private static final long END_GAME_MODE_RESERVED_TRIGGER = 0x500000L;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long RTA_END_GAME_MODE_SIZE_TRIGGER_BLOCKS = 16L;
    private static final long END_GAME_MODE_RESERVED_TRIGGER_BLOCKS = 320L;
    private static final long END_GAME_MODE_SIZE_TRIGGER_BLOCKS = 1280L;
    private static final long END_GAME_MODE_TIMEOUT = 120000L;
    private static final int NO_REQUEST_BACKOFF_MAX_MILLIS = 5000;
    private static final int NO_REQUEST_BACKOFF_MAX_LOOPS = 5000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
    static final Random random = new Random();
    private final DiskManager diskManager;
    private final PEPeerControl peerControl;
    private final DiskManagerListenerImpl diskManagerListener;
    protected final Map peerListeners;
    private final PEPeerManagerListener peerManagerListener;
    private final int nbPieces;
    private final DiskManagerPiece[] dmPieces;
    private final PEPiece[] pePieces;
    private final int pieceSize;
    private final List<PEPiece> rarestStartedPieces;
    protected final AEMonitor availabilityMon = new AEMonitor("PiecePicker:avail");
    private final Object endGameModeChunkLock = new Object();
    protected volatile int nbPiecesDone;
    protected volatile int[] availabilityAsynch;
    protected volatile long availabilityDrift;
    private long timeAvailRebuild = 299976L;
    protected volatile int[] availability;
    private long time_last_avail;
    protected volatile long availabilityChange;
    private volatile long availabilityComputeChange;
    private long time_last_rebuild;
    private long timeAvailLessThanOne;
    private float globalAvail;
    private float globalAvgAvail;
    private int nbRarestActive;
    private int globalMin;
    private int globalMax;
    private long bytesUnavailable;
    private volatile int globalMinOthers;
    protected volatile long filePriorityChange;
    protected volatile int sequentialDownload = 0;
    private volatile long priorityParamChange;
    private volatile long priorityFileChange;
    private volatile long priorityAvailChange;
    private boolean priorityRTAexists;
    private long timeLastPriorities;
    private int[] startPriorities;
    protected volatile boolean hasNeededUndonePiece;
    protected volatile long neededUndonePieceChange;
    private volatile boolean endGameMode;
    private volatile boolean endGameModeAbandoned;
    private volatile long timeEndGameModeEntered;
    private LinkedList<EndGameModeChunk> endGameModeChunks;
    private Map<Long, EndGameModeChunk> endGameModeChunkMap;
    private long lastProviderRecalcTime;
    private final CopyOnWriteList rta_providers = new CopyOnWriteList();
    private long[] provider_piece_rtas;
    private final CopyOnWriteList priority_providers = new CopyOnWriteList();
    private long[] provider_piece_priorities;
    private int allocate_request_loop_count;
    private int max_file_priority;
    private int min_file_priority;
    private boolean reverse_block_order;
    private int[] global_request_hint;
    private static boolean enable_request_hints;
    private static boolean includeLanPeersInReqLimiting;
    private final CopyOnWriteList<PiecePickerListener> listeners = new CopyOnWriteList();
    private volatile float[] fileAvailabilities;
    private volatile long fileAvailabilitiesCalcTime;
    private volatile CopyOnWriteSet<Integer> forced_pieces;
    protected static volatile boolean firstPiecePriority;
    protected static volatile long firstPriorityBytes;
    protected static volatile boolean firstPiecePriorityForce;
    protected static volatile boolean completionPriority;
    protected static volatile long paramPriorityChange;
    private final SpeedTokenDispenser dispenser = PeerControlSchedulerFactory.getSingleton(0).getSpeedTokenDispenser();

    static {
        paramPriorityChange = Long.MIN_VALUE;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Prioritize Most Completed Files", "Prioritize First Piece", "Prioritize First MB", "Prioritize First Piece Force"}, n -> {
            long MB = DisplayFormatters.getMinB();
            completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files");
            firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece");
            firstPriorityBytes = (long)COConfigurationManager.getIntParameter("Prioritize First MB") * MB;
            firstPiecePriorityForce = COConfigurationManager.getBooleanParameter("Prioritize First Piece Force");
            ++paramPriorityChange;
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Piece Picker Request Hint Enabled", "LAN Speed Enabled"}, n -> {
            enable_request_hints = COConfigurationManager.getBooleanParameter("Piece Picker Request Hint Enabled");
            includeLanPeersInReqLimiting = !COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
        });
    }

    public PiecePickerImpl(PEPeerControl pc) {
        this.peerControl = pc;
        this.diskManager = this.peerControl.getDiskManager();
        this.dmPieces = this.diskManager.getPieces();
        this.nbPieces = this.diskManager.getNbPieces();
        this.pieceSize = this.diskManager.getPieceLength();
        this.nbPiecesDone = 0;
        this.pePieces = pc.getPieces();
        this.availability = new int[this.nbPieces];
        this.hasNeededUndonePiece = false;
        this.neededUndonePieceChange = Long.MIN_VALUE;
        this.time_last_avail = Long.MIN_VALUE;
        this.availabilityChange = -9223372036854775807L;
        this.availabilityComputeChange = Long.MIN_VALUE;
        this.availabilityDrift = this.nbPieces;
        int i = 0;
        while (i < this.nbPieces) {
            if (this.dmPieces[i].isDone()) {
                int n = i;
                this.availability[n] = this.availability[n] + 1;
                ++this.nbPiecesDone;
            } else {
                this.hasNeededUndonePiece |= this.dmPieces[i].calcNeeded();
            }
            ++i;
        }
        if (this.hasNeededUndonePiece) {
            ++this.neededUndonePieceChange;
        }
        this.updateAvailability();
        this.peerListeners = new HashMap();
        this.peerManagerListener = new PEPeerManagerListenerImpl();
        this.peerControl.addListener(this.peerManagerListener);
        this.rarestStartedPieces = new ArrayList<PEPiece>();
        this.filePriorityChange = Long.MIN_VALUE;
        this.priorityParamChange = Long.MIN_VALUE;
        this.priorityFileChange = Long.MIN_VALUE;
        this.priorityAvailChange = Long.MIN_VALUE;
        this.timeLastPriorities = Long.MIN_VALUE;
        this.endGameMode = false;
        this.endGameModeAbandoned = false;
        this.timeEndGameModeEntered = 0L;
        this.diskManagerListener = new DiskManagerListenerImpl();
        this.syncFilePriorities();
        this.diskManager.addListener(this.diskManagerListener);
    }

    @Override
    public PEPeerManager getPeerManager() {
        return this.peerControl;
    }

    @Override
    public final void addHavePiece(PEPeer peer, int pieceNumber) {
        try {
            this.availabilityMon.enter();
            if (this.availabilityAsynch == null) {
                this.availabilityAsynch = (int[])this.availability.clone();
            }
            int n = pieceNumber;
            this.availabilityAsynch[n] = this.availabilityAsynch[n] + 1;
            ++this.availabilityChange;
        }
        finally {
            this.availabilityMon.exit();
        }
        if (peer != null && this.dmPieces[pieceNumber].isDownloadable()) {
            peer.setConsecutiveNoRequestCount(0);
        }
    }

    @Override
    public final void updateAvailability() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.time_last_avail && now < this.time_last_avail + 974L) {
            return;
        }
        if (this.availabilityDrift > 0L || now < this.time_last_rebuild || now - this.time_last_rebuild > this.timeAvailRebuild) {
            try {
                this.availabilityMon.enter();
                this.time_last_rebuild = now;
                int[] new_availability = this.recomputeAvailability();
                if (Constants.isCVSVersion()) {
                    int[] old_availability = this.availabilityAsynch == null ? this.availability : this.availabilityAsynch;
                    int errors = 0;
                    int i = 0;
                    while (i < new_availability.length) {
                        if (new_availability[i] != old_availability[i]) {
                            ++errors;
                        }
                        ++i;
                    }
                    if (errors > 0 && errors != this.nbPieces) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.peerControl, LOGID, 3, "updateAvailability(): availability rebuild errors = " + errors + " timeAvailRebuild =" + this.timeAvailRebuild));
                        }
                        this.timeAvailRebuild -= (long)errors;
                    } else {
                        ++this.timeAvailRebuild;
                    }
                }
                this.availabilityAsynch = new_availability;
                this.availabilityDrift = 0L;
                ++this.availabilityChange;
            }
            finally {
                this.availabilityMon.exit();
            }
        } else if (this.availabilityComputeChange >= this.availabilityChange) {
            return;
        }
        try {
            this.availabilityMon.enter();
            this.time_last_avail = now;
            this.availabilityComputeChange = this.availabilityChange;
            if (this.availabilityAsynch != null) {
                this.availability = this.availabilityAsynch;
                this.availabilityAsynch = null;
            }
        }
        finally {
            this.availabilityMon.exit();
        }
        int allMin = Integer.MAX_VALUE;
        int allMax = 0;
        int rarestMin = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.nbPieces) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail > 0 && avail < rarestMin && dmPiece.isDownloadable() && (pePiece == null || pePiece.isRequestable())) {
                rarestMin = avail;
            }
            if (avail < allMin) {
                allMin = avail;
            }
            if (avail > allMax) {
                allMax = avail;
            }
            ++i;
        }
        this.globalMin = allMin;
        this.globalMax = allMax;
        this.globalMinOthers = rarestMin;
        int total = 0;
        int rarestActive = 0;
        long totalAvail = 0L;
        long newBytesUnavailable = 0L;
        i = 0;
        while (i < this.nbPieces) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail > 0) {
                if (avail > allMin) {
                    ++total;
                }
                if (avail <= rarestMin && dmPiece.isDownloadable() && pePiece != null && !pePiece.isRequested()) {
                    ++rarestActive;
                }
                totalAvail += (long)avail;
            } else {
                newBytesUnavailable += (long)dmPiece.getLength();
            }
            ++i;
        }
        float newGlobalAvail = (float)total / (float)this.nbPieces + (float)allMin;
        if ((double)this.globalAvail >= 1.0 && (double)newGlobalAvail < 1.0) {
            this.timeAvailLessThanOne = now;
        } else if ((double)newGlobalAvail >= 1.0) {
            this.timeAvailLessThanOne = 0L;
        }
        this.bytesUnavailable = newBytesUnavailable;
        this.globalAvail = newGlobalAvail;
        this.nbRarestActive = rarestActive;
        this.globalAvgAvail = (float)totalAvail / (float)this.nbPieces / (float)(1 + this.peerControl.getNbSeeds() + this.peerControl.getNbPeers());
    }

    private int[] recomputeAvailability() {
        if (this.availabilityDrift > 0L && this.availabilityDrift != (long)this.nbPieces && Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this.diskManager.getTorrent(), LOGID, 0, "Recomputing availabiliy. Drift=" + this.availabilityDrift + ":" + this.peerControl.getDisplayName()));
        }
        List<PEPeer> peers = this.peerControl.getPeers();
        int[] newAvailability = new int[this.nbPieces];
        int j = 0;
        while (j < this.nbPieces) {
            newAvailability[j] = this.dmPieces[j].isDone() ? 1 : 0;
            ++j;
        }
        int peersSize = peers.size();
        int i = 0;
        while (i < peersSize) {
            BitFlags peerHavePieces;
            PEPeerTransport peer = (PEPeerTransport)peers.get(i);
            if (peer != null && peer.getPeerState() == 30 && (peerHavePieces = peer.getAvailable()) != null && peerHavePieces.nbSet > 0) {
                j = peerHavePieces.start;
                while (j <= peerHavePieces.end) {
                    if (peerHavePieces.flags[j]) {
                        int n = j;
                        newAvailability[n] = newAvailability[n] + 1;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return newAvailability;
    }

    @Override
    public int getNumberOfPieces() {
        return this.nbPieces;
    }

    @Override
    public final int[] getAvailability() {
        return this.availability;
    }

    @Override
    public final int getAvailability(int pieceNumber) {
        return this.availability[pieceNumber];
    }

    @Override
    public final float getMinAvailability() {
        return this.globalAvail;
    }

    @Override
    public float getMinAvailability(int fileIndex) {
        float[] avails = this.fileAvailabilities;
        if (avails == null) {
            DiskManagerFileInfo[] files = this.diskManager.getFiles();
            avails = new float[files.length];
        }
        if (avails.length == 1) {
            if (this.fileAvailabilities == null) {
                this.fileAvailabilities = avails;
            }
            return this.getMinAvailability();
        }
        long now = SystemTime.getMonotonousTime();
        if (this.fileAvailabilities == null || now - this.fileAvailabilitiesCalcTime > 5000L) {
            int[] current_avail = this.availability;
            if (current_avail == null) {
                return 0.0f;
            }
            DiskManagerFileInfo[] files = this.diskManager.getFiles();
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                int start = file.getFirstPieceNumber();
                int end = start + file.getNbPieces();
                int min_avail = Integer.MAX_VALUE;
                int j = start;
                while (j < end) {
                    int a = current_avail[j];
                    min_avail = Math.min(a, min_avail);
                    ++j;
                }
                int total = 0;
                int j2 = start;
                while (j2 < end) {
                    int a = current_avail[j2];
                    if (a > 0 && a > min_avail) {
                        ++total;
                    }
                    ++j2;
                }
                avails[i] = (float)total / (float)(end - start + 1) + (float)min_avail;
                ++i;
            }
            this.fileAvailabilities = avails;
            this.fileAvailabilitiesCalcTime = now;
        }
        return avails[fileIndex];
    }

    @Override
    public final long getBytesUnavailable() {
        return this.bytesUnavailable;
    }

    @Override
    public final long getAvailWentBadTime() {
        return this.timeAvailLessThanOne;
    }

    @Override
    public final int getMaxAvailability() {
        return this.globalMax;
    }

    @Override
    public final float getAvgAvail() {
        return this.globalAvgAvail;
    }

    @Override
    public int getNbPiecesDone() {
        return this.nbPiecesDone;
    }

    protected final void checkDownloadablePiece() {
        int i = 0;
        while (i < this.nbPieces) {
            if (this.dmPieces[i].isInteresting()) {
                if (!this.hasNeededUndonePiece) {
                    this.hasNeededUndonePiece = true;
                    ++this.neededUndonePieceChange;
                }
                return;
            }
            ++i;
        }
        if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void allocateRequests() {
        block32: {
            if (!this.hasNeededUndonePiece) {
                return;
            }
            ++this.allocate_request_loop_count;
            peers = this.peerControl.getPeers();
            peersSize = peers.size();
            bestUploaders = new ArrayList<PEPeerTransport>(peersSize);
            i = 0;
            while (i < peersSize) {
                peer = (PEPeerTransport)peers.get(i);
                if (peer.isDownloadPossible() && ((no_req_count = peer.getConsecutiveNoRequestCount()) == 0 || this.allocate_request_loop_count % (no_req_count + 1) == 0)) {
                    bestUploaders.add(peer);
                }
                ++i;
            }
            Collections.shuffle(bestUploaders);
            i = 0;
            while (i < 3) {
                try {
                    Collections.sort(bestUploaders, new Comparator<PEPeerTransport>(){

                        @Override
                        public int compare(PEPeerTransport pt1, PEPeerTransport pt2) {
                            if (pt1 == pt2) {
                                return 0;
                            }
                            PEPeerStats stats2 = pt2.getStats();
                            PEPeerStats stats1 = pt1.getStats();
                            int toReturn = 0;
                            if (pt1.isLANLocal() && !pt2.isLANLocal()) {
                                toReturn = -1;
                            } else if (!pt1.isLANLocal() && pt2.isLANLocal()) {
                                toReturn = 1;
                            }
                            if (toReturn == 0) {
                                toReturn = (int)(stats2.getSmoothDataReceiveRate() - stats1.getSmoothDataReceiveRate());
                            }
                            if (!(toReturn != 0 || pt2.isChokedByMe() && pt1.isChokedByMe())) {
                                toReturn = (int)(stats2.getDataSendRate() - stats1.getDataSendRate());
                            }
                            if (toReturn == 0 && pt2.isSnubbed() && !pt1.isSnubbed()) {
                                toReturn = -1;
                            }
                            if (toReturn == 0 && !pt2.isSnubbed() && pt1.isSnubbed()) {
                                toReturn = 1;
                            }
                            if (toReturn == 0 && stats2.getTotalDataBytesReceived() == 0L && stats1.getTotalDataBytesReceived() > 0L) {
                                toReturn = 1;
                            }
                            if (toReturn == 0 && stats1.getTotalDataBytesReceived() == 0L && stats2.getTotalDataBytesReceived() > 0L) {
                                toReturn = -1;
                            }
                            return toReturn;
                        }
                    });
                    break;
                }
                catch (IllegalArgumentException peer) {
                    ++i;
                }
            }
            uploadersSize = bestUploaders.size();
            if (uploadersSize == 0) {
                return;
            }
            done_priorities = false;
            if (!this.priorityRTAexists) ** GOTO lbl51
            REQUESTS_MIN = 2;
            peer_randomiser = new Map[1];
            block_time_order_peers_metrics = new HashMap<K, V>(uploadersSize);
            block_time_order_peers = new TreeSet<PEPeerTransport>(new Comparator(){

                public int compare(Object arg1, Object arg2) {
                    int result;
                    Integer m2;
                    if (arg1 == arg2) {
                        return 0;
                    }
                    PEPeerTransport pt1 = (PEPeerTransport)arg1;
                    PEPeerTransport pt2 = (PEPeerTransport)arg2;
                    Integer m1 = (Integer)block_time_order_peers_metrics.get(pt1);
                    if (m1 == null) {
                        m1 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pt1));
                        block_time_order_peers_metrics.put(pt1, m1);
                    }
                    if ((m2 = (Integer)block_time_order_peers_metrics.get(pt2)) == null) {
                        m2 = new Integer(PiecePickerImpl.this.getNextBlockETAFromNow(pt2));
                        block_time_order_peers_metrics.put(pt2, m2);
                    }
                    if ((result = m1 - m2) == 0) {
                        Integer r_2;
                        Integer r_1;
                        LightHashMap pr = peer_randomiser[0];
                        if (pr == null) {
                            pr = peer_randomiser[0] = new LightHashMap(bestUploaders.size());
                        }
                        if ((r_1 = (Integer)pr.get(pt1)) == null) {
                            r_1 = new Integer(random.nextInt());
                            pr.put(pt1, r_1);
                        }
                        if ((r_2 = (Integer)pr.get(pt2)) == null) {
                            r_2 = new Integer(random.nextInt());
                            pr.put(pt2, r_2);
                        }
                        if ((result = r_1 - r_2) == 0 && (result = pt1.hashCode() - pt2.hashCode()) == 0) {
                            result = 1;
                        }
                    }
                    return result;
                }
            });
            block_time_order_peers.addAll(bestUploaders);
            best_uploader = (PEPeerTransport)bestUploaders.get(0);
            best_block_eta = SystemTime.getCurrentTime() + (long)this.getNextBlockETAFromNow(best_uploader);
            allocated_request = true;
            allocations_started = new HashSet<PEPeerTransport>();
            while (true) {
                block34: {
                    if (!allocated_request) break block34;
                    if (!this.priorityRTAexists) {
                    }
                    allocated_request = false;
                    if (true) ** GOTO lbl79
                }
                break;
            }
            finally {
                it = allocations_started.iterator();
                if (true) ** GOTO lbl83
            }
lbl51:
            // 1 sources

            required_blocks = (int)(this.diskManager.getRemainingExcludingDND() / 16384L);
            blocks_per_uploader = required_blocks / uploadersSize;
            REQUESTS_MIN = Math.max(2, Math.min(8, blocks_per_uploader / 2));
            break block32;
            do {
                block35: {
                    it = block_time_order_peers.iterator();
                    pt = (PEPeerTransport)it.next();
                    it.remove();
                    if (!pt.isDownloadPossible() || pt.isSnubbed()) continue;
                    maxRequests = REQUESTS_MIN + (int)(pt.getStats().getDataReceiveRate() / 4096L) + 1;
                    if (maxRequests > 512 || maxRequests < 0) {
                        maxRequests = 512;
                    }
                    if ((allowed_requests = maxRequests - (currentRequests = pt.getNbRequests())) <= 0) continue;
                    if (done_priorities) break block35;
                    done_priorities = true;
                    this.computeBasePriorities();
                    if (!this.priorityRTAexists) ** GOTO lbl-1000
                }
                if (!allocations_started.contains(pt)) {
                    pt.requestAllocationStarts(this.startPriorities);
                    allocations_started.add(pt);
                }
                if (!this.findRTAPieceToDownload(pt, pt == best_uploader, best_block_eta) || allowed_requests <= 1) continue;
                block_time_order_peers_metrics.remove(pt);
                block_time_order_peers.add(pt);
lbl79:
                // 5 sources

            } while (!block_time_order_peers.isEmpty());
            ** continue;
            do {
                ((PEPeerTransport)it.next()).requestAllocationComplete();
lbl83:
                // 2 sources

            } while (it.hasNext());
        }
        this.checkEndGameMode();
        i = 0;
        while (i < uploadersSize) {
            block36: {
                block38: {
                    block39: {
                        block37: {
                            pt = (PEPeerTransport)bestUploaders.get(i);
                            if (this.dispenser.peek(16384) < 1) {
                                if (pt.isLANLocal() == false) return;
                                if (PiecePickerImpl.includeLanPeersInReqLimiting) {
                                    return;
                                }
                            }
                            if (!pt.isDownloadPossible()) break block36;
                            peer_request_num = pt.getMaxNbRequests();
                            if (peer_request_num == -1) break block37;
                            maxRequests = peer_request_num;
                            break block38;
                        }
                        if (pt.isSnubbed()) break block39;
                        if (!this.endGameMode) {
                            peer_requests_min = pt.getUnchokedForMillis() < 10000L ? REQUESTS_MIN : 2;
                            maxRequests = peer_requests_min + (int)(pt.getStats().getDataReceiveRate() / 4096L);
                            if (maxRequests > 512 || maxRequests < 0) {
                                maxRequests = 512;
                            }
                            break block38;
                        } else {
                            maxRequests = 2;
                        }
                        break block38;
                    }
                    v0 = maxRequests = pt.getNetwork() == "Public" ? 1 : 2;
                }
                if (pt.getNbRequests() <= maxRequests * 3 / 5) {
                    if (!done_priorities) {
                        done_priorities = true;
                        this.computeBasePriorities();
                    }
                    total_allocated = 0;
                    try {
                        peer_managing_requests = pt.requestAllocationStarts(this.startPriorities);
                        while (pt.isDownloadPossible() && pt.getNbRequests() < maxRequests) {
                            allocated = peer_managing_requests != false || this.endGameMode == false ? this.findPieceToDownload(pt, maxRequests) : this.findPieceInEndGameMode(pt, maxRequests);
                            if (allocated != 0) {
                                total_allocated += allocated;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        pt.requestAllocationComplete();
                    }
                    if (total_allocated == 0) {
                        no_req_count = pt.getConsecutiveNoRequestCount();
                        if (no_req_count < PiecePickerImpl.NO_REQUEST_BACKOFF_MAX_LOOPS) {
                            pt.setConsecutiveNoRequestCount(no_req_count + 1);
                        }
                    } else {
                        pt.setConsecutiveNoRequestCount(0);
                    }
                }
            }
            ++i;
        }
    }

    protected int getNextBlockETAFromNow(PEPeerTransport pt) {
        long upRate = pt.getStats().getDataReceiveRate();
        if (upRate < 1L) {
            upRate = 1L;
        }
        int next_block_bytes = (pt.getNbRequests() + 1) * 16384;
        return (int)((long)(next_block_bytes * 1000) / upRate);
    }

    private int calcRarestAllowed() {
        int RarestAllowed = 1;
        if (this.globalMinOthers < 20) {
            RarestAllowed = 2;
        }
        if (this.globalMinOthers < 8) {
            RarestAllowed = 3;
        }
        if (this.globalMinOthers < 4) {
            RarestAllowed = 4;
        }
        if (this.nbPiecesDone < 4) {
            RarestAllowed = 0;
        }
        if (SystemTime.getCurrentTime() - this.peerControl.getTimeStarted(false) < 180000L) {
            RarestAllowed = 0;
        }
        if (this.rarestStartedPieces.size() > RarestAllowed + 2) {
            RarestAllowed = 0;
        }
        int i = 0;
        while (i < this.rarestStartedPieces.size()) {
            PEPiece rarestStarted = this.rarestStartedPieces.get(i);
            if (this.pePieces[rarestStarted.getPieceNumber()] == null) {
                this.rarestStartedPieces.remove(i);
                --i;
            } else if (!(rarestStarted.getAvailability() > this.globalMinOthers && this.globalMinOthers <= this.globalMin || SystemTime.getCurrentTime() - rarestStarted.getLastDownloadTime(SystemTime.getCurrentTime()) >= 60000L && rarestStarted.getNbWritten() != 0 || rarestStarted.isDownloaded())) {
                --RarestAllowed;
            }
            ++i;
        }
        return RarestAllowed;
    }

    private void syncFilePriorities() {
        DiskManagerFileInfo[] files = this.diskManager.getFiles();
        int max = 0;
        int min = 0;
        DiskManagerFileInfo[] diskManagerFileInfoArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            int p = file.getPriority();
            if (p > max) {
                max = p;
            } else if (p < min) {
                min = p;
            }
            ++n2;
        }
        this.max_file_priority = max;
        this.min_file_priority = min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeBasePriorities() {
        long now = SystemTime.getCurrentTime();
        if (now < this.lastProviderRecalcTime || now - this.lastProviderRecalcTime > 1000L) {
            this.lastProviderRecalcTime = now;
            this.priorityRTAexists = this.computeProviderPriorities();
        }
        if (!this.priorityRTAexists && this.startPriorities != null && (now > this.timeLastPriorities && now < this.timeLastPriorities + 999L || this.priorityParamChange >= paramPriorityChange && this.priorityFileChange >= this.filePriorityChange && this.priorityAvailChange >= this.availabilityChange)) {
            return;
        }
        this.timeLastPriorities = now;
        this.priorityParamChange = paramPriorityChange;
        this.priorityFileChange = this.filePriorityChange;
        this.priorityAvailChange = this.availabilityChange;
        boolean foundPieceToDownload = false;
        int[] newPriorities = new int[this.nbPieces];
        boolean firstPiecePriorityL = firstPiecePriority;
        boolean firstPiecePriorityForceL = firstPiecePriorityForce;
        boolean completionPriorityL = completionPriority;
        DMPieceMap pieceMap = this.diskManager.getPieceMap();
        int priorityPieces = firstPriorityBytes > 0L ? (int)((firstPriorityBytes + (long)this.pieceSize - 1L) / (long)this.pieceSize) : 1;
        CopyOnWriteSet<Integer> forced = this.forced_pieces;
        try {
            boolean rarestOverride = this.calcRarestAllowed() < 1;
            int nbConnects = this.peerControl.getNbPeers() + this.peerControl.getNbSeeds();
            int i = 0;
            while (i < this.nbPieces) {
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (dmPiece.isDone()) {
                    if (forced != null && forced.contains(i) && forced.remove(i) && forced.size() == 0) {
                        PiecePickerImpl piecePickerImpl = this;
                        synchronized (piecePickerImpl) {
                            if (this.forced_pieces != null && this.forced_pieces.size() == 0) {
                                this.forced_pieces = null;
                            }
                        }
                    }
                } else {
                    int startPriority = Integer.MIN_VALUE;
                    DMPieceList pieceList2 = pieceMap.getPieceList(dmPiece.getPieceNumber());
                    int pieceListSize = pieceList2.size();
                    boolean pieceHasFirstLastPriority = false;
                    int j = 0;
                    while (j < pieceListSize) {
                        DiskManagerFileInfo fileInfo2 = pieceList2.get(j).getFile();
                        long downloaded = fileInfo2.getDownloaded();
                        long length = fileInfo2.getLength();
                        if (length > 0L && downloaded < length && !fileInfo2.isSkipped()) {
                            long percent;
                            int min;
                            int file_priority;
                            int max;
                            int range;
                            int priority = 0;
                            boolean hasFirstLastPriority = false;
                            int flpOffset = 0;
                            int nbPieces = fileInfo2.getNbPieces();
                            if (firstPiecePriorityL && (long)nbPieces > 4L) {
                                if (priorityPieces > 1) {
                                    int fp = fileInfo2.getFirstPieceNumber();
                                    int lp = fileInfo2.getLastPieceNumber();
                                    int pp = Math.min(nbPieces, priorityPieces);
                                    if (i >= fp && i < fp + pp) {
                                        hasFirstLastPriority = true;
                                        pieceHasFirstLastPriority = true;
                                        flpOffset = fp - i;
                                    } else if (i <= lp && i > lp - pp) {
                                        hasFirstLastPriority = true;
                                        pieceHasFirstLastPriority = true;
                                        flpOffset = i - lp;
                                    }
                                } else if (i == fileInfo2.getFirstPieceNumber() || i == fileInfo2.getLastPieceNumber()) {
                                    hasFirstLastPriority = true;
                                    pieceHasFirstLastPriority = true;
                                }
                            }
                            if ((range = (max = Math.max(file_priority = fileInfo2.getPriority(), this.max_file_priority)) - (min = Math.min(file_priority, this.min_file_priority))) > 0) {
                                int adjustment;
                                int relative_file_priority = file_priority - min;
                                priority += 1000;
                                if (hasFirstLastPriority) {
                                    adjustment = 1000 * (relative_file_priority + 1) / range - 1;
                                    adjustment += flpOffset;
                                } else {
                                    adjustment = 1000 * relative_file_priority / range;
                                }
                                priority += adjustment;
                            } else if (hasFirstLastPriority) {
                                priority += 999 + flpOffset;
                            }
                            if (completionPriorityL && (percent = 1000L * downloaded / length) >= 900L) {
                                priority = (int)((long)priority + 2000L * downloaded / this.diskManager.getTotalLength());
                            }
                            if (priority > startPriority) {
                                startPriority = priority;
                            }
                        }
                        ++j;
                    }
                    if (startPriority >= 0) {
                        if (pieceHasFirstLastPriority && firstPiecePriorityForceL) {
                            startPriority += 1000000;
                        }
                        dmPiece.setNeeded();
                        foundPieceToDownload = true;
                        int avail = this.availability[i];
                        if (avail > 0 && nbConnects > avail) {
                            startPriority += nbConnects - avail;
                            if (!rarestOverride && avail <= this.globalMinOthers) {
                                startPriority += nbConnects / avail;
                            }
                        }
                        if (this.provider_piece_rtas != null) {
                            if (this.provider_piece_rtas[i] > 0L) {
                                startPriority = 9999999;
                            }
                        } else if (this.provider_piece_priorities != null) {
                            startPriority = (int)((long)startPriority + this.provider_piece_priorities[i]);
                        } else if (forced != null && forced.contains(i)) {
                            startPriority += 1000000;
                        }
                    } else {
                        dmPiece.clearNeeded();
                    }
                    newPriorities[i] = startPriority;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.sequentialDownload != 0 && !this.priorityRTAexists) {
            int loop_dir;
            int loop_end;
            int loop_start;
            int seq_pri = 100000;
            boolean do_file_priorities = this.min_file_priority != this.max_file_priority;
            int file_priority_start = this.nbPieces * 10;
            if (this.sequentialDownload > 0) {
                loop_start = this.nbPieces;
                loop_end = this.sequentialDownload - 1;
                loop_dir = -1;
            } else {
                loop_start = -1;
                loop_end = -(this.sequentialDownload + 1);
                loop_dir = 1;
            }
            int loop_pos = loop_start;
            do {
                int priority;
                if ((priority = newPriorities[loop_pos += loop_dir]) == Integer.MIN_VALUE) continue;
                if (priority < 1000000) {
                    if (do_file_priorities) {
                        DiskManagerPiece dmPiece = this.dmPieces[loop_pos];
                        int highest = Integer.MIN_VALUE;
                        DMPieceList pieceList3 = pieceMap.getPieceList(dmPiece.getPieceNumber());
                        int pieceListSize = pieceList3.size();
                        int j = 0;
                        while (j < pieceListSize) {
                            DiskManagerFileInfo fileInfo3 = pieceList3.get(j).getFile();
                            long downloaded = fileInfo3.getDownloaded();
                            long length = fileInfo3.getLength();
                            if (length > 0L && downloaded < length && !fileInfo3.isSkipped()) {
                                highest = Math.max(highest, fileInfo3.getPriority());
                            }
                            ++j;
                        }
                        if (highest == Integer.MIN_VALUE) {
                            newPriorities[loop_pos] = seq_pri;
                        } else {
                            int rel = highest - this.min_file_priority;
                            newPriorities[loop_pos] = file_priority_start + this.nbPieces * rel + seq_pri;
                        }
                    } else {
                        newPriorities[loop_pos] = seq_pri;
                    }
                }
                seq_pri += 10;
            } while (loop_pos != loop_end);
        }
        if (foundPieceToDownload != this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = foundPieceToDownload;
            ++this.neededUndonePieceChange;
        }
        this.startPriorities = newPriorities;
    }

    protected final int findPieceToDownload(PEPeerTransport pt, int nbWanted) {
        PEPiece pePiece;
        int pieceNumber = this.getRequestCandidate(pt);
        if (pieceNumber < 0) {
            return 0;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        if (peerSpeed < 0) {
            peerSpeed = 0;
        }
        if (pt.isSnubbed()) {
            peerSpeed = 0;
        }
        if (this.pePieces[pieceNumber] != null) {
            pePiece = this.pePieces[pieceNumber];
        } else {
            int[] peer_priority_offsets = pt.getPriorityOffsets();
            int this_offset = peer_priority_offsets == null ? 0 : peer_priority_offsets[pieceNumber];
            pePiece = new PEPieceImpl(this, this.dmPieces[pieceNumber], peerSpeed >> 1);
            this.peerControl.addPiece(pePiece, pieceNumber, pt);
            if (this.startPriorities != null) {
                pePiece.setResumePriority(this.startPriorities[pieceNumber] + this_offset);
            } else {
                pePiece.setResumePriority(this_offset);
            }
            if (this.availability[pieceNumber] <= this.globalMinOthers) {
                ++this.nbRarestActive;
            }
        }
        int[] request_hint = null;
        if (enable_request_hints) {
            request_hint = pt.getRequestHint();
            if (request_hint != null && request_hint[0] != pieceNumber) {
                request_hint = null;
            }
            if (request_hint == null && (request_hint = this.global_request_hint) != null && request_hint[0] != pieceNumber) {
                request_hint = null;
            }
        }
        if (!pt.isLANLocal() || includeLanPeersInReqLimiting) {
            nbWanted = this.dispenser.dispense(nbWanted, 16384);
        }
        int[] blocksFound = pePiece.getAndMarkBlocks(pt, nbWanted, request_hint, this.reverse_block_order);
        int blockNumber = blocksFound[0];
        int nbBlocks = blocksFound[1];
        if ((!pt.isLANLocal() || includeLanPeersInReqLimiting) && nbBlocks != nbWanted) {
            this.dispenser.returnUnusedChunks(nbWanted - nbBlocks, 16384);
        }
        if (nbBlocks <= 0) {
            return 0;
        }
        int requested = 0;
        if (this.reverse_block_order) {
            int i = nbBlocks - 1;
            while (i >= 0) {
                int thisBlock = blockNumber + i;
                DiskManagerReadRequest request2 = pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock), true);
                if (request2 != null) {
                    this.peerControl.requestAdded(pePiece, pt, request2);
                    ++requested;
                    pt.setLastPiece(pieceNumber);
                    pePiece.setLastRequestedPeerSpeed(peerSpeed);
                } else {
                    pePiece.clearRequested(thisBlock);
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < nbBlocks) {
                int thisBlock = blockNumber + i;
                DiskManagerReadRequest request3 = pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock), true);
                if (request3 != null) {
                    this.peerControl.requestAdded(pePiece, pt, request3);
                    ++requested;
                    pt.setLastPiece(pieceNumber);
                    pePiece.setLastRequestedPeerSpeed(peerSpeed);
                } else {
                    pePiece.clearRequested(thisBlock);
                }
                ++i;
            }
        }
        if (requested > 0 && pePiece.getAvailability() <= this.globalMinOthers && this.calcRarestAllowed() > 0 && !this.rarestStartedPieces.contains(pePiece)) {
            this.rarestStartedPieces.add(pePiece);
        }
        return requested;
    }

    protected final boolean findRTAPieceToDownload(PEPeerTransport pt, boolean best_uploader, long best_uploader_next_block_eta) {
        block24: {
            block25: {
                block26: {
                    RealTimeData rtd;
                    if (pt == null || pt.getPeerState() != 30) {
                        return false;
                    }
                    BitFlags peerHavePieces = pt.getAvailable();
                    if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                        return false;
                    }
                    Object rta_log_str = null;
                    int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1024;
                    int startI = peerHavePieces.start;
                    int endI = peerHavePieces.end;
                    int piece_min_rta_index = -1;
                    int piece_min_rta_block = 0;
                    long piece_min_rta_time = Long.MAX_VALUE;
                    long now = SystemTime.getCurrentTime();
                    long my_next_block_eta = now + (long)this.getNextBlockETAFromNow(pt);
                    int i = startI;
                    while (i <= endI) {
                        PEPiece pePiece;
                        DiskManagerPiece dmPiece;
                        long piece_rta = this.provider_piece_rtas[i];
                        if (peerHavePieces.flags[i] && this.startPriorities[i] == 9999999 && piece_rta > 0L && (dmPiece = this.dmPieces[i]).isDownloadable() && ((pePiece = this.pePieces[i]) == null || !pePiece.isDownloaded())) {
                            boolean try_allocate_even_though_late;
                            Object realtime_data = null;
                            boolean bl = try_allocate_even_though_late = my_next_block_eta > piece_rta && best_uploader_next_block_eta > piece_rta;
                            if (piece_rta < piece_min_rta_time && (my_next_block_eta <= piece_rta || best_uploader || best_uploader_next_block_eta > piece_rta)) {
                                if (pePiece == null || (realtime_data = pePiece.getRealTimeData()) == null) {
                                    piece_min_rta_time = piece_rta;
                                    piece_min_rta_index = i;
                                    piece_min_rta_block = 0;
                                } else {
                                    RealTimeData rtd2 = (RealTimeData)realtime_data;
                                    List[] peer_requests = rtd2.getRequests();
                                    int j = 0;
                                    while (j < peer_requests.length) {
                                        if (!pePiece.isDownloaded(j) && !pePiece.isWritten(j)) {
                                            List block_peer_requests = peer_requests[j];
                                            long best_eta = Long.MAX_VALUE;
                                            boolean pt_already_present = false;
                                            Iterator it = block_peer_requests.iterator();
                                            while (it.hasNext()) {
                                                RealTimePeerRequest pr = (RealTimePeerRequest)it.next();
                                                PEPeerTransport this_pt = pr.getPeer();
                                                if (this_pt.getPeerState() != 30) {
                                                    it.remove();
                                                    continue;
                                                }
                                                DiskManagerReadRequest this_request = pr.getRequest();
                                                int request_index = this_pt.getRequestIndex(this_request);
                                                if (request_index == -1) {
                                                    it.remove();
                                                    continue;
                                                }
                                                if (this_pt == pt) {
                                                    pt_already_present = true;
                                                    break;
                                                }
                                                long this_up_bps = this_pt.getStats().getDataReceiveRate();
                                                if (this_up_bps < 1L) {
                                                    this_up_bps = 1L;
                                                }
                                                int next_block_bytes = (request_index + 1) * 16384;
                                                long this_peer_eta = now + (long)(next_block_bytes * 1000) / this_up_bps;
                                                best_eta = Math.min(best_eta, this_peer_eta);
                                            }
                                            if (!pt_already_present) {
                                                if (block_peer_requests.size() == 0) {
                                                    piece_min_rta_time = piece_rta;
                                                    piece_min_rta_index = i;
                                                    piece_min_rta_block = j;
                                                    break;
                                                }
                                                if (best_eta > piece_rta && (best_uploader || !try_allocate_even_though_late) && my_next_block_eta < best_eta) {
                                                    piece_min_rta_time = piece_rta;
                                                    piece_min_rta_index = i;
                                                    piece_min_rta_block = j;
                                                    break;
                                                }
                                            }
                                        }
                                        ++j;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (piece_min_rta_index == -1) break block24;
                    if (this.dispenser.dispense(1, 16384) != 1 && (!pt.isLANLocal() || includeLanPeersInReqLimiting)) break block25;
                    PEPiece pePiece = this.pePieces[piece_min_rta_index];
                    if (pePiece == null) {
                        pePiece = new PEPieceImpl(this, this.dmPieces[piece_min_rta_index], peerSpeed >> 1);
                        this.peerControl.addPiece(pePiece, piece_min_rta_index, pt);
                        pePiece.setResumePriority(9999999);
                        if (this.availability[piece_min_rta_index] <= this.globalMinOthers) {
                            ++this.nbRarestActive;
                        }
                    }
                    if ((rtd = (RealTimeData)pePiece.getRealTimeData()) == null) {
                        rtd = new RealTimeData(pePiece);
                        pePiece.setRealTimeData(rtd);
                    }
                    pePiece.getAndMarkBlock(pt, piece_min_rta_block);
                    DiskManagerReadRequest request2 = pt.request(piece_min_rta_index, piece_min_rta_block * 16384, pePiece.getBlockSize(piece_min_rta_block), true);
                    if (request2 == null) break block26;
                    this.peerControl.requestAdded(pePiece, pt, request2);
                    List real_time_requests = rtd.getRequests()[piece_min_rta_block];
                    real_time_requests.add(new RealTimePeerRequest(pt, request2));
                    pt.setLastPiece(piece_min_rta_index);
                    pePiece.setLastRequestedPeerSpeed(peerSpeed);
                    return true;
                }
                if (!pt.isLANLocal() || includeLanPeersInReqLimiting) {
                    this.dispenser.returnUnusedChunks(1, 16384);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private int getRequestCandidate(PEPeerTransport pt) {
        int[] g_hint;
        int request_hint_piece_number;
        int reservedPieceNumber;
        if (pt == null || pt.getPeerState() != 30) {
            return -1;
        }
        BitFlags peerHavePieces = pt.getAvailable();
        if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
            return -1;
        }
        int[] reservedPieceNumbers = pt.getReservedPieceNumbers();
        if (reservedPieceNumbers != null) {
            int[] nArray = reservedPieceNumbers;
            int n = reservedPieceNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String peerReserved;
                reservedPieceNumber = nArray[n2];
                PEPiece pePiece = this.pePieces[reservedPieceNumber];
                if (pePiece != null && (peerReserved = pePiece.getReservedBy()) != null && peerReserved.equals(pt.getIp())) {
                    if (peerHavePieces.flags[reservedPieceNumber] && pePiece.isRequestable()) {
                        return reservedPieceNumber;
                    }
                    pePiece.setReservedBy(null);
                }
                pt.removeReservedPieceNumber(reservedPieceNumber);
                ++n2;
            }
        }
        reservedPieceNumber = -1;
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1024;
        int lastPiece = pt.getLastPiece();
        int nbSnubbed = this.peerControl.getNbPeersSnubbed();
        long resumeMinAvail = Long.MAX_VALUE;
        int resumeMaxPriority = Integer.MIN_VALUE;
        boolean resumeIsRarest = false;
        int secondChoiceResume = -1;
        BitFlags startCandidates = null;
        int startMaxPriority = Integer.MIN_VALUE;
        int startMinAvail = Integer.MAX_VALUE;
        boolean startIsRarest = false;
        boolean forceStart = false;
        int avail = 0;
        boolean rarestAllowed = this.calcRarestAllowed() > 0;
        int startI = peerHavePieces.start;
        int endI = peerHavePieces.end;
        int[] peerPriorities = pt.getPriorityOffsets();
        long now = SystemTime.getCurrentTime();
        int[] request_hint = pt.getRequestHint();
        if (request_hint != null) {
            request_hint_piece_number = request_hint[0];
            if (this.dmPieces[request_hint_piece_number].isDone()) {
                pt.clearRequestHint();
                request_hint_piece_number = -1;
            }
        } else {
            request_hint_piece_number = -1;
        }
        if (request_hint_piece_number == -1 && (g_hint = this.global_request_hint) != null && this.dmPieces[request_hint_piece_number = g_hint[0]].isDone()) {
            g_hint = null;
            request_hint_piece_number = -1;
        }
        CopyOnWriteSet<Integer> forced = this.forced_pieces;
        int i = startI;
        while (i <= endI) {
            block61: {
                PEPiece pePiece;
                DiskManagerPiece dmPiece;
                int priority;
                block62: {
                    if (!peerHavePieces.flags[i]) break block61;
                    priority = this.startPriorities[i];
                    dmPiece = this.dmPieces[i];
                    if (priority < 0 || !dmPiece.isDownloadable()) break block61;
                    if (peerPriorities == null) break block62;
                    int peer_priority = peerPriorities[i];
                    if (peer_priority < 0) break block61;
                    priority += peer_priority;
                }
                if (enable_request_hints && i == request_hint_piece_number) {
                    priority += 3000;
                    PEPiece pePiece2 = this.pePieces[i];
                    if (pePiece2 == null) {
                        forceStart = true;
                    } else {
                        pePiece2.setReservedBy(pt.getIp());
                        pt.addReservedPieceNumber(i);
                    }
                }
                if ((pePiece = this.pePieces[i]) == null || pePiece.isRequestable()) {
                    boolean pieceRarestOverride = priority >= 9000 ? true : rarestAllowed;
                    avail = this.availability[i];
                    if (avail == 0) {
                        this.availability[i] = 1;
                        avail = 1;
                    } else if (forced != null && forced.contains(i)) {
                        avail = this.globalMinOthers;
                    } else if (this.sequentialDownload != 0 && this.globalMinOthers > 1) {
                        avail = this.globalMinOthers;
                    }
                    if (pePiece != null) {
                        if (priority != this.startPriorities[i]) {
                            pePiece.setResumePriority(priority);
                        }
                        boolean startedRarest = this.rarestStartedPieces.contains(pePiece);
                        boolean rarestPrio = avail <= this.globalMinOthers && (startedRarest || rarestAllowed);
                        int freeReqs = pePiece.getNbUnrequested();
                        if (freeReqs <= 0) {
                            pePiece.setRequested();
                        } else {
                            String peerReserved = pePiece.getReservedBy();
                            if (peerReserved != null) {
                                if (peerReserved.equals(pt.getIp())) {
                                    pt.addReservedPieceNumber(i);
                                    return i;
                                }
                            } else {
                                int pieceSpeed = pePiece.getSpeed();
                                boolean mayResume = true;
                                if (pt.isSnubbed()) {
                                    mayResume &= pieceSpeed < 1;
                                    mayResume &= freeReqs > 2 || avail <= nbSnubbed;
                                } else {
                                    mayResume &= freeReqs * peerSpeed >= pieceSpeed / 2;
                                    mayResume &= peerSpeed < 2 || pieceSpeed > 0 || pePiece.getNbRequests() == 0;
                                    mayResume |= i == pt.getLastPiece();
                                }
                                if (secondChoiceResume == -1 || avail > this.availability[secondChoiceResume]) {
                                    secondChoiceResume = i;
                                }
                                if (mayResume && (long)avail <= resumeMinAvail) {
                                    priority += pieceSpeed;
                                    priority += i == lastPiece ? 700 : 0;
                                    priority = (int)((long)priority + pePiece.getTimeSinceLastActivity() / 120000L);
                                    long pieceAge = now - pePiece.getCreationTime();
                                    if (pieceAge > 0L) {
                                        priority = (int)((long)priority + 900L * pieceAge / (long)(60000 * dmPiece.getNbBlocks()));
                                    }
                                    pePiece.setResumePriority(priority += 900 * dmPiece.getNbWritten() / dmPiece.getNbBlocks());
                                    if (((long)avail < resumeMinAvail || (long)avail == resumeMinAvail && priority > resumeMaxPriority) && pePiece.hasUnrequestedBlock()) {
                                        reservedPieceNumber = i;
                                        resumeMinAvail = avail;
                                        resumeMaxPriority = priority;
                                        resumeMinAvail = avail;
                                        resumeIsRarest = rarestPrio;
                                    }
                                }
                            }
                        }
                    } else if (avail <= this.globalMinOthers && rarestAllowed) {
                        if (!startIsRarest) {
                            if (startCandidates == null) {
                                startCandidates = new BitFlags(this.nbPieces);
                            }
                            startMaxPriority = priority;
                            startMinAvail = avail;
                            startIsRarest = avail <= this.globalMinOthers;
                            startCandidates.setOnly(i);
                        } else if (priority > startMaxPriority) {
                            if (startCandidates == null) {
                                startCandidates = new BitFlags(this.nbPieces);
                            }
                            startMaxPriority = priority;
                            startCandidates.setOnly(i);
                        } else if (priority == startMaxPriority) {
                            startCandidates.setEnd(i);
                        }
                    } else if (!startIsRarest || !rarestAllowed) {
                        if (priority > startMaxPriority) {
                            if (startCandidates == null) {
                                startCandidates = new BitFlags(this.nbPieces);
                            }
                            startMaxPriority = priority;
                            startMinAvail = avail;
                            startIsRarest = avail <= this.globalMinOthers;
                            startCandidates.setOnly(i);
                        } else if (priority == startMaxPriority) {
                            if (startCandidates == null) {
                                startCandidates = new BitFlags(this.nbPieces);
                            }
                            if (avail < startMinAvail) {
                                startMinAvail = avail;
                                startIsRarest = avail <= this.globalMinOthers;
                                startCandidates.setOnly(i);
                            } else if (avail == startMinAvail) {
                                startCandidates.setEnd(i);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (!forceStart || startCandidates == null || startCandidates.nbSet <= 0) {
            if (!(reservedPieceNumber < 0 || !resumeIsRarest && startIsRarest && rarestAllowed && startCandidates != null && startCandidates.nbSet > 0)) {
                return reservedPieceNumber;
            }
            if (secondChoiceResume != -1 && (startCandidates == null || startCandidates.nbSet <= 0)) {
                return secondChoiceResume;
            }
            if (reservedPieceNumber >= 0 && this.globalMinOthers > 0 && this.peerControl.getNbActivePieces() > 32) {
                boolean resumeIsBetter;
                boolean bl = resumeIsBetter = (long)resumeMaxPriority / resumeMinAvail > (long)(startMaxPriority / this.globalMinOthers);
                if (Constants.isCVSVersion() && Logger.isEnabled()) {
                    Logger.log(new LogEvent(new Object[]{pt, this.peerControl}, LOGID, "Start/resume choice; piece #:" + reservedPieceNumber + " resumeIsBetter:" + resumeIsBetter + " globalMinOthers=" + this.globalMinOthers + " startMaxPriority=" + startMaxPriority + " startMinAvail=" + startMinAvail + " resumeMaxPriority=" + resumeMaxPriority + " resumeMinAvail=" + resumeMinAvail + " : " + pt));
                }
                if (resumeIsBetter) {
                    return reservedPieceNumber;
                }
            }
        }
        return this.getPieceToStart(startCandidates);
    }

    protected final int getPieceToStart(BitFlags startCandidates) {
        if (startCandidates == null || startCandidates.nbSet <= 0) {
            return -1;
        }
        if (startCandidates.nbSet == 1) {
            return startCandidates.start;
        }
        if (this.sequentialDownload != 0) {
            if (this.sequentialDownload > 0) {
                return startCandidates.start;
            }
            return startCandidates.end;
        }
        int direction = RandomUtils.generateRandomPlusMinus1();
        int startI = direction == 1 ? startCandidates.start : startCandidates.end;
        int targetNb = RandomUtils.generateRandomIntUpto(startCandidates.nbSet);
        int foundNb = -1;
        int i = startI;
        while (i <= startCandidates.end && i >= startCandidates.start) {
            if (startCandidates.flags[i] && ++foundNb >= targetNb) {
                return i;
            }
            i += direction;
        }
        return -1;
    }

    @Override
    public final boolean hasDownloadablePiece() {
        return this.hasNeededUndonePiece;
    }

    @Override
    public final long getNeededUndonePieceChange() {
        return this.neededUndonePieceChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEndGameMode() {
        if (this.peerControl.getNbSeeds() + this.peerControl.getNbPeers() < 3) {
            return;
        }
        long mono_now = SystemTime.getMonotonousTime();
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (this.endGameModeAbandoned || mono_now - this.timeEndGameModeEntered <= 120000L) return;
            this.abandonEndGameMode();
            return;
        }
        boolean use_rta_egm = this.rta_providers.size() > 0;
        long trigger_blocks = use_rta_egm ? 16L : 1280L;
        int active_blocks = 0;
        int reserved_blocks = 0;
        int i = 0;
        while (i < this.nbPieces) {
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (dmPiece.isDownloadable()) {
                PEPiece pePiece = this.pePieces[i];
                if (pePiece == null) return;
                if (!pePiece.isDownloaded()) {
                    int j;
                    boolean[] written;
                    if (!dmPiece.isNeeded()) return;
                    if (pePiece.isRequested()) {
                        written = dmPiece.getWritten();
                        if (written == null) {
                            if (!dmPiece.isDone()) {
                                active_blocks += pePiece.getNbBlocks();
                            }
                        } else {
                            j = 0;
                            while (j < written.length) {
                                if (!written[j]) {
                                    ++active_blocks;
                                }
                                ++j;
                            }
                        }
                        if ((long)active_blocks > trigger_blocks) {
                            return;
                        }
                    } else {
                        if (pePiece.getReservedBy() == null) return;
                        written = dmPiece.getWritten();
                        if (written == null) {
                            if (!dmPiece.isDone()) {
                                reserved_blocks += pePiece.getNbBlocks();
                            }
                        } else {
                            j = 0;
                            while (j < written.length) {
                                if (!written[j]) {
                                    ++reserved_blocks;
                                }
                                ++j;
                            }
                        }
                        if ((long)reserved_blocks > 320L) {
                            return;
                        }
                    }
                }
            }
            ++i;
        }
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            this.endGameModeChunks = new LinkedList();
            this.endGameModeChunkMap = new HashMap<Long, EndGameModeChunk>();
            this.timeEndGameModeEntered = mono_now;
            this.endGameMode = true;
            this.computeEndGameModeChunks();
            if (!Logger.isEnabled()) return;
            Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Entering end-game mode: " + this.peerControl.getDisplayName()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEndGameModeChunks() {
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nbPieces) {
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (dmPiece.isInteresting()) {
                    EndGameModeChunk chunk;
                    int j;
                    boolean[] written;
                    PEPiece pePiece = this.pePieces[i];
                    if (pePiece == null) {
                        pePiece = new PEPieceImpl(this, dmPiece, 0);
                        this.peerControl.addPiece(pePiece, i, null);
                    }
                    if ((written = dmPiece.getWritten()) == null) {
                        if (!dmPiece.isDone()) {
                            j = 0;
                            while (j < pePiece.getNbBlocks()) {
                                chunk = new EndGameModeChunk(pePiece, j);
                                this.endGameModeChunks.add(chunk);
                                this.endGameModeChunkMap.put(new Long((long)i << 32 | (long)j), chunk);
                                ++j;
                            }
                        }
                    } else {
                        j = 0;
                        while (j < written.length) {
                            if (!written[j]) {
                                chunk = new EndGameModeChunk(pePiece, j);
                                this.endGameModeChunks.add(chunk);
                                this.endGameModeChunkMap.put(new Long((long)i << 32 | (long)j), chunk);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (this.reverse_block_order) {
                Collections.reverse(this.endGameModeChunks);
            }
        }
    }

    @Override
    public final boolean isInEndGameMode() {
        return this.endGameMode;
    }

    @Override
    public boolean hasEndGameModeBeenAbandoned() {
        return this.endGameModeAbandoned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEndGameChunks(PEPiece pePiece) {
        if (!this.endGameMode) {
            return;
        }
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            int nbChunks = pePiece.getNbBlocks();
            int piece_number = pePiece.getPieceNumber();
            int i = 0;
            while (i < nbChunks) {
                EndGameModeChunk chunk = new EndGameModeChunk(pePiece, i);
                this.endGameModeChunks.add(chunk);
                this.endGameModeChunkMap.put(new Long((long)piece_number << 32 | (long)i), chunk);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int findPieceInEndGameMode(PEPeerTransport pt, int wants) {
        if (pt == null || wants <= 0 || pt.getPeerState() != 30) {
            return 0;
        }
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            DiskManagerReadRequest request2;
            PEPiece pePiece;
            int pieceNumber;
            EndGameModeChunk chunk;
            Iterator it = this.endGameModeChunks.iterator();
            while (true) {
                if (!it.hasNext()) {
                    if (this.endGameModeChunks.isEmpty()) {
                        this.leaveEndGameMode();
                    }
                    return 0;
                }
                chunk = (EndGameModeChunk)it.next();
                pieceNumber = chunk.getPieceNumber();
                if (this.dmPieces[pieceNumber].isWritten(chunk.getBlockNumber())) {
                    it.remove();
                    this.endGameModeChunkMap.remove(new Long((long)pieceNumber << 32 | (long)chunk.getBlockNumber()));
                    continue;
                }
                pePiece = this.pePieces[pieceNumber];
                if (pt.isPieceAvailable(pieceNumber) && pePiece != null && (!pt.isSnubbed() || this.availability[pieceNumber] <= this.peerControl.getNbPeersSnubbed()) && (request2 = pt.request(pieceNumber, chunk.getOffset(), chunk.getLength(), false)) != null) break;
            }
            this.peerControl.requestAdded(pePiece, pt, request2);
            pePiece.setRequested(pt, chunk.getBlockNumber());
            pt.setLastPiece(pieceNumber);
            chunk.requested();
            it.remove();
            this.endGameModeChunks.add(chunk);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeFromEndGameModeChunks(int pieceNumber, int offset) {
        if (!this.endGameMode) {
            return;
        }
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            Iterator iter = this.endGameModeChunks.iterator();
            while (iter.hasNext()) {
                EndGameModeChunk chunk = (EndGameModeChunk)iter.next();
                if (!chunk.equals(pieceNumber, offset)) continue;
                iter.remove();
                this.endGameModeChunkMap.remove(new Long((long)pieceNumber << 32 | (long)chunk.getBlockNumber()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearEndGameChunks() {
        if (!this.endGameMode) {
            return;
        }
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            this.endGameModeChunks.clear();
            this.endGameModeChunkMap.clear();
            this.endGameMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveEndGameMode() {
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            if (this.endGameMode) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Leaving end-game mode: " + this.peerControl.getDisplayName()));
                }
                this.endGameMode = false;
                this.endGameModeChunks.clear();
                this.endGameModeChunkMap.clear();
                this.timeEndGameModeEntered = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonEndGameMode() {
        if (!this.endGameModeAbandoned) {
            Object object = this.endGameModeChunkLock;
            synchronized (object) {
                this.endGameModeAbandoned = true;
                this.endGameMode = false;
                this.clearEndGameChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Abandoning end-game mode: " + this.peerControl.getDisplayName()));
                }
            }
        }
    }

    private boolean computeProviderPriorities() {
        List rta_ps;
        List p_ps = this.priority_providers.getList();
        if (p_ps.size() == 0) {
            if (this.provider_piece_priorities != null) {
                ++paramPriorityChange;
                this.provider_piece_priorities = null;
            }
        } else {
            ++paramPriorityChange;
            this.provider_piece_priorities = new long[this.nbPieces];
            int i = 0;
            while (i < p_ps.size()) {
                PiecePriorityProvider shaper = (PiecePriorityProvider)p_ps.get(i);
                long[] priorities = shaper.updatePriorities(this);
                if (priorities != null) {
                    int j = 0;
                    while (j < priorities.length) {
                        long priority = priorities[j];
                        if (priority != 0L) {
                            int n = j;
                            this.provider_piece_priorities[n] = this.provider_piece_priorities[n] + priority;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((rta_ps = this.rta_providers.getList()).size() == 0) {
            if (this.provider_piece_rtas != null) {
                int i = 0;
                while (i < this.pePieces.length) {
                    PEPiece piece = this.pePieces[i];
                    if (piece != null) {
                        piece.setRealTimeData(null);
                    }
                    ++i;
                }
                this.provider_piece_rtas = null;
            }
            return false;
        }
        boolean has_rta = false;
        this.provider_piece_rtas = new long[this.nbPieces];
        int i = 0;
        while (i < rta_ps.size()) {
            PieceRTAProvider shaper = (PieceRTAProvider)rta_ps.get(i);
            long[] offsets = shaper.updateRTAs(this);
            if (offsets != null) {
                int j = 0;
                while (j < offsets.length) {
                    long rta = offsets[j];
                    if (rta > 0L) {
                        this.provider_piece_rtas[j] = this.provider_piece_rtas[j] == 0L ? rta : Math.min(this.provider_piece_rtas[j], rta);
                        has_rta = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return has_rta;
    }

    @Override
    public void addRTAProvider(PieceRTAProvider provider) {
        this.rta_providers.add(provider);
        Iterator<PiecePickerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().providerAdded(provider);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.leaveEndGameMode();
    }

    @Override
    public void removeRTAProvider(PieceRTAProvider provider) {
        this.rta_providers.remove(provider);
        Iterator<PiecePickerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().providerRemoved(provider);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public List getRTAProviders() {
        return this.rta_providers.getList();
    }

    @Override
    public void addPriorityProvider(PiecePriorityProvider provider) {
        this.priority_providers.add(provider);
        Iterator<PiecePickerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().providerAdded(provider);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void removePriorityProvider(PiecePriorityProvider provider) {
        this.priority_providers.remove(provider);
        Iterator<PiecePickerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().providerRemoved(provider);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public List getPriorityProviders() {
        return this.rta_providers.getList();
    }

    @Override
    public void addListener(PiecePickerListener listener) {
        this.listeners.add(listener);
        Iterator it = this.rta_providers.iterator();
        while (it.hasNext()) {
            listener.providerAdded((PieceRTAProvider)it.next());
        }
    }

    @Override
    public void removeListener(PiecePickerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcePiece(int pieceNumber, boolean forced) {
        if (pieceNumber < 0 || pieceNumber >= this.nbPieces) {
            Debug.out("Invalid piece number: " + pieceNumber);
            return;
        }
        PiecePickerImpl piecePickerImpl = this;
        synchronized (piecePickerImpl) {
            CopyOnWriteSet<Integer> set = this.forced_pieces;
            if (set == null) {
                if (!forced) {
                    return;
                }
                set = new CopyOnWriteSet(false);
                this.forced_pieces = set;
            }
            if (forced) {
                set.add(pieceNumber);
            } else {
                set.remove(pieceNumber);
                if (set.size() == 0) {
                    this.forced_pieces = null;
                }
            }
        }
        Iterator<PiecePickerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().somethingChanged(this, 1, pieceNumber);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        ++paramPriorityChange;
        this.computeBasePriorities();
    }

    @Override
    public boolean isForcePiece(int pieceNumber) {
        if (pieceNumber < 0 || pieceNumber >= this.nbPieces) {
            Debug.out("Invalid piece number: " + pieceNumber);
            return false;
        }
        CopyOnWriteSet<Integer> set = this.forced_pieces;
        return set != null && set.contains(pieceNumber);
    }

    private void setSequentialDownload(int val) {
        if (this.sequentialDownload != val) {
            this.sequentialDownload = val;
            ++this.filePriorityChange;
        }
    }

    @Override
    public void setSequentialAscendingFrom(int start_piece) {
        this.setSequentialDownload(start_piece + 1);
    }

    @Override
    public void setSequentialDescendingFrom(int start_piece) {
        this.setSequentialDownload(-(start_piece + 1));
    }

    @Override
    public void clearSequential() {
        this.setSequentialDownload(0);
    }

    @Override
    public int getSequentialInfo() {
        return this.sequentialDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEGMInfo() {
        if (this.endGameModeAbandoned) {
            return "abandoned";
        }
        if (this.endGameMode) {
            Object object = this.endGameModeChunkLock;
            synchronized (object) {
                long elapsed = SystemTime.getMonotonousTime() - this.timeEndGameModeEntered;
                String str = "rem=" + (120000L - elapsed) / 1000L + "s";
                str = String.valueOf(str) + ",chunks=" + this.endGameModeChunks.size();
                return str;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEGMRequestCount(int piece_number, int block_number) {
        Object object = this.endGameModeChunkLock;
        synchronized (object) {
            EndGameModeChunk chunk;
            block4: {
                chunk = this.endGameModeChunkMap.get(new Long((long)piece_number << 32 | (long)block_number));
                if (chunk != null) break block4;
                return 0;
            }
            return chunk.getRequestCount();
        }
    }

    @Override
    public void setGlobalRequestHint(int piece_number, int start_bytes, int byte_count) {
        this.global_request_hint = (int[])(piece_number < 0 ? null : new int[]{piece_number, start_bytes, byte_count});
    }

    @Override
    public int[] getGlobalRequestHint() {
        return this.global_request_hint;
    }

    @Override
    public void setReverseBlockOrder(boolean is_reverse) {
        this.reverse_block_order = is_reverse;
    }

    @Override
    public boolean getReverseBlockOrder() {
        return this.reverse_block_order;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getPieceString(int piece_number) {
        CopyOnWriteSet<Integer> forced;
        String str;
        long priority = this.startPriorities == null ? 0 : this.startPriorities[piece_number];
        if (priority == 9999999L) {
            long[] rta = this.provider_piece_rtas;
            str = "pri=rta:" + (rta == null ? "?" : "" + (rta[piece_number] - SystemTime.getCurrentTime()));
        } else {
            PEPiece pe_piece = this.pePieces[piece_number];
            if (pe_piece != null) {
                priority = pe_piece.getResumePriority();
            }
            str = "pri=" + priority;
        }
        str = String.valueOf(str) + ",avail=" + this.availability[piece_number];
        long[] exts = this.provider_piece_priorities;
        if (exts != null) {
            str = String.valueOf(str) + ",ext=" + exts[piece_number];
        }
        if ((forced = this.forced_pieces) != null && forced.contains(piece_number)) {
            str = String.valueOf(str) + ", forced";
        }
        return str;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("Piece Picker");
        try {
            writer.indent();
            writer.println("globalAvail: " + this.globalAvail);
            writer.println("globalAvgAvail: " + this.globalAvgAvail);
            writer.println("nbRarestActive: " + this.nbRarestActive);
            writer.println("globalMin: " + this.globalMin);
            writer.println("globalMinOthers: " + this.globalMinOthers);
            writer.println("hasNeededUndonePiece: " + this.hasNeededUndonePiece);
            writer.println("endGameMode: " + this.endGameMode);
            writer.println("endGameModeAbandoned: " + this.endGameModeAbandoned);
            writer.println("endGameModeChunks: " + this.endGameModeChunks);
        }
        finally {
            writer.exdent();
        }
    }

    private class DiskManagerListenerImpl
    implements DiskManagerListener {
        private DiskManagerListenerImpl() {
        }

        @Override
        public final void stateChanged(DiskManager dm, int oldState, int newState) {
        }

        @Override
        public final void filePriorityChanged(DiskManager dm, List<DiskManagerFileInfo> files) {
            int endI;
            int startI;
            PiecePickerImpl.this.syncFilePriorities();
            ++PiecePickerImpl.this.filePriorityChange;
            boolean foundPieceToDownload = false;
            if (PiecePickerImpl.this.hasNeededUndonePiece) {
                startI = 0;
                endI = PiecePickerImpl.this.nbPieces;
            } else {
                startI = PiecePickerImpl.this.nbPieces;
                endI = 0;
                for (DiskManagerFileInfo file : files) {
                    startI = Math.min(startI, file.getFirstPieceNumber());
                    endI = Math.max(endI, file.getLastPieceNumber() + 1);
                }
            }
            int i = startI;
            while (i < endI) {
                DiskManagerPiece dmPiece = PiecePickerImpl.this.dmPieces[i];
                if (!dmPiece.isDone()) {
                    foundPieceToDownload |= dmPiece.calcNeeded();
                }
                ++i;
            }
            if (foundPieceToDownload ^ PiecePickerImpl.this.hasNeededUndonePiece) {
                PiecePickerImpl.this.hasNeededUndonePiece = foundPieceToDownload;
                ++PiecePickerImpl.this.neededUndonePieceChange;
            }
        }

        @Override
        public final void pieceDoneChanged(DiskManager dm, DiskManagerPiece dmPiece) {
            int pieceNumber = dmPiece.getPieceNumber();
            if (dmPiece.isDone()) {
                PiecePickerImpl.this.addHavePiece(null, pieceNumber);
                ++PiecePickerImpl.this.nbPiecesDone;
                if (PiecePickerImpl.this.nbPiecesDone >= PiecePickerImpl.this.nbPieces) {
                    PiecePickerImpl.this.checkDownloadablePiece();
                }
            } else {
                try {
                    PiecePickerImpl.this.availabilityMon.enter();
                    if (PiecePickerImpl.this.availabilityAsynch == null) {
                        PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                    }
                    if (PiecePickerImpl.this.availabilityAsynch[pieceNumber] > 0) {
                        int n = pieceNumber;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                    } else {
                        ++PiecePickerImpl.this.availabilityDrift;
                    }
                    ++PiecePickerImpl.this.availabilityChange;
                }
                finally {
                    PiecePickerImpl.this.availabilityMon.exit();
                }
                --PiecePickerImpl.this.nbPiecesDone;
                if (dmPiece.calcNeeded() && !PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            }
        }
    }

    private class PEPeerListenerImpl
    implements PEPeerListener {
        private PEPeerListenerImpl() {
        }

        @Override
        public final void stateChanged(PEPeer peer, int newState) {
        }

        @Override
        public final void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
        }

        @Override
        public final void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                int i = peerHavePieces.start;
                while (i <= peerHavePieces.end) {
                    if (peerHavePieces.flags[i]) {
                        int n = i;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] + 1;
                    }
                    ++i;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }

        @Override
        public final void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                int i = peerHavePieces.start;
                while (i <= peerHavePieces.end) {
                    if (peerHavePieces.flags[i]) {
                        if (PiecePickerImpl.this.availabilityAsynch[i] > (PiecePickerImpl.this.dmPieces[i].isDone() ? 1 : 0)) {
                            int n = i;
                            PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                        } else {
                            ++PiecePickerImpl.this.availabilityDrift;
                        }
                    }
                    ++i;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }
    }

    private class PEPeerManagerListenerImpl
    extends PEPeerManagerListenerAdapter {
        private PEPeerManagerListenerImpl() {
        }

        @Override
        public final void peerAdded(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.get(peer);
            if (peerListener == null) {
                peerListener = new PEPeerListenerImpl();
                PiecePickerImpl.this.peerListeners.put(peer, peerListener);
            }
            peer.addListener(peerListener);
        }

        @Override
        public final void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.remove(peer);
            peer.removeListener(peerListener);
        }
    }

    protected static class RealTimeData {
        private final List[] peer_requests;

        protected RealTimeData(PEPiece piece) {
            int nb = piece.getNbBlocks();
            this.peer_requests = new List[nb];
            int i = 0;
            while (i < this.peer_requests.length) {
                this.peer_requests[i] = new ArrayList(1);
                ++i;
            }
        }

        public final List[] getRequests() {
            return this.peer_requests;
        }
    }

    private static class RealTimePeerRequest {
        private final PEPeerTransport peer;
        private final DiskManagerReadRequest request;

        protected RealTimePeerRequest(PEPeerTransport _peer, DiskManagerReadRequest _request) {
            this.peer = _peer;
            this.request = _request;
        }

        protected PEPeerTransport getPeer() {
            return this.peer;
        }

        protected DiskManagerReadRequest getRequest() {
            return this.request;
        }
    }
}

