/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.unchoker;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;

public class UnchokerUtil {
    public static boolean isUnchokable(PEPeer peer, boolean allow_snubbed) {
        return peer.getPeerState() == 30 && !peer.isSeed() && !peer.isRelativeSeed() && peer.isInterested() && !peer.isUploadDisabled() && (!peer.isSnubbed() || allow_snubbed);
    }

    public static void updateLargestValueFirstSort(long new_value, long[] values, PEPeer new_item, ArrayList items, int start_pos) {
        items.ensureCapacity(values.length);
        int i = start_pos;
        while (i < values.length) {
            if (new_value >= values[i]) {
                int j = values.length - 2;
                while (j >= i) {
                    values[j + 1] = values[j];
                    --j;
                }
                if (items.size() == values.length) {
                    items.remove(values.length - 1);
                }
                values[i] = new_value;
                items.add(i, new_item);
                return;
            }
            ++i;
        }
    }

    public static PEPeer getNextOptimisticPeer(ArrayList<PEPeer> all_peers, boolean factor_reciprocated, boolean allow_snubbed) {
        ArrayList<PEPeer> peers = UnchokerUtil.getNextOptimisticPeers(all_peers, factor_reciprocated, allow_snubbed, 1);
        if (peers != null) {
            return (PEPeerTransport)peers.get(0);
        }
        return null;
    }

    public static ArrayList<PEPeer> getNextOptimisticPeers(ArrayList<PEPeer> all_peers, boolean factor_reciprocated, boolean allow_snubbed, int num_needed) {
        PEPeer peer;
        ArrayList<PEPeer> optimistics = new ArrayList<PEPeer>();
        int i = 0;
        while (i < all_peers.size()) {
            peer = all_peers.get(i);
            if (UnchokerUtil.isUnchokable(peer, false) && peer.isChokedByMe()) {
                optimistics.add(peer);
            }
            ++i;
        }
        if (optimistics.isEmpty() && allow_snubbed) {
            i = 0;
            while (i < all_peers.size()) {
                peer = all_peers.get(i);
                if (UnchokerUtil.isUnchokable(peer, true) && peer.isChokedByMe()) {
                    optimistics.add(peer);
                }
                ++i;
            }
        }
        if (optimistics.isEmpty()) {
            return null;
        }
        ArrayList<PEPeer> result = new ArrayList<PEPeer>(optimistics.size());
        if (factor_reciprocated) {
            ArrayList ratioed_peers = new ArrayList(optimistics.size());
            long[] ratios = new long[optimistics.size()];
            Arrays.fill(ratios, Long.MIN_VALUE);
            int i2 = 0;
            while (i2 < optimistics.size()) {
                PEPeer peer2 = (PEPeer)optimistics.get(i2);
                long score = peer2.getStats().getTotalDataBytesSent() - peer2.getStats().getTotalDataBytesReceived();
                UnchokerUtil.updateLargestValueFirstSort(score, ratios, peer2, ratioed_peers, 0);
                ++i2;
            }
            i2 = 0;
            while (i2 < num_needed && ratioed_peers.size() > 0) {
                double factor = 1.0 / (0.8 + 0.2 * Math.pow(RandomUtils.nextFloat(), -1.0));
                int pos = (int)(factor * (double)ratioed_peers.size());
                result.add((PEPeer)ratioed_peers.remove(pos));
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < num_needed && optimistics.size() > 0) {
                int rand_pos = new Random().nextInt(optimistics.size());
                result.add((PEPeer)optimistics.remove(rand_pos));
                ++i3;
            }
        }
        return result;
    }

    public static void performChokes(ArrayList<PEPeer> peers_to_choke, ArrayList<PEPeer> peers_to_unchoke) {
        PEPeer peer;
        int i;
        if (peers_to_choke != null) {
            i = 0;
            while (i < peers_to_choke.size()) {
                peer = (PEPeerTransport)peers_to_choke.get(i);
                if (!peer.isChokedByMe()) {
                    peer.sendChoke();
                }
                ++i;
            }
        }
        if (peers_to_unchoke != null) {
            i = 0;
            while (i < peers_to_unchoke.size()) {
                peer = peers_to_unchoke.get(i);
                if (peer.isChokedByMe()) {
                    peer.sendUnChoke();
                }
                ++i;
            }
        }
    }

    public static void performChokeUnchoke(PEPeer to_choke, PEPeer to_unchoke) {
        if (to_choke != null && !to_choke.isChokedByMe()) {
            to_choke.sendChoke();
        }
        if (to_unchoke != null && to_unchoke.isChokedByMe()) {
            to_unchoke.sendUnChoke();
        }
    }

    public static void doHighLatencyPeers(ArrayList<PEPeer> peers_to_choke, ArrayList<PEPeer> peers_to_unchoke, boolean allow_snubbed) {
        if (peers_to_choke.size() == 0) {
            return;
        }
        Iterator<PEPeer> choke_it = peers_to_choke.iterator();
        int to_remove = 0;
        while (choke_it.hasNext()) {
            PEPeer peer = choke_it.next();
            if (AENetworkClassifier.categoriseAddress(peer.getIp()) == "Public" || !UnchokerUtil.isUnchokable(peer, allow_snubbed)) continue;
            choke_it.remove();
            ++to_remove;
        }
        if (to_remove > 0) {
            PEPeer peer;
            ListIterator<PEPeer> unchoke_it = peers_to_unchoke.listIterator(peers_to_unchoke.size());
            while (unchoke_it.hasPrevious()) {
                peer = unchoke_it.previous();
                if (AENetworkClassifier.categoriseAddress(peer.getIp()) == "Public") continue;
                unchoke_it.remove();
                if (--to_remove != 0) continue;
                return;
            }
            if (to_remove > 0) {
                unchoke_it = peers_to_unchoke.listIterator(peers_to_unchoke.size());
                while (unchoke_it.hasPrevious()) {
                    peer = unchoke_it.previous();
                    unchoke_it.remove();
                    if (--to_remove != 0) continue;
                    return;
                }
            }
        }
    }
}

