/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.security.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.security.SECertificateListener;
import com.biglybt.core.security.SEKeyDetails;
import com.biglybt.core.security.SEPasswordListener;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.security.impl.ClientSecurityManager;
import com.biglybt.core.security.impl.SESecurityManagerBC;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SESecurityManagerImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    protected static final SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected static String KEYSTORE_TYPE;
    private static boolean auto_install_certs;
    private static boolean auto_decline_certs;
    protected String keystore_name;
    protected String truststore_name;
    protected final CopyOnWriteList<SECertificateListener> certificate_listeners = new CopyOnWriteList();
    protected final CopyOnWriteList<SEPasswordListener> password_listeners = new CopyOnWriteList();
    private static final ThreadLocal<Object> tls;
    protected final Map<String, Object[]> password_handlers = new HashMap<String, Object[]>();
    protected final Map<String, Object[]> certificate_handlers = new HashMap<String, Object[]>();
    protected boolean exit_vm_permitted = false;
    private volatile SESecurityManager.MySecurityManager my_sec_man;
    protected final AEMonitor store_mon = new AEMonitor("SESecurityManager:s");
    private boolean initialized = false;
    final List stoppable_threads = new ArrayList();
    private boolean hack_constructor_tried;
    private Constructor hack_constructor;

    static {
        String[] types = new String[]{"JKS", "GKR", "BKS"};
        int i = 0;
        while (i < types.length) {
            try {
                KeyStore.getInstance(types[i]);
                KEYSTORE_TYPE = types[i];
                break;
            }
            catch (Throwable throwable) {
                ++i;
            }
        }
        if (KEYSTORE_TYPE == null) {
            KEYSTORE_TYPE = "JKS";
        }
        Logger.log(new LogEvent(LOGID, "Keystore type is " + KEYSTORE_TYPE));
        COConfigurationManager.addAndFireParameterListeners(new String[]{"security.cert.auto.install", "security.cert.auto.decline"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                auto_install_certs = COConfigurationManager.getBooleanParameter("security.cert.auto.install");
                auto_decline_certs = COConfigurationManager.getBooleanParameter("security.cert.auto.decline");
            }
        });
        tls = new ThreadLocal<Object>(){

            @Override
            public Object initialValue() {
                return null;
            }
        };
    }

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        SESecurityManagerImpl sESecurityManagerImpl = this;
        synchronized (sESecurityManagerImpl) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
        }
        this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
        this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.installAuthenticator();
        String[] providers = new String[]{"com.sun.net.ssl.internal.ssl.Provider", "org.metastatic.jessie.provider.Jessie", "org.gudy.bouncycastle.jce.provider.BouncyCastleProvider"};
        String provider = null;
        int i = 0;
        while (i < providers.length) {
            try {
                Class.forName(providers[i]).newInstance();
                provider = providers[i];
                break;
            }
            catch (Throwable throwable) {
                ++i;
            }
        }
        if (provider == null) {
            Debug.out("No SSL provider available");
        }
        try {
            SESecurityManagerBC.initialise();
        }
        catch (Throwable e) {
            Debug.out(e);
            Logger.log(new LogEvent(LOGID, 3, "Bouncy Castle not available"));
        }
        this.installSecurityManager();
        this.ensureStoreExists(this.keystore_name);
        this.ensureStoreExists(this.truststore_name);
        this.initEmptyTrustStore();
    }

    private void initEmptyTrustStore() {
        try {
            File cacerts;
            File target = FileUtil.newFile(this.truststore_name, new String[0]);
            if (target.exists() && target.length() > 2048L) {
                return;
            }
            KeyStore keystore = this.getTrustStore();
            if (keystore.size() == 0 && (cacerts = FileUtil.newFile(System.getProperty("java.home"), "lib", "security", "cacerts")).exists()) {
                FileUtil.copyFile(cacerts, target);
                try {
                    this.getTrustStore();
                }
                catch (Throwable e) {
                    target.delete();
                    this.ensureStoreExists(this.truststore_name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean resetTrustStore(boolean test_only) {
        return this.resetTrustStore(test_only, false);
    }

    private boolean resetTrustStore(boolean test_only, boolean recovering) {
        File cacerts = FileUtil.newFile(System.getProperty("java.home"), "lib", "security", "cacerts");
        if (!cacerts.exists()) {
            return false;
        }
        if (test_only) {
            return true;
        }
        File target = FileUtil.newFile(this.truststore_name, new String[0]);
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
            return false;
        }
        if (!FileUtil.copyFile(cacerts, target)) {
            Debug.out("Failed to copy file from " + cacerts + " to " + target);
            return false;
        }
        try {
            this.getTrustStore(!recovering);
        }
        catch (Throwable e) {
            Debug.out(e);
            target.delete();
            this.ensureStoreExists(this.truststore_name);
            return false;
        }
        return true;
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
        if (!Constants.isAndroid) {
            String prop = System.getProperty(SystemProperties.SYSPROP_SECURITY_MANAGER_INSTALL, "1");
            if (prop.equals("0")) {
                Debug.outNoStack("Not installing security manager - disabled by system property");
                return;
            }
            try {
                if (!Constants.isJava18OrHigher) {
                    this.my_sec_man = new ClientSecurityManager(this);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStoppableThread() {
        List list = this.stoppable_threads;
        synchronized (list) {
            return this.stoppable_threads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread(Thread t) {
        List list = this.stoppable_threads;
        synchronized (list) {
            this.stoppable_threads.add(Thread.currentThread());
        }
        try {
            t.stop();
        }
        catch (Throwable throwable) {
            List list2 = this.stoppable_threads;
            synchronized (list2) {
                this.stoppable_threads.remove(Thread.currentThread());
            }
            throw throwable;
        }
        List list3 = this.stoppable_threads;
        synchronized (list3) {
            this.stoppable_threads.remove(Thread.currentThread());
        }
    }

    protected boolean canExitVM() {
        return this.exit_vm_permitted;
    }

    public void exitVM(int status) {
        try {
            this.exit_vm_permitted = true;
            try {
                System.exit(status);
            }
            catch (Throwable throwable) {}
        }
        finally {
            this.exit_vm_permitted = false;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected final AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String host = this.getRequestingHost();
                int port = this.getRequestingPort();
                if (host != null) {
                    try {
                        String str = AEPluginProxyHandler.lookupPluginProxyURLHostRewrite(host);
                        if (str != null) {
                            host = str;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                try {
                    PasswordAuthentication res;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication = res = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), host, port);
                    return passwordAuthentication;
                }
                finally {
                    this.auth_mon.exit();
                }
            }
        });
    }

    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        try {
            URL tracker_url = new URL(String.valueOf(protocol) + "://" + host + ":" + port + "/");
            if (protocol.toLowerCase().startsWith("socks")) {
                PasswordAuthentication temp;
                SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
                if (thread_listener != null && (temp = thread_listener.getAuthentication(realm, tracker_url)) != null) {
                    return temp;
                }
                String socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                String socks_pw = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    return new PasswordAuthentication("", "".toCharArray());
                }
                if (socks_user.length() == 0) {
                    Logger.log(new LogAlert(false, 1, "Socks server is requesting authentication, please setup user and password in config"));
                }
                return new PasswordAuthentication(socks_user, socks_pw.toCharArray());
            }
            return this.getPasswordAuthentication(realm, tracker_url);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File f = FileUtil.newFile(this.keystore_name, new String[0]);
        if (!f.exists()) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore key_store = this.loadKeyStore();
            Enumeration<String> enumx = key_store.aliases();
            if (!enumx.hasMoreElements()) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.corrupt"), new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    protected boolean ensureStoreExists(String name) {
        try {
            this.store_mon.enter();
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            if (!FileUtil.newFile(name, new String[0]).exists()) {
                keystore.load(null, null);
                try (FileOutputStream out = null;){
                    out = FileUtil.newFileOutputStream(FileUtil.newFile(name, new String[0]));
                    keystore.store(out, "changeit".toCharArray());
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        finally {
            this.store_mon.exit();
        }
    }

    private KeyStore getTrustStore() throws Exception {
        return this.getTrustStore(true);
    }

    private KeyStore getTrustStore(boolean attempt_recovery) throws Exception {
        try {
            KeyStore keystore;
            block16: {
                this.store_mon.enter();
                keystore = KeyStore.getInstance(KEYSTORE_TYPE);
                File tf_file = FileUtil.newFile(this.truststore_name, new String[0]);
                try {
                    if (!tf_file.exists()) {
                        keystore.load(null, null);
                        break block16;
                    }
                    try (FileInputStream in = null;){
                        in = FileUtil.newFileInputStream(tf_file);
                        keystore.load(in, "changeit".toCharArray());
                    }
                }
                catch (Throwable e) {
                    if (attempt_recovery) {
                        Debug.out("Failed to load trust store - resetting", e);
                        try {
                            if (tf_file.exists()) {
                                File bad_file = FileUtil.newFile(String.valueOf(tf_file.getAbsolutePath()) + ".bad", new String[0]);
                                bad_file.delete();
                                tf_file.renameTo(bad_file);
                            }
                        }
                        catch (Throwable f) {
                            Debug.out(f);
                        }
                        this.resetTrustStore(false, true);
                        KeyStore keyStore = this.getTrustStore(false);
                        this.store_mon.exit();
                        return keyStore;
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
            }
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            this.store_mon.exit();
        }
    }

    private KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    private KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        try {
            this.store_mon.enter();
            KeyStore key_store = KeyStore.getInstance(KEYSTORE_TYPE);
            File keystore_file = FileUtil.newFile(this.keystore_name, new String[0]);
            if (!keystore_file.exists()) {
                key_store.load(null, null);
            } else {
                try (FileInputStream kis = null;){
                    kis = FileUtil.newFileInputStream(keystore_file);
                    key_store.load(kis, "changeit".toCharArray());
                }
            }
            keyManagerFactory.init(key_store, "changeit".toCharArray());
            KeyStore keyStore = key_store;
            return keyStore;
        }
        finally {
            this.store_mon.exit();
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext context2 = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        context2.init(keyManagerFactory.getKeyManagers(), null, RandomUtils.SECURE_RANDOM);
        SSLServerSocketFactory factory = context2.getServerSocketFactory();
        return factory;
    }

    public SEKeyDetails getKeyDetails(String alias) throws Exception {
        KeyStore key_store = this.loadKeyStore();
        final Key key = key_store.getKey(alias, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] chain = key_store.getCertificateChain(alias);
        final X509Certificate[] res = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            res[i] = (X509Certificate)chain[i];
            ++i;
        }
        return new SEKeyDetails(){

            @Override
            public Key getKey() {
                return key;
            }

            @Override
            public X509Certificate[] getCertificateChain() {
                return res;
            }
        };
    }

    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManagerBC.createSelfSignedCertificate(this, alias, cert_dn, strength);
    }

    public TrustManagerFactory getTrustManagerFactory() {
        try {
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            return tmf;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        try {
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            return factory;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    public TrustManager[] getAllTrustingTrustManager() {
        return this.getAllTrustingTrustManager(null);
    }

    public TrustManager[] getAllTrustingTrustManager(final X509TrustManager delegate) {
        try {
            this.store_mon.enter();
            TrustManager[] all_trusting_manager = null;
            if (!this.hack_constructor_tried) {
                this.hack_constructor_tried = true;
                boolean hasClassX509ExtendedTrustManager = false;
                try {
                    Class.forName("javax.net.ssl.X509ExtendedTrustManager");
                    hasClassX509ExtendedTrustManager = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    if (hasClassX509ExtendedTrustManager) {
                        this.hack_constructor = Class.forName("com.biglybt.core.security.impl.SETrustingManager").getConstructor(X509TrustManager.class);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.hack_constructor != null) {
                try {
                    all_trusting_manager = new TrustManager[]{(TrustManager)this.hack_constructor.newInstance(delegate)};
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (all_trusting_manager == null) {
                all_trusting_manager = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        if (delegate != null) {
                            return delegate.getAcceptedIssuers();
                        }
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (delegate != null) {
                            delegate.checkClientTrusted(chain, authType);
                        }
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (delegate != null) {
                            delegate.checkServerTrusted(chain, authType);
                        }
                    }
                }};
            }
            TrustManager[] trustManagerArray = all_trusting_manager;
            return trustManagerArray;
        }
        finally {
            this.store_mon.exit();
        }
    }

    public SSLSocketFactory installServerCertificates(URL https_url) {
        try {
            return this.installServerCertificates(https_url, false, false, false);
        }
        catch (Throwable e) {
            try {
                return this.installServerCertificates(https_url, false, false, true);
            }
            catch (Throwable f) {
                return null;
            }
        }
    }

    public SSLSocketFactory installServerCertificates(String alias, String host, int port) {
        try {
            return this.installServerCertificates(alias, host, port, false, false);
        }
        catch (Throwable e) {
            try {
                return this.installServerCertificates(alias, host, port, false, true);
            }
            catch (Throwable f) {
                Debug.out(e);
                return null;
            }
        }
    }

    private SSLSocket createInstallServerCertificatesSocket(TrustManager[] trustAllCerts, String host, int port, boolean sni_hack, boolean use_proxy) throws Throwable {
        SSLSocket socket;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
        SSLSocketFactory factory = sc.getSocketFactory();
        if (use_proxy) {
            HashMap<String, Object> opts = new HashMap<String, Object>();
            opts.put("peer_networks", "Tor");
            AEProxyFactory.PluginProxy plugin_proxy = AEProxyFactory.getPluginProxy("installCerts", host, port, opts);
            if (plugin_proxy == null) {
                throw new Exception("Plugin Proxy unavailable");
            }
            boolean proxy_ok = false;
            try {
                Proxy proxy = plugin_proxy.getProxy();
                Socket base_socket = new Socket(proxy);
                base_socket.setSoTimeout(30000);
                InetSocketAddress targetSockAddress = InetSocketAddress.createUnresolved(host, port);
                base_socket.connect(targetSockAddress, 30000);
                if (sni_hack) {
                    socket = (SSLSocket)factory.createSocket(base_socket, "", base_socket.getPort(), true);
                    socket.setEnabledProtocols(new String[]{"TLSv1"});
                    socket.setUseClientMode(true);
                } else {
                    socket = (SSLSocket)factory.createSocket(base_socket, host, port, true);
                }
                proxy_ok = true;
            }
            finally {
                plugin_proxy.setOK(proxy_ok);
            }
        }
        InetSocketAddress targetSockAddress = new InetSocketAddress(InetAddress.getByName(host), port);
        InetAddress bindIP = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress(targetSockAddress.getAddress() instanceof Inet6Address ? 2 : 1);
        try {
            if (sni_hack) {
                Socket base_socket = new Socket();
                if (bindIP != null) {
                    base_socket.bind(new InetSocketAddress(bindIP, 0));
                }
                base_socket.connect(targetSockAddress, 30000);
                socket = (SSLSocket)factory.createSocket(base_socket, "", base_socket.getPort(), true);
                socket.setEnabledProtocols(new String[]{"TLSv1"});
                socket.setUseClientMode(true);
            } else {
                socket = bindIP != null ? (SSLSocket)factory.createSocket(host, port, bindIP, 0) : (SSLSocket)factory.createSocket(host, port);
            }
        }
        catch (Throwable e) {
            throw new Exception("Failed to create socket: " + host + ":" + port + ", bind=" + bindIP, e);
        }
        socket.setSoTimeout(30000);
        return socket;
    }

    private SSLSocketFactory installServerCertificates(URL https_url, boolean sni_hack, boolean dh_hack, boolean use_proxy) throws Throwable {
        String host = https_url.getHost();
        if (host.isEmpty()) {
            throw new Exception("Host missing from URL: " + https_url);
        }
        int port = https_url.getPort();
        if (port == -1) {
            port = 443;
        }
        Socket socket = null;
        try {
            TrustManagerFactory tmf = this.getTrustManagerFactory();
            final ArrayList<X509TrustManager> default_tms = new ArrayList<X509TrustManager>();
            if (tmf != null) {
                TrustManager[] trustManagerArray = tmf.getTrustManagers();
                int n = trustManagerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TrustManager tm = trustManagerArray[n2];
                    if (tm instanceof X509TrustManager) {
                        default_tms.add((X509TrustManager)tm);
                    }
                    ++n2;
                }
            }
            final ArrayList trustedChains = new ArrayList();
            TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager(new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        Iterator iterator = default_tms.iterator();
                        if (iterator.hasNext()) {
                            X509TrustManager tm = (X509TrustManager)iterator.next();
                            tm.checkServerTrusted(chain, authType);
                            trustedChains.add(chain);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            socket = this.createInstallServerCertificatesSocket(trustAllCerts, host, port, sni_hack, use_proxy);
            if (dh_hack) {
                String[] cs = ((SSLSocket)socket).getEnabledCipherSuites();
                ArrayList<String> new_cs = new ArrayList<String>();
                String[] stringArray = cs;
                int n = cs.length;
                int n3 = 0;
                while (n3 < n) {
                    String x = stringArray[n3];
                    if (!x.contains("_DH_") && !x.contains("_DHE_")) {
                        new_cs.add(x);
                    }
                    ++n3;
                }
                ((SSLSocket)socket).setEnabledCipherSuites(new_cs.toArray(new String[new_cs.size()]));
            }
            ((SSLSocket)socket).startHandshake();
            Certificate[] serverCerts = ((SSLSocket)socket).getSession().getPeerCertificates();
            X509Certificate[] x509_certs = new X509Certificate[serverCerts.length];
            int i = 0;
            while (i < serverCerts.length) {
                X509Certificate x509_cert;
                Certificate cert = serverCerts[i];
                if (cert instanceof X509Certificate) {
                    x509_cert = (X509Certificate)cert;
                } else {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                }
                x509_certs[i] = x509_cert;
                ++i;
            }
            boolean chain_trusted = false;
            if (trustedChains.size() > 0) {
                for (Object ochain : trustedChains) {
                    X509Certificate[] chain = (X509Certificate[])ochain;
                    if (chain.length != x509_certs.length) continue;
                    boolean match = true;
                    int i2 = 0;
                    while (i2 < chain.length) {
                        if (!chain[i2].equals(x509_certs[i2])) {
                            match = false;
                            break;
                        }
                        ++i2;
                    }
                    if (!match) continue;
                    chain_trusted = true;
                    break;
                }
            }
            SSLSocketFactory result = null;
            int i3 = 0;
            while (i3 < serverCerts.length) {
                Certificate cert = serverCerts[i3];
                X509Certificate x509_cert = x509_certs[i3];
                String resource = https_url.toString();
                int param_pos = resource.indexOf("?");
                if (param_pos != -1) {
                    resource = resource.substring(0, param_pos);
                }
                String url_s = String.valueOf(https_url.getProtocol()) + "://" + https_url.getHost() + ":" + https_url.getPort() + "/";
                Object[] handler = this.certificate_handlers.get(url_s);
                String alias = host.concat(":").concat(String.valueOf(port));
                if (i3 > 0) {
                    alias = String.valueOf(alias) + "[" + i3 + "]";
                }
                try {
                    this.store_mon.enter();
                    KeyStore keystore = this.getTrustStore();
                    byte[] new_encoded = x509_cert.getEncoded();
                    int count = 0;
                    boolean already_trusted = false;
                    while (count < 256) {
                        String test_alias = count == 0 ? alias : String.valueOf(alias) + "." + count;
                        Certificate existing = keystore.getCertificate(test_alias);
                        if (existing != null) {
                            if (Arrays.equals(new_encoded, existing.getEncoded())) {
                                alias = test_alias;
                                already_trusted = true;
                                break;
                            }
                        } else {
                            alias = test_alias;
                            break;
                        }
                        ++count;
                    }
                    if (auto_install_certs || chain_trusted || already_trusted || result != null) {
                        result = this.addCertToTrustStore(alias, cert, true);
                    } else if (!auto_decline_certs) {
                        if (handler != null && ((SECertificateListener)handler[0]).trustCertificate(resource, x509_cert)) {
                            result = this.addCertToTrustStore(alias, cert, true);
                        }
                        for (SECertificateListener listener : this.certificate_listeners) {
                            if (!listener.trustCertificate(resource, x509_cert)) continue;
                            result = this.addCertToTrustStore(alias, cert, true);
                        }
                    }
                }
                finally {
                    this.store_mon.exit();
                }
                ++i3;
            }
            SSLSocketFactory sSLSocketFactory = result;
            return sSLSocketFactory;
        }
        catch (Throwable e) {
            String msg = Debug.getNestedExceptionMessage(e);
            if (msg.contains("unrecognized_name") && !sni_hack) {
                SSLSocketFactory sSLSocketFactory = this.installServerCertificates(https_url, true, dh_hack, use_proxy);
                return sSLSocketFactory;
            }
            if (msg.contains("DH keypair") && !dh_hack) {
                SSLSocketFactory sSLSocketFactory = this.installServerCertificates(https_url, sni_hack, true, use_proxy);
                return sSLSocketFactory;
            }
            throw e;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private SSLSocketFactory installServerCertificates(String alias, String host, int port, boolean sni_hack, boolean use_proxy) throws Throwable {
        if (port == -1) {
            port = 443;
        }
        Socket socket = null;
        try {
            TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
            socket = this.createInstallServerCertificatesSocket(trustAllCerts, host, port, sni_hack, use_proxy);
            ((SSLSocket)socket).startHandshake();
            Certificate[] serverCerts = ((SSLSocket)socket).getSession().getPeerCertificates();
            SSLSocketFactory result = null;
            Certificate[] certificateArray = serverCerts;
            int n = serverCerts.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate x509_cert;
                Certificate cert = certificateArray[n2];
                if (cert instanceof X509Certificate) {
                    x509_cert = (X509Certificate)cert;
                } else {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                }
                result = this.addCertToTrustStore(alias, x509_cert, false);
                ++n2;
            }
            SSLSocketFactory sSLSocketFactory = result;
            return sSLSocketFactory;
        }
        catch (Throwable e) {
            if (Debug.getNestedExceptionMessage(e).contains("unrecognized_name") && !sni_hack) {
                SSLSocketFactory sSLSocketFactory = this.installServerCertificates(alias, host, port, true, use_proxy);
                return sSLSocketFactory;
            }
            throw e;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void addCertToKeyStore(String alias, Key public_key, Certificate[] certChain) throws Exception {
        try {
            this.store_mon.enter();
            KeyStore key_store = this.loadKeyStore();
            if (key_store.containsAlias(alias)) {
                key_store.deleteEntry(alias);
            }
            key_store.setKeyEntry(alias, public_key, "changeit".toCharArray(), certChain);
            try (FileOutputStream out = null;){
                try {
                    out = FileUtil.newFileOutputStream(FileUtil.newFile(this.keystore_name, new String[0]));
                    key_store.store(out, "changeit".toCharArray());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
        finally {
            this.store_mon.exit();
        }
    }

    protected SSLSocketFactory addCertToTrustStore(String alias, Certificate cert, boolean update_https_factory) throws Exception {
        try {
            this.store_mon.enter();
            KeyStore keystore = this.getTrustStore();
            if (cert != null) {
                if (keystore.containsAlias(alias)) {
                    keystore.deleteEntry(alias);
                }
                keystore.setCertificateEntry(alias, cert);
                try (FileOutputStream out = null;){
                    out = FileUtil.newFileOutputStream(FileUtil.newFile(this.truststore_name, new String[0]));
                    keystore.store(out, "changeit".toCharArray());
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            if (update_https_factory) {
                HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            }
            SSLSocketFactory sSLSocketFactory = factory;
            return sSLSocketFactory;
        }
        finally {
            this.store_mon.exit();
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String realm, URL tracker) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            return thread_listener.getAuthentication(realm, tracker);
        }
        Object[] handler = this.password_handlers.get(tracker.toString());
        if (handler != null) {
            try {
                return ((SEPasswordListener)handler[0]).getAuthentication(realm, (URL)handler[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        Iterator<SEPasswordListener> it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                PasswordAuthentication res = it.next().getAuthentication(realm, tracker);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String realm, URL tracker, boolean success) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.setAuthenticationOutcome(realm, tracker, success);
        }
        Iterator<SEPasswordListener> it = this.password_listeners.iterator();
        while (it.hasNext()) {
            it.next().setAuthenticationOutcome(realm, tracker, success);
        }
    }

    public void addPasswordListener(SEPasswordListener l) {
        this.password_listeners.add(l);
    }

    public void removePasswordListener(SEPasswordListener l) {
        this.password_listeners.remove(l);
    }

    public void clearPasswords() {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.clearPasswords();
        }
        Iterator<SEPasswordListener> it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().clearPasswords();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setThreadPasswordHandler(SEPasswordListener l) {
        tls.set(l);
    }

    public void unsetThreadPasswordHandler() {
        tls.set(null);
    }

    public void setPasswordHandler(URL url, SEPasswordListener l) {
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.password_handlers.remove(url_s);
        } else {
            this.password_handlers.put(url_s, new Object[]{l, url});
        }
    }

    public void addCertificateListener(SECertificateListener l) {
        this.certificate_listeners.add(l);
    }

    public void setCertificateHandler(URL url, SECertificateListener l) {
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.certificate_handlers.remove(url_s);
        } else {
            this.certificate_handlers.put(url_s, new Object[]{l, url});
        }
    }

    public void removeCertificateListener(SECertificateListener l) {
        this.certificate_listeners.remove(l);
    }

    public Class<?>[] getClassContext() {
        if (this.my_sec_man == null) {
            return new Class[0];
        }
        return this.my_sec_man.getClassContext();
    }

    public boolean filterNetworkInterfaces(List<NetworkInterface> interfaces) {
        if (this.my_sec_man != null) {
            return this.my_sec_man.filterNetworkInterfaces(interfaces);
        }
        return false;
    }

    public static void main(String[] args) {
        SESecurityManagerImpl man = SESecurityManagerImpl.getSingleton();
        man.initialise();
        try {
            man.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

