/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager;

import com.biglybt.core.Core;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.stats.transfer.LongTermStats;
import com.biglybt.core.stats.transfer.LongTermStatsListener;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagFeatureExecOnAssign;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagFeatureRunState;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagPeer;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.average.Average;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingImmediateAverage;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class SpeedLimitHandler
implements LongTermStatsListener {
    private static SpeedLimitHandler singleton;
    private static final Object RL_TO_BE_REMOVED_LOCK;
    private static final Object RLD_TO_BE_REMOVED_KEY;
    private static final Object RLU_TO_BE_REMOVED_KEY;
    private static final Object PEER_LT_WAIT_START_KEY;
    private static final Object PEER_ASN_WAIT_START_KEY;
    private static final IpFilter ip_filter;
    private static final int SCHEDULER_PERIOD = 30000;
    private static final int NETLIMIT_TAG_LOG_PERIOD = 60000;
    private static final int NETLIMIT_TAG_LOG_TICKS = 2;
    private static final int PRIORITISER_CHECK_PERIOD_BASE = 5000;
    private static final int STORAGE_CHECK_PERIOD = 15000;
    private static final String NET_IPV4 = "IPv4";
    private static final String NET_IPV6 = "IPv6";
    private static final String NET_LAN = "LAN";
    private static final String NET_WAN = "WAN";
    private static final int AS_UNKOWN = 0;
    private static final int AS_INACTIVE = 1;
    private static final int AS_ACTIVE = 2;
    final Core core;
    final PluginInterface plugin_interface;
    final TorrentAttribute category_attribute;
    private final LoggerChannel logger;
    private boolean is_enabled = true;
    private TimerEventPeriodic schedule_event;
    private List<ScheduleRule> current_rules = new ArrayList<ScheduleRule>();
    private ScheduleRule active_rule;
    private boolean preserve_inactive_limits;
    private boolean pause_forced_downloads = true;
    private boolean prioritiser_enabled = true;
    private TimerEventPeriodic prioritiser_event;
    private List<Prioritiser> current_prioritisers = new ArrayList<Prioritiser>();
    private TimerEventPeriodic storage_event;
    private List<StorageDetails> current_storage_details = new ArrayList<StorageDetails>();
    private Map<String, PeerSet> current_ip_sets = new HashMap<String, PeerSet>();
    private final Map<String, RateLimiter> ip_set_rate_limiters_up = new HashMap<String, RateLimiter>();
    private final Map<String, RateLimiter> ip_set_rate_limiters_down = new HashMap<String, RateLimiter>();
    private TimerEventPeriodic ip_set_event;
    private boolean net_limit_listener_added;
    private Map<Integer, List<NetLimit>> net_limits_by_type = new HashMap<Integer, List<NetLimit>>();
    private List<NetLimit> net_limits_all = new ArrayList<NetLimit>();
    private static final String INACTIVE_PROFILE_NAME = "preserved_limits (auto)";
    private final List<String> predefined_profile_names = new ArrayList<String>();
    private boolean rule_pause_all_active;
    private boolean net_limit_pause_all_active;
    private final IPSetTagType ip_set_tag_type;
    private final Object extensions_lock;
    private final List<String> auto_peer_set_queue_client;
    private final List<String> auto_peer_set_queue_intf;
    private volatile BuddyPlugin buddy_plugin;
    private final AsyncDispatcher gm_dispatcher;
    private DML current_dml;
    private static final Object ip_set_peer_key;
    private final FrequencyLimitedDispatcher check_ip_sets_limiter;
    private final FrequencyLimitedDispatcher auto_peer_set_checker;

    static {
        RL_TO_BE_REMOVED_LOCK = new Object();
        RLD_TO_BE_REMOVED_KEY = new Object();
        RLU_TO_BE_REMOVED_KEY = new Object();
        PEER_LT_WAIT_START_KEY = new Object();
        PEER_ASN_WAIT_START_KEY = new Object();
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        ip_set_peer_key = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpeedLimitHandler getSingleton(Core core) {
        Class<SpeedLimitHandler> clazz = SpeedLimitHandler.class;
        synchronized (SpeedLimitHandler.class) {
            if (singleton == null) {
                try {
                    singleton = new SpeedLimitHandler(core);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private SpeedLimitHandler(Core _core) {
        this.predefined_profile_names.add("null");
        this.predefined_profile_names.add("pause_all");
        this.predefined_profile_names.add("resume_all");
        this.ip_set_tag_type = TagManagerFactory.getTagManager().isEnabled() ? new IPSetTagType() : null;
        this.extensions_lock = new Object();
        this.auto_peer_set_queue_client = new ArrayList<String>();
        this.auto_peer_set_queue_intf = new ArrayList<String>();
        this.gm_dispatcher = new AsyncDispatcher();
        this.check_ip_sets_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

            @Override
            public void runSupport() {
                SpeedLimitHandler.this.checkIPSetsSupport();
            }
        }, 500);
        this.check_ip_sets_limiter.setSingleThreaded();
        this.auto_peer_set_checker = new FrequencyLimitedDispatcher(new AERunnable(){
            AsyncDispatcher dispatcher = new AsyncDispatcher();

            @Override
            public void runSupport() {
                this.dispatcher.dispatch(AERunnable.create(() -> {
                    ArrayList todo_intf;
                    ArrayList todo_clients;
                    Object object = SpeedLimitHandler.this.auto_peer_set_queue_client;
                    synchronized (object) {
                        todo_clients = new ArrayList(SpeedLimitHandler.this.auto_peer_set_queue_client);
                        SpeedLimitHandler.this.auto_peer_set_queue_client.clear();
                    }
                    object = SpeedLimitHandler.this.auto_peer_set_queue_intf;
                    synchronized (object) {
                        todo_intf = new ArrayList(SpeedLimitHandler.this.auto_peer_set_queue_intf);
                        SpeedLimitHandler.this.auto_peer_set_queue_intf.clear();
                    }
                    if (todo_clients.isEmpty() && todo_intf.isEmpty()) {
                        return;
                    }
                    object = SpeedLimitHandler.this;
                    synchronized (object) {
                        Pattern pattern;
                        PeerSet set;
                        String set_name;
                        HashMap<String, PeerSet> added = new HashMap<String, PeerSet>();
                        for (String name : todo_clients) {
                            if (name.isEmpty()) {
                                name = "?";
                            } else {
                                char c = name.charAt(0);
                                if (c == '\u03bc') {
                                    name = String.valueOf('\u00b5') + name.substring(1);
                                }
                            }
                            set_name = String.valueOf(MessageText.getString("Peers.column.client")) + "_" + name;
                            set = (PeerSet)SpeedLimitHandler.this.current_ip_sets.get(set_name);
                            if (set != null) continue;
                            set = new PeerSet(set_name);
                            try {
                                pattern = Pattern.compile("^" + Pattern.quote(name) + ".*", 66);
                                set.setParameters(false, -1, -1, 0, 0, new HashSet(), pattern, false, null, false, null, false, null);
                                set.addCIDRorCCetc("all");
                                set.setGroup(String.valueOf(MessageText.getString("Peers.column.client")) + "_" + MessageText.getString("wizard.maketorrent.auto"));
                                added.put(set_name, set);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        for (String name : todo_intf) {
                            if (name.isEmpty()) {
                                name = "?";
                            }
                            set_name = String.valueOf(MessageText.getString("label.interface.short")) + "_" + name;
                            set = (PeerSet)SpeedLimitHandler.this.current_ip_sets.get(set_name);
                            if (set != null) continue;
                            set = new PeerSet(set_name);
                            try {
                                pattern = Pattern.compile("^" + Pattern.quote(name) + ".*", 66);
                                set.setParameters(false, -1, -1, 0, 0, new HashSet(), null, false, pattern, false, null, false, null);
                                set.addCIDRorCCetc("all");
                                set.setGroup(String.valueOf(MessageText.getString("label.interface.short")) + "_" + MessageText.getString("wizard.maketorrent.auto"));
                                added.put(set_name, set);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        if (!added.isEmpty()) {
                            SpeedLimitHandler.this.initialiseIPSets(added);
                            SpeedLimitHandler.this.checkIPSets();
                        }
                    }
                }));
            }
        }, 2000);
        this.core = _core;
        this.plugin_interface = this.core.getPluginManager().getDefaultPluginInterface();
        this.category_attribute = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.logger = this.plugin_interface.getLogger().getTimeStampedChannel("Speed Limit Scheduler");
        if (Constants.isCVSVersion()) {
            this.logger.setDiagnostic(0x100000L, true);
        }
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("Speed Limit Scheduler");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.logger.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        this.loadPauseAllActive();
        this.loadSchedule(true);
        this.plugin_interface.addListener(new PluginAdapter(){

            @Override
            public void closedownInitiated() {
                int active_state = SpeedLimitHandler.this.getActiveState();
                if (active_state == 1 && SpeedLimitHandler.this.preserve_inactive_limits) {
                    SpeedLimitHandler.this.saveProfile(SpeedLimitHandler.INACTIVE_PROFILE_NAME);
                }
            }
        });
    }

    private int getActiveState() {
        return COConfigurationManager.getIntParameter("speed.limit.handler.active.state", 0);
    }

    private void setActiveState(int state) {
        COConfigurationManager.setParameter("speed.limit.handler.active.state", state);
    }

    public boolean hasAnyProfiles() {
        if (!COConfigurationManager.hasParameter("speed.limit.handler.state", true)) {
            return false;
        }
        Map map = this.loadConfig();
        if (map.size() == 0) {
            return false;
        }
        List list = (List)map.get("profiles");
        return list != null && list.size() != 0;
    }

    private synchronized Map loadConfig() {
        return BEncoder.cloneMap(COConfigurationManager.getMapParameter("speed.limit.handler.state", new HashMap()));
    }

    private synchronized void saveConfig(Map map) {
        if (map.isEmpty()) {
            COConfigurationManager.removeParameter("speed.limit.handler.state");
        } else {
            COConfigurationManager.setParameter("speed.limit.handler.state", map);
        }
        COConfigurationManager.save();
    }

    private void loadPauseAllActive() {
        this.setRulePauseAllActive(COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_active", false));
        this.setNetLimitPauseAllActive(COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.nl_pa_active", false));
    }

    private BuddyPlugin getBuddyPlugin() {
        if (this.buddy_plugin == null) {
            this.buddy_plugin = BuddyPluginUtils.getPlugin();
        }
        return this.buddy_plugin;
    }

    private void setRulePauseAllActive(boolean active) {
        GlobalManager gm = this.core.getGlobalManager();
        if (active) {
            if (!this.rule_pause_all_active) {
                this.logger.logAlertRepeatable(1, "Pausing all downloads due to pause_all rule");
            }
            this.gm_dispatcher.dispatch(() -> gm.pauseDownloads(this.pause_forced_downloads));
            this.rule_pause_all_active = true;
        } else {
            if (!this.net_limit_pause_all_active && COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_capable", false)) {
                if (this.rule_pause_all_active) {
                    this.logger.logAlertRepeatable(1, "Resuming all downloads as pause_all rule no longer applies");
                }
                this.gm_dispatcher.dispatch(() -> {
                    boolean bl = gm.resumeDownloads(true);
                });
            }
            this.rule_pause_all_active = false;
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.pa_active", active);
    }

    private void setNetLimitPauseAllActive(boolean active) {
        GlobalManager gm = this.core.getGlobalManager();
        if (active) {
            if (!this.net_limit_pause_all_active) {
                this.logger.logAlertRepeatable(1, "Pausing all downloads as network limit exceeded");
            }
            this.gm_dispatcher.dispatch(() -> gm.pauseDownloads(this.pause_forced_downloads));
            this.net_limit_pause_all_active = true;
        } else {
            if (!this.rule_pause_all_active && COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_capable", false)) {
                if (this.net_limit_pause_all_active) {
                    this.logger.logAlertRepeatable(1, "Resuming all downloads as network limit no longer exceeded");
                }
                gm.resumeDownloads(true);
            }
            this.net_limit_pause_all_active = false;
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.nl_pa_active", active);
    }

    public List<String> clearCurrentLimits() {
        if (this.net_limit_pause_all_active) {
            this.setNetLimitPauseAllActive(false);
        }
        return this.resetRules();
    }

    private List<String> resetRules() {
        if (this.rule_pause_all_active) {
            this.setRulePauseAllActive(false);
        }
        LimitDetails details = new LimitDetails();
        details.loadForReset();
        details.apply();
        return details.getString(true, false);
    }

    public List<String> getCurrent() {
        LimitDetails details = new LimitDetails();
        details.loadCurrent();
        List lines = details.getString(true, false);
        lines.add("");
        lines.add("Peer Sets");
        if (this.current_ip_sets.size() == 0) {
            lines.add("    None");
        } else {
            for (Map.Entry<String, PeerSet> entry : this.current_ip_sets.entrySet()) {
                lines.add("    " + entry.getValue().getDetailString());
            }
        }
        ArrayList<Object[]> tag_nls = new ArrayList<Object[]>();
        for (Map.Entry<Integer, List<NetLimit>> entry : this.net_limits_by_type.entrySet()) {
            for (NetLimit nl : entry.getValue()) {
                if (nl.getTag() == null) continue;
                tag_nls.add(new Object[]{entry.getKey(), nl});
            }
        }
        if (tag_nls.size() > 0) {
            lines.add("");
            lines.add("Tag/Peer Set Net Limits");
            for (Object[] objectArray : tag_nls) {
                int type = (Integer)objectArray[0];
                NetLimit nl = (NetLimit)objectArray[1];
                long[] stats2 = nl.getLongTermStats().getTotalUsageInPeriod(type, nl.getMultiplier());
                long[] limits = nl.getLimits();
                long total_up = stats2[0] + stats2[1];
                long total_do = stats2[2] + stats2[3];
                String lim_str = "";
                lim_str = String.valueOf(lim_str) + LongTermStats.PT_NAMES[type] + ", mult=" + nl.getMultiplier() + ": ";
                long total_lim = limits[0];
                long up_lim = limits[1];
                long down_lim = limits[2];
                String sep = "";
                if (total_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + "Total limit=" + DisplayFormatters.formatByteCountToKiBEtc(total_lim) + ", used=" + DisplayFormatters.formatByteCountToKiBEtc(total_up + total_do) + " - " + 100L * (total_up + total_do) / total_lim + "%";
                    sep = ", ";
                }
                if (up_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + sep + "Up limit=" + DisplayFormatters.formatByteCountToKiBEtc(up_lim) + ", used=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + " - " + 100L * total_up / up_lim + "%";
                    sep = ", ";
                }
                if (down_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + sep + "Down limit=" + DisplayFormatters.formatByteCountToKiBEtc(down_lim) + ", used=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + " - " + 100L * total_do / down_lim + "%";
                }
                lim_str = String.valueOf(lim_str) + sep + "enabled=" + nl.isEnabled();
                String tag_name = nl.getTag().getTag().getTagName(true);
                String name = nl.getName();
                name = String.valueOf(name) + (name.length() == 0 ? "" : " ") + tag_name;
                lines.add("    " + name + ": " + lim_str);
            }
        }
        if (this.current_prioritisers.size() > 0) {
            lines.add("");
            lines.add("Prioritizers: " + this.current_prioritisers.size());
        }
        ScheduleRule scheduleRule = this.active_rule;
        lines.add("");
        lines.add("Scheduler");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        lines.add("    Current Time: " + cal.get(11) + ":" + cal.get(12));
        lines.add("    Rules defined: " + this.current_rules.size());
        lines.add("    Active rule: " + (scheduleRule == null ? "None" : scheduleRule.getString()));
        lines.add("");
        lines.add("Network Totals");
        LongTermStats lt_stats = StatsFactory.getLongTermStats();
        if (lt_stats == null || !lt_stats.isEnabled()) {
            lines.add("    Not Available");
        } else {
            lines.add("    Today:\t\t" + this.getString(lt_stats, 1, this.net_limits_by_type.get(1)));
            lines.add("    This week:\t" + this.getString(lt_stats, 2, this.net_limits_by_type.get(2)));
            lines.add("    This month:\t" + this.getString(lt_stats, 3, this.net_limits_by_type.get(3)));
            lines.add("");
            lines.add("    Rate (3 minute average):\t\t" + this.getString(lt_stats.getCurrentRateBytesPerSecond(), null, true));
        }
        lines.add("");
        lines.add("Storage");
        for (StorageDetails s : this.current_storage_details) {
            lines.add("    " + s.getString());
        }
        return lines;
    }

    private String getString(LongTermStats lts, int type, List<NetLimit> net_limits) {
        net_limits = net_limits == null ? new ArrayList<NetLimit>() : new ArrayList<NetLimit>(net_limits);
        net_limits.add(0, null);
        String result = "";
        int lines = 0;
        for (NetLimit net_limit : net_limits) {
            long[] stats2 = this.getLongTermUsage(lts, type, net_limit);
            long total_up = stats2[0] + stats2[1] + stats2[4];
            long total_do = stats2[2] + stats2[3] + stats2[5];
            String lim_str = "";
            String profile = null;
            if (net_limit != null) {
                if (net_limit.getTag() != null) continue;
                profile = net_limit.getProfile();
                long[] limits = net_limit.getLimits();
                long total_lim = limits[0];
                long up_lim = limits[1];
                long down_lim = limits[2];
                if (total_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + "Total=" + DisplayFormatters.formatByteCountToKiBEtc(total_lim) + " " + 100L * (total_up + total_do) / total_lim + "%";
                }
                if (up_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + (lim_str.length() == 0 ? "" : ", ") + "Up=" + DisplayFormatters.formatByteCountToKiBEtc(up_lim) + " " + 100L * total_up / up_lim + "%";
                }
                if (down_lim > 0L) {
                    lim_str = String.valueOf(lim_str) + (lim_str.length() == 0 ? "" : ", ") + "Down=" + DisplayFormatters.formatByteCountToKiBEtc(down_lim) + " " + 100L * total_do / down_lim + "%";
                }
                if (lim_str.length() > 0) {
                    lim_str = "\t[ Limits: " + lim_str + "]";
                }
            }
            if (++lines > 1) {
                if (lines == 2) {
                    result = "\r\n        " + result;
                }
                result = String.valueOf(result) + "\r\n        ";
            }
            result = String.valueOf(result) + (profile == null ? "Overall" : profile) + " - " + "Upload=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + lim_str;
        }
        return result;
    }

    private long[] getLongTermUsage(LongTermStats lts, int type, NetLimit net_limit_maybe_null) {
        double multiplier;
        double d = multiplier = net_limit_maybe_null == null ? 1.0 : net_limit_maybe_null.getMultiplier();
        if (net_limit_maybe_null == null || net_limit_maybe_null.getProfile() == null) {
            return lts.getTotalUsageInPeriod(type, multiplier);
        }
        final String profile = net_limit_maybe_null.getProfile();
        return lts.getTotalUsageInPeriod(type, multiplier, new LongTermStats.RecordAccepter(){

            @Override
            public boolean acceptRecord(long timestamp) {
                ScheduleRule rule = SpeedLimitHandler.this.getActiveRule(new Date(timestamp));
                return rule != null && rule.profile_name.equals(profile);
            }
        });
    }

    private String getString(long[] stats2, long[] limits, boolean is_rate) {
        long total_up = stats2[0] + stats2[1] + stats2[4];
        long total_do = stats2[2] + stats2[3] + stats2[5];
        String lim_str = "";
        if (limits != null) {
            long total_lim = limits[0];
            long up_lim = limits[1];
            long down_lim = limits[2];
            if (total_lim > 0L) {
                lim_str = String.valueOf(lim_str) + "Total=" + DisplayFormatters.formatByteCountToKiBEtc(total_lim) + " " + 100L * (total_up + total_do) / total_lim + "%";
            }
            if (up_lim > 0L) {
                lim_str = String.valueOf(lim_str) + (lim_str.length() == 0 ? "" : ", ") + "Up=" + DisplayFormatters.formatByteCountToKiBEtc(up_lim) + " " + 100L * total_up / up_lim + "%";
            }
            if (down_lim > 0L) {
                lim_str = String.valueOf(lim_str) + (lim_str.length() == 0 ? "" : ", ") + "Down=" + DisplayFormatters.formatByteCountToKiBEtc(down_lim) + " " + 100L * total_do / down_lim + "%";
            }
            if (lim_str.length() > 0) {
                lim_str = "\t[ Limits: " + lim_str + "]";
            }
        }
        if (is_rate) {
            return "Upload=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(total_do);
        }
        return "Upload=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + lim_str;
    }

    public List<String> getProfileNames() {
        Map map = this.loadConfig();
        ArrayList<String> profiles = new ArrayList<String>();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String name = this.importString(m, "n");
                if (name == null) continue;
                profiles.add(name);
            }
        }
        return profiles;
    }

    public List<String> loadProfile(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                ld.apply();
                return ld.getString(false, false);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Profile not found");
        return result;
    }

    private boolean profileExists(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProfile(String name) {
        return this.getProfileSupport(name, false);
    }

    public List<String> getProfileSupport(String name, boolean use_hashes) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                return ld.getString(false, use_hashes);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Profile not found");
        return result;
    }

    public List<String> getProfilesForDownload(byte[] hash) {
        ArrayList<String> result = new ArrayList<String>();
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            String hash_str = Base32.encode(hash);
            for (Map m : list) {
                Map profile;
                LimitDetails ld;
                String p_name = this.importString(m, "n");
                if (p_name == null || (ld = new LimitDetails(profile = (Map)m.get("p"))).getLimitsForDownload(hash_str) == null) continue;
                result.add(p_name);
            }
        }
        return result;
    }

    private void addRemoveDownloadsToProfile(String name, List<byte[]> hashes, boolean add) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        ArrayList<String> hash_strs = new ArrayList<String>();
        for (byte[] hash : hashes) {
            hash_strs.add(Base32.encode(hash));
        }
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                ld.addRemoveDownloads(hash_strs, add);
                m.put("p", ld.export());
                this.saveConfig(map);
                return;
            }
        }
    }

    public void addDownloadsToProfile(String name, List<byte[]> hashes) {
        this.addRemoveDownloadsToProfile(name, hashes, true);
    }

    public void removeDownloadsFromProfile(String name, List<byte[]> hashes) {
        this.addRemoveDownloadsToProfile(name, hashes, false);
    }

    public void deleteProfile(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                list.remove(m);
                this.saveConfig(map);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> saveProfile(String name) {
        ScheduleRule rule;
        LimitDetails details = new LimitDetails();
        details.loadCurrent();
        Map map = this.loadConfig();
        ArrayList list = (ArrayList)map.get("profiles");
        if (list == null) {
            list = new ArrayList();
            map.put("profiles", list);
        }
        for (Map map2 : list) {
            String p_name = this.importString(map2, "n");
            if (p_name == null || !name.equals(p_name)) continue;
            list.remove(map2);
            break;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        list.add(hashMap);
        hashMap.put("n", name);
        hashMap.put("p", details.export());
        this.saveConfig(map);
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            rule = this.active_rule;
        }
        if (rule != null && rule.profile_name.equals(name)) {
            details.apply();
        }
        return details.getString(false, false);
    }

    private synchronized List<String> loadSchedule(boolean start_of_day) {
        ArrayList<String> result = new ArrayList<String>();
        List list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
        List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(list));
        boolean enabled = true;
        ArrayList<ScheduleRule> rules = new ArrayList<ScheduleRule>();
        HashMap<String, PeerSet> ip_sets = new HashMap<String, PeerSet>();
        HashMap<Integer, List<NetLimit>> new_net_limits_by_type = new HashMap<Integer, List<NetLimit>>();
        ArrayList<NetLimit> new_net_limits_all = new ArrayList<NetLimit>();
        ArrayList<Prioritiser> new_prioritisers = new ArrayList<Prioritiser>();
        ArrayList<StorageDetails> new_storage_details = new ArrayList<StorageDetails>();
        boolean checked_lts_enabled = false;
        boolean lts_enabled = false;
        boolean preserve_limits = false;
        boolean pause_forced = true;
        for (String line : schedule_lines) {
            Object tag_dm;
            String[] args;
            String[] bits;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String lc_line = line.toLowerCase(Locale.US);
            if (lc_line.startsWith("enable")) {
                bits = lc_line.split("=");
                boolean ok = false;
                if (bits.length == 2) {
                    String arg = bits[1].trim();
                    if (arg.equals("yes")) {
                        enabled = true;
                        ok = true;
                    } else if (arg.equals("no")) {
                        enabled = false;
                        ok = true;
                    }
                }
                if (ok) continue;
                result.add("'" + line + "' is invalid: use enable=(yes|no)");
                continue;
            }
            if (lc_line.startsWith("preserve_inactive_limits")) {
                bits = lc_line.split("=");
                boolean ok = false;
                if (bits.length == 2) {
                    String arg = bits[1].trim();
                    if (arg.equals("yes")) {
                        preserve_limits = true;
                        ok = true;
                    } else if (arg.equals("no")) {
                        preserve_limits = false;
                        ok = true;
                    }
                }
                if (ok) continue;
                result.add("'" + line + "' is invalid: use preserve_inactive_limits=(yes|no)");
                continue;
            }
            if (lc_line.startsWith("pause_force_downloads")) {
                bits = lc_line.split("=");
                boolean ok = false;
                if (bits.length == 2) {
                    String arg = bits[1].trim();
                    if (arg.equals("yes")) {
                        pause_forced = true;
                        ok = true;
                    } else if (arg.equals("no")) {
                        pause_forced = false;
                        ok = true;
                    }
                }
                if (ok) continue;
                result.add("'" + line + "' is invalid: use pause_force_downloads=(yes|no)");
                continue;
            }
            if (lc_line.startsWith("ip_set") || lc_line.startsWith("peer_set")) {
                try {
                    args = line.substring(lc_line.indexOf(95) + 4).split(",");
                    boolean inverse = false;
                    int up_lim = -1;
                    int down_lim = -1;
                    int peer_up_lim = 0;
                    int peer_down_lim = 0;
                    HashSet<String> categories_or_tags = new HashSet<String>();
                    Pattern client_pattern = null;
                    Pattern intf_pattern = null;
                    Pattern asn_pattern = null;
                    boolean client_pattern_inverse = false;
                    boolean intf_pattern_inverse = false;
                    boolean asn_pattern_inverse = false;
                    String group = null;
                    PeerSet set = null;
                    String[] stringArray = args;
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3;
                        String arg = stringArray[n2];
                        String[] bits2 = arg.split("=");
                        if (bits2.length != 2) {
                            throw new Exception("Expected <key>=<value> for '" + arg + "'");
                        }
                        String lhs = bits2[0].trim();
                        String lc_lhs = lhs.toLowerCase(Locale.US);
                        String rhs = bits2[1].trim();
                        String lc_rhs = rhs.toLowerCase(Locale.US);
                        if (lc_lhs.equals("inverse")) {
                            inverse = lc_rhs.equals("yes");
                        } else if (lc_lhs.equals("up")) {
                            up_lim = (int)this.parseRate(lc_rhs);
                        } else if (lc_lhs.equals("down")) {
                            down_lim = (int)this.parseRate(lc_rhs);
                        } else if (lc_lhs.equals("peer_up")) {
                            peer_up_lim = (int)this.parseRate(lc_rhs);
                        } else if (lc_lhs.equals("peer_down")) {
                            peer_down_lim = (int)this.parseRate(lc_rhs);
                        } else if (lc_lhs.equals("cat") || lc_lhs.equals("tag")) {
                            String[] cats;
                            String[] stringArray2 = cats = rhs.split(" ");
                            n3 = cats.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String cat = stringArray2[n4];
                                if ((cat = cat.trim()).length() > 0) {
                                    categories_or_tags.add(cat);
                                }
                                ++n4;
                            }
                        } else if (lc_lhs.equals("client")) {
                            try {
                                if (rhs.startsWith("!")) {
                                    rhs = rhs.substring(1);
                                    client_pattern_inverse = true;
                                }
                                client_pattern = Pattern.compile(rhs, 66);
                            }
                            catch (Throwable e) {
                                throw new Exception("Invalid client pattern - '" + rhs + "'");
                            }
                        } else if (lc_lhs.equals("intf")) {
                            try {
                                if (rhs.startsWith("!")) {
                                    rhs = rhs.substring(1);
                                    intf_pattern_inverse = true;
                                }
                                intf_pattern = Pattern.compile(rhs, 66);
                            }
                            catch (Throwable e) {
                                throw new Exception("Invalid intf pattern - '" + rhs + "'");
                            }
                        } else if (lc_lhs.equals("asn")) {
                            try {
                                if (rhs.startsWith("!")) {
                                    rhs = rhs.substring(1);
                                    asn_pattern_inverse = true;
                                }
                                asn_pattern = Pattern.compile(rhs, 66);
                            }
                            catch (Throwable e) {
                                throw new Exception("Invalid asn pattern - '" + rhs + "'");
                            }
                        } else if (lc_lhs.equals("group")) {
                            group = rhs;
                        } else {
                            String name = lhs;
                            String def = rhs.replace(';', ' ');
                            set = (PeerSet)ip_sets.get(name);
                            if (set == null) {
                                set = new PeerSet(name);
                                ip_sets.put(name, set);
                            }
                            String[] stringArray3 = bits2 = def.split(" ");
                            int n5 = bits2.length;
                            n3 = 0;
                            while (n3 < n5) {
                                String bit = stringArray3[n3];
                                if ((bit = bit.trim()).length() > 0) {
                                    PeerSet other_set = (PeerSet)ip_sets.get(bit);
                                    if (other_set != null && other_set != set) {
                                        set.addSet(other_set);
                                    } else if (!set.addCIDRorCCetc(bit)) {
                                        result.add("CIDR, CC, Network or ip_set reference '" + bit + "' isn't valid");
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                    if (set == null) {
                        throw new Exception();
                    }
                    int pattern_count = 0;
                    if (client_pattern != null) {
                        ++pattern_count;
                    }
                    if (intf_pattern != null) {
                        ++pattern_count;
                    }
                    if (asn_pattern != null) {
                        ++pattern_count;
                    }
                    if (pattern_count > 1) {
                        throw new Exception("Only one of client, intf and asn pattern can be set for a peer set");
                    }
                    set.setParameters(inverse, up_lim, down_lim, peer_up_lim, peer_down_lim, categories_or_tags, client_pattern, client_pattern_inverse, intf_pattern, intf_pattern_inverse, asn_pattern, asn_pattern_inverse, group);
                }
                catch (Throwable e) {
                    result.add("'" + line + "' is invalid: use ip_set <name>=<cidrs...> [,inverse=[yes|no]] [,up=<limit>] [,down=<limit>] [,peer_up=<limit>] [,peer_down=<limit>] [,cat=<categories>]: " + e.getMessage());
                }
                continue;
            }
            if (lc_line.startsWith("net_limit")) {
                if (!checked_lts_enabled) {
                    checked_lts_enabled = true;
                    lts_enabled = StatsFactory.getLongTermStats().isEnabled();
                    if (!lts_enabled) {
                        result.add("Long-term stats are currently disabled, limits will NOT be applied");
                    }
                }
                line = line.substring(9).replace(",", " ");
                args = line.split(" ");
                String name = "";
                int type = -1;
                double mult = 1.0;
                String profile = null;
                TagType tag_type = null;
                String tag_name = null;
                long total_lim = 0L;
                long up_lim = 0L;
                long down_lim = 0L;
                String[] stringArray = args;
                int n = args.length;
                int pattern_count = 0;
                while (pattern_count < n) {
                    String arg = stringArray[pattern_count];
                    if ((arg = arg.trim()).length() != 0) {
                        if (type == -1) {
                            int sep = arg.indexOf(":");
                            if (sep != -1) {
                                profile = arg.substring(sep + 1).trim();
                                if (!this.profileExists(profile)) {
                                    result.add("net_limit profile '" + profile + "' not defined");
                                    break;
                                }
                                arg = arg.substring(0, sep);
                            } else {
                                sep = arg.indexOf("$");
                                if (sep != -1) {
                                    tag_name = arg.substring(sep + 1).trim();
                                    TagType tag_type_dm = TagManagerFactory.getTagManager().getTagType(3);
                                    TagFeatureRateLimit tag_dm2 = (TagFeatureRateLimit)((Object)tag_type_dm.getTag(tag_name, true));
                                    if (tag_dm2 != null) {
                                        tag_type = tag_type_dm;
                                    } else if (ip_sets.get(tag_name) != null) {
                                        tag_type = this.ip_set_tag_type;
                                    }
                                    if (tag_type == null) {
                                        result.add("net_limit tag/peer set '" + tag_name + "' not defined or invalid");
                                        break;
                                    }
                                    arg = arg.substring(0, sep);
                                }
                            }
                            int pos = arg.indexOf("*");
                            if (pos != -1) {
                                mult = Double.parseDouble(arg.substring(pos + 1));
                                arg = arg.substring(0, pos);
                            }
                            boolean sliding = false;
                            if (arg.equalsIgnoreCase("hourly")) {
                                type = 0;
                            } else if (arg.equalsIgnoreCase("shourly")) {
                                type = 10;
                                sliding = true;
                            } else if (arg.equalsIgnoreCase("daily")) {
                                type = 1;
                            } else if (arg.equalsIgnoreCase("sdaily")) {
                                type = 11;
                                sliding = true;
                            } else if (arg.equalsIgnoreCase("weekly")) {
                                type = 2;
                            } else if (arg.equalsIgnoreCase("sweekly")) {
                                type = 12;
                                sliding = true;
                            } else if (arg.equalsIgnoreCase("monthly")) {
                                type = 3;
                            } else {
                                result.add("net_limit type of '" + arg + "' not recognised - use hourly, daily, weekly or monthly");
                                break;
                            }
                            if (mult != 1.0 && !sliding) {
                                result.add("'" + line + "': invalid net_limit specification. multiplier only supported for sliding windows.");
                            }
                        } else {
                            String[] bits3 = arg.split("=");
                            if (bits3.length != 2) {
                                result.add("'" + line + "': invalid net_limit specification");
                            } else {
                                String lhs = bits3[0];
                                String rhs = bits3[1];
                                if (lhs.equalsIgnoreCase("name")) {
                                    name = rhs;
                                } else {
                                    long lim = this.parseRate(rhs);
                                    if (lhs.equalsIgnoreCase("total")) {
                                        total_lim = lim;
                                    } else if (lhs.equalsIgnoreCase("up")) {
                                        up_lim = lim;
                                    } else if (lhs.equalsIgnoreCase("down")) {
                                        down_lim = lim;
                                    } else {
                                        result.add("'" + line + "': invalid net_limit specification");
                                    }
                                }
                            }
                        }
                    }
                    ++pattern_count;
                }
                if (type == -1) continue;
                ArrayList<NetLimit> limits = (ArrayList<NetLimit>)new_net_limits_by_type.get(type);
                if (limits == null) {
                    limits = new ArrayList<NetLimit>();
                    new_net_limits_by_type.put(type, limits);
                }
                NetLimit limit = new NetLimit(type, name, mult, profile, tag_type, tag_name, total_lim, up_lim, down_lim);
                limits.add(limit);
                new_net_limits_all.add(limit);
                continue;
            }
            if (lc_line.startsWith("priority_down ") || lc_line.startsWith("priority_up ")) {
                args = line.substring(lc_line.indexOf(32) + 1).split(",");
                Prioritiser pri = new Prioritiser();
                pri.setIsDown(lc_line.startsWith("priority_down "));
                TagType tag_type_dm = TagManagerFactory.getTagManager().getTagType(3);
                boolean pri_ok = true;
                String[] tag_name = args;
                int tag_type = args.length;
                int profile = 0;
                while (profile < tag_type) {
                    String arg = tag_name[profile];
                    String[] bits4 = arg.split("=");
                    boolean ok = false;
                    try {
                        if (bits4.length == 2) {
                            String lhs = bits4[0].trim();
                            String rhs = bits4[1].trim();
                            if (Character.isDigit(lhs.charAt(0))) {
                                int p = Integer.parseInt(lhs);
                                TagType tag_type2 = null;
                                tag_dm = (TagFeatureRateLimit)((Object)tag_type_dm.getTag(rhs, true));
                                if (tag_dm != null) {
                                    tag_type2 = tag_type_dm;
                                } else if (ip_sets.get(rhs) != null) {
                                    tag_type2 = this.ip_set_tag_type;
                                }
                                if (tag_type2 != null) {
                                    pri.addTarget(p, tag_type2, rhs);
                                    ok = true;
                                }
                            } else if (lhs.equalsIgnoreCase("freq")) {
                                pri.setFrequency(Integer.parseInt(rhs));
                                ok = true;
                            } else if (lhs.equalsIgnoreCase("rest")) {
                                pri.setRestTicks(Integer.parseInt(rhs));
                                ok = true;
                            } else if (lhs.equalsIgnoreCase("probe")) {
                                pri.setProbePeriod(Integer.parseInt(rhs));
                                ok = true;
                            } else if (lhs.equals("min")) {
                                int min = (int)this.parseRate(rhs);
                                if (min == 0) {
                                    min = -1;
                                }
                                pri.setMinimum(min);
                                ok = true;
                            } else if (lhs.equals("max")) {
                                pri.setMaximum((int)this.parseRate(rhs));
                                ok = true;
                            } else if (lhs.equals("name")) {
                                pri.setName(rhs);
                                ok = true;
                            }
                        }
                    }
                    catch (Throwable lhs) {
                        // empty catch block
                    }
                    if (!ok) {
                        result.add("'" + line + "': invalid argument: " + arg);
                        pri_ok = false;
                    }
                    ++profile;
                }
                if (pri.getTargetCount() < 2) {
                    result.add("'" + line + "': insufficient targets");
                    continue;
                }
                if (!pri_ok) continue;
                new_prioritisers.add(pri);
                continue;
            }
            if (lc_line.startsWith("storage ")) {
                bits = GeneralUtils.decomposeArgs(line = line.replaceAll("\\\\", "\\\\\\\\"));
                if (bits.length != 3) {
                    result.add("'" + line + "': invalid storage specification");
                    continue;
                }
                String root_name = bits[1];
                File[] roots = FileUtil.listRootsWithTimeout();
                File root_hit = null;
                String valid_roots = "";
                File[] bits4 = roots;
                int tag_name = roots.length;
                int tag_type = 0;
                while (tag_type < tag_name) {
                    File root = bits4[tag_type];
                    String this_name = root.getAbsolutePath();
                    valid_roots = String.valueOf(valid_roots) + (valid_roots.isEmpty() ? "" : ", ") + this_name;
                    if (root_name.equals("*") || this_name.equals(root_name)) {
                        String[] args2;
                        root_hit = root;
                        tag_dm = args2 = bits[2].split(",");
                        int tag_type2 = args2.length;
                        int min = 0;
                        while (min < tag_type2) {
                            block223: {
                                String arg = tag_dm[min];
                                try {
                                    String[] x = arg.split("=");
                                    if (x.length != 2) {
                                        throw new Exception("expected <name=value> argument, got '" + arg + "'");
                                    }
                                    String lhs = x[0].toLowerCase();
                                    if (lhs.equals("min_space")) {
                                        try {
                                            long amount = this.parseRate(x[1]);
                                            new_storage_details.add(new StorageDetails(root_hit, FileUtil.getFileStoreNames(root_hit)[0], amount));
                                            break block223;
                                        }
                                        catch (Throwable e) {
                                            throw new Exception("invalid amount in '" + arg + "'");
                                        }
                                    }
                                    throw new Exception("invalid argument: '" + arg + "'");
                                }
                                catch (Throwable e) {
                                    result.add("'" + line + "': invalid storage specification, " + e.getMessage());
                                }
                            }
                            ++min;
                        }
                    }
                    ++tag_type;
                }
                if (root_hit != null) continue;
                result.add("'" + line + "': invalid storage specification, root '" + root_name + "' not found. Valid roots are " + valid_roots);
                continue;
            }
            String[] _bits = line.split(" ");
            ArrayList<String> bits5 = new ArrayList<String>();
            String[] root = _bits;
            int valid_roots = _bits.length;
            int root_hit = 0;
            while (root_hit < valid_roots) {
                String b = root[root_hit];
                if ((b = b.trim()).length() > 0) {
                    bits5.add(b);
                }
                ++root_hit;
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (bits5.size() >= 6) {
                String freq_str = ((String)bits5.get(0)).toLowerCase(Locale.US);
                byte freq = 0;
                if (freq_str.equals("daily")) {
                    freq = 127;
                } else if (freq_str.equals("weekdays")) {
                    freq = 31;
                } else if (freq_str.equals("weekends")) {
                    freq = 96;
                } else if (freq_str.equals("mon")) {
                    freq = 1;
                } else if (freq_str.equals("tue")) {
                    freq = 2;
                } else if (freq_str.equals("wed")) {
                    freq = 4;
                } else if (freq_str.equals("thu")) {
                    freq = 8;
                } else if (freq_str.equals("fri")) {
                    freq = 16;
                } else if (freq_str.equals("sat")) {
                    freq = 32;
                } else if (freq_str.equals("sun")) {
                    freq = 64;
                } else {
                    errors.add("frequency '" + freq_str + "' is invalid");
                }
                String profile = (String)bits5.get(1);
                if (!this.profileExists(profile) && !this.predefined_profile_names.contains(profile.toLowerCase())) {
                    errors.add("profile '" + profile + "' not found");
                    profile = null;
                }
                int from_mins = -1;
                if (((String)bits5.get(2)).equalsIgnoreCase("from")) {
                    from_mins = this.getMins((String)bits5.get(3));
                }
                if (from_mins == -1) {
                    errors.add("'from' is invalid");
                }
                int to_mins = -1;
                if (((String)bits5.get(4)).equalsIgnoreCase("to")) {
                    to_mins = this.getMins((String)bits5.get(5));
                }
                if (to_mins == -1) {
                    errors.add("'to' is invalid");
                }
                ArrayList<ScheduleRuleExtensions> extensions = null;
                int i = 6;
                while (i < bits5.size()) {
                    String ext_cmd;
                    String extension = (String)bits5.get(i);
                    String[] temp = extension.split(":");
                    boolean ok = false;
                    String extra = "";
                    if (temp.length == 1) {
                        ext_cmd = temp[0];
                        if (ext_cmd.equals("enable_priority") || ext_cmd.equals("disable_priority")) {
                            if (extensions == null) {
                                extensions = new ArrayList<ScheduleRuleExtensions>(bits5.size() - 6);
                            }
                            int et = ext_cmd.equals("enable_priority") ? 5 : 6;
                            extensions.add(new ScheduleRuleExtensions(et));
                            ok = true;
                        }
                    } else if (temp.length == 2) {
                        ext_cmd = temp[0];
                        String ext_param = temp[1];
                        if (ext_cmd.equals("start_tag") || ext_cmd.equals("stop_tag") || ext_cmd.equals("pause_tag") || ext_cmd.equals("resume_tag")) {
                            TagDownload tag = (TagDownload)TagManagerFactory.getTagManager().getTagType(3).getTag(ext_param, true);
                            if (tag == null) {
                                tag = (TagDownload)TagManagerFactory.getTagManager().getTagType(2).getTag(ext_param, true);
                            }
                            if (tag == null) {
                                extra = ", tag '" + ext_param + "' not found";
                            } else {
                                if (extensions == null) {
                                    extensions = new ArrayList(bits5.size() - 6);
                                }
                                int et = ext_cmd.equals("start_tag") ? 1 : (ext_cmd.equals("stop_tag") ? 2 : (ext_cmd.equals("pause_tag") ? 3 : 4));
                                extensions.add(new ScheduleRuleExtensions(et, tag));
                                ok = true;
                            }
                        } else if (ext_cmd.equals("enable_net_limit") || ext_cmd.equals("disable_net_limit")) {
                            ArrayList<NetLimit> limits = new ArrayList<NetLimit>();
                            String[] nls = ext_param.split(";");
                            ArrayList<String> missing = new ArrayList<String>();
                            String[] stringArray = nls;
                            int n = nls.length;
                            int n6 = 0;
                            while (n6 < n) {
                                String nl = stringArray[n6];
                                nl = nl.trim();
                                boolean found = false;
                                for (NetLimit x : this.net_limits_all) {
                                    if (!x.getName().equals(nl)) continue;
                                    limits.add(x);
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    missing.add(nl);
                                }
                                ++n6;
                            }
                            if (missing.size() == 0) {
                                int et = ext_cmd.equals("enable_net_limit") ? 7 : 8;
                                ok = true;
                                if (extensions == null) {
                                    extensions = new ArrayList(bits5.size() - 6);
                                }
                                extensions.add(new ScheduleRuleExtensions(et, limits));
                            } else {
                                extra = ", net_limit(s) '" + missing + "' not found";
                            }
                        }
                    }
                    if (!ok) {
                        errors.add("extension '" + extension + "' is invalid" + extra);
                    }
                    ++i;
                }
                if (errors.size() == 0) {
                    rules.add(new ScheduleRule(freq, profile, from_mins, to_mins, extensions));
                    continue;
                }
                String err_str = "";
                for (String e : errors) {
                    err_str = String.valueOf(err_str) + (err_str.length() == 0 ? "" : ", ") + e;
                }
                result.add("'" + line + "' is invalid (" + err_str + ") - use <frequency> <profile> from <hh:mm> to <hh:mm>");
                continue;
            }
            result.add("'" + line + "' is invalid: use <frequency> <profile> from <hh:mm> to <hh:mm> [extensions]*");
        }
        boolean schedule_has_net_limits = false;
        boolean schedule_has_pausing = false;
        if (enabled) {
            this.preserve_inactive_limits = preserve_limits;
            this.pause_forced_downloads = pause_forced;
            if (start_of_day && rules.isEmpty()) {
                this.setActiveState(1);
            }
            if (new_net_limits_all.size() > 0) {
                schedule_has_net_limits = true;
            }
            for (ScheduleRule rule : rules) {
                String profile_name = rule.profile_name;
                if (!profile_name.equalsIgnoreCase("pause_all") && !profile_name.equalsIgnoreCase("resume_all")) continue;
                schedule_has_pausing = true;
                break;
            }
        }
        if (!schedule_has_pausing) {
            this.setRulePauseAllActive(false);
        }
        if (!schedule_has_net_limits) {
            this.setNetLimitPauseAllActive(false);
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.pa_capable", enabled && (schedule_has_pausing || schedule_has_net_limits));
        if (enabled) {
            this.current_rules = rules;
            for (PeerSet s : this.current_ip_sets.values()) {
                s.destroy();
            }
            this.current_ip_sets.clear();
            this.initialiseIPSets(ip_sets);
            this.checkIPSets();
            if (!lts_enabled) {
                new_net_limits_by_type.clear();
                new_net_limits_all.clear();
            }
            this.net_limits_by_type = new_net_limits_by_type;
            this.net_limits_all = new_net_limits_all;
            if (this.net_limits_all.size() > 0) {
                for (NetLimit n : this.net_limits_all) {
                    n.initialise();
                }
                if (!this.net_limit_listener_added) {
                    this.net_limit_listener_added = true;
                    StatsFactory.getLongTermStats().addListener(0x100000L, this);
                }
                this.updated(StatsFactory.getLongTermStats());
            } else if (this.net_limit_listener_added) {
                this.net_limit_listener_added = false;
                StatsFactory.getLongTermStats().removeListener(this);
            }
            this.current_prioritisers = new_prioritisers;
            if (new_prioritisers.size() == 0) {
                if (this.prioritiser_event != null) {
                    this.prioritiser_event.cancel();
                    this.prioritiser_event = null;
                }
            } else {
                for (Prioritiser p : new_prioritisers) {
                    p.initialise();
                }
                if (this.prioritiser_event == null) {
                    this.prioritiser_event = SimpleTimer.addPeriodicEvent("speed handler prioritiser", 5000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            SpeedLimitHandler.this.checkPrioritisers();
                        }
                    });
                }
            }
            this.current_storage_details = new_storage_details;
            if (this.current_storage_details.size() == 0) {
                if (this.storage_event != null) {
                    this.storage_event.cancel();
                    this.storage_event = null;
                }
            } else if (this.storage_event == null) {
                this.storage_event = SimpleTimer.addPeriodicEvent("speed handler storage checker", 15000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        SpeedLimitHandler.this.checkStorage();
                    }
                });
            }
            if (this.schedule_event == null && (rules.size() > 0 || this.net_limits_all.size() > 0)) {
                this.schedule_event = SimpleTimer.addPeriodicEvent("speed handler scheduler", 30000L, new TimerEventPerformer(){
                    private int tick_count;

                    @Override
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        SpeedLimitHandler.this.checkSchedule(false, this.tick_count);
                    }
                });
            }
            if (this.active_rule != null || rules.size() > 0 || this.net_limits_all.size() > 0) {
                this.checkSchedule(start_of_day, 0);
            }
        } else {
            this.current_rules.clear();
            if (this.schedule_event != null) {
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (this.active_rule != null) {
                this.active_rule = null;
                this.setProfileActive(null);
            }
            for (PeerSet s : this.current_ip_sets.values()) {
                s.destroy();
            }
            this.current_ip_sets.clear();
            this.checkIPSets();
            if (this.net_limit_pause_all_active) {
                this.setNetLimitPauseAllActive(false);
            }
            this.net_limits_by_type.clear();
            this.net_limits_all.clear();
            if (this.net_limit_listener_added) {
                this.net_limit_listener_added = false;
                StatsFactory.getLongTermStats().removeListener(this);
            }
            this.setActiveState(1);
        }
        if (!this.preserve_inactive_limits && this.profileExists(INACTIVE_PROFILE_NAME)) {
            this.deleteProfile(INACTIVE_PROFILE_NAME);
        }
        this.is_enabled = enabled;
        return result;
    }

    private long parseRate(String str) {
        int pos = (str = str.toLowerCase(Locale.US)).indexOf("/");
        if (pos != -1) {
            str = str.substring(0, pos).trim();
        }
        String num = "";
        long mult = 1L;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                if (c == 'k') {
                    mult = 1024L;
                    break;
                }
                if (c == 'm') {
                    mult = 0x100000L;
                    break;
                }
                if (c == 'g') {
                    mult = 0x40000000L;
                    break;
                }
                if (c == 't') {
                    mult = 0x10000000000L;
                    break;
                }
                if (c != 'e') break;
                mult = 0x4000000000000L;
                break;
            }
            num = String.valueOf(num) + c;
            ++i;
        }
        if (num.contains(".")) {
            return (long)(Float.parseFloat(num) * (float)mult);
        }
        return (long)Integer.parseInt(num) * mult;
    }

    public boolean isEnabled() {
        return this.is_enabled;
    }

    public void addConfigLine(String line, boolean auto_enable) {
        List<String> lines = this.getSchedule();
        if (!this.is_enabled && auto_enable) {
            lines.add("enable=yes");
        }
        lines.add(line);
        this.setSchedule(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerSet> getPeerSets() {
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            return new ArrayList<PeerSet>(this.current_ip_sets.values());
        }
    }

    private int getMins(String str) {
        try {
            String[] bits = str.split(":");
            if (bits.length == 2) {
                return Integer.parseInt(bits[0].trim()) * 60 + Integer.parseInt(bits[1].trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    private void checkIPSets() {
        this.check_ip_sets_limiter.dispatch();
    }

    private void initialiseIPSets(Map<String, PeerSet> sets) {
        int id_max;
        String config_max_key = "speed.limit.handler.ipset_n.max";
        HashSet<Integer> id_allocated = new HashSet<Integer>();
        HashMap<PeerSet, Integer> id_map = new HashMap<PeerSet, Integer>();
        int original_id_max = id_max = COConfigurationManager.getIntParameter(config_max_key, -1);
        int i = 0;
        while (i < 2) {
            for (PeerSet s : i == 0 ? this.current_ip_sets.values() : sets.values()) {
                String name = s.getName();
                try {
                    String config_key = "speed.limit.handler.ipset_n." + Base32.encode(name.getBytes("UTF-8"));
                    int existing = COConfigurationManager.getIntParameter(config_key, -1);
                    if (existing == -1) continue;
                    if (id_allocated.contains(existing)) {
                        COConfigurationManager.removeParameter(config_key);
                        continue;
                    }
                    id_allocated.add(existing);
                    id_map.put(s, existing);
                    id_max = Math.max(id_max, existing);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            ++i;
        }
        for (PeerSet s : sets.values()) {
            String name = s.getName();
            try {
                String config_key = "speed.limit.handler.ipset_n." + Base32.encode(name.getBytes("UTF-8"));
                Integer tag_id = (Integer)id_map.get(s);
                if (tag_id == null) {
                    tag_id = ++id_max;
                    COConfigurationManager.setParameter(config_key, tag_id);
                }
                s.initialise(tag_id);
                this.current_ip_sets.put(s.getName(), s);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (id_max > original_id_max) {
            COConfigurationManager.setParameter(config_max_key, id_max);
            COConfigurationManager.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkIPSetsSupport() {
        Download[] downloads;
        DownloadManager download_manager = this.plugin_interface.getDownloadManager();
        if (this.current_dml != null) {
            this.current_dml.destroy();
            this.current_dml = null;
        }
        Download[] downloadArray = downloads = download_manager.getDownloads();
        int n = downloads.length;
        int n2 = 0;
        while (n2 < n) {
            PeerManager pm;
            Download dm = downloadArray[n2];
            if (!dm.getFlag(512L) && (pm = dm.getPeerManager()) != null) {
                Peer[] peers;
                Peer[] peerArray = peers = pm.getPeers();
                int n3 = peers.length;
                int n4 = 0;
                while (n4 < n3) {
                    List<RateLimiter> to_be_removed;
                    Object object;
                    RateLimiter l;
                    RateLimiter[] lims;
                    Peer peer = peerArray[n4];
                    RateLimiter[] rateLimiterArray = lims = peer.getRateLimiters(false);
                    int n5 = lims.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        l = rateLimiterArray[n6];
                        if (this.ip_set_rate_limiters_down.containsValue(l)) {
                            object = RL_TO_BE_REMOVED_LOCK;
                            synchronized (object) {
                                to_be_removed = (ArrayList<RateLimiter>)peer.getUserData(RLD_TO_BE_REMOVED_KEY);
                                if (to_be_removed == null) {
                                    to_be_removed = new ArrayList<RateLimiter>();
                                    peer.setUserData(RLD_TO_BE_REMOVED_KEY, to_be_removed);
                                }
                                to_be_removed.add(l);
                            }
                        }
                        ++n6;
                    }
                    rateLimiterArray = lims = peer.getRateLimiters(true);
                    n5 = lims.length;
                    n6 = 0;
                    while (n6 < n5) {
                        l = rateLimiterArray[n6];
                        if (this.ip_set_rate_limiters_up.containsValue(l)) {
                            object = RL_TO_BE_REMOVED_LOCK;
                            synchronized (object) {
                                to_be_removed = (List)peer.getUserData(RLU_TO_BE_REMOVED_KEY);
                                if (to_be_removed == null) {
                                    to_be_removed = new ArrayList();
                                    peer.setUserData(RLU_TO_BE_REMOVED_KEY, to_be_removed);
                                }
                                to_be_removed.add(l);
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.ip_set_rate_limiters_down.clear();
        this.ip_set_rate_limiters_up.clear();
        HashSet has_cats_or_tags = new HashSet();
        for (PeerSet set : this.current_ip_sets.values()) {
            this.ip_set_rate_limiters_down.put(set.getName(), set.getDownLimiter());
            this.ip_set_rate_limiters_up.put(set.getName(), set.getUpLimiter());
            Set cot = set.getCategoriesOrTags();
            if (cot != null) {
                has_cats_or_tags.addAll(cot);
            }
            set.removeAllPeers();
        }
        if (this.current_ip_sets.size() == 0) {
            if (this.ip_set_event != null) {
                this.ip_set_event.cancel();
                this.ip_set_event = null;
            }
        } else {
            if (this.ip_set_event == null) {
                this.ip_set_event = SimpleTimer.addPeriodicEvent("speed handler ip set scheduler", 1000L, new TimerEventPerformer(){
                    private int tick_count;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        SpeedLimitHandler speedLimitHandler = SpeedLimitHandler.this;
                        synchronized (speedLimitHandler) {
                            for (PeerSet set : SpeedLimitHandler.this.current_ip_sets.values()) {
                                set.updateStats(this.tick_count);
                            }
                        }
                    }
                });
            }
            this.current_dml = new DML(download_manager, has_cats_or_tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void peersAdded(Download download, PeerManager peer_manager, Peer[] peers) {
        has_ccs = false;
        has_nets = false;
        category_or_tags = null;
        tm = TagManagerFactory.getTagManager();
        var12_8 = this;
        synchronized (var12_8) {
            len = this.current_ip_sets.size();
            sets = new PeerSet[len];
            set_ranges = new long[len][][];
            set_ccs = new Set[len];
            set_nets = new Set[len];
            pos = 0;
            var16_15 = this.current_ip_sets.values().iterator();
            while (var16_15.hasNext()) {
                sets[pos] = set = var16_15.next();
                set_ranges[pos] = PeerSet.access$24(set);
                set_ccs[pos] = PeerSet.access$25(set);
                set_nets[pos] = PeerSet.access$26(set);
                if (set_ccs[pos].size() > 0) {
                    has_ccs = true;
                }
                if (set_nets[pos].size() > 0) {
                    has_nets = true;
                }
                ++pos;
                if (category_or_tags != null || PeerSet.access$21(set) == null) continue;
                category_or_tags = new HashSet<String>();
                cat = download.getAttribute(this.category_attribute);
                if (cat != null && cat.length() > 0) {
                    category_or_tags.add(cat);
                }
                tags = tm.getTagsForTaggable(3, (Taggable)PluginCoreUtils.unwrap(download));
                for (Tag t : tags) {
                    category_or_tags.add(t.getTagName(true));
                }
            }
        }
        if (sets.length == 0) {
            return;
        }
        var15_16 = peers;
        var14_14 = peers.length;
        var13_9 = 0;
        while (var13_9 < var14_14) {
            block48: {
                peer = var15_16[var13_9];
                tags = SpeedLimitHandler.RL_TO_BE_REMOVED_LOCK;
                synchronized (tags) {
                    rlu_tbr = (List)peer.getUserData(SpeedLimitHandler.RLU_TO_BE_REMOVED_KEY);
                    rld_tbr = (List)peer.getUserData(SpeedLimitHandler.RLD_TO_BE_REMOVED_KEY);
                    if (rlu_tbr != null) {
                        peer.setUserData(SpeedLimitHandler.RLU_TO_BE_REMOVED_KEY, null);
                    }
                    if (rld_tbr != null) {
                        peer.setUserData(SpeedLimitHandler.RLD_TO_BE_REMOVED_KEY, null);
                    }
                }
                try {
                    entry = (long[])peer.getUserData(SpeedLimitHandler.ip_set_peer_key);
                    if (entry == null) {
                        l_address = 0L;
                        ip = peer.getIp();
                        if (!ip.contains(":") && (bytes = HostNameToIPResolver.hostAddressToBytes(ip)) != null) {
                            l_address = (long)(bytes[0] << 24 & -16777216 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 65280 | bytes[3] & 255) & 0xFFFFFFFFL;
                        }
                        entry = new long[]{l_address};
                        peer.setUserData(SpeedLimitHandler.ip_set_peer_key, entry);
                    } else {
                        l_address = entry[0];
                    }
                    peer_cc = null;
                    peer_net = null;
                    if (has_ccs) {
                        details = PeerUtils.getCountryDetails(peer);
                        peer_cc = details != null && details.length > 0 ? details[0] : "??";
                    }
                    if (has_nets) {
                        peer_net = AENetworkClassifier.categoriseAddress(peer.getIp());
                    }
                    added_to_sets = new HashSet<PeerSet>();
                    if (l_address != 0L) {
                        i = 0;
                        while (i < set_ranges.length) {
                            ranges = set_ranges[i];
                            if (ranges.length != 0) {
                                set = sets[i];
                                is_inverse = PeerSet.access$27(set);
                                set_cats_or_tags = PeerSet.access$21(set);
                                if (set_cats_or_tags == null || new HashSet<E>(set_cats_or_tags).removeAll(category_or_tags)) {
                                    hit = false;
                                    var33_38 = ranges;
                                    var32_37 = ranges.length;
                                    var31_36 = 0;
                                    while (var31_36 < var32_37) {
                                        range = var33_38[var31_36];
                                        if (l_address >= range[0] && l_address <= range[1]) {
                                            hit = true;
                                            if (is_inverse) break;
                                            this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                                            added_to_sets.add(set);
                                            break;
                                        }
                                        ++var31_36;
                                    }
                                    if (is_inverse && !hit) {
                                        this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                                        added_to_sets.add(set);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    if (peer_cc != null) {
                        i = 0;
                        while (i < set_ccs.length) {
                            set = sets[i];
                            if (!added_to_sets.contains(set) && (ccs = set_ccs[i]).size() != 0) {
                                not_inverse = PeerSet.access$27(set) == false;
                                set_cats_or_tags = PeerSet.access$21(set);
                                if ((set_cats_or_tags == null || new HashSet<E>(set_cats_or_tags).removeAll(category_or_tags)) && (hit = ccs.contains(peer_cc)) == not_inverse) {
                                    this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                                    added_to_sets.add(set);
                                }
                            }
                            ++i;
                        }
                    }
                    if (peer_net != null) {
                        pub_peer_net = null;
                        pub_lan = null;
                        if (peer_net == "Public") {
                            try {
                                address = InetAddress.getByName(peer.getIp()).getAddress();
                                pub_peer_net = address.length == 4 ? "IPv4" : "IPv6";
                            }
                            catch (Throwable address) {
                                // empty catch block
                            }
                            pub_lan = peer.isLANLocal() != false ? "LAN" : "WAN";
                        }
                        i = 0;
                        while (i < set_nets.length) {
                            set = sets[i];
                            if (!added_to_sets.contains(set) && (nets = set_nets[i]).size() != 0) {
                                not_inverse = PeerSet.access$27(set) == false;
                                set_cats_or_tags = PeerSet.access$21(set);
                                if (set_cats_or_tags == null || new HashSet<E>(set_cats_or_tags).removeAll(category_or_tags)) {
                                    hit = nets.contains(peer_net);
                                    if (!hit) {
                                        if (pub_peer_net != null) {
                                            hit = nets.contains(pub_peer_net);
                                        }
                                        if (!hit && pub_lan != null) {
                                            hit = nets.contains(pub_lan);
                                        }
                                    }
                                    if (hit == not_inverse) {
                                        this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                                        added_to_sets.add(set);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    if (rlu_tbr == null) break block48;
                    var36_40 = rlu_tbr.iterator();
                    if (true) ** GOTO lbl162
                }
                {
                }
                do {
                    l = (RateLimiter)var36_40.next();
                    peer.removeRateLimiter(l, true);
lbl162:
                    // 2 sources

                } while (var36_40.hasNext());
            }
            if (rld_tbr != null) {
                for (RateLimiter l : rld_tbr) {
                    peer.removeRateLimiter(l, false);
                }
            }
            ++var13_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peerRemoved(Download download, PeerManager peer_manager, Peer peer) {
        Collection<PeerSet> sets;
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            if (this.current_ip_sets.size() == 0) {
                return;
            }
            sets = this.current_ip_sets.values();
        }
        for (PeerSet s : sets) {
            s.removePeer(peer_manager, peer);
        }
    }

    private void addLimiters(PeerManager peer_manager, Peer peer, PeerSet set, List<RateLimiter> up_to_be_removed, List<RateLimiter> down_to_be_removed) {
        int peer_down;
        int peer_up;
        RateLimiter e;
        boolean matched = false;
        RateLimiter l = set.getUpLimiter();
        RateLimiter[] existing = peer.getRateLimiters(true);
        boolean found = false;
        RateLimiter[] rateLimiterArray = existing;
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            e = rateLimiterArray[n2];
            if (e == l) {
                found = true;
                break;
            }
            ++n2;
        }
        if (found) {
            if (up_to_be_removed != null && up_to_be_removed.remove(l)) {
                matched = true;
            }
        } else {
            peer.addRateLimiter(l, true);
            matched = true;
        }
        l = set.getDownLimiter();
        existing = peer.getRateLimiters(false);
        found = false;
        rateLimiterArray = existing;
        n = existing.length;
        n2 = 0;
        while (n2 < n) {
            e = rateLimiterArray[n2];
            if (e == l) {
                found = true;
                break;
            }
            ++n2;
        }
        if (found) {
            if (down_to_be_removed != null && down_to_be_removed.remove(l)) {
                matched = true;
            }
        } else {
            peer.addRateLimiter(l, false);
            matched = true;
        }
        if (matched) {
            set.addPeer(peer_manager, peer);
        }
        if ((peer_up = set.getPeerUpLimit()) > 0) {
            peer.getStats().setUploadRateLimit(peer_up);
        }
        if ((peer_down = set.getPeerDownLimit()) > 0) {
            peer.getStats().setDownloadRateLimit(peer_down);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPrioritisers() {
        ArrayList<Prioritiser> prioritisers;
        Object object = this;
        synchronized (object) {
            prioritisers = new ArrayList<Prioritiser>(this.current_prioritisers);
        }
        object = this.extensions_lock;
        synchronized (object) {
            for (Prioritiser p : prioritisers) {
                p.check();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStorage() {
        ArrayList<StorageDetails> storage;
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            storage = new ArrayList<StorageDetails>(this.current_storage_details);
        }
        for (StorageDetails details : storage) {
            details.check();
        }
    }

    private ScheduleRule getActiveRule(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int day_of_week = cal.get(7);
        int hour_of_day = cal.get(11);
        int min_of_hour = cal.get(12);
        int day = -1;
        switch (day_of_week) {
            case 2: {
                day = 1;
                break;
            }
            case 3: {
                day = 2;
                break;
            }
            case 4: {
                day = 4;
                break;
            }
            case 5: {
                day = 8;
                break;
            }
            case 6: {
                day = 16;
                break;
            }
            case 7: {
                day = 32;
                break;
            }
            case 1: {
                day = 64;
            }
        }
        int min_of_day = hour_of_day * 60 + min_of_hour;
        ScheduleRule latest_match = null;
        for (ScheduleRule main_rule : this.current_rules) {
            List sub_rules = main_rule.splitByDay();
            for (ScheduleRule rule : sub_rules) {
                if ((rule.frequency & day) == 0 || rule.from_mins > min_of_day || rule.to_mins < min_of_day) continue;
                latest_match = main_rule;
            }
        }
        return latest_match;
    }

    private void setProfileActive(String profile_name) {
        int active_state = this.getActiveState();
        if (profile_name == null) {
            if (this.preserve_inactive_limits && this.profileExists(INACTIVE_PROFILE_NAME)) {
                if (active_state == 2 && this.rule_pause_all_active) {
                    this.setRulePauseAllActive(false);
                }
                this.loadProfile(INACTIVE_PROFILE_NAME);
            } else {
                this.resetRules();
            }
            this.setActiveState(1);
        } else {
            if (active_state == 1 && this.preserve_inactive_limits) {
                this.saveProfile(INACTIVE_PROFILE_NAME);
            }
            this.loadProfile(profile_name);
            this.setActiveState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchedule(boolean start_of_day, int tick_count) {
        ScheduleRule current_rule;
        GlobalManager gm = this.core.getGlobalManager();
        Object object = this;
        synchronized (object) {
            current_rule = this.active_rule;
            ScheduleRule latest_match = this.getActiveRule(new Date());
            if (latest_match == null) {
                this.active_rule = null;
                if (start_of_day || current_rule != null) {
                    this.setProfileActive(null);
                }
            } else {
                String profile_name = latest_match.profile_name;
                boolean is_rule_pause_all = false;
                if (this.active_rule == null || !this.active_rule.sameAs(latest_match)) {
                    String lc_profile_name = profile_name.toLowerCase();
                    if (this.predefined_profile_names.contains(lc_profile_name)) {
                        if (lc_profile_name.equals("pause_all")) {
                            this.active_rule = latest_match;
                            is_rule_pause_all = true;
                            this.setRulePauseAllActive(true);
                        } else if (lc_profile_name.equals("resume_all")) {
                            this.active_rule = latest_match;
                            this.setRulePauseAllActive(false);
                        } else if (lc_profile_name.equals("null")) {
                            this.active_rule = latest_match;
                        } else {
                            Debug.out("Unknown pre-def name '" + profile_name + "'");
                        }
                    } else if (this.profileExists(profile_name)) {
                        this.active_rule = latest_match;
                        this.setProfileActive(profile_name);
                    } else if (this.active_rule != null) {
                        this.active_rule = null;
                        this.setProfileActive(null);
                    }
                } else {
                    this.active_rule = latest_match;
                    is_rule_pause_all = this.rule_pause_all_active;
                }
                if (this.rule_pause_all_active) {
                    if (!is_rule_pause_all) {
                        this.setRulePauseAllActive(false);
                    } else if (gm.canPauseDownloads(this.pause_forced_downloads)) {
                        this.gm_dispatcher.dispatch(() -> gm.pauseDownloads(this.pause_forced_downloads));
                    }
                }
            }
        }
        object = this.extensions_lock;
        synchronized (object) {
            this.prioritiser_enabled = true;
            for (NetLimit n : this.net_limits_all) {
                n.setEnabled(true);
            }
            if (this.active_rule != null) {
                this.active_rule.checkExtensions();
            }
        }
        if (!this.net_limit_pause_all_active && this.net_limits_all.size() > 0) {
            this.checkTagNetLimits(tick_count);
        }
        if (current_rule != this.active_rule && this.net_limits_all.size() > 0 || this.net_limit_pause_all_active) {
            this.updated(StatsFactory.getLongTermStats());
        }
        if (this.net_limit_pause_all_active && gm.canPauseDownloads(this.pause_forced_downloads)) {
            this.gm_dispatcher.dispatch(() -> gm.pauseDownloads(this.pause_forced_downloads));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchedule() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("# Enter rules on separate lines below this section - see https://wiki.biglybt.com/w/Speed_Limit_Scheduler for more details");
        result.add("# Rules are of the following types:");
        result.add("#    enable=(yes|no)   - controls whether the entire schedule is enabled or not (default=yes)");
        result.add("#    preserve_inactive_limits=(yes|no) - save existing limits when activating and reinstate on deactivation (default=no)");
        result.add("#    pause_force_downloads=(yes|no) - when pausing downloads also pause force-start ones (default=yes)");
        result.add("#    <frequency> <profile_name> from <time> to <time> [extension]*");
        result.add("#        frequency: daily|weekdays|weekends|<day_of_week>");
        result.add("#            day_of_week: mon|tue|wed|thu|fri|sat|sun");
        result.add("#        time: hh:mm - 24 hour clock; 00:00=midnight; local time");
        result.add("#        extension: (start_tag|stop_tag|pause_tag|resume_tag):<tag_name> (enable_priority|disable_priority)");
        result.add("#    peer_set <set_name>=[<CIDR_specs...>|CC list|Network List|<prior_set_name>] [,inverse=[yes|no]] [,up=<limit>] [,down=<limit>] [peer_up=<limit>] [peer_down=<limit>] [,cat=<cat names>] [,tag=<tag names>] [,client=<regular expression>|auto] [,intf=<regular expression>|auto] [,asn=<regular expression>]");
        result.add("#    net_limit (hourly|daily|weekly|monthly)[(:<profile>|$<tag>)] [total=<limit>] [up=<limit>] [down=<limit>]");
        result.add("#    priority_(up|down) <id>=<tag_name> [,<id>=<tag_name>]+ [,freq=<secs>] [,max=<limit>] [,probe=<cycles>]");
        result.add("#    storage (<root>|*) min_space=<space>");
        result.add("#");
        result.add("# For example - assuming there are profiles called 'no_limits' and 'limited_upload' defined:");
        result.add("#");
        result.add("#     daily no_limits from 00:00 to 23:59");
        result.add("#     daily limited_upload from 06:00 to 22:00 stop_tag:bigstuff");
        result.add("#     daily pause_all from 08:00 to 17:00");
        result.add("#");
        result.add("#     net_limit monthly total=250G          // flat monthly limit");
        result.add("#");
        result.add("#     net_limit monthly:no_limits                  // no monthly limit when no_limits active");
        result.add("#     net_limit monthly:limited_upload total=100G  // 100G a month limit when limited_upload active");
        result.add("#");
        result.add("#     peer_set external=211.34.128.0/19 211.35.128.0/17");
        result.add("#     peer_set Europe=EU;AD;AL;AT;BA;BE;BG;BY;CH;CS;CZ;DE;DK;EE;ES;FI;FO;FR;FX;GB;GI;GR;HR;HU;IE;IS;IT;LI;LT;LU;LV;MC;MD;MK;MT;NL;NO;PL;PT;RO;SE;SI;SJ;SK;SM;UA;VA");
        result.add("#     peer_set Blorp=Europe;US");
        result.add("#     peer_set BiglyBTPeers=Public;I2P;Tor,client=BiglyBT.*");
        result.add("#     peer_set AutoIntf=all,intf=auto");
        result.add("#");
        result.add("# When multiple rules apply the one further down the list of rules take precedence");
        result.add("# Currently peer_set limits are not schedulable");
        result.add("# Comment lines are prefixed with '#'");
        result.add("# Pre-defined profiles: " + this.predefined_profile_names);
        List<String> profiles = this.getProfileNames();
        if (profiles.size() == 0) {
            result.add("# No user profiles currently defined.");
        } else {
            ScheduleRule current_rule;
            String str = "";
            for (String s : profiles) {
                str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + s;
            }
            result.add("# Current profiles details:");
            result.add("#     defined: " + str);
            SpeedLimitHandler speedLimitHandler = this;
            synchronized (speedLimitHandler) {
                current_rule = this.active_rule;
            }
            result.add("#     active: " + (current_rule == null ? "none" : current_rule.profile_name));
        }
        result.add("# ---- Do not edit this line or any text above! ----");
        List lines_list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
        List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(lines_list));
        if (schedule_lines.size() == 0) {
            schedule_lines.add("");
            schedule_lines.add("");
        } else {
            for (String l : schedule_lines) {
                result.add(l.trim());
            }
        }
        return result;
    }

    public List<String> setSchedule(List<String> lines) {
        int trim_from = 0;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.startsWith("# ---- Do not edit")) {
                trim_from = i + 1;
            }
            ++i;
        }
        if (trim_from > 0) {
            lines = lines.subList(trim_from, lines.size());
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.lines", lines);
        COConfigurationManager.save();
        return this.loadSchedule(false);
    }

    private List<LimitedRateGroup> trim(LimitedRateGroup[] groups) {
        ArrayList<LimitedRateGroup> result = new ArrayList<LimitedRateGroup>();
        LimitedRateGroup[] limitedRateGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            LimitedRateGroup group = limitedRateGroupArray[n2];
            if (group instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                result.add(group);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void updated(LongTermStats stats2) {
        boolean exceeded = false;
        for (NetLimit limit : this.net_limits_all) {
            String profile;
            LongTermStats net_lts = limit.getLongTermStats();
            if (net_lts != null || (profile = limit.getProfile()) != null && (this.active_rule == null || !this.active_rule.profile_name.equals(profile))) continue;
            long[] usage = this.getLongTermUsage(stats2, limit.getType(), limit);
            long total_up = usage[0] + usage[1] + usage[4];
            long total_do = usage[2] + usage[3] + usage[5];
            long[] limits = limit.getLimits();
            if (limits[0] > 0L) {
                boolean bl = exceeded = total_up + total_do >= limits[0];
            }
            if (limits[1] > 0L && !exceeded) {
                boolean bl = exceeded = total_up >= limits[1];
            }
            if (limits[2] > 0L && !exceeded) {
                boolean bl = exceeded = total_do >= limits[2];
            }
            if (exceeded) break;
        }
        if (this.net_limit_pause_all_active != exceeded) {
            if (exceeded) {
                if (this.canPauseAll()) {
                    this.setNetLimitPauseAllActive(true);
                }
            } else {
                this.setNetLimitPauseAllActive(false);
            }
        }
    }

    private boolean canPauseAll() {
        GlobalManager gm = this.core.getGlobalManager();
        for (com.biglybt.core.download.DownloadManager dm : gm.getDownloadManagers()) {
            DiskManager disk_manager;
            int state = dm.getState();
            if (state == 70) continue;
            if (dm.getMoveProgress() != null || FileUtil.hasTask(dm)) {
                return false;
            }
            if (state == 30) {
                return false;
            }
            if (state != 60 || (disk_manager = dm.getDiskManager()) == null || disk_manager.getCompleteRecheckStatus() == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void checkTagNetLimits(int tick_count) {
        Object stats2;
        boolean do_log = tick_count % 2 == 0;
        String log_str = "";
        LinkedHashMap<TagFeatureRunState, ArrayList<Object[]>> rs_ops = new LinkedHashMap<TagFeatureRunState, ArrayList<Object[]>>();
        LinkedHashMap<TagFeatureRateLimit, ArrayList<Object[]>> rl_ops = new LinkedHashMap<TagFeatureRateLimit, ArrayList<Object[]>>();
        IdentityHashSet<Taggable> handled_dms = new IdentityHashSet<Taggable>();
        if (!this.pause_forced_downloads) {
            for (com.biglybt.core.download.DownloadManager dm : this.core.getGlobalManager().getDownloadManagers()) {
                if (!dm.isForceStart()) continue;
                handled_dms.add(dm);
            }
        }
        for (NetLimit limit : this.net_limits_all) {
            String name_str = "net_limit";
            String name = limit.getName();
            if (name.length() > 0) {
                name_str = String.valueOf(name_str) + " " + name;
            }
            if ((stats2 = (Object)limit.getLongTermStats()) == null) continue;
            TagFeatureRateLimit tagFeatureRateLimit = limit.getTag();
            Tag tag = tagFeatureRateLimit.getTag();
            long[] usage = this.getLongTermUsage((LongTermStats)stats2, limit.getType(), limit);
            long total_up = usage[0] + usage[1];
            long total_do = usage[2] + usage[3];
            boolean enabled = limit.isEnabled();
            log_str = String.valueOf(log_str) + (log_str.length() == 0 ? "" : "; ") + (name.length() == 0 ? "" : String.valueOf(name) + " ") + tag.getTagName(true) + ": up=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + ", down=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + ", enabled=" + enabled;
            long[] limits = limit.getLimits();
            boolean exceeded_up = false;
            boolean exceeded_down = false;
            boolean handled = false;
            if (enabled) {
                TagFeatureRunState rs;
                if (limits[0] > 0L) {
                    exceeded_down = total_up + total_do >= limits[0];
                    exceeded_up = exceeded_down;
                }
                if (limits[1] > 0L && !exceeded_up) {
                    boolean bl = exceeded_up = total_up >= limits[1];
                }
                if (limits[2] > 0L && !exceeded_down) {
                    boolean bl = exceeded_down = total_do >= limits[2];
                }
                if (tag instanceof TagFeatureRunState && (rs = (TagFeatureRunState)((Object)tag)).hasRunStateCapability(2)) {
                    boolean pause = exceeded_up && exceeded_down;
                    int op = pause ? 2 : 4;
                    ArrayList<Object[]> list = (ArrayList<Object[]>)rs_ops.get(rs);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        rs_ops.put(rs, list);
                    }
                    list.add(new Object[]{String.valueOf(name_str) + " : " + (pause ? "pausing" : "resuming") + " tag " + tag.getTagName(true), op});
                    handled = pause;
                }
            }
            if (handled) continue;
            int target_up = exceeded_up ? -1 : 0;
            int target_down = exceeded_down ? -1 : 0;
            ArrayList<Object[]> list = (ArrayList<Object[]>)rl_ops.get(tagFeatureRateLimit);
            if (list == null) {
                list = new ArrayList<Object[]>();
                rl_ops.put(tagFeatureRateLimit, list);
            }
            list.add(new Object[]{String.valueOf(name_str) + ": setting rates to " + this.format(target_up) + "/" + this.format(target_down) + " on tag " + tag.getTagName(true), target_up, target_down});
        }
        Predicate<Taggable> filter2 = taggable -> !handled_dms.contains(taggable);
        stats2 = new int[]{2, 4};
        int name = ((int[])stats2).length;
        int n = 0;
        while (n < name) {
            int op_to_do = stats2[n];
            for (Map.Entry entry : rs_ops.entrySet()) {
                boolean[] result;
                TagFeatureRunState tag_rs = (TagFeatureRunState)entry.getKey();
                List details = (List)entry.getValue();
                int selected_op = 4;
                String all_str = "";
                for (Object[] detail : details) {
                    String str = (String)detail[0];
                    all_str = String.valueOf(all_str) + (all_str.length() == 0 ? "" : ";") + str;
                    int op = (Integer)detail[1];
                    if (op != 2) continue;
                    selected_op = 2;
                }
                if (op_to_do != selected_op) continue;
                if (selected_op == 2) {
                    Set<Taggable> dms = tag_rs.getTag().getTagged();
                    for (Taggable t : dms) {
                        if (!((com.biglybt.core.download.DownloadManager)t).isPaused()) continue;
                        handled_dms.add(t);
                    }
                }
                if (!(result = tag_rs.getPerformableOperations(new int[]{selected_op}, filter2))[0]) continue;
                this.logger.log(all_str);
                do_log = true;
                List<Taggable> affected = tag_rs.performOperation(selected_op, filter2);
                if (selected_op != 2) continue;
                handled_dms.addAll(affected);
            }
            ++n;
        }
        for (Map.Entry entry : rl_ops.entrySet()) {
            void var12_23;
            TagFeatureRateLimit tag_rl = (TagFeatureRateLimit)entry.getKey();
            List details = (List)entry.getValue();
            String string = "";
            int selected_up = 0;
            int selected_down = 0;
            for (Object[] detail : details) {
                String str = (String)detail[0];
                String string2 = String.valueOf(var12_23) + (var12_23.length() == 0 ? "" : ";") + str;
                int up = (Integer)detail[1];
                int down = (Integer)detail[2];
                if (up == -1) {
                    selected_up = -1;
                }
                if (down != -1) continue;
                selected_down = -1;
            }
            int up_lim = tag_rl.getTagUploadLimit();
            int down_lim = tag_rl.getTagDownloadLimit();
            if (up_lim == selected_up && down_lim == selected_down) continue;
            this.logger.log((String)var12_23);
            do_log = true;
            tag_rl.setTagUploadLimit(selected_up);
            tag_rl.setTagDownloadLimit(selected_down);
        }
        if (log_str.length() > 0 && do_log) {
            this.logger.log("net_limit: current: " + log_str);
        }
    }

    private String formatUp(int rate) {
        return "Up=" + this.format(rate);
    }

    private String formatDown(int rate) {
        return "Down=" + this.format(rate);
    }

    private String format(int rate) {
        if (rate < 0) {
            return "Disabled";
        }
        if (rate == 0) {
            return "Unlimited";
        }
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(rate);
    }

    private String formatUp(List<LimitedRateGroup> groups) {
        return "Up=" + this.format(groups);
    }

    private String formatDown(List<LimitedRateGroup> groups) {
        return "Down=" + this.format(groups);
    }

    private String format(List<LimitedRateGroup> groups) {
        String str = "";
        for (LimitedRateGroup group : groups) {
            str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + group.getName() + ":" + this.format(group.getRateLimitBytesPerSecond());
        }
        return str;
    }

    private void exportBoolean(Map<String, Object> map, String key, boolean b) {
        map.put(key, b ? 1 : 0);
    }

    private boolean importBoolean(Map<String, Object> map, String key) {
        Long l = (Long)map.get(key);
        if (l != null) {
            return l == 1L;
        }
        return false;
    }

    private void exportInt(Map<String, Object> map, String key, int i) {
        map.put(key, new Long(i));
    }

    private int importInt(Map<String, Object> map, String key) {
        Long l = (Long)map.get(key);
        if (l != null) {
            return l.intValue();
        }
        return 0;
    }

    private void exportString(Map<String, Object> map, String key, String s) {
        try {
            map.put(key, s.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String importString(Map<String, Object> map, String key) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void dump(IndentWriter iw) {
        iw.println("Profiles");
        iw.indent();
        try {
            List<String> profiles = this.getProfileNames();
            for (String profile : profiles) {
                iw.println(profile);
                iw.indent();
                try {
                    List<String> p_lines = this.getProfileSupport(profile, true);
                    for (String line : p_lines) {
                        iw.println(line);
                    }
                }
                finally {
                    iw.exdent();
                }
            }
        }
        finally {
            iw.exdent();
        }
        iw.println("Schedule");
        iw.indent();
        try {
            List lines_list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
            List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(lines_list));
            for (String line : schedule_lines) {
                iw.println(line);
            }
        }
        finally {
            iw.exdent();
        }
    }

    private class DML
    implements DownloadManagerListener {
        private final Object lock;
        private final DownloadManager download_manager;
        private final Set<String> has_cats_or_tags;
        final Map<Download, List<Runnable>> listener_removers;
        private volatile boolean destroyed;

        private DML(DownloadManager _download_manager, Set<String> _has_cats_or_tags) {
            this.lock = SpeedLimitHandler.this;
            this.listener_removers = new IdentityHashMap<Download, List<Runnable>>();
            this.download_manager = _download_manager;
            this.has_cats_or_tags = _has_cats_or_tags;
            this.download_manager.addListener(this, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            Object object = this.lock;
            synchronized (object) {
                this.destroyed = true;
                this.download_manager.removeListener(this);
                for (List<Runnable> dl_listeners : this.listener_removers.values()) {
                    for (Runnable r : dl_listeners) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                this.listener_removers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadAdded(final Download download) {
            if (download.getFlag(512L)) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                List<Runnable> _dl_listeners = this.listener_removers.get(download);
                if (_dl_listeners == null) {
                    _dl_listeners = new ArrayList<Runnable>();
                    this.listener_removers.put(download, _dl_listeners);
                } else {
                    Debug.out("already present");
                }
                final List<Runnable> dl_listeners = _dl_listeners;
                if (!this.has_cats_or_tags.isEmpty()) {
                    final DownloadAttributeListener attr_listener = new DownloadAttributeListener(download){
                        String current_cat;
                        {
                            this.current_cat = download.getAttribute(((DML)DML.this).SpeedLimitHandler.this.category_attribute);
                        }

                        @Override
                        public void attributeEventOccurred(Download download, TorrentAttribute attribute, int event_type) {
                            String old_cat = this.current_cat;
                            this.current_cat = download.getAttribute(((DML)DML.this).SpeedLimitHandler.this.category_attribute);
                            if (DML.this.has_cats_or_tags.contains(old_cat) || DML.this.has_cats_or_tags.contains(this.current_cat)) {
                                SpeedLimitHandler.this.checkIPSets();
                            }
                        }
                    };
                    final TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                    final com.biglybt.core.download.DownloadManager core_download = PluginCoreUtils.unwrap(download);
                    final TagListener tag_listener = new TagListener(){

                        @Override
                        public void taggableSync(Tag tag) {
                        }

                        @Override
                        public void taggableRemoved(Tag tag, Taggable tagged) {
                            if (DML.this.has_cats_or_tags.contains(tag.getTagName(true))) {
                                SpeedLimitHandler.this.checkIPSets();
                            }
                        }

                        @Override
                        public void taggableAdded(Tag tag, Taggable tagged) {
                            if (DML.this.has_cats_or_tags.contains(tag.getTagName(true))) {
                                SpeedLimitHandler.this.checkIPSets();
                            }
                        }
                    };
                    download.addAttributeListener(attr_listener, SpeedLimitHandler.this.category_attribute, 1);
                    tt.addTagListener(core_download, tag_listener);
                    dl_listeners.add(new Runnable(){

                        @Override
                        public void run() {
                            download.removeAttributeListener(attr_listener, ((DML)DML.this).SpeedLimitHandler.this.category_attribute, 1);
                            tt.removeTagListener(core_download, tag_listener);
                        }
                    });
                }
                final DownloadPeerListener peer_listener = new DownloadPeerListener(){
                    private Runnable pm_listener_remover;
                    private PeerManager current_pm;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                        Object object = DML.this.lock;
                        synchronized (object) {
                            if (DML.this.destroyed) {
                                return;
                            }
                            final PeerManagerListener2 listener = new PeerManagerListener2(){

                                @Override
                                public void eventOccurred(PeerManagerEvent event2) {
                                    if (DML.this.destroyed) {
                                        return;
                                    }
                                    if (event2.getType() == 1) {
                                        SpeedLimitHandler.this.peersAdded(download, peer_manager, new Peer[]{event2.getPeer()});
                                    } else if (event2.getType() == 2) {
                                        SpeedLimitHandler.this.peerRemoved(download, peer_manager, event2.getPeer());
                                    }
                                }
                            };
                            peer_manager.addListener(listener);
                            if (this.pm_listener_remover != null) {
                                Debug.out("Old listener still active");
                            }
                            this.current_pm = peer_manager;
                            this.pm_listener_remover = new Runnable(){

                                @Override
                                public void run() {
                                    peer_manager.removeListener(listener);
                                }
                            };
                            dl_listeners.add(this.pm_listener_remover);
                        }
                        Peer[] peers = peer_manager.getPeers();
                        SpeedLimitHandler.this.peersAdded(download, peer_manager, peers);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                        Object object = DML.this.lock;
                        synchronized (object) {
                            if (peer_manager != this.current_pm) {
                                Debug.out("PM mismatch: " + this.current_pm + "/" + peer_manager);
                            }
                            this.current_pm = null;
                            if (dl_listeners.remove(this.pm_listener_remover)) {
                                this.pm_listener_remover.run();
                                this.pm_listener_remover = null;
                            }
                        }
                    }
                };
                download.addPeerListener(peer_listener);
                dl_listeners.add(new Runnable(){

                    @Override
                    public void run() {
                        download.removePeerListener(peer_listener);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadRemoved(Download download) {
            Object object = this.lock;
            synchronized (object) {
                List<Runnable> dl_listeners = this.listener_removers.remove(download);
                if (dl_listeners != null) {
                    for (Runnable r : dl_listeners) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        }
    }

    private static class IPSetTagType
    extends TagTypeWithState {
        private final int[] color_default = new int[]{132, 16, 57};

        private IPSetTagType() {
            super(4, 65, "tag.type.ipset");
            this.addTagType();
        }

        @Override
        public int[] getColorDefault() {
            return this.color_default;
        }
    }

    private class LimitDetails {
        private boolean auto_up_enabled;
        private boolean auto_up_seeding_enabled;
        private boolean seeding_limits_enabled;
        private int up_limit;
        private int up_seeding_limit;
        private int down_limit;
        private boolean lan_rates_enabled;
        private int lan_up_limit;
        private int lan_down_limit;
        private final Map<String, int[]> download_limits = new HashMap<String, int[]>();
        private final Map<String, int[]> category_limits = new HashMap<String, int[]>();
        private final Map<String, int[]> tag_limits = new HashMap<String, int[]>();

        private LimitDetails() {
        }

        private LimitDetails(Map<String, Object> map) {
            List t_list;
            List c_list;
            this.auto_up_enabled = SpeedLimitHandler.this.importBoolean(map, "aue");
            this.auto_up_seeding_enabled = SpeedLimitHandler.this.importBoolean(map, "ause");
            this.seeding_limits_enabled = SpeedLimitHandler.this.importBoolean(map, "sle");
            this.up_limit = SpeedLimitHandler.this.importInt(map, "ul");
            this.up_seeding_limit = SpeedLimitHandler.this.importInt(map, "usl");
            this.down_limit = SpeedLimitHandler.this.importInt(map, "dl");
            this.lan_rates_enabled = map.containsKey("lre") ? SpeedLimitHandler.this.importBoolean(map, "lre") : COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            this.lan_up_limit = SpeedLimitHandler.this.importInt(map, "lul");
            this.lan_down_limit = SpeedLimitHandler.this.importInt(map, "ldl");
            List d_list = (List)map.get("dms");
            if (d_list != null) {
                for (Map m : d_list) {
                    String k = SpeedLimitHandler.this.importString(m, "k");
                    if (k == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.download_limits.put(k, new int[]{ul, dl});
                }
            }
            if ((c_list = (List)map.get("cts")) != null) {
                for (Map m : c_list) {
                    String k = SpeedLimitHandler.this.importString(m, "k");
                    if (k == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.category_limits.put(k, new int[]{ul, dl});
                }
            }
            if ((t_list = (List)map.get("tgs")) != null) {
                for (Map m : t_list) {
                    String t = SpeedLimitHandler.this.importString(m, "k");
                    if (t == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.tag_limits.put(t, new int[]{ul, dl});
                }
            }
        }

        private Map<String, Object> export() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            SpeedLimitHandler.this.exportBoolean(map, "aue", this.auto_up_enabled);
            SpeedLimitHandler.this.exportBoolean(map, "ause", this.auto_up_seeding_enabled);
            SpeedLimitHandler.this.exportBoolean(map, "sle", this.seeding_limits_enabled);
            SpeedLimitHandler.this.exportInt(map, "ul", this.up_limit);
            SpeedLimitHandler.this.exportInt(map, "usl", this.up_seeding_limit);
            SpeedLimitHandler.this.exportInt(map, "dl", this.down_limit);
            SpeedLimitHandler.this.exportBoolean(map, "lre", this.lan_rates_enabled);
            SpeedLimitHandler.this.exportInt(map, "lul", this.lan_up_limit);
            SpeedLimitHandler.this.exportInt(map, "ldl", this.lan_down_limit);
            ArrayList d_list = new ArrayList();
            map.put("dms", d_list);
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                HashMap m = new HashMap();
                d_list.add(m);
                SpeedLimitHandler.this.exportString(m, "k", entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", entry.getValue()[0]);
                SpeedLimitHandler.this.exportInt(m, "d", entry.getValue()[1]);
            }
            ArrayList c_list = new ArrayList();
            map.put("cts", c_list);
            for (Map.Entry entry : this.category_limits.entrySet()) {
                HashMap m = new HashMap();
                c_list.add(m);
                SpeedLimitHandler.this.exportString(m, "k", (String)entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", ((int[])entry.getValue())[0]);
                SpeedLimitHandler.this.exportInt(m, "d", ((int[])entry.getValue())[1]);
            }
            ArrayList arrayList = new ArrayList();
            map.put("tgs", arrayList);
            for (Map.Entry<String, int[]> entry : this.tag_limits.entrySet()) {
                HashMap m = new HashMap();
                arrayList.add(m);
                SpeedLimitHandler.this.exportString(m, "k", entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", entry.getValue()[0]);
                SpeedLimitHandler.this.exportInt(m, "d", entry.getValue()[1]);
            }
            return map;
        }

        private void loadForReset() {
            this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        }

        private void loadCurrent() {
            this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
            this.auto_up_seeding_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
            this.seeding_limits_enabled = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
            this.up_limit = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
            this.up_seeding_limit = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs");
            this.down_limit = COConfigurationManager.getIntParameter("Max Download Speed KBs");
            this.lan_rates_enabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            this.lan_up_limit = COConfigurationManager.getIntParameter("Max LAN Upload Speed KBs");
            this.lan_down_limit = COConfigurationManager.getIntParameter("Max LAN Download Speed KBs");
            this.download_limits.clear();
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            List<com.biglybt.core.download.DownloadManager> downloads = gm.getDownloadManagers();
            for (com.biglybt.core.download.DownloadManager download : downloads) {
                TOTorrent torrent = download.getTorrent();
                byte[] hash = null;
                if (torrent != null) {
                    try {
                        hash = torrent.getHash();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (hash == null) continue;
                int download_up_limit = download.getStats().getUploadRateLimitBytesPerSecond();
                int download_down_limit = download.getStats().getDownloadRateLimitBytesPerSecond();
                if (download_up_limit <= 0 && download_up_limit >= 0 && download_down_limit <= 0 && download_down_limit >= 0) continue;
                this.download_limits.put(Base32.encode(hash), new int[]{download_up_limit, download_down_limit});
            }
            Category[] categories = CategoryManager.getCategories();
            this.category_limits.clear();
            Category[] download_up_limit = categories;
            int n = categories.length;
            int torrent = 0;
            while (torrent < n) {
                Category category = download_up_limit[torrent];
                int cat_up_limit = category.getUploadSpeed();
                int cat_down_limit = category.getDownloadSpeed();
                if (cat_up_limit > 0 || cat_down_limit > 0) {
                    this.category_limits.put(category.getName(), new int[]{cat_up_limit, cat_down_limit});
                }
                ++torrent;
            }
            List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
            this.tag_limits.clear();
            for (TagType tag_type : tag_types) {
                if (tag_type.getTagType() == 1 || !tag_type.hasTagTypeFeature(1L)) continue;
                List<Tag> tags = tag_type.getTags();
                for (Tag tag : tags) {
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    int tag_up_limit = rl.getTagUploadLimit();
                    int tag_down_limit = rl.getTagDownloadLimit();
                    if (tag_up_limit == 0 && tag_down_limit == 0) continue;
                    this.tag_limits.put(String.valueOf(tag_type.getTagType()) + "." + tag.getTagID(), new int[]{tag_up_limit, tag_down_limit});
                }
            }
        }

        private int[] getLimitsForDownload(String hash) {
            return this.download_limits.get(hash);
        }

        private void addRemoveDownloads(List<String> hashes, boolean add) {
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            for (String hash : hashes) {
                if (add) {
                    com.biglybt.core.download.DownloadManager download = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                    if (download == null) continue;
                    int download_up_limit = download.getStats().getUploadRateLimitBytesPerSecond();
                    int download_down_limit = download.getStats().getDownloadRateLimitBytesPerSecond();
                    if (download_up_limit <= 0 && download_up_limit >= 0 && download_down_limit <= 0 && download_down_limit >= 0) continue;
                    this.download_limits.put(hash, new int[]{download_up_limit, download_down_limit});
                    continue;
                }
                this.download_limits.remove(hash);
            }
        }

        private void apply() {
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.auto_up_enabled);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.auto_up_seeding_enabled);
            if (!this.auto_up_enabled && !this.auto_up_seeding_enabled) {
                COConfigurationManager.setParameter("Max Upload Speed KBs", this.up_limit);
            }
            COConfigurationManager.setParameter("enable.seedingonly.upload.rate", this.seeding_limits_enabled);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", this.up_seeding_limit);
            COConfigurationManager.setParameter("Max Download Speed KBs", this.down_limit);
            COConfigurationManager.setParameter("LAN Speed Enabled", this.lan_rates_enabled);
            COConfigurationManager.setParameter("Max LAN Upload Speed KBs", this.lan_up_limit);
            COConfigurationManager.setParameter("Max LAN Download Speed KBs", this.lan_down_limit);
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            HashSet<com.biglybt.core.download.DownloadManager> all_managers = new HashSet<com.biglybt.core.download.DownloadManager>(gm.getDownloadManagers());
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                byte[] hash = Base32.decode(entry.getKey());
                com.biglybt.core.download.DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                if (dm == null) continue;
                int[] limits = entry.getValue();
                dm.getStats().setUploadRateLimitBytesPerSecond(limits[0]);
                dm.getStats().setDownloadRateLimitBytesPerSecond(limits[1]);
                all_managers.remove(dm);
            }
            for (com.biglybt.core.download.DownloadManager dm : all_managers) {
                dm.getStats().setUploadRateLimitBytesPerSecond(0);
                dm.getStats().setDownloadRateLimitBytesPerSecond(0);
            }
            HashSet<Category> all_categories = new HashSet<Category>(Arrays.asList(CategoryManager.getCategories()));
            HashMap<String, Category> cat_map = new HashMap<String, Category>();
            for (Category c : all_categories) {
                cat_map.put(c.getName(), c);
            }
            for (Map.Entry<String, int[]> entry : this.category_limits.entrySet()) {
                String cat_name = entry.getKey();
                Category category = (Category)cat_map.get(cat_name);
                if (category == null) continue;
                int[] limits = entry.getValue();
                category.setUploadSpeed(limits[0]);
                category.setDownloadSpeed(limits[1]);
                all_categories.remove(category);
            }
            for (Category category : all_categories) {
                category.setUploadSpeed(0);
                category.setDownloadSpeed(0);
            }
            TagManager tm = TagManagerFactory.getTagManager();
            List<TagType> all_tts = tm.getTagTypes();
            HashSet<Tag> all_rl_tags = new HashSet<Tag>();
            for (TagType tagType : all_tts) {
                if (tagType.getTagType() == 1 || !tagType.hasTagTypeFeature(1L)) continue;
                all_rl_tags.addAll(tagType.getTags());
            }
            for (Map.Entry entry : this.tag_limits.entrySet()) {
                String tag_key = (String)entry.getKey();
                String[] bits = tag_key.split("\\.");
                try {
                    Tag tag;
                    int tag_type = Integer.parseInt(bits[0]);
                    int tag_id = Integer.parseInt(bits[1]);
                    TagType tt = tm.getTagType(tag_type);
                    if (tt == null || !tt.hasTagTypeFeature(1L) || (tag = tt.getTag(tag_id)) == null) continue;
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    int[] limits = (int[])entry.getValue();
                    rl.setTagUploadLimit(limits[0]);
                    rl.setTagDownloadLimit(limits[1]);
                    all_rl_tags.remove(tag);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (Tag tag : all_rl_tags) {
                try {
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    rl.setTagUploadLimit(0);
                    rl.setTagDownloadLimit(0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private List<String> getString(boolean is_current, boolean use_hashes) {
            Object tag_name;
            Object[] limits;
            ArrayList<String> result = new ArrayList<String>();
            result.add("Global Limits");
            if (this.auto_up_enabled) {
                result.add("    Auto upload limit enabled");
            } else if (this.auto_up_seeding_enabled) {
                result.add("    Auto upload seeding limit enabled");
            } else {
                result.add("    " + SpeedLimitHandler.this.formatUp(this.up_limit * 1024));
                if (this.seeding_limits_enabled) {
                    result.add("    Seeding only limit enabled");
                    result.add("    Seeding only: " + SpeedLimitHandler.this.format(this.up_seeding_limit * 1024));
                }
            }
            result.add("    " + SpeedLimitHandler.this.formatDown(this.down_limit * 1024));
            if (this.lan_rates_enabled) {
                result.add("");
                result.add("    LAN limits enabled");
                result.add("        " + SpeedLimitHandler.this.formatUp(this.lan_up_limit * 1024));
                result.add("        " + SpeedLimitHandler.this.formatDown(this.lan_down_limit * 1024));
            }
            result.add("");
            result.add("Download Limits");
            int total_download_limits = 0;
            int total_download_limits_up = 0;
            int total_download_limits_up_disabled = 0;
            int total_download_limits_down = 0;
            int total_download_limits_down_disabled = 0;
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                String hash_str = entry.getKey();
                byte[] hash = Base32.decode(hash_str);
                com.biglybt.core.download.DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                if (dm == null) continue;
                limits = entry.getValue();
                ++total_download_limits;
                Category up = limits[0];
                Category down = limits[1];
                if (up < 0) {
                    ++total_download_limits_up_disabled;
                } else {
                    total_download_limits_up += up;
                }
                if (down < 0) {
                    ++total_download_limits_down_disabled;
                } else {
                    total_download_limits_down += down;
                }
                result.add("    " + (use_hashes ? hash_str.substring(0, 16) : dm.getDisplayName()) + ": " + SpeedLimitHandler.this.formatUp((int)up) + ", " + SpeedLimitHandler.this.formatDown((int)down));
            }
            if (total_download_limits == 0) {
                result.add("    None");
            } else {
                result.add("    ----");
                result.add("    Total=" + total_download_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_download_limits_up) + (total_download_limits_up_disabled == 0 ? "" : " [" + total_download_limits_up_disabled + " disabled]") + ", " + SpeedLimitHandler.this.formatDown(total_download_limits_down) + (total_download_limits_down_disabled == 0 ? "" : " [" + total_download_limits_down_disabled + " disabled]"));
            }
            Category[] categories = CategoryManager.getCategories();
            HashMap<String, Category> cat_map = new HashMap<String, Category>();
            limits = categories;
            int dm = categories.length;
            int hash = 0;
            while (hash < dm) {
                Category c = limits[hash];
                cat_map.put(c.getName(), c);
                ++hash;
            }
            result.add("");
            result.add("Category Limits");
            int total_cat_limits = 0;
            int total_cat_limits_up = 0;
            int total_cat_limits_down = 0;
            TreeMap<String, int[]> sorted_category_limits = new TreeMap<String, int[]>(this.category_limits);
            for (Map.Entry entry : sorted_category_limits.entrySet()) {
                String cat_name = (String)entry.getKey();
                Category category = (Category)cat_map.get(cat_name);
                if (category == null) continue;
                if (category.getType() == 2) {
                    cat_name = "Uncategorised";
                }
                int[] limits2 = (int[])entry.getValue();
                ++total_cat_limits;
                int up = limits2[0];
                int down = limits2[1];
                total_cat_limits_up += up;
                total_cat_limits_down += down;
                result.add("    " + cat_name + ": " + SpeedLimitHandler.this.formatUp(up) + ", " + SpeedLimitHandler.this.formatDown(down));
            }
            if (total_cat_limits == 0) {
                result.add("    None");
            } else {
                result.add("    ----");
                result.add("    Total=" + total_cat_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_cat_limits_up) + ", " + SpeedLimitHandler.this.formatDown(total_cat_limits_down));
            }
            result.add("");
            result.add("Tag Limits");
            int total_tag_limits = 0;
            int total_tag_limits_up = 0;
            int total_tag_limits_down = 0;
            boolean some_up_disabled = false;
            boolean some_down_disabled = false;
            TagManager tm = TagManagerFactory.getTagManager();
            TreeMap<String, int[]> sorted_tag_limts = new TreeMap<String, int[]>(this.tag_limits);
            for (Map.Entry entry : sorted_tag_limts.entrySet()) {
                String tag_key = (String)entry.getKey();
                String[] bits = tag_key.split("\\.");
                try {
                    Tag tag;
                    int tag_type = Integer.parseInt(bits[0]);
                    int tag_id = Integer.parseInt(bits[1]);
                    TagType tt = tm.getTagType(tag_type);
                    if (tt == null || !tt.hasTagTypeFeature(1L) || (tag = tt.getTag(tag_id)) == null) continue;
                    tag_name = String.valueOf(tt.getTagTypeName(true)) + " - " + tag.getTagName(true);
                    int[] limits3 = (int[])entry.getValue();
                    ++total_tag_limits;
                    int up = limits3[0];
                    int down = limits3[1];
                    if (up > 0) {
                        total_tag_limits_up += up;
                    } else if (up < 0) {
                        some_up_disabled = true;
                    }
                    if (down > 0) {
                        total_tag_limits_down += down;
                    } else if (down < 0) {
                        some_down_disabled = true;
                    }
                    result.add("    " + (String)tag_name + ": " + SpeedLimitHandler.this.formatUp(up) + ", " + SpeedLimitHandler.this.formatDown(down));
                }
                catch (Throwable tag_type) {
                    // empty catch block
                }
            }
            String dis_str = "";
            if (some_up_disabled) {
                dis_str = "up";
            }
            if (some_down_disabled) {
                dis_str = String.valueOf(dis_str) + (dis_str.length() == 0 ? "" : "&") + "down";
            }
            if (dis_str.length() > 0) {
                dis_str = " (some " + dis_str + " disabled)";
            }
            if (total_tag_limits == 0) {
                result.add("    None" + dis_str);
            } else {
                result.add("    ----");
                result.add("    Total=" + total_tag_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_tag_limits_up) + ", " + SpeedLimitHandler.this.formatDown(total_tag_limits_down) + dis_str);
            }
            if (is_current) {
                HashMap plugin_limiters = new HashMap();
                List<com.biglybt.core.download.DownloadManager> dms = gm.getDownloadManagers();
                for (com.biglybt.core.download.DownloadManager dm2 : dms) {
                    tag_name = new Boolean[]{true, false};
                    int tag = ((Boolean[])tag_name).length;
                    int tt = 0;
                    while (tt < tag) {
                        boolean upload = tag_name[tt];
                        List limiters = SpeedLimitHandler.this.trim(dm2.getRateLimiters(upload));
                        for (LimitedRateGroup g : limiters) {
                            ArrayList<com.biglybt.core.download.DownloadManager> entries = (ArrayList<com.biglybt.core.download.DownloadManager>)plugin_limiters.get(g);
                            if (entries == null) {
                                entries = new ArrayList<com.biglybt.core.download.DownloadManager>();
                                plugin_limiters.put(g, entries);
                                entries.add((com.biglybt.core.download.DownloadManager)((Object)Boolean.valueOf(upload)));
                                entries.add((com.biglybt.core.download.DownloadManager)new int[1]);
                            }
                            entries.add(dm2);
                        }
                        ++tt;
                    }
                    PEPeerManager pm = dm2.getPeerManager();
                    if (pm == null) continue;
                    List<PEPeer> peers = pm.getPeers();
                    for (PEPeer peer : peers) {
                        Boolean[] booleanArray = new Boolean[]{true, false};
                        int n = booleanArray.length;
                        int g = 0;
                        while (g < n) {
                            boolean upload = booleanArray[g];
                            List limiters = SpeedLimitHandler.this.trim(peer.getRateLimiters(upload));
                            for (LimitedRateGroup g2 : limiters) {
                                ArrayList<Object> entries = (ArrayList<Object>)plugin_limiters.get(g2);
                                if (entries == null) {
                                    entries = new ArrayList<Object>();
                                    plugin_limiters.put(g2, entries);
                                    entries.add(upload);
                                    entries.add(new int[]{1});
                                    continue;
                                }
                                int[] nArray = (int[])entries.get(1);
                                nArray[0] = nArray[0] + 1;
                            }
                            ++g;
                        }
                    }
                }
                result.add("");
                result.add("Plugin Limits");
                if (plugin_limiters.size() == 0) {
                    result.add("    None");
                } else {
                    ArrayList<String> plugin_lines = new ArrayList<String>();
                    for (Map.Entry entry : plugin_limiters.entrySet()) {
                        LimitedRateGroup group = (LimitedRateGroup)entry.getKey();
                        List list = (List)entry.getValue();
                        boolean is_upload = (Boolean)list.get(0);
                        int peers = ((int[])list.get(1))[0];
                        String line = "    " + group.getName() + ": " + (is_upload ? SpeedLimitHandler.this.formatUp(group.getRateLimitBytesPerSecond()) : SpeedLimitHandler.this.formatDown(group.getRateLimitBytesPerSecond()));
                        if (peers > 0) {
                            line = String.valueOf(line) + ", peers=" + peers;
                        }
                        if (list.size() > 2) {
                            line = String.valueOf(line) + ", downloads=" + (list.size() - 2);
                        }
                        plugin_lines.add(line);
                    }
                    Collections.sort(plugin_lines);
                    result.addAll(plugin_lines);
                }
            }
            return result;
        }
    }

    class NetLimit {
        private final int type;
        private final String name;
        private final double multiplier;
        private final String profile;
        private final TagType tag_type;
        private final String tag_name;
        private final long[] limits;
        private boolean enabled = true;
        private TagFeatureRateLimit tag;
        private LongTermStats lt_stats;

        private NetLimit(int _type, String _name, double _mult, String _profile, TagType _tag_type, String _tag_name, long _total_lim, long _up_lim, long _down_lim) {
            this.type = _type;
            this.name = _name;
            this.multiplier = _mult;
            this.profile = _profile;
            this.tag_type = _tag_type;
            this.tag_name = _tag_name;
            this.limits = new long[]{_total_lim, _up_lim, _down_lim};
        }

        private void initialise() {
            if (this.tag_type != null) {
                this.tag = (TagFeatureRateLimit)((Object)this.tag_type.getTag(this.tag_name, true));
                if (this.tag == null) {
                    Debug.out("hmm, tag " + this.tag_name + " not found");
                } else {
                    try {
                        this.lt_stats = StatsFactory.getGenericLongTermStats("tag." + this.tag.getTag().getTagUID(), new NetLimitStatsProvider(this.tag));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }

        private int getType() {
            return this.type;
        }

        private String getName() {
            return this.name;
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private void setEnabled(boolean _b) {
            this.enabled = _b;
        }

        private double getMultiplier() {
            return this.multiplier;
        }

        private LongTermStats getLongTermStats() {
            return this.lt_stats;
        }

        private String getProfile() {
            return this.profile;
        }

        private TagFeatureRateLimit getTag() {
            return this.tag;
        }

        private long[] getLimits() {
            return this.limits;
        }

        private class NetLimitStatsProvider
        implements LongTermStats.GenericStatsSource {
            private final TagType tag_type;
            private final String tag_name;
            private TagFeatureRateLimit tag_rl;

            private NetLimitStatsProvider(TagFeatureRateLimit _tag_rl) {
                this.tag_rl = _tag_rl;
                Tag tag = this.tag_rl.getTag();
                this.tag_type = tag.getTagType();
                this.tag_name = tag.getTagName(true);
            }

            @Override
            public int getEntryCount() {
                return 4;
            }

            @Override
            public long[] getStats(String id) {
                TagFeatureRateLimit t;
                if (this.tag_type == SpeedLimitHandler.this.ip_set_tag_type && (t = (TagFeatureRateLimit)((Object)SpeedLimitHandler.this.ip_set_tag_type.getTag(this.tag_name, true))) != this.tag_rl) {
                    this.tag_rl = t;
                }
                long[] up = this.tag_rl.getTagUploadTotal();
                long[] down = this.tag_rl.getTagDownloadTotal();
                long[] result = new long[4];
                if (up != null) {
                    result[1] = up[0];
                }
                if (down != null) {
                    result[3] = down[0];
                }
                return result;
            }
        }
    }

    public class PeerSet {
        private final String name;
        private long[][] ranges = new long[0][];
        private final Set<String> country_codes = new HashSet<String>();
        private final Set<String> networks = new HashSet<String>();
        private boolean inverse;
        private Set<String> categories_or_tags;
        private boolean has_explicit_up_lim;
        private boolean has_explicit_down_lim;
        private long last_send_total = -1L;
        private long last_recv_total = -1L;
        final Average send_rate = AverageFactory.MovingImmediateAverage(10);
        final Average receive_rate = AverageFactory.MovingImmediateAverage(10);
        final RateLimiter up_limiter;
        final RateLimiter down_limiter;
        private int peer_up_lim;
        private int peer_down_lim;
        private Pattern client_pattern;
        private Pattern intf_pattern;
        private Pattern asn_pattern;
        private boolean client_pattern_inverse;
        private boolean intf_pattern_inverse;
        private boolean asn_pattern_inverse;
        private String group;
        private TagPeerImpl tag_impl;

        private PeerSet(String _name) {
            this.name = _name;
            this.up_limiter = SpeedLimitHandler.this.plugin_interface.getConnectionManager().createRateLimiter("ps-" + this.name, 0);
            this.down_limiter = SpeedLimitHandler.this.plugin_interface.getConnectionManager().createRateLimiter("ps-" + this.name, 0);
        }

        private void initialise(int tag_id) {
            if (SpeedLimitHandler.this.ip_set_tag_type != null) {
                this.tag_impl = new TagPeerImpl(this, tag_id);
            }
            if (!this.has_explicit_up_lim) {
                this.up_limiter.setRateLimitBytesPerSecond(COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".up", 0));
            }
            if (!this.has_explicit_down_lim) {
                this.down_limiter.setRateLimitBytesPerSecond(COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".down", 0));
            }
            TagPeerImpl tag = this.tag_impl;
            if (this.group != null && tag != null) {
                tag.setGroup(this.group);
            }
            if ((this.client_pattern != null && this.client_pattern.pattern().equals("auto") || this.intf_pattern != null && this.intf_pattern.pattern().equals("auto")) && tag != null) {
                tag.setVisible(false);
            }
        }

        private void setParameters(boolean _inverse, int _up_lim, int _down_lim, int _peer_up_lim, int _peer_down_lim, Set<String> _cats_or_tags, Pattern _client_pattern, boolean _client_pattern_inverse, Pattern _intf_pattern, boolean _intf_pattern_inverse, Pattern _asn_pattern, boolean _asn_pattern_inverse, String _group) {
            this.inverse = _inverse;
            boolean bl = this.has_explicit_up_lim = _up_lim >= 0;
            if (!this.has_explicit_up_lim) {
                _up_lim = 0;
            }
            boolean bl2 = this.has_explicit_down_lim = _down_lim >= 0;
            if (!this.has_explicit_down_lim) {
                _down_lim = 0;
            }
            this.up_limiter.setRateLimitBytesPerSecond(_up_lim);
            this.down_limiter.setRateLimitBytesPerSecond(_down_lim);
            this.peer_up_lim = _peer_up_lim;
            this.peer_down_lim = _peer_down_lim;
            this.categories_or_tags = _cats_or_tags.size() == 0 ? null : _cats_or_tags;
            this.client_pattern = _client_pattern;
            this.intf_pattern = _intf_pattern;
            this.asn_pattern = _asn_pattern;
            this.client_pattern_inverse = _client_pattern_inverse;
            this.intf_pattern_inverse = _intf_pattern_inverse;
            this.asn_pattern_inverse = _asn_pattern_inverse;
            if (this.client_pattern != null && this.client_pattern.pattern().equals("auto")) {
                this.setGroup(String.valueOf(MessageText.getString("Peers.column.client")) + "_" + MessageText.getString("wizard.maketorrent.auto"));
            } else if (this.intf_pattern != null && this.intf_pattern.pattern().equals("auto")) {
                this.setGroup(String.valueOf(MessageText.getString("label.interface.short")) + "_" + MessageText.getString("wizard.maketorrent.auto"));
            } else if (_group != null) {
                this.setGroup(_group);
            }
        }

        private void setGroup(String _group) {
            this.group = _group;
        }

        public Pattern getClientPattern() {
            return this.client_pattern;
        }

        private int getPeerUpLimit() {
            return this.peer_up_lim;
        }

        private int getPeerDownLimit() {
            return this.peer_down_lim;
        }

        private boolean addCIDRorCCetc(String cidr_or_cc_etc) {
            if (Character.isDigit(cidr_or_cc_etc.charAt(0))) {
                String cidr = cidr_or_cc_etc;
                int pos = cidr.indexOf(47);
                if (pos == -1) {
                    return false;
                }
                String address = cidr.substring(0, pos);
                if (address.contains(":")) {
                    return false;
                }
                try {
                    byte[] start_bytes = HostNameToIPResolver.syncResolve(address).getAddress();
                    int cidr_mask = Integer.parseInt(cidr.substring(pos + 1));
                    int rev_mask = 0;
                    int i = 0;
                    while (i < 32 - cidr_mask) {
                        rev_mask = rev_mask << 1 | 1;
                        ++i;
                    }
                    start_bytes[0] = (byte)(start_bytes[0] & ~(rev_mask >> 24));
                    start_bytes[1] = (byte)(start_bytes[1] & ~(rev_mask >> 16));
                    start_bytes[2] = (byte)(start_bytes[2] & ~(rev_mask >> 8));
                    start_bytes[3] = (byte)(start_bytes[3] & ~rev_mask);
                    byte[] end_bytes = (byte[])start_bytes.clone();
                    end_bytes[0] = (byte)(end_bytes[0] | rev_mask >> 24 & 0xFF);
                    end_bytes[1] = (byte)(end_bytes[1] | rev_mask >> 16 & 0xFF);
                    end_bytes[2] = (byte)(end_bytes[2] | rev_mask >> 8 & 0xFF);
                    end_bytes[3] = (byte)(end_bytes[3] | rev_mask & 0xFF);
                    long l_start = (long)(start_bytes[0] << 24 & 0xFF000000 | start_bytes[1] << 16 & 0xFF0000 | start_bytes[2] << 8 & 0xFF00 | start_bytes[3] & 0xFF) & 0xFFFFFFFFL;
                    long l_end = (long)(end_bytes[0] << 24 & 0xFF000000 | end_bytes[1] << 16 & 0xFF0000 | end_bytes[2] << 8 & 0xFF00 | end_bytes[3] & 0xFF) & 0xFFFFFFFFL;
                    int len = this.ranges.length;
                    long[][] new_ranges = new long[len + 1][];
                    System.arraycopy(this.ranges, 0, new_ranges, 0, len);
                    new_ranges[len] = new long[]{l_start, l_end};
                    this.ranges = new_ranges;
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            String[] stringArray = AENetworkClassifier.AT_NETWORKS;
            int n = AENetworkClassifier.AT_NETWORKS.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (cidr_or_cc_etc.equalsIgnoreCase(net)) {
                    this.networks.add(net);
                    return true;
                }
                ++n2;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase(SpeedLimitHandler.NET_IPV4)) {
                this.networks.add(SpeedLimitHandler.NET_IPV4);
                return true;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase(SpeedLimitHandler.NET_IPV6)) {
                this.networks.add(SpeedLimitHandler.NET_IPV6);
                return true;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase(SpeedLimitHandler.NET_LAN)) {
                this.networks.add(SpeedLimitHandler.NET_LAN);
                return true;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase(SpeedLimitHandler.NET_WAN)) {
                this.networks.add(SpeedLimitHandler.NET_WAN);
                return true;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase("all")) {
                this.networks.addAll(Arrays.asList(AENetworkClassifier.AT_NETWORKS));
                return true;
            }
            String cc = cidr_or_cc_etc;
            if (cc.length() != 2) {
                return false;
            }
            this.country_codes.add(cc.toUpperCase(Locale.US));
            return true;
        }

        private void addSet(PeerSet other) {
            long[][] new_ranges = new long[this.ranges.length + other.ranges.length][];
            System.arraycopy(this.ranges, 0, new_ranges, 0, this.ranges.length);
            System.arraycopy(other.ranges, 0, new_ranges, this.ranges.length, other.ranges.length);
            this.ranges = new_ranges;
            this.country_codes.addAll(other.country_codes);
            this.networks.addAll(other.networks);
        }

        public String getName() {
            return this.name;
        }

        private long[][] getRanges() {
            return this.ranges;
        }

        private Set<String> getCountryCodes() {
            return this.country_codes;
        }

        private Set<String> getNetworks() {
            return this.networks;
        }

        private RateLimiter getUpLimiter() {
            return this.up_limiter;
        }

        private RateLimiter getDownLimiter() {
            return this.down_limiter;
        }

        private Set<String> getCategoriesOrTags() {
            return this.categories_or_tags;
        }

        private void updateStats(int tick_count) {
            long send_total = this.up_limiter.getRateLimitTotalByteCount();
            long recv_total = this.down_limiter.getRateLimitTotalByteCount();
            if (this.last_send_total != -1L) {
                long send_diff = send_total - this.last_send_total;
                long recv_diff = recv_total - this.last_recv_total;
                this.send_rate.update(send_diff);
                this.receive_rate.update(recv_diff);
            }
            this.last_send_total = send_total;
            this.last_recv_total = recv_total;
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.update(tick_count);
            }
        }

        private boolean isInverse() {
            return this.inverse;
        }

        private void addPeer(PeerManager peer_manager, Peer peer) {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.add(peer_manager, peer);
            }
        }

        private void removePeer(PeerManager peer_manager, Peer peer) {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.remove(peer_manager, peer);
            }
        }

        private void removeAllPeers() {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.removeAll();
            }
        }

        private void destroy() {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                this.tag_impl = null;
                tag.removeAll();
                tag.removeTag();
            }
        }

        private String getAddressString() {
            long address_count = 0L;
            long[][] lArray = this.ranges;
            int n = this.ranges.length;
            int n2 = 0;
            while (n2 < n) {
                long[] range = lArray[n2];
                address_count += range[1] - range[0] + 1L;
                ++n2;
            }
            if (address_count == 0L) {
                return "[]";
            }
            return String.valueOf(address_count);
        }

        private String getDetailString() {
            return String.valueOf(this.name) + ": Up=" + SpeedLimitHandler.this.format(this.up_limiter.getRateLimitBytesPerSecond()) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.send_rate.getAverage()) + ")" + ", Down=" + SpeedLimitHandler.this.format(this.down_limiter.getRateLimitBytesPerSecond()) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.receive_rate.getAverage()) + ")" + ", Addresses=" + this.getAddressString() + ", CC=" + this.country_codes + ", Networks=" + this.networks + ", Inverse=" + this.inverse + ", Categories/Tags=" + (this.categories_or_tags == null ? "[]" : String.valueOf(this.categories_or_tags)) + ", Peer_Up=" + SpeedLimitHandler.this.format(this.peer_up_lim) + ", Peer_Down=" + SpeedLimitHandler.this.format(this.peer_down_lim) + ", Client=" + (this.client_pattern == null ? "" : String.valueOf(this.client_pattern_inverse ? "!" : "") + this.client_pattern) + ", Intf=" + (this.intf_pattern == null ? "" : String.valueOf(this.intf_pattern_inverse ? "!" : "") + this.intf_pattern) + ", ASN=" + (this.asn_pattern == null ? "" : String.valueOf(this.asn_pattern_inverse ? "!" : "") + this.asn_pattern);
        }

        static /* synthetic */ long[][] access$24(PeerSet peerSet) {
            return peerSet.getRanges();
        }

        static /* synthetic */ Set access$25(PeerSet peerSet) {
            return peerSet.getCountryCodes();
        }

        static /* synthetic */ Set access$26(PeerSet peerSet) {
            return peerSet.getNetworks();
        }

        static /* synthetic */ boolean access$27(PeerSet peerSet) {
            return peerSet.isInverse();
        }

        private class TagPeerImpl
        extends TagBase
        implements TagPeer,
        TagFeatureExecOnAssign {
            private final PeerSet ip_set;
            private final Object UPLOAD_PRIORITY_ADDED_KEY;
            private final Object BOOSTED_KEY;
            private int upload_priority;
            private final Set<PEPeer> added_peers;
            private final Set<PEPeer> pending_peers;

            private TagPeerImpl(PeerSet _ip_set, int tag_id) {
                int[] colour;
                super(SpeedLimitHandler.this.ip_set_tag_type, tag_id, PeerSet.this.name);
                this.UPLOAD_PRIORITY_ADDED_KEY = new Object();
                this.BOOSTED_KEY = new Object();
                this.added_peers = new HashSet<PEPeer>();
                this.pending_peers = new HashSet<PEPeer>();
                this.ip_set = _ip_set;
                this.addTag();
                this.upload_priority = COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".uppri", 0);
                this.setTagBoost(COConfigurationManager.getBooleanParameter("speed.limit.handler.ipset_n." + tag_id + ".boost", false));
                int actions = COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".eos", -1);
                if (actions != -1) {
                    int[] nArray = new int[]{1, 65536};
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int action = nArray[n2];
                        if ((actions & action) != 0) {
                            super.setActionEnabled(action, true);
                        }
                        ++n2;
                    }
                }
                if ((colour = COConfigurationManager.getRGBParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".color")) != null) {
                    super.setColor(colour);
                }
            }

            @Override
            public int getTaggableTypes() {
                return 4;
            }

            @Override
            public int getSupportedActions() {
                return 65537;
            }

            @Override
            public void setActionEnabled(int action, boolean enabled) {
                super.setActionEnabled(action, enabled);
                if (action == 1 || action == 65536) {
                    int tag_id = this.getTagID();
                    int actions = COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".eos", -1);
                    if (enabled) {
                        actions = actions == -1 ? action : (actions |= action);
                    } else {
                        if (actions != -1) {
                            actions &= ~action;
                        }
                        if (actions == 0) {
                            actions = -1;
                        }
                    }
                    COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + tag_id + ".eos", actions);
                }
            }

            @Override
            public void setColor(int[] rgb) {
                super.setColor(rgb);
                COConfigurationManager.setRGBParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".color", rgb, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void update(int tick_count) {
                ArrayList<PEPeer> to_remove = null;
                ArrayList<PEPeer> to_add = null;
                ArrayList<PEPeer> to_delete = null;
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    PEPeer peer;
                    Iterator<PEPeer> it;
                    if (tick_count % 5 == 0) {
                        it = this.added_peers.iterator();
                        while (it.hasNext()) {
                            peer = it.next();
                            if (peer.getPeerState() != 50) continue;
                            it.remove();
                            if (to_remove == null) {
                                to_remove = new ArrayList<PEPeer>();
                            }
                            to_remove.add(peer);
                        }
                    }
                    it = this.pending_peers.iterator();
                    while (it.hasNext()) {
                        peer = it.next();
                        int state = peer.getPeerState();
                        if (state == 30) {
                            int can_add = this.canAdd(peer);
                            if (can_add == 0) continue;
                            if (can_add == 3) {
                                it.remove();
                                if (to_delete == null) {
                                    to_delete = new ArrayList<PEPeer>();
                                }
                                to_delete.add(peer);
                                continue;
                            }
                            it.remove();
                            if (can_add == 1) {
                                this.added_peers.add(peer);
                                if (to_add == null) {
                                    to_add = new ArrayList<PEPeer>();
                                }
                                to_add.add(peer);
                                continue;
                            }
                            this.deferredRemove(peer);
                            continue;
                        }
                        if (state != 50) continue;
                        it.remove();
                    }
                }
                if (to_add != null) {
                    for (PEPeer peer : to_add) {
                        this.addTaggable(peer);
                    }
                }
                if (to_remove != null) {
                    for (PEPeer peer : to_remove) {
                        this.removeTaggable(peer);
                    }
                }
                if (to_delete != null) {
                    boolean do_ban = this.isActionEnabled(65536);
                    for (PEPeer peer : to_delete) {
                        PEPeerManager peer_manager = peer.getManager();
                        if (peer_manager == null) continue;
                        if (do_ban) {
                            ip_filter.ban(peer.getIp(), String.valueOf(MessageText.getString("tag.type.ipset")) + ": " + this.getTagName(true), false);
                            peer_manager.removePeer(peer, "PeerSet ban action", 5);
                            continue;
                        }
                        peer_manager.removePeer(peer, "PeerSet removal action", 5);
                    }
                }
            }

            private boolean deferEOS() {
                return this.ip_set.client_pattern != null || this.ip_set.intf_pattern != null || this.ip_set.asn_pattern != null;
            }

            private void deferredRemove(PEPeer peer) {
                if (this.upload_priority > 0) {
                    peer.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                Peer p = PluginCoreUtils.wrap(peer);
                p.removeRateLimiter(this.ip_set.up_limiter, true);
                p.removeRateLimiter(this.ip_set.down_limiter, false);
            }

            private int canAdd(PEPeer peer) {
                Pattern client_pattern = this.ip_set.client_pattern;
                Pattern intf_pattern = this.ip_set.intf_pattern;
                Pattern asn_pattern = this.ip_set.asn_pattern;
                if (client_pattern == null && intf_pattern == null && asn_pattern == null) {
                    return 1;
                }
                if (client_pattern != null) {
                    return this.canAddClient(peer, client_pattern);
                }
                if (intf_pattern != null) {
                    return this.canAddIntf(peer, intf_pattern);
                }
                return this.canAddASN(peer, asn_pattern);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int canAddClient(PEPeer peer, Pattern client_pattern) {
                String id_name;
                boolean auto_client = client_pattern.pattern().equals("auto");
                boolean result = false;
                String hs_name = peer.getClientNameFromExtensionHandshake();
                if (hs_name != null && !hs_name.isEmpty()) {
                    if (auto_client) {
                        char[] chars = hs_name.toCharArray();
                        String client = hs_name;
                        int i22 = 2;
                        while (i22 < chars.length) {
                            if (!Character.isLetter(chars[i22])) {
                                client = new String(chars, 0, i22);
                                break;
                            }
                            ++i22;
                        }
                        List i22 = SpeedLimitHandler.this.auto_peer_set_queue_client;
                        synchronized (i22) {
                            if (!SpeedLimitHandler.this.auto_peer_set_queue_client.contains(client)) {
                                SpeedLimitHandler.this.auto_peer_set_queue_client.add(client);
                                SpeedLimitHandler.this.auto_peer_set_checker.dispatch();
                            }
                        }
                        return 2;
                    }
                    if (client_pattern.matcher(hs_name).find()) {
                        result = true;
                    }
                    if (PeerSet.this.client_pattern_inverse) {
                        result = !result;
                    }
                } else {
                    Long start = (Long)peer.getUserData(PEER_LT_WAIT_START_KEY);
                    long now = SystemTime.getMonotonousTime();
                    if (start == null) {
                        peer.setUserData(PEER_LT_WAIT_START_KEY, now);
                        return 0;
                    }
                    if (now - start < 20000L) {
                        return 0;
                    }
                }
                if (!result && (id_name = peer.getClientNameFromPeerID()) != null && !id_name.isEmpty()) {
                    if (auto_client) {
                        char[] chars = id_name.toCharArray();
                        String client = id_name;
                        int i = 2;
                        while (i < chars.length) {
                            if (!Character.isLetter(chars[i])) {
                                client = new String(chars, 0, i);
                                break;
                            }
                            ++i;
                        }
                        List list = SpeedLimitHandler.this.auto_peer_set_queue_client;
                        synchronized (list) {
                            if (!SpeedLimitHandler.this.auto_peer_set_queue_client.contains(client)) {
                                SpeedLimitHandler.this.auto_peer_set_queue_client.add(client);
                                SpeedLimitHandler.this.auto_peer_set_checker.dispatch();
                            }
                        }
                        return 2;
                    }
                    if (client_pattern.matcher(id_name).find()) {
                        result = true;
                    }
                    if (PeerSet.this.client_pattern_inverse) {
                        boolean bl = result = !result;
                    }
                }
                if (result && (this.isActionEnabled(1) || this.isActionEnabled(65536))) {
                    return 3;
                }
                return result ? 1 : 2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int canAddIntf(PEPeer peer, Pattern intf_pattern) {
                boolean auto_intf = intf_pattern.pattern().equals("auto");
                boolean result = false;
                NetworkInterface ni = PeerUtils.getLocalNetworkInterface(peer);
                String intf_name = ni != null ? ni.getName() : "?";
                if (auto_intf) {
                    List list = SpeedLimitHandler.this.auto_peer_set_queue_intf;
                    synchronized (list) {
                        if (!SpeedLimitHandler.this.auto_peer_set_queue_intf.contains(intf_name)) {
                            SpeedLimitHandler.this.auto_peer_set_queue_intf.add(intf_name);
                            SpeedLimitHandler.this.auto_peer_set_checker.dispatch();
                        }
                    }
                    return 2;
                }
                if (intf_pattern.matcher(intf_name).find()) {
                    result = true;
                }
                if (PeerSet.this.intf_pattern_inverse) {
                    boolean bl = result = !result;
                }
                if (result && (this.isActionEnabled(1) || this.isActionEnabled(65536))) {
                    return 3;
                }
                return result ? 1 : 2;
            }

            private int canAddASN(PEPeer peer, Pattern asn_pattern) {
                boolean result = false;
                String[] as_details = PeerUtils.getASandASN(peer);
                if (as_details != null) {
                    String as = as_details[0];
                    String asn = as_details[1];
                    boolean matched = false;
                    if (!as.isEmpty() && asn_pattern.matcher(as).find()) {
                        result = true;
                        matched = true;
                    }
                    if (!matched && !asn.isEmpty() && asn_pattern.matcher(asn).find()) {
                        result = true;
                    }
                    if (PeerSet.this.asn_pattern_inverse) {
                        result = !result;
                    }
                } else {
                    Long start = (Long)peer.getUserData(PEER_ASN_WAIT_START_KEY);
                    long now = SystemTime.getMonotonousTime();
                    if (start == null) {
                        peer.setUserData(PEER_ASN_WAIT_START_KEY, now);
                        return 0;
                    }
                    if (now - start < 20000L) {
                        return 0;
                    }
                }
                if (result && (this.isActionEnabled(1) || this.isActionEnabled(65536))) {
                    return 3;
                }
                return result ? 1 : 2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void add(PeerManager peer_manager, Peer _peer) {
                PEPeer peer = PluginCoreUtils.unwrap(_peer);
                if (!this.deferEOS()) {
                    if (this.isActionEnabled(65536)) {
                        ip_filter.ban(peer.getIp(), String.valueOf(MessageText.getString("tag.type.ipset")) + ": " + this.getTagName(true), false);
                        peer_manager.removePeer(_peer, "PeerSet ban action", 5);
                        return;
                    }
                    if (this.isActionEnabled(1)) {
                        peer_manager.removePeer(_peer, "PeerSet removal action", 5);
                        return;
                    }
                }
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    if (peer.getPeerState() == 30) {
                        if (this.added_peers.contains(peer)) {
                            return;
                        }
                        int can_add = this.canAdd(peer);
                        if (can_add == 0) {
                            this.pending_peers.add(peer);
                            return;
                        }
                        if (can_add == 3) {
                            if (this.isActionEnabled(65536)) {
                                ip_filter.ban(peer.getIp(), String.valueOf(MessageText.getString("tag.type.ipset")) + ": " + this.getTagName(true), false);
                                peer_manager.removePeer(_peer, "PeerSet ban action", 5);
                            } else {
                                peer_manager.removePeer(_peer, "PeerSet removal action", 5);
                            }
                            return;
                        }
                        this.pending_peers.remove(peer);
                        if (can_add != 1) {
                            this.deferredRemove(peer);
                            return;
                        }
                    } else {
                        this.pending_peers.add(peer);
                        return;
                    }
                    this.added_peers.add(peer);
                }
                this.addTaggable(peer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void remove(PeerManager peer_manager, Peer _peer) {
                PEPeer peer = PluginCoreUtils.unwrap(_peer);
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    if (this.pending_peers.remove(peer)) {
                        return;
                    }
                    if (!this.added_peers.remove(peer)) {
                        return;
                    }
                }
                this.removeTaggable(peer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeAll() {
                ArrayList<PEPeer> to_remove;
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    this.pending_peers.clear();
                    to_remove = new ArrayList<PEPeer>(this.added_peers);
                    this.added_peers.clear();
                }
                for (PEPeer peer : to_remove) {
                    this.removeTaggable(peer);
                }
            }

            @Override
            public void addTaggable(Taggable t) {
                if (this.upload_priority > 0) {
                    ((PEPeer)t).updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, true);
                }
                if (this.getTagBoost()) {
                    this.setBoost((PEPeer)t, true);
                }
                super.addTaggable(t);
            }

            @Override
            public void removeTaggable(Taggable t) {
                if (this.upload_priority > 0) {
                    ((PEPeer)t).updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                if (this.getTagBoost()) {
                    this.setBoost((PEPeer)t, false);
                }
                super.removeTaggable(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaggedCount() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return this.added_peers.size();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PEPeer> getTaggedPeers() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return new ArrayList<PEPeer>(this.added_peers);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<Taggable> getTagged() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return new HashSet<Taggable>(this.added_peers);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasTaggable(Taggable t) {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return this.added_peers.contains(t);
                }
            }

            @Override
            public boolean supportsTagRates() {
                return true;
            }

            @Override
            public boolean supportsTagUploadLimit() {
                return !PeerSet.this.has_explicit_up_lim;
            }

            @Override
            public boolean supportsTagDownloadLimit() {
                return !PeerSet.this.has_explicit_down_lim;
            }

            @Override
            public int getTagUploadLimit() {
                return PeerSet.this.up_limiter.getRateLimitBytesPerSecond();
            }

            @Override
            public void setTagUploadLimit(int bps) {
                if (this.supportsTagUploadLimit()) {
                    PeerSet.this.up_limiter.setRateLimitBytesPerSecond(bps);
                    COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".up", bps);
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        LimitedRateGroup[] limitedRateGroupArray = peer.getRateLimiters(true);
                        int n = limitedRateGroupArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LimitedRateGroup l = limitedRateGroupArray[n2];
                            l.getRateLimitBytesPerSecond();
                            ++n2;
                        }
                    }
                }
            }

            @Override
            public int getTagCurrentUploadRate() {
                return (int)PeerSet.this.send_rate.getAverage();
            }

            @Override
            protected long[] getTagSessionUploadTotalCurrent() {
                return new long[]{PeerSet.this.last_send_total};
            }

            @Override
            protected long[] getTagSessionDownloadTotalCurrent() {
                return new long[]{PeerSet.this.last_recv_total};
            }

            @Override
            public int getTagDownloadLimit() {
                return PeerSet.this.down_limiter.getRateLimitBytesPerSecond();
            }

            @Override
            public void setTagDownloadLimit(int bps) {
                if (this.supportsTagDownloadLimit()) {
                    PeerSet.this.down_limiter.setRateLimitBytesPerSecond(bps);
                    COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".down", bps);
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        LimitedRateGroup[] limitedRateGroupArray = peer.getRateLimiters(false);
                        int n = limitedRateGroupArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LimitedRateGroup l = limitedRateGroupArray[n2];
                            l.getRateLimitBytesPerSecond();
                            ++n2;
                        }
                    }
                }
            }

            @Override
            public int getTagCurrentDownloadRate() {
                return (int)PeerSet.this.receive_rate.getAverage();
            }

            @Override
            public boolean getCanBePublicDefault() {
                return false;
            }

            @Override
            public int getTagUploadPriority() {
                return this.upload_priority;
            }

            @Override
            public void setTagUploadPriority(int priority) {
                if (priority < 0) {
                    priority = 0;
                }
                if (priority == this.upload_priority) {
                    return;
                }
                int old_up = this.upload_priority;
                this.upload_priority = priority;
                COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".uppri", priority);
                if (old_up == 0 || priority == 0) {
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        peer.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, priority > 0);
                    }
                }
            }

            @Override
            public void setTagBoost(boolean boost) {
                super.setTagBoost(boost);
                COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".boost", boost);
                List<PEPeer> peers = this.getTaggedPeers();
                for (PEPeer peer : peers) {
                    this.setBoost(peer, boost);
                }
            }

            private void setBoost(PEPeer pe_peer, boolean boost) {
                BuddyPlugin bp = SpeedLimitHandler.this.getBuddyPlugin();
                if (bp != null) {
                    boolean is_boosted;
                    boolean bl = is_boosted = pe_peer.getUserData(this.BOOSTED_KEY) != null;
                    if (boost || is_boosted) {
                        try {
                            Download download = PluginCoreUtils.wrap(((PeerSet)PeerSet.this).SpeedLimitHandler.this.core.getGlobalManager().getDownloadManager(new HashWrapper(pe_peer.getManager().getHash())));
                            Peer peer = PluginCoreUtils.wrap(pe_peer);
                            if (download != null && peer != null) {
                                if (boost) {
                                    if (!is_boosted) {
                                        bp.setPartialBuddy(download, peer, true, false);
                                        pe_peer.setUserData(this.BOOSTED_KEY, "");
                                    }
                                } else {
                                    bp.setPartialBuddy(download, peer, false, false);
                                    pe_peer.setUserData(this.BOOSTED_KEY, null);
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }

            @Override
            public void removeTag() {
                if (this.upload_priority > 0) {
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        peer.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
                        this.setBoost(peer, false);
                    }
                }
                super.removeTag();
            }

            @Override
            public String getDescription() {
                return PeerSet.this.getDetailString();
            }
        }
    }

    private class Prioritiser {
        private static final int FREQ_DEFAULT = 5;
        private static final int MIN_DEFAULT = 1024;
        private static final int MAX_DEFAULT = 0x6400000;
        private static final int PROBE_DEFAULT = 3;
        private static final int REST_DEFAULT = 12;
        private boolean is_down;
        private int freq = 5;
        private int min = 1024;
        private int max = 0x6400000;
        private int probe_period = 3;
        private String name = "";
        private int rest_ticks = 12;
        private int tick_count = 0;
        private int check_ticks = 1;
        private int skip_ticks = 0;
        private final List<Object[]> temp_states = new ArrayList<Object[]>();
        private final List<PrioritiserTagState> tag_states = new ArrayList<PrioritiserTagState>();
        private int phase = 0;
        private int phase_0_stable_waits = 0;
        private int phase_0_count = 0;
        private PrioritiserTagState phase_1_tag = null;
        private int phase_1_tag_state = 0;
        private int phase_1_tag_rate;
        private boolean phase_1_limit_hit;
        private int phase_1_higher_pri_rates;
        private int phase_1_lower_pri_decrease;
        private int consec_limits_hit = 0;
        private int phase_2_max_detected = 0;
        private final Map<PrioritiserTagState, int[]> phase_2_limits = new HashMap<PrioritiserTagState, int[]>();
        private int phase_4_tag_state = 0;
        private final Map<PrioritiserTagState, int[]> phase_4_limits = new HashMap<PrioritiserTagState, int[]>();
        private final Set<PrioritiserTagState> wake_on_active_tags = new HashSet<PrioritiserTagState>();

        private Prioritiser() {
            this.setFrequency(5);
        }

        private void setIsDown(boolean _down) {
            this.is_down = _down;
        }

        private void addTarget(int priority, TagType tag_type, String tag_name) {
            this.temp_states.add(new Object[]{tag_type, tag_name});
        }

        private void initialise() {
            for (Object[] entry : this.temp_states) {
                String tag_name;
                TagType tag_type = (TagType)entry[0];
                TagFeatureRateLimit tag = (TagFeatureRateLimit)((Object)tag_type.getTag(tag_name = (String)entry[1], true));
                if (tag == null) {
                    Debug.out("Hmm, tag '" + tag_name + "' not found for " + tag_type.getTagTypeName(true));
                    continue;
                }
                PrioritiserTagState tag_state = new PrioritiserTagState(tag);
                this.tag_states.add(tag_state);
                this.setLimit(tag_state, this.tag_states.size() == 1 ? this.max : -1, "initial");
            }
        }

        private int getTargetCount() {
            return this.temp_states.size();
        }

        private void setFrequency(int _freq) {
            this.freq = _freq;
            this.check_ticks = this.freq * 1000 / 5000;
            if (this.check_ticks < 1) {
                this.check_ticks = 1;
            }
        }

        private void setMinimum(int _min) {
            this.min = _min;
        }

        private void setMaximum(int _max) {
            this.max = _max;
        }

        private void setProbePeriod(int _period) {
            this.probe_period = _period;
        }

        private void setRestTicks(int ticks) {
            this.rest_ticks = ticks;
        }

        private void setName(String str) {
            this.name = str;
        }

        private String getName() {
            return this.name;
        }

        private void check() {
            if (!SpeedLimitHandler.this.prioritiser_enabled) {
                for (PrioritiserTagState tag_state : this.tag_states) {
                    tag_state.setLimit(Integer.MAX_VALUE, "disabled");
                }
                return;
            }
            int num_tags = this.tag_states.size();
            if (this.skip_ticks > 0) {
                --this.skip_ticks;
                int total_wakeup_rate = 0;
                for (PrioritiserTagState tag_state : this.tag_states) {
                    boolean active;
                    int raw_rate = tag_state.updateAverage(true);
                    if (!this.wake_on_active_tags.contains(tag_state) || !(active = tag_state.update())) continue;
                    total_wakeup_rate += raw_rate;
                }
                if (total_wakeup_rate > 2048) {
                    this.log("Waking up early, active tag(s) detected");
                    this.skip_ticks = 0;
                } else {
                    return;
                }
            }
            this.wake_on_active_tags.clear();
            ++this.tick_count;
            if (this.tick_count % this.check_ticks != 0) {
                return;
            }
            ArrayList<PrioritiserTagState> active_tags = new ArrayList<PrioritiserTagState>();
            boolean adjusting = false;
            int rate_available = this.phase_2_max_detected == 0 ? this.max : this.phase_2_max_detected;
            int i = 0;
            while (i < num_tags) {
                PrioritiserTagState tag_state = this.tag_states.get(i);
                tag_state.updateAverage(false);
                int rate = tag_state.getRate();
                boolean active = tag_state.update();
                if (active) {
                    active_tags.add(tag_state);
                    if (tag_state.isAdjusting()) {
                        adjusting = true;
                    }
                } else {
                    int inactive_rate = i < num_tags / 3 ? Math.max(rate_available, 5120) : 5120;
                    tag_state.setLimit(inactive_rate, "inactive[no log]");
                }
                rate_available -= rate;
                ++i;
            }
            int num_active = active_tags.size();
            if (num_active == 0) {
                return;
            }
            if (num_active == 1) {
                ((PrioritiserTagState)active_tags.get(0)).setLimit(this.max, "only one active");
                return;
            }
            if (adjusting) {
                return;
            }
            String str = "";
            int i2 = 0;
            while (i2 < num_active) {
                PrioritiserTagState tag_state = (PrioritiserTagState)active_tags.get(i2);
                if (!this.is_down) {
                    tag_state.getTag().setTagUploadPriority(i2 <= (num_active - 1) / 3 ? 1 : 0);
                }
                str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + tag_state.getString();
                ++i2;
            }
            GlobalManagerStats gm_stats = SpeedLimitHandler.this.core.getGlobalManager().getStats();
            long glob = this.is_down ? gm_stats.getSmoothedReceiveRate() : gm_stats.getSmoothedSendRate();
            this.log("* " + str + " [global=" + this.formatRate(glob, false) + "]");
            if (this.phase == 0) {
                int rate;
                boolean all_good = true;
                if (this.phase_0_stable_waits < 1) {
                    ++this.phase_0_stable_waits;
                    int i3 = 0;
                    while (i3 < active_tags.size()) {
                        PrioritiserTagState tag_state = (PrioritiserTagState)active_tags.get(i3);
                        int limit = tag_state.getLimit();
                        rate = tag_state.getRate();
                        boolean stable = tag_state.isStable();
                        if (limit == -1) {
                            limit = 0;
                        }
                        if (!stable || !this.sameRate(limit, rate)) {
                            int target;
                            boolean weak_tag = false;
                            boolean weakly_stable = false;
                            int probe_rate = tag_state.getProbeRate();
                            if (tag_state.getStrength() < 5 && probe_rate > 0) {
                                weak_tag = true;
                                if (rate >= 80 * probe_rate / 100) {
                                    weakly_stable = true;
                                }
                            }
                            if (weakly_stable) {
                                target = Math.max(probe_rate * 2, rate);
                                target = Math.min(this.max, target);
                                if ((target -= 2048) < 1024) {
                                    target = 1024;
                                }
                                tag_state.setLimit(target, "0: weak stable");
                            } else {
                                all_good = false;
                                if (limit > 0) {
                                    if (stable) {
                                        target = rate;
                                        if (target < 1024) {
                                            target = 1024;
                                        }
                                        tag_state.setLimit(target, "0: reducing to current");
                                    } else {
                                        target = rate - 2048;
                                        if (target <= 1024) {
                                            target = -1;
                                        }
                                        tag_state.setLimit(target, "0: reducing, unstable");
                                    }
                                }
                            }
                        }
                        ++i3;
                    }
                }
                if (all_good) {
                    this.phase_0_stable_waits = 0;
                    if (this.probe_period > 0 && this.phase_0_count % (this.probe_period + 1) == 0) {
                        this.phase_2_limits.clear();
                        boolean changed = false;
                        for (PrioritiserTagState tag : active_tags) {
                            rate = tag.getRate();
                            this.phase_2_limits.put(tag, new int[]{tag.getLimit(), rate, rate});
                            if (!tag.setLimit(this.max, "1: probing")) continue;
                            changed = true;
                        }
                        if (changed) {
                            this.phase = 2;
                            this.skip_ticks = 1;
                        }
                    }
                    if (this.phase == 0) {
                        this.phase = 1;
                        this.phase_1_tag = (PrioritiserTagState)active_tags.get(0);
                        this.phase_1_tag_state = 0;
                        this.phase_1_limit_hit = false;
                    }
                }
            } else if (this.phase == 1) {
                int start_index = active_tags.indexOf(this.phase_1_tag);
                if (start_index == -1) {
                    this.phase = 0;
                } else {
                    boolean stay_in_phase_1 = false;
                    int i4 = start_index;
                    block6: while (i4 < num_active) {
                        int rate;
                        PrioritiserTagState s;
                        PrioritiserTagState tag_state;
                        this.phase_1_tag = tag_state = (PrioritiserTagState)active_tags.get(i4);
                        int current_rate = tag_state.getRate();
                        int total_rate = 0;
                        int higher_pri_rates = 0;
                        int high_priority_strength = 0;
                        int low_priority_strength = 0;
                        int j = 0;
                        while (j < num_active) {
                            s = (PrioritiserTagState)active_tags.get(j);
                            rate = s.getRate();
                            total_rate += rate;
                            if (j < i4) {
                                higher_pri_rates += rate;
                            }
                            if (j <= i4) {
                                high_priority_strength += s.getStrength();
                            } else {
                                low_priority_strength += s.getStrength();
                            }
                            ++j;
                        }
                        if (this.phase_2_max_detected > 0 && this.phase_2_max_detected < total_rate) {
                            this.phase_2_max_detected = total_rate;
                        }
                        if (tag_state.getLimit() != this.max && this.phase_1_tag_state == 0) {
                            int raise_to;
                            j = 0;
                            while (j < i4) {
                                s = (PrioritiserTagState)active_tags.get(j);
                                rate = s.getRate();
                                s.setPreTestRate(rate);
                                ++j;
                            }
                            int limits_hit = tag_state.getLimitsHit();
                            if (limits_hit == 0) {
                                raise_to = this.max;
                            } else {
                                int diff = this.max - current_rate;
                                int bump = diff / (limits_hit + 1);
                                if (bump < 2048) {
                                    bump = 2048;
                                }
                                raise_to = Math.min(current_rate + bump, this.max);
                            }
                            int change_type = 0;
                            if (i4 < num_active / 3 && high_priority_strength <= low_priority_strength / 2) {
                                change_type = 1;
                            }
                            tag_state.setLimit(raise_to, change_type, "1: raising to " + (raise_to == this.max ? "max" : this.formatRate(raise_to, true)) + " {" + high_priority_strength + "/" + low_priority_strength + "}");
                            int decrease_by = 2048;
                            int j2 = 0;
                            while (j2 < this.consec_limits_hit) {
                                if ((decrease_by *= 2) > Math.min(this.max / 4, 10240)) break;
                                ++j2;
                            }
                            int total_decrease = 0;
                            int j3 = num_active - 1;
                            while (j3 > i4) {
                                int target;
                                int decrease;
                                PrioritiserTagState ts = (PrioritiserTagState)active_tags.get(j3);
                                int rate2 = ts.getRate();
                                if (rate2 >= decrease_by) {
                                    decrease = decrease_by;
                                    target = rate2 - decrease_by;
                                    decrease_by = 0;
                                } else {
                                    decrease = rate2;
                                    target = 0;
                                    decrease_by -= rate2;
                                }
                                total_decrease += decrease;
                                if (target <= 1024) {
                                    target = -1;
                                }
                                ts.setLimit(target, "1: decreasing lower priority (dec=" + this.formatRate(decrease, false) + ")");
                                if (decrease_by <= 0) break;
                                --j3;
                            }
                            this.phase_1_tag_state = 1;
                            this.phase_1_tag_rate = current_rate;
                            this.phase_1_higher_pri_rates = higher_pri_rates;
                            this.phase_1_lower_pri_decrease = total_decrease;
                            stay_in_phase_1 = true;
                            this.skip_ticks = 1;
                            break;
                        }
                        if (this.phase_1_tag_state == 1) {
                            int j4;
                            boolean limit_hit;
                            int my_diff = current_rate - this.phase_1_tag_rate;
                            int hp_diff = higher_pri_rates - this.phase_1_higher_pri_rates;
                            int my_target = current_rate;
                            if (my_target <= 1024) {
                                my_target = -1;
                            } else if (this.sameRate(my_target, this.max)) {
                                my_target = this.max;
                            }
                            int overall_gain = my_diff + hp_diff - this.phase_1_lower_pri_decrease;
                            int hp_drop = -hp_diff;
                            boolean bl = limit_hit = hp_drop > 0 && my_diff > 0;
                            if (limit_hit) {
                                if (hp_drop <= 1024 || hp_drop <= 3 * this.phase_1_higher_pri_rates / 100) {
                                    limit_hit = false;
                                } else if (hp_drop <= 10240 && overall_gain >= 3 * hp_drop && high_priority_strength >= low_priority_strength) {
                                    limit_hit = false;
                                    if ((my_target -= 3 * hp_drop) <= 1024) {
                                        my_target = -1;
                                    }
                                }
                            }
                            if (limit_hit) {
                                boolean stick_with_decision = false;
                                j4 = 0;
                                while (j4 < i4) {
                                    PrioritiserTagState s2 = (PrioritiserTagState)active_tags.get(j4);
                                    int pre_rate = s2.getPreTestRate();
                                    int rate3 = s2.getRate();
                                    int diff = rate3 - pre_rate;
                                    if (diff < 0) {
                                        if (s2.getStrength() < 5) {
                                            if (-diff >= pre_rate / 4) {
                                                stick_with_decision = true;
                                                break;
                                            }
                                            int probe_rate = s2.getProbeRate();
                                            if (probe_rate <= 0 || rate3 < 110 * probe_rate / 100) {
                                                stick_with_decision = true;
                                                break;
                                            }
                                        } else {
                                            stick_with_decision = true;
                                            break;
                                        }
                                    }
                                    ++j4;
                                }
                                if (!stick_with_decision) {
                                    limit_hit = false;
                                    this.log("Ignoring limit indicator as weak tags within probed limits (diffs=" + this.formatRate(hp_diff, false) + "/" + this.formatRate(my_diff, false));
                                }
                            }
                            if (limit_hit) {
                                if (this.phase_1_limit_hit || hp_drop > 10240) {
                                    if (overall_gain > 4096) {
                                        my_target = this.phase_1_tag_rate + overall_gain / 4;
                                    } else {
                                        my_target = current_rate + hp_diff;
                                        my_target = Math.min(my_target, this.phase_1_tag_rate - 2048);
                                    }
                                    if (my_target <= 1024) {
                                        my_target = -1;
                                    }
                                    ++this.consec_limits_hit;
                                    tag_state.hitLimit(true);
                                    tag_state.setLimit(my_target, 2, "1: adjusting after limit hit (diffs=" + this.formatRate(hp_diff, false) + "/" + this.formatRate(my_diff, false) + ", consec=" + this.consec_limits_hit + ")");
                                    int low_pri_rates = 0;
                                    j4 = num_active - 1;
                                    while (j4 > i4) {
                                        PrioritiserTagState ts = (PrioritiserTagState)active_tags.get(j4);
                                        low_pri_rates += ts.getRate();
                                        --j4;
                                    }
                                    int decrease_by = low_pri_rates / 4;
                                    decrease_by = Math.min(decrease_by, 32768);
                                    int total_decrease = 0;
                                    int j5 = active_tags.size() - 1;
                                    while (j5 > i4) {
                                        int target;
                                        int decrease;
                                        if (decrease_by <= 0) break block6;
                                        PrioritiserTagState ts = (PrioritiserTagState)active_tags.get(j5);
                                        int rate4 = ts.getRate();
                                        if (rate4 >= decrease_by) {
                                            decrease = decrease_by;
                                            target = rate4 - decrease_by;
                                            decrease_by = 0;
                                        } else {
                                            decrease = rate4;
                                            target = 0;
                                            decrease_by -= rate4;
                                        }
                                        total_decrease += decrease;
                                        if (target <= 1024) {
                                            target = -1;
                                        }
                                        ts.setLimit(target, "1: decreasing lower priority (dec=" + this.formatRate(decrease, false) + ")");
                                        --j5;
                                    }
                                    break;
                                }
                                this.phase_1_limit_hit = true;
                                tag_state.hitLimit(true);
                                tag_state.setLimit(this.phase_1_tag_rate, 2, "1: limit hit (diffs=" + this.formatRate(hp_diff, false) + "/" + this.formatRate(my_diff, false) + ", verifying");
                                this.phase_1_tag_state = 0;
                                stay_in_phase_1 = true;
                                break;
                            }
                            this.phase_1_limit_hit = false;
                            tag_state.hitLimit(false);
                            tag_state.setLimit(my_target, "1: setting to current (diffs=" + this.formatRate(hp_diff, false) + "/" + this.formatRate(my_diff, false) + ")");
                            if (i4 < num_active - 1) {
                                boolean quit_now = false;
                                if (this.phase_2_max_detected > 0) {
                                    int hp_rate = 0;
                                    int j6 = 0;
                                    while (j6 <= i4) {
                                        hp_rate += ((PrioritiserTagState)active_tags.get(j6)).getRate();
                                        ++j6;
                                    }
                                    if (hp_rate >= 90 * this.phase_2_max_detected / 100) {
                                        quit_now = true;
                                    }
                                }
                                if (quit_now) {
                                    this.log("Higher priority tags satisfy 90% of last probe result (" + this.formatRate(this.phase_2_max_detected, false) + ")");
                                    break;
                                }
                                this.phase_1_tag = (PrioritiserTagState)active_tags.get(i4 + 1);
                                this.phase_1_tag_state = 0;
                                stay_in_phase_1 = true;
                                break;
                            }
                            this.consec_limits_hit = 0;
                            break;
                        }
                        ++i4;
                    }
                    if (!stay_in_phase_1) {
                        this.phase = 3;
                    }
                }
            } else if (this.phase == 2) {
                long old_total_rate = 0L;
                long new_total_rate = 0L;
                long total_inc = 0L;
                String probe_str = "";
                boolean tag_rate_went_down = false;
                for (PrioritiserTagState tag : active_tags) {
                    int[] entry = this.phase_2_limits.get(tag);
                    if (entry == null) continue;
                    int old_rate = entry[1];
                    old_total_rate += (long)old_rate;
                    int new_rate = tag.getRate();
                    tag.setProbeRate(new_rate);
                    new_total_rate += (long)new_rate;
                    entry[2] = new_rate;
                    int inc = new_rate - old_rate;
                    if (inc > 0) {
                        total_inc += (long)inc;
                        probe_str = String.valueOf(probe_str) + (probe_str.length() == 0 ? "" : ", ") + tag.getTagName() + " +" + this.formatRate(inc, false);
                        continue;
                    }
                    if (inc >= -1024) continue;
                    tag_rate_went_down = true;
                }
                long diff = new_total_rate - old_total_rate;
                this.phase_2_max_detected = (int)new_total_rate;
                this.log("Probe result: before=" + this.formatRate(old_total_rate, false) + ", after=" + this.formatRate(new_total_rate, false) + ", inc=" + this.formatRate(total_inc, false) + " [" + probe_str + "]");
                int major_done = 0;
                int major_skipped = 0;
                for (Map.Entry<PrioritiserTagState, int[]> entry : this.phase_2_limits.entrySet()) {
                    int change_type;
                    PrioritiserTagState tag = entry.getKey();
                    int[] vals = entry.getValue();
                    int limit = vals[0];
                    if (tag_rate_went_down) {
                        change_type = 2;
                    } else {
                        change_type = 0;
                        if (diff > 0L && total_inc > 0L) {
                            int new_rate = vals[2];
                            int old_rate = vals[1];
                            int inc = new_rate - old_rate;
                            if (inc > 0) {
                                if ((limit += (int)((long)inc * diff / total_inc)) > this.max) {
                                    limit = this.max;
                                }
                            } else {
                                change_type = 2;
                            }
                        } else {
                            change_type = 2;
                        }
                    }
                    boolean did_it = tag.setLimit(limit, change_type, "2: probe result");
                    if (change_type == 0) continue;
                    if (did_it) {
                        ++major_done;
                        continue;
                    }
                    ++major_skipped;
                }
                if (major_skipped > 0 && major_done == 0) {
                    this.skip_ticks = 2;
                }
                this.phase = 0;
                ++this.phase_0_count;
            } else if (this.phase == 3) {
                if (this.rest_ticks > 0 && this.phase_2_max_detected > 0) {
                    int current_rate = 0;
                    for (PrioritiserTagState tag : active_tags) {
                        int rate = tag.getRate();
                        current_rate += rate;
                    }
                    int achieved = current_rate * 100 / this.phase_2_max_detected;
                    this.skip_ticks = Math.min(this.rest_ticks, (achieved += 10) * this.rest_ticks / 100);
                    ((PrioritiserTagState)active_tags.get(0)).setLimit(this.max, "resting");
                    int i5 = 0;
                    while (i5 < (num_tags + 2) / 3) {
                        PrioritiserTagState tag = this.tag_states.get(i5);
                        if (!active_tags.contains(tag)) {
                            this.wake_on_active_tags.add(tag);
                        }
                        ++i5;
                    }
                    this.log("Resting for " + this.skip_ticks);
                    this.phase_4_tag_state = 0;
                    this.phase = 4;
                } else {
                    this.phase = 0;
                    ++this.phase_0_count;
                }
            } else if (this.phase == 4) {
                if (this.phase_4_tag_state == 0) {
                    this.phase_4_limits.clear();
                    boolean changed = false;
                    int cutoff = (num_active + 2) / 3;
                    int i6 = 0;
                    while (i6 < num_active) {
                        PrioritiserTagState tag = (PrioritiserTagState)active_tags.get(i6);
                        int limit = tag.getLimit();
                        int rate = tag.getRate();
                        this.phase_4_limits.put(tag, new int[]{limit, rate, rate, i6 < cutoff ? 0 : 1});
                        if (i6 < cutoff) {
                            if (tag.setLimit(this.max, "4: mini-probing")) {
                                changed = true;
                            }
                        } else {
                            if (!changed) break;
                            int lim = 9 * rate / 10;
                            if (lim < 1024) {
                                lim = 1024;
                            }
                            tag.setLimit(lim, "4: mini-probing");
                        }
                        ++i6;
                    }
                    if (changed) {
                        this.phase_4_tag_state = 1;
                        this.skip_ticks = 1;
                    } else {
                        this.phase = 0;
                        ++this.phase_0_count;
                    }
                } else {
                    int[] details;
                    PrioritiserTagState tag;
                    int total_inc = 0;
                    String probe_str = "";
                    for (Map.Entry<PrioritiserTagState, int[]> entry : this.phase_4_limits.entrySet()) {
                        int new_rate;
                        boolean hp;
                        tag = entry.getKey();
                        details = entry.getValue();
                        if (!active_tags.contains(tag)) continue;
                        boolean bl = hp = details[3] == 0;
                        if (!hp) continue;
                        int old_rate = details[1];
                        details[2] = new_rate = tag.getRate();
                        int inc = new_rate - old_rate;
                        if (inc <= 0) continue;
                        if (tag.getProbeRate() < new_rate) {
                            tag.setProbeRate(new_rate);
                        }
                        total_inc += inc;
                        probe_str = String.valueOf(probe_str) + (probe_str.length() == 0 ? "" : ", ") + tag.getTagName() + " +" + this.formatRate(inc, false);
                    }
                    this.log("Mini-probe result: inc=" + this.formatRate(total_inc, false) + " [" + probe_str + "]");
                    if (total_inc <= 10240) {
                        for (Map.Entry<PrioritiserTagState, int[]> entry : this.phase_4_limits.entrySet()) {
                            tag = entry.getKey();
                            details = entry.getValue();
                            tag.setLimit(details[0], "4: reverting");
                        }
                        this.skip_ticks = 1;
                    }
                    this.phase = 0;
                    ++this.phase_0_count;
                }
            }
        }

        private String formatRate(long rate, boolean is_limit) {
            if (rate == -1L && is_limit) {
                return "x";
            }
            if (rate < 0L) {
                return "-" + DisplayFormatters.formatByteCountToKiBEtcPerSec(-rate);
            }
            if ((rate == 0L || rate >= 0x6400000L) && is_limit) {
                return "\u221e";
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(rate);
        }

        private boolean setLimit(PrioritiserTagState tag_state, int rate, String reason) {
            if (rate > 1024) {
                rate = rate / 256 * 256;
            }
            TagFeatureRateLimit tag = tag_state.getTag();
            if (this.is_down) {
                if (rate != tag.getTagDownloadLimit()) {
                    tag.setTagDownloadLimit(rate);
                    if (!reason.contains("[no log]")) {
                        this.log(tag_state, "->" + this.formatRate(rate, true) + " (" + reason + ")");
                    }
                    return true;
                }
            } else if (rate != tag.getTagUploadLimit()) {
                tag.setTagUploadLimit(rate);
                if (!reason.contains("[no log]")) {
                    this.log(tag_state, "->" + this.formatRate(rate, true) + " (" + reason + ")");
                }
                return true;
            }
            return false;
        }

        private boolean sameRate(int r1, int r2) {
            int diff = Math.abs(r1 - r2);
            if (diff <= 1024) {
                return true;
            }
            int max = Math.max(r1, r2);
            return max * 3 / 100 >= diff;
        }

        private void log(PrioritiserTagState tag_state, String str) {
            this.log(String.valueOf(tag_state.getTagName()) + ": " + str);
        }

        private void log(String str) {
            if (this.name.length() > 0) {
                SpeedLimitHandler.this.logger.log("priority " + this.name + ": " + str);
            } else {
                SpeedLimitHandler.this.logger.log("priority: " + str);
            }
        }

        class PrioritiserTagState {
            private static final int STABLE_PERIODS = 2;
            private static final int AVERAGE_PERIODS = 3;
            private static final int ADJUSTMENT_PERIODS = 2;
            private static final int INITIAL_ADJUSTMENT_PERIODS = 4;
            private static final int CT_NORMAL = 0;
            private static final int CT_MEDIUM = 1;
            private static final int CT_MAJOR = 2;
            private final TagFeatureRateLimit tag;
            private final MovingImmediateAverage average = AverageFactory.MovingImmediateAverage(3);
            private final int[] last_averages = new int[2];
            private int active_ticks = 0;
            private int last_average_index;
            private boolean last_stable;
            private int last_rate;
            private int last_limit;
            private int adjusting_ticks = 4;
            private int tag_limits_hit;
            private int strength;
            private int probe_rate = -1;
            private int pre_test_rate;
            private long last_byte_count = -1L;
            private long last_average_time = 0L;

            private PrioritiserTagState(TagFeatureRateLimit _tag) {
                this.tag = _tag;
            }

            private String getTagName() {
                return this.tag.getTag().getTagName(true);
            }

            private int getWeight(List<PEPeer> peers) {
                int weight = 0;
                for (PEPeer peer : peers) {
                    if (peer.getPeerState() != 30) continue;
                    ++weight;
                }
                return weight;
            }

            private boolean update() {
                Tag t = this.tag.getTag();
                int weight = 0;
                if (t instanceof TagDownload) {
                    Set<com.biglybt.core.download.DownloadManager> downloads = ((TagDownload)this.tag).getTaggedDownloads();
                    for (com.biglybt.core.download.DownloadManager dm : downloads) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null || Prioritiser.this.is_down && dm.isDownloadComplete(false)) continue;
                        LimitedRateGroup[] limiters = dm.getRateLimiters(!Prioritiser.this.is_down);
                        boolean disabled = false;
                        LimitedRateGroup[] limitedRateGroupArray = limiters;
                        int n = limiters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LimitedRateGroup rl = limitedRateGroupArray[n2];
                            disabled = rl.isDisabled();
                            if (disabled) break;
                            ++n2;
                        }
                        if (disabled) continue;
                        List<PEPeer> peers = pm.getPeers();
                        weight += this.getWeight(peers);
                    }
                } else {
                    List<PEPeer> peers = ((TagPeer)this.tag).getTaggedPeers();
                    weight = this.getWeight(peers);
                }
                this.strength = weight;
                if (weight > 0) {
                    ++this.active_ticks;
                    return this.active_ticks > 1;
                }
                this.active_ticks = 0;
                return false;
            }

            private int updateAverage(boolean is_skip_cycle) {
                int rate;
                int limit;
                long[] current_byte_counts;
                long now = SystemTime.getMonotonousTime();
                if (Prioritiser.this.is_down) {
                    current_byte_counts = this.tag.getTagDownloadTotal();
                    limit = this.tag.getTagDownloadLimit();
                } else {
                    current_byte_counts = this.tag.getTagUploadTotal();
                    limit = this.tag.getTagUploadLimit();
                }
                long current_byte_count = 0L;
                long[] lArray = current_byte_counts;
                int n = current_byte_counts.length;
                int n2 = 0;
                while (n2 < n) {
                    long l = lArray[n2];
                    current_byte_count += l;
                    ++n2;
                }
                if (this.last_byte_count == -1L) {
                    rate = 0;
                } else {
                    long diff_bytes = current_byte_count - this.last_byte_count;
                    long diff_time = now - this.last_average_time;
                    rate = diff_time <= 0L ? 0 : (int)(diff_bytes * 1000L / diff_time);
                }
                this.last_byte_count = current_byte_count;
                this.last_average_time = now;
                if (!is_skip_cycle) {
                    if (this.adjusting_ticks > 0) {
                        --this.adjusting_ticks;
                    }
                    if (limit == -1) {
                        rate = 0;
                    } else if (rate > limit) {
                        rate = limit;
                    }
                    int average_rate = (int)this.average.update(rate);
                    boolean stable = true;
                    int[] nArray = this.last_averages;
                    int n3 = this.last_averages.length;
                    n = 0;
                    while (n < n3) {
                        int la = nArray[n];
                        if (!Prioritiser.this.sameRate(average_rate, la)) {
                            stable = false;
                        }
                        ++n;
                    }
                    this.last_averages[this.last_average_index++ % this.last_averages.length] = average_rate;
                    this.last_limit = limit;
                    this.last_rate = average_rate;
                    this.last_stable = stable;
                }
                return rate;
            }

            private TagFeatureRateLimit getTag() {
                return this.tag;
            }

            private int getLimit() {
                return this.last_limit;
            }

            private int getRate() {
                return this.last_rate;
            }

            private boolean isStable() {
                return this.last_stable;
            }

            private boolean isAdjusting() {
                return this.adjusting_ticks > 0;
            }

            public int getStrength() {
                return this.strength;
            }

            private int getLimitsHit() {
                return this.tag_limits_hit;
            }

            private void hitLimit(boolean b) {
                this.tag_limits_hit = b ? ++this.tag_limits_hit : 0;
            }

            private boolean setLimit(int limit, String reason) {
                return this.setLimit(limit, 0, reason);
            }

            private boolean setLimit(int limit, int change_type, String reason) {
                if (limit == Integer.MAX_VALUE) {
                    limit = 0;
                } else if (limit < Prioritiser.this.min) {
                    limit = Prioritiser.this.min;
                } else if (limit > Prioritiser.this.max) {
                    limit = Prioritiser.this.max;
                }
                if (change_type == 1) {
                    reason = String.valueOf(reason) + " (medium)";
                } else if (change_type == 2) {
                    reason = String.valueOf(reason) + " (major)";
                }
                if (Prioritiser.this.setLimit(this, limit, reason)) {
                    this.last_limit = limit;
                    this.average.reset();
                    this.adjusting_ticks = 2;
                    if (change_type == 1) {
                        ++this.adjusting_ticks;
                    } else if (change_type == 2) {
                        this.adjusting_ticks *= 2;
                    }
                    return true;
                }
                return false;
            }

            private void setProbeRate(int rate) {
                this.probe_rate = rate;
            }

            private int getProbeRate() {
                return this.probe_rate;
            }

            private void setPreTestRate(int rate) {
                this.pre_test_rate = rate;
            }

            private int getPreTestRate() {
                return this.pre_test_rate;
            }

            private String getString() {
                String str = String.valueOf(this.getTagName()) + "=" + Prioritiser.this.formatRate(this.getRate(), false) + " (" + Prioritiser.this.formatRate(this.getLimit(), true) + ") {" + this.getStrength() + (this.probe_rate <= 0 ? "" : "/" + Prioritiser.this.formatRate(this.probe_rate, false)) + "}";
                return str;
            }
        }
    }

    private static class ScheduleRule {
        private static final byte FR_MON = 1;
        private static final byte FR_TUE = 2;
        private static final byte FR_WED = 4;
        private static final byte FR_THU = 8;
        private static final byte FR_FRI = 16;
        private static final byte FR_SAT = 32;
        private static final byte FR_SUN = 64;
        private static final byte FR_OVERFLOW = -128;
        private static final byte FR_WEEKDAY = 31;
        private static final byte FR_WEEKEND = 96;
        private static final byte FR_DAILY = 127;
        final String profile_name;
        final byte frequency;
        final int from_mins;
        final int to_mins;
        private final List<ScheduleRuleExtensions> extensions;

        private ScheduleRule(byte _freq, String _profile, int _from, int _to, List<ScheduleRuleExtensions> _exts) {
            this.frequency = _freq;
            this.profile_name = _profile;
            this.from_mins = _from;
            this.to_mins = _to;
            this.extensions = _exts;
        }

        private List<ScheduleRule> splitByDay() {
            ArrayList<ScheduleRule> result = new ArrayList<ScheduleRule>();
            if (this.to_mins > this.from_mins) {
                result.add(this);
            } else {
                byte next_frequency = (byte)(this.frequency << 1);
                if ((next_frequency & 0xFFFFFF80) != 0) {
                    next_frequency = (byte)(next_frequency & 0x7F);
                    next_frequency = (byte)(next_frequency | 1);
                }
                ScheduleRule rule1 = new ScheduleRule(this.frequency, this.profile_name, this.from_mins, 1439, this.extensions);
                ScheduleRule rule2 = new ScheduleRule(next_frequency, this.profile_name, 0, this.to_mins, this.extensions);
                result.add(rule1);
                result.add(rule2);
            }
            return result;
        }

        private void checkExtensions() {
            if (this.extensions != null) {
                for (ScheduleRuleExtensions ext : this.extensions) {
                    ext.checkExtension();
                }
            }
        }

        private boolean sameAs(ScheduleRule other) {
            if (other == null) {
                return false;
            }
            if (this.extensions != other.extensions) {
                if (this.extensions == null || other.extensions == null || this.extensions.size() != other.extensions.size()) {
                    return false;
                }
                for (ScheduleRuleExtensions ext1 : this.extensions) {
                    boolean match = false;
                    for (ScheduleRuleExtensions ext2 : other.extensions) {
                        if (!ext1.sameAs(ext2)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
            }
            return this.frequency == other.frequency && this.profile_name.equals(other.profile_name) && this.from_mins == other.from_mins && this.to_mins == other.to_mins;
        }

        public String getString() {
            String freq_str = "";
            if (this.frequency == 127) {
                freq_str = "daily";
            } else if (this.frequency == 31) {
                freq_str = "weekdays";
            } else if (this.frequency == 96) {
                freq_str = "weekends";
            } else if (this.frequency == 1) {
                freq_str = "mon";
            } else if (this.frequency == 2) {
                freq_str = "tue";
            } else if (this.frequency == 4) {
                freq_str = "wed";
            } else if (this.frequency == 8) {
                freq_str = "thu";
            } else if (this.frequency == 16) {
                freq_str = "fri";
            } else if (this.frequency == 32) {
                freq_str = "sat";
            } else if (this.frequency == 64) {
                freq_str = "sun";
            }
            String ext_str = "";
            if (this.extensions != null) {
                for (ScheduleRuleExtensions ext : this.extensions) {
                    ext_str = String.valueOf(ext_str) + ", " + ext.getString();
                }
            }
            return "profile=" + this.profile_name + ", frequency=" + freq_str + ", from=" + this.getTime(this.from_mins) + ", to=" + this.getTime(this.to_mins) + ext_str;
        }

        private String getTime(int mins) {
            String str = String.valueOf(this.getTimeBit(mins / 60)) + ":" + this.getTimeBit(mins % 60);
            return str;
        }

        private String getTimeBit(int num) {
            String str = String.valueOf(num);
            if (str.length() < 2) {
                str = "0" + str;
            }
            return str;
        }
    }

    private class ScheduleRuleExtensions {
        private static final int ET_START_TAG = 1;
        private static final int ET_STOP_TAG = 2;
        private static final int ET_PAUSE_TAG = 3;
        private static final int ET_RESUME_TAG = 4;
        private static final int ET_ENABLE_PRIORITY = 5;
        private static final int ET_DISABLE_PRIORITY = 6;
        private static final int ET_ENABLE_NET_LIMIT = 7;
        private static final int ET_DISABLE_NET_LIMIT = 8;
        private final int extension_type;
        private final TagDownload tag;
        private final List<NetLimit> net_limits;

        private ScheduleRuleExtensions(int _et) {
            this.extension_type = _et;
            this.tag = null;
            this.net_limits = null;
        }

        private ScheduleRuleExtensions(int _et, TagDownload _tag) {
            this.extension_type = _et;
            this.tag = _tag;
            this.net_limits = null;
        }

        private ScheduleRuleExtensions(int _et, List<NetLimit> _net_limits) {
            this.extension_type = _et;
            this.tag = null;
            this.net_limits = _net_limits;
        }

        private void checkExtension() {
            if (this.net_limits != null) {
                boolean enable = this.extension_type == 7;
                for (NetLimit nl : this.net_limits) {
                    nl.setEnabled(enable);
                }
            } else if (this.tag == null) {
                if (this.extension_type == 5) {
                    SpeedLimitHandler.this.prioritiser_enabled = true;
                } else {
                    SpeedLimitHandler.this.prioritiser_enabled = false;
                }
            } else {
                Set<com.biglybt.core.download.DownloadManager> downloads = this.tag.getTaggedDownloads();
                for (com.biglybt.core.download.DownloadManager download : downloads) {
                    if (download.isPaused()) {
                        if (this.extension_type != 4 || SpeedLimitHandler.this.rule_pause_all_active || SpeedLimitHandler.this.net_limit_pause_all_active) continue;
                        download.resume();
                        continue;
                    }
                    int state = download.getState();
                    if (this.extension_type == 1) {
                        if (state != 70) continue;
                        download.setStateWaiting();
                        continue;
                    }
                    if (this.extension_type == 3) {
                        if (!SpeedLimitHandler.this.pause_forced_downloads && download.isForceStart()) continue;
                        if (!download.isPaused()) {
                            download.pause(true);
                        }
                        download.setStopReason("Speed Limit Scheduler: Tag " + this.tag.getTagName(true));
                        continue;
                    }
                    if (this.extension_type != 2 || state == 8 || state == 7 || state == 6) continue;
                    download.stopIt(70, false, false);
                    download.setStopReason("Speed Limit Scheduler: Tag " + this.tag.getTagName(true));
                }
            }
        }

        private boolean sameAs(ScheduleRuleExtensions other) {
            return this.extension_type == other.extension_type && this.tag == other.tag;
        }

        private String getString() {
            String str = this.extension_type == 1 ? "start_tag" : (this.extension_type == 2 ? "stop_tag" : (this.extension_type == 4 ? "resume_tag" : (this.extension_type == 3 ? "pause_tag" : (this.extension_type == 5 ? "enable_priority" : (this.extension_type == 6 ? "disable_priority" : (this.extension_type == 7 ? "enable_net_limit" : (this.extension_type == 8 ? "disable_net_limit" : "eh?")))))));
            if (this.tag != null) {
                str = String.valueOf(str) + ":" + this.tag.getTagName(true);
            }
            if (this.net_limits != null) {
                str = String.valueOf(str) + ":netlimits=" + this.net_limits.size();
            }
            return str;
        }
    }

    private class StorageDetails {
        private final File root;
        private final String name;
        private final long min_space;

        private StorageDetails(File _root, String _name, long _min_space) {
            this.root = _root;
            this.name = _name;
            this.min_space = _min_space;
        }

        private void check() {
            try {
                long space = this.root.getFreeSpace();
                if (space < this.min_space) {
                    List<com.biglybt.core.download.DownloadManager> dms = SpeedLimitHandler.this.core.getGlobalManager().getDownloadManagers();
                    for (com.biglybt.core.download.DownloadManager dm : dms) {
                        String fs;
                        if (dm.getState() != 50 || !(fs = FileUtil.getFileStoreNames(dm.getAbsoluteSaveLocation())[0]).equals(this.name) || !SpeedLimitHandler.this.pause_forced_downloads && dm.isForceStart()) continue;
                        SpeedLimitHandler.this.logger.log("Pausing '" + dm.getDisplayName() + "', insufficient space on '" + this.root.getAbsolutePath() + "'");
                        dm.pause(true);
                        dm.setStopReason("Speed Limit Scheduler: Insufficient space on '" + this.root.getAbsolutePath() + "'");
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        private String getString() {
            return String.valueOf(this.name) + ", root=" + this.root.getAbsolutePath() + ", min_space=" + DisplayFormatters.formatByteCountToKiBEtc(this.min_space) + ", free=" + DisplayFormatters.formatByteCountToKiBEtc(this.root.getFreeSpace());
        }
    }
}

