/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

public class PingSpaceMapper {
    GridRegion[][] gridRegion;
    int lastDownloadBitsPerSec;
    int lastUploadBitsPerSec;
    final int goodPingInMilliSec;
    final int badPingInMilliSec;
    int totalPointsInMap = 0;
    private static final int maxMeshIndex = 70;
    public static final int RESULT_UPLOAD_INDEX = 0;
    public static final int RESULT_DOWNLOAD_INDEX = 1;
    static final int GOOD_PING_INDEX = 0;
    static final int ANY_PING_INDEX = 1;

    public PingSpaceMapper(int _goodPingInMilliSec, int _badPingInMilliSec) {
        this.createNewGrid();
        this.goodPingInMilliSec = _goodPingInMilliSec;
        this.badPingInMilliSec = _badPingInMilliSec;
    }

    private void createNewGrid() {
        this.gridRegion = null;
        this.gridRegion = new GridRegion[70][70];
        int upIndex = 0;
        while (upIndex < 70) {
            int downIndex = 0;
            while (downIndex < 70) {
                this.gridRegion[upIndex][downIndex] = new GridRegion();
                ++downIndex;
            }
            ++upIndex;
        }
    }

    private int convertBitsPerSec2meshIndex(int bitsPerSec) {
        if (bitsPerSec < 0) {
            return 0;
        }
        int bytesPerSec = bitsPerSec / 1024;
        if (bytesPerSec < 100) {
            return bytesPerSec / 10;
        }
        if (bytesPerSec < 500) {
            return 10 + (bytesPerSec - 100) / 50;
        }
        if (bytesPerSec < 5000) {
            return 18 + (bytesPerSec - 500) / 100;
        }
        return 63;
    }

    private int convertMeshIndex2bitsPerSec(int meshIndex) {
        int bytesPerSec = 0;
        if (meshIndex <= 0) {
            return 0;
        }
        bytesPerSec = meshIndex <= 10 ? meshIndex * 10 : (meshIndex <= 18 ? 100 + (meshIndex - 10) * 50 : 500 + (meshIndex - 18) * 100);
        return bytesPerSec * 1024;
    }

    public void setCurrentTransferRates(int downloadBitPerSec, int uploadBitsPerSec) {
        this.lastDownloadBitsPerSec = downloadBitPerSec;
        this.lastUploadBitsPerSec = uploadBitsPerSec;
    }

    public void addMetricToMap(int metric) {
        int downIndex = this.convertBitsPerSec2meshIndex(this.lastDownloadBitsPerSec);
        int upIndex = this.convertBitsPerSec2meshIndex(this.lastUploadBitsPerSec);
        ++this.totalPointsInMap;
        if (metric < this.goodPingInMilliSec) {
            this.gridRegion[upIndex][downIndex].incrementMetricCount(0);
        } else if (metric < this.badPingInMilliSec) {
            this.gridRegion[upIndex][downIndex].incrementMetricCount(1);
        } else {
            this.gridRegion[upIndex][downIndex].incrementMetricCount(2);
        }
    }

    public void reset() {
        this.totalPointsInMap = 0;
        this.createNewGrid();
    }

    private Result getHighestMeshIndexWithGoodPing() {
        Result[] retVal = this.calculate();
        return retVal[0];
    }

    private Result getHighestMeshIndexWithAnyPing() {
        Result[] retVal = this.calculate();
        return retVal[1];
    }

    public boolean hadChockingPing(boolean isDownloadTest) {
        int highPingIndex;
        int goodPingIndex;
        Result[] res = this.calculate();
        if (isDownloadTest) {
            goodPingIndex = res[0].getDownloadIndex();
            highPingIndex = res[1].getDownloadIndex();
        } else {
            goodPingIndex = res[0].getUploadIndex();
            highPingIndex = res[1].getUploadIndex();
        }
        return highPingIndex > goodPingIndex;
    }

    private Result[] calculate() {
        Result[] retVal = new Result[]{new Result(), new Result()};
        int upIndex = 0;
        while (upIndex < 70) {
            int downIndex = 0;
            while (downIndex < 70) {
                int count;
                float rating = this.gridRegion[upIndex][downIndex].getRating();
                if (rating > 0.0f) {
                    retVal[0].checkAndUpdate(upIndex, downIndex);
                }
                if ((count = this.gridRegion[upIndex][downIndex].getTotal()) > 0) {
                    retVal[1].checkAndUpdate(upIndex, downIndex);
                }
                ++downIndex;
            }
            ++upIndex;
        }
        return retVal;
    }

    public int guessUploadLimit() {
        Result result = this.getHighestMeshIndexWithGoodPing();
        int upMeshIndex = result.getUploadIndex();
        return this.convertMeshIndex2bitsPerSec(upMeshIndex);
    }

    public int guessDownloadLimit() {
        Result result = this.getHighestMeshIndexWithGoodPing();
        int downMeshIndex = result.getDownloadIndex();
        return this.convertMeshIndex2bitsPerSec(downMeshIndex);
    }

    static class GridRegion {
        public static final int INDEX_PING_GOOD = 0;
        public static final int INDEX_PING_NEUTRAL = 1;
        public static final int INDEX_PING_BAD = 2;
        final int[] pingCount = new int[3];
        int[] uploadBound = new int[2];
        int[] downloadBound = new int[2];

        GridRegion() {
        }

        public void incrementMetricCount(int pingIndex) {
            if (pingIndex >= 0 && pingIndex <= 3) {
                int n = pingIndex;
                this.pingCount[n] = this.pingCount[n] + 1;
            }
        }

        public float getRating() {
            int total = this.getTotal();
            if (total == 0) {
                return 0.0f;
            }
            float score = (float)this.pingCount[0] + 0.3f * (float)this.pingCount[1] - (float)this.pingCount[2];
            return score / (float)total;
        }

        public int getTotal() {
            return this.pingCount[0] + this.pingCount[1] + this.pingCount[2];
        }
    }

    static class Result {
        int highestUploadIndex = 0;
        int highestDownloadIndex = 0;

        Result() {
        }

        public void checkAndUpdate(int uploadIndex, int downloadIndex) {
            if (uploadIndex > this.highestUploadIndex) {
                this.highestUploadIndex = uploadIndex;
            }
            if (downloadIndex > this.highestDownloadIndex) {
                this.highestDownloadIndex = downloadIndex;
            }
        }

        public int getUploadIndex() {
            return this.highestUploadIndex;
        }

        public int getDownloadIndex() {
            return this.highestDownloadIndex;
        }
    }
}

