/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

import com.biglybt.core.CoreException;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.speedmanager.SpeedManagerPingSource;
import com.biglybt.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.biglybt.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.biglybt.core.speedmanager.impl.v2.PingSourceManager;
import com.biglybt.core.speedmanager.impl.v2.SMInstance;
import com.biglybt.core.speedmanager.impl.v2.SMUpdate;
import com.biglybt.core.speedmanager.impl.v2.SpeedLimitMonitor;
import com.biglybt.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.dht.DHTPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SpeedManagerAlgorithmProviderDHTPing
implements SpeedManagerAlgorithmProvider,
COConfigurationListener {
    private final SpeedManagerAlgorithmProviderAdapter adapter;
    private PluginInterface dhtPlugin;
    private long timeSinceLastUpdate;
    private static int metricGoodResult = 100;
    private static int metricGoodTolerance = 300;
    private static int metricBadResult = 1300;
    private static int metricBadTolerance = 300;
    private int consecutiveUpticks = 0;
    private int consecutiveDownticks = 0;
    private final SpeedLimitMonitor limitMonitor;
    private int lastMetricValue;
    private static int numIntervalsBetweenCal = 2;
    private static boolean skipIntervalAfterAdjustment = true;
    private List pingTimeList = new ArrayList();
    private boolean hadAdjustmentLastInterval = false;
    private int intervalCount = 0;
    final PingSourceManager pingSourceManager = new PingSourceManager();
    int sessionMaxUploadRate = 0;

    SpeedManagerAlgorithmProviderDHTPing(SpeedManagerAlgorithmProviderAdapter _adapter) {
        this.adapter = _adapter;
        SpeedManagerLogger.setAdapter("dht", this.adapter);
        this.limitMonitor = new SpeedLimitMonitor(this.adapter.getSpeedManager());
        COConfigurationManager.addListener(this);
        SMInstance.init(_adapter);
        try {
            this.dhtPlugin = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        }
        catch (CoreException ace) {
            this.log("Warning: Core was not initialized on startup.");
        }
        if (this.dhtPlugin == null) {
            this.log(" Error: failed to get DHT Plugin ");
        }
        this.limitMonitor.initPingSpaceMap(metricGoodResult + metricGoodTolerance, metricBadResult - metricBadTolerance);
    }

    @Override
    public void destroy() {
        COConfigurationManager.removeListener(this);
    }

    @Override
    public void configurationSaved() {
        try {
            this.limitMonitor.readFromPersistentMap();
            this.limitMonitor.updateFromCOConfigManager();
            metricGoodResult = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint");
            metricGoodTolerance = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance");
            metricBadResult = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint");
            metricBadTolerance = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance");
            skipIntervalAfterAdjustment = COConfigurationManager.getBooleanParameter("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
            numIntervalsBetweenCal = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
            this.limitMonitor.initPingSpaceMap(metricGoodResult + metricGoodTolerance, metricBadResult - metricBadTolerance);
            SpeedManagerLogger.trace("..DHTPing - configurationSaved called.");
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.getMessage());
        }
    }

    @Override
    public void reset() {
        this.log("reset");
        this.log("curr-data: curr-down-rate : curr-down-limit : down-capacity : down-bandwidth-mode : down-limit-mode : curr-up-rate : curr-up-limit : up-capacity : upload-bandwidth-mode : upload-limit-mode : transfer-mode");
        this.log("new-limit:newLimit:currStep:signalStrength:multiple:currUpLimit:maxStep:uploadLimitMax:uploadLimitMin:transferMode");
        this.log("consecutive:up:down");
        this.log("metric:value:type");
        this.log("user-comment:log");
        this.log("pin:upload-status,download-status,upload-unpin-timer,download-unpin-timer");
        this.log("limits:down-max:down-min:down-conf:up-max:up-min:up-conf");
        this.limitMonitor.resetPingSpace();
    }

    @Override
    public void updateStats() {
        int currUploadLimit = this.adapter.getCurrentUploadLimit();
        int currDataUploadSpeed = this.adapter.getCurrentDataUploadSpeed();
        int currProtoUploadSpeed = this.adapter.getCurrentProtocolUploadSpeed();
        int upRateBitsPerSec = currDataUploadSpeed + currProtoUploadSpeed;
        int currDownLimit = this.adapter.getCurrentDownloadLimit();
        int downDataRate = this.adapter.getCurrentDataDownloadSpeed();
        int downProtoRate = this.adapter.getCurrentProtocolDownloadSpeed();
        int downRateBitsPerSec = downDataRate + downProtoRate;
        this.limitMonitor.setDownloadBandwidthMode(downRateBitsPerSec, currDownLimit);
        this.limitMonitor.setUploadBandwidthMode(upRateBitsPerSec, currUploadLimit);
        this.limitMonitor.setDownloadLimitSettingMode(currDownLimit);
        this.limitMonitor.setUploadLimitSettingMode(currUploadLimit);
        this.limitMonitor.updateTransferMode();
        if (this.limitMonitor.isConfTestingLimits()) {
            this.limitMonitor.updateLimitTestingData(downRateBitsPerSec, upRateBitsPerSec);
        }
        this.limitMonitor.setCurrentTransferRates(downRateBitsPerSec, upRateBitsPerSec);
        if (upRateBitsPerSec > this.sessionMaxUploadRate) {
            this.sessionMaxUploadRate = upRateBitsPerSec;
        }
        this.logCurrentData(downRateBitsPerSec, currDownLimit, upRateBitsPerSec, currUploadLimit);
    }

    private void logCurrentData(int downRate, int currDownLimit, int upRate, int currUploadLimit) {
        StringBuilder sb = new StringBuilder("curr-data-v:" + downRate + ":" + currDownLimit + ":");
        sb.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        sb.append(this.limitMonitor.getDownloadBandwidthMode()).append(":");
        sb.append(this.limitMonitor.getDownloadLimitSettingMode()).append(":");
        sb.append(upRate).append(":").append(currUploadLimit).append(":");
        sb.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        sb.append(this.limitMonitor.getUploadBandwidthMode()).append(":");
        sb.append(this.limitMonitor.getUploadLimitSettingMode()).append(":");
        sb.append(this.limitMonitor.getTransferModeAsString());
        SpeedManagerLogger.log(sb.toString());
    }

    @Override
    public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        this.log("pingSourceFound");
        this.pingSourceManager.pingSourceFound(source, is_replacement);
    }

    @Override
    public void pingSourceFailed(SpeedManagerPingSource source) {
        this.log("pingSourceFailed");
        this.pingSourceManager.pingSourceFailed(source);
    }

    @Override
    public void calculate(SpeedManagerPingSource[] sources) {
        this.limitMonitor.logPMDataEx();
        int len = sources.length;
        int i = 0;
        while (i < len) {
            this.pingSourceManager.addPingTime(sources[i]);
            int pingTime = sources[i].getPingTime();
            if (pingTime > 0) {
                this.pingTimeList.add(new Integer(sources[i].getPingTime()));
                ++this.intervalCount;
            }
            ++i;
        }
        if (this.limitMonitor.isConfTestingLimits()) {
            if (this.limitMonitor.isConfLimitTestFinished()) {
                this.endLimitTesting();
                return;
            }
            SMUpdate ramp = this.limitMonitor.rampTestingLimit(this.adapter.getCurrentUploadLimit(), this.adapter.getCurrentDownloadLimit());
            this.logNewLimits(ramp);
            this.setNewLimits(ramp);
        }
        long currTime = SystemTime.getCurrentTime();
        if (this.timeSinceLastUpdate == 0L) {
            this.timeSinceLastUpdate = currTime;
        }
        if (this.calculateMediaDHTPingTime()) {
            return;
        }
        this.log("metric:" + this.lastMetricValue);
        this.logLimitStatus();
        this.limitMonitor.addToPingMapData(this.lastMetricValue);
        float signalStrength = this.determineSignalStrength(this.lastMetricValue);
        if (signalStrength != 0.0f && !this.limitMonitor.isConfTestingLimits()) {
            this.hadAdjustmentLastInterval = true;
            float multiple = this.consectiveMultiplier();
            int currUpLimit = this.adapter.getCurrentUploadLimit();
            int currDownLimit = this.adapter.getCurrentDownloadLimit();
            this.limitMonitor.checkForUnpinningCondition();
            SMUpdate update = this.limitMonitor.modifyLimits(signalStrength, multiple, currUpLimit, currDownLimit);
            this.logNewLimits(update);
            this.setNewLimits(update);
        } else {
            int currDownloadLimit;
            this.hadAdjustmentLastInterval = false;
            int currUploadLimit = this.adapter.getCurrentUploadLimit();
            if (!this.limitMonitor.areSettingsInSpec(currUploadLimit, currDownloadLimit = this.adapter.getCurrentDownloadLimit())) {
                SMUpdate update = this.limitMonitor.adjustLimitsToSpec(currUploadLimit, currDownloadLimit);
                this.logNewLimits(update);
                this.setNewLimits(update);
            }
        }
        this.pingSourceManager.checkPingSources(sources);
    }

    private void endLimitTesting() {
        int downLimitGuess = this.limitMonitor.guessDownloadLimit();
        int upLimitGuess = this.limitMonitor.guessUploadLimit();
        SMUpdate update = this.limitMonitor.endLimitTesting(downLimitGuess, upLimitGuess);
        this.limitMonitor.logPingMapData();
        this.limitMonitor.resetPingSpace();
        this.logNewLimits(update);
        this.setNewLimits(update);
    }

    private void logLimitStatus() {
        StringBuilder msg = new StringBuilder();
        msg.append("limits:");
        msg.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        msg.append(this.limitMonitor.getUploadMinLimit()).append(":");
        msg.append(this.limitMonitor.getUploadConfidence()).append(":");
        msg.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        msg.append(this.limitMonitor.getDownloadMinLimit()).append(":");
        msg.append(this.limitMonitor.getDownloadConfidence());
        SpeedManagerLogger.log(msg.toString());
    }

    private boolean calculateMediaDHTPingTime() {
        if (skipIntervalAfterAdjustment && this.hadAdjustmentLastInterval) {
            this.hadAdjustmentLastInterval = false;
            this.pingTimeList = new ArrayList();
            this.intervalCount = 0;
            return true;
        }
        if (this.intervalCount < numIntervalsBetweenCal) {
            return true;
        }
        Collections.sort(this.pingTimeList);
        if (this.pingTimeList.size() == 0) {
            this.lastMetricValue = 10000;
        } else {
            int medianIndex = this.pingTimeList.size() / 2;
            Integer medianPingTime = (Integer)this.pingTimeList.get(medianIndex);
            this.lastMetricValue = medianPingTime;
        }
        this.intervalCount = 0;
        this.pingTimeList = new ArrayList();
        return false;
    }

    private void logNewLimits(SMUpdate update) {
        if (update.hasNewUploadLimit) {
            int kbpsUpoadLimit = update.newUploadLimit / 1024;
            this.log(" new up limit  : " + kbpsUpoadLimit + " kb/s");
        }
        if (update.hasNewDownloadLimit) {
            int kpbsDownloadLimit = update.newDownloadLimit / 1024;
            this.log(" new down limit: " + kpbsDownloadLimit + " kb/s");
        }
    }

    private void setNewLimits(SMUpdate update) {
        this.adapter.setCurrentUploadLimit(update.newUploadLimit);
        this.adapter.setCurrentDownloadLimit(update.newDownloadLimit);
    }

    private float determineSignalStrength(int currMetricValue) {
        float signal = 0.0f;
        if (currMetricValue < metricGoodResult) {
            signal = 1.0f;
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (currMetricValue < metricGoodResult + metricGoodTolerance) {
            signal = (float)(currMetricValue - metricGoodResult) / (float)metricGoodTolerance;
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (currMetricValue > metricBadResult) {
            signal = -1.0f;
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
        } else if (currMetricValue > metricBadResult - metricBadTolerance) {
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
            int lowerBound = metricBadResult - metricBadTolerance;
            signal = (float)(currMetricValue - lowerBound) / (float)metricBadTolerance;
            signal -= 1.0f;
        }
        this.log("consecutive:" + this.consecutiveUpticks + ":" + this.consecutiveDownticks);
        return signal;
    }

    private float consectiveMultiplier() {
        float multiple;
        if (this.consecutiveUpticks > this.consecutiveDownticks) {
            if (this.limitMonitor.bandwidthUsageLow()) {
                this.consecutiveUpticks = 0;
            }
            multiple = this.calculateUpTickMultiple(this.consecutiveUpticks);
        } else {
            multiple = this.calculateDownTickMultiple(this.consecutiveDownticks);
            this.limitMonitor.notifyOfDownSignal();
        }
        return multiple;
    }

    private float calculateUpTickMultiple(int c) {
        float multiple = 0.0f;
        if (c < 0) {
            return multiple;
        }
        switch (c) {
            case 0: 
            case 1: {
                multiple = 0.25f;
                break;
            }
            case 2: {
                multiple = 0.5f;
                break;
            }
            case 3: {
                multiple = 1.0f;
                break;
            }
            case 4: {
                multiple = 1.25f;
                break;
            }
            case 5: {
                multiple = 1.5f;
                break;
            }
            case 6: {
                multiple = 1.75f;
                break;
            }
            case 7: {
                multiple = 2.0f;
                break;
            }
            case 8: {
                multiple = 2.25f;
                break;
            }
            case 9: {
                multiple = 2.5f;
                break;
            }
            default: {
                multiple = 3.0f;
            }
        }
        if (this.limitMonitor.bandwidthUsageMedium()) {
            multiple /= 2.0f;
        }
        return multiple;
    }

    private float calculateDownTickMultiple(int c) {
        float multiple = 0.0f;
        if (c < 0) {
            return multiple;
        }
        switch (c) {
            case 0: 
            case 1: {
                multiple = 0.25f;
                break;
            }
            case 2: {
                multiple = 0.5f;
                break;
            }
            case 3: {
                multiple = 1.0f;
                break;
            }
            case 4: {
                multiple = 2.0f;
                break;
            }
            case 5: {
                multiple = 3.0f;
                break;
            }
            case 6: {
                multiple = 4.0f;
                break;
            }
            case 7: {
                multiple = 6.0f;
                break;
            }
            case 8: {
                multiple = 9.0f;
                break;
            }
            case 9: {
                multiple = 15.0f;
                break;
            }
            default: {
                multiple = 20.0f;
            }
        }
        return multiple;
    }

    @Override
    public int getIdlePingMillis() {
        return this.lastMetricValue;
    }

    @Override
    public int getCurrentPingMillis() {
        return 0;
    }

    @Override
    public int getMaxPingMillis() {
        return 912;
    }

    @Override
    public int getCurrentChokeSpeed() {
        return 0;
    }

    @Override
    public int getMaxUploadSpeed() {
        return this.sessionMaxUploadRate;
    }

    @Override
    public boolean getAdjustsDownloadLimits() {
        return true;
    }

    protected void log(String str) {
        SpeedManagerLogger.log(str);
    }
}

