/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.SearchLoginException;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.impl.SubscriptionHistoryImpl;
import com.biglybt.core.subs.impl.SubscriptionImpl;
import com.biglybt.core.subs.impl.SubscriptionManagerImpl;
import com.biglybt.core.subs.impl.SubscriptionResultFilterImpl;
import com.biglybt.core.subs.impl.SubscriptionResultImpl;
import com.biglybt.core.subs.util.SubscriptionResultFilterable;
import com.biglybt.core.util.Debug;
import com.biglybt.util.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionDownloader {
    private SubscriptionManagerImpl manager;
    private SubscriptionImpl subs;

    protected SubscriptionDownloader(SubscriptionManagerImpl _manager, SubscriptionImpl _subs) throws SubscriptionException {
        this.manager = _manager;
        this.subs = _subs;
    }

    protected void download() throws SubscriptionException {
        SubscriptionHistoryImpl history;
        long max_age_secs;
        this.log("Downloading '" + this.subs.getName() + "'");
        Map map = JSONUtils.decodeJSON(this.subs.getJSON());
        Long engine_id = (Long)map.get("engine_id");
        String search_term = (String)map.get("search_term");
        String networks = (String)map.get("networks");
        Map filters = (Map)map.get("filters");
        Engine engine = this.manager.getEngine(this.subs, map, false);
        if (engine == null) {
            throw new SubscriptionException("Download failed, search engine " + engine_id + " not found");
        }
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        if (search_term != null) {
            sps.add(new SearchParameter("s", search_term));
            this.log("    Using search term '" + search_term + "' for engine " + engine.getString());
        }
        if (networks != null && networks.length() > 0) {
            sps.add(new SearchParameter("n", networks));
        }
        if ((max_age_secs = (history = this.subs.getHistory()).getMaxAgeSecs()) > 0L) {
            sps.add(new SearchParameter("a", String.valueOf(max_age_secs)));
        }
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        try {
            HashMap<String, String> context2 = new HashMap<String, String>();
            context2.put("azsrc", "subscription");
            Result[] results = engine.search(parameters, context2, -1, -1, null, null);
            this.log("    Got " + results.length + " results");
            SubscriptionResultFilterImpl result_filter = new SubscriptionResultFilterImpl(this.subs, filters);
            results = result_filter.filter(results);
            this.log("    Post-filter: " + results.length + " results");
            SubscriptionResultImpl[] s_results = new SubscriptionResultImpl[results.length];
            int i = 0;
            while (i < results.length) {
                SubscriptionResultImpl s_result;
                s_results[i] = s_result = new SubscriptionResultImpl(history, results[i]);
                ++i;
            }
            SubscriptionResultImpl[] all_results = history.reconcileResults(engine, s_results, false);
            this.checkAutoDownload(all_results);
            history.setLastError(null, false);
        }
        catch (Throwable e) {
            this.log("    Download failed", e);
            history.setLastError(Debug.getNestedExceptionMessage(e), e instanceof SearchLoginException);
            throw new SubscriptionException("Search failed", e);
        }
    }

    protected void checkAutoDownload(SubscriptionResultImpl[] results) {
        SubscriptionResultFilterImpl filter2;
        SubscriptionHistoryImpl history = this.subs.getHistory();
        if (!history.isEnabled()) {
            return;
        }
        if (!history.isAutoDownload()) {
            return;
        }
        try {
            filter2 = this.subs.getFilters();
            if (!filter2.isActive()) {
                filter2 = null;
            }
        }
        catch (Throwable e) {
            filter2 = null;
        }
        int i = 0;
        while (i < results.length) {
            SubscriptionResultImpl result = results[i];
            if (!(result.isDeleted() || result.getRead() || filter2 != null && filter2.isFiltered(new SubscriptionResultFilterable(this.subs, result)))) {
                this.manager.getScheduler().download((Subscription)this.subs, result);
            }
            ++i;
        }
    }

    protected void log(String str) {
        this.manager.log(str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log(str, e);
    }
}

