/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.impl;

import com.biglybt.activities.LocalActivityManager;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionHistory;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.impl.SubscriptionImpl;
import com.biglybt.core.subs.impl.SubscriptionManagerImpl;
import com.biglybt.core.subs.impl.SubscriptionResultImpl;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SystemTime;
import com.biglybt.util.MapUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubscriptionHistoryImpl
implements SubscriptionHistory {
    private static AsyncDispatcher dispatcher = new AsyncDispatcher("subspost");
    private final SubscriptionManagerImpl manager;
    private final SubscriptionImpl subs;
    private boolean enabled;
    private boolean auto_dl;
    private boolean post_notifications;
    private long last_scan;
    private long last_new_result;
    private int num_unread;
    private int num_read;
    private long max_results = -1L;
    private String[] networks = null;
    private long max_age_secs = -1L;
    private long next_scheduled;
    private String last_error;
    private long last_error_time;
    private boolean auth_failed;
    private int consec_fails;
    private boolean auto_dl_supported;
    private boolean dl_with_ref = true;
    private int interval_override;

    protected SubscriptionHistoryImpl(SubscriptionManagerImpl _manager, SubscriptionImpl _subs) {
        this.manager = _manager;
        this.subs = _subs;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionResultImpl[] reconcileResults(Engine engine_maybe_null, SubscriptionResultImpl[] latest_results, boolean allow_reincarnation) {
        SubscriptionResultImpl[] result;
        this.auto_dl_supported = engine_maybe_null == null ? false : engine_maybe_null.getAutoDownloadSupported() == 1;
        int new_unread = 0;
        int new_read = 0;
        if (this.last_scan == 0L) {
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            int i = 0;
            while (i < latest_results.length) {
                result = latest_results[i];
                result.setReadInternal(true);
                try {
                    byte[] hash;
                    DownloadManager dm;
                    String hash_str = result.getAssetHash();
                    if (hash_str != null && (dm = gm.getDownloadManager(new HashWrapper(hash = Base32.decode(hash_str)))) != null) {
                        this.log("Adding existing association on first read for '" + dm.getDisplayName());
                        this.subs.addAssociation(hash);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        long now = SystemTime.getCurrentTime();
        int max_results = this.getMaxNonDeletedResults();
        if (max_results < 0) {
            max_results = this.manager.getMaxNonDeletedResults();
        }
        SubscriptionResultImpl first_new_result = null;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl r;
            boolean got_changed = false;
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] existing_results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            ByteArrayHashMap<SubscriptionResultImpl> result_key_map = new ByteArrayHashMap<SubscriptionResultImpl>();
            ByteArrayHashMap<SubscriptionResultImpl> result_key2_map = new ByteArrayHashMap<SubscriptionResultImpl>();
            ArrayList<SubscriptionResultImpl> updated_results = new ArrayList<SubscriptionResultImpl>(existing_results.length + latest_results.length);
            ArrayList<SubscriptionResultImpl> new_results = new ArrayList<SubscriptionResultImpl>(latest_results.length);
            int i = 0;
            while (i < existing_results.length) {
                r = existing_results[i];
                result_key_map.put(r.getKey1(), r);
                byte[] key2 = r.getKey2();
                if (key2 != null) {
                    result_key2_map.put(key2, r);
                }
                updated_results.add(r);
                if (!r.isDeleted()) {
                    if (r.getRead()) {
                        ++new_read;
                    } else {
                        ++new_unread;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < latest_results.length) {
                byte[] key2;
                r = latest_results[i];
                SubscriptionResultImpl existing = (SubscriptionResultImpl)result_key_map.get(r.getKey1());
                if (existing == null && (key2 = r.getKey2()) != null) {
                    existing = (SubscriptionResultImpl)result_key2_map.get(key2);
                }
                if (existing == null) {
                    this.last_new_result = now;
                    updated_results.add(r);
                    result_key_map.put(r.getKey1(), r);
                    key2 = r.getKey2();
                    if (key2 != null) {
                        result_key2_map.put(key2, r);
                    }
                    new_results.add(r);
                    if (r.getRead()) {
                        ++new_read;
                    } else {
                        ++new_unread;
                        if (first_new_result == null) {
                            first_new_result = r;
                        }
                    }
                } else if (existing.updateFrom(r, allow_reincarnation)) {
                    got_changed = true;
                }
                ++i;
            }
            if (max_results > 0 && new_unread + new_read > max_results) {
                i = 0;
                while (i < updated_results.size()) {
                    r = (SubscriptionResultImpl)updated_results.get(i);
                    if (!r.isDeleted()) {
                        if (r.getRead()) {
                            --new_read;
                        } else {
                            --new_unread;
                        }
                        r.deleteInternal();
                        got_changed = true;
                        if (new_unread + new_read <= max_results) break;
                    }
                    ++i;
                }
            }
            if (got_changed || !new_results.isEmpty()) {
                result = updated_results.toArray(new SubscriptionResultImpl[updated_results.size()]);
                this.manager.saveResults(this.subs, result, new_results);
            } else {
                result = existing_results;
            }
            this.last_scan = now;
            this.num_unread = new_unread;
            this.num_read = new_read;
        }
        this.saveConfig(2);
        if (this.post_notifications && first_new_result != null) {
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    HashMap<String, String> cb_data = new HashMap<String, String>();
                    cb_data.put("subname", SubscriptionHistoryImpl.this.subs.getName());
                    cb_data.put("subid", SubscriptionHistoryImpl.this.subs.getID());
                    cb_data.put("allowReAdd", "true");
                    String date_str = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(SystemTime.getCurrentTime()));
                    LocalActivityManager.addLocalActivity("NewResults:" + SubscriptionHistoryImpl.this.subs.getID(), "rss", String.valueOf(MessageText.getString("subs.activity.new.results", new String[]{SubscriptionHistoryImpl.this.subs.getName(), String.valueOf(SubscriptionHistoryImpl.this.num_unread)})) + ": " + date_str, new String[]{MessageText.getString("label.view")}, ActivityCallback.class, cb_data);
                }
            });
        }
        return result;
    }

    public Subscription getSubscription() {
        return this.subs;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean _enabled) {
        if (_enabled != this.enabled) {
            this.enabled = _enabled;
            this.saveConfig(1);
            if (_enabled && this.isAutoDownload()) {
                ArrayList<SubscriptionResult> unread_results = new ArrayList<SubscriptionResult>();
                SubscriptionHistoryImpl subscriptionHistoryImpl = this;
                synchronized (subscriptionHistoryImpl) {
                    LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
                    for (SubscriptionResult subscriptionResult : results_map.values()) {
                        if (subscriptionResult.isDeleted() || subscriptionResult.getRead()) continue;
                        unread_results.add(subscriptionResult);
                    }
                }
                for (SubscriptionResult result : unread_results) {
                    this.manager.getScheduler().download((Subscription)this.subs, result);
                }
            }
        }
    }

    @Override
    public boolean isAutoDownload() {
        return this.auto_dl;
    }

    @Override
    public void setAutoDownload(boolean _auto_dl) {
        if (_auto_dl != this.auto_dl) {
            this.auto_dl = _auto_dl;
            this.saveConfig(1);
            if (this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    @Override
    public int getMaxNonDeletedResults() {
        return this.max_results < 0L ? -1 : (int)this.max_results;
    }

    @Override
    public void setMaxNonDeletedResults(int _max_results) {
        if ((long)_max_results != this.max_results) {
            this.max_results = _max_results;
            this.saveConfig(1);
        }
    }

    @Override
    public String[] getDownloadNetworks() {
        return this.networks;
    }

    @Override
    public void setDownloadNetworks(String[] nets) {
        this.networks = nets;
        this.saveConfig(1);
    }

    @Override
    public long getMaxAgeSecs() {
        return this.max_age_secs;
    }

    @Override
    public void setMaxAgeSecs(long max) {
        this.max_age_secs = max;
        this.saveConfig(1);
    }

    @Override
    public boolean getNotificationPostEnabled() {
        return this.post_notifications;
    }

    @Override
    public void setNotificationPostEnabled(boolean enabled) {
        if (enabled != this.post_notifications) {
            this.post_notifications = enabled;
            this.saveConfig(1);
        }
    }

    @Override
    public void setDetails(boolean _enabled, boolean _auto_dl) {
        if (this.enabled != _enabled || this.auto_dl != _auto_dl) {
            this.enabled = _enabled;
            this.auto_dl = _auto_dl;
            this.saveConfig(1);
            if (this.enabled && this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    protected void downloadNow() {
        try {
            this.subs.getManager().getScheduler().downloadAsync(this.subs, false);
        }
        catch (Throwable e) {
            this.log("Failed to initiate download", e);
        }
    }

    @Override
    public long getLastScanTime() {
        return this.last_scan;
    }

    @Override
    public long getLastNewResultTime() {
        return this.last_new_result;
    }

    @Override
    public void setNextScheduledUpdate(long when) {
        if (this.next_scheduled != when) {
            this.next_scheduled = when;
            this.subs.fireChanged(1, false);
        }
    }

    @Override
    public long getNextScheduledUpdate() {
        return this.next_scheduled;
    }

    @Override
    public long getNextScanTime() {
        long interval_min;
        block8: {
            if (this.interval_override > 0) {
                if (this.last_scan == 0L) {
                    return SystemTime.getCurrentTime();
                }
                return this.last_scan + (long)(this.interval_override * 60 * 1000);
            }
            Map schedule = this.subs.getScheduleConfig();
            if (schedule.size() == 0) {
                this.log("Schedule is empty!");
                return Long.MAX_VALUE;
            }
            try {
                interval_min = (Long)schedule.get("interval");
                if (interval_min <= 0L) {
                    interval_min = this.manager.getDefaultCheckFrequencyMins();
                }
                if (interval_min != Integer.MAX_VALUE && interval_min != Long.MAX_VALUE) break block8;
                return Long.MAX_VALUE;
            }
            catch (Throwable e) {
                this.log("Failed to decode schedule " + schedule, e);
                return Long.MAX_VALUE;
            }
        }
        if (this.last_scan == 0L) {
            return SystemTime.getCurrentTime();
        }
        return this.last_scan + interval_min * 60L * 1000L;
    }

    @Override
    public int getCheckFrequencyMins() {
        if (this.interval_override > 0) {
            return this.interval_override;
        }
        Map schedule = this.subs.getScheduleConfig();
        if (schedule.size() == 0) {
            return this.manager.getDefaultCheckFrequencyMins();
        }
        try {
            int interval_min = ((Long)schedule.get("interval")).intValue();
            if (interval_min <= 0) {
                interval_min = this.manager.getDefaultCheckFrequencyMins();
            }
            return interval_min;
        }
        catch (Throwable e) {
            return this.manager.getDefaultCheckFrequencyMins();
        }
    }

    @Override
    public void setCheckFrequencyMins(int mins) {
        this.interval_override = mins;
        this.saveConfig(1);
        this.subs.fireChanged(1);
    }

    @Override
    public int getNumUnread() {
        return this.num_unread;
    }

    @Override
    public int getNumRead() {
        return this.num_read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionResult[] getResults(boolean include_deleted) {
        SubscriptionResult[] results;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
        }
        if (include_deleted) {
            return results;
        }
        ArrayList<SubscriptionResult> l = new ArrayList<SubscriptionResult>(results.length);
        int i = 0;
        while (i < results.length) {
            if (!results[i].isDeleted()) {
                l.add(results[i]);
            }
            ++i;
        }
        return l.toArray(new SubscriptionResult[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionResult getResult(String result_id) {
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results = this.manager.loadResults(this.subs);
            return results.get(result_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResult(SubscriptionResultImpl result) {
        byte[] key = result.getKey1();
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i = 0;
            while (i < results.length) {
                if (Arrays.equals(results[i].getKey1(), key)) {
                    results[i] = result;
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                this.updateReadUnread(results);
                ArrayList<SubscriptionResultImpl> new_unread_results = null;
                if (!result.getRead()) {
                    new_unread_results = new ArrayList<SubscriptionResultImpl>(1);
                    new_unread_results.add(result);
                }
                this.manager.saveResults(this.subs, results, new_unread_results);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
        if (this.isEnabled() && this.isAutoDownload() && !result.getRead() && !result.isDeleted()) {
            this.manager.getScheduler().download((Subscription)this.subs, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResults(String[] result_ids) {
        ByteArrayHashMap<String> rids = new ByteArrayHashMap<String>();
        int i = 0;
        while (i < result_ids.length) {
            rids.put(Base32.decode(result_ids[i]), "");
            ++i;
        }
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i2 = 0;
            while (i2 < results.length) {
                SubscriptionResultImpl result = results[i2];
                if (!result.isDeleted() && rids.containsKey(result.getKey1())) {
                    changed = true;
                    result.deleteInternal();
                }
                ++i2;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, null);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllResults() {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i = 0;
            while (i < results.length) {
                SubscriptionResultImpl result = results[i];
                if (!result.isDeleted()) {
                    changed = true;
                    result.deleteInternal();
                }
                ++i;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, null);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResults(String[] result_ids) {
        ByteArrayHashMap<String> rids = new ByteArrayHashMap<String>();
        int i = 0;
        while (i < result_ids.length) {
            rids.put(Base32.decode(result_ids[i]), "");
            ++i;
        }
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            ArrayList<SubscriptionResultImpl> new_results = new ArrayList<SubscriptionResultImpl>(results_map.size());
            for (SubscriptionResultImpl result : results_map.values()) {
                if (!result.isDeleted() && rids.containsKey(result.getKey1())) {
                    changed = true;
                    result.deleteInternal();
                    continue;
                }
                new_results.add(result);
            }
            if (changed) {
                SubscriptionResultImpl[] results = new_results.toArray(new SubscriptionResultImpl[new_results.size()]);
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, null);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllResultsRead() {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i = 0;
            while (i < results.length) {
                SubscriptionResultImpl result = results[i];
                if (!result.getRead()) {
                    changed = true;
                    result.setReadInternal(true);
                }
                ++i;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, null);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllResultsUnread() {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i = 0;
            while (i < results.length) {
                SubscriptionResultImpl result = results[i];
                if (result.getRead()) {
                    changed = true;
                    result.setReadInternal(false);
                }
                ++i;
            }
            if (changed) {
                this.updateReadUnread(results);
                List<SubscriptionResultImpl> new_unread_results = Arrays.asList(results);
                this.manager.saveResults(this.subs, results, new_unread_results);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markResults(String[] result_ids, boolean[] reads) {
        ByteArrayHashMap<Boolean> rid_map = new ByteArrayHashMap<Boolean>();
        int i = 0;
        while (i < result_ids.length) {
            rid_map.put(Base32.decode(result_ids[i]), reads[i]);
            ++i;
        }
        boolean changed = false;
        ArrayList<SubscriptionResultImpl> new_unread_results = new ArrayList<SubscriptionResultImpl>(result_ids.length);
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i2 = 0;
            while (i2 < results.length) {
                Boolean b_read;
                SubscriptionResultImpl result = results[i2];
                if (!result.isDeleted() && (b_read = (Boolean)rid_map.get(result.getKey1())) != null) {
                    boolean read = b_read;
                    if (result.getRead() != read) {
                        changed = true;
                        result.setReadInternal(read);
                        if (!read) {
                            new_unread_results.add(result);
                        }
                    }
                }
                ++i2;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, new_unread_results);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
        if (this.isEnabled() && this.isAutoDownload()) {
            int i3 = 0;
            while (i3 < new_unread_results.size()) {
                this.manager.getScheduler().download((Subscription)this.subs, (SubscriptionResult)new_unread_results.get(i3));
                ++i3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markResults(Set<String> hashes, Set<String> name_sizes) {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            int i = 0;
            while (i < results.length) {
                SubscriptionResultImpl result = results[i];
                if (!result.isDeleted() && !result.getRead()) {
                    String hash = result.getAssetHash();
                    if (hash != null && hashes.contains(hash)) {
                        changed = true;
                        result.setReadInternal(true);
                    } else {
                        String ns;
                        Map<Integer, Object> properties = result.toPropertyMap();
                        String name = (String)properties.get(1);
                        Long size = (Long)properties.get(3);
                        if (name != null && size != null && name_sizes.contains(ns = String.valueOf(name) + ":" + size)) {
                            changed = true;
                            result.setReadInternal(true);
                        }
                    }
                }
                ++i;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results, null);
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
            SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
            if (results.length > 0) {
                results = new SubscriptionResultImpl[]{};
                this.manager.saveResults(this.subs, results, null);
            }
            this.updateReadUnread(results);
        }
        this.last_error = null;
        this.last_new_result = 0L;
        this.last_scan = 0L;
        this.saveConfig(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMaxResults(int max_results) {
        if (max_results <= 0) {
            return;
        }
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            if (this.num_unread + this.num_read > max_results) {
                LinkedHashMap<String, SubscriptionResultImpl> results_map = this.manager.loadResults(this.subs);
                SubscriptionResultImpl[] results = results_map.values().toArray(new SubscriptionResultImpl[results_map.size()]);
                int i = 0;
                while (i < results.length) {
                    SubscriptionResultImpl r = results[i];
                    if (!r.isDeleted()) {
                        if (r.getRead()) {
                            --this.num_read;
                        } else {
                            --this.num_unread;
                        }
                        r.deleteInternal();
                        changed = true;
                        if (this.num_unread + this.num_read <= max_results) break;
                    }
                    ++i;
                }
                if (changed) {
                    this.manager.saveResults(this.subs, results, null);
                }
            }
        }
        if (changed) {
            this.saveConfig(2);
        }
    }

    protected void updateReadUnread(SubscriptionResultImpl[] results) {
        int new_unread = 0;
        int new_read = 0;
        int i = 0;
        while (i < results.length) {
            SubscriptionResultImpl result = results[i];
            if (!result.isDeleted()) {
                if (result.getRead()) {
                    ++new_read;
                } else {
                    ++new_unread;
                }
            }
            ++i;
        }
        this.num_read = new_read;
        this.num_unread = new_unread;
    }

    protected boolean isAutoDownloadSupported() {
        return this.auto_dl_supported;
    }

    protected void setFatalError(String _error) {
        this.last_error = _error;
        this.last_error_time = SystemTime.getCurrentTime();
        this.consec_fails = 1024;
        this.subs.fireChanged(1);
    }

    protected void setLastError(String _last_error, boolean _auth_failed) {
        this.last_error = _last_error;
        this.auth_failed = _auth_failed;
        if (this.last_error == null) {
            this.consec_fails = 0;
        } else {
            ++this.consec_fails;
            this.last_error_time = SystemTime.getCurrentTime();
        }
        this.subs.fireChanged(1);
    }

    @Override
    public String getLastError() {
        return this.last_error;
    }

    @Override
    public long getLastErrorTime() {
        return this.last_error_time;
    }

    @Override
    public boolean isAuthFail() {
        return this.auth_failed;
    }

    @Override
    public int getConsecFails() {
        return this.consec_fails;
    }

    @Override
    public boolean getDownloadWithReferer() {
        return this.dl_with_ref;
    }

    @Override
    public void setDownloadWithReferer(boolean b) {
        if (b != this.dl_with_ref) {
            this.dl_with_ref = b;
            this.saveConfig(1);
        }
    }

    protected void loadConfig() {
        Long l_post_noto;
        Map map = this.subs.getHistoryConfig();
        Long l_enabled = (Long)map.get("enabled");
        this.enabled = l_enabled == null ? true : l_enabled == 1L;
        Long l_auto_dl = (Long)map.get("auto_dl");
        this.auto_dl = l_auto_dl == null ? false : l_auto_dl == 1L;
        Long l_last_scan = (Long)map.get("last_scan");
        this.last_scan = l_last_scan == null ? 0L : l_last_scan;
        Long l_last_new = (Long)map.get("last_new");
        this.last_new_result = l_last_new == null ? 0L : l_last_new;
        Long l_num_unread = (Long)map.get("num_unread");
        this.num_unread = l_num_unread == null ? 0 : l_num_unread.intValue();
        Long l_num_read = (Long)map.get("num_read");
        this.num_read = l_num_read == null ? 0 : l_num_read.intValue();
        Long l_auto_dl_s = (Long)map.get("auto_dl_supported");
        this.auto_dl_supported = l_auto_dl_s == null ? this.last_scan > 0L : l_auto_dl_s == 1L;
        Long l_dl_with_ref = (Long)map.get("dl_with_ref");
        this.dl_with_ref = l_dl_with_ref == null ? true : l_dl_with_ref == 1L;
        Long l_interval_override = (Long)map.get("interval_override");
        this.interval_override = l_interval_override == null ? 0 : l_interval_override.intValue();
        Long l_max_results = (Long)map.get("max_results");
        this.max_results = l_max_results == null ? -1L : l_max_results;
        String s_networks = MapUtils.getMapString(map, "nets", null);
        if (s_networks != null) {
            this.networks = s_networks.split(",");
            int i = 0;
            while (i < this.networks.length) {
                this.networks[i] = AENetworkClassifier.internalise(this.networks[i]);
                ++i;
            }
        }
        this.post_notifications = (l_post_noto = (Long)map.get("post_noti")) == null ? false : l_post_noto == 1L;
        Long l_max_age_secs = (Long)map.get("max_age_secs");
        this.max_age_secs = l_max_age_secs == null ? -1L : l_max_age_secs;
    }

    protected void saveConfig(int reason) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", new Long(this.enabled ? 1 : 0));
        map.put("auto_dl", new Long(this.auto_dl ? 1 : 0));
        map.put("auto_dl_supported", new Long(this.auto_dl_supported ? 1 : 0));
        map.put("last_scan", new Long(this.last_scan));
        map.put("last_new", new Long(this.last_new_result));
        map.put("num_unread", new Long(this.num_unread));
        map.put("num_read", new Long(this.num_read));
        map.put("dl_with_ref", new Long(this.dl_with_ref ? 1 : 0));
        map.put("max_results", new Long(this.max_results));
        if (this.interval_override > 0) {
            map.put("interval_override", new Long(this.interval_override));
        }
        if (this.networks != null) {
            String str = "";
            String[] stringArray = this.networks;
            int n = this.networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + net;
                ++n2;
            }
            map.put("nets", str);
        }
        if (this.post_notifications) {
            map.put("post_noti", 1);
        }
        if (this.max_age_secs > 0L) {
            map.put("max_age_secs", this.max_age_secs);
        }
        this.subs.updateHistoryConfig(map, reason);
    }

    protected void log(String str) {
        this.subs.log("History: " + str);
    }

    protected void log(String str, Throwable e) {
        this.subs.log("History: " + str, e);
    }

    protected String getString() {
        return "unread=" + this.num_unread + ",read=" + this.num_read + ",last_err=" + this.last_error;
    }

    public static class ActivityCallback
    implements LocalActivityManager.LocalActivityCallback {
        @Override
        public void actionSelected(String action, Map<String, String> data) {
            String sub_id;
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            Subscription sub = subs_man.getSubscriptionByID(sub_id = data.get("subid"));
            if (sub != null) {
                sub.requestAttention();
            }
        }
    }
}

