/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs.util;

import com.biglybt.core.metasearch.FilterableResult;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.LightHashMap;
import java.util.Date;
import java.util.Map;

public class SubscriptionResultFilterable
implements SearchSubsResultBase,
FilterableResult {
    private final Subscription subs;
    private final String result_id;
    private final String name;
    private final byte[] hash;
    private final int content_type;
    private final long size;
    private final String torrent_link;
    private final String details_link;
    private final String category;
    private final String desc;
    private long time;
    private boolean read;
    private long seeds_peers_sort;
    private String seeds_peers;
    private int seed_count;
    private int peer_count;
    private int completed_count;
    private long votes_comments_sort;
    private String votes_comments;
    private int rank;
    private long asset_date;
    private String[] tags;
    private LightHashMap<Object, Object> user_data;

    public SubscriptionResultFilterable(Subscription _subs, SubscriptionResult _result) {
        char c;
        this.subs = _subs;
        this.result_id = _result.getID();
        Map<Integer, Object> properties = _result.toPropertyMap();
        this.name = (String)properties.get(1);
        this.hash = (byte[])properties.get(21);
        String type = (String)properties.get(10);
        this.content_type = type == null || type.length() == 0 ? 0 : ((c = type.charAt(0)) == 'v' ? 1 : (c == 'a' ? 2 : (c == 'g' ? 3 : 0)));
        Long l_size = (Long)properties.get(3);
        this.size = l_size == null ? 0L : l_size;
        String tl = (String)properties.get(23);
        if (tl == null) {
            tl = (String)properties.get(12);
        }
        this.torrent_link = tl;
        this.details_link = (String)properties.get(11);
        this.category = (String)properties.get(7);
        Date ad = (Date)properties.get(24);
        if (ad != null) {
            this.asset_date = ad.getTime();
        }
        this.desc = (String)properties.get(27);
        this.updateMutables(_result, properties);
    }

    private void updateMutables(SubscriptionResult _result, Map<Integer, Object> properties) {
        long pt;
        this.read = _result.getRead();
        Date pub_date = (Date)properties.get(2);
        this.time = pub_date == null ? _result.getTimeFound() : ((pt = pub_date.getTime()) <= 0L ? _result.getTimeFound() : pt);
        this.tags = (String[])properties.get(25);
        long seeds = (Long)properties.get(5);
        long leechers = (Long)properties.get(4);
        long cc = (Long)properties.get(26);
        this.completed_count = cc < 0L ? -1 : (int)cc;
        this.seed_count = (int)(seeds < 0L ? 0L : seeds);
        this.peer_count = (int)(leechers < 0L ? 0L : leechers);
        this.seeds_peers = String.valueOf(seeds < 0L ? "--" : String.valueOf(seeds)) + "/" + (leechers < 0L ? "--" : String.valueOf(leechers));
        seeds = seeds < 0L ? 0L : ++seeds;
        leechers = leechers < 0L ? 0L : ++leechers;
        this.seeds_peers_sort = (seeds & Integer.MAX_VALUE) << 32 | leechers & 0xFFFFFFFFFFFFFFFFL;
        long votes = (Long)properties.get(9);
        long comments = (Long)properties.get(8);
        if (votes < 0L && comments < 0L) {
            this.votes_comments_sort = 0L;
            this.votes_comments = null;
        } else {
            this.votes_comments = String.valueOf(votes < 0L ? "--" : String.valueOf(votes)) + "/" + (comments < 0L ? "--" : String.valueOf(comments));
            votes = votes < 0L ? 0L : ++votes;
            comments = comments < 0L ? 0L : ++comments;
            this.votes_comments_sort = (votes & Integer.MAX_VALUE) << 32 | comments & 0xFFFFFFFFFFFFFFFFL;
        }
        this.rank = ((Long)properties.get(17)).intValue();
    }

    public void updateFrom(SubscriptionResult other) {
        this.updateMutables(other, other.toPropertyMap());
    }

    public Subscription getSubscription() {
        return this.subs;
    }

    @Override
    public String getID() {
        return this.result_id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public int getContentType() {
        return this.content_type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getNbSeeds() {
        return this.seed_count;
    }

    @Override
    public int getNbPeers() {
        return this.peer_count;
    }

    @Override
    public String getSeedsPeers() {
        return this.seeds_peers;
    }

    @Override
    public long getSeedsPeersSortValue() {
        return this.seeds_peers_sort;
    }

    @Override
    public int getNbCompleted() {
        return this.completed_count;
    }

    @Override
    public String getVotesComments() {
        return this.votes_comments;
    }

    @Override
    public long getVotesCommentsSortValue() {
        return this.votes_comments_sort;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public String getTorrentLink() {
        return this.torrent_link;
    }

    @Override
    public String getDetailsLink() {
        return this.details_link;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getAssetDate() {
        return this.asset_date == 0L ? this.time : this.asset_date;
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public void setRead(boolean _read) {
        SubscriptionResult result = this.subs.getHistory().getResult(this.result_id);
        if (result != null) {
            result.setRead(_read);
        }
    }

    public void delete() {
        SubscriptionResult result = this.subs.getHistory().getResult(this.result_id);
        if (result != null) {
            result.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        SubscriptionResultFilterable subscriptionResultFilterable = this;
        synchronized (subscriptionResultFilterable) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap();
            }
            this.user_data.put(key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        SubscriptionResultFilterable subscriptionResultFilterable = this;
        synchronized (subscriptionResultFilterable) {
            block4: {
                if (this.user_data != null) break block4;
                return null;
            }
            return this.user_data.get(key);
        }
    }
}

