/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerOptionsHandler;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureExecOnAssign;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureLimits;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRSSFeed;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.impl.TagManagerImpl;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TagBase
implements Tag,
SimpleTimer.TimerTickReceiver,
DataSourceResolver.ExportableDataSource {
    protected static final String AT_RATELIMIT_UP = "rl.up";
    protected static final String AT_RATELIMIT_DOWN = "rl.down";
    protected static final String AT_VISIBLE = "vis";
    protected static final String AT_PUBLIC = "pub";
    protected static final String AT_FLAGS = "flag";
    protected static final String AT_GROUP = "gr";
    protected static final String AT_CAN_BE_PUBLIC = "canpub";
    protected static final String AT_ORIGINAL_NAME = "oname";
    protected static final String AT_IMAGE_ID = "img.id";
    protected static final String AT_IMAGE_FILE = "img.file";
    protected static final String AT_IMAGE_SORT_ORDER = "img.so";
    protected static final String AT_COLOR_ID = "col.rgb";
    protected static final String AT_COLORS_ID = "cols";
    protected static final String AT_RSS_ENABLE = "rss.enable";
    protected static final String AT_RATELIMIT_UP_PRI = "rl.uppri";
    protected static final String AT_XCODE_TARGET = "xcode.to";
    protected static final String AT_FL_PREVENT_DELETE = "fl.pd";
    protected static final String AT_FL_MOVE_COMP = "fl.comp";
    protected static final String AT_FL_MOVE_COMP_OPT = "fl.comp.o";
    protected static final String AT_FL_MOVE_REM = "fl.rem";
    protected static final String AT_FL_MOVE_REM_OPT = "fl.rem.o";
    protected static final String AT_FL_COPY_COMP = "fl.copy";
    protected static final String AT_FL_COPY_COMP_OPT = "fl.copy.o";
    protected static final String AT_FL_INIT_LOC = "fl.init";
    protected static final String AT_FL_INIT_LOC_OPT = "fl.init.o";
    protected static final String AT_FL_MOVE_ASSIGN = "fl.ass";
    protected static final String AT_FL_MOVE_ASSIGN_OPT = "fl.ass.o";
    protected static final String AT_RATELIMIT_MIN_SR = "rl.minsr";
    protected static final String AT_RATELIMIT_MAX_SR = "rl.maxsr";
    protected static final String AT_RATELIMIT_MAX_SR_ACTION = "rl.maxsr.a";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR = "rl.maxaggsr";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR_ACTION = "rl.maxaggsr.a";
    protected static final String AT_RATELIMIT_MAX_AGGREGATE_SR_PRIORITY = "rl.maxaggsr.p";
    protected static final String AT_RATELIMIT_FP_SEEDING = "rl.fps";
    protected static final String AT_RATELIMIT_NOT_FP_SEEDING = "rl.nfps";
    protected static final String AT_RATELIMIT_BOOST = "rl.bst";
    protected static final String AT_RATELIMIT_MAX_ACTIVE_DL = "rl.maxadl";
    protected static final String AT_RATELIMIT_MAX_ACTIVE_CD = "rl.maxacd";
    protected static final String AT_RATELIMIT_ACTIVE_LIMITS_STRICT = "rl.als";
    protected static final String AT_PROPERTY_PREFIX = "pp.";
    protected static final String AT_BYTES_UP = "b.up";
    protected static final String AT_BYTES_DOWN = "b.down";
    protected static final String AT_DESCRIPTION = "desc";
    protected static final String AT_MAX_TAGGABLES = "max.t";
    protected static final String AT_REMOVAL_STRATEGY = "max.t.r";
    protected static final String AT_EOS_SCRIPT = "eos.scr";
    protected static final String AT_EOS_OPTIONS_TEMPLATE = "eos.ot";
    protected static final String AT_EOS_PM = "eos.pm";
    protected static final String AT_NOTIFICATION_POST = "noti.post";
    protected static final String AT_NOTIFICATION_PUBLISH = "noti.pub";
    protected static final String AT_LIMIT_ORDERING = "max.t.o";
    protected static final String AT_EOS_ASSIGN_TAGS = "eos.at";
    protected static final String AT_EOS_REMOVE_TAGS = "eos.rt";
    protected static final String AT_AUTO_APPLY_SORT_INTERVAL = "dl.auto.sort";
    protected static final String AT_WEIGHT = "dl.weight";
    private static final String[] EMPTY_STRING_LIST = new String[0];
    final TagTypeBase tag_type;
    private final int tag_id;
    private String tag_name;
    private static final int TL_ADD = 1;
    private static final int TL_REMOVE = 2;
    private static final int TL_SYNC = 3;
    private final ListenerManager<TagListener> t_listeners = ListenerManager.createManager("TagListeners", new ListenerManagerDispatcher<TagListener>(){

        @Override
        public void dispatch(TagListener listener, int type, Object value) {
            if (type == 1) {
                listener.taggableAdded(TagBase.this, (Taggable)value);
            } else if (type == 2) {
                listener.taggableRemoved(TagBase.this, (Taggable)value);
            } else if (type == 3) {
                listener.taggableSync(TagBase.this);
            }
        }
    });
    private final Map<com.biglybt.pif.tag.TagListener, TagListener> listener_map = new HashMap<com.biglybt.pif.tag.TagListener, TagListener>();
    private Boolean is_visible;
    private Boolean is_public;
    private long flags;
    private String group;
    private int[] colour;
    private long[] colours;
    private String description;
    private String image_file;
    private int image_sort_order = Integer.MIN_VALUE;
    private TagFeatureRateLimit tag_rl;
    private TagFeatureRSSFeed tag_rss;
    private TagFeatureFileLocation tag_fl;
    private TagFeatureLimits tag_limits;
    private HashMap<String, Object> transient_properties;
    private boolean is_removed;
    private static final Map<Long, long[][]> session_cache = new HashMap<Long, long[][]>();
    private long[] total_up_at_start;
    private long[] total_down_at_start;
    private long[] session_up;
    private long[] session_down;
    private long[] session_up_reset;
    private long[] session_down_reset;
    private static final int HISTORY_MAX_SECS = 1800;
    private volatile boolean history_retention_required;
    private long[] history;
    private int history_pos;
    private boolean history_wrapped;
    private boolean timer_registered;

    protected TagBase(TagTypeBase _tag_type, int _tag_id, String _tag_name) {
        this.tag_type = _tag_type;
        this.tag_id = _tag_id;
        this.tag_name = _tag_name;
        if (this.getManager().isEnabled()) {
            this.is_visible = this.readBooleanAttribute(AT_VISIBLE, null);
            this.is_public = this.readBooleanAttribute(AT_PUBLIC, null);
            this.flags = this.readLongAttribute(AT_FLAGS, 0L);
            this.group = this.readStringAttribute(AT_GROUP, null);
            this.description = this.readStringAttribute(AT_DESCRIPTION, null);
            if (this instanceof TagFeatureRateLimit) {
                this.tag_rl = (TagFeatureRateLimit)((Object)this);
            }
            if (this instanceof TagFeatureRSSFeed) {
                this.tag_rss = (TagFeatureRSSFeed)((Object)this);
                if (this.tag_rss.isTagRSSFeedEnabled()) {
                    this.getManager().checkRSSFeeds(this, true);
                }
            }
            if (this instanceof TagFeatureFileLocation) {
                this.tag_fl = (TagFeatureFileLocation)((Object)this);
            }
            if (this instanceof TagFeatureLimits) {
                this.tag_limits = (TagFeatureLimits)((Object)this);
            }
        }
    }

    protected void initialized() {
        if (this.group != null) {
            this.tag_type.setTagGroup(this, null, this.group);
        }
        this.loadPersistentStuff();
        this.loadTransientStuff();
    }

    @Override
    public DataSourceResolver.ExportedDataSource exportDataSource() {
        return new DataSourceResolver.ExportedDataSource(){

            @Override
            public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                return TagManagerImpl.class;
            }

            @Override
            public Map<String, Object> getExport() {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("uid", TagBase.this.getTagUID());
                return m;
            }
        };
    }

    public Tag getTag() {
        return this;
    }

    protected void addTag() {
        if (this.getManager().isEnabled()) {
            this.tag_type.addTag(this);
        }
    }

    protected TagManagerImpl getManager() {
        return this.tag_type.getTagManager();
    }

    @Override
    public TagTypeBase getTagType() {
        return this.tag_type;
    }

    @Override
    public int getTagID() {
        return this.tag_id;
    }

    @Override
    public long getTagUID() {
        return (long)this.getTagType().getTagType() << 32 | (long)this.tag_id;
    }

    @Override
    public String getTagName() {
        return this.getTagName(true);
    }

    protected String getTagNameRaw() {
        return this.tag_name;
    }

    @Override
    public String getTagName(boolean localize) {
        if (localize) {
            if (this.tag_name.startsWith("tag.")) {
                return MessageText.getString(this.tag_name);
            }
            return this.tag_name;
        }
        if (this.tag_name.startsWith("tag.")) {
            return this.tag_name;
        }
        String original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null);
        if (original_name != null && original_name.startsWith("tag.")) {
            return original_name;
        }
        return "!" + this.tag_name + "!";
    }

    @Override
    public void setTagName(String name) throws TagException {
        String original_name;
        if (this.getTagType().isTagTypeAuto()) {
            throw new TagException("Not supported");
        }
        if (this.tag_name.startsWith("tag.") && (original_name = this.readStringAttribute(AT_ORIGINAL_NAME, null)) == null) {
            this.writeStringAttribute(AT_ORIGINAL_NAME, this.tag_name);
        }
        this.tag_name = name;
        this.tag_type.fireMetadataChanged(this);
    }

    @Override
    public boolean isPublic() {
        boolean[] autos;
        boolean pub;
        boolean bl = pub = this.is_public == null ? this.getPublicDefault() : this.is_public.booleanValue();
        if (pub && ((autos = this.isTagAuto())[0] || autos[1])) {
            pub = false;
        }
        return pub;
    }

    @Override
    public void setPublic(boolean v) {
        if (this.is_public == null || v != this.is_public) {
            if (v && !this.canBePublic()) {
                Debug.out("Invalid attempt to set public");
                return;
            }
            this.is_public = v;
            this.writeBooleanAttribute(AT_PUBLIC, v);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    protected boolean getPublicDefault() {
        if (!this.getCanBePublicDefault()) {
            return false;
        }
        return this.tag_type.getTagManager().getTagPublicDefault();
    }

    @Override
    public void setCanBePublic(boolean can_be_public) {
        this.writeBooleanAttribute(AT_CAN_BE_PUBLIC, can_be_public);
        if (!can_be_public && this.isPublic()) {
            this.setPublic(false);
        }
    }

    @Override
    public boolean canBePublic() {
        boolean[] autos;
        boolean result = this.readBooleanAttribute(AT_CAN_BE_PUBLIC, this.getCanBePublicDefault());
        if (result && ((autos = this.isTagAuto())[0] || autos[1])) {
            result = false;
        }
        return result;
    }

    protected boolean getCanBePublicDefault() {
        return true;
    }

    @Override
    public void setFlag(long flag, boolean value) {
        boolean set;
        boolean bl = set = (this.flags & flag) != 0L;
        if (set == value) {
            return;
        }
        this.flags = value ? (this.flags |= flag) : (this.flags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        this.writeLongAttribute(AT_FLAGS, this.flags);
        this.tag_type.fireMetadataChanged(this);
    }

    @Override
    public boolean getFlag(long flag) {
        return (this.flags & flag) != 0L;
    }

    @Override
    public boolean[] isTagAuto() {
        return new boolean[3];
    }

    @Override
    public boolean isVisible() {
        return this.is_visible == null ? this.getVisibleDefault() : this.is_visible.booleanValue();
    }

    @Override
    public void setVisible(boolean v) {
        if (this.is_visible == null || v != this.is_visible) {
            this.is_visible = v;
            this.writeBooleanAttribute(AT_VISIBLE, v);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String new_group) {
        if (this.group == null && new_group == null) {
            return;
        }
        if (this.group == null || new_group == null || !this.group.equals(new_group)) {
            String old_name = this.group;
            this.group = new_group;
            this.writeStringAttribute(AT_GROUP, new_group);
            this.tag_type.setTagGroup(this, old_name, new_group);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    @Override
    public TagGroup getGroupContainer() {
        return this.tag_type.getTagGroup(this.group);
    }

    protected boolean getVisibleDefault() {
        return true;
    }

    @Override
    public String getImageID() {
        return this.readStringAttribute(AT_IMAGE_ID, null);
    }

    @Override
    public void setImageID(String id) {
        this.writeStringAttribute(AT_IMAGE_ID, id);
        this.tag_type.fireMetadataChanged(this);
    }

    @Override
    public String getImageFile() {
        if (this.image_file == null) {
            this.image_file = this.readStringAttribute(AT_IMAGE_FILE, "");
        }
        return this.image_file.isEmpty() ? null : this.image_file;
    }

    @Override
    public void setImageFile(String id) {
        this.image_file = id == null ? "" : id;
        this.writeStringAttribute(AT_IMAGE_FILE, id);
        this.tag_type.fireMetadataChanged(this);
    }

    @Override
    public void setImageSortOrder(int order) {
        this.image_sort_order = order;
        this.writeLongAttribute(AT_IMAGE_SORT_ORDER, order);
        this.tag_type.fireMetadataChanged(this);
    }

    @Override
    public int getImageSortOrder() {
        int result = this.image_sort_order;
        if (result == Integer.MIN_VALUE) {
            result = this.image_sort_order = this.readLongAttribute(AT_IMAGE_SORT_ORDER, -1L).intValue();
        }
        return result;
    }

    private int[] decodeRGB(String str) {
        if (str == null) {
            return null;
        }
        String[] bits = str.split(",");
        if (bits.length != 3) {
            return null;
        }
        int[] rgb = new int[3];
        int i = 0;
        while (i < bits.length) {
            try {
                rgb[i] = Integer.parseInt(bits[i]);
            }
            catch (Throwable e) {
                return null;
            }
            ++i;
        }
        return rgb;
    }

    private String encodeRGB(int[] rgb) {
        if (rgb == null || rgb.length != 3) {
            return null;
        }
        return String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2];
    }

    @Override
    public boolean isColorDefault() {
        return this.decodeRGB(this.readStringAttribute(AT_COLOR_ID, null)) == null;
    }

    @Override
    public int[] getColor() {
        int[] result = this.colour;
        if (result == null) {
            result = this.decodeRGB(this.readStringAttribute(AT_COLOR_ID, null));
            if (result == null) {
                result = this.tag_type.getColorDefault();
            }
            this.colour = result;
        }
        return result;
    }

    @Override
    public void setColor(int[] rgb) {
        TagGroup tg;
        if (rgb == null && this.group != null && (tg = this.getGroupContainer()) != null) {
            rgb = tg.getColor();
        }
        boolean changed = this.writeStringAttribute(AT_COLOR_ID, this.encodeRGB(rgb));
        this.colour = null;
        if (changed) {
            this.tag_type.fireMetadataChanged(this);
        }
    }

    @Override
    public long[] getColors() {
        long[] result = this.colours;
        if (result == null) {
            this.colours = result = this.readLongListAttribute(AT_COLORS_ID, new long[0]);
        }
        return result;
    }

    @Override
    public void setColors(long[] params) {
        boolean changed;
        if (params == null) {
            params = new long[]{};
        }
        if (this.colours != null && this.colours.length == 0 && params.length == 0) {
            changed = false;
        } else {
            changed = this.writeLongListAttribute(AT_COLORS_ID, params);
            if (this.colours == null) {
                changed = true;
            }
        }
        this.colours = params;
        if (changed) {
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean isTagRSSFeedEnabled() {
        if (this.tag_rss != null) {
            return this.readBooleanAttribute(AT_RSS_ENABLE, false);
        }
        return false;
    }

    public void setTagRSSFeedEnabled(boolean enable) {
        if (this.tag_rss != null && this.isTagRSSFeedEnabled() != enable) {
            this.writeBooleanAttribute(AT_RSS_ENABLE, enable);
            this.tag_type.fireMetadataChanged(this);
            this.tag_type.getTagManager().checkRSSFeeds(this, enable);
        }
    }

    public boolean getPreventDelete() {
        if (this.tag_fl != null) {
            return this.readBooleanAttribute(AT_FL_PREVENT_DELETE, false);
        }
        return false;
    }

    public void setPreventDelete(boolean b) {
        if (this.tag_fl != null && this.getPreventDelete() != b) {
            this.writeBooleanAttribute(AT_FL_PREVENT_DELETE, b);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean getTagBoost() {
        if (this.tag_rl != null) {
            return this.readBooleanAttribute(AT_RATELIMIT_BOOST, false);
        }
        return false;
    }

    public void setTagBoost(boolean boost) {
        if (this.tag_rl != null && this.getTagBoost() != boost) {
            this.writeBooleanAttribute(AT_RATELIMIT_BOOST, boost);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public int getMaxActiveDownloads() {
        if (this.tag_rl != null) {
            return this.readLongAttribute(AT_RATELIMIT_MAX_ACTIVE_DL, 0L).intValue();
        }
        return 0;
    }

    public void setMaxActiveDownloads(int max) {
        if (this.tag_rl != null && this.getMaxActiveDownloads() != max) {
            this.writeLongAttribute(AT_RATELIMIT_MAX_ACTIVE_DL, max);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public int getMaxActiveSeeds() {
        if (this.tag_rl != null) {
            return this.readLongAttribute(AT_RATELIMIT_MAX_ACTIVE_CD, 0L).intValue();
        }
        return 0;
    }

    public void setMaxActiveSeeds(int max) {
        if (this.tag_rl != null && this.getMaxActiveSeeds() != max) {
            this.writeLongAttribute(AT_RATELIMIT_MAX_ACTIVE_CD, max);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean getStrictActivityLimits() {
        if (this.tag_rl != null) {
            return this.readBooleanAttribute(AT_RATELIMIT_ACTIVE_LIMITS_STRICT, true);
        }
        return false;
    }

    public void setStrictActivityLimits(boolean b) {
        if (this.tag_rl != null && this.getStrictActivityLimits() != b) {
            this.writeBooleanAttribute(AT_RATELIMIT_ACTIVE_LIMITS_STRICT, b);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean supportsTagInitialSaveFolder() {
        return false;
    }

    public File getTagInitialSaveFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_INIT_LOC, null);
            if (str == null) {
                return null;
            }
            return FileUtil.newFile(str, new String[0]);
        }
        return null;
    }

    public void setTagInitialSaveFolder(File folder) {
        if (this.tag_fl != null) {
            boolean changed;
            File existing = this.getTagInitialSaveFolder();
            if (existing == null && folder == null) {
                return;
            }
            if ((existing == null || folder == null || !existing.equals(folder)) && (changed = this.writeStringAttribute(AT_FL_INIT_LOC, folder == null ? null : folder.getAbsolutePath()))) {
                this.tag_type.fireMetadataChanged(this);
            }
        }
    }

    public long getTagInitialSaveOptions() {
        if (this.tag_fl != null) {
            return this.readLongAttribute(AT_FL_INIT_LOC_OPT, 1L);
        }
        return 0L;
    }

    public void setTagInitialSaveOptions(long options) {
        long existing;
        if (this.tag_fl != null && (existing = this.getTagInitialSaveOptions()) != options) {
            this.writeLongAttribute(AT_FL_INIT_LOC_OPT, options);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean supportsTagMoveOnComplete() {
        return false;
    }

    public File getTagMoveOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_MOVE_COMP, null);
            if (str == null) {
                return null;
            }
            return FileUtil.newFile(str, new String[0]);
        }
        return null;
    }

    public void setTagMoveOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            boolean changed;
            File existing = this.getTagMoveOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if ((existing == null || folder == null || !existing.equals(folder)) && (changed = this.writeStringAttribute(AT_FL_MOVE_COMP, folder == null ? null : folder.getAbsolutePath()))) {
                this.tag_type.fireMetadataChanged(this);
            }
        }
    }

    public long getTagMoveOnCompleteOptions() {
        if (this.tag_fl != null) {
            return this.readLongAttribute(AT_FL_MOVE_COMP_OPT, 1L);
        }
        return 0L;
    }

    public void setTagMoveOnCompleteOptions(long options) {
        long existing;
        if (this.tag_fl != null && (existing = this.getTagMoveOnCompleteOptions()) != options) {
            this.writeLongAttribute(AT_FL_MOVE_COMP_OPT, options);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean supportsTagCopyOnComplete() {
        return false;
    }

    public File getTagCopyOnCompleteFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_COPY_COMP, null);
            if (str == null) {
                return null;
            }
            return FileUtil.newFile(str, new String[0]);
        }
        return null;
    }

    public void setTagCopyOnCompleteFolder(File folder) {
        if (this.tag_fl != null) {
            boolean changed;
            File existing = this.getTagCopyOnCompleteFolder();
            if (existing == null && folder == null) {
                return;
            }
            if ((existing == null || folder == null || !existing.equals(folder)) && (changed = this.writeStringAttribute(AT_FL_COPY_COMP, folder == null ? null : folder.getAbsolutePath()))) {
                this.tag_type.fireMetadataChanged(this);
            }
        }
    }

    public long getTagCopyOnCompleteOptions() {
        if (this.tag_fl != null) {
            return this.readLongAttribute(AT_FL_COPY_COMP_OPT, 1L);
        }
        return 0L;
    }

    public void setTagCopyOnCompleteOptions(long options) {
        long existing;
        if (this.tag_fl != null && (existing = this.getTagCopyOnCompleteOptions()) != options) {
            this.writeLongAttribute(AT_FL_COPY_COMP_OPT, options);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean supportsTagMoveOnRemove() {
        return false;
    }

    public File getTagMoveOnRemoveFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_MOVE_REM, null);
            if (str == null) {
                return null;
            }
            return FileUtil.newFile(str, new String[0]);
        }
        return null;
    }

    public void setTagMoveOnRemoveFolder(File folder) {
        if (this.tag_fl != null) {
            boolean changed;
            File existing = this.getTagMoveOnRemoveFolder();
            if (existing == null && folder == null) {
                return;
            }
            if ((existing == null || folder == null || !existing.equals(folder)) && (changed = this.writeStringAttribute(AT_FL_MOVE_REM, folder == null ? null : folder.getAbsolutePath()))) {
                this.tag_type.fireMetadataChanged(this);
            }
        }
    }

    public long getTagMoveOnRemoveOptions() {
        if (this.tag_fl != null) {
            return this.readLongAttribute(AT_FL_MOVE_REM_OPT, 1L);
        }
        return 0L;
    }

    public void setTagMoveOnRemoveOptions(long options) {
        long existing;
        if (this.tag_fl != null && (existing = this.getTagMoveOnRemoveOptions()) != options) {
            this.writeLongAttribute(AT_FL_MOVE_REM_OPT, options);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public boolean supportsTagMoveOnAssign() {
        return false;
    }

    public File getTagMoveOnAssignFolder() {
        if (this.tag_fl != null) {
            String str = this.readStringAttribute(AT_FL_MOVE_ASSIGN, null);
            if (str == null) {
                return null;
            }
            return FileUtil.newFile(str, new String[0]);
        }
        return null;
    }

    public void setTagMoveOnAssignFolder(File folder) {
        if (this.tag_fl != null) {
            boolean changed;
            File existing = this.getTagMoveOnAssignFolder();
            if (existing == null && folder == null) {
                return;
            }
            if ((existing == null || folder == null || !existing.equals(folder)) && (changed = this.writeStringAttribute(AT_FL_MOVE_ASSIGN, folder == null ? null : folder.getAbsolutePath()))) {
                this.setTagInitialSaveFolder(folder);
                this.tag_type.fireMetadataChanged(this);
            }
        }
    }

    public long getTagMoveOnAssignOptions() {
        if (this.tag_fl != null) {
            return this.readLongAttribute(AT_FL_MOVE_ASSIGN_OPT, 1L);
        }
        return 0L;
    }

    public void setTagMoveOnAssignOptions(long options) {
        long existing;
        if (this.tag_fl != null && (existing = this.getTagMoveOnAssignOptions()) != options) {
            this.writeLongAttribute(AT_FL_MOVE_ASSIGN_OPT, options);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public int getTagMinShareRatio() {
        return -1;
    }

    public void setTagMinShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxShareRatio() {
        return -1;
    }

    public void setTagMaxShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxShareRatioAction() {
        return -1;
    }

    public void setTagMaxShareRatioAction(int action) {
        Debug.out("not supported");
    }

    public int getTagAggregateShareRatio() {
        return -1;
    }

    public int getTagMaxAggregateShareRatio() {
        return -1;
    }

    public void setTagMaxAggregateShareRatio(int sr) {
        Debug.out("not supported");
    }

    public int getTagMaxAggregateShareRatioAction() {
        return -1;
    }

    public void setTagMaxAggregateShareRatioAction(int action) {
        Debug.out("not supported");
    }

    public boolean getTagMaxAggregateShareRatioHasPriority() {
        return true;
    }

    public void setTagMaxAggregateShareRatioHasPriority(boolean priority) {
        Debug.out("not supported");
    }

    public boolean getFirstPrioritySeeding() {
        return false;
    }

    public void setFirstPrioritySeeding(boolean priority) {
        Debug.out("not supported");
    }

    public boolean getNotFirstPrioritySeeding() {
        return false;
    }

    public void setNotFirstPrioritySeeding(boolean priority) {
        Debug.out("not supported");
    }

    public int getMaximumTaggables() {
        if (this.tag_limits != null) {
            return this.readLongAttribute(AT_MAX_TAGGABLES, 0L).intValue();
        }
        return -1;
    }

    public void setMaximumTaggables(int max) {
        if (this.tag_limits != null && this.getMaximumTaggables() != max) {
            this.writeLongAttribute(AT_MAX_TAGGABLES, max);
            this.tag_type.fireMetadataChanged(this);
            this.checkMaximumTaggables();
        }
    }

    protected void checkMaximumTaggables() {
    }

    public int getRemovalStrategy() {
        if (this.tag_limits != null) {
            return this.readLongAttribute(AT_REMOVAL_STRATEGY, 0L).intValue();
        }
        return -1;
    }

    public void setRemovalStrategy(int id) {
        if (this.tag_limits != null && this.getRemovalStrategy() != id) {
            this.writeLongAttribute(AT_REMOVAL_STRATEGY, id);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public int getOrdering() {
        if (this.tag_limits != null) {
            return this.readLongAttribute(AT_LIMIT_ORDERING, 0L).intValue();
        }
        return -1;
    }

    public void setOrdering(int id) {
        if (this.tag_limits != null && this.getOrdering() != id) {
            this.writeLongAttribute(AT_LIMIT_ORDERING, id);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return new TagFeatureProperties.TagProperty[0];
    }

    public TagFeatureProperties.TagProperty getProperty(String name) {
        TagFeatureProperties.TagProperty[] props;
        TagFeatureProperties.TagProperty[] tagPropertyArray = props = this.getSupportedProperties();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
            if (prop.getName(false) == name) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    protected TagFeatureProperties.TagProperty createTagProperty(String name, int type) {
        return new TagPropertyImpl(name, type);
    }

    public int getSupportedActions() {
        return 0;
    }

    public boolean supportsAction(int action) {
        return (this.getSupportedActions() & action) != 0;
    }

    public boolean isAnyActionEnabled() {
        int[] nArray = TagFeatureExecOnAssign.ACTIONS;
        int n = TagFeatureExecOnAssign.ACTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int action = nArray[n2];
            if (this.isActionEnabled(action)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isActionEnabled(int action) {
        if (!this.supportsAction(action)) {
            return false;
        }
        return this.readBooleanAttribute(AT_PROPERTY_PREFIX + action, false);
    }

    public void setActionEnabled(int action, boolean enabled) {
        if (!this.supportsAction(action)) {
            if (enabled) {
                Debug.out("not supported");
            }
            return;
        }
        this.writeBooleanAttribute(AT_PROPERTY_PREFIX + action, enabled);
        this.tag_type.fireMetadataChanged(this);
    }

    public String getActionScript() {
        String script = this.readStringAttribute(AT_EOS_SCRIPT, "");
        if (script == null) {
            script = "";
        }
        return script;
    }

    public void setActionScript(String script) {
        boolean changed;
        if (script == null) {
            script = "";
        }
        if (changed = this.writeStringAttribute(AT_EOS_SCRIPT, script = script.trim())) {
            this.setActionEnabled(32, script.length() > 0);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public String getPostMessageChannel() {
        String channel2 = this.readStringAttribute(AT_EOS_PM, "");
        if (channel2 == null) {
            channel2 = "";
        }
        return channel2;
    }

    public void setPostMessageChannel(String channel2) {
        boolean changed;
        if (channel2 == null) {
            channel2 = "";
        }
        if (changed = this.writeStringAttribute(AT_EOS_PM, channel2 = channel2.trim())) {
            this.setActionEnabled(512, channel2.length() > 0);
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public TagFeatureExecOnAssign.OptionsTemplateHandler getOptionsTemplateHandler() {
        return new TagFeatureExecOnAssign.OptionsTemplateHandler(){
            private CopyOnWriteList<DownloadManagerOptionsHandler.ParameterChangeListener> listeners = new CopyOnWriteList();

            @Override
            public boolean isActive() {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                return map != null && !map.isEmpty();
            }

            private void update(Map<String, Object> map) {
                if (map != null && map.isEmpty()) {
                    map = null;
                }
                TagBase.this.writeMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, map);
                if (map == null) {
                    TagBase.this.setActionEnabled(256, false);
                } else {
                    TagBase.this.setActionEnabled(256, true);
                }
            }

            @Override
            public String getName() {
                return String.valueOf(MessageText.getString("label.options.template")) + " : " + TagBase.this.getTagName(true);
            }

            @Override
            public int getUploadRateLimitBytesPerSecond() {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                return MapUtils.getMapInt(map, "gen_up", 0);
            }

            @Override
            public void setUploadRateLimitBytesPerSecond(int limit) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, new HashMap<String, Object>());
                if (limit == 0) {
                    map.remove("gen_up");
                } else {
                    map.put("gen_up", limit);
                }
                this.update(map);
            }

            @Override
            public int getDownloadRateLimitBytesPerSecond() {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                return MapUtils.getMapInt(map, "gen_down", 0);
            }

            @Override
            public void setDownloadRateLimitBytesPerSecond(int limit) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, new HashMap<String, Object>());
                if (limit == 0) {
                    map.remove("gen_down");
                } else {
                    map.put("gen_down", limit);
                }
                this.update(map);
            }

            @Override
            public int getIntParameter(String name) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                return MapUtils.getMapInt(map, name, DownloadManagerStateFactory.getIntParameterDefault(name));
            }

            @Override
            public void setIntParameter(String name, int value) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, new HashMap<String, Object>());
                if (value == DownloadManagerStateFactory.getIntParameterDefault(name)) {
                    map.remove(name);
                } else {
                    map.put(name, new Long(value));
                }
                this.update(map);
            }

            @Override
            public boolean getBooleanParameter(String name) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                return MapUtils.getMapBoolean(map, name, DownloadManagerStateFactory.getBooleanParameterDefault(name));
            }

            @Override
            public void setBooleanParameter(String name, boolean value) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, new HashMap<String, Object>());
                if (value == DownloadManagerStateFactory.getBooleanParameterDefault(name)) {
                    map.remove(name);
                } else {
                    map.put(name, value ? 1 : 0);
                }
                this.update(map);
            }

            @Override
            public void setParameterDefault(String key) {
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                if (map != null) {
                    map.remove(key);
                    this.update(map);
                    for (DownloadManagerOptionsHandler.ParameterChangeListener l : this.listeners) {
                        try {
                            l.parameterChanged(this);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }

            @Override
            public DownloadManager getDownloadManager() {
                return null;
            }

            @Override
            public void addListener(DownloadManagerOptionsHandler.ParameterChangeListener listener) {
                this.listeners.add(listener);
            }

            @Override
            public void removeListener(DownloadManagerOptionsHandler.ParameterChangeListener listener) {
                this.listeners.remove(listener);
            }

            @Override
            public void applyTo(DownloadManager dm) {
                int up;
                Map<String, Object> map = TagBase.this.readMapAttribute(TagBase.AT_EOS_OPTIONS_TEMPLATE, null);
                if (map == null) {
                    return;
                }
                if (map.containsKey("gen_up")) {
                    up = MapUtils.getMapInt(map, "gen_up", 0);
                    dm.getStats().setUploadRateLimitBytesPerSecond(up);
                }
                if (map.containsKey("gen_down")) {
                    up = MapUtils.getMapInt(map, "gen_down", 0);
                    dm.getStats().setDownloadRateLimitBytesPerSecond(up);
                }
                DownloadManagerState state = dm.getDownloadState();
                for (String name : map.keySet()) {
                    if (name.startsWith("gen_")) continue;
                    if (DownloadManagerStateFactory.getBooleanParameterDefault(name) != null) {
                        state.setBooleanParameter(name, MapUtils.getMapBoolean(map, name, false));
                        continue;
                    }
                    if (DownloadManagerStateFactory.getIntParameterDefault(name) == null) continue;
                    state.setIntParameter(name, MapUtils.getMapInt(map, name, 0));
                }
            }
        };
    }

    public int getAutoApplySortInterval() {
        return this.readLongAttribute(AT_AUTO_APPLY_SORT_INTERVAL, 0L).intValue();
    }

    public void setAutoApplySortInterval(int secs) {
        this.writeLongAttribute(AT_AUTO_APPLY_SORT_INTERVAL, secs);
    }

    public void applySort() {
    }

    public int getWeight() {
        return this.readLongAttribute(AT_WEIGHT, 0L).intValue();
    }

    public void setWeight(int weight) {
        this.writeLongAttribute(AT_WEIGHT, weight);
    }

    public int getPostingNotifications() {
        return this.readLongAttribute(AT_NOTIFICATION_POST, 0L).intValue();
    }

    public void setPostingNotifications(int flags) {
        this.writeLongAttribute(AT_NOTIFICATION_POST, flags);
    }

    public String getNotifyMessageChannel() {
        String channel2 = this.readStringAttribute(AT_NOTIFICATION_PUBLISH, "");
        if (channel2 == null) {
            channel2 = "";
        }
        return channel2;
    }

    public void setNotifyMessageChannel(String channel2) {
        boolean changed;
        if (channel2 == null) {
            channel2 = "";
        }
        if (changed = this.writeStringAttribute(AT_NOTIFICATION_PUBLISH, channel2 = channel2.trim())) {
            this.tag_type.fireMetadataChanged(this);
        }
    }

    public List<Tag> getTagAssigns() {
        String[] tag_uids = this.readStringListAttribute(AT_EOS_ASSIGN_TAGS, new String[0]);
        if (tag_uids == null || tag_uids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        String[] stringArray = tag_uids;
        int n = tag_uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            try {
                Tag tag = this.tag_type.getTagManager().lookupTagByUID(Long.parseLong(uid));
                if (tag != null) {
                    result.add(tag);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            ++n2;
        }
        return result;
    }

    public void setTagAssigns(List<Tag> tags) {
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        String[] tag_uids = new String[tags.size()];
        int i = 0;
        while (i < tag_uids.length) {
            tag_uids[i] = String.valueOf(tags.get(i).getTagUID());
            ++i;
        }
        this.writeStringListAttribute(AT_EOS_ASSIGN_TAGS, tag_uids);
        this.setActionEnabled(2048, !tags.isEmpty());
        this.tag_type.fireMetadataChanged(this);
    }

    public List<Tag> getTagRemoves() {
        String[] tag_uids = this.readStringListAttribute(AT_EOS_REMOVE_TAGS, new String[0]);
        if (tag_uids == null || tag_uids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        String[] stringArray = tag_uids;
        int n = tag_uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            try {
                Tag tag = this.tag_type.getTagManager().lookupTagByUID(Long.parseLong(uid));
                if (tag != null) {
                    result.add(tag);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            ++n2;
        }
        return result;
    }

    public void setTagRemoves(List<Tag> tags) {
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        String[] tag_uids = new String[tags.size()];
        int i = 0;
        while (i < tag_uids.length) {
            tag_uids[i] = String.valueOf(tags.get(i).getTagUID());
            ++i;
        }
        this.writeStringListAttribute(AT_EOS_REMOVE_TAGS, tag_uids);
        this.setActionEnabled(16384, !tags.isEmpty());
        this.tag_type.fireMetadataChanged(this);
    }

    public String getPropertiesString() {
        TagFeatureProperties.TagProperty[] props = this.getSupportedProperties();
        String text = "";
        if (props.length > 0) {
            TagFeatureProperties.TagProperty[] tagPropertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
                String prop_str = prop.getString();
                if (prop_str.length() > 0) {
                    text = String.valueOf(text) + (text.length() == 0 ? "" : "; ") + prop_str;
                }
                ++n2;
            }
        }
        return text;
    }

    public String getEOAString() {
        String text = "";
        int actions = this.getSupportedActions();
        if (actions != 0) {
            String actions_str = "";
            boolean is_peer_set = this.getTagType().getTagType() == 4;
            int[] action_ids = new int[]{256, 1, 2, 8, 16, 4, 32768, 32, 64, 128, 512, 1024, 2048, 16384, 4096, 8192, 65536};
            String[] action_keys = new String[]{"label.apply.options.template", is_peer_set ? "azbuddy.ui.menu.disconnect" : "v3.MainWindow.button.delete", "v3.MainWindow.button.start", "v3.MainWindow.button.forcestart", "v3.MainWindow.button.notforcestart", "v3.MainWindow.button.stop", "ConfigView.section.queue", "label.script", "v3.MainWindow.button.pause", "v3.MainWindow.button.resume", "label.post.magnet.to.chat", "label.init.save.loc.move", "label.assign.tags", "label.remove.tags", "menu.host.on.tracker", "menu.publish.on.tracker", "label.ban"};
            int i = 0;
            while (i < action_ids.length) {
                boolean enabled;
                int action_id = action_ids[i];
                if (this.supportsAction(action_id) && (enabled = this.isActionEnabled(action_id))) {
                    if (action_id == 32) {
                        String script = this.getActionScript();
                        if (script.length() > 63) {
                            script = String.valueOf(script.substring(0, 60)) + "...";
                        }
                        actions_str = String.valueOf(actions_str) + (actions_str.length() == 0 ? "" : ",") + MessageText.getString(action_keys[i]) + "=" + script;
                    } else if (action_id == 2048 || action_id == 16384) {
                        List<Tag> tags = action_id == 2048 ? this.getTagAssigns() : this.getTagRemoves();
                        String tag_str = "";
                        for (Tag t : tags) {
                            tag_str = String.valueOf(tag_str) + (tag_str == "" ? "" : ";") + t.getTagName(true);
                        }
                        actions_str = String.valueOf(actions_str) + (actions_str.length() == 0 ? "" : ",") + MessageText.getString(action_keys[i]) + "=" + tag_str;
                    } else {
                        actions_str = String.valueOf(actions_str) + (actions_str.length() == 0 ? "" : ",") + MessageText.getString(action_keys[i]) + "=Y";
                    }
                }
                ++i;
            }
            if (actions_str.length() > 0) {
                text = String.valueOf(text) + actions_str;
            }
        }
        return text;
    }

    @Override
    public void addTaggableBatch(boolean starts) {
    }

    @Override
    public void addTaggable(Taggable t) {
        this.tag_type.tagsOrMembershipChanged();
        this.t_listeners.dispatch(1, t);
        this.tag_type.taggableAdded(this, t);
        if (this.tag_limits != null) {
            this.checkMaximumTaggables();
        }
    }

    @Override
    public void removeTaggable(Taggable t) {
        this.tag_type.tagsOrMembershipChanged();
        this.t_listeners.dispatch(2, t);
        this.tag_type.taggableRemoved(this, t);
    }

    protected void sync() {
        this.t_listeners.dispatch(3, null);
        this.tag_type.taggableSync(this);
        this.savePersistentStuff();
    }

    protected void closing() {
        this.savePersistentStuff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag() {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.is_removed) {
                return;
            }
            this.is_removed = true;
        }
        boolean was_rss = this.isTagRSSFeedEnabled();
        this.tag_type.removeTag(this);
        this.setGroup(null);
        if (was_rss) {
            this.tag_type.getTagManager().checkRSSFeeds(this, false);
        }
        this.saveTransientStuff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTagRemoved() {
        TagBase tagBase = this;
        synchronized (tagBase) {
            return this.is_removed;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String str) {
        String existing = this.getDescription();
        if (existing == str) {
            return;
        }
        if (str != null && existing != null && str.equals(existing)) {
            return;
        }
        this.description = str;
        boolean changed = this.writeStringAttribute(AT_DESCRIPTION, str);
        if (changed) {
            this.tag_type.fireMetadataChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransientProperty(String property, Object value) {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.transient_properties == null) {
                if (value == null) {
                    return;
                }
                this.transient_properties = new HashMap();
            }
            if (value == null) {
                this.transient_properties.remove(property);
            } else {
                this.transient_properties.put(property, value);
            }
            this.tag_type.fireMetadataChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransientProperty(String property) {
        TagBase tagBase = this;
        synchronized (tagBase) {
            block4: {
                if (this.transient_properties != null) break block4;
                return null;
            }
            return this.transient_properties.get(property);
        }
    }

    @Override
    public void addTagListener(TagListener listener, boolean fire_for_existing) {
        if (!this.t_listeners.hasListener(listener)) {
            this.t_listeners.addListener(listener);
        }
        if (fire_for_existing) {
            for (Taggable t : this.getTagged()) {
                listener.taggableAdded(this, t);
            }
        }
    }

    protected void destroy() {
        Set<Taggable> taggables = this.getTagged();
        for (Taggable t : taggables) {
            this.tag_type.tagsOrMembershipChanged();
            this.t_listeners.dispatch(2, t);
            this.tag_type.taggableRemoved(this, t);
        }
    }

    @Override
    public void removeTagListener(TagListener listener) {
        this.t_listeners.removeListener(listener);
    }

    @Override
    public List<com.biglybt.pif.tag.Taggable> getTaggables() {
        Set<Taggable> taggables = this.getTagged();
        ArrayList<com.biglybt.pif.tag.Taggable> result = new ArrayList<com.biglybt.pif.tag.Taggable>(taggables.size());
        for (Taggable t : taggables) {
            if (!(t instanceof DownloadManager)) continue;
            result.add(PluginCoreUtils.wrap((DownloadManager)t));
        }
        return result;
    }

    @Override
    public void requestAttention() {
        this.tag_type.requestAttention(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final com.biglybt.pif.tag.TagListener listener) {
        Map<com.biglybt.pif.tag.TagListener, TagListener> map = this.listener_map;
        synchronized (map) {
            TagListener l = this.listener_map.get(listener);
            if (l != null) {
                Debug.out("listener already added");
                return;
            }
            l = new TagListener(){

                @Override
                public void taggableSync(Tag tag) {
                    listener.taggableSync(tag);
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    listener.taggableRemoved(tag, tagged);
                }

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    listener.taggableAdded(tag, tagged);
                }
            };
            this.listener_map.put(listener, l);
            this.addTagListener(l, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(com.biglybt.pif.tag.TagListener listener) {
        Map<com.biglybt.pif.tag.TagListener, TagListener> map = this.listener_map;
        synchronized (map) {
            TagListener l = this.listener_map.remove(listener);
            if (l == null) {
                Debug.out("listener not found");
                return;
            }
            this.removeTagListener(l);
        }
    }

    protected Boolean readBooleanAttribute(String attr, Boolean def) {
        return this.tag_type.readBooleanAttribute(this, attr, def);
    }

    protected boolean writeBooleanAttribute(String attr, Boolean value) {
        return this.tag_type.writeBooleanAttribute(this, attr, value);
    }

    protected Long readLongAttribute(String attr, Long def) {
        return this.tag_type.readLongAttribute(this, attr, def);
    }

    protected boolean writeLongAttribute(String attr, long value) {
        return this.tag_type.writeLongAttribute(this, attr, value);
    }

    protected String readStringAttribute(String attr, String def) {
        return this.tag_type.readStringAttribute(this, attr, def);
    }

    protected boolean writeStringAttribute(String attr, String value) {
        return this.tag_type.writeStringAttribute(this, attr, value);
    }

    protected Map<String, Object> readMapAttribute(String attr, Map<String, Object> def) {
        return this.tag_type.readMapAttribute(this, attr, def);
    }

    protected void writeMapAttribute(String attr, Map<String, Object> value) {
        this.tag_type.writeMapAttribute(this, attr, value);
    }

    protected String[] readStringListAttribute(String attr, String[] def) {
        return this.tag_type.readStringListAttribute(this, attr, def);
    }

    protected boolean writeStringListAttribute(String attr, String[] value) {
        return this.tag_type.writeStringListAttribute(this, attr, value);
    }

    protected long[] readLongListAttribute(String attr, long[] def) {
        return this.tag_type.readLongListAttribute(this, attr, def);
    }

    protected boolean writeLongListAttribute(String attr, long[] value) {
        return this.tag_type.writeLongListAttribute(this, attr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransientStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            Map<Long, long[][]> map = session_cache;
            synchronized (map) {
                long[][] entry = session_cache.get(this.getTagUID());
                if (entry != null) {
                    this.total_up_at_start = entry[0];
                    this.total_down_at_start = entry[1];
                    this.session_up = entry[2];
                    this.session_down = entry[3];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTransientStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            long[] session_up = this.getTagSessionUploadTotalRaw();
            long[] session_down = this.getTagSessionDownloadTotalRaw();
            Map<Long, long[][]> map = session_cache;
            synchronized (map) {
                session_cache.put(this.getTagUID(), new long[][]{this.total_up_at_start, this.total_down_at_start, session_up, session_down});
            }
        }
    }

    private void loadPersistentStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            String[] downs;
            String[] ups = this.readStringListAttribute(AT_BYTES_UP, null);
            if (ups != null) {
                this.total_up_at_start = new long[ups.length];
                int i = 0;
                while (i < ups.length) {
                    try {
                        this.total_up_at_start[i] = Long.parseLong(ups[i]);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
            }
            if ((downs = this.readStringListAttribute(AT_BYTES_DOWN, null)) != null) {
                this.total_down_at_start = new long[downs.length];
                int i = 0;
                while (i < downs.length) {
                    try {
                        this.total_down_at_start[i] = Long.parseLong(downs[i]);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
            }
        }
    }

    private void savePersistentStuff() {
        if (this.tag_rl != null && this.tag_rl.supportsTagRates()) {
            long[] session_down;
            long[] session_up = this.getTagSessionUploadTotalRaw();
            if (session_up != null) {
                String[] ups = new String[session_up.length];
                int i = 0;
                while (i < ups.length) {
                    long l = session_up[i];
                    if (this.total_up_at_start != null && this.total_up_at_start.length > i) {
                        l += this.total_up_at_start[i];
                    }
                    ups[i] = String.valueOf(l);
                    ++i;
                }
                this.writeStringListAttribute(AT_BYTES_UP, ups);
            }
            if ((session_down = this.getTagSessionDownloadTotalRaw()) != null) {
                String[] downs = new String[session_down.length];
                int i = 0;
                while (i < downs.length) {
                    long l = session_down[i];
                    if (this.total_down_at_start != null && this.total_down_at_start.length > i) {
                        l += this.total_down_at_start[i];
                    }
                    downs[i] = String.valueOf(l);
                    ++i;
                }
                this.writeStringListAttribute(AT_BYTES_DOWN, downs);
            }
        }
    }

    public long[] getTagUploadTotal() {
        long[] result = this.getTagSessionUploadTotalRaw();
        if (result != null && this.total_up_at_start != null && this.total_up_at_start.length == result.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.total_up_at_start[i];
                ++i;
            }
        }
        return result;
    }

    public long[] getTagSessionUploadTotal() {
        long[] result = this.getTagSessionUploadTotalRaw();
        if (result != null && this.session_up_reset != null && result.length == this.session_up_reset.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] - this.session_up_reset[i];
                ++i;
            }
        }
        return result;
    }

    public void resetTagSessionUploadTotal() {
        this.session_up_reset = this.getTagSessionUploadTotalRaw();
    }

    private long[] getTagSessionUploadTotalRaw() {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return null;
        }
        long[] result = this.getTagSessionUploadTotalCurrent();
        if (result != null && this.session_up != null) {
            if (result.length == this.session_up.length) {
                int i = 0;
                while (i < result.length) {
                    int n = i;
                    result[n] = result[n] + this.session_up[i];
                    ++i;
                }
            } else {
                Debug.out("derp");
            }
        }
        return result;
    }

    protected long[] getTagSessionUploadTotalCurrent() {
        return null;
    }

    public long[] getTagDownloadTotal() {
        long[] result = this.getTagSessionDownloadTotalRaw();
        if (result != null && this.total_down_at_start != null && this.total_down_at_start.length == result.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.total_down_at_start[i];
                ++i;
            }
        }
        return result;
    }

    public long[] getTagSessionDownloadTotal() {
        long[] result = this.getTagSessionDownloadTotalRaw();
        if (result != null && this.session_down_reset != null && result.length == this.session_down_reset.length) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] - this.session_down_reset[i];
                ++i;
            }
        }
        return result;
    }

    public void resetTagSessionDownloadTotal() {
        this.session_down_reset = this.getTagSessionDownloadTotalRaw();
    }

    private long[] getTagSessionDownloadTotalRaw() {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return null;
        }
        long[] result = this.getTagSessionDownloadTotalCurrent();
        if (result != null && this.session_down != null) {
            if (result.length == this.session_down.length) {
                int i = 0;
                while (i < result.length) {
                    int n = i;
                    result[n] = result[n] + this.session_down[i];
                    ++i;
                }
            } else {
                Debug.out("derp");
            }
        }
        return result;
    }

    protected long[] getTagSessionDownloadTotalCurrent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentHistoryRetention(boolean required) {
        if (this.tag_rl == null || !this.tag_rl.supportsTagRates()) {
            return;
        }
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (required) {
                if (!this.history_retention_required) {
                    this.history = new long[1800];
                    this.history_pos = 0;
                    this.history_retention_required = true;
                    if (!this.timer_registered) {
                        SimpleTimer.addTickReceiver(this);
                        this.timer_registered = true;
                    }
                }
            } else {
                this.history = null;
                this.history_retention_required = false;
                if (this.timer_registered) {
                    SimpleTimer.removeTickReceiver(this);
                    this.timer_registered = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getRecentHistory() {
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history == null) {
                return new int[2][0];
            }
            int entries = this.history_wrapped ? 1800 : this.history_pos;
            int start = this.history_wrapped ? this.history_pos : 0;
            int[][] result = new int[2][entries];
            int pos = start;
            int i = 0;
            while (i < entries) {
                if (pos == 1800) {
                    pos = 0;
                }
                long entry = this.history[pos++];
                int send_rate = (int)(entry >> 32 & 0xFFFFFFFFL);
                int recv_rate = (int)(entry & 0xFFFFFFFFL);
                result[0][i] = send_rate;
                result[1][i] = recv_rate;
                ++i;
            }
            return result;
        }
    }

    @Override
    public long getTaggableAddedTime(Taggable taggble) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(long mono_now, int count) {
        if (!this.history_retention_required) {
            return;
        }
        long send_rate = this.tag_rl.getTagCurrentUploadRate();
        long receive_rate = this.tag_rl.getTagCurrentDownloadRate();
        long entry = send_rate << 32 & 0xFFFFFFFF00000000L | receive_rate & 0xFFFFFFFFL;
        TagBase tagBase = this;
        synchronized (tagBase) {
            if (this.history != null) {
                this.history[this.history_pos++] = entry;
                if (this.history_pos == 1800) {
                    this.history_pos = 0;
                    this.history_wrapped = true;
                }
            }
        }
    }

    @Override
    public VuzeFile getVuzeFile() {
        return this.getManager().getVuzeFile(this);
    }

    public void generate(IndentWriter writer) {
        writer.println(this.tag_name);
        try {
            writer.indent();
            this.tag_type.generateConfig(writer, this);
        }
        finally {
            writer.exdent();
        }
    }

    private class TagPropertyImpl
    implements TagFeatureProperties.TagProperty {
        private final String name;
        private final int type;
        private final CopyOnWriteList<TagFeatureProperties.TagPropertyListener> listeners = new CopyOnWriteList();

        private TagPropertyImpl(String _name, int _type) {
            this.name = _name;
            this.type = _type;
        }

        @Override
        public Tag getTag() {
            return TagBase.this;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName(boolean localize) {
            if (localize) {
                return MessageText.getString("tag.property." + this.name);
            }
            return this.name;
        }

        @Override
        public boolean isEnabled() {
            return TagBase.this.readBooleanAttribute("pp.enabled." + this.name, true);
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (TagBase.this.writeBooleanAttribute("pp.enabled." + this.name, enabled)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireMetadataChanged(TagBase.this);
            }
        }

        @Override
        public void setStringList(String[] value) {
            String desc;
            long res;
            UIManager ui_manager;
            String[] old_value;
            String name = this.getName(false);
            if (name.equals("constraint") && ((old_value = this.getStringList()).length == 0 || old_value[0].trim().isEmpty()) && value != null && value.length > 0 && !value[0].trim().isEmpty() && !TagBase.this.getTaggables().isEmpty() && (ui_manager = StaticUtilities.getUIManager(15000L)) != null && (res = ui_manager.showMessageBox("tag.constraint.with.manuals.title", "!" + (desc = MessageText.getString("tag.constraint.with.manuals.desc", new String[]{TagBase.this.getTagName(true)})) + "!", 3L)) != 1L) {
                return;
            }
            if (TagBase.this.writeStringListAttribute(TagBase.AT_PROPERTY_PREFIX + name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireMetadataChanged(TagBase.this);
            }
        }

        @Override
        public String[] getStringList() {
            return TagBase.this.readStringListAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, EMPTY_STRING_LIST);
        }

        @Override
        public void setBoolean(Boolean value) {
            if (TagBase.this.writeBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireMetadataChanged(TagBase.this);
            }
        }

        @Override
        public Boolean getBoolean() {
            return TagBase.this.readBooleanAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, null);
        }

        @Override
        public void setLong(Long value) {
            if (TagBase.this.writeLongAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, value)) {
                for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                    try {
                        l.propertyChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                TagBase.this.tag_type.fireMetadataChanged(TagBase.this);
            }
        }

        @Override
        public Long getLong() {
            return TagBase.this.readLongAttribute(TagBase.AT_PROPERTY_PREFIX + this.name, null);
        }

        @Override
        public String getString() {
            String value = null;
            switch (this.getType()) {
                case 1: {
                    String[] vals = this.getStringList();
                    if (vals == null || vals.length <= 0) break;
                    value = "";
                    String name = this.getName(false);
                    if (name.equals("tracker_templates")) {
                        String str_merge = MessageText.getString("label.merge");
                        String str_replace = MessageText.getString("label.replace");
                        String str_remove = MessageText.getString("Button.remove");
                        String[] stringArray = vals;
                        int n = vals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String val = stringArray[n2];
                            String[] bits = val.split(":");
                            String type = bits[0];
                            String str = bits[1];
                            str = type.equals("m") ? String.valueOf(str) + ": " + str_merge : (type.equals("r") ? String.valueOf(str) + ": " + str_replace : String.valueOf(str) + ": " + str_remove);
                            value = String.valueOf(value) + (value.length() == 0 ? "" : ",") + str;
                            ++n2;
                        }
                    } else {
                        if (name.equals("constraint")) {
                            boolean auto_remove;
                            if ((value = String.valueOf(value) + vals[0]).trim().isEmpty()) {
                                value = null;
                                break;
                            }
                            if (vals.length <= 1) break;
                            String options = vals[1];
                            boolean new_dls = options.contains("am=3;");
                            if (new_dls) {
                                value = String.valueOf(value) + "," + MessageText.getString("label.scope");
                                value = String.valueOf(value) + "=";
                                value = String.valueOf(value) + MessageText.getString("label.new.downloads");
                                break;
                            }
                            boolean auto_add = !options.contains("am=2;");
                            boolean bl = auto_remove = !options.contains("am=1;");
                            if (auto_add && auto_remove || !auto_add && !auto_remove) break;
                            value = String.valueOf(value) + "," + MessageText.getString("label.scope");
                            value = String.valueOf(value) + "=";
                            if (auto_add) {
                                value = String.valueOf(value) + MessageText.getString("label.addition.only");
                                break;
                            }
                            value = String.valueOf(value) + MessageText.getString("label.removal.only");
                            break;
                        }
                        String[] stringArray = vals;
                        int n = vals.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String val = stringArray[n3];
                            value = String.valueOf(value) + (value.length() == 0 ? "" : ",") + val;
                            ++n3;
                        }
                    }
                    break;
                }
                case 2: {
                    Boolean val = this.getBoolean();
                    if (val == null) break;
                    value = String.valueOf(val);
                    break;
                }
                case 3: {
                    Long val = this.getLong();
                    if (val == null) break;
                    value = String.valueOf(val);
                    break;
                }
                default: {
                    value = "Unknown type";
                }
            }
            if (value == null) {
                return "";
            }
            return String.valueOf(this.getName(true)) + "=" + value;
        }

        @Override
        public void addListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(TagFeatureProperties.TagPropertyListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void syncListeners() {
            for (TagFeatureProperties.TagPropertyListener l : this.listeners) {
                try {
                    l.propertySync(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        @Override
        public String[] explainTaggable(Taggable taggable) {
            return TagBase.this.tag_type.getTagManager().explain(TagBase.this, this, taggable);
        }
    }
}

