/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagFeatureExecOnAssign;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagManagerImpl;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagWithState;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TagDownloadWithState
extends TagWithState
implements TagDownload,
TaggableResolver.LifecycleControlListener {
    private static Object FP_DL_KEY = new Object();
    private static Object NOT_FP_DL_KEY = new Object();
    private int upload_rate_limit;
    private int download_rate_limit;
    private int upload_rate = -1;
    private int download_rate = -1;
    private int aggregate_sr;
    private long session_up;
    private long session_down;
    private long last_rate_update;
    final Object UPLOAD_PRIORITY_ADDED_KEY = new Object();
    private int upload_priority;
    private int min_share_ratio;
    private int max_share_ratio;
    private int max_share_ratio_action;
    private int max_aggregate_share_ratio;
    private int max_aggregate_share_ratio_action;
    private boolean max_aggregate_share_ratio_priority;
    private boolean fp_seeding;
    private boolean not_fp_seeding;
    private boolean fp_or_not_seeding_ever;
    private int auto_sort_period;
    private long last_auto_sort = -1L;
    private boolean supports_xcode;
    private boolean supports_file_location;
    private boolean prevent_delete;
    private String notification_pub = "";
    final Object rate_lock = new Object();
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            String str = "tag_up: " + TagDownloadWithState.this.getTagName(true);
            if (TagDownloadWithState.this.upload_rate_limit < 0) {
                str = String.valueOf(str) + ": disabled";
            }
            return str;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            int res = TagDownloadWithState.this.upload_rate_limit;
            if (res < 0) {
                res = 0;
            }
            return res;
        }

        @Override
        public boolean isDisabled() {
            return TagDownloadWithState.this.upload_rate_limit < 0;
        }

        @Override
        public void updateBytesUsed(int used) {
            TagDownloadWithState tagDownloadWithState = TagDownloadWithState.this;
            tagDownloadWithState.session_up = tagDownloadWithState.session_up + (long)used;
        }
    };
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            String str = "tag_down: " + TagDownloadWithState.this.getTagName(true);
            if (TagDownloadWithState.this.download_rate_limit < 0) {
                str = String.valueOf(str) + ": disabled";
            }
            return str;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            int res = TagDownloadWithState.this.download_rate_limit;
            if (res < 0) {
                res = 0;
            }
            return res;
        }

        @Override
        public boolean isDisabled() {
            return TagDownloadWithState.this.download_rate_limit < 0;
        }

        @Override
        public void updateBytesUsed(int used) {
            TagDownloadWithState tagDownloadWithState = TagDownloadWithState.this;
            tagDownloadWithState.session_down = tagDownloadWithState.session_down + (long)used;
        }
    };
    private boolean do_rates;
    private boolean do_up;
    private boolean do_down;
    private boolean do_bytes;
    private int run_states;
    private static final AsyncDispatcher rs_async = new AsyncDispatcher(2000);
    private final TagFeatureProperties.TagProperty[] tag_properties = new TagFeatureProperties.TagProperty[]{this.createTagProperty("trackers", 1), this.createTagProperty("untagged", 2), this.createTagProperty("tracker_templates", 1), this.createTagProperty("constraint", 1)};
    private static final AsyncDispatcher move_dispatcher = new AsyncDispatcher("tag:eos_move");
    private List<DownloadManager> batch = new ArrayList<DownloadManager>();
    private int batch_depth = 0;
    private final DownloadManagerPeerListener peer_listener = new DownloadManagerPeerListener(){

        @Override
        public void peerManagerWillBeAdded(PEPeerManager manager) {
        }

        @Override
        public void peerManagerAdded(PEPeerManager manager) {
        }

        @Override
        public void peerManagerRemoved(PEPeerManager manager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerAdded(PEPeer peer) {
            Object object = TagDownloadWithState.this.rate_lock;
            synchronized (object) {
                if (TagDownloadWithState.this.upload_rate_limit < 0) {
                    peer.setUploadDisabled(this, true);
                }
                if (TagDownloadWithState.this.download_rate_limit < 0) {
                    peer.setDownloadDisabled(this, true);
                }
            }
        }

        @Override
        public void peerRemoved(PEPeer peer) {
        }
    };
    private BuddyPluginBeta.ChatInstance notification_pub_channel;
    private String notification_pub_channel_key;
    private long npc_initialised_time;
    private boolean npc_chat_ready;
    private AtomicLong ncp_pub_list_mutate_index = new AtomicLong();
    private LinkedList<NPCState> ncp_pub_list;
    private long ncp_pub_list_mut;
    private static final String NPC_ATTRIBUTE_NAME = "_tm::npc";
    private static final boolean[] AUTO_BOTH;
    private static final boolean[] AUTO_NONE;

    static {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        AUTO_BOTH = blArray;
        AUTO_NONE = new boolean[3];
    }

    public TagDownloadWithState(TagTypeBase tt, int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
        super(tt, tag_id, name);
        this.init(do_rates, do_up, do_down, do_bytes, run_states);
    }

    protected TagDownloadWithState(TagTypeBase tt, int tag_id, Map details, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
        super(tt, tag_id, details);
        this.init(do_rates, do_up, do_down, do_bytes, run_states);
    }

    private void init(boolean _do_rates, boolean _do_up, boolean _do_down, boolean _do_bytes, int _run_states) {
        TaggableResolver resolver;
        this.do_rates = _do_rates;
        this.do_up = _do_up;
        this.do_down = _do_down;
        this.do_bytes = _do_bytes;
        this.run_states = _run_states;
        if (this.do_up) {
            this.setRateLimit(this.readLongAttribute("rl.up", 0L).intValue(), true);
        }
        if (this.do_down) {
            this.setRateLimit(this.readLongAttribute("rl.down", 0L).intValue(), false);
        }
        this.upload_priority = this.readLongAttribute("rl.uppri", 0L).intValue();
        this.min_share_ratio = this.readLongAttribute("rl.minsr", 0L).intValue();
        this.max_share_ratio = this.readLongAttribute("rl.maxsr", 0L).intValue();
        this.max_share_ratio_action = this.readLongAttribute("rl.maxsr.a", 0L).intValue();
        this.max_aggregate_share_ratio = this.readLongAttribute("rl.maxaggsr", 0L).intValue();
        this.max_aggregate_share_ratio_action = this.readLongAttribute("rl.maxaggsr.a", 1L).intValue();
        this.max_aggregate_share_ratio_priority = this.readBooleanAttribute("rl.maxaggsr.p", true);
        this.fp_seeding = this.readBooleanAttribute("rl.fps", false);
        this.not_fp_seeding = this.readBooleanAttribute("rl.nfps", false);
        this.auto_sort_period = this.getAutoApplySortInterval();
        this.notification_pub = this.getNotifyMessageChannel();
        this.prevent_delete = this.getPreventDelete();
        if (this.prevent_delete && (resolver = this.getTagType().getResolver()) != null) {
            resolver.addLifecycleControlListener(this);
        }
        this.addTagListener(new TagListener(){

            @Override
            public void taggableAdded(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                TagDownloadWithState.this.setRateLimit(manager, true);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, true);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, TagDownloadWithState.this.min_share_ratio);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, TagDownloadWithState.this.max_share_ratio);
                }
                if (TagDownloadWithState.this.fp_seeding || TagDownloadWithState.this.not_fp_seeding) {
                    TagDownloadWithState.this.updateFPSeeding(manager, TagDownloadWithState.this.fp_seeding, TagDownloadWithState.this.not_fp_seeding);
                }
                TagDownloadWithState.this.ncp_pub_list_mutate_index.incrementAndGet();
            }

            @Override
            public void taggableSync(Tag tag) {
            }

            @Override
            public void taggableRemoved(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                TagDownloadWithState.this.setRateLimit(manager, false);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, 0);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, 0);
                }
                if (TagDownloadWithState.this.fp_seeding || TagDownloadWithState.this.not_fp_seeding) {
                    TagDownloadWithState.this.updateFPSeeding(manager, false, false);
                }
                TagDownloadWithState.this.ncp_pub_list_mutate_index.incrementAndGet();
            }

            private void updateMinShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.min", sr);
            }

            private void updateMaxShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.max", sr);
            }
        }, true);
    }

    @Override
    public void removeTag() {
        for (DownloadManager dm : this.getTaggedDownloads()) {
            this.setRateLimit(dm, false);
            if (this.upload_priority > 0) {
                dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
            }
            if (!this.fp_seeding && !this.not_fp_seeding) continue;
            this.updateFPSeeding(dm, false, false);
        }
        super.removeTag();
    }

    private static void moveDownload(final DownloadManager dm, final TagFeatureFileLocation fl) {
        move_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                File old_torrent_file;
                boolean set_torrent;
                File save_loc = fl.getTagInitialSaveFolder();
                long options = fl.getTagInitialSaveOptions();
                boolean set_data = (options & 1L) != 0L;
                boolean bl = set_torrent = (options & 2L) != 0L;
                if (set_data) {
                    File existing_save_loc = dm.getSaveLocation();
                    if (dm.getTorrent().isSimpleTorrent()) {
                        existing_save_loc = existing_save_loc.getParentFile();
                    }
                    if (!existing_save_loc.equals(save_loc)) {
                        try {
                            dm.moveDataFilesLive(save_loc);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                if (set_torrent && (old_torrent_file = FileUtil.newFile(dm.getTorrentFileName(), new String[0])).exists()) {
                    try {
                        dm.setTorrentFile(save_loc, old_torrent_file.getName());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaggableBatch(boolean starts) {
        String script;
        final ArrayList<DownloadManager> to_do = new ArrayList<DownloadManager>();
        List<DownloadManager> list = this.batch;
        synchronized (list) {
            if (starts) {
                ++this.batch_depth;
            } else {
                --this.batch_depth;
                if (this.batch_depth == 0) {
                    to_do.addAll(this.batch);
                    this.batch.clear();
                }
            }
        }
        if (!to_do.isEmpty() && (script = this.getActionScript()).length() > 0) {
            rs_async.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    TagManagerImpl.getSingleton().evalScript(TagDownloadWithState.this, script, to_do, "execAssign");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaggable(Taggable t) {
        if (t instanceof DownloadManager) {
            final DownloadManager dm = (DownloadManager)t;
            if (!dm.isDestroyed()) {
                super.addTaggable(t);
                int actions = this.getSupportedActions();
                if (actions != 0) {
                    List<Tag> tags;
                    File f;
                    TagDownloadWithState fl;
                    TagFeatureExecOnAssign.OptionsTemplateHandler handler;
                    String chat;
                    String script;
                    int dm_state;
                    if (this.isActionEnabled(2) || this.isActionEnabled(128)) {
                        dm_state = dm.getState();
                        if (dm_state == 70 || dm_state == 100) {
                            rs_async.dispatch(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    if (TagDownloadWithState.this.isActionEnabled(2)) {
                                        dm.setStateQueued();
                                    } else {
                                        dm.resume();
                                    }
                                }
                            });
                        }
                    } else if ((this.isActionEnabled(4) || this.isActionEnabled(64) || this.isActionEnabled(32768)) && (dm_state = dm.getState()) != 70 && dm_state != 65 && dm_state != 100) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (TagDownloadWithState.this.isActionEnabled(4)) {
                                    dm.stopIt(70, false, false);
                                } else if (TagDownloadWithState.this.isActionEnabled(32768)) {
                                    dm.stopIt(75, false, false);
                                } else {
                                    dm.pause(true);
                                }
                                TagDownloadWithState.this.checkMaximumTaggables();
                            }
                        });
                    }
                    if (this.isActionEnabled(8)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                dm.setForceStart(true);
                            }
                        });
                    } else if (this.isActionEnabled(16)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                dm.setForceStart(false);
                            }
                        });
                    }
                    if (this.isActionEnabled(32) && (script = this.getActionScript()).length() > 0) {
                        List<DownloadManager> list = this.batch;
                        synchronized (list) {
                            if (this.batch_depth > 0) {
                                this.batch.add(dm);
                            } else {
                                rs_async.dispatch(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        TagManagerImpl.getSingleton().evalScript(TagDownloadWithState.this, script, Arrays.asList(dm), "execAssign");
                                    }
                                });
                            }
                        }
                    }
                    if (this.isActionEnabled(512) && (chat = this.getPostMessageChannel()).length() > 0) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                String[] bits = chat.split(":", 2);
                                final String net = bits[0].startsWith("Public") ? "Public" : "I2P";
                                final String key = bits[1].trim();
                                SimpleTimer.addEvent("EOS:PM", SystemTime.getOffsetTime(250L), new TimerEventPerformer(){
                                    private final long start = SystemTime.getMonotonousTime();

                                    @Override
                                    public void perform(TimerEvent event2) {
                                        BuddyPluginBeta.ChatInstance chat = BuddyPluginUtils.getChat(net, key);
                                        if (chat != null) {
                                            try {
                                                if (chat.isAvailable()) {
                                                    chat.sendMessage(PluginCoreUtils.wrap(dm));
                                                } else if (SystemTime.getMonotonousTime() - this.start >= 600000L) {
                                                    Debug.out("EOS:PM Abandoned sending of magnet to " + chat);
                                                } else {
                                                    SimpleTimer.addEvent("EOS:PM", SystemTime.getOffsetTime(5000L), this);
                                                }
                                            }
                                            finally {
                                                if (chat.getReferenceCount() > 1) {
                                                    chat.destroy();
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        });
                    }
                    if (this.isActionEnabled(256) && (handler = this.getOptionsTemplateHandler()).isActive()) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                handler.applyTo(dm);
                            }
                        });
                    }
                    if (this.isActionEnabled(1024) && this.getTagType().hasTagTypeFeature(16L) && (fl = this).supportsTagInitialSaveFolder() && (f = fl.getTagInitialSaveFolder()) != null) {
                        TagDownloadWithState.moveDownload(dm, fl);
                    }
                    if (this.isActionEnabled(2048) && !(tags = this.getTagAssigns()).isEmpty()) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                for (Tag t : tags) {
                                    if (t.hasTaggable(dm)) continue;
                                    t.addTaggable(dm);
                                }
                            }
                        });
                    }
                    if (this.isActionEnabled(16384) && !(tags = this.getTagRemoves()).isEmpty()) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                for (Tag t : tags) {
                                    if (!t.hasTaggable(dm)) continue;
                                    t.removeTaggable(dm);
                                }
                            }
                        });
                    }
                    if (this.isActionEnabled(4096)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                try {
                                    CoreFactory.getSingleton().getTrackerHost().hostTorrent(dm.getTorrent(), true, false);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        });
                    }
                    if (this.isActionEnabled(8192)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                try {
                                    CoreFactory.getSingleton().getTrackerHost().publishTorrent(dm.getTorrent());
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        });
                    }
                }
            }
        } else {
            Debug.out("Invalid Taggable added: " + t);
        }
    }

    @Override
    public int getTaggableTypes() {
        return 2;
    }

    @Override
    public Set<DownloadManager> getTaggedDownloads() {
        return this.getTagged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRateLimit(DownloadManager manager, boolean added) {
        Object object = this.rate_lock;
        synchronized (object) {
            if (added) {
                if (manager.getUserData(this.rate_lock) == null) {
                    manager.setUserData(this.rate_lock, "");
                    manager.addPeerListener(this.peer_listener, true);
                    manager.addRateLimiter(this.upload_limiter, true);
                    manager.addRateLimiter(this.download_limiter, false);
                }
            } else if (manager.getUserData(this.rate_lock) != null) {
                manager.setUserData(this.rate_lock, null);
                manager.removeRateLimiter(this.upload_limiter, true);
                manager.removeRateLimiter(this.download_limiter, false);
                manager.removePeerListener(this.peer_listener);
                PEPeerManager pm = manager.getPeerManager();
                if (pm != null) {
                    List<PEPeer> peers = pm.getPeers();
                    if (this.upload_rate_limit < 0 || this.download_rate_limit < 0) {
                        for (PEPeer peer : peers) {
                            if (this.upload_rate_limit < 0) {
                                peer.setUploadDisabled(this.peer_listener, false);
                            }
                            if (this.download_rate_limit >= 0) continue;
                            peer.setDownloadDisabled(this.peer_listener, false);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRateLimit(int limit, boolean is_up) {
        if (limit < 0) {
            limit = -1;
        }
        Object object = this.rate_lock;
        synchronized (object) {
            if (is_up) {
                if (limit == this.upload_rate_limit) {
                    return;
                }
                if (limit < 0 || this.upload_rate_limit < 0) {
                    Set<DownloadManager> downloads = this.getTaggedDownloads();
                    for (DownloadManager dm : downloads) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) continue;
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            peer.setUploadDisabled(this.peer_listener, limit < 0);
                        }
                    }
                }
                this.upload_rate_limit = limit;
            } else {
                if (limit == this.download_rate_limit) {
                    return;
                }
                if (limit < 0 || this.download_rate_limit < 0) {
                    Set<DownloadManager> downloads = this.getTaggedDownloads();
                    for (DownloadManager dm : downloads) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) continue;
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            peer.setDownloadDisabled(this.peer_listener, limit < 0);
                        }
                    }
                }
                this.download_rate_limit = limit;
            }
        }
    }

    @Override
    public boolean supportsTagRates() {
        return this.do_rates;
    }

    @Override
    public boolean supportsTagUploadLimit() {
        return this.do_up;
    }

    @Override
    public boolean supportsTagDownloadLimit() {
        return this.do_down;
    }

    @Override
    public int getTagUploadLimit() {
        return this.upload_rate_limit;
    }

    @Override
    public void setTagUploadLimit(int bps) {
        if (this.upload_rate_limit == bps) {
            return;
        }
        if (!this.do_up) {
            Debug.out("Not supported");
            return;
        }
        this.setRateLimit(bps, true);
        this.writeLongAttribute("rl.up", this.upload_rate_limit);
        this.getTagType().fireMetadataChanged(this);
    }

    @Override
    public int getTagCurrentUploadRate() {
        this.updateStuff();
        return this.upload_rate;
    }

    @Override
    public int getTagDownloadLimit() {
        return this.download_rate_limit;
    }

    @Override
    public void setTagDownloadLimit(int bps) {
        if (this.download_rate_limit == bps) {
            return;
        }
        if (!this.do_down) {
            Debug.out("Not supported");
            return;
        }
        this.setRateLimit(bps, false);
        this.writeLongAttribute("rl.down", this.download_rate_limit);
        this.getTagType().fireMetadataChanged(this);
    }

    @Override
    public int getTagCurrentDownloadRate() {
        this.updateStuff();
        return this.download_rate;
    }

    @Override
    public int getTagUploadPriority() {
        return this.upload_priority;
    }

    @Override
    protected long[] getTagSessionUploadTotalCurrent() {
        if (this.do_bytes && this.do_up) {
            return new long[]{this.session_up};
        }
        return null;
    }

    @Override
    protected long[] getTagSessionDownloadTotalCurrent() {
        if (this.do_bytes && this.do_down) {
            return new long[]{this.session_down};
        }
        return null;
    }

    @Override
    public void setTagUploadPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        }
        if (priority == this.upload_priority) {
            return;
        }
        int old_up = this.upload_priority;
        this.upload_priority = priority;
        this.writeLongAttribute("rl.uppri", priority);
        if (old_up == 0 || priority == 0) {
            Set<DownloadManager> dms = this.getTaggedDownloads();
            for (DownloadManager dm : dms) {
                dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, priority > 0);
            }
        }
        this.getTagType().fireMetadataChanged(this);
    }

    @Override
    public int getTagMinShareRatio() {
        return this.min_share_ratio;
    }

    @Override
    public void setTagMinShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.min_share_ratio) {
            return;
        }
        this.min_share_ratio = sr;
        this.writeLongAttribute("rl.minsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.min", sr);
        }
        this.getTagType().fireMetadataChanged(this);
    }

    @Override
    public int getTagMaxShareRatio() {
        return this.max_share_ratio;
    }

    @Override
    public void setTagMaxShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.max_share_ratio) {
            return;
        }
        this.max_share_ratio = sr;
        this.writeLongAttribute("rl.maxsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.max", sr);
        }
        this.getTagType().fireMetadataChanged(this);
        this.checkIndividualShareRatio();
    }

    @Override
    public int getTagMaxShareRatioAction() {
        return this.max_share_ratio_action;
    }

    @Override
    public void setTagMaxShareRatioAction(int action) {
        if (action == this.max_share_ratio_action) {
            return;
        }
        this.max_share_ratio_action = action;
        this.writeLongAttribute("rl.maxsr.a", action);
        this.getTagType().fireMetadataChanged(this);
        this.checkIndividualShareRatio();
    }

    @Override
    public int getTagAggregateShareRatio() {
        this.updateStuff();
        return this.aggregate_sr;
    }

    @Override
    public int getTagMaxAggregateShareRatio() {
        return this.max_aggregate_share_ratio;
    }

    @Override
    public void setTagMaxAggregateShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.max_aggregate_share_ratio) {
            return;
        }
        this.max_aggregate_share_ratio = sr;
        this.writeLongAttribute("rl.maxaggsr", sr);
        this.getTagType().fireMetadataChanged(this);
        this.checkAggregateShareRatio();
    }

    @Override
    public int getTagMaxAggregateShareRatioAction() {
        return this.max_aggregate_share_ratio_action;
    }

    @Override
    public void setTagMaxAggregateShareRatioAction(int action) {
        if (action == this.max_aggregate_share_ratio_action) {
            return;
        }
        this.max_aggregate_share_ratio_action = action;
        this.writeLongAttribute("rl.maxaggsr.a", action);
        this.getTagType().fireMetadataChanged(this);
        this.checkAggregateShareRatio();
    }

    @Override
    public boolean getTagMaxAggregateShareRatioHasPriority() {
        return this.max_aggregate_share_ratio_priority;
    }

    @Override
    public void setTagMaxAggregateShareRatioHasPriority(boolean priority) {
        if (priority == this.max_aggregate_share_ratio_priority) {
            return;
        }
        this.max_aggregate_share_ratio_priority = priority;
        this.writeBooleanAttribute("rl.maxaggsr.p", priority);
        this.getTagType().fireMetadataChanged(this);
        this.checkIndividualShareRatio();
        this.checkAggregateShareRatio();
    }

    @Override
    public boolean getFirstPrioritySeeding() {
        return this.fp_seeding;
    }

    @Override
    public void setFirstPrioritySeeding(boolean b) {
        if (b == this.fp_seeding) {
            return;
        }
        this.fp_seeding = b;
        this.writeBooleanAttribute("rl.fps", b);
        this.getTagType().fireMetadataChanged(this);
        this.checkFPSeeding();
    }

    @Override
    public boolean getNotFirstPrioritySeeding() {
        return this.not_fp_seeding;
    }

    @Override
    public void setNotFirstPrioritySeeding(boolean b) {
        if (b == this.not_fp_seeding) {
            return;
        }
        this.not_fp_seeding = b;
        this.writeBooleanAttribute("rl.nfps", b);
        this.getTagType().fireMetadataChanged(this);
        this.checkFPSeeding();
    }

    @Override
    public void setPreventDelete(boolean b) {
        super.setPreventDelete(b);
        if (this.prevent_delete != b) {
            this.prevent_delete = b;
            TaggableResolver resolver = this.getTagType().getResolver();
            if (this.prevent_delete && resolver != null) {
                resolver.addLifecycleControlListener(this);
            } else {
                resolver.removeLifecycleControlListener(this);
            }
        }
    }

    @Override
    public void canTaggableBeRemoved(Taggable taggable) throws Exception {
        if (this.prevent_delete && this.hasTaggable(taggable)) {
            throw new Exception("Download removal prevented by Tag '" + this.getTagName() + "'");
        }
    }

    @Override
    public void setNotifyMessageChannel(String channel2) {
        super.setNotifyMessageChannel(channel2);
        this.notification_pub = this.getNotifyMessageChannel();
    }

    private void updateStuff() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_rate_update > 2500L) {
            int new_up = 0;
            int new_down = 0;
            long new_agg_up = 0L;
            long new_agg_down = 0L;
            Set<DownloadManager> dms = this.getTaggedDownloads();
            if (dms.size() == 0) {
                new_up = -1;
                new_down = -1;
            } else {
                new_up = 0;
                new_down = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    new_up = (int)((long)new_up + (stats2.getDataSendRate() + stats2.getProtocolSendRate()));
                    new_down = (int)((long)new_down + (stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()));
                    long downloaded = stats2.getTotalGoodDataBytesReceived();
                    long uploaded = stats2.getTotalDataBytesSent();
                    if (downloaded > 0L) {
                        new_agg_down += downloaded;
                    }
                    if (uploaded <= 0L) continue;
                    new_agg_up += uploaded;
                }
            }
            this.upload_rate = new_up;
            this.download_rate = new_down;
            this.aggregate_sr = new_agg_down <= 0L ? 0 : (int)(1000L * new_agg_up / new_agg_down);
            this.last_rate_update = now;
        }
    }

    private void checkIndividualShareRatio() {
        if (this.max_share_ratio <= 0) {
            return;
        }
        if (this.max_share_ratio_action == 0) {
            return;
        }
        if (this.max_aggregate_share_ratio_priority && this.max_aggregate_share_ratio > 0) {
            this.updateStuff();
            if (this.aggregate_sr < this.max_aggregate_share_ratio) {
                return;
            }
        }
        Set<DownloadManager> dms = this.getTaggedDownloads();
        HashSet<DownloadManager> to_action = new HashSet<DownloadManager>();
        for (DownloadManager dm : dms) {
            int sr;
            int state;
            if (!dm.isDownloadComplete(false) || dm.isForceStart() || (state = dm.getState()) != 75 && state != 60 || (sr = dm.getStats().getShareRatio()) < this.max_share_ratio) continue;
            to_action.add(dm);
        }
        if (to_action.size() > 0) {
            int operation;
            switch (this.max_share_ratio_action) {
                case 1: {
                    operation = 2;
                    break;
                }
                case 2: {
                    operation = 1;
                    break;
                }
                case 3: {
                    operation = 16;
                    break;
                }
                case 4: {
                    operation = 32;
                    break;
                }
                case 5: {
                    operation = 64;
                    break;
                }
                default: {
                    Debug.out("Invalid share ratio action");
                    return;
                }
            }
            this.performOperation(operation, to_action.stream());
        }
    }

    private boolean isAggregateShareRatioMet() {
        if (this.max_aggregate_share_ratio == 0) {
            return true;
        }
        this.updateStuff();
        return this.aggregate_sr >= this.max_aggregate_share_ratio;
    }

    private void checkAggregateShareRatio() {
        if (this.max_aggregate_share_ratio > 0) {
            if (TorrentUtils.isTorrentDeleting() || TorrentUtils.getMillisecondsSinceLastTorrentDelete() < 10000L) {
                return;
            }
            this.updateStuff();
            if (this.aggregate_sr >= this.max_aggregate_share_ratio) {
                HashSet<DownloadManager> dms = new HashSet<DownloadManager>(this.getTaggedDownloads());
                Iterator it = dms.iterator();
                block0: while (it.hasNext()) {
                    int sr;
                    DownloadManager dm = (DownloadManager)it.next();
                    if (dm.isForceStart() || !dm.isDownloadComplete(false)) {
                        it.remove();
                        continue;
                    }
                    if (!this.max_aggregate_share_ratio_priority && this.max_share_ratio > 0 && (sr = dm.getStats().getShareRatio()) < this.max_share_ratio) {
                        it.remove();
                        continue;
                    }
                    List<Tag> all_tags = this.getTagType().getTagManager().getTagsForTaggable(dm);
                    for (Tag tag : all_tags) {
                        TagDownloadWithState other_tag;
                        if (tag == this || !(tag instanceof TagDownloadWithState) || (other_tag = (TagDownloadWithState)tag).isAggregateShareRatioMet()) continue;
                        it.remove();
                        continue block0;
                    }
                }
                this.performOperation(this.max_aggregate_share_ratio_action == 1 ? 2 : 1, dms.stream());
            } else {
                this.performOperation(this.max_aggregate_share_ratio_action == 1 ? 4 : 8);
            }
        }
    }

    private void checkFPSeeding() {
        if (this.fp_seeding || this.not_fp_seeding) {
            this.fp_or_not_seeding_ever = true;
        }
        if (!this.fp_or_not_seeding_ever) {
            return;
        }
        HashSet<DownloadManager> dms = new HashSet<DownloadManager>(this.getTaggedDownloads());
        for (DownloadManager dm : dms) {
            this.updateFPSeeding(dm, this.fp_seeding, this.not_fp_seeding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFPSeeding(DownloadManager dm, boolean fp_seed, boolean not_fp_seed) {
        Map<DownloadManager, String> map;
        if (fp_seed || not_fp_seed) {
            this.fp_or_not_seeding_ever = true;
        }
        Object object = FP_DL_KEY;
        synchronized (object) {
            map = (IdentityHashMap<DownloadManager, String>)dm.getUserData(FP_DL_KEY);
            if (fp_seed) {
                if (map == null) {
                    map = new IdentityHashMap<DownloadManager, String>();
                    dm.setUserData(FP_DL_KEY, map);
                    dm.getDownloadState().setTransientFlag(2L, true);
                }
                map.put(dm, "");
            } else if (map != null) {
                map.remove(dm);
                if (map.isEmpty()) {
                    dm.setUserData(FP_DL_KEY, null);
                    dm.getDownloadState().setTransientFlag(2L, false);
                }
            }
        }
        object = NOT_FP_DL_KEY;
        synchronized (object) {
            map = (Map)dm.getUserData(NOT_FP_DL_KEY);
            if (not_fp_seed) {
                if (map == null) {
                    map = new IdentityHashMap();
                    dm.setUserData(NOT_FP_DL_KEY, map);
                    dm.getDownloadState().setTransientFlag(4L, true);
                }
                map.put(dm, "");
            } else if (map != null) {
                map.remove(dm);
                if (map.isEmpty()) {
                    dm.setUserData(NOT_FP_DL_KEY, null);
                    dm.getDownloadState().setTransientFlag(4L, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkNotifyPublish() {
        String channel2 = this.notification_pub;
        if (channel2.isEmpty()) {
            if (this.notification_pub_channel == null) return;
            this.notification_pub_channel.destroy();
            this.notification_pub_channel = null;
            this.ncp_pub_list = null;
            return;
        }
        if (this.notification_pub_channel_key != null && this.notification_pub_channel != null && !this.notification_pub_channel.getNetAndKey().equals(this.notification_pub_channel_key)) {
            this.notification_pub_channel.destroy();
            this.notification_pub_channel = null;
            this.ncp_pub_list = null;
        }
        if (this.notification_pub_channel == null) {
            String[] bits = channel2.split(":", 2);
            String net = bits[0].startsWith("Public") ? "Public" : "I2P";
            String key = bits[1].trim();
            if (key.startsWith(Constants.APP_NAME)) {
                return;
            }
            this.notification_pub_channel = BuddyPluginUtils.getChat(net, key);
            if (this.notification_pub_channel == null) {
                return;
            }
            this.notification_pub_channel_key = channel2;
            this.npc_initialised_time = 0L;
            this.npc_chat_ready = false;
        }
        if (!this.npc_chat_ready) {
            long now = SystemTime.getMonotonousTime();
            if (this.npc_initialised_time == 0L) {
                if (!this.notification_pub_channel.isInitialised()) return;
                this.npc_initialised_time = now;
                return;
            }
            if (now - this.npc_initialised_time <= 60000L) return;
            if (this.notification_pub_channel.getIncomingSyncState() != 0) return;
            this.npc_chat_ready = true;
            return;
        }
        Set<DownloadManager> dms = this.getTaggedDownloads();
        String state_key = String.valueOf(this.getTagUID()) + ":" + this.notification_pub_channel.getDefaultNickname();
        LinkedList<NPCState> pub_list = this.ncp_pub_list;
        long mut = this.ncp_pub_list_mutate_index.get();
        if (pub_list == null || this.ncp_pub_list_mut != mut) {
            this.ncp_pub_list_mut = mut;
            ArrayList<NPCState> new_pub_list = new ArrayList<NPCState>(dms.size());
            for (DownloadManager dm : dms) {
                Long l_last_pub;
                String string = NPC_ATTRIBUTE_NAME;
                // MONITORENTER : "_tm::npc"
                Map state = dm.getDownloadState().getMapAttribute(NPC_ATTRIBUTE_NAME);
                long last_pub = state == null ? 0L : ((l_last_pub = (Long)state.get(state_key)) != null ? l_last_pub : 0L);
                new_pub_list.add(new NPCState(last_pub, dm));
                // MONITOREXIT : string
            }
            Collections.sort(new_pub_list, new Comparator<NPCState>(){

                @Override
                public int compare(NPCState o1, NPCState o2) {
                    long l1 = o1.last_pub;
                    long l2 = o2.last_pub;
                    if (l1 == l2) {
                        long a2;
                        DownloadManager dm1 = o1.dm;
                        DownloadManager dm2 = o2.dm;
                        long a1 = dm1.getDownloadState().getLongParameter("stats.download.added.time");
                        if (a1 == (a2 = dm2.getDownloadState().getLongParameter("stats.download.added.time"))) {
                            return 0;
                        }
                        if (a1 < a2) {
                            return 1;
                        }
                        return -1;
                    }
                    if (l1 < l2) {
                        return -1;
                    }
                    return 1;
                }
            });
            pub_list = new LinkedList(new_pub_list);
            this.ncp_pub_list = pub_list;
        }
        if (pub_list.isEmpty()) return;
        int num_to_publish = Math.min(1, pub_list.size());
        int num = 0;
        while (num < num_to_publish) {
            Object messages;
            boolean already_published;
            DownloadManager dm;
            block27: {
                NPCState next = pub_list.removeFirst();
                dm = next.dm;
                pub_list.addLast(new NPCState(SystemTime.getCurrentTime(), dm));
                already_published = false;
                int max_msg_to_check = 128;
                if (pub_list.size() <= max_msg_to_check) {
                    messages = this.notification_pub_channel.getMessages();
                    int normal_count = 0;
                    try {
                        TOTorrent torrent = next.dm.getTorrent();
                        if (torrent == null) {
                            already_published = true;
                            break block27;
                        }
                        String magnet = UrlUtils.getMagnetURI(torrent.getHash());
                        int i = messages.size() - 1;
                        while (i >= 0) {
                            BuddyPluginBeta.ChatMessage message = (BuddyPluginBeta.ChatMessage)messages.get(i);
                            if (message.getMessageType() == 1) {
                                ++normal_count;
                                String text = message.getMessage();
                                if (text.contains(magnet)) {
                                    already_published = true;
                                    break;
                                }
                                if (normal_count == max_msg_to_check) break;
                            }
                            --i;
                        }
                    }
                    catch (Throwable e) {
                        already_published = true;
                        Debug.out(e);
                    }
                }
            }
            if (!already_published) {
                try {
                    this.notification_pub_channel.sendMessage(PluginCoreUtils.wrap(dm));
                    messages = NPC_ATTRIBUTE_NAME;
                    // MONITORENTER : "_tm::npc"
                    Map<String, Long> state = dm.getDownloadState().getMapAttribute(NPC_ATTRIBUTE_NAME);
                    state = state == null ? new HashMap<String, Long>() : BEncoder.cloneMap(state);
                    state.put(state_key, SystemTime.getCurrentTime());
                    dm.getDownloadState().setMapAttribute(NPC_ATTRIBUTE_NAME, state);
                    // MONITOREXIT : messages
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            ++num;
        }
    }

    @Override
    protected void sync() {
        this.checkIndividualShareRatio();
        this.checkAggregateShareRatio();
        this.checkMaximumTaggables();
        this.checkFPSeeding();
        this.checkNotifyPublish();
        this.checkSort();
        super.sync();
    }

    @Override
    public int getRunStateCapabilities() {
        return this.run_states;
    }

    @Override
    public boolean hasRunStateCapability(int capability) {
        return (this.run_states & capability) != 0;
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops) {
        return this.getPerformableOperations(ops, t -> true);
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops, Predicate<Taggable> filter2) {
        boolean[] result = new boolean[ops.length];
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            if (!filter2.test(dm)) continue;
            int dm_state = dm.getState();
            int i = 0;
            while (i < ops.length) {
                if (!result[i]) {
                    int op = ops[i];
                    if ((op & 8) != 0) {
                        if (dm_state == 70 || dm_state == 100) {
                            result[i] = true;
                        } else if (dm.isForceStart()) {
                            result[i] = true;
                        }
                    }
                    if ((op & 0x80) != 0 && !dm.isForceStart()) {
                        result[i] = true;
                    }
                    if ((op & 1) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100) {
                        result[i] = true;
                    }
                    if ((op & 2) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100 && !dm.isPaused()) {
                        result[i] = true;
                    }
                    if ((op & 4) != 0 && dm.isPaused()) {
                        result[i] = true;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Taggable> performOperation(int op) {
        return this.performOperation(op, (Taggable t) -> true);
    }

    @Override
    public List<Taggable> performOperation(int op, Predicate<Taggable> filter2) {
        Set<DownloadManager> dms = this.getTaggedDownloads();
        return this.performOperation(op, dms.stream().filter(filter2));
    }

    private List<Taggable> performOperation(int op, Stream<DownloadManager> dms) {
        ArrayList<Taggable> affected = new ArrayList<Taggable>();
        dms.forEach(dm -> {
            int dm_state = dm.getState();
            if (op == 8) {
                if (dm_state == 70 || dm_state == 100) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(new AERunnable((DownloadManager)dm){
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.val$dm = downloadManager;
                        }

                        @Override
                        public void runSupport() {
                            this.val$dm.setStateQueued();
                        }
                    });
                } else if (dm.isForceStart()) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(() -> dm.setForceStart(false));
                }
            } else if (op == 128) {
                if (!dm.isForceStart()) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(new AERunnable((DownloadManager)dm){
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.val$dm = downloadManager;
                        }

                        @Override
                        public void runSupport() {
                            this.val$dm.setForceStart(true);
                        }
                    });
                }
            } else if (op == 1) {
                if (dm_state != 70 && dm_state != 65 && dm_state != 100) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(new AERunnable((DownloadManager)dm){
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.val$dm = downloadManager;
                        }

                        @Override
                        public void runSupport() {
                            this.val$dm.stopIt(70, false, false);
                            this.val$dm.setStopReason("Tag '" + TagDownloadWithState.this.getTagName() + "' stopped");
                            TagDownloadWithState.this.checkMaximumTaggables();
                        }
                    });
                }
            } else if (op == 2) {
                if (dm_state != 70 && dm_state != 65 && dm_state != 100) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(new AERunnable((DownloadManager)dm){
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.val$dm = downloadManager;
                        }

                        @Override
                        public void runSupport() {
                            this.val$dm.pause(true);
                            this.val$dm.setStopReason("Tag '" + TagDownloadWithState.this.getTagName() + "' paused");
                        }
                    });
                }
            } else if (op == 4) {
                if (dm.isPaused()) {
                    affected.add((Taggable)dm);
                    rs_async.dispatch(new AERunnable((DownloadManager)dm){
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.val$dm = downloadManager;
                        }

                        @Override
                        public void runSupport() {
                            this.val$dm.resume();
                        }
                    });
                }
            } else {
                affected.add((Taggable)dm);
                rs_async.dispatch(new AERunnable((DownloadManager)dm, op){
                    private final /* synthetic */ DownloadManager val$dm;
                    private final /* synthetic */ int val$op;
                    {
                        this.val$dm = downloadManager;
                        this.val$op = n;
                    }

                    @Override
                    public void runSupport() {
                        int dm_state = this.val$dm.getState();
                        if (dm_state != 70 && dm_state != 100) {
                            this.val$dm.stopIt(70, false, false);
                        }
                        try {
                            if (this.val$op == 16) {
                                Download download = PluginCoreUtils.wrap(this.val$dm);
                                if (download.canStubbify()) {
                                    TagDownloadWithState.this.removeTaggable(this.val$dm);
                                    download.stubbify();
                                }
                            } else if (this.val$op == 32) {
                                this.val$dm.getGlobalManager().removeDownloadManager(this.val$dm, false, false);
                            } else if (this.val$op == 64) {
                                boolean reallyDeleteData = !this.val$dm.getDownloadState().getFlag(64L);
                                this.val$dm.getGlobalManager().removeDownloadManager(this.val$dm, true, reallyDeleteData);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
        return affected;
    }

    @Override
    public int getSupportedActions() {
        if (this.getTagType().getTagType() == 3) {
            return 65534;
        }
        if (this.getTagType().getTagType() == 2) {
            return 544;
        }
        return 0;
    }

    protected void setSupportsTagTranscode(boolean sup) {
        this.supports_xcode = sup;
    }

    @Override
    public boolean supportsTagTranscode() {
        return this.supports_xcode;
    }

    @Override
    public String[] getTagTranscodeTarget() {
        String temp = this.readStringAttribute("xcode.to", null);
        if (temp == null) {
            return null;
        }
        String[] bits = temp.split("\n");
        if (bits.length != 2) {
            return null;
        }
        return bits;
    }

    @Override
    public void setTagTranscodeTarget(String uid, String name) {
        this.writeStringAttribute("xcode.to", uid == null ? null : String.valueOf(uid) + "\n" + name);
        this.getTagType().fireMetadataChanged(this);
        this.getManager().featureChanged(this, 8);
    }

    protected void setSupportsFileLocation(boolean sup) {
        this.supports_file_location = sup;
    }

    @Override
    public boolean supportsTagInitialSaveFolder() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagMoveOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagCopyOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagMoveOnRemove() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagMoveOnAssign() {
        return this.supports_file_location;
    }

    @Override
    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return this.getTagType().isTagTypeAuto() ? new TagFeatureProperties.TagProperty[]{} : this.tag_properties;
    }

    @Override
    public boolean[] isTagAuto() {
        TagFeatureProperties.TagProperty[] props;
        TagFeatureProperties.TagProperty[] tagPropertyArray = props = this.getSupportedProperties();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
            String name = prop.getName(false);
            if (!name.equals("tracker_templates")) {
                String[] vals;
                int type = prop.getType();
                if (type == 2) {
                    Boolean b = prop.getBoolean();
                    if (b != null && b.booleanValue()) {
                        return AUTO_BOTH;
                    }
                } else if (type == 3) {
                    Long l = prop.getLong();
                    if (l != null && l != Long.MIN_VALUE) {
                        return AUTO_BOTH;
                    }
                } else if (type == 1 && (vals = prop.getStringList()) != null && vals.length > 0) {
                    if (name.equals("constraint")) {
                        String options;
                        if (!prop.isEnabled()) {
                            return AUTO_NONE;
                        }
                        String constraint = vals[0];
                        if (constraint == null || constraint.trim().isEmpty()) {
                            return AUTO_NONE;
                        }
                        if (vals.length > 1 && (options = vals[1]) != null) {
                            if (options.contains("am=1;")) {
                                boolean[] blArray = new boolean[3];
                                blArray[0] = true;
                                return blArray;
                            }
                            if (options.contains("am=2;")) {
                                boolean[] blArray = new boolean[3];
                                blArray[1] = true;
                                return blArray;
                            }
                            if (options.contains("am=3;")) {
                                boolean[] blArray = new boolean[3];
                                blArray[2] = true;
                                return blArray;
                            }
                        }
                        return AUTO_BOTH;
                    }
                    return AUTO_BOTH;
                }
            }
            ++n2;
        }
        return AUTO_NONE;
    }

    @Override
    public int getMaximumTaggables() {
        if (this.getTagType().getTagType() != 3) {
            return -1;
        }
        return super.getMaximumTaggables();
    }

    @Override
    protected void checkMaximumTaggables() {
        int removal_strategy;
        if (this.getTagType().getTagType() != 3) {
            return;
        }
        int max = this.getMaximumTaggables();
        if (max <= 0) {
            return;
        }
        if (max == 999999) {
            max = 0;
        }
        if ((removal_strategy = this.getRemovalStrategy()) == 0) {
            return;
        }
        if (this.getTaggedCount() > max) {
            Set<DownloadManager> dms = this.getTaggedDownloads();
            ArrayList<DownloadManager> sorted_dms = new ArrayList<DownloadManager>(dms);
            final int order = this.getOrdering();
            Collections.sort(sorted_dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager dm1, DownloadManager dm2) {
                    long t2;
                    if (order == 0) {
                        long t22;
                        long t1 = dm1.getDownloadState().getLongParameter("stats.download.added.time");
                        if (t1 < (t22 = dm2.getDownloadState().getLongParameter("stats.download.added.time"))) {
                            return -1;
                        }
                        if (t1 > t22) {
                            return 1;
                        }
                        return dm1.getInternalName().compareTo(dm2.getInternalName());
                    }
                    long t1 = TagDownloadWithState.this.getTaggableAddedTime(dm1);
                    if (t1 < (t2 = TagDownloadWithState.this.getTaggableAddedTime(dm2))) {
                        return -1;
                    }
                    if (t1 > t2) {
                        return 1;
                    }
                    return dm1.getInternalName().compareTo(dm2.getInternalName());
                }
            });
            Iterator it = sorted_dms.iterator();
            while (it.hasNext() && sorted_dms.size() > max) {
                DownloadManager dm = (DownloadManager)it.next();
                if (dm.isPersistent()) {
                    it.remove();
                    try {
                        if (removal_strategy == 1) {
                            Download download = PluginCoreUtils.wrap(dm);
                            if (!download.canStubbify()) continue;
                            this.removeTaggable(dm);
                            download.stubbify();
                            continue;
                        }
                        if (removal_strategy == 2) {
                            dm.getGlobalManager().removeDownloadManager(dm, false, false);
                            continue;
                        }
                        if (removal_strategy == 3) {
                            boolean reallyDeleteData = !dm.getDownloadState().getFlag(64L);
                            dm.getGlobalManager().removeDownloadManager(dm, true, reallyDeleteData);
                            continue;
                        }
                        if (removal_strategy != 4) continue;
                        String old_tag = String.valueOf(this.getTagName(true)) + "_";
                        old_tag = Character.isUpperCase(old_tag.charAt(0)) ? String.valueOf(old_tag) + "Old" : String.valueOf(old_tag) + "old";
                        Tag ot = this.getTagType().getTag(old_tag, true);
                        if (ot == null) {
                            ot = this.getTagType().createTag(old_tag, true);
                        }
                        ot.addTaggable(dm);
                        this.removeTaggable(dm);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    continue;
                }
                Logger.log(new LogAlert(false, 1, "Non-persistent downloads (e.g. shares) can't be automatically deleted or archived. Maximum entries not enforced for Tag '" + this.getTagName(true) + "'"));
            }
        }
    }

    @Override
    public List<Tag> dependsOnTags() {
        return new ArrayList<Tag>(this.getManager().getDependsOnTags(this));
    }

    @Override
    public String getStatus() {
        String other;
        String result = "";
        String error = (String)this.getTransientProperty("Constraint Error");
        if (error != null) {
            result = String.valueOf(result) + "Error: " + error;
        }
        if ((other = this.getManager().getTagStatus(this)) != null) {
            result = String.valueOf(result) + (result.isEmpty() ? "" : "; ") + other;
        }
        return result;
    }

    @Override
    public void setAutoApplySortInterval(int secs) {
        super.setAutoApplySortInterval(secs);
        this.auto_sort_period = secs;
    }

    private void checkSort() {
        if (this.auto_sort_period == 0) {
            return;
        }
        long now = SystemTime.getMonotonousTime();
        if ((this.last_auto_sort == -1L || now - this.last_auto_sort >= (long)(this.auto_sort_period * 1000)) && this.applySortSupport()) {
            this.last_auto_sort = now;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean applySortSupport() {
        try {
            DownloadManager dm;
            int current_pos;
            Object[] entry;
            int dl_pos;
            boolean random;
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            ArrayList<DownloadManager> downloads = new ArrayList<DownloadManager>(this.getTaggedDownloads());
            if (downloads.isEmpty()) {
                return true;
            }
            Collections.sort(downloads, (d1, d2) -> Integer.compare(d1.getPosition(), d2.getPosition()));
            Long uid = this.getTagUID();
            ArrayList<Integer> download_positions_comp = new ArrayList<Integer>(downloads.size());
            ArrayList<Integer> download_positions_incomp = new ArrayList<Integer>(downloads.size());
            ArrayList<Object[]> tag_sort_comp = new ArrayList<Object[]>(downloads.size());
            ArrayList<Object[]> tag_sort_incomp = new ArrayList<Object[]>(downloads.size());
            String overall_options = null;
            for (DownloadManager download : downloads) {
                Object[] entry2;
                Map map = (Map)download.getDownloadState().getTransientAttribute("t_tagsort");
                if (map == null) {
                    return false;
                }
                Object[] objectArray = entry2 = (Object[])map.get(uid);
                if (entry2 == null) {
                    return false;
                }
                if (entry2.length > 2) {
                    String options = (String)entry2[2];
                    if (overall_options == null) {
                        overall_options = options;
                    } else {
                        if (options == null) {
                            return false;
                        }
                        if (!options.equals(overall_options)) {
                            return false;
                        }
                    }
                } else if (overall_options != null) {
                    return false;
                }
                int pos = download.getPosition();
                if (download.isDownloadComplete(false)) {
                    download_positions_comp.add(pos);
                    tag_sort_comp.add(new Object[]{download, entry2[1], pos, entry2});
                    continue;
                }
                download_positions_incomp.add(pos);
                tag_sort_incomp.add(new Object[]{download, entry2[1], pos, entry2});
            }
            Collections.sort(download_positions_comp);
            Collections.sort(download_positions_incomp);
            boolean bl = random = overall_options != null && overall_options.equals("random");
            if (random) {
                Collections.shuffle(tag_sort_comp);
                Collections.shuffle(tag_sort_incomp);
            } else {
                boolean reverse = overall_options != null && (overall_options.equals("r") || overall_options.equals("reverse"));
                Collections.sort(tag_sort_comp, (e1, e2) -> {
                    if (reverse) {
                        return Long.compare((Long)e2[1], (Long)e1[1]);
                    }
                    return Long.compare((Long)e1[1], (Long)e2[1]);
                });
                Collections.sort(tag_sort_incomp, (e1, e2) -> {
                    if (reverse) {
                        return Long.compare((Long)e2[1], (Long)e1[1]);
                    }
                    return Long.compare((Long)e1[1], (Long)e2[1]);
                });
            }
            ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(download_positions_comp.size());
            ArrayList<Integer> positions = new ArrayList<Integer>(download_positions_comp.size());
            int i = 0;
            while (i < download_positions_comp.size()) {
                dl_pos = (Integer)download_positions_comp.get(i);
                entry = (Object[])tag_sort_comp.get(i);
                current_pos = (Integer)entry[2];
                dm = (DownloadManager)entry[0];
                if (random) {
                    ((Object[])entry[3])[1] = (long)RandomUtils.nextInt(downloads.size());
                }
                if (current_pos != dl_pos) {
                    dms.add(dm);
                    positions.add(dl_pos);
                }
                ++i;
            }
            gm.moveTo(dms, positions);
            dms = new ArrayList(download_positions_incomp.size());
            positions = new ArrayList(download_positions_incomp.size());
            i = 0;
            while (i < download_positions_incomp.size()) {
                dl_pos = (Integer)download_positions_incomp.get(i);
                entry = (Object[])tag_sort_incomp.get(i);
                current_pos = (Integer)entry[2];
                dm = (DownloadManager)entry[0];
                if (random) {
                    ((Object[])entry[3])[1] = (long)RandomUtils.nextInt(downloads.size());
                }
                if (current_pos != dl_pos) {
                    dms.add(dm);
                    positions.add(dl_pos);
                }
                ++i;
            }
            gm.moveTo(dms, positions);
            return true;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    @Override
    public void applySort() {
        this.applySortSupport();
    }

    private class NPCState {
        final DownloadManager dm;
        final long last_pub;

        NPCState(long t, DownloadManager d) {
            this.last_pub = t;
            this.dm = d;
        }
    }
}

