/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerInitialisationAdapter;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagConstraint;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureListener;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRSSFeed;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableLifecycleHandler;
import com.biglybt.core.tag.TaggableLifecycleListener;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.tag.impl.TagDownloadWithState;
import com.biglybt.core.tag.impl.TagPropertyConstraintHandler;
import com.biglybt.core.tag.impl.TagPropertyTrackerHandler;
import com.biglybt.core.tag.impl.TagPropertyTrackerTemplateHandler;
import com.biglybt.core.tag.impl.TagPropertyUntaggedHandler;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagTypeDownloadInternal;
import com.biglybt.core.tag.impl.TagTypeDownloadManual;
import com.biglybt.core.tag.impl.TagTypeSwarmTag;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.tag.impl.TagWithState;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.TrackersUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.core.xml.util.XMLEscapeWriter;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadCompletionListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.utils.ScriptProvider;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.PluginUtils;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.rssgen.RSSGeneratorPlugin;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class TagManagerImpl
implements TagManager,
DownloadCompletionListener,
AEDiagnosticsEvidenceGenerator,
DataSourceResolver.DataSourceImporter {
    private static final String CONFIG_FILE = "tag.config";
    private static final int CU_TAG_CREATE = 1;
    private static final int CU_TAG_CHANGE = 2;
    private static final int CU_TAG_CONTENTS = 3;
    private static final int CU_TAG_REMOVE = 4;
    private static final boolean enabled = COConfigurationManager.getBooleanParameter("tagmanager.enable", true);
    private static TagManagerImpl singleton;
    private static Object KEY_TG_COLUMNS;
    final CopyOnWriteList<TagTypeBase> tag_types = new CopyOnWriteList();
    private final Map<Integer, TagType> tag_type_map = new HashMap<Integer, TagType>();
    private static final String RSS_PROVIDER = "tags";
    final Set<TagBase> rss_tags = new HashSet<TagBase>();
    final Set<DownloadManager> active_copy_on_complete = new IdentityHashSet<DownloadManager>();
    private final RSSGeneratorPlugin.Provider rss_generator = new RSSGeneratorPlugin.Provider(){

        @Override
        public boolean isEnabled() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
            int pos;
            URL url = request2.getAbsoluteURL();
            String path = url.getPath();
            String query = url.getQuery();
            if (query != null) {
                path = String.valueOf(path) + "?" + query;
            }
            if ((pos = path.indexOf(63)) != -1) {
                String args = path.substring(pos + 1);
                if ((path = path.substring(0, pos)).endsWith("GetTorrent")) {
                    String[] bits;
                    String[] stringArray = bits = args.split("&");
                    int n = bits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bit = stringArray[n2];
                        String[] temp = bit.split("=");
                        if (temp.length == 2 && temp[0].equals("hash")) {
                            try {
                                Download download = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(Base32.decode(temp[1]));
                                Torrent torrent = download.getTorrent();
                                torrent = torrent.getClone();
                                torrent = torrent.removeAdditionalProperties();
                                response.getOutputStream().write(torrent.writeToBEncodedData());
                                response.setContentType("application/x-bittorrent");
                                return true;
                            }
                            catch (Throwable download) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    response.setReplyStatus(404);
                    return true;
                }
                if (path.endsWith("GetThumbnail")) {
                    String[] bits;
                    String[] stringArray = bits = args.split("&");
                    int n = bits.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String bit = stringArray[n3];
                        String[] temp = bit.split("=");
                        if (temp.length == 2 && temp[0].equals("hash")) {
                            try {
                                Download download = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(Base32.decode(temp[1]));
                                DownloadManager core_download = PluginCoreUtils.unwrap(download);
                                TOTorrent torrent = core_download.getTorrent();
                                byte[] thumb = PlatformTorrentUtils.getContentThumbnail(torrent);
                                if (thumb != null) {
                                    response.getOutputStream().write(thumb);
                                    String thumb_type = PlatformTorrentUtils.getContentThumbnailType(torrent);
                                    if (thumb_type == null || thumb_type.length() == 0) {
                                        thumb_type = "image/jpeg";
                                    }
                                    response.setContentType(thumb_type);
                                    return true;
                                }
                            }
                            catch (Throwable download) {
                                // empty catch block
                            }
                        }
                        ++n3;
                    }
                    response.setReplyStatus(404);
                    return true;
                }
            }
            path = path.substring(TagManagerImpl.RSS_PROVIDER.length() + 1);
            XMLEscapeWriter pw = new XMLEscapeWriter(new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8")));
            pw.setEnabled(false);
            if (path.length() <= 1) {
                ArrayList<TagBase> tags;
                response.setContentType("text/html; charset=UTF-8");
                pw.println("<HTML><HEAD><TITLE>" + Constants.APP_NAME + " Tag Feeds</TITLE></HEAD><BODY>");
                TreeMap<String, String> lines = new TreeMap<String, String>();
                Set<TagBase> set = TagManagerImpl.this.rss_tags;
                synchronized (set) {
                    tags = new ArrayList<TagBase>(TagManagerImpl.this.rss_tags);
                }
                for (TagBase t : tags) {
                    if (!(t instanceof TagDownload) || !((TagFeatureRSSFeed)((Object)t)).isTagRSSFeedEnabled()) continue;
                    String name = t.getTagName(true);
                    String tag_url = "tags/" + t.getTagType().getTagType() + "-" + t.getTagID();
                    lines.put(name, "<LI><A href=\"" + tag_url + "\">" + name + "</A>&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + tag_url + "?format=html\">html</a></font></LI>");
                }
                for (String line : lines.values()) {
                    pw.println(line);
                }
                pw.println("</BODY></HTML>");
            } else {
                String tag_id = path.substring(1);
                String[] bits = tag_id.split("-");
                int tt_id = Integer.parseInt(bits[0]);
                int t_id = Integer.parseInt(bits[1]);
                TagDownload tag = null;
                Set<TagBase> tag_url = TagManagerImpl.this.rss_tags;
                synchronized (tag_url) {
                    for (TagBase t : TagManagerImpl.this.rss_tags) {
                        if (t.getTagType().getTagType() != tt_id || t.getTagID() != t_id || !(t instanceof TagDownload)) continue;
                        tag = (TagDownload)((Object)t);
                    }
                }
                if (tag == null) {
                    response.setReplyStatus(404);
                    return true;
                }
                boolean enable_low_noise = RSSGeneratorPlugin.getSingleton().isLowNoiseEnabled();
                Set<DownloadManager> dms = tag.getTaggedDownloads();
                ArrayList<Download> downloads = new ArrayList<Download>(dms.size());
                long dl_marker = 0L;
                for (DownloadManager dm : dms) {
                    DownloadManagerState state;
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null || (state = dm.getDownloadState()).getFlag(512L) || !enable_low_noise && state.getFlag(16L) || TorrentUtils.isReallyPrivate(torrent)) continue;
                    dl_marker += dm.getDownloadState().getLongParameter("stats.download.added.time");
                    downloads.add(PluginCoreUtils.wrap(dm));
                }
                if (url.toExternalForm().contains("format=html")) {
                    String host = (String)request2.getHeaders().get("host");
                    if (host != null) {
                        int c_pos = host.indexOf(58);
                        if (c_pos != -1) {
                            host = host.substring(0, c_pos);
                        }
                    } else {
                        host = "127.0.0.1";
                    }
                    response.setContentType("text/html; charset=UTF-8");
                    pw.println("<HTML><HEAD><TITLE>Tag: " + this.escape(tag.getTagName(true)) + "</TITLE></HEAD><BODY>");
                    PluginManager pm = CoreFactory.getSingleton().getPluginManager();
                    PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", true);
                    if (pi == null) {
                        pw.println("UPnP Media Server plugin not found");
                    } else {
                        int i = 0;
                        while (i < downloads.size()) {
                            DiskManagerFileInfo[] files;
                            Download download = (Download)downloads.get(i);
                            DiskManagerFileInfo[] diskManagerFileInfoArray = files = download.getDiskManagerFileInfo();
                            int n = files.length;
                            int n4 = 0;
                            while (n4 < n) {
                                DiskManagerFileInfo file = diskManagerFileInfoArray[n4];
                                File target_file = file.getFile(true);
                                if (target_file.exists()) {
                                    try {
                                        URL stream_url = new URL((String)pi.getIPC().invoke("getContentURL", new Object[]{file}));
                                        if (stream_url != null) {
                                            stream_url = UrlUtils.setHost(stream_url, host);
                                            String url_ext = stream_url.toExternalForm();
                                            pw.println("<p>");
                                            pw.println("<a href=\"" + url_ext + "\">" + this.escape(target_file.getName()) + "</a>");
                                            url_ext = String.valueOf(url_ext) + (url_ext.indexOf(63) == -1 ? "?" : "&");
                                            url_ext = String.valueOf(url_ext) + "action=download";
                                            pw.println("&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + url_ext + "\">save</a></font>");
                                        }
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++n4;
                            }
                            ++i;
                        }
                    }
                    pw.println("</BODY></HTML>");
                } else {
                    String config_key = "tag.rss.config." + tt_id + "." + t_id;
                    long old_marker = COConfigurationManager.getLongParameter(String.valueOf(config_key) + ".marker", 0L);
                    long last_modified = COConfigurationManager.getLongParameter(String.valueOf(config_key) + ".last_mod", 0L);
                    long now = SystemTime.getCurrentTime();
                    if (old_marker == dl_marker) {
                        if (last_modified == 0L) {
                            last_modified = now;
                        }
                    } else {
                        COConfigurationManager.setParameter(String.valueOf(config_key) + ".marker", dl_marker);
                        last_modified = now;
                    }
                    if (last_modified == now) {
                        COConfigurationManager.setParameter(String.valueOf(config_key) + ".last_mod", last_modified);
                    }
                    response.setContentType("application/xml; charset=UTF-8");
                    pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    pw.println("<rss version=\"2.0\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:vuze=\"http://www.vuze.com\">");
                    pw.println("<channel>");
                    pw.println("<title>" + this.escape(tag.getTagName(true)) + "</title>");
                    Collections.sort(downloads, new Comparator<Download>(){

                        @Override
                        public int compare(Download d1, Download d2) {
                            long added1 = this.getAddedTime(d1) / 1000L;
                            long added2 = this.getAddedTime(d2) / 1000L;
                            return (int)(added2 - added1);
                        }
                    });
                    pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
                    int i = 0;
                    while (i < downloads.size()) {
                        String dl_cat;
                        String host;
                        byte[] thumb;
                        String host2;
                        Download download = (Download)downloads.get(i);
                        DownloadManager core_download = PluginCoreUtils.unwrap(download);
                        Torrent torrent = download.getTorrent();
                        TOTorrent to_torrent = core_download.getTorrent();
                        byte[] hash = torrent.getHash();
                        String hash_str = Base32.encode(hash);
                        pw.println("<item>");
                        pw.println("<title>" + this.escape(download.getName()) + "</title>");
                        String desc = PlatformTorrentUtils.getContentDescription(to_torrent);
                        if (desc != null && desc.length() > 0) {
                            desc = desc.replaceAll("\r\n", "<br>");
                            desc = desc.replaceAll("\n", "<br>");
                            desc = desc.replaceAll("\t", "    ");
                            pw.println("<description>" + this.escape(desc) + "</description>");
                        }
                        pw.println("<guid>" + hash_str + "</guid>");
                        String magnet_uri = UrlUtils.getMagnetURI(download);
                        String obtained_from = TorrentUtils.getObtainedFrom(core_download.getTorrent());
                        String[] dl_nets = core_download.getDownloadState().getNetworks();
                        boolean added_fl = false;
                        if (obtained_from != null) {
                            try {
                                URL ou = new URL(obtained_from);
                                if (ou.getProtocol().toLowerCase(Locale.US).startsWith("http")) {
                                    String host3 = ou.getHost();
                                    String net = AENetworkClassifier.categoriseAddress(host3);
                                    boolean net_ok = false;
                                    if (dl_nets == null || dl_nets.length == 0) {
                                        net_ok = true;
                                    } else {
                                        String[] stringArray = dl_nets;
                                        int n = dl_nets.length;
                                        int n5 = 0;
                                        while (n5 < n) {
                                            String dl_net = stringArray[n5];
                                            if (dl_net == net) {
                                                net_ok = true;
                                                break;
                                            }
                                            ++n5;
                                        }
                                    }
                                    if (net_ok) {
                                        magnet_uri = String.valueOf(magnet_uri) + "&fl=" + UrlUtils.encode(ou.toExternalForm());
                                        added_fl = true;
                                    }
                                }
                            }
                            catch (Throwable ou) {
                                // empty catch block
                            }
                        }
                        if (!added_fl && (host2 = (String)request2.getHeaders().get("host")) != null) {
                            String local_fl = String.valueOf(url.getProtocol()) + "://" + host2 + "/" + TagManagerImpl.RSS_PROVIDER + "/GetTorrent?hash=" + Base32.encode(torrent.getHash());
                            magnet_uri = String.valueOf(magnet_uri) + "&fl=" + UrlUtils.encode(local_fl);
                        }
                        magnet_uri = this.escape(magnet_uri);
                        pw.println("<link>" + magnet_uri + "</link>");
                        long added = core_download.getDownloadState().getLongParameter("stats.download.added.time");
                        pw.println("<pubDate>" + TimeFormatter.getHTTPDate(added) + "</pubDate>");
                        pw.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                        pw.println("<vuze:assethash>" + hash_str + "</vuze:assethash>");
                        pw.println("<vuze:downloadurl>" + magnet_uri + "</vuze:downloadurl>");
                        DownloadScrapeResult scrape = download.getLastScrapeResult();
                        if (scrape != null && scrape.getResponseType() == 1) {
                            pw.println("<vuze:seeds>" + scrape.getSeedCount() + "</vuze:seeds>");
                            pw.println("<vuze:peers>" + scrape.getNonSeedCount() + "</vuze:peers>");
                        }
                        if ((thumb = PlatformTorrentUtils.getContentThumbnail(to_torrent)) != null && (host = (String)request2.getHeaders().get("host")) != null) {
                            String thumb_url = String.valueOf(url.getProtocol()) + "://" + host + "/" + TagManagerImpl.RSS_PROVIDER + "/GetThumbnail?hash=" + Base32.encode(torrent.getHash());
                            pw.println("<media:thumbnail url=\"" + thumb_url + "\"/>");
                        }
                        if ((dl_cat = download.getCategoryName()) != null && dl_cat.length() > 0 && !dl_cat.equalsIgnoreCase("Categories.uncategorized")) {
                            pw.println("<category>" + this.escape(dl_cat) + "</category>");
                        }
                        List<Tag> dl_tags = TagManagerFactory.getTagManager().getTagsForTaggable(core_download);
                        for (Tag dl_tag : dl_tags) {
                            boolean[] autos;
                            TagType tt = dl_tag.getTagType();
                            if (tt.isTagTypeAuto() || tt.getTagType() != 3 || (autos = dl_tag.isTagAuto())[0] || autos[1]) continue;
                            pw.println("<tag>" + this.escape(dl_tag.getTagName(true)) + "</tag>");
                        }
                        pw.println("</item>");
                        ++i;
                    }
                    pw.println("</channel>");
                    pw.println("</rss>");
                }
            }
            pw.flush();
            return true;
        }

        protected long getAddedTime(Download download) {
            DownloadManager core_download = PluginCoreUtils.unwrap(download);
            return core_download.getDownloadState().getLongParameter("stats.download.added.time");
        }

        protected String escape(String str) {
            return XUXmlWriter.escapeXML(str);
        }
    };
    final AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);
    final AsyncDispatcher move_on_assign_dispatcher = new AsyncDispatcher(5000);
    private final FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            new AEThread2("tag:fld"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    TagManagerImpl.this.writeConfig();
                }
            }.start();
        }
    }, 30000);
    private Map<String, Object> config;
    private WeakReference<Map<String, Object>> config_ref;
    private boolean config_dirty;
    private final List<Object[]> config_change_queue = new ArrayList<Object[]>();
    private final CopyOnWriteList<TagManagerListener> listeners = new CopyOnWriteList();
    private final CopyOnWriteList<Object[]> feature_listeners = new CopyOnWriteList();
    private final Map<Long, LifecycleHandlerImpl> lifecycle_handlers = new HashMap<Long, LifecycleHandlerImpl>();
    private TagPropertyTrackerHandler auto_tracker;
    private TagPropertyUntaggedHandler untagged_handler;
    private TagPropertyConstraintHandler constraint_handler;
    private boolean js_plugin_install_tried;
    private static final String TTP_TAGS_FOR_TAGGABLE_CACHE = "TagManagerImpl::tags_for_taggable_cache";

    static {
        KEY_TG_COLUMNS = new Object();
    }

    public static synchronized TagManagerImpl getSingleton() {
        if (singleton == null) {
            singleton = new TagManagerImpl();
            singleton.init();
        }
        return singleton;
    }

    private TagManagerImpl() {
        DataSourceResolver.registerExporter(this);
        AEDiagnostics.addWeakEvidenceGenerator(this);
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] files, int expected_types) {
                int i = 0;
                while (i < files.length) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    int j = 0;
                    while (j < comps.length) {
                        VuzeFileComponent comp2 = comps[j];
                        int type = comp2.getType();
                        if (type == 8192) {
                            Map map = comp2.getContent();
                            map = BDecoder.decodeStrings(map);
                            String tt_name = (String)map.get("name");
                            List tt_template = (List)map.get("template");
                            Map<String, List<List<String>>> m_t = TrackersUtil.getInstance().getMultiTrackers();
                            if (m_t.containsKey(tt_name)) {
                                Debug.out("Tracker template '" + tt_name + "' already exists, ignoring import");
                            } else {
                                TrackersUtil.getInstance().addMultiTracker(tt_name, tt_template);
                                comp2.setProcessed();
                            }
                        }
                        ++j;
                    }
                    ArrayList<Tag> imported_tags = new ArrayList<Tag>();
                    int j2 = 0;
                    while (j2 < comps.length) {
                        Tag tag;
                        VuzeFileComponent comp3 = comps[j2];
                        int type = comp3.getType();
                        if (type == 4096 && (tag = TagManagerImpl.this.importVuzeFile(comp3.getContent())) != null) {
                            comp3.setProcessed();
                            imported_tags.add(tag);
                        }
                        ++j2;
                    }
                    if (!imported_tags.isEmpty()) {
                        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                        if (imported_tags.size() < 5) {
                            for (Tag tag : imported_tags) {
                                String details = MessageText.getString("tag.import.ok.desc", new String[]{tag.getTagName(true)});
                                ui_manager.showMessageBox("tag.import.ok.title", "!" + details + "!", 1L);
                            }
                        } else {
                            String details = MessageText.getString("tag.imports.ok.desc", new String[]{String.valueOf(imported_tags.size())});
                            ui_manager.showMessageBox("tag.import.ok.title", "!" + details + "!", 1L);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    private void init() {
        if (!enabled) {
            return;
        }
        Core core = CoreFactory.getSingleton();
        this.auto_tracker = new TagPropertyTrackerHandler(core, this);
        this.untagged_handler = new TagPropertyUntaggedHandler(core, this);
        new TagPropertyTrackerTemplateHandler(core, this);
        this.constraint_handler = new TagPropertyConstraintHandler(core, this);
        core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void started(Core core) {
                core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getGlobalDownloadEventNotifier().addCompletionListener(TagManagerImpl.this);
            }

            @Override
            public void componentCreated(Core core, CoreComponent component) {
                if (component instanceof GlobalManager) {
                    TagManagerImpl.this.initializeSwarmTags();
                    GlobalManager global_manager = (GlobalManager)component;
                    global_manager.addDownloadManagerInitialisationAdapter(new DownloadManagerInitialisationAdapter(){

                        @Override
                        public int getActions() {
                            return 1;
                        }

                        @Override
                        public void initialised(DownloadManager manager, boolean for_seeding) {
                            com.biglybt.core.disk.DiskManagerFileInfo[] files;
                            com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = files = manager.getDiskManagerFileInfoSet().getFiles();
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String name;
                                com.biglybt.core.disk.DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                                if (file.getTorrentFile().getPathComponents().length == 1 && ((name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US)).equals("index.html") || name.equals("index.htm"))) {
                                    TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                                    String tag_name = "Websites";
                                    Tag tag = tt.getTag(tag_name, true);
                                    try {
                                        if (tag == null) {
                                            tag = tt.createTag(tag_name, true);
                                        }
                                        if (tag.hasTaggable(manager)) break;
                                        tag.addTaggable(manager);
                                        tag.setDescription(MessageText.getString("tag.website.desc"));
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                    break;
                                }
                                ++n2;
                            }
                        }
                    });
                    global_manager.addDownloadManagerInitialisationAdapter(new DownloadManagerInitialisationAdapter(){

                        @Override
                        public int getActions() {
                            return 2;
                        }

                        @Override
                        public void initialised(DownloadManager manager, boolean for_seeding) {
                            TagFeatureFileLocation tag;
                            if (for_seeding) {
                                return;
                            }
                            List<Tag> auto_tags = TagManagerImpl.this.auto_tracker.getTagsForDownload(manager);
                            HashSet<Tag> tags = new HashSet<Tag>(TagManagerImpl.this.getTagsForTaggable(3, (Taggable)manager));
                            tags.addAll(auto_tags);
                            if (tags.size() == 0) {
                                tags.addAll(TagManagerImpl.this.untagged_handler.getUntaggedTags());
                            }
                            if ((tag = TagUtils.selectInitialDownloadLocation(tags)) != null) {
                                File old_torrent_file;
                                File old_loc;
                                long options = tag.getTagInitialSaveOptions();
                                boolean set_data = (options & 1L) != 0L;
                                boolean set_torrent = (options & 2L) != 0L;
                                File new_loc = tag.getTagInitialSaveFolder();
                                if (set_data && !new_loc.equals(old_loc = manager.getSaveLocation())) {
                                    if (old_loc.isDirectory()) {
                                        TorrentUtils.recursiveEmptyDirDelete(old_loc, false);
                                    }
                                    manager.setTorrentSaveDir(FileUtil.newFile(new_loc.getAbsolutePath(), new String[0]), false);
                                }
                                if (set_torrent && (old_torrent_file = FileUtil.newFile(manager.getTorrentFileName(), new String[0])).exists()) {
                                    try {
                                        manager.setTorrentFile(new_loc, old_torrent_file.getName());
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        }
                    });
                }
            }

            @Override
            public void stopped(Core core) {
                TagManagerImpl.this.destroy();
            }
        });
        SimpleTimer.addPeriodicEvent("TM:Sync", 30000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                for (TagType tagType : TagManagerImpl.this.tag_types) {
                    ((TagTypeBase)tagType).sync();
                }
                TagManagerImpl.this.auto_tracker.sync();
            }
        });
    }

    @Override
    public void setProcessingEnabled(boolean enabled) {
        if (this.constraint_handler != null) {
            this.constraint_handler.setProcessingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Download d) {
        final DownloadManager manager = PluginCoreUtils.unwrap(d);
        List<Tag> tags = this.getTagsForTaggable(manager);
        ArrayList<Tag> cc_tags = new ArrayList<Tag>();
        for (Tag tag : tags) {
            File save_loc;
            TagFeatureFileLocation fl;
            if (!tag.getTagType().hasTagTypeFeature(16L) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagCopyOnComplete() || (save_loc = fl.getTagCopyOnCompleteFolder()) == null) continue;
            cc_tags.add(tag);
        }
        if (cc_tags.size() > 0) {
            File old_file;
            File old_loc;
            boolean copy_torrent;
            if (cc_tags.size() > 1) {
                Collections.sort(cc_tags, new Comparator<Tag>(){

                    @Override
                    public int compare(Tag o1, Tag o2) {
                        return o1.getTagID() - o2.getTagID();
                    }
                });
            }
            TagFeatureFileLocation fl = (TagFeatureFileLocation)cc_tags.get(0);
            final File new_loc = fl.getTagCopyOnCompleteFolder();
            long options = fl.getTagCopyOnCompleteOptions();
            boolean copy_data = (options & 1L) != 0L;
            boolean bl = copy_torrent = (options & 2L) != 0L;
            if (copy_data && !new_loc.equals(old_loc = manager.getSaveLocation())) {
                boolean do_it;
                Set<DownloadManager> set = this.active_copy_on_complete;
                synchronized (set) {
                    if (this.active_copy_on_complete.contains(manager)) {
                        do_it = false;
                    } else {
                        this.active_copy_on_complete.add(manager);
                        do_it = true;
                    }
                }
                if (do_it) {
                    new AEThread2("tm:copy"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block30: {
                                try {
                                    try {
                                        long stopped_and_incomplete_start = 0L;
                                        long looks_good_start = 0L;
                                        while (true) {
                                            long now;
                                            if (manager.isDestroyed()) {
                                                throw new Exception("Download has been removed");
                                            }
                                            DiskManager dm = manager.getDiskManager();
                                            if (dm == null) {
                                                looks_good_start = 0L;
                                                if (manager.getAssumedComplete()) break;
                                                now = SystemTime.getMonotonousTime();
                                                if (stopped_and_incomplete_start == 0L) {
                                                    stopped_and_incomplete_start = now;
                                                } else if (now - stopped_and_incomplete_start > 30000L) {
                                                    throw new Exception("Download is stopped and incomplete");
                                                }
                                            } else {
                                                stopped_and_incomplete_start = 0L;
                                                if (manager.getAssumedComplete()) {
                                                    if (dm.getMoveProgress() == null && dm.getCompleteRecheckStatus() == -1) {
                                                        now = SystemTime.getMonotonousTime();
                                                        if (looks_good_start == 0L) {
                                                            looks_good_start = now;
                                                        } else if (now - looks_good_start > 5000L) {
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    looks_good_start = 0L;
                                                }
                                            }
                                            Thread.sleep(1000L);
                                        }
                                        try {
                                            FileUtil.runAsTask(7, new CoreOperationTask(){
                                                private CoreOperationTask.ProgressCallback cb = new CoreOperationTask.ProgressCallbackAdapter();

                                                @Override
                                                public String getName() {
                                                    return manager.getDisplayName();
                                                }

                                                @Override
                                                public DownloadManager getDownload() {
                                                    return manager;
                                                }

                                                @Override
                                                public String[] getAffectedFileSystems() {
                                                    return FileUtil.getFileStoreNames(manager.getAbsoluteSaveLocation(), new_loc);
                                                }

                                                @Override
                                                public boolean runOperation(CoreOperation operation) {
                                                    try {
                                                        manager.copyDataFiles(new_loc, this.cb);
                                                    }
                                                    catch (Throwable e) {
                                                        throw new RuntimeException(e);
                                                    }
                                                    return true;
                                                }

                                                @Override
                                                public CoreOperationTask.ProgressCallback getProgressCallback() {
                                                    return this.cb;
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            Throwable f = e.getCause();
                                            if (f instanceof DownloadManagerException) {
                                                throw (DownloadManagerException)f;
                                            }
                                            throw new DownloadManagerException("Copy failed", e);
                                        }
                                        Logger.logTextResource(new LogAlert((Object)manager, true, 0, "alert.copy.on.comp.done"), new String[]{manager.getDisplayName(), new_loc.toString()});
                                    }
                                    catch (Throwable e) {
                                        Logger.logTextResource(new LogAlert((Object)manager, true, 3, "alert.copy.on.comp.fail"), new String[]{manager.getDisplayName(), new_loc.toString(), Debug.getNestedExceptionMessage(e)});
                                        Set<DownloadManager> set = TagManagerImpl.this.active_copy_on_complete;
                                        synchronized (set) {
                                            TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                            break block30;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Set<DownloadManager> set = TagManagerImpl.this.active_copy_on_complete;
                                    synchronized (set) {
                                        TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                    }
                                    throw throwable;
                                }
                                Set<DownloadManager> set = TagManagerImpl.this.active_copy_on_complete;
                                synchronized (set) {
                                    TagManagerImpl.this.active_copy_on_complete.remove(manager);
                                }
                            }
                        }
                    }.start();
                }
            }
            if (copy_torrent && (old_file = FileUtil.newFile(manager.getTorrentFileName(), new String[0])).exists()) {
                File new_file = FileUtil.newFile(new_loc, old_file.getName());
                FileUtil.copyFile(old_file, new_file);
            }
        }
    }

    protected Object evalScript(Tag tag, String script, List<DownloadManager> dms, String intent_key) {
        String start;
        String script_type = "";
        if ((script = script.trim()).length() >= 10 && ((start = script.substring(0, 10).toLowerCase(Locale.US)).startsWith("javascript") || start.startsWith("plugin"))) {
            int p1 = script.indexOf(40);
            int p2 = script.lastIndexOf(41);
            if (p1 != -1 && p2 != -1) {
                if ((script = script.substring(p1 + 1, p2).trim()).startsWith("\"") && script.endsWith("\"")) {
                    script = script.substring(1, script.length() - 1);
                }
                script = script.replaceAll("\\\\\"", "\"");
                String string = script_type = start.startsWith("javascript") ? "javascript" : "plugin";
            }
        }
        if (script_type == "") {
            String error = "Unrecognised script type: " + script;
            Debug.out(error);
            return new Exception(error);
        }
        boolean provider_found = false;
        List<ScriptProvider> providers = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getScriptProviders();
        for (ScriptProvider p : providers) {
            if (p.getScriptType() != script_type) continue;
            provider_found = true;
            if (dms.size() > 1 && p.canEvalBatch(script)) {
                HashMap<String, Object> bindings = new HashMap<String, Object>();
                ArrayList<String> intents = new ArrayList<String>();
                ArrayList<Download> plugin_dms = new ArrayList<Download>();
                for (DownloadManager dm : dms) {
                    Download plugin_dm = PluginCoreUtils.wrap(dm);
                    if (plugin_dm == null) continue;
                    String dm_name = dm.getDisplayName();
                    if (dm_name.length() > 32) {
                        dm_name = String.valueOf(dm_name.substring(0, 29)) + "...";
                    }
                    String intent = String.valueOf(intent_key) + "(\"" + tag.getTagName() + "\",\"" + dm_name + "\")";
                    intents.add(intent);
                    plugin_dms.add(plugin_dm);
                }
                if (intents.isEmpty()) {
                    return null;
                }
                bindings.put("intents", intents);
                bindings.put("downloads", plugin_dms);
                bindings.put("tag", tag);
                try {
                    Object result = p.eval(script, bindings);
                    return result;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    return e;
                }
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (DownloadManager dm : dms) {
                Download plugin_dm = PluginCoreUtils.wrap(dm);
                if (plugin_dm == null) continue;
                HashMap<String, Object> bindings = new HashMap<String, Object>();
                String dm_name = dm.getDisplayName();
                if (dm_name.length() > 32) {
                    dm_name = String.valueOf(dm_name.substring(0, 29)) + "...";
                }
                String intent = String.valueOf(intent_key) + "(\"" + tag.getTagName() + "\",\"" + dm_name + "\")";
                bindings.put("intent", intent);
                bindings.put("download", plugin_dm);
                bindings.put("tag", tag);
                try {
                    Object result = p.eval(script, bindings);
                    results.add(result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    results.add(e);
                }
            }
            if (results.size() == 1 && dms.size() == 1) {
                return results.get(0);
            }
            return results;
        }
        if (script_type == "javascript" && !provider_found && !this.js_plugin_install_tried) {
            this.js_plugin_install_tried = true;
            PluginUtils.installJavaScriptPlugin();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTags(TagTypeWithState tt_with_state) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map<String, Object> config = this.getConfig();
            Map tt = (Map)config.get(String.valueOf(tt_with_state.getTagType()));
            if (tt != null) {
                for (Map.Entry entry : tt.entrySet()) {
                    String key = (String)entry.getKey();
                    try {
                        if (!Character.isDigit(key.charAt(0))) continue;
                        int tag_id = Integer.parseInt(key);
                        Map m = (Map)entry.getValue();
                        tags.add(tt_with_state.createTag(tag_id, m));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        for (Tag tag : tags) {
            tt_with_state.addTag(tag);
        }
    }

    private void initializeSwarmTags() {
        TagTypeSwarmTag stt = new TagTypeSwarmTag();
        this.loadTags(stt);
    }

    private void resolverInitialized(TaggableResolver resolver) {
        TagTypeDownloadManual ttdm = new TagTypeDownloadManual(resolver);
        this.loadTags(ttdm);
        TagTypeDownloadInternal ttdi = new TagTypeDownloadInternal(resolver);
    }

    private void removeTaggable(TaggableResolver resolver, Taggable taggable) {
        for (TagType tagType : this.tag_types) {
            TagTypeBase ttb = (TagTypeBase)tagType;
            ttb.removeTaggable(resolver, taggable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTagType(TagTypeBase tag_type) {
        if (!enabled) {
            Debug.out("Not enabled");
            return;
        }
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            if (this.tag_type_map.put(tag_type.getTagType(), tag_type) != null) {
                Debug.out("Duplicate tag type!");
            }
        }
        this.tag_types.add(tag_type);
        for (TagManagerListener l : this.listeners) {
            try {
                l.tagTypeAdded(this, tag_type);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagType getTagType(int tag_type) {
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            return this.tag_type_map.get(tag_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTagType(TagTypeBase tag_type) {
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            this.tag_type_map.remove(tag_type.getTagType());
        }
        this.tag_types.remove(tag_type);
        for (TagManagerListener l : this.listeners) {
            try {
                l.tagTypeRemoved(this, tag_type);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.removeConfig(tag_type);
    }

    @Override
    public List<TagType> getTagTypes() {
        return this.tag_types.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taggableAdded(TagType tag_type, Tag tag, Taggable tagged) {
        tagged.updateTagMutationCount();
        int tt = tag_type.getTagType();
        if (tt == 3 && tagged instanceof DownloadManager) {
            TOTorrent torrent;
            DownloadManager dm;
            TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
            if (fl.supportsTagInitialSaveFolder()) {
                try {
                    File save_loc = fl.getTagInitialSaveFolder();
                    if (save_loc != null && (dm = (DownloadManager)tagged).getState() == 70 && (torrent = dm.getTorrent()) != null && dm.getGlobalManager().getDownloadManager(torrent.getHashWrapper()) != null) {
                        File old_torrent_file;
                        File existing_save_loc;
                        boolean set_torrent;
                        long options = fl.getTagInitialSaveOptions();
                        boolean set_data = (options & 1L) != 0L;
                        boolean bl = set_torrent = (options & 2L) != 0L;
                        if (set_data && !(existing_save_loc = dm.getSaveLocation()).equals(save_loc) && !existing_save_loc.exists()) {
                            dm.setTorrentSaveDir(FileUtil.newFile(save_loc.getAbsolutePath(), new String[0]), false);
                        }
                        if (set_torrent && (old_torrent_file = FileUtil.newFile(dm.getTorrentFileName(), new String[0])).exists()) {
                            try {
                                dm.setTorrentFile(save_loc, old_torrent_file.getName());
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (fl.supportsTagMoveOnAssign()) {
                try {
                    File ass_loc = fl.getTagMoveOnAssignFolder();
                    if (ass_loc != null && (torrent = (dm = (DownloadManager)tagged).getTorrent()) != null && dm.getGlobalManager().getDownloadManager(torrent.getHashWrapper()) != null) {
                        this.move_on_assign_dispatcher.dispatch(AERunnable.create(() -> this.moveOnAssign(dm, ass_loc, fl.getTagMoveOnAssignOptions())));
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        if (tt == 3) {
            Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
            synchronized (map) {
                long type = tagged.getTaggableType();
                LifecycleHandlerImpl handler = this.lifecycle_handlers.get(type);
                if (handler == null) {
                    handler = new LifecycleHandlerImpl();
                    this.lifecycle_handlers.put(type, handler);
                }
                handler.taggableTagged(tag_type, tag, tagged);
            }
        }
    }

    private void moveOnAssign(DownloadManager dm, File location, long options) {
        try {
            File old_torrent_file;
            boolean set_torrent;
            boolean set_data = (options & 1L) != 0L;
            boolean bl = set_torrent = (options & 2L) != 0L;
            if (set_data) {
                File existing_save_loc = dm.getSaveLocation();
                if (existing_save_loc.isFile()) {
                    existing_save_loc = existing_save_loc.getParentFile();
                }
                if (!existing_save_loc.equals(location)) {
                    dm.moveDataFilesLive(location);
                }
            }
            if (set_torrent && (old_torrent_file = FileUtil.newFile(dm.getTorrentFileName(), new String[0])).exists()) {
                try {
                    dm.setTorrentFile(location, old_torrent_file.getName());
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taggableRemoved(TagType tag_type, Tag tag, Taggable tagged) {
        tagged.updateTagMutationCount();
        int tt = tag_type.getTagType();
        if (tt == 3) {
            Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
            synchronized (map) {
                long type = tagged.getTaggableType();
                LifecycleHandlerImpl handler = this.lifecycle_handlers.get(type);
                if (handler == null) {
                    handler = new LifecycleHandlerImpl();
                    this.lifecycle_handlers.put(type, handler);
                }
                handler.taggableUntagged(tag_type, tag, tagged);
            }
        }
    }

    @Override
    public List<Tag> getTagsForTaggable(Taggable taggable) {
        int mut = TagTypeBase.getTagAndTaggableMut();
        Object[] cache = (Object[])taggable.getTaggableTransientProperty(TTP_TAGS_FOR_TAGGABLE_CACHE);
        if (cache != null && (Integer)cache[0] == mut) {
            return (List)cache[1];
        }
        List<Tag> result = null;
        for (TagType tagType : this.tag_types) {
            List<Tag> tags = tagType.getTagsForTaggable(taggable);
            if (tags.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(tags);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        taggable.setTaggableTransientProperty(TTP_TAGS_FOR_TAGGABLE_CACHE, new Object[]{mut, result});
        return result;
    }

    @Override
    public List<Tag> getTagsForTaggable(int tag_type, Taggable taggable) {
        for (TagType tagType : this.tag_types) {
            if (tagType.getTagType() != tag_type) continue;
            return tagType.getTagsForTaggable(taggable);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Tag> getTagsForTaggable(int[] tts, Taggable taggable) {
        ArrayList<Tag> result = null;
        int[] nArray = tts;
        int n = tts.length;
        int n2 = 0;
        while (n2 < n) {
            List<Tag> temp;
            int tt = nArray[n2];
            TagType tag_type = this.getTagType(tt);
            if (tag_type != null && !(temp = tag_type.getTagsForTaggable(taggable)).isEmpty()) {
                if (result == null) {
                    result = new ArrayList<Tag>();
                }
                result.addAll(temp);
            }
            ++n2;
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<Tag> getTagsByName(String name, boolean is_localized) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (TagType tagType : this.tag_types) {
            Tag t = tagType.getTag(name, is_localized);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag lookupTagByUID(long tag_uid) {
        TagType tt;
        int tag_type_id = (int)(tag_uid >> 32 & 0xFFFFFFFFL);
        Map<Integer, TagType> map = this.tag_type_map;
        synchronized (map) {
            tt = this.tag_type_map.get(tag_type_id);
        }
        if (tt != null) {
            int tag_id = (int)(tag_uid & 0xFFFFFFFFL);
            return tt.getTag(tag_id);
        }
        return null;
    }

    @Override
    public List<Tag> lookupTagsByName(String tag_name) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (TagType tagType : this.tag_types) {
            Tag tag = tagType.getTag(tag_name, true);
            if (tag == null) continue;
            result.add(tag);
        }
        return result;
    }

    public Object importDataSource(Map map) {
        long uid = (Long)map.get("uid");
        return this.lookupTagByUID(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggableLifecycleHandler registerTaggableResolver(TaggableResolver resolver) {
        LifecycleHandlerImpl handler;
        if (!enabled) {
            return new TaggableLifecycleHandler(){

                @Override
                public void initialized(List<Taggable> initial_taggables) {
                }

                @Override
                public void taggableCreated(Taggable taggable) {
                }

                @Override
                public void taggableDestroyed(Taggable taggable) {
                }
            };
        }
        long type = resolver.getResolverTaggableType();
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            handler = this.lifecycle_handlers.get(type);
            if (handler == null) {
                handler = new LifecycleHandlerImpl();
                this.lifecycle_handlers.put(type, handler);
            }
            handler.setResolver(resolver);
        }
        return handler;
    }

    @Override
    public void setTagPublicDefault(boolean pub) {
        COConfigurationManager.setParameter("tag.manager.pub.default", pub);
    }

    @Override
    public boolean getTagPublicDefault() {
        return COConfigurationManager.getBooleanParameter("tag.manager.pub.default", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tagGroupCreated(TagTypeBase tag_type, final TagTypeBase.TagGroupImpl group, TagTypeBase.TagGroupImpl old_group) {
        Map tg_conf;
        Map<String, Object> conf = this.getConf(tag_type, false);
        if (conf != null && (tg_conf = (Map)conf.get(group.getGroupID())) != null) {
            group.importState(tg_conf);
        }
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
        UIManager ui_manager = pi.getUIManager();
        TableManager tm = ui_manager.getTableManager();
        List old_cols = null;
        if (old_group != null) {
            String old_col_id_text = "tag.group.col." + old_group.getGroupID();
            String old_col_id_icons = "tag.group.col.icons." + old_group.getGroupID();
            tm.unregisterColumn(Download.class, old_col_id_text);
            tm.unregisterColumn(Download.class, old_col_id_icons);
            Object object = KEY_TG_COLUMNS;
            synchronized (object) {
                old_cols = (List)old_group.getUserData(KEY_TG_COLUMNS);
            }
            if (old_cols != null) {
                for (TableColumn tc : old_cols) {
                    tc.remove();
                }
            }
        }
        Properties props = new Properties();
        String col_id_text = "tag.group.col." + group.getGroupID();
        String col_id_icons = "tag.group.col.icons." + group.getGroupID();
        props.put("TableColumn.header." + col_id_text, group.getName());
        props.put("TableColumn.header." + col_id_text + ".info", MessageText.getString("label.tags"));
        props.put("TableColumn.header." + col_id_icons, group.getName());
        props.put("TableColumn.header." + col_id_icons + ".info", MessageText.getString("TableColumn.header.tag_icons"));
        pi.getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(props);
        tm.registerColumn(Download.class, col_id_text, new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableColumnCreated(TableColumn column) {
                Object object = KEY_TG_COLUMNS;
                synchronized (object) {
                    ArrayList<TableColumn> cols = (ArrayList<TableColumn>)group.getUserData(KEY_TG_COLUMNS);
                    if (cols == null) {
                        cols = new ArrayList<TableColumn>();
                        group.setUserData(KEY_TG_COLUMNS, cols);
                    }
                    cols.add(column);
                }
                try {
                    Class<?> cla = Class.forName("com.biglybt.ui.swt.columns.tag.ColumnTagGroupTags");
                    cla.getConstructor(TableColumn.class, TagGroup.class).newInstance(column, group);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        tm.registerColumn(Download.class, col_id_icons, new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableColumnCreated(TableColumn column) {
                Object object = KEY_TG_COLUMNS;
                synchronized (object) {
                    ArrayList<TableColumn> cols = (ArrayList<TableColumn>)group.getUserData(KEY_TG_COLUMNS);
                    if (cols == null) {
                        cols = new ArrayList<TableColumn>();
                        group.setUserData(KEY_TG_COLUMNS, cols);
                    }
                    cols.add(column);
                }
                try {
                    Class<?> cla = Class.forName("com.biglybt.ui.swt.columns.tag.ColumnTagGroupIcons");
                    cla.getConstructor(TableColumn.class, TagGroup.class).newInstance(column, group);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
    }

    protected void tagGroupUpdated(TagTypeBase tag_type, TagTypeBase.TagGroupImpl group) {
        Map<String, Object> conf = this.getConf(tag_type, true);
        String id = group.getGroupID();
        Map<String, Object> state = group.exportState();
        if (state.isEmpty()) {
            conf.remove(id);
        } else {
            conf.put(id, state);
        }
        this.setDirty();
    }

    protected void tagGroupDeleted(TagTypeBase tag_type, TagTypeBase.TagGroupImpl group) {
        String id;
        Map<String, Object> conf = this.getConf(tag_type, true);
        if (conf.remove(id = group.getGroupID()) != null) {
            this.setDirty();
        }
    }

    protected void tagGroupRenamed(TagTypeBase tag_type, TagTypeBase.TagGroupImpl old_group, TagTypeBase.TagGroupImpl new_group) {
        this.tagGroupDeleted(tag_type, old_group);
        this.tagGroupCreated(tag_type, new_group, old_group);
        this.tagGroupUpdated(tag_type, new_group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRSSFeeds(TagBase tag, boolean enable) {
        Set<TagBase> set = this.rss_tags;
        synchronized (set) {
            if (enable) {
                if (this.rss_tags.contains(tag)) {
                    return;
                }
                this.rss_tags.add(tag);
                if (this.rss_tags.size() > 1) {
                    return;
                }
                RSSGeneratorPlugin.registerProvider(RSS_PROVIDER, this.rss_generator);
            } else {
                this.rss_tags.remove(tag);
                if (this.rss_tags.size() == 0) {
                    RSSGeneratorPlugin.unregisterProvider(RSS_PROVIDER);
                }
            }
        }
    }

    protected String getTagStatus(Tag tag) {
        if (this.constraint_handler != null) {
            return this.constraint_handler.getTagStatus(tag);
        }
        return null;
    }

    protected Set<Tag> getDependsOnTags(Tag tag) {
        if (this.constraint_handler != null) {
            return this.constraint_handler.getDependsOnTags(tag);
        }
        return Collections.emptySet();
    }

    @Override
    public void addTagManagerListener(TagManagerListener listener, boolean fire_for_existing) {
        this.listeners.add(listener);
        if (fire_for_existing) {
            for (TagType tagType : this.tag_types) {
                listener.tagTypeAdded(this, tagType);
            }
        }
    }

    @Override
    public void removeTagManagerListener(TagManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addTagFeatureListener(int features, TagFeatureListener listener) {
        this.feature_listeners.add(new Object[]{features, listener});
    }

    @Override
    public void removeTagFeatureListener(TagFeatureListener listener) {
        for (Object[] entry : this.feature_listeners) {
            if (entry[1] != listener) continue;
            this.feature_listeners.remove(entry);
        }
    }

    protected void featureChanged(Tag tag, int feature) {
        for (Object[] entry : this.feature_listeners) {
            if (((Integer)entry[0] & feature) == 0) continue;
            try {
                ((TagFeatureListener)entry[1]).tagFeatureChanged(tag, feature);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaggableResolver getResolver(long taggable_type) {
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            LifecycleHandlerImpl handler = this.lifecycle_handlers.get(taggable_type);
            if (handler != null) {
                return handler.resolver;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaggableLifecycleListener(long taggable_type, TaggableLifecycleListener listener) {
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            LifecycleHandlerImpl handler = this.lifecycle_handlers.get(taggable_type);
            if (handler == null) {
                handler = new LifecycleHandlerImpl();
                this.lifecycle_handlers.put(taggable_type, handler);
            }
            handler.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaggableLifecycleListener(long taggable_type, TaggableLifecycleListener listener) {
        Map<Long, LifecycleHandlerImpl> map = this.lifecycle_handlers;
        synchronized (map) {
            LifecycleHandlerImpl handler = this.lifecycle_handlers.get(taggable_type);
            if (handler != null) {
                handler.removeListener(listener);
            }
        }
    }

    protected void tagCreated(TagWithState tag) {
        this.addConfigUpdate(1, tag);
    }

    protected void tagChanged(TagWithState tag) {
        this.addConfigUpdate(2, tag);
    }

    protected void tagRemoved(TagWithState tag) {
        this.addConfigUpdate(4, tag);
    }

    protected void tagContentsChanged(TagWithState tag) {
        this.addConfigUpdate(3, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigUpdate(int type, TagWithState tag) {
        if (!tag.getTagType().isTagTypePersistent()) {
            return;
        }
        if (tag.isTagRemoved() && type != 4) {
            return;
        }
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            this.config_change_queue.add(new Object[]{type, tag});
        }
        this.setDirty();
    }

    private void applyConfigUpdates(Map config) {
        HashMap<TagWithState, Integer> updates = new HashMap<TagWithState, Integer>();
        for (Object[] objectArray : this.config_change_queue) {
            Integer existing;
            int type = (Integer)objectArray[0];
            TagWithState tag = (TagWithState)objectArray[1];
            if (tag.isTagRemoved()) {
                type = 4;
            }
            if ((existing = (Integer)updates.get(tag)) == null) {
                updates.put(tag, type);
                continue;
            }
            if (existing == 4 || type <= existing) continue;
            updates.put(tag, type);
        }
        for (Map.Entry entry : updates.entrySet()) {
            TagWithState tag = (TagWithState)entry.getKey();
            int type = (Integer)entry.getValue();
            TagTypeBase tag_type = tag.getTagType();
            String tt_key = String.valueOf(tag_type.getTagType());
            HashMap tt = (HashMap)config.get(tt_key);
            if (tt == null) {
                if (type == 4) continue;
                tt = new HashMap();
                config.put(tt_key, tt);
            }
            String t_key = String.valueOf(tag.getTagID());
            if (type == 4) {
                tt.remove(t_key);
                continue;
            }
            HashMap t = (HashMap)tt.get(t_key);
            if (t == null) {
                t = new HashMap();
                tt.put(t_key, t);
            }
            tag.exportDetails(t, type == 3);
        }
        this.config_change_queue.clear();
    }

    private void destroy() {
        for (TagType tagType : this.tag_types) {
            ((TagTypeBase)tagType).closing();
        }
        this.writeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (!this.config_dirty) {
                this.config_dirty = true;
                this.dirty_dispatcher.dispatch();
            }
        }
    }

    private Map readConfig() {
        if (!enabled) {
            Debug.out("TagManager is disabled");
            return new HashMap();
        }
        HashMap map = FileUtil.resilientConfigFileExists(CONFIG_FILE) ? FileUtil.readResilientConfigFile(CONFIG_FILE) : new HashMap();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getConfig() {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (this.config != null) {
                return this.config;
            }
            if (this.config_ref != null) {
                this.config = (Map)this.config_ref.get();
                if (this.config != null) {
                    return this.config;
                }
            }
            this.config = this.readConfig();
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfig() {
        if (!enabled) {
            Debug.out("TagManager is disabled");
        }
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            if (!this.config_dirty) {
                return;
            }
            this.config_dirty = false;
            if (this.config_change_queue.size() > 0) {
                this.applyConfigUpdates(this.getConfig());
            }
            if (this.config != null) {
                FileUtil.writeResilientConfigFile(CONFIG_FILE, this.config);
                this.config_ref = new WeakReference<Map<String, Object>>(this.config);
                this.config = null;
            }
        }
    }

    private Map<String, Object> getConf(TagTypeBase tag_type, boolean create) {
        HashMap conf;
        String tt_key;
        Map<String, Object> m = this.getConfig();
        HashMap tt = (HashMap)m.get(tt_key = String.valueOf(tag_type.getTagType()));
        if (tt == null) {
            if (create) {
                tt = new HashMap();
                m.put(tt_key, tt);
            } else {
                return null;
            }
        }
        if ((conf = (HashMap)tt.get("c")) == null && create) {
            conf = new HashMap();
            tt.put("c", conf);
        }
        return conf;
    }

    private Map<String, Object> getConf(TagTypeBase tag_type, TagBase tag, boolean create) {
        HashMap conf;
        String t_key;
        HashMap t;
        String tt_key;
        Map<String, Object> m = this.getConfig();
        HashMap tt = (HashMap)m.get(tt_key = String.valueOf(tag_type.getTagType()));
        if (tt == null) {
            if (create) {
                tt = new HashMap();
                m.put(tt_key, tt);
            } else {
                return null;
            }
        }
        if ((t = (HashMap)tt.get(t_key = String.valueOf(tag.getTagID()))) == null) {
            if (create) {
                t = new HashMap();
                tt.put(t_key, t);
            } else {
                return null;
            }
        }
        if ((conf = (HashMap)t.get("c")) == null && create) {
            conf = new HashMap();
            t.put("c", conf);
        }
        return conf;
    }

    protected void setConf(int tag_type, int tag_id, Map conf) {
        String tt_key;
        Map<String, Object> m = this.getConfig();
        HashMap tt = (HashMap)m.get(tt_key = String.valueOf(tag_type));
        if (tt == null) {
            tt = new HashMap();
            m.put(tt_key, tt);
        }
        String t_key = String.valueOf(tag_id);
        HashMap<String, Map> t = new HashMap<String, Map>();
        tt.put(t_key, t);
        t.put("c", conf);
        this.setDirty();
    }

    protected Boolean readBooleanAttribute(TagTypeBase tag_type, TagBase tag, String attr, Boolean def) {
        Long result = this.readLongAttribute(tag_type, tag, attr, def == null ? null : Long.valueOf(def != false ? 1L : 0L));
        if (result == null) {
            return null;
        }
        if (result == 1L) {
            return true;
        }
        return false;
    }

    protected boolean writeBooleanAttribute(TagTypeBase tag_type, TagBase tag, String attr, Boolean value) {
        return this.writeLongAttribute(tag_type, tag, attr, value == null ? null : Long.valueOf(value != false ? 1L : 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long readLongAttribute(TagTypeBase tag_type, TagBase tag, String attr, Long def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                Long value = (Long)conf.get(attr);
                if (value == null) {
                    return def;
                }
                return value;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeLongAttribute(TagTypeBase tag_type, TagBase tag, String attr, Long value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, true);
                if (value == null) {
                    if (conf.containsKey(attr)) {
                        conf.remove(attr);
                        this.setDirty();
                        return true;
                    }
                    return false;
                }
                long old = MapUtils.getMapLong(conf, attr, 0L);
                if (old == value && conf.containsKey(attr)) {
                    return false;
                }
                conf.put(attr, value);
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStringAttribute(TagTypeBase tag_type, TagBase tag, String attr, String def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                return MapUtils.getMapString(conf, attr, def);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeStringAttribute(TagTypeBase tag_type, TagBase tag, String attr, String value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, true);
                String old = MapUtils.getMapString(conf, attr, null);
                if (old == value) {
                    return false;
                }
                if (old != null && value != null && old.equals(value)) {
                    return false;
                }
                MapUtils.setMapString(conf, attr, value);
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> readMapAttribute(TagTypeBase tag_type, TagBase tag, String attr, Map<String, Object> def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                Map m = (Map)conf.get(attr);
                if (m == null) {
                    return def;
                }
                return BEncoder.cloneMap(m);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapAttribute(TagTypeBase tag_type, TagBase tag, String attr, Map<String, Object> value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, true);
                Map old = (Map)conf.get(attr);
                if (old == value) {
                    return;
                }
                if (old != null && value != null && BEncoder.mapsAreIdentical(old, value)) {
                    return;
                }
                conf.put(attr, value);
                this.setDirty();
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] readStringListAttribute(TagTypeBase tag_type, TagBase tag, String attr, String[] def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                List vals = BDecoder.decodeStrings((List)conf.get(attr));
                if (vals == null) {
                    return def;
                }
                return vals.toArray(new String[vals.size()]);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeStringListAttribute(TagTypeBase tag_type, TagBase tag, String attr, String[] value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, true);
                List old = BDecoder.decodeStrings((List)conf.get(attr));
                if (old == null && value == null) {
                    return false;
                }
                if (old != null && value != null && value.length == old.size()) {
                    boolean diff = false;
                    int i = 0;
                    while (i < value.length) {
                        String old_value = (String)old.get(i);
                        if (old_value == null || !((String)old.get(i)).equals(value[i])) {
                            diff = true;
                            break;
                        }
                        ++i;
                    }
                    if (!diff) {
                        return false;
                    }
                }
                if (value == null) {
                    conf.remove(attr);
                } else {
                    conf.put(attr, Arrays.asList(value));
                }
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] readLongListAttribute(TagTypeBase tag_type, TagBase tag, String attr, long[] def) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, false);
                if (conf == null) {
                    return def;
                }
                List vals = (List)conf.get(attr);
                if (vals == null) {
                    return def;
                }
                long[] result = new long[vals.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = (Long)vals.get(i);
                    ++i;
                }
                return result;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeLongListAttribute(TagTypeBase tag_type, TagBase tag, String attr, long[] value) {
        try {
            TagManagerImpl tagManagerImpl = this;
            synchronized (tagManagerImpl) {
                Map<String, Object> conf = this.getConf(tag_type, tag, true);
                List old = (List)conf.get(attr);
                if (old == null && value == null) {
                    return false;
                }
                if (old != null && value != null && value.length == old.size()) {
                    boolean diff = false;
                    int i = 0;
                    while (i < value.length) {
                        long old_value = (Long)old.get(i);
                        if (old_value != value[i]) {
                            diff = true;
                            break;
                        }
                        ++i;
                    }
                    if (!diff) {
                        return false;
                    }
                }
                if (value == null) {
                    conf.remove(attr);
                } else {
                    ArrayList<Long> l = new ArrayList<Long>(value.length);
                    long[] lArray = value;
                    int n = value.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            conf.put(attr, l);
                            break;
                        }
                        long v = lArray[n2];
                        l.add(v);
                        ++n2;
                    }
                }
                this.setDirty();
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConfig(TagType tag_type) {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map<String, Object> m = this.getConfig();
            String tt_key = String.valueOf(tag_type.getTagType());
            Map tt = (Map)m.remove(tt_key);
            if (tt != null) {
                this.setDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConfig(Tag tag) {
        TagType tag_type = tag.getTagType();
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map<String, Object> m = this.getConfig();
            String tt_key = String.valueOf(tag_type.getTagType());
            Map tt = (Map)m.get(tt_key);
            if (tt == null) {
                return;
            }
            String t_key = String.valueOf(tag.getTagID());
            Map t = (Map)tt.remove(t_key);
            if (t != null) {
                this.setDirty();
            }
        }
    }

    private Tag importVuzeFile(Map content) {
        TagTypeDownloadManual tt = (TagTypeDownloadManual)this.getTagType(3);
        TagDownloadWithState tag = tt.importTag((Map)content.get("tag"), (Map)content.get("config"));
        tt.addTag(tag);
        return tag;
    }

    public VuzeFile getVuzeFile(TagBase tag) {
        if (tag.getTagType().getTagType() == 3) {
            TagWithState tws = (TagWithState)tag;
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            HashMap<String, Map<Object, Object>> map = new HashMap<String, Map<Object, Object>>();
            HashMap tag_map = new HashMap();
            tws.exportDetails(vf, tag_map, false);
            Map<String, Object> conf = this.getConf(tag.getTagType(), tag, false);
            map.put("tag", tag_map);
            map.put("config", conf);
            vf.addComponent(4096, map);
            return vf;
        }
        return null;
    }

    @Override
    public TagConstraint compileConstraint(String expression) {
        if (this.constraint_handler == null) {
            return null;
        }
        return this.constraint_handler.compileConstraint(expression);
    }

    @Override
    public VuzeFile exportTags(List<Tag> tags) {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        for (Tag tag : tags) {
            if (tag.getTagType().getTagType() != 3) continue;
            TagWithState tws = (TagWithState)tag;
            HashMap<String, Map<Object, Object>> map = new HashMap<String, Map<Object, Object>>();
            HashMap tag_map = new HashMap();
            tws.exportDetails(vf, tag_map, false);
            Map<String, Object> conf = this.getConf(tws.getTagType(), tws, false);
            map.put("tag", tag_map);
            map.put("config", conf);
            vf.addComponent(4096, map);
        }
        return vf;
    }

    @Override
    public Tag duplicate(Tag tag) {
        if (tag.getTagType().getTagType() == 3) {
            TagTypeDownloadManual tt = (TagTypeDownloadManual)tag.getTagType();
            TagWithState tws = (TagWithState)tag;
            HashMap map = new HashMap();
            Map tag_map = new HashMap();
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            tws.exportDetails(vf, tag_map, false);
            Map conf = this.getConf(tt, tws, false);
            tag_map = BEncoder.cloneMap(tag_map);
            conf = BEncoder.cloneMap(conf);
            TagDownloadWithState dup_tag = tt.importTag(tag_map, conf);
            tt.addTag(dup_tag);
            return dup_tag;
        }
        return null;
    }

    protected String[] explain(Tag tag, TagFeatureProperties.TagProperty property, Taggable taggable) {
        if (property.getName(false) == "constraint") {
            return this.constraint_handler.explain(tag, taggable);
        }
        return new String[0];
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Tag Manager");
        try {
            writer.indent();
            for (TagTypeBase tag_type : this.tag_types) {
                tag_type.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void generate(IndentWriter writer, TagTypeBase tag_type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer, TagTypeBase tag_type, TagBase tag) {
        TagManagerImpl tagManagerImpl = this;
        synchronized (tagManagerImpl) {
            Map conf = this.getConf(tag_type, tag, false);
            if (conf != null) {
                conf = BDecoder.decodeStrings(BEncoder.cloneMap(conf));
                writer.println(BEncoder.encodeToJSON(conf));
            }
        }
    }

    private class LifecycleHandlerImpl
    implements TaggableLifecycleHandler {
        private TaggableResolver resolver;
        private boolean initialised;
        private final CopyOnWriteList<TaggableLifecycleListener> listeners = new CopyOnWriteList();

        private LifecycleHandlerImpl() {
        }

        private void setResolver(TaggableResolver _resolver) {
            this.resolver = _resolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(final TaggableLifecycleListener listener) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                List<Taggable> taggables;
                this.listeners.add(listener);
                if (this.initialised && (taggables = this.resolver.getResolvedTaggables()).size() > 0) {
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            listener.initialised(taggables);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener(TaggableLifecycleListener listener) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialized(final List<Taggable> initial_taggables) {
            TagManagerImpl.this.resolverInitialized(this.resolver);
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                this.initialised = true;
                if (this.listeners.size() > 0) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                listener.initialised(initial_taggables);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taggableCreated(final Taggable t) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableCreated(t);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taggableDestroyed(final Taggable t) {
            TagManagerImpl.this.removeTaggable(this.resolver, t);
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableDestroyed(t);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taggableTagged(final TagType tag_type, final Tag tag, final Taggable taggable) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableTagged(tag_type, tag, taggable);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taggableUntagged(final TagType tag_type, final Tag tag, final Taggable taggable) {
            LifecycleHandlerImpl lifecycleHandlerImpl = this;
            synchronized (lifecycleHandlerImpl) {
                if (this.initialised) {
                    final List<TaggableLifecycleListener> listeners_ref = this.listeners.getList();
                    TagManagerImpl.this.async_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            for (TaggableLifecycleListener listener : listeners_ref) {
                                try {
                                    listener.taggableUntagged(tag_type, tag, taggable);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

