/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagGroupListener;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.tag.impl.TagManagerImpl;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class TagTypeBase
implements TagType,
TagListener {
    protected static final String AT_COLOR_ID = "col.rgb";
    private final int tag_type;
    private final int tag_type_features;
    private final String tag_type_name;
    private static final int TTL_ADD = 1;
    private static final int TTL_TAG_MEMBERHIP_CHANGE = 2;
    private static final int TTL_TAG_METADATA_CHANGE = 3;
    private static final int TTL_REMOVE = 4;
    private static final int TTL_TYPE_CHANGE = 5;
    private static final int TTL_ATTENTION_REQUESTED = 6;
    private static final TagManagerImpl manager = TagManagerImpl.getSingleton();
    private static final AtomicInteger all_tags_or_tag_membership_mut = new AtomicInteger();
    private final AtomicInteger tags_or_tag_membership_mut = new AtomicInteger();
    private final ListenerManager<TagTypeListener> tt_listeners = ListenerManager.createManager("TagTypeListeners", new ListenerManagerDispatcher<TagTypeListener>(){

        @Override
        public void dispatch(TagTypeListener listener, int type, Object value) {
            if (type == 5) {
                listener.tagTypeChanged(TagTypeBase.this);
            } else {
                int event_type;
                final Tag tag = (Tag)value;
                if (type == 1) {
                    event_type = 0;
                } else if (type == 3) {
                    event_type = 4;
                } else if (type == 2) {
                    event_type = 1;
                } else if (type == 4) {
                    event_type = 2;
                } else if (type == 6) {
                    event_type = 3;
                } else {
                    return;
                }
                listener.tagEventOccurred(new TagTypeListener.TagEvent(){

                    @Override
                    public Tag getTag() {
                        return tag;
                    }

                    @Override
                    public int getEventType() {
                        return event_type;
                    }
                });
            }
        }
    });
    private final Map<Taggable, List<TagListener>> tag_listeners = new HashMap<Taggable, List<TagListener>>();
    private Map<String, TagGroupImpl> tag_groups = new HashMap<String, TagGroupImpl>();
    private final String TTP_TAGS_FOR_TAGGABLE_CACHE;

    public static int getTagAndTaggableMut() {
        return all_tags_or_tag_membership_mut.get();
    }

    protected TagTypeBase(int _tag_type, int _tag_features, String _tag_type_name) {
        this.tag_type = _tag_type;
        this.tag_type_features = _tag_features;
        this.tag_type_name = _tag_type_name;
        this.TTP_TAGS_FOR_TAGGABLE_CACHE = "TagTypeBase::tags_for_taggable_cache::" + this.tag_type;
        all_tags_or_tag_membership_mut.incrementAndGet();
    }

    protected void addTagType() {
        if (manager.isEnabled()) {
            manager.addTagType(this);
        }
    }

    @Override
    public TagManagerImpl getTagManager() {
        return manager;
    }

    protected TaggableResolver getResolver() {
        return manager.getResolver(this.tag_type);
    }

    protected Taggable resolveTaggable(String id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTaggable(TaggableResolver resolver, Taggable taggable) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            this.tag_listeners.remove(taggable);
        }
    }

    @Override
    public int getTagType() {
        return this.tag_type;
    }

    @Override
    public String getTagTypeName(boolean localize) {
        if (localize) {
            if (this.tag_type_name.startsWith("tag.")) {
                return MessageText.getString(this.tag_type_name);
            }
            return this.tag_type_name;
        }
        if (this.tag_type_name.startsWith("tag.")) {
            return this.tag_type_name;
        }
        return "!" + this.tag_type_name + "!";
    }

    @Override
    public boolean isTagTypeAuto() {
        return true;
    }

    @Override
    public boolean isTagTypePersistent() {
        return false;
    }

    @Override
    public long getTagTypeFeatures() {
        return this.tag_type_features;
    }

    @Override
    public boolean hasTagTypeFeature(long feature) {
        return ((long)this.tag_type_features & feature) != 0L;
    }

    protected void fireChanged() {
        this.tt_listeners.dispatch(5, null);
    }

    @Override
    public Tag createTag(String name, boolean auto_add) throws TagException {
        throw new TagException("Not supported");
    }

    protected void tagsOrMembershipChanged() {
        this.tags_or_tag_membership_mut.incrementAndGet();
        all_tags_or_tag_membership_mut.incrementAndGet();
    }

    @Override
    public void addTag(Tag t) {
        ((TagBase)t).initialized();
        this.tagsOrMembershipChanged();
        this.tt_listeners.dispatch(1, t);
    }

    @Override
    public void removeTag(Tag t) {
        ((TagBase)t).destroy();
        this.tagsOrMembershipChanged();
        this.tt_listeners.dispatch(4, t);
        manager.removeConfig(t);
    }

    public void requestAttention(Tag t) {
        this.tt_listeners.dispatch(6, t);
    }

    @Override
    public int[] getColorDefault() {
        return null;
    }

    protected void sync() {
        List<Tag> tags = this.getTags();
        for (Tag t : tags) {
            ((TagBase)t).sync();
        }
    }

    protected void closing() {
        List<Tag> tags = this.getTags();
        for (Tag t : tags) {
            ((TagBase)t).closing();
        }
    }

    @Override
    public Tag getTag(int tag_id) {
        for (Tag t : this.getTags()) {
            if (t.getTagID() != tag_id) continue;
            return t;
        }
        return null;
    }

    @Override
    public Tag getTag(String tag_name, boolean is_localized) {
        for (Tag t : this.getTags()) {
            if (!t.getTagName(is_localized).equals(tag_name)) continue;
            return t;
        }
        return null;
    }

    @Override
    public List<Tag> getTagsForTaggable(Taggable taggable) {
        int mut = this.tags_or_tag_membership_mut.get();
        Object[] cache = (Object[])taggable.getTaggableTransientProperty(this.TTP_TAGS_FOR_TAGGABLE_CACHE);
        if (cache != null && (Integer)cache[0] == mut) {
            return (List)cache[1];
        }
        List<Tag> result = null;
        int taggable_type = taggable.getTaggableType();
        for (Tag t : this.getTags()) {
            if (t.getTaggableTypes() != taggable_type || !t.hasTaggable(taggable)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(t);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        taggable.setTaggableTransientProperty(this.TTP_TAGS_FOR_TAGGABLE_CACHE, new Object[]{mut, result});
        return result;
    }

    private void fireMembershipChanged(Tag t) {
        this.tt_listeners.dispatch(2, t);
    }

    protected void fireMetadataChanged(Tag t) {
        this.tt_listeners.dispatch(3, t);
    }

    @Override
    public void removeTagType() {
        manager.removeTagType(this);
    }

    @Override
    public void addTagTypeListener(TagTypeListener listener, boolean fire_for_existing) {
        this.tt_listeners.addListener(listener);
        if (fire_for_existing) {
            for (final Tag t : this.getTags()) {
                try {
                    listener.tagEventOccurred(new TagTypeListener.TagEvent(){

                        @Override
                        public Tag getTag() {
                            return t;
                        }

                        @Override
                        public int getEventType() {
                            return 0;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public void removeTagTypeListener(TagTypeListener listener) {
        this.tt_listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        try {
            List<TagListener> listeners;
            Map<Taggable, List<TagListener>> map = this.tag_listeners;
            synchronized (map) {
                listeners = this.tag_listeners.get(tagged);
            }
            if (listeners != null) {
                for (TagListener l : listeners) {
                    try {
                        l.taggableAdded(tag, tagged);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            manager.taggableAdded(this, tag, tagged);
            TagGroup tg = tag.getGroupContainer();
            if (tg != null && tg.getName() != null && tg.isExclusive()) {
                List<Tag> tags = tg.getTags();
                for (Tag t : tags) {
                    boolean[] auto;
                    if (t == tag || !t.hasTaggable(tagged) || (auto = t.isTagAuto())[0]) continue;
                    t.removeTaggable(tagged);
                }
            }
        }
        finally {
            this.fireMembershipChanged(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableSync(Tag tag) {
        ArrayList<List<TagListener>> all_listeners = new ArrayList<List<TagListener>>();
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            all_listeners.addAll(this.tag_listeners.values());
        }
        for (List list : all_listeners) {
            for (TagListener listener : list) {
                try {
                    listener.taggableSync(tag);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        try {
            List<TagListener> listeners;
            Map<Taggable, List<TagListener>> map = this.tag_listeners;
            synchronized (map) {
                listeners = this.tag_listeners.get(tagged);
            }
            if (listeners != null) {
                for (TagListener l : listeners) {
                    try {
                        l.taggableRemoved(tag, tagged);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            manager.taggableRemoved(this, tag, tagged);
        }
        finally {
            this.fireMembershipChanged(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTagListener(Taggable taggable, TagListener listener) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            List<TagListener> listeners = this.tag_listeners.get(taggable);
            listeners = listeners == null ? new ArrayList<TagListener>() : new ArrayList<TagListener>(listeners);
            listeners.add(listener);
            this.tag_listeners.put(taggable, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTagListener(Taggable taggable, TagListener listener) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            List<TagListener> listeners = this.tag_listeners.get(taggable);
            if (listeners != null) {
                listeners = new ArrayList<TagListener>(listeners);
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.tag_listeners.remove(taggable);
                } else {
                    this.tag_listeners.put(taggable, listeners);
                }
            }
        }
    }

    protected Boolean readBooleanAttribute(TagBase tag, String attr, Boolean def) {
        return manager.readBooleanAttribute(this, tag, attr, def);
    }

    protected boolean writeBooleanAttribute(TagBase tag, String attr, Boolean value) {
        return manager.writeBooleanAttribute(this, tag, attr, value);
    }

    protected Long readLongAttribute(TagBase tag, String attr, Long def) {
        return manager.readLongAttribute(this, tag, attr, def);
    }

    protected boolean writeLongAttribute(TagBase tag, String attr, Long value) {
        return manager.writeLongAttribute(this, tag, attr, value);
    }

    protected String readStringAttribute(TagBase tag, String attr, String def) {
        return manager.readStringAttribute(this, tag, attr, def);
    }

    protected boolean writeStringAttribute(TagBase tag, String attr, String value) {
        return manager.writeStringAttribute(this, tag, attr, value);
    }

    protected Map<String, Object> readMapAttribute(TagBase tag, String attr, Map<String, Object> def) {
        return manager.readMapAttribute(this, tag, attr, def);
    }

    protected void writeMapAttribute(TagBase tag, String attr, Map<String, Object> value) {
        manager.writeMapAttribute(this, tag, attr, value);
    }

    protected String[] readStringListAttribute(TagBase tag, String attr, String[] def) {
        return manager.readStringListAttribute(this, tag, attr, def);
    }

    protected boolean writeStringListAttribute(TagBase tag, String attr, String[] value) {
        return manager.writeStringListAttribute(this, tag, attr, value);
    }

    protected long[] readLongListAttribute(TagBase tag, String attr, long[] def) {
        return manager.readLongListAttribute(this, tag, attr, def);
    }

    protected boolean writeLongListAttribute(TagBase tag, String attr, long[] value) {
        return manager.writeLongListAttribute(this, tag, attr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTagGroupName(TagGroupImpl old_group, String new_name) {
        List<Tag> tags;
        String old_name = old_group.getName();
        if (old_name == new_name || old_name != null && old_name.equals(new_name)) {
            return;
        }
        TagTypeBase tagTypeBase = this;
        synchronized (tagTypeBase) {
            TagGroupImpl new_group;
            tags = old_group.getTags();
            if (old_name != null) {
                this.tag_groups.remove(old_name);
            }
            for (Tag t : tags) {
                old_group.removeTag(t);
            }
            if (new_name != null && (new_group = this.tag_groups.get(new_name)) == null) {
                new_group = new TagGroupImpl(new_name, old_group);
                this.tag_groups.put(new_name, new_group);
                manager.tagGroupRenamed(this, old_group, new_group);
            }
        }
        if (new_name != null) {
            for (Tag t : tags) {
                t.setGroup(new_name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTagGroup(Tag tag, String old_name, String new_name) {
        if (old_name == new_name || old_name != null && old_name.equals(new_name)) {
            return;
        }
        TagTypeBase tagTypeBase = this;
        synchronized (tagTypeBase) {
            TagGroupImpl tg;
            if (old_name != null && (tg = this.tag_groups.get(old_name)) != null) {
                tg.removeTag(tag);
            }
            if (new_name != null) {
                tg = this.tag_groups.get(new_name);
                if (tg == null) {
                    tg = new TagGroupImpl(new_name, null, null, null);
                    this.tag_groups.put(new_name, tg);
                    manager.tagGroupCreated(this, tg, null);
                }
                tg.addTag(tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TagGroup getTagGroup(String name) {
        if (name == null) {
            return new TagGroupImpl(null, null, null, null);
        }
        TagTypeBase tagTypeBase = this;
        synchronized (tagTypeBase) {
            TagGroupImpl result = this.tag_groups.get(name);
            if (result == null) {
                result = new TagGroupImpl(name, null, null, null);
                this.tag_groups.put(name, result);
                manager.tagGroupCreated(this, result, null);
            }
            return result;
        }
    }

    public void generate(IndentWriter writer) {
        writer.println(this.tag_type_name);
        try {
            writer.indent();
            manager.generate(writer, this);
            List<Tag> tags = this.getTags();
            for (Tag t : tags) {
                ((TagBase)t).generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected void generateConfig(IndentWriter writer, TagBase tag) {
        manager.generate(writer, this, tag);
    }

    protected class TagGroupImpl
    implements TagGroup {
        private final String name;
        private boolean exclusive;
        private File ass_root;
        private int[] group_colour;
        private CopyOnWriteList<Tag> tags = new CopyOnWriteList();
        private CopyOnWriteList<TagGroupListener> listeners = new CopyOnWriteList();
        private Map<Object, Object> user_data = new HashMap<Object, Object>();

        private TagGroupImpl(String _name) {
            this.name = _name;
        }

        private TagGroupImpl(String _name, TagGroupImpl _basis) {
            this.name = _name;
            this.exclusive = _basis.exclusive;
            this.ass_root = _basis.ass_root;
            this.group_colour = _basis.group_colour;
        }

        protected String getGroupID() {
            return this.name == null ? "<null>" : Base32.encode(this.name.getBytes());
        }

        protected void importState(Map<String, Object> map) {
            List gc;
            this.exclusive = MapUtils.getMapBoolean(map, "x", false);
            String ar = MapUtils.getMapString(map, "ar", null);
            if (ar != null) {
                this.ass_root = FileUtil.newFile(ar, new String[0]);
            }
            if ((gc = (List)map.get("gc")) != null) {
                this.group_colour = new int[gc.size()];
                int i = 0;
                while (i < this.group_colour.length) {
                    this.group_colour[i] = ((Number)gc.get(i)).intValue();
                    ++i;
                }
            }
        }

        protected Map<String, Object> exportState() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.exclusive) {
                map.put("x", new Long(1L));
            }
            if (this.ass_root != null) {
                map.put("ar", this.ass_root.getAbsolutePath());
            }
            if (this.group_colour != null) {
                ArrayList<Integer> list = new ArrayList<Integer>(this.group_colour.length);
                int[] nArray = this.group_colour;
                int n = this.group_colour.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    list.add(i);
                    ++n2;
                }
                map.put("gc", list);
            }
            return map;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            TagTypeBase.this.setTagGroupName(this, name);
        }

        @Override
        public boolean isExclusive() {
            return this.exclusive;
        }

        @Override
        public void setExclusive(boolean b) {
            if (b != this.exclusive) {
                this.exclusive = b;
                manager.tagGroupUpdated(TagTypeBase.this, this);
                this.groupChanged();
            }
        }

        @Override
        public File getRootMoveOnAssignLocation() {
            return this.ass_root;
        }

        @Override
        public void setRootMoveOnAssignLocation(File f) {
            if (f == this.ass_root) {
                return;
            }
            if (f == null || this.ass_root == null || !f.equals(this.ass_root)) {
                this.ass_root = f;
                for (Tag tag : this.tags) {
                    TagFeatureFileLocation fl;
                    if (!TagTypeBase.this.hasTagTypeFeature(16L) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnAssign()) continue;
                    fl.setTagMoveOnAssignFolder(this.ass_root == null ? null : FileUtil.newFile(this.ass_root, tag.getTagName(true)));
                }
                manager.tagGroupUpdated(TagTypeBase.this, this);
                this.groupChanged();
            }
        }

        @Override
        public int[] getColor() {
            return this.group_colour;
        }

        @Override
        public void setColor(int[] rgb) {
            this.group_colour = rgb;
            for (Tag tag : this.tags) {
                if (!tag.isColorDefault()) continue;
                tag.setColor(rgb);
            }
            manager.tagGroupUpdated(TagTypeBase.this, this);
            this.groupChanged();
        }

        @Override
        public TagType getTagType() {
            return TagTypeBase.this;
        }

        @Override
        public List<Tag> getTags() {
            return this.tags.getList();
        }

        protected void addTag(Tag tag) {
            if (!this.tags.contains(tag)) {
                TagFeatureFileLocation fl;
                this.tags.add(tag);
                if (this.ass_root != null && TagTypeBase.this.hasTagTypeFeature(16L) && (fl = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnAssign()) {
                    fl.setTagMoveOnAssignFolder(this.ass_root == null ? null : FileUtil.newFile(this.ass_root, tag.getTagName(true)));
                }
                if (tag.isColorDefault() && this.group_colour != null) {
                    tag.setColor(this.group_colour);
                }
                for (TagGroupListener l : this.listeners) {
                    try {
                        l.tagAdded(this, tag);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }

        protected void removeTag(Tag tag) {
            if (this.tags.contains(tag)) {
                this.tags.remove(tag);
                for (TagGroupListener l : this.listeners) {
                    try {
                        l.tagRemoved(this, tag);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }

        private void groupChanged() {
            for (TagGroupListener l : this.listeners) {
                try {
                    l.groupChanged(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        @Override
        public void addListener(TagGroupListener l, boolean fire_for_existing) {
            this.listeners.add(l);
            if (fire_for_existing) {
                for (Tag t : this.tags) {
                    l.tagAdded(this, t);
                }
            }
        }

        @Override
        public void removeListener(TagGroupListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUserData(Object key, Object data) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                this.user_data.put(key, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getUserData(Object key) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                return this.user_data.get(key);
            }
        }

        /* synthetic */ TagGroupImpl(String string, TagGroupImpl tagGroupImpl, TagGroupImpl tagGroupImpl2, TagGroupImpl tagGroupImpl3) {
            this(string);
        }
    }
}

