/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent;

import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.HashWrapper;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

public interface TOTorrent {
    public static final int TT_V1 = 1;
    public static final int TT_V1_V2 = 2;
    public static final int TT_V2 = 3;
    public static final String DEFAULT_IGNORE_FILES = ".DS_Store;Thumbs.db;desktop.ini";
    public static final String AZUREUS_PROPERTIES = "azureus_properties";
    public static final String AZUREUS_PRIVATE_PROPERTIES = "azureus_private_properties";
    public static final String ENCODING_ACTUALLY_UTF8_KEYS = "utf8 keys";

    public int getTorrentType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public int getEffectiveTorrentType() {
        int type = this.getTorrentType();
        if (type != 2) {
            return type;
        }
        try {
            byte[] hash = this.getHash();
            byte[] v2_hash = this.getFullHash(3);
            int i = 0;
            while (true) {
                if (i >= hash.length) {
                    return 3;
                }
                if (hash[i] != v2_hash[i]) {
                    return 1;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            return type;
        }
    }

    public boolean isExportable();

    public boolean updateExportability(TOTorrent var1);

    public byte[] getName();

    public boolean isSimpleTorrent();

    public byte[] getComment();

    public void setComment(String var1);

    public long getCreationDate();

    public void setCreationDate(long var1);

    public byte[] getCreatedBy();

    public void setCreatedBy(byte[] var1);

    public URL getAnnounceURL();

    public boolean setAnnounceURL(URL var1);

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup();

    public boolean isDecentralised();

    public byte[][] getPieces() throws TOTorrentException;

    public void setPieces(byte[][] var1) throws TOTorrentException;

    public long getPieceLength();

    public int getNumberOfPieces();

    public long getSize();

    public int getFileCount();

    public TOTorrentFile[] getFiles();

    public byte[] getHash() throws TOTorrentException;

    public HashWrapper getHashWrapper() throws TOTorrentException;

    public byte[] getFullHash(int var1) throws TOTorrentException;

    default public byte[] getTruncatedHash(int type) throws TOTorrentException {
        byte[] hash = this.getFullHash(type);
        if (type == 3 && hash != null) {
            byte[] trunc = new byte[20];
            System.arraycopy(hash, 0, trunc, 0, 20);
            return trunc;
        }
        return hash;
    }

    public TOTorrent selectHybridHashType(int var1) throws TOTorrentException;

    public void setHashOverride(byte[] var1) throws TOTorrentException;

    public TOTorrent setSimpleTorrentDisabled(boolean var1) throws TOTorrentException;

    public boolean isSimpleTorrentDisabled() throws TOTorrentException;

    public boolean hasSameHashAs(TOTorrent var1);

    public boolean getPrivate();

    public void setPrivate(boolean var1) throws TOTorrentException;

    public void setSource(String var1) throws TOTorrentException;

    public String getSource();

    public void setAdditionalStringProperty(String var1, String var2);

    public String getAdditionalStringProperty(String var1);

    public void setAdditionalByteArrayProperty(String var1, byte[] var2);

    public byte[] getAdditionalByteArrayProperty(String var1);

    public void setAdditionalLongProperty(String var1, Long var2);

    public Long getAdditionalLongProperty(String var1);

    public void setAdditionalListProperty(String var1, List var2);

    public List getAdditionalListProperty(String var1);

    public void setAdditionalMapProperty(String var1, Map var2);

    public Map getAdditionalMapProperty(String var1);

    public Object getAdditionalProperty(String var1);

    public void setAdditionalProperty(String var1, Object var2);

    public void removeAdditionalProperty(String var1);

    public void removeAdditionalProperties();

    public void serialiseToBEncodedFile(File var1) throws TOTorrentException;

    public Map serialiseToMap() throws TOTorrentException;

    public void serialiseToXMLFile(File var1) throws TOTorrentException;

    public void addListener(TOTorrentListener var1);

    public void removeListener(TOTorrentListener var1);

    public AEMonitor getMonitor();

    public void print();

    public String getUTF8Name();
}

