/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentProgressListener;
import com.biglybt.core.torrent.impl.TOTorrentCreateV2Impl;
import com.biglybt.core.torrent.impl.TOTorrentFileHasher;
import com.biglybt.core.torrent.impl.TOTorrentFileHasherListener;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.torrent.impl.TOTorrentImpl;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class TOTorrentCreateImpl
extends TOTorrentImpl
implements TOTorrentFileHasherListener {
    private static final Comparator<File> file_comparator = System.getProperty("az.create.torrent.alphanumeric.sort", "0").equals("1") ? new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            String s1 = f1.getName();
            String s2 = f2.getName();
            int l1 = s1.length();
            int l2 = s2.length();
            int c1_pos = 0;
            int c2_pos = 0;
            while (c1_pos < l1 && c2_pos < l2) {
                char c1 = s1.charAt(c1_pos++);
                char c2 = s2.charAt(c2_pos++);
                if (Character.isDigit(c1) && Character.isDigit(c2)) {
                    int n1_pos = c1_pos - 1;
                    int n2_pos = c2_pos - 1;
                    while (c1_pos < l1) {
                        if (!Character.isDigit(s1.charAt(c1_pos))) break;
                        ++c1_pos;
                    }
                    while (c2_pos < l2) {
                        if (!Character.isDigit(s2.charAt(c2_pos))) break;
                        ++c2_pos;
                    }
                    int n1_length = c1_pos - n1_pos;
                    int n2_length = c2_pos - n2_pos;
                    if (n1_length != n2_length) {
                        return n1_length - n2_length;
                    }
                    int i = 0;
                    while (i < n1_length) {
                        char nc2;
                        char nc1;
                        if ((nc1 = s1.charAt(n1_pos++)) != (nc2 = s2.charAt(n2_pos++))) {
                            return nc1 - nc2;
                        }
                        ++i;
                    }
                    continue;
                }
                if ((c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return l1 - l2;
        }
    } : null;
    private static final Comparator<File> file_comparator_v2 = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private final int torrent_type;
    private File torrent_base;
    private long piece_length;
    private TOTorrentFileHasher file_hasher;
    private long total_file_size_no_pad = -1L;
    private long total_file_count_no_pad = 0L;
    private long piece_count_no_pad;
    private boolean add_other_hashes;
    private boolean add_pad_files = false;
    private int pad_file_num;
    private long pad_file_sizes;
    private final boolean add_v1;
    private final boolean add_v2;
    private final List<TOTorrentProgressListener> progress_listeners = new ArrayList<TOTorrentProgressListener>();
    private int reported_progress;
    private Set<String> ignore_set = new HashSet<String>();
    private Map<String, File> linkage_map;
    private final Map<String, String> linked_tf_map = new HashMap<String, String>();
    private volatile boolean cancelled;

    protected TOTorrentCreateImpl(int _torrent_type, Map<String, File> _linkage_map, File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_length) throws TOTorrentException {
        super(_torrent_base.getName(), _announce_url, _torrent_base.isFile());
        long highestOneBit;
        this.linkage_map = _linkage_map;
        this.torrent_base = _torrent_base;
        this.piece_length = _piece_length;
        this.add_other_hashes = _add_other_hashes;
        this.torrent_type = _torrent_type;
        this.add_v1 = this.torrent_type == 1 || this.torrent_type == 2;
        boolean bl = this.add_v2 = this.torrent_type == 3 || this.torrent_type == 2;
        if (this.add_v2 && this.piece_length != (highestOneBit = Long.highestOneBit(this.piece_length))) {
            this.piece_length = highestOneBit << 1;
        }
    }

    protected TOTorrentCreateImpl(int _torrent_type, Map<String, File> _linkage_map, File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) throws TOTorrentException {
        super(_torrent_base.getName(), _announce_url, _torrent_base.isFile());
        long highestOneBit;
        this.linkage_map = _linkage_map;
        this.torrent_base = _torrent_base;
        this.add_other_hashes = _add_other_hashes;
        this.torrent_type = _torrent_type;
        this.add_v1 = this.torrent_type == 1 || this.torrent_type == 2;
        this.add_v2 = this.torrent_type == 3 || this.torrent_type == 2;
        long total_size = this.calculateTotalFileSize(_torrent_base);
        this.piece_length = TOTorrentCreateImpl.getComputedPieceSize(total_size, _piece_min_size, _piece_max_size, _piece_num_lower, _piece_num_upper);
        if (this.add_v2 && this.piece_length != (highestOneBit = Long.highestOneBit(this.piece_length))) {
            this.piece_length = highestOneBit << 1;
        }
    }

    protected void create(boolean skip_hashing) throws TOTorrentException {
        block14: {
            if (!this.add_v1 && !this.add_v2) {
                throw new TOTorrentException("No torrent versions selected", 10);
            }
            if (this.add_v2) {
                this.add_pad_files = true;
            }
            try {
                int ignored;
                this.setIgnoreList();
                this.setTorrentType(this.torrent_type);
                this.setCreationDate(SystemTime.getCurrentTime() / 1000L);
                this.setCreatedBy("BiglyBT/3.9.0.0");
                this.setPieceLength(this.piece_length);
                this.piece_count_no_pad = this.calculateNumberOfPieces(this.torrent_base, this.piece_length);
                if (this.piece_count_no_pad == 0L) {
                    throw new TOTorrentException("Specified files have zero total length", 2);
                }
                this.report("Torrent.create.progress.piecelength", this.piece_length);
                if (this.add_v1) {
                    ignored = this.createV1(skip_hashing);
                    if (this.linkage_map.size() > 0 && this.linkage_map.size() != this.linked_tf_map.size() + ignored) {
                        throw new TOTorrentException("Unresolved V1 linkages: required=" + this.linkage_map + ", resolved=" + this.linked_tf_map, 6);
                    }
                }
                if (this.add_v2) {
                    this.linked_tf_map.clear();
                    ignored = this.createV2(skip_hashing);
                    if (this.linkage_map.size() > 0 && this.linkage_map.size() != this.linked_tf_map.size() + ignored) {
                        throw new TOTorrentException("Unresolved V2 linkages: required=" + this.linkage_map + ", resolved=" + this.linked_tf_map, 6);
                    }
                }
                if (this.linked_tf_map.size() <= 0) break block14;
                HashMap<String, Object> m = this.getAdditionalMapProperty("azureus_private_properties");
                if (m == null) {
                    m = new HashMap<String, Object>();
                    this.setAdditionalMapProperty("azureus_private_properties", m);
                }
                if (this.linked_tf_map.size() < 100) {
                    m.put("initial_linkage", this.linked_tf_map);
                    break block14;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(102400);
                try {
                    GZIPOutputStream gos = new GZIPOutputStream(baos);
                    gos.write(BEncoder.encode(this.linked_tf_map));
                    gos.close();
                    m.put("initial_linkage2", baos.toByteArray());
                }
                catch (Throwable e) {
                    throw new TOTorrentException("Failed to serialise linkage", 5);
                }
            }
            finally {
                this.setConstructed();
            }
        }
    }

    private int createV1(boolean skip_hashing) throws TOTorrentException {
        this.report("Torrent.create.progress.hashing", this.add_v2 ? ": V1" : "");
        int i = 0;
        while (i < this.progress_listeners.size()) {
            this.progress_listeners.get(i).reportProgress(0);
            ++i;
        }
        boolean add_other_per_file_hashes = this.add_other_hashes && !this.getSimpleTorrent();
        this.file_hasher = new TOTorrentFileHasher(this.add_other_hashes, add_other_per_file_hashes, (int)this.piece_length, this.progress_listeners.size() == 0 ? null : this);
        if (skip_hashing) {
            this.file_hasher.setSkipHashing(true);
        }
        int ignored = 0;
        try {
            if (this.cancelled) {
                throw new TOTorrentException("Operation cancelled", 9);
            }
            if (this.getSimpleTorrent()) {
                File link = this.linkage_map.get(this.torrent_base.getName());
                if (link != null) {
                    this.linked_tf_map.put("0", link.getAbsolutePath());
                }
                long length = this.file_hasher.add(link == null ? this.torrent_base : link);
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrentImpl)this, 0, 0L, length, new byte[][]{this.getName()})});
                this.setPieces(this.file_hasher.getPieces());
            } else {
                ArrayList<TOTorrentFileImpl> encoded = new ArrayList<TOTorrentFileImpl>();
                ignored = this.processDir(this.file_hasher, this.torrent_base, encoded, this.torrent_base.getName(), "", new long[1]);
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[encoded.size()];
                encoded.toArray(files);
                this.setFiles(files);
            }
            this.setPieces(this.file_hasher.getPieces());
            if (this.add_other_hashes) {
                byte[] sha1_digest = this.file_hasher.getSHA1Digest();
                byte[] ed2k_digest = this.file_hasher.getED2KDigest();
                this.addAdditionalInfoProperty("sha1", sha1_digest);
                this.addAdditionalInfoProperty("ed2k", ed2k_digest);
            }
            int n = ignored;
            return n;
        }
        finally {
            this.file_hasher = null;
        }
    }

    private int createV2(boolean skip_hashing) throws TOTorrentException {
        this.report("Torrent.create.progress.hashing", this.add_v1 ? ": V2" : "");
        int i = 0;
        while (i < this.progress_listeners.size()) {
            this.progress_listeners.get(i).reportProgress(0);
            ++i;
        }
        TOTorrentCreateV2Impl v2_creator = new TOTorrentCreateV2Impl(this.torrent_base, this.piece_length, new TOTorrentCreateV2Impl.Adapter(){

            @Override
            public File resolveFile(int index, File file, String relative_file) {
                File link = (File)TOTorrentCreateImpl.this.linkage_map.get(relative_file);
                if (link != null) {
                    TOTorrentCreateImpl.this.linked_tf_map.put(String.valueOf(index), link.getAbsolutePath());
                }
                return link;
            }

            @Override
            public void reportHashedBytes(long bytes) {
                TOTorrentCreateImpl.this.pieceHashed((int)(bytes / TOTorrentCreateImpl.this.piece_length));
            }

            @Override
            public void report(String resource_key) {
                TOTorrentCreateImpl.this.report(resource_key);
            }

            @Override
            public boolean ignore(String name) {
                return TOTorrentCreateImpl.this.ignoreFile(name);
            }

            @Override
            public boolean cancelled() {
                return TOTorrentCreateImpl.this.cancelled;
            }
        });
        Map<String, Object> v2_torrent = v2_creator.create();
        this.pieceHashed((int)this.piece_count_no_pad);
        if (this.add_v1) {
            if (v2_creator.getTotalFileSize() != this.total_file_size_no_pad) {
                throw new TOTorrentException("V1 and V2 total file sizes inconsistent", 4);
            }
            if (v2_creator.getTotalPadding() != this.pad_file_sizes) {
                throw new TOTorrentException("V1 and V2 padding file sizes inconsistent", 4);
            }
        }
        this.setAdditionalStringProperty("encoding", "UTF-8");
        this.setAdditionalMapProperty("piece layers", (Map)v2_torrent.get("piece layers"));
        Map v2_info = (Map)v2_torrent.get("info");
        Map v2_file_tree = (Map)v2_info.get("file tree");
        this.addAdditionalInfoProperty("file tree", v2_file_tree);
        this.addAdditionalInfoProperty("meta version", v2_info.get("meta version"));
        return v2_creator.getIgnoredFiles();
    }

    private int processDir(TOTorrentFileHasher hasher, File dir, List<TOTorrentFileImpl> encoded, String base_name, String root, long[] torrent_offset) throws TOTorrentException {
        File[] dir_file_list = dir.listFiles();
        if (dir_file_list == null) {
            throw new TOTorrentException("Directory '" + dir.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        ArrayList<File> file_list = new ArrayList<File>(Arrays.asList(dir_file_list));
        if (this.add_v2) {
            Collections.sort(file_list, file_comparator_v2);
        } else if (file_comparator == null) {
            Collections.sort(file_list);
        } else {
            Collections.sort(file_list, file_comparator);
        }
        int ignored = 0;
        int i = 0;
        while (i < file_list.size()) {
            File file = (File)file_list.get(i);
            String file_name = file.getName();
            if (!file_name.equals(".") && !file_name.equals("..")) {
                if (file.isDirectory()) {
                    if (root.length() > 0) {
                        file_name = String.valueOf(root) + File.separator + file_name;
                    }
                    ignored += this.processDir(hasher, file, encoded, base_name, file_name, torrent_offset);
                } else if (this.ignoreFile(file_name)) {
                    ++ignored;
                } else {
                    File link;
                    long offset;
                    long l;
                    if (this.add_pad_files && (l = (offset = torrent_offset[0]) % this.piece_length) > 0L) {
                        long pad_size = this.piece_length - l;
                        hasher.addPad((int)pad_size);
                        String pad_file = ".pad" + File.separator + ++this.pad_file_num + "_" + pad_size;
                        this.pad_file_sizes += pad_size;
                        TOTorrentFileImpl tf = new TOTorrentFileImpl((TOTorrentImpl)this, i, torrent_offset[0], pad_size, pad_file);
                        tf.setAdditionalProperty("attr", "p".getBytes(Constants.UTF_8));
                        torrent_offset[0] = torrent_offset[0] + pad_size;
                        encoded.add(tf);
                    }
                    if (root.length() > 0) {
                        file_name = String.valueOf(root) + File.separator + file_name;
                    }
                    if ((link = this.linkage_map.get(String.valueOf(base_name) + File.separator + file_name)) != null) {
                        this.linked_tf_map.put(String.valueOf(encoded.size()), link.getAbsolutePath());
                    }
                    long length = hasher.add(link == null ? file : link);
                    TOTorrentFileImpl tf = new TOTorrentFileImpl((TOTorrentImpl)this, i, torrent_offset[0], length, file_name);
                    torrent_offset[0] = torrent_offset[0] + length;
                    if (this.add_other_hashes) {
                        byte[] ed2k_digest = hasher.getPerFileED2KDigest();
                        byte[] sha1_digest = hasher.getPerFileSHA1Digest();
                        tf.setAdditionalProperty("sha1", sha1_digest);
                        tf.setAdditionalProperty("ed2k", ed2k_digest);
                    }
                    encoded.add(tf);
                }
            }
            ++i;
        }
        return ignored;
    }

    @Override
    public void pieceHashed(int piece_number) {
        int this_progress = (int)((long)(piece_number * 100) / this.piece_count_no_pad);
        if (this_progress > 100) {
            this_progress = 100;
        }
        if (this_progress != this.reported_progress) {
            this.reported_progress = this_progress;
            int i = 0;
            while (i < this.progress_listeners.size()) {
                this.progress_listeners.get(i).reportProgress(this.reported_progress);
                ++i;
            }
        }
    }

    protected long calculateNumberOfPieces(File _file, long _piece_length) throws TOTorrentException {
        long res = TOTorrentCreateImpl.getPieceCount(this.calculateTotalFileSize(_file), _piece_length);
        this.report("Torrent.create.progress.piececount", "" + res);
        return res;
    }

    protected long calculateTotalFileSize(File file) throws TOTorrentException {
        if (this.total_file_size_no_pad == -1L) {
            this.total_file_size_no_pad = this.getTotalFileSize(file);
        }
        return this.total_file_size_no_pad;
    }

    protected long getTotalFileSize(File file) throws TOTorrentException {
        this.report("Torrent.create.progress.parsingfiles");
        long res = this.getTotalFileSizeSupport(file, "");
        this.report("Torrent.create.progress.totalfilesize", res);
        this.report("Torrent.create.progress.totalfilecount", "" + this.total_file_count_no_pad);
        return res;
    }

    protected long getTotalFileSizeSupport(File file, String root) throws TOTorrentException {
        String name = file.getName();
        if (name.equals(".") || name.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            throw new TOTorrentException("File '" + file.getName() + "' doesn't exist", 1);
        }
        if (file.isFile()) {
            if (!this.ignoreFile(name)) {
                File link;
                ++this.total_file_count_no_pad;
                if (root.length() > 0) {
                    name = String.valueOf(root) + File.separator + name;
                }
                return (link = this.linkage_map.get(name)) == null ? file.length() : link.length();
            }
            return 0L;
        }
        File[] dir_files = file.listFiles();
        if (dir_files == null) {
            throw new TOTorrentException("Directory '" + file.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        long length = 0L;
        root = root.length() == 0 ? name : String.valueOf(root) + File.separator + name;
        int i = 0;
        while (i < dir_files.length) {
            length += this.getTotalFileSizeSupport(dir_files[i], root);
            ++i;
        }
        return length;
    }

    protected void report(String resource_key) {
        this.report(resource_key, null);
    }

    protected void report(String resource_key, long bytes) {
        if (this.progress_listeners.size() > 0) {
            this.report(resource_key, DisplayFormatters.formatByteCountToKiBEtc(bytes));
        }
    }

    protected void report(String resource_key, String additional_text) {
        if (this.progress_listeners.size() > 0) {
            String prefix = MessageText.getString(resource_key);
            int i = 0;
            while (i < this.progress_listeners.size()) {
                this.progress_listeners.get(i).reportCurrentTask(String.valueOf(prefix) + (additional_text == null ? "" : " " + additional_text));
                ++i;
            }
        }
    }

    public static long getComputedPieceSize(long total_size, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) {
        long piece_length = -1L;
        long current_piece_size = _piece_min_size;
        while (current_piece_size <= _piece_max_size) {
            long pieces = total_size / current_piece_size;
            if (pieces <= _piece_num_upper) {
                piece_length = current_piece_size;
                break;
            }
            current_piece_size <<= 1;
        }
        if (piece_length == -1L) {
            piece_length = _piece_max_size;
        }
        return piece_length;
    }

    public static long getPieceCount(long total_size, long piece_size) {
        return (total_size + (piece_size - 1L)) / piece_size;
    }

    private void setIgnoreList() {
        try {
            this.ignore_set = TorrentUtils.getIgnoreSet();
        }
        catch (NoClassDefFoundError e) {
            return;
        }
    }

    private boolean ignoreFile(String file_name) {
        if (this.ignore_set.contains(file_name.toLowerCase())) {
            this.report("Torrent.create.progress.ignoringfile", " '" + file_name + "'");
            return true;
        }
        String converted = FileUtil.convertOSSpecificChars(file_name, false);
        if (!converted.equals(file_name)) {
            this.report("Torrent.create.progress.fileconvwarn", " '" + file_name + "' -> '" + converted + "'");
        }
        return false;
    }

    protected void cancel() {
        if (!this.cancelled) {
            this.report("Torrent.create.progress.cancelled");
            this.cancelled = true;
            if (this.file_hasher != null) {
                this.file_hasher.cancel();
            }
        }
    }

    protected void addListener(TOTorrentProgressListener listener) {
        this.progress_listeners.add(listener);
    }

    protected void removeListener(TOTorrentProgressListener listener) {
        this.progress_listeners.remove(listener);
    }
}

