/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.html.HTMLUtils;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.torrent.impl.TOTorrentImpl;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.LightHashMapEx;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.TorrentUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class TOTorrentDeserialiseImpl
extends TOTorrentImpl {
    public TOTorrentDeserialiseImpl(File file) throws TOTorrentException {
        block21: {
            try {
                if (!file.exists()) {
                    throw new TOTorrentException("Torrent file '" + file.toString() + "' does not exist", 1);
                }
                if (!file.isFile()) {
                    throw new TOTorrentException("Torrent must be a file ('" + file.toString() + "')", 1);
                }
                if (file.length() == 0L) {
                    throw new TOTorrentException("Torrent is zero length ('" + file.toString() + "')", 2);
                }
                InputStream fis = null;
                try {
                    try {
                        fis = FileUtil.newFileInputStream(file);
                        this.construct(fis);
                    }
                    catch (Throwable e) {
                        try {
                            if (fis != null) {
                                fis.close();
                                fis = null;
                            }
                            fis = FileUtil.newFileInputStream(file);
                            fis = new GZIPInputStream(fis);
                            this.construct(fis);
                        }
                        catch (Throwable f) {
                            throw new TOTorrentException("Error reading torrent file '" + file.toString() + " - " + Debug.getNestedExceptionMessage(e), 4);
                        }
                        if (fis == null) break block21;
                        try {
                            fis.close();
                        }
                        catch (IOException e2) {
                            Debug.printStackTrace(e2);
                        }
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
            finally {
                this.setConstructed();
            }
        }
    }

    public TOTorrentDeserialiseImpl(InputStream is) throws TOTorrentException {
        try {
            this.construct(is);
        }
        finally {
            this.setConstructed();
        }
    }

    public TOTorrentDeserialiseImpl(TOTorrentFactory.TorrentDataHolder bytes) throws TOTorrentException {
        try {
            this.construct(bytes);
        }
        finally {
            this.setConstructed();
        }
    }

    public TOTorrentDeserialiseImpl(Map map) throws TOTorrentException {
        try {
            this.construct(map);
        }
        finally {
            this.setConstructed();
        }
    }

    protected void construct(InputStream is) throws TOTorrentException {
        ByteArrayOutputStream metaInfo = new ByteArrayOutputStream(65536);
        try {
            int nbRead;
            byte[] buf = new byte[32768];
            int iFirstByte = is.read();
            if (iFirstByte != 100 && iFirstByte != 101 && iFirstByte != 105 && (iFirstByte < 48 || iFirstByte > 57)) {
                block9: {
                    try {
                        int nbRead2;
                        metaInfo.write(iFirstByte);
                        while ((nbRead2 = is.read(buf)) > 0 && metaInfo.size() < 32000) {
                            metaInfo.write(buf, 0, nbRead2);
                        }
                        String char_data = new String(metaInfo.toByteArray());
                        if (char_data.toLowerCase().contains("html")) {
                            char_data = HTMLUtils.convertHTMLToText2(char_data);
                            if ((char_data = HTMLUtils.splitWithLineLength(char_data, 80)).length() > 400) {
                                char_data = String.valueOf(char_data.substring(0, 400)) + "...";
                            }
                            throw new TOTorrentException("Contents maybe HTML:\n" + char_data, 6);
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof TOTorrentException)) break block9;
                        throw (TOTorrentException)e;
                    }
                }
                throw new TOTorrentException("Contents invalid - bad header", 6);
            }
            metaInfo.write(iFirstByte);
            while ((nbRead = is.read(buf)) > 0) {
                metaInfo.write(buf, 0, nbRead);
            }
        }
        catch (Throwable e) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(e), 4);
        }
        byte[] bytes = metaInfo.toByteArray();
        metaInfo = null;
        TOTorrentFactory.TorrentDataHolder d_bytes = new TOTorrentFactory.TorrentDataHolder(bytes);
        bytes = null;
        this.construct(d_bytes);
    }

    protected void construct(TOTorrentFactory.TorrentDataHolder bytes) throws TOTorrentException {
        try {
            BDecoder decoder = new BDecoder();
            decoder.setVerifyMapOrder(true);
            Map<String, Object> meta_data = decoder.decodeByteArray(bytes.getBytes());
            bytes.release();
            this.construct(meta_data);
        }
        catch (IOException e) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(e), 6, e);
        }
    }

    protected void construct(Map meta_data) throws TOTorrentException {
        try {
            byte[] flat_pieces;
            int torrent_type;
            Map info;
            TOTorrentAnnounceURLSet[] sets;
            String announce_url = null;
            boolean got_announce = false;
            boolean got_announce_list = false;
            boolean bad_announce = false;
            for (String key : meta_data.keySet()) {
                if (key.equalsIgnoreCase("announce")) {
                    got_announce = true;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url == null || announce_url.trim().length() == 0) {
                        bad_announce = true;
                        continue;
                    }
                    announce_url = announce_url.replaceAll(" ", "");
                    try {
                        this.setAnnounceURL(new URL(announce_url));
                    }
                    catch (MalformedURLException e) {
                        if (!announce_url.contains("://")) {
                            announce_url = "http:/" + (announce_url.startsWith("/") ? "" : "/") + announce_url;
                        } else if (announce_url.startsWith("utp:")) {
                            announce_url = "udp" + announce_url.substring(3);
                        }
                        try {
                            this.setAnnounceURL(new URL(announce_url));
                        }
                        catch (MalformedURLException f) {
                            Debug.out("Invalid announce url: " + announce_url);
                            bad_announce = true;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("announce-list")) {
                    got_announce_list = true;
                    List announce_list = null;
                    Object ann_list = meta_data.get("announce-list");
                    if (ann_list instanceof List) {
                        announce_list = (List)ann_list;
                    }
                    if (announce_list == null || announce_list.size() <= 0) continue;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url != null) {
                        announce_url = announce_url.replaceAll(" ", "");
                    }
                    boolean announce_url_found = false;
                    int i = 0;
                    while (i < announce_list.size()) {
                        Object temp = announce_list.get(i);
                        if (temp instanceof byte[]) {
                            ArrayList l = new ArrayList();
                            l.add(temp);
                            temp = l;
                        }
                        if (temp instanceof List) {
                            Vector<URL> urls = new Vector<URL>();
                            List set = (List)temp;
                            while (set.size() > 0) {
                                Object temp2 = set.remove(0);
                                try {
                                    if (temp2 instanceof List) {
                                        List junk = (List)temp2;
                                        if (junk.size() <= 0) continue;
                                        set.add(junk.get(0));
                                        continue;
                                    }
                                    String url_str = this.readStringFromMetaData((byte[])temp2);
                                    url_str = url_str.replaceAll(" ", "");
                                    try {
                                        urls.add(new URL(StringInterner.intern(url_str)));
                                        if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                        announce_url_found = true;
                                    }
                                    catch (MalformedURLException e) {
                                        if (!url_str.contains("://")) {
                                            url_str = "http:/" + (url_str.startsWith("/") ? "" : "/") + url_str;
                                        } else if (url_str.startsWith("utp:")) {
                                            url_str = "udp" + url_str.substring(3);
                                        }
                                        try {
                                            urls.add(new URL(StringInterner.intern(url_str)));
                                            if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                            announce_url_found = true;
                                        }
                                        catch (MalformedURLException f) {
                                            Debug.out("Invalid url: " + url_str, f);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out("Torrent has invalid url-list entry (" + temp2 + ") - ignoring: meta=" + meta_data, e);
                                }
                            }
                            if (urls.size() > 0) {
                                Object[] url_array = new URL[urls.size()];
                                urls.copyInto(url_array);
                                this.addTorrentAnnounceURLSet((URL[])url_array);
                            }
                        } else {
                            Debug.out("Torrent has invalid url-list entry (" + temp + ") - ignoring: meta=" + meta_data);
                        }
                        ++i;
                    }
                    if (announce_url_found || announce_url == null || announce_url.length() <= 0) continue;
                    try {
                        Vector<URL> urls = new Vector<URL>();
                        urls.add(new URL(StringInterner.intern(announce_url)));
                        Object[] url_array = new URL[urls.size()];
                        urls.copyInto(url_array);
                        this.addTorrentAnnounceURLSet((URL[])url_array);
                    }
                    catch (Exception e) {
                        Debug.out("Invalid URL '" + announce_url + "' - meta=" + meta_data, e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("comment")) {
                    this.setComment((byte[])meta_data.get("comment"));
                    continue;
                }
                if (key.equalsIgnoreCase("created by")) {
                    this.setCreatedBy((byte[])meta_data.get("created by"));
                    continue;
                }
                if (key.equalsIgnoreCase("creation date")) {
                    try {
                        Long creation_date = (Long)meta_data.get("creation date");
                        if (creation_date == null) continue;
                        this.setCreationDate(creation_date);
                    }
                    catch (Exception e) {
                        System.out.println("creation_date extraction fails, ignoring");
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("info")) continue;
                Object prop = meta_data.get(key);
                if (prop instanceof byte[]) {
                    this.setAdditionalByteArrayProperty(key, (byte[])prop);
                    continue;
                }
                if (prop instanceof Long) {
                    this.setAdditionalLongProperty(key, (Long)prop);
                    continue;
                }
                if (prop instanceof List) {
                    this.setAdditionalListProperty(key, (List)prop);
                    continue;
                }
                this.setAdditionalMapProperty(key, (Map)prop);
            }
            if (bad_announce && got_announce_list && (sets = this.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
                this.setAnnounceURL(sets[0].getAnnounceURLs()[0]);
            }
            if (!got_announce_list && !got_announce) {
                this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
            }
            if (this.getAnnounceURL() == null) {
                TOTorrentAnnounceURLSet[] sets2;
                boolean done = false;
                if (got_announce_list && (sets2 = this.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
                    this.setAnnounceURL(sets2[0].getAnnounceURLs()[0]);
                    done = true;
                }
                if (!done) {
                    this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
                }
            }
            if ((info = (Map)meta_data.get("info")) == null) {
                throw new TOTorrentException("Decode fails, 'info' element not found'", 6);
            }
            boolean has_v2 = info.containsKey("file tree");
            boolean hasUTF8Keys = info.containsKey("name.utf-8");
            this.setName((byte[])info.get("name"));
            long piece_length = (Long)info.get("piece length");
            if (piece_length <= 0L) {
                throw new TOTorrentException("Decode fails, piece-length is invalid", 6);
            }
            this.setPieceLength(piece_length);
            Long simple_file_length = (Long)info.get("length");
            long total_length = 0L;
            String encoding = this.getAdditionalStringProperty("encoding");
            hasUTF8Keys &= encoding == null || encoding.equals("utf8 keys") || encoding.equalsIgnoreCase("utf-8");
            if (simple_file_length != null && simple_file_length == 0L && info.containsKey("files")) {
                this.addAdditionalInfoProperty("length", simple_file_length);
                simple_file_length = null;
            }
            boolean has_v1 = false;
            if (simple_file_length != null) {
                has_v1 = true;
                this.setSimpleTorrent(true);
                total_length = simple_file_length;
                if (hasUTF8Keys) {
                    this.setNameUTF8((byte[])info.get("name.utf-8"));
                    this.setAdditionalStringProperty("encoding", "utf8 keys");
                }
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrentImpl)this, 0, 0L, total_length, new byte[][]{this.getName()})});
            } else {
                this.setSimpleTorrent(false);
                List meta_files = (List)info.get("files");
                if (meta_files == null) {
                    if (!has_v2) {
                        throw new TOTorrentException("files missing", 6);
                    }
                } else {
                    has_v1 = true;
                    TOTorrentFileImpl[] files = new TOTorrentFileImpl[meta_files.size()];
                    if (hasUTF8Keys) {
                        int i = 0;
                        while (i < files.length) {
                            Map file_map = (Map)meta_files.get(i);
                            if (!(hasUTF8Keys &= file_map.containsKey("path.utf-8"))) break;
                            ++i;
                        }
                        if (hasUTF8Keys) {
                            this.setNameUTF8((byte[])info.get("name.utf-8"));
                            this.setAdditionalStringProperty("encoding", "utf8 keys");
                        }
                    }
                    ByteArrayHashMap<byte[]> comp_cache = new ByteArrayHashMap<byte[]>();
                    int i = 0;
                    while (i < files.length) {
                        TOTorrentFileImpl file;
                        Map file_map = (Map)meta_files.get(i);
                        long len = (Long)file_map.get("length");
                        List paths = (List)file_map.get("path");
                        List paths8 = (List)file_map.get("path.utf-8");
                        byte[][] path_comps = null;
                        if (paths != null) {
                            int limit = paths.size() - 1;
                            path_comps = new byte[limit + 1][];
                            int j = 0;
                            while (j <= limit) {
                                byte[] comp2 = (byte[])paths.get(j);
                                if (j < limit) {
                                    byte[] existing = (byte[])comp_cache.get(comp2);
                                    if (existing == null) {
                                        comp_cache.put(comp2, comp2);
                                    } else {
                                        comp2 = existing;
                                    }
                                }
                                path_comps[j] = comp2;
                                ++j;
                            }
                        }
                        if (hasUTF8Keys) {
                            int limit = paths8.size() - 1;
                            byte[][] path_comps8 = new byte[limit + 1][];
                            int j = 0;
                            while (j <= limit) {
                                byte[] comp3 = (byte[])paths8.get(j);
                                if (j < limit) {
                                    byte[] existing = (byte[])comp_cache.get(comp3);
                                    if (existing == null) {
                                        comp_cache.put(comp3, comp3);
                                    } else {
                                        comp3 = existing;
                                    }
                                }
                                path_comps8[j] = comp3;
                                ++j;
                            }
                            file = files[i] = new TOTorrentFileImpl(this, i, total_length, len, path_comps, path_comps8);
                        } else {
                            file = files[i] = new TOTorrentFileImpl((TOTorrentImpl)this, i, total_length, len, path_comps);
                        }
                        total_length += len;
                        for (String key : file_map.keySet()) {
                            if (key.equals("length") || key.equals("path")) continue;
                            file.setAdditionalProperty(key, file_map.get(key));
                        }
                        ++i;
                    }
                    this.setFiles(files);
                }
            }
            if (has_v1 && has_v2) {
                torrent_type = 2;
            } else if (has_v1) {
                torrent_type = 1;
            } else if (has_v2) {
                torrent_type = 3;
            } else {
                throw new TOTorrentException("Decode fails, missing v1 and v2 data", 6);
            }
            this.setTorrentType(torrent_type);
            if (has_v1) {
                this.setHashFromInfo(info);
            }
            if ((flat_pieces = (byte[])info.get("pieces")) == null) {
                if (!has_v2) {
                    throw new TOTorrentException("pieces missing", 6);
                }
            } else {
                int pieces_supplied = flat_pieces.length / 20;
                int pieces_required = (int)((total_length + (piece_length - 1L)) / piece_length);
                if (pieces_supplied < pieces_required) {
                    throw new TOTorrentException("Decode fails, insufficient pieces supplied", 6);
                }
                if (pieces_supplied > pieces_required) {
                    Debug.out("Torrent '" + new String(this.getName()) + "' has too many pieces (required=" + pieces_required + ",supplied=" + pieces_supplied + ") - ignoring excess");
                }
                byte[][] pieces = new byte[pieces_supplied][20];
                int i = 0;
                while (i < pieces.length) {
                    System.arraycopy(flat_pieces, i * 20, pieces[i], 0, 20);
                    ++i;
                }
                this.setPieces(pieces);
            }
            for (String key : info.keySet()) {
                if (key.equals("name") || key.equals("length") || key.equals("files") || key.equals("piece length") || key.equals("pieces")) continue;
                this.addAdditionalInfoProperty(key, info.get(key));
            }
            try {
                LightHashMapEx info_ex;
                byte[] ho = (byte[])info.get("hash-override");
                if (ho != null) {
                    this.setHashOverride(ho);
                } else if (info instanceof LightHashMapEx && (info_ex = (LightHashMapEx)info).getFlag((byte)1)) {
                    String name = this.getUTF8Name();
                    if (name == null) {
                        name = new String(this.getName());
                    }
                    String message = MessageText.getString("torrent.decode.info.order.bad", new String[]{name});
                    LogAlert alert = new LogAlert((Object)this, false, 1, message);
                    alert.forceNotify = true;
                    Logger.log(alert);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                if (this.isSimpleTorrentDisabled()) {
                    this.setSimpleTorrentDisabledInternal(true);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        catch (Throwable e) {
            if (e instanceof TOTorrentException) {
                throw (TOTorrentException)e;
            }
            throw new TOTorrentException("Torrent decode fails '" + Debug.getNestedExceptionMessageAndStack(e) + "'", 6, e);
        }
    }

    public void printMap() {
        try {
            this.print("", "root", this.serialiseToMap());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void print(String indent, String name, Map map) {
        System.out.println(String.valueOf(indent) + name + "{map}");
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                this.print(String.valueOf(indent) + "  ", key, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.print(String.valueOf(indent) + "  ", key, (List)value);
                continue;
            }
            if (value instanceof Long) {
                this.print(String.valueOf(indent) + "  ", key, (Long)value);
                continue;
            }
            this.print(String.valueOf(indent) + "  ", key, (byte[])value);
        }
    }

    protected void print(String indent, String name, List list) {
        System.out.println(String.valueOf(indent) + name + "{list}");
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Map) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (Map)value);
            } else if (value instanceof List) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (List)value);
            } else if (value instanceof Long) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (Long)value);
            } else {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (byte[])value);
            }
            ++index;
        }
    }

    protected void print(String indent, String name, Long value) {
        System.out.println(String.valueOf(indent) + name + "{long} = " + value);
    }

    protected void print(String indent, String name, byte[] value) {
        String x = new String(value);
        boolean print = true;
        int i = 0;
        while (i < x.length()) {
            char c = x.charAt(i);
            if (c >= '\u0080') {
                print = false;
                break;
            }
            ++i;
        }
        if (print) {
            System.out.println(String.valueOf(indent) + name + "{byte[]} = " + x);
        } else {
            System.out.println(String.valueOf(indent) + name + "{byte[], length " + value.length + "}");
        }
    }
}

