/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.TOTorrentFileHashTree;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.util.Debug;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TOTorrentFileHashTreeImpl
implements TOTorrentFileHashTree {
    private static final boolean TEST_LEAF_REQUESTS = false;
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16384;
    private static final Map<Integer, byte[]> pad_hash_cache = new HashMap<Integer, byte[]>();
    private static final int[] tree_hash_widths = new int[31];
    private final TOTorrentFileImpl file;
    private Object tree_lock = new Object();
    private byte[][] tree;
    private final int piece_layer_index;

    static {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] pad_hash = new byte[32];
            pad_hash_cache.put(0, pad_hash);
            TOTorrentFileHashTreeImpl.tree_hash_widths[0] = 1;
            int width = 2;
            int i = 1;
            while (i < tree_hash_widths.length) {
                TOTorrentFileHashTreeImpl.tree_hash_widths[i] = width;
                width <<= 1;
                sha256.update(pad_hash);
                sha256.update(pad_hash);
                pad_hash = sha256.digest();
                pad_hash_cache.put(i, pad_hash);
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected TOTorrentFileHashTreeImpl(TOTorrentFileImpl _file, byte[] _root_hash) {
        int tree_depth;
        this.file = _file;
        long file_length = this.file.getLength();
        long highestOneBit = Long.highestOneBit(file_length);
        long base_width_bytes = file_length == highestOneBit ? file_length : highestOneBit << 1;
        int block_depth = 13;
        if (base_width_bytes <= 16384L) {
            tree_depth = 1;
        } else {
            tree_depth = 63 - Long.numberOfLeadingZeros(base_width_bytes);
            tree_depth -= block_depth;
        }
        int piece_length = (int)this.file.getTorrent().getPieceLength();
        if (file_length > (long)piece_length) {
            int piece_depth = 31 - Integer.numberOfLeadingZeros(piece_length) - block_depth;
            this.piece_layer_index = tree_depth - piece_depth;
        } else {
            this.piece_layer_index = 0;
        }
        this.tree = new byte[tree_depth][];
        this.tree[0] = _root_hash;
        long layer_block_size = base_width_bytes;
        int i = 1;
        while (i < tree_depth) {
            int needed_blocks = (int)(file_length / (layer_block_size >>>= 1));
            if (file_length % layer_block_size != 0L) {
                ++needed_blocks;
            }
            int layer_size = needed_blocks * 32;
            this.tree[i] = new byte[layer_size];
            if (i == this.piece_layer_index) break;
            ++i;
        }
    }

    @Override
    public TOTorrentFile getFile() {
        return this.file;
    }

    @Override
    public byte[] getRootHash() {
        return this.tree[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> exportState() {
        Object object = this.tree_lock;
        synchronized (object) {
            block7: {
                byte[] piece_layer = this.tree[this.piece_layer_index];
                boolean is_empty = true;
                int i = 0;
                while (i < piece_layer.length) {
                    if (piece_layer[i] != 0) {
                        is_empty = false;
                        break;
                    }
                    ++i;
                }
                if (!is_empty) break block7;
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 1;
            while (i <= this.piece_layer_index) {
                map.put(String.valueOf(i), this.tree[i].clone());
                ++i;
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<byte[]> importState(Map<String, Object> map) {
        ArrayList<byte[]> result = null;
        byte[][] updated_tree = new byte[this.tree.length][];
        Object object = this.tree_lock;
        synchronized (object) {
            int i = 1;
            while (i <= this.piece_layer_index) {
                byte[] layer = (byte[])map.get(String.valueOf(i));
                if (layer != null && layer.length == this.tree[i].length) {
                    updated_tree[i] = layer;
                    if (i == this.piece_layer_index) {
                        result = new ArrayList<byte[]>(layer.length / 32);
                        int j = 0;
                        while (j < layer.length) {
                            byte[] x = new byte[32];
                            System.arraycopy(layer, j, x, 0, 32);
                            boolean ok = false;
                            int k = 0;
                            while (k < 32) {
                                if (x[k] != 0) {
                                    ok = true;
                                    break;
                                }
                                ++k;
                            }
                            result.add((byte[])(ok ? x : null));
                            j += 32;
                        }
                    }
                } else {
                    Debug.out("Invalid hash tree state");
                    return Collections.EMPTY_LIST;
                }
                ++i;
            }
            if (result == null) {
                Debug.out("Invalid hash tree state");
                return Collections.EMPTY_LIST;
            }
            i = 1;
            while (i <= this.piece_layer_index) {
                this.tree[i] = updated_tree[i];
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPieceLayerComplete() {
        if (this.piece_layer_index == 0) {
            return true;
        }
        Object object = this.tree_lock;
        synchronized (object) {
            byte[] tree_layer = this.tree[this.piece_layer_index];
            int i = 0;
            while (true) {
                if (i >= tree_layer.length) {
                    return true;
                }
                boolean ok = false;
                int j = i;
                while (j < i + 32) {
                    if (tree_layer[j] != 0) {
                        ok = true;
                        break;
                    }
                    ++j;
                }
                if (!ok) {
                    return false;
                }
                i += 32;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getPieceLayer() {
        if (this.piece_layer_index == 0) {
            return null;
        }
        Object object = this.tree_lock;
        synchronized (object) {
            byte[] tree_layer = this.tree[this.piece_layer_index];
            int i = 0;
            while (true) {
                if (i >= tree_layer.length) {
                    return (byte[])tree_layer.clone();
                }
                boolean ok = false;
                int j = i;
                while (j < i + 32) {
                    if (tree_layer[j] != 0) {
                        ok = true;
                        break;
                    }
                    ++j;
                }
                if (!ok) {
                    return null;
                }
                i += 32;
            }
        }
    }

    protected List<byte[]> addPieceLayer(byte[] piece_layer) throws TOTorrentException {
        Object object = this.tree_lock;
        synchronized (object) {
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                int layer_index = this.piece_layer_index;
                byte[] tree_layer = this.tree[layer_index];
                System.arraycopy(piece_layer, 0, tree_layer, 0, piece_layer.length);
                byte[] computed_root_hash = null;
                while (layer_index > 0) {
                    byte[] layer_pad_hash = pad_hash_cache.get(this.tree.length - layer_index - 1);
                    int layer_width = tree_hash_widths[layer_index];
                    byte[] layer_above = this.tree[layer_index - 1];
                    int layer_above_offset = 0;
                    int i = 0;
                    while (i < layer_width) {
                        int offset1 = i * 32;
                        if (offset1 >= tree_layer.length) break;
                        sha256.update(tree_layer, offset1, 32);
                        int offset2 = offset1 + 32;
                        if (offset2 >= tree_layer.length) {
                            sha256.update(layer_pad_hash);
                        } else {
                            sha256.update(tree_layer, offset2, 32);
                        }
                        byte[] hash = sha256.digest();
                        if (layer_index > 1) {
                            System.arraycopy(hash, 0, layer_above, layer_above_offset, 32);
                            layer_above_offset += 32;
                        } else {
                            computed_root_hash = hash;
                        }
                        i += 2;
                    }
                    tree_layer = this.tree[--layer_index];
                }
                if (!Arrays.equals(computed_root_hash, this.tree[0])) {
                    int i = this.piece_layer_index;
                    while (i > 0) {
                        this.tree[i] = new byte[this.tree[i].length];
                        --i;
                    }
                    throw new TOTorrentException("Piece layer validation against root failed", 6);
                }
                ArrayList<byte[]> result = new ArrayList<byte[]>(piece_layer.length / 32);
                int i = 0;
                while (i < piece_layer.length) {
                    byte[] x = new byte[32];
                    System.arraycopy(piece_layer, i, x, 0, 32);
                    result.add(x);
                    i += 32;
                }
                return result;
            }
            catch (TOTorrentException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TOTorrentException("Failed to validate piece layer", 6, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TOTorrentFileHashTree.HashRequest requestPieceHash(int piece_number, BitFlags available) {
        if (this.piece_layer_index == 0) {
            return null;
        }
        int index = piece_number - this.file.getFirstPieceNumber();
        Object object = this.tree_lock;
        synchronized (object) {
            int offset;
            byte[] piece_layer = this.tree[this.piece_layer_index];
            int i = offset = index * 32;
            while (true) {
                if (i >= offset + 32) {
                    int piece_base_layer = this.tree.length - this.piece_layer_index - 1;
                    int length = 2;
                    int proof_layers = this.piece_layer_index - 1;
                    return new HashRequestImpl(piece_base_layer, index &= 0xFFFFFFFE, length, proof_layers);
                }
                if (piece_layer[i] != 0) {
                    return null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedHashes(byte[] root_hash, int base_layer, int index, int length, int proof_layers, byte[][] hashes) {
        try {
            int layer_index = this.tree.length - base_layer - 1;
            if (layer_index != this.piece_layer_index) {
                return;
            }
            Object object = this.tree_lock;
            synchronized (object) {
                byte[][] copy_bytes = new byte[layer_index + 1][];
                int[] copy_offsets = new int[copy_bytes.length];
                try {
                    byte[] computed_root_hash;
                    byte[] tree_layer;
                    MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                    List l_hashes = Arrays.asList(hashes).subList(0, length);
                    int proof_pos = length;
                    int layer_offset = index;
                    boolean layer_match = false;
                    int li = layer_index;
                    while (li > 0) {
                        int i;
                        int copy_offset_bytes = layer_offset * 32;
                        if (l_hashes.size() == 1) {
                            if (proof_pos == hashes.length) break;
                            if ((layer_offset & 1) == 0) {
                                l_hashes.add(hashes[proof_pos++]);
                            } else {
                                l_hashes.add(0, hashes[proof_pos++]);
                                copy_offset_bytes -= 32;
                            }
                        }
                        byte[] hashes_bytes = new byte[l_hashes.size() * 32];
                        int i2 = 0;
                        while (i2 < l_hashes.size()) {
                            System.arraycopy(l_hashes.get(i2), 0, hashes_bytes, i2 * 32, 32);
                            ++i2;
                        }
                        tree_layer = this.tree[li];
                        if (tree_layer != null) {
                            layer_match = true;
                            int tree_pos = copy_offset_bytes;
                            i = 0;
                            while (i < hashes_bytes.length && tree_pos < tree_layer.length) {
                                if (tree_layer[tree_pos++] != hashes_bytes[i]) {
                                    layer_match = false;
                                    break;
                                }
                                ++i;
                            }
                            if (layer_match) break;
                        }
                        copy_bytes[li] = hashes_bytes;
                        copy_offsets[li] = copy_offset_bytes;
                        ArrayList next_hashes = new ArrayList(l_hashes.size() / 2);
                        i = 0;
                        while (i < hashes_bytes.length) {
                            sha256.update(hashes_bytes, i, 64);
                            next_hashes.add(sha256.digest());
                            i += 64;
                        }
                        l_hashes = next_hashes;
                        layer_offset >>>= 1;
                        --li;
                    }
                    if (!layer_match && !Arrays.equals(computed_root_hash = (byte[])l_hashes.get(0), this.tree[0])) {
                        Debug.out("Computed root hash mismatch");
                        return;
                    }
                    li = layer_index;
                    while (li > 0) {
                        byte[] bytes = copy_bytes[li];
                        if (bytes != null) {
                            int to_copy;
                            int copy_offset = copy_offsets[li];
                            tree_layer = this.tree[li];
                            if (tree_layer != null && (to_copy = Math.min(bytes.length, tree_layer.length - copy_offset)) > 0) {
                                System.arraycopy(bytes, 0, tree_layer, copy_offset, to_copy);
                            }
                            --li;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    return;
                }
            }
            if (layer_index == this.piece_layer_index) {
                int i = 0;
                while (i < length) {
                    byte[] piece_hash = new byte[32];
                    System.arraycopy(hashes[i], 0, piece_hash, 0, 32);
                    int piece_number = this.file.getFirstPieceNumber() + index + i;
                    if (piece_number <= this.file.getLastPieceNumber()) {
                        this.file.getTorrent().setPiece(piece_number, piece_hash);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public boolean requestHashes(TOTorrentFileHashTree.PieceTreeProvider piece_tree_provider, TOTorrentFileHashTree.HashesReceiver hashes_receiver, byte[] root_hash, int base_layer, int index, int length, int proof_layers) {
        return this.requestHashesSupport(piece_tree_provider, hashes_receiver, root_hash, base_layer, index, length, proof_layers, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean requestHashesSupport(final TOTorrentFileHashTree.PieceTreeProvider piece_tree_provider, final TOTorrentFileHashTree.HashesReceiver hashes_receiver, final byte[] root_hash, final int base_layer, final int index, final int length, final int proof_layers, byte[][] loaded_piece_tree) {
        try {
            int hashes_start;
            boolean ok;
            byte[][] local_tree;
            int leaf_layer_index = this.tree.length - 1;
            int layer_index = leaf_layer_index - base_layer;
            if (layer_index != this.piece_layer_index && layer_index != this.tree.length - 1) {
                return false;
            }
            if (length < 2 || length > 512) {
                return false;
            }
            if (length != Integer.highestOneBit(length)) {
                return false;
            }
            if (index % length != 0) {
                return false;
            }
            if (proof_layers >= this.tree.length) {
                return false;
            }
            int[] layer_offsets = new int[this.tree.length];
            byte[][] piece_tree = null;
            int layer_offset_x = index;
            int i = layer_index;
            while (i > 0) {
                layer_offsets[i] = layer_offset_x;
                layer_offset_x >>>= 1;
                --i;
            }
            int missing_proofs = 31 - Integer.numberOfLeadingZeros(length) - 1;
            if (layer_index == this.piece_layer_index) {
                local_tree = this.tree;
            } else {
                final int pli_offset = index >>> leaf_layer_index - this.piece_layer_index;
                byte[] piece_layer = this.tree[this.piece_layer_index];
                int piece_length = (int)this.file.getTorrent().getPieceLength();
                int hashes_per_piece = piece_length / 16384;
                final int pieces_required = (length + hashes_per_piece - 1) / hashes_per_piece;
                int piece_num = 0;
                while (piece_num < pieces_required) {
                    int current_offset;
                    ok = false;
                    int i2 = current_offset = pli_offset;
                    while (i2 < current_offset + 32) {
                        if (piece_layer[i2] != 0) {
                            ok = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!ok) {
                        return false;
                    }
                    current_offset += 32;
                    ++piece_num;
                }
                if (loaded_piece_tree == null) {
                    TOTorrentFileHashTree.PieceTreeReceiver pt_receiver = new TOTorrentFileHashTree.PieceTreeReceiver(){
                        byte[][][] trees;
                        int remaining;
                        boolean done;
                        {
                            this.trees = new byte[n][][];
                            this.remaining = n;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void receivePieceTree(int piece_offset, byte[][] piece_tree) {
                            if (pieces_required == 1) {
                                if (piece_tree == null) {
                                    hashes_receiver.receiveHashes(null);
                                    return;
                                } else {
                                    if (TOTorrentFileHashTreeImpl.this.requestHashesSupport(piece_tree_provider, hashes_receiver, root_hash, base_layer, index, length, proof_layers, piece_tree)) return;
                                    hashes_receiver.receiveHashes(null);
                                }
                                return;
                            }
                            byte[][][] byArray = this.trees;
                            synchronized (this.trees) {
                                if (this.done) {
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                                if (piece_tree == null) {
                                    hashes_receiver.receiveHashes(null);
                                    this.done = true;
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                                int entry = piece_offset - pli_offset;
                                if (this.trees[entry] != null) {
                                    Debug.out("Got tree twice");
                                    hashes_receiver.receiveHashes(null);
                                    this.done = true;
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                                this.trees[entry] = piece_tree;
                                --this.remaining;
                                if (this.remaining > 0) {
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                                this.done = true;
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                byte[][] tree0 = this.trees[0];
                                int layers = tree0.length;
                                byte[][] combined = new byte[layers][];
                                int li = 0;
                                while (li < tree0.length) {
                                    combined[li] = new byte[tree0[li].length * pieces_required];
                                    ++li;
                                }
                                int ti = 0;
                                while (ti < pieces_required) {
                                    byte[][] t = this.trees[ti];
                                    int li2 = 0;
                                    while (li2 < layers) {
                                        byte[] src = t[li2];
                                        int len = src.length;
                                        System.arraycopy(src, 0, combined[li2], len * ti, len);
                                        ++li2;
                                    }
                                    ++ti;
                                }
                                if (TOTorrentFileHashTreeImpl.this.requestHashesSupport(piece_tree_provider, hashes_receiver, root_hash, base_layer, index, length, proof_layers, combined)) return;
                                hashes_receiver.receiveHashes(null);
                                return;
                            }
                        }

                        @Override
                        public TOTorrentFileHashTree.HashesReceiver getHashesReceiver() {
                            return hashes_receiver;
                        }
                    };
                    int piece_num2 = 0;
                    while (piece_num2 < pieces_required) {
                        piece_tree_provider.getPieceTree(pt_receiver, this, pli_offset + piece_num2);
                        ++piece_num2;
                    }
                    return true;
                }
                piece_tree = loaded_piece_tree;
                local_tree = (byte[][])this.tree.clone();
                int x = this.piece_layer_index + 1;
                int missing_offset = layer_offsets[this.piece_layer_index];
                int i3 = 0;
                while (i3 < piece_tree.length) {
                    local_tree[x] = piece_tree[i3];
                    int n = x++;
                    layer_offsets[n] = layer_offsets[n] - (missing_offset <<= 1);
                    ++i3;
                }
            }
            byte[] tree_layer = local_tree[layer_index];
            byte[][] hashes = new byte[length + proof_layers - missing_proofs][];
            int hash_pos = 0;
            int i4 = hashes_start = layer_offsets[layer_index] * 32;
            while (i4 < tree_layer.length && hash_pos < length) {
                byte[] hash = new byte[32];
                System.arraycopy(tree_layer, i4, hash, 0, 32);
                if (layer_index <= this.piece_layer_index) {
                    ok = false;
                    int j = 0;
                    while (j < hash.length) {
                        if (hash[j] != 0) {
                            ok = true;
                            break;
                        }
                        ++j;
                    }
                    if (!ok) {
                        return false;
                    }
                }
                hashes[hash_pos++] = hash;
                i4 += 32;
            }
            if (hash_pos < length) {
                byte[] layer_pad_hash = pad_hash_cache.get(this.tree.length - layer_index - 1);
                while (hash_pos < length) {
                    hashes[hash_pos++] = layer_pad_hash;
                }
            }
            while (layer_index > 1 && hash_pos < hashes.length) {
                --layer_index;
                if (missing_proofs > 0) {
                    --missing_proofs;
                    continue;
                }
                int layer_offset = layer_offsets[layer_index];
                int uncle_offset = (layer_offset & 1) == 0 ? layer_offset + 1 : layer_offset - 1;
                int hash_start = uncle_offset * 32;
                if (hash_start < (tree_layer = local_tree[layer_index]).length) {
                    byte[] hash = new byte[32];
                    System.arraycopy(tree_layer, hash_start, hash, 0, 32);
                    boolean ok2 = false;
                    int j = 0;
                    while (j < hash.length) {
                        if (hash[j] != 0) {
                            ok2 = true;
                            break;
                        }
                        ++j;
                    }
                    if (!ok2) {
                        return false;
                    }
                    hashes[hash_pos++] = hash;
                    continue;
                }
                hashes[hash_pos++] = pad_hash_cache.get(this.tree.length - layer_index - 1);
            }
            if (hash_pos != hashes.length) {
                return false;
            }
            hashes_receiver.receiveHashes(hashes);
            return true;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    private class HashRequestImpl
    implements TOTorrentFileHashTree.HashRequest {
        private final int base_layer;
        private final int offset;
        private final int length;
        private final int proof_layers;

        private HashRequestImpl(int _base_layer, int _offset, int _length, int _proof_layers) {
            this.base_layer = _base_layer;
            this.offset = _offset;
            this.length = _length;
            this.proof_layers = _proof_layers;
        }

        @Override
        public byte[] getRootHash() {
            return TOTorrentFileHashTreeImpl.this.tree[0];
        }

        @Override
        public int getBaseLayer() {
            return this.base_layer;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getProofLayers() {
            return this.proof_layers;
        }
    }
}

