/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TOTorrentFileHashTreeImpl;
import com.biglybt.core.torrent.impl.TOTorrentImpl;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.LightHashMap;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class TOTorrentFileImpl
implements TOTorrentFile {
    private static final byte FLAG_BEP47_PAD = 1;
    private static final byte FLAG_OTHER_PAD = 2;
    private static final byte FLAG_OTHER_PAD_CHECKED = 4;
    private final TOTorrentImpl torrent;
    private final int index;
    private final long file_length;
    private final long offset_in_torrent;
    private final byte[][] path_components;
    private final byte[][] path_components_utf8;
    private final int first_piece_number;
    private final int last_piece_number;
    private Map additional_properties_maybe_null;
    private final boolean is_utf8;
    private byte flags;
    private TOTorrentFileHashTreeImpl hash_tree;
    private byte[] root_hash;

    protected TOTorrentFileImpl(TOTorrentImpl _torrent, int _index, long _torrent_offset, long _len, String _path) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.offset_in_torrent = _torrent_offset;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.hash_tree = null;
        this.is_utf8 = true;
        Vector<byte[]> temp = new Vector<byte[]>();
        int pos = 0;
        while (true) {
            int p1;
            if ((p1 = _path.indexOf(File.separator, pos)) == -1) break;
            temp.add(_path.substring(pos, p1).getBytes(Constants.DEFAULT_ENCODING_CHARSET));
            pos = p1 + 1;
        }
        temp.add(_path.substring(pos).getBytes(Constants.DEFAULT_ENCODING_CHARSET));
        this.path_components = new byte[temp.size()][];
        temp.copyInto((Object[])this.path_components);
        this.path_components_utf8 = new byte[temp.size()][];
        temp.copyInto((Object[])this.path_components_utf8);
        this.checkComponents();
    }

    protected TOTorrentFileImpl(TOTorrentImpl _torrent, int _index, long _torrent_offset, long _len, byte[][] _path_components) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.offset_in_torrent = _torrent_offset;
        this.path_components = _path_components;
        this.path_components_utf8 = null;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.hash_tree = null;
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected TOTorrentFileImpl(TOTorrentImpl _torrent, int _index, long _torrent_offset, long _len, byte[][] _path_components, byte[][] _path_components_utf8) throws TOTorrentException {
        this(_torrent, _index, _torrent_offset, _len, _path_components, _path_components_utf8, null);
    }

    protected TOTorrentFileImpl(TOTorrentImpl _torrent, int _index, long _torrent_offset, long _len, byte[][] _path_components, byte[][] _path_components_utf8, byte[] _v2_root_hash) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.offset_in_torrent = _torrent_offset;
        this.path_components = _path_components;
        this.path_components_utf8 = _path_components_utf8;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.hash_tree = _v2_root_hash == null ? null : new TOTorrentFileHashTreeImpl(this, _v2_root_hash);
        this.root_hash = _v2_root_hash;
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected void checkComponents() throws TOTorrentException {
        byte[][][] to_do;
        byte[][][] byArrayArray = to_do = new byte[][][]{this.path_components, this.path_components_utf8};
        int n = to_do.length;
        int n2 = 0;
        while (n2 < n) {
            byte[][] pc = byArrayArray[n2];
            if (pc != null) {
                int i = 0;
                while (i < pc.length) {
                    byte[] comp2 = pc[i];
                    if (comp2.length == 2 && comp2[0] == 46 && comp2[1] == 46) {
                        throw new TOTorrentException("Torrent file contains illegal '..' component", 6);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Override
    public TOTorrentImpl getTorrent() {
        return this.torrent;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public long getLength() {
        return this.file_length;
    }

    @Override
    public long getOffsetInTorrent() {
        return this.offset_in_torrent;
    }

    public byte[][] getPathComponentsBasic() {
        return this.path_components;
    }

    @Override
    public byte[][] getPathComponents() {
        return this.path_components_utf8 == null ? this.path_components : this.path_components_utf8;
    }

    public byte[][] getPathComponentsUTF8() {
        return this.path_components_utf8;
    }

    protected boolean isUTF8() {
        return this.is_utf8;
    }

    protected void setAdditionalProperty(String name, Object value) {
        String attr_str;
        if (this.additional_properties_maybe_null == null) {
            this.additional_properties_maybe_null = new LightHashMap();
        }
        this.additional_properties_maybe_null.put(name, value);
        if (name.equals("attr") && value instanceof byte[] && (attr_str = new String((byte[])value, Constants.UTF_8)).contains("p")) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    @Override
    public TOTorrentFileHashTreeImpl getHashTree() {
        return this.hash_tree;
    }

    @Override
    public byte[] getRootHash() {
        if (this.root_hash == null && (this.flags & 1) == 0) {
            this.torrent.fixupRootHashes();
        }
        return this.root_hash;
    }

    protected void setRootHash(byte[] _root_hash) {
        this.root_hash = _root_hash;
        this.hash_tree = new TOTorrentFileHashTreeImpl(this, this.root_hash);
    }

    @Override
    public Map getAdditionalProperties() {
        return this.additional_properties_maybe_null;
    }

    @Override
    public int getFirstPieceNumber() {
        return this.first_piece_number;
    }

    @Override
    public int getLastPieceNumber() {
        return this.last_piece_number;
    }

    @Override
    public int getNumberOfPieces() {
        return this.getLastPieceNumber() - this.getFirstPieceNumber() + 1;
    }

    @Override
    public boolean isPadFile() {
        if ((this.flags & 1) != 0) {
            return true;
        }
        if ((this.flags & 4) == 0) {
            byte[][] comps = this.path_components_utf8 == null ? this.path_components : this.path_components_utf8;
            byte[] last = comps[comps.length - 1];
            int other_pad = 0;
            if (last.length > 20 && last[0] == 95 && last[1] == 95 && last[2] == 95 && last[3] == 95 && last[4] == 95 && last[5] == 112 && last[6] == 97 && last[7] == 100 && last[8] == 100 && last[9] == 105 && last[10] == 110 && last[11] == 103 && last[12] == 95 && last[13] == 102 && last[14] == 105 && last[15] == 108 && last[16] == 101 && last[17] == 95) {
                int pos = 18;
                while (pos < last.length) {
                    byte c = last[pos];
                    if (c < 48 || c > 57) break;
                    ++pos;
                }
                if (pos > 18 && pos < last.length && last[pos] == 95) {
                    other_pad = 2;
                }
            }
            this.flags = (byte)(this.flags | (4 | other_pad));
        }
        return (this.flags & 2) != 0;
    }

    @Override
    public String getRelativePath() {
        return this.getRelativePath(null);
    }

    @Override
    public String getRelativePath(LocaleUtilDecoder decoder) {
        if (this.torrent == null) {
            return "";
        }
        byte[][] pathComponentsUTF8 = this.getPathComponentsUTF8();
        if (pathComponentsUTF8 != null) {
            StringBuilder sRelativePathSB = null;
            int j = 0;
            while (j < pathComponentsUTF8.length) {
                try {
                    String comp2;
                    try {
                        comp2 = new String(pathComponentsUTF8[j], "utf8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                        comp2 = "UnsupportedEncoding";
                    }
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != pathComponentsUTF8.length - 1);
                    if (j == 0) {
                        if (pathComponentsUTF8.length == 1) {
                            return comp2;
                        }
                        sRelativePathSB = new StringBuilder(512);
                    } else {
                        sRelativePathSB.append(File.separator);
                    }
                    sRelativePathSB.append(comp2);
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
                ++j;
            }
            return sRelativePathSB == null ? "" : sRelativePathSB.toString();
        }
        if (decoder == null) {
            try {
                decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
                if (decoder == null) {
                    LocaleUtil localeUtil = LocaleUtil.getSingleton();
                    decoder = localeUtil.getSystemDecoder();
                }
            }
            catch (Exception localeUtil) {
                // empty catch block
            }
        }
        if (decoder != null) {
            StringBuilder sRelativePathSB = null;
            byte[][] components = this.getPathComponents();
            int j = 0;
            while (j < components.length) {
                try {
                    String comp3;
                    try {
                        comp3 = decoder.decodeString(components[j]);
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                        try {
                            comp3 = new String(components[j]);
                        }
                        catch (Exception e2) {
                            comp3 = "UnsupportedEncoding";
                        }
                    }
                    comp3 = FileUtil.convertOSSpecificChars(comp3, j != components.length - 1);
                    if (j == 0) {
                        if (components.length == 1) {
                            return comp3;
                        }
                        sRelativePathSB = new StringBuilder(512);
                    } else {
                        sRelativePathSB.append(File.separator);
                    }
                    sRelativePathSB.append(comp3);
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
                ++j;
            }
            return sRelativePathSB == null ? "" : sRelativePathSB.toString();
        }
        return "";
    }

    public Map serializeToMap() {
        HashMap<String, Serializable> file_map = new HashMap<String, Serializable>();
        file_map.put("length", new Long(this.getLength()));
        ArrayList path = new ArrayList();
        file_map.put("path", path);
        byte[][] path_comps = this.getPathComponentsBasic();
        if (path_comps != null) {
            Collections.addAll(path, path_comps);
        }
        if (path_comps != null && this.isUTF8()) {
            ArrayList utf8_path = new ArrayList();
            file_map.put("path.utf-8", utf8_path);
            Collections.addAll(utf8_path, path_comps);
        } else {
            byte[][] utf8_path_comps = this.getPathComponentsUTF8();
            if (utf8_path_comps != null) {
                ArrayList utf8_path = new ArrayList();
                file_map.put("path.utf-8", utf8_path);
                Collections.addAll(utf8_path, utf8_path_comps);
            }
        }
        Map file_additional_properties = this.getAdditionalProperties();
        if (file_additional_properties != null) {
            file_map.putAll(file_additional_properties);
        }
        return file_map;
    }
}

