/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.torrent.impl.TOTorrentAnnounceURLGroupImpl;
import com.biglybt.core.torrent.impl.TOTorrentCreateV2Impl;
import com.biglybt.core.torrent.impl.TOTorrentFileHashTreeImpl;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.torrent.impl.TOTorrentXMLSerialiser;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteEncodedKeyHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TOTorrentImpl
extends LogRelation
implements TOTorrent {
    protected static final String TK_ANNOUNCE = "announce";
    protected static final String TK_ANNOUNCE_LIST = "announce-list";
    protected static final String TK_COMMENT = "comment";
    protected static final String TK_CREATION_DATE = "creation date";
    protected static final String TK_CREATED_BY = "created by";
    protected static final String TK_INFO = "info";
    protected static final String TK_NAME = "name";
    protected static final String TK_LENGTH = "length";
    protected static final String TK_PATH = "path";
    protected static final String TK_FILES = "files";
    protected static final String TK_PIECE_LENGTH = "piece length";
    protected static final String TK_PIECES = "pieces";
    protected static final String TK_PRIVATE = "private";
    protected static final String TK_SOURCE = "source";
    protected static final String TK_NAME_UTF8 = "name.utf-8";
    protected static final String TK_PATH_UTF8 = "path.utf-8";
    protected static final String TK_COMMENT_UTF8 = "comment.utf-8";
    protected static final String TK_WEBSEED_BT = "httpseeds";
    protected static final String TK_WEBSEED_GR = "url-list";
    protected static final String TK_HASH_OVERRIDE = "hash-override";
    protected static final String TK_ENCODING = "encoding";
    protected static final List TK_ADDITIONAL_OK_ATTRS = Arrays.asList("comment.utf-8", "azureus_properties", "httpseeds", "url-list");
    protected static final String TK_BEP47_ATTRS = "attr";
    protected static final String TK_V2_META_VERSION = "meta version";
    protected static final String TK_V2_FILE_TREE = "file tree";
    protected static final String TK_V2_PIECE_LAYERS = "piece layers";
    protected static final String TK_V2_PIECES_ROOT = "pieces root";
    private static CopyOnWriteList<TOTorrentListener> global_listeners = new CopyOnWriteList();
    private int torrent_type;
    private byte[] torrent_name;
    private String torrent_name_utf8;
    private byte[] comment;
    private URL announce_url;
    private final TOTorrentAnnounceURLGroupImpl announce_group = new TOTorrentAnnounceURLGroupImpl(this);
    private long piece_length;
    private byte[][] pieces;
    private int number_of_pieces;
    private byte[] torrent_hash_override;
    private byte[] torrent_hash;
    private HashWrapper torrent_hash_wrapper;
    private byte[] torrent_hash_v1;
    private HashWrapper torrent_hash_wrapper_v1;
    private byte[] torrent_hash_v2;
    private HashWrapper torrent_hash_wrapper_v2;
    private boolean simple_torrent_original;
    private boolean simple_torrent_effective;
    private TOTorrentFileImpl[] files;
    private long creation_date;
    private byte[] created_by;
    private Map additional_properties = new LightHashMap(4);
    private final Map additional_info_properties = new LightHashMap(4);
    private boolean created;
    private boolean serialising;
    private List<TOTorrentListener> listeners;
    protected final AEMonitor this_mon = new AEMonitor("TOTorrent");
    private boolean constructing = true;
    private boolean fixed_up_root_hashes;

    public static void addGlobalListener(TOTorrentListener listener) {
        global_listeners.add(listener);
    }

    public static void removeGlobalListener(TOTorrentListener listener) {
        global_listeners.remove(listener);
    }

    protected TOTorrentImpl() {
    }

    protected TOTorrentImpl(String _torrent_name, URL _announce_url, boolean _simple_torrent) {
        this.created = true;
        this.torrent_name = _torrent_name.getBytes(Constants.DEFAULT_ENCODING_CHARSET);
        this.torrent_name_utf8 = _torrent_name;
        this.setAnnounceURL(_announce_url);
        this.simple_torrent_original = this.simple_torrent_effective = _simple_torrent;
    }

    protected void setConstructed() throws TOTorrentException {
        try {
            if (this.torrent_type == 3) {
                TOTorrentCreateV2Impl.lashUpV1Info(this);
                if (this.files.length == 1 && this.files[0].getPathComponents().length == 1) {
                    this.setSimpleTorrent(true);
                }
            }
        }
        finally {
            this.constructing = false;
        }
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
    }

    protected void fixupRootHashes() {
        if (this.torrent_type == 2 && !this.fixed_up_root_hashes) {
            TOTorrentCreateV2Impl.setV2FileHashes(this);
            this.fixed_up_root_hashes = true;
        }
    }

    @Override
    public void serialiseToBEncodedFile(File output_file) throws TOTorrentException {
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
        byte[] res = this.serialiseToByteArray();
        FilterOutputStream bos = null;
        try {
            try {
                File temp;
                boolean dir_created;
                File parent = output_file.getParentFile();
                if (parent == null) {
                    throw new TOTorrentException("Path '" + output_file + "' is invalid", 5);
                }
                if (!parent.isDirectory() && !(dir_created = FileUtil.mkdirs(parent))) {
                    if (parent.exists()) {
                        if (!parent.isDirectory()) {
                            throw new TOTorrentException("Path '" + output_file + "' is invalid", 5);
                        }
                    } else {
                        throw new TOTorrentException("Failed to create directory '" + parent + "'", 5);
                    }
                }
                if ((temp = FileUtil.newFile(parent, String.valueOf(output_file.getName()) + ".saving")).exists()) {
                    if (!temp.delete()) {
                        throw new TOTorrentException("Insufficient permissions to delete '" + temp + "'", 5);
                    }
                } else {
                    boolean ok = false;
                    try {
                        ok = temp.createNewFile();
                    }
                    catch (Throwable e) {
                        throw new TOTorrentException("Insufficient permissions to write '" + temp + "'", 5, e);
                    }
                    if (!ok) {
                        throw new TOTorrentException("Insufficient permissions to write '" + temp + "'", 5);
                    }
                }
                FileOutputStream fos = FileUtil.newFileOutputStream(temp);
                bos = new BufferedOutputStream(fos, 8192);
                bos.write(res);
                ((BufferedOutputStream)bos).flush();
                fos.getFD().sync();
                bos.close();
                bos = null;
                if (temp.length() > 1L) {
                    if (output_file.exists() && !output_file.delete()) {
                        Debug.out("Failed to delete " + output_file);
                    }
                    if (!temp.renameTo(output_file)) {
                        Debug.out("Failed to rename '" + temp + "' to '" + output_file + "'");
                    }
                }
            }
            catch (TOTorrentException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(e), 5);
            }
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected byte[] serialiseToByteArray() throws TOTorrentException {
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
        Map root = this.serialiseToMap();
        try {
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    return BEncoder.encode(root);
                }
                catch (ConcurrentModificationException e) {
                    if (attempts < 3) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(e), 5);
        }
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        TOTorrentFileImpl file;
        if (this.created && !this.serialising) {
            try {
                this.serialising = true;
                TorrentUtils.addCreatedTorrent(this);
            }
            finally {
                this.serialising = false;
            }
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        this.writeStringToMetaData(root, TK_ANNOUNCE, (this.announce_url == null ? TorrentUtils.getDecentralisedEmptyURL() : this.announce_url).toString());
        TOTorrentAnnounceURLSet[] sets = this.announce_group.getAnnounceURLSets();
        if (sets.length > 0) {
            ArrayList announce_list = new ArrayList();
            int i = 0;
            while (i < sets.length) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                if (urls.length != 0) {
                    ArrayList<byte[]> sub_list = new ArrayList<byte[]>();
                    announce_list.add(sub_list);
                    int j = 0;
                    while (j < urls.length) {
                        sub_list.add(this.writeStringToMetaData(urls[j].toString()));
                        ++j;
                    }
                }
                ++i;
            }
            if (announce_list.size() > 0) {
                root.put(TK_ANNOUNCE_LIST, announce_list);
            }
        }
        if (this.comment != null) {
            root.put(TK_COMMENT, this.comment);
        }
        if (this.creation_date != 0L) {
            root.put(TK_CREATION_DATE, new Long(this.creation_date));
        }
        if (this.created_by != null) {
            root.put(TK_CREATED_BY, this.created_by);
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        root.put(TK_INFO, info);
        info.put(TK_PIECE_LENGTH, new Long(this.piece_length));
        if (this.torrent_type != 3) {
            if (this.pieces == null) {
                throw new TOTorrentException("Pieces is null", 5);
            }
            byte[] flat_pieces = new byte[this.pieces.length * 20];
            int i = 0;
            while (i < this.pieces.length) {
                System.arraycopy(this.pieces[i], 0, flat_pieces, i * 20, 20);
                ++i;
            }
            info.put(TK_PIECES, flat_pieces);
            if (this.simple_torrent_original) {
                TOTorrentFileImpl file2 = this.files[0];
                info.put(TK_LENGTH, new Long(file2.getLength()));
            } else {
                ArrayList<Map> meta_files = new ArrayList<Map>();
                info.put(TK_FILES, meta_files);
                int i2 = 0;
                while (i2 < this.files.length) {
                    file = this.files[i2];
                    Map file_map = file.serializeToMap();
                    meta_files.add(file_map);
                    ++i2;
                }
            }
        } else if (this.getAdditionalMapProperty(TK_V2_PIECE_LAYERS) == null && this.files != null) {
            ByteEncodedKeyHashMap pl_map = new ByteEncodedKeyHashMap();
            HashMap<String, Map<String, Object>> hash_tree_state = new HashMap<String, Map<String, Object>>();
            boolean complete = true;
            TOTorrentFileImpl[] tOTorrentFileImplArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                file = tOTorrentFileImplArray[n2];
                if (file.getLength() > this.piece_length) {
                    TOTorrentFileHashTreeImpl tree = file.getHashTree();
                    byte[] root_hash = tree.getRootHash();
                    byte[] piece_layer = tree.getPieceLayer();
                    if (piece_layer == null) {
                        complete = false;
                        Map<String, Object> export = tree.exportState();
                        if (export != null) {
                            hash_tree_state.put(String.valueOf(file.getIndex()), export);
                        }
                    } else {
                        pl_map.put(new String(root_hash, Constants.BYTE_ENCODING_CHARSET), piece_layer);
                    }
                }
                ++n2;
            }
            if (complete) {
                this.setAdditionalMapProperty(TK_V2_PIECE_LAYERS, pl_map);
            } else {
                TorrentUtils.setHashTreeState(this, hash_tree_state);
            }
        } else {
            TorrentUtils.setHashTreeState(this, null);
        }
        info.put(TK_NAME, this.torrent_name);
        if (this.torrent_name_utf8 != null) {
            info.put(TK_NAME_UTF8, this.torrent_name_utf8.getBytes(Constants.UTF_8));
        }
        if (this.torrent_hash_override != null) {
            info.put(TK_HASH_OVERRIDE, this.torrent_hash_override);
        }
        for (String key : this.additional_info_properties.keySet()) {
            info.put(key, this.additional_info_properties.get(key));
        }
        for (String key : this.additional_properties.keySet()) {
            Object value = this.additional_properties.get(key);
            if (value == null) continue;
            root.put(key, value);
        }
        return root;
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
        TOTorrentXMLSerialiser serialiser = new TOTorrentXMLSerialiser(this);
        serialiser.serialiseToFile(file);
    }

    @Override
    public int getTorrentType() {
        if (this.torrent_type == 0) {
            Debug.out("Torrent type not set!");
            return 1;
        }
        return this.torrent_type;
    }

    protected void setTorrentType(int type) {
        this.torrent_type = type;
    }

    @Override
    public boolean isExportable() {
        if (this.torrent_type == 3) {
            return this.getAdditionalMapProperty(TK_V2_PIECE_LAYERS) != null;
        }
        return true;
    }

    @Override
    public boolean updateExportability(TOTorrent from) {
        if (this.torrent_type == 3) {
            Map piece_layers;
            block7: {
                block6: {
                    if (this.isExportable()) {
                        return true;
                    }
                    try {
                        if (Arrays.equals(this.getHash(), from.getHash())) break block6;
                        return false;
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        return false;
                    }
                }
                piece_layers = from.getAdditionalMapProperty(TK_V2_PIECE_LAYERS);
                if (piece_layers != null) break block7;
                return false;
            }
            this.setAdditionalMapProperty(TK_V2_PIECE_LAYERS, piece_layers);
            return true;
        }
        return true;
    }

    @Override
    public byte[] getName() {
        return this.torrent_name;
    }

    protected void setName(byte[] _name) {
        this.torrent_name = _name;
    }

    @Override
    public String getUTF8Name() {
        return this.torrent_name_utf8;
    }

    protected void setNameUTF8(byte[] name) {
        if (name != null) {
            this.torrent_name_utf8 = new String(name, Constants.UTF_8);
        }
    }

    @Override
    public boolean isSimpleTorrent() {
        return this.simple_torrent_effective;
    }

    @Override
    public byte[] getComment() {
        return this.comment;
    }

    protected void setComment(byte[] _comment) {
        this.comment = _comment;
    }

    @Override
    public void setComment(String _comment) {
        byte[] utf8_comment = _comment.getBytes(Constants.UTF_8);
        this.setComment(utf8_comment);
        this.setAdditionalByteArrayProperty(TK_COMMENT_UTF8, utf8_comment);
    }

    @Override
    public URL getAnnounceURL() {
        return this.announce_url;
    }

    @Override
    public boolean setAnnounceURL(URL url) {
        String s1;
        URL newURL = url;
        String s0 = newURL == null ? "" : newURL.toString();
        String string = s1 = this.announce_url == null ? "" : this.announce_url.toString();
        if (s0.equals(s1)) {
            return false;
        }
        if (newURL == null) {
            newURL = TorrentUtils.getDecentralisedEmptyURL();
        }
        URL old = this.announce_url;
        this.announce_url = StringInterner.internURL(newURL);
        this.fireChanged(1, new Object[]{old, this.announce_url});
        return true;
    }

    @Override
    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.getAnnounceURL());
    }

    @Override
    public long getCreationDate() {
        return this.creation_date;
    }

    @Override
    public void setCreationDate(long _creation_date) {
        long now_secs = SystemTime.getCurrentTime() / 1000L;
        if (_creation_date > now_secs + 3153600000L) {
            _creation_date /= 1000L;
        }
        this.creation_date = _creation_date;
    }

    @Override
    public void setCreatedBy(byte[] _created_by) {
        this.created_by = _created_by;
    }

    protected void setCreatedBy(String _created_by) {
        this.setCreatedBy(_created_by.getBytes(Constants.DEFAULT_ENCODING_CHARSET));
    }

    @Override
    public byte[] getCreatedBy() {
        return this.created_by;
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        if (this.torrent_hash == null) {
            Map root = this.serialiseToMap();
            Map info = (Map)root.get(TK_INFO);
            this.setHashFromInfo(info);
        }
        return this.torrent_hash;
    }

    @Override
    public byte[] getFullHash(int type) throws TOTorrentException {
        if (this.torrent_hash == null) {
            Map root = this.serialiseToMap();
            Map info = (Map)root.get(TK_INFO);
            this.setHashFromInfo(info);
        }
        return type == 1 ? this.torrent_hash_v1 : this.torrent_hash_v2;
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        if (this.torrent_hash_wrapper == null) {
            this.getHash();
        }
        return this.torrent_hash_wrapper;
    }

    @Override
    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.getHash(), other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    protected void setHashFromInfo(Map<String, Object> info) throws TOTorrentException {
        try {
            if (this.torrent_hash_override == null) {
                if (this.torrent_type == 0) {
                    Debug.out("Torrent type unknown");
                }
                byte[] encoded = BEncoder.encode(info);
                if (this.torrent_type == 2) {
                    Long l;
                    Map private_props = this.getAdditionalMapProperty("azureus_private_properties");
                    boolean hybrid_hash_is_v2 = false;
                    if (private_props != null && (l = (Long)private_props.get("hybrid_hash_v2")) != null) {
                        hybrid_hash_is_v2 = l == 1L;
                    }
                    SHA1Hasher s = new SHA1Hasher();
                    this.torrent_hash_v1 = s.calculateHash(encoded);
                    this.torrent_hash_wrapper_v1 = new HashWrapper(this.torrent_hash_v1);
                    MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                    this.torrent_hash_v2 = sha256.digest(encoded);
                    this.torrent_hash_wrapper_v2 = new HashWrapper(this.torrent_hash_v2);
                    if (hybrid_hash_is_v2) {
                        this.torrent_hash = new byte[20];
                        System.arraycopy(this.torrent_hash_v2, 0, this.torrent_hash, 0, 20);
                    } else {
                        this.torrent_hash = this.torrent_hash_v1;
                    }
                } else if (this.torrent_type == 3) {
                    MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                    this.torrent_hash_v2 = sha256.digest(encoded);
                    this.torrent_hash_wrapper_v2 = new HashWrapper(this.torrent_hash_v2);
                    this.torrent_hash = new byte[20];
                    System.arraycopy(this.torrent_hash_v2, 0, this.torrent_hash, 0, 20);
                } else {
                    SHA1Hasher s = new SHA1Hasher();
                    this.torrent_hash = s.calculateHash(encoded);
                    this.torrent_hash_v1 = this.torrent_hash;
                    this.torrent_hash_wrapper_v1 = new HashWrapper(this.torrent_hash_v1);
                }
            } else {
                this.torrent_hash = this.torrent_hash_override;
            }
            this.torrent_hash_wrapper = new HashWrapper(this.torrent_hash);
        }
        catch (Throwable e) {
            throw new TOTorrentException("Failed to calculate hash: " + Debug.getNestedExceptionMessage(e), 8);
        }
    }

    @Override
    public TOTorrent selectHybridHashType(int type) throws TOTorrentException {
        if (this.torrent_type != 2) {
            throw new TOTorrentException("Torrent isn't hybrid", 10);
        }
        TOTorrent clone = TOTorrentFactory.deserialiseFromBEncodedByteArray(new TOTorrentFactory.TorrentDataHolder(this.serialiseToByteArray()));
        TorrentUtils.clearTorrentFileName(clone);
        HashMap<String, Long> private_props = clone.getAdditionalMapProperty("azureus_private_properties");
        if (type == 1) {
            if (private_props != null) {
                private_props.remove("hybrid_hash_v2");
            }
        } else if (type == 3) {
            if (private_props == null) {
                private_props = new HashMap<String, Long>();
            }
            private_props.put("hybrid_hash_v2", 1L);
            clone.setAdditionalMapProperty("azureus_private_properties", private_props);
        }
        try {
            return TOTorrentFactory.deserialiseFromBEncodedByteArray(new TOTorrentFactory.TorrentDataHolder(BEncoder.encode(clone.serialiseToMap())));
        }
        catch (Throwable e) {
            throw new TOTorrentException("Encode failed", 10, e);
        }
    }

    @Override
    public void setHashOverride(byte[] hash) throws TOTorrentException {
        if (this.torrent_hash_override != null) {
            if (Arrays.equals(hash, this.torrent_hash_override)) {
                return;
            }
            throw new TOTorrentException("Hash override can only be set once", 8);
        }
        this.torrent_hash_override = hash;
        this.torrent_hash = null;
        this.getHash();
    }

    protected byte[] getHashOverride() {
        return this.torrent_hash_override;
    }

    @Override
    public TOTorrent setSimpleTorrentDisabled(boolean disabled) throws TOTorrentException {
        TOTorrent clone = TOTorrentFactory.deserialiseFromBEncodedByteArray(new TOTorrentFactory.TorrentDataHolder(this.serialiseToByteArray()));
        TorrentUtils.clearTorrentFileName(clone);
        HashMap<String, Long> private_props = clone.getAdditionalMapProperty("azureus_private_properties");
        if (disabled) {
            if (!this.simple_torrent_effective) {
                throw new TOTorrentException("Torrent isn't simple", 10);
            }
        } else if (private_props == null || !private_props.containsKey("simple_torrent_disable")) {
            throw new TOTorrentException("Torrent wasn't simple-disabled", 10);
        }
        if (disabled) {
            if (private_props == null) {
                private_props = new HashMap<String, Long>();
            }
            private_props.put("simple_torrent_disable", 1L);
            clone.setAdditionalMapProperty("azureus_private_properties", private_props);
        } else if (private_props != null) {
            private_props.remove("hybrid_hash_v2");
        }
        try {
            return TOTorrentFactory.deserialiseFromBEncodedByteArray(new TOTorrentFactory.TorrentDataHolder(BEncoder.encode(clone.serialiseToMap())));
        }
        catch (Throwable e) {
            throw new TOTorrentException("Encode failed", 10, e);
        }
    }

    @Override
    public boolean isSimpleTorrentDisabled() throws TOTorrentException {
        Map private_props = this.getAdditionalMapProperty("azureus_private_properties");
        return private_props != null && private_props.containsKey("simple_torrent_disable");
    }

    protected void setSimpleTorrentDisabledInternal(boolean b) {
        this.simple_torrent_effective = !b;
    }

    @Override
    public void setPrivate(boolean _private_torrent) throws TOTorrentException {
        Long existing = (Long)this.additional_info_properties.get(TK_PRIVATE);
        if (existing == null && !_private_torrent) {
            return;
        }
        Long l_private = new Long(_private_torrent ? 1 : 0);
        if (existing != null && existing.equals(l_private)) {
            return;
        }
        this.additional_info_properties.put(TK_PRIVATE, l_private);
        this.torrent_hash = null;
        this.getHash();
    }

    @Override
    public boolean getPrivate() {
        Object o = this.additional_info_properties.get(TK_PRIVATE);
        if (o instanceof Long) {
            return ((Long)o).intValue() != 0;
        }
        return false;
    }

    @Override
    public void setSource(String str) throws TOTorrentException {
        this.additional_info_properties.put(TK_SOURCE, str.getBytes(Constants.UTF_8));
        this.torrent_hash = null;
        this.getHash();
    }

    @Override
    public String getSource() {
        Object o = this.additional_info_properties.get(TK_SOURCE);
        if (o instanceof byte[]) {
            return new String((byte[])o, Constants.UTF_8);
        }
        return null;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return this.announce_group;
    }

    protected void addTorrentAnnounceURLSet(URL[] urls) {
        this.announce_group.addSet(this.announce_group.createAnnounceURLSet(urls));
    }

    @Override
    public long getSize() {
        long res = 0L;
        int i = 0;
        while (i < this.files.length) {
            res += this.files[i].getLength();
            ++i;
        }
        return res;
    }

    @Override
    public long getPieceLength() {
        return this.piece_length;
    }

    protected void setPieceLength(long _length) {
        this.piece_length = _length;
    }

    @Override
    public int getNumberOfPieces() {
        if (this.number_of_pieces == 0) {
            this.number_of_pieces = (int)((this.getSize() + (this.piece_length - 1L)) / this.piece_length);
        }
        return this.number_of_pieces;
    }

    @Override
    public byte[][] getPieces() {
        return this.pieces;
    }

    @Override
    public void setPieces(byte[][] _pieces) {
        this.pieces = _pieces;
    }

    protected void setPiece(int index, byte[] piece) {
        this.pieces[index] = piece;
    }

    @Override
    public int getFileCount() {
        return this.files.length;
    }

    public TOTorrentFileImpl[] getFiles() {
        return this.files;
    }

    protected void setFiles(TOTorrentFileImpl[] _files) {
        this.files = _files;
    }

    protected boolean getSimpleTorrent() {
        return this.simple_torrent_original;
    }

    protected void setSimpleTorrent(boolean _simple_torrent) {
        this.simple_torrent_original = this.simple_torrent_effective = _simple_torrent;
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }

    @Override
    public void setAdditionalStringProperty(String name, String value) {
        this.setAdditionalByteArrayProperty(name, this.writeStringToMetaData(value));
    }

    @Override
    public String getAdditionalStringProperty(String name) {
        return this.readStringFromMetaData(this.getAdditionalByteArrayProperty(name));
    }

    @Override
    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (value instanceof String) {
            this.setAdditionalStringProperty(name, (String)value);
        } else {
            this.additional_properties.put(name, value);
        }
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    @Override
    public void setAdditionalLongProperty(String name, Long value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public Long getAdditionalLongProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    @Override
    public void setAdditionalListProperty(String name, List value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public List getAdditionalListProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    @Override
    public void setAdditionalMapProperty(String name, Map value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public Map getAdditionalMapProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    @Override
    public Object getAdditionalProperty(String name) {
        return this.additional_properties.get(name);
    }

    @Override
    public void removeAdditionalProperty(String name) {
        this.additional_properties.remove(name);
    }

    @Override
    public void removeAdditionalProperties() {
        HashMap new_props = new HashMap();
        for (String key : this.additional_properties.keySet()) {
            if (!TK_ADDITIONAL_OK_ATTRS.contains(key)) continue;
            new_props.put(key, this.additional_properties.get(key));
        }
        this.additional_properties = new_props;
    }

    protected void addAdditionalProperty(String name, Object value) {
        this.additional_properties.put(name, value);
    }

    protected void addAdditionalInfoProperty(String name, Object value) {
        this.additional_info_properties.put(name, value);
    }

    protected Map getAdditionalInfoProperties() {
        return this.additional_info_properties;
    }

    protected String readStringFromMetaData(Map meta_data, String name) {
        Object obj = meta_data.get(name);
        if (obj instanceof byte[]) {
            return this.readStringFromMetaData((byte[])obj);
        }
        return null;
    }

    protected String readStringFromMetaData(byte[] value) {
        if (value == null) {
            return null;
        }
        return new String(value, Constants.DEFAULT_ENCODING_CHARSET);
    }

    protected void writeStringToMetaData(Map meta_data, String name, String value) {
        meta_data.put(name, this.writeStringToMetaData(value));
    }

    protected byte[] writeStringToMetaData(String value) {
        return value.getBytes(Constants.DEFAULT_ENCODING_CHARSET);
    }

    @Override
    public void print() {
        try {
            byte[] hash = this.getHash();
            System.out.println("name = " + this.torrent_name);
            System.out.println("announce url = " + this.announce_url);
            System.out.println("announce group = " + this.announce_group.getAnnounceURLSets().length);
            System.out.println("creation date = " + this.creation_date);
            System.out.println("creation by = " + this.created_by);
            System.out.println("comment = " + this.comment);
            System.out.println("hash = " + ByteFormatter.nicePrint(hash));
            System.out.println("piece length = " + this.getPieceLength());
            System.out.println("pieces = " + this.getNumberOfPieces());
            for (String key : this.additional_info_properties.keySet()) {
                Object value = this.additional_info_properties.get(key);
                System.out.println("info prop '" + key + "' = '" + (value instanceof byte[] ? new String((byte[])value, Constants.DEFAULT_ENCODING_CHARSET) : value) + "'");
            }
            for (String key : this.additional_properties.keySet()) {
                Object value = this.additional_properties.get(key);
                System.out.println("prop '" + key + "' = '" + (value instanceof byte[] ? new String((byte[])value, Constants.DEFAULT_ENCODING_CHARSET) : value) + "'");
            }
            if (this.pieces == null) {
                System.out.println("\tpieces = null");
            } else {
                int i = 0;
                while (i < this.pieces.length) {
                    System.out.println("\t" + ByteFormatter.nicePrint(this.pieces[i]));
                    ++i;
                }
            }
            int i = 0;
            while (i < this.files.length) {
                byte[][] path_comps = this.files[i].getPathComponents();
                String path_str = "";
                int j = 0;
                while (j < path_comps.length) {
                    path_str = String.valueOf(path_str) + (j == 0 ? "" : File.separator) + new String(path_comps[j], Constants.DEFAULT_ENCODING_CHARSET);
                    ++j;
                }
                System.out.println("\t" + path_str + " (" + this.files[i].getLength() + ")");
                ++i;
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void fireChanged(int type, Object data) {
        if (this.constructing) {
            return;
        }
        ArrayList<TOTorrentListener> to_fire = null;
        try {
            this.this_mon.enter();
            if (this.listeners != null) {
                to_fire = new ArrayList<TOTorrentListener>(this.listeners);
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (to_fire != null) {
            for (TOTorrentListener l : to_fire) {
                try {
                    l.torrentChanged(this, type, data);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        for (TOTorrentListener l : global_listeners) {
            try {
                l.torrentChanged(this, type, data);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addListener(TOTorrentListener l) {
        try {
            this.this_mon.enter();
            if (this.listeners == null) {
                this.listeners = new ArrayList<TOTorrentListener>();
            }
            this.listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(TOTorrentListener l) {
        try {
            this.this_mon.enter();
            if (this.listeners != null) {
                this.listeners.remove(l);
                if (this.listeners.size() == 0) {
                    this.listeners = null;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    @Override
    public String getRelationText() {
        return "Torrent: '" + new String(this.torrent_name) + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        try {
            return new Object[]{CoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
        }
        catch (Exception exception) {
            return null;
        }
    }
}

