/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.StringInterner;
import java.io.File;

public class TorrentOpenFileOptions {
    private final TorrentOpenOptions torrentOptions;
    private final TOTorrentFile tfile;
    private String orgParent;
    private String orgFileName;
    private boolean toDownload;
    private int priority;
    private boolean priority_auto;
    private String destFileName;
    private String destPathName;
    private boolean didManualRename;
    private boolean isValid;

    public TorrentOpenFileOptions(TorrentOpenOptions parent, TOTorrentFile tfile, boolean wanted) {
        this.torrentOptions = parent;
        this.tfile = tfile;
        this.setOriginalFileNames();
        this.setToDownload(wanted);
        this.isValid = true;
    }

    protected void setOriginalFileNames() {
        String fileStr = this.tfile.getRelativePath();
        File file = FileUtil.newFile(fileStr, new String[0]);
        String parent = file.getParent();
        this.orgParent = parent == null || parent.isEmpty() ? null : StringInterner.intern(parent);
        this.orgFileName = file.getName();
    }

    public TorrentOpenOptions getTorrentOptions() {
        return this.torrentOptions;
    }

    public int getIndex() {
        return this.tfile.getIndex();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean b) {
        this.isValid = b;
    }

    public long getSize() {
        return this.tfile.getLength();
    }

    public String getOriginalFullName() {
        if (this.orgParent == null) {
            return this.orgFileName;
        }
        return String.valueOf(this.orgParent) + File.separator + this.orgFileName;
    }

    public String getOriginalFileName() {
        return this.orgFileName;
    }

    public void setFullDestName(String newFullName) {
        if (newFullName == null) {
            this.setDestPathName(null);
            this.setDestFileName(null, true);
            return;
        }
        File newPath = FileUtil.newFile(newFullName, new String[0]);
        this.setDestPathName(newPath.getParent());
        this.setDestFileName(newPath.getName(), true);
    }

    public void setDestPathName(String newPath) {
        if (this.torrentOptions.getTorrent().isSimpleTorrent()) {
            this.torrentOptions.setParentDir(newPath);
        } else {
            this.destPathName = newPath;
        }
    }

    public void setDestFileName(String newFileName, boolean manualRename) {
        if (this.orgFileName.equals(newFileName)) {
            this.destFileName = null;
            this.didManualRename = false;
        } else {
            this.destFileName = newFileName;
            this.didManualRename = manualRename;
        }
    }

    public String getDestPathName() {
        if (this.destPathName != null) {
            return this.destPathName;
        }
        if (this.torrentOptions.getTorrent().isSimpleTorrent()) {
            return this.torrentOptions.getParentDir();
        }
        return FileUtil.newFile(this.torrentOptions.getDataDir(), this.getOriginalFullName()).getParent();
    }

    public boolean isManualRename() {
        return this.didManualRename;
    }

    public String getDestFileName() {
        return this.destFileName == null ? this.orgFileName : this.destFileName;
    }

    public File getDestFileFullName() {
        String path = this.getDestPathName();
        String file = this.getDestFileName();
        return FileUtil.newFile(path, file);
    }

    public boolean okToDisable() {
        return this.torrentOptions.okToDisableAll();
    }

    public File getInitialLink() {
        return this.torrentOptions.getInitialLinkage(this.getIndex());
    }

    public boolean isLinked() {
        return this.destFileName != null || this.destPathName != null;
    }

    public boolean isToDownload() {
        return this.toDownload;
    }

    public void setToDownload(boolean toDownload) {
        this.toDownload = toDownload;
        this.torrentOptions.fileDownloadStateChanged(this, toDownload);
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isPriorityAuto() {
        return this.priority_auto;
    }

    public void setPriority(int _priority, boolean _auto) {
        this.priority_auto = _auto;
        this.priority = _priority;
        this.torrentOptions.filePriorityStateChanged(this, _priority);
    }
}

