/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.config.impl.ConfigurationParameterNotFoundException;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerInitialisationAdapter;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenFileOptions;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TorrentOpenOptions {
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String PARAM_MOVEWHENDONE = "Move Completed When Done";
    private static final String PARAM_QUEUEPOSITION = "Add Torrent Queue Position";
    public static final int QUEUELOCATION_TOP = 0;
    public static final int QUEUELOCATION_BOTTOM = 1;
    public static final int QUEUELOCATION_AUTO = 2;
    public static final String[] STARTMODE_KEYS = new String[]{"OpenTorrentWindow.startMode.queuedstarted", "OpenTorrentWindow.startMode.stopped", "ManagerItem.paused", "OpenTorrentWindow.startMode.forceStarted", "OpenTorrentWindow.startMode.seeding", "OpenTorrentWindow.startMode.alloc.stopped", "OpenTorrentWindow.startMode.alloc.paused"};
    public static final int STARTMODE_QUEUED = 0;
    public static final int STARTMODE_STOPPED = 1;
    public static final int STARTMODE_PAUSED = 2;
    public static final int STARTMODE_FORCESTARTED = 3;
    public static final int STARTMODE_SEEDING = 4;
    public static final int STARTMODE_ALLOCATED_AND_STOPPED = 5;
    public static final int STARTMODE_ALLOCATED_AND_PAUSED = 6;
    public static final int[] STARTMODE_VALUES;
    public String sOriginatingLocation;
    private String sFileName;
    private String sDestDir;
    private String manualRename;
    private String sDestSubDir;
    private boolean explicitDataDir;
    private boolean removedTopLevel;
    private boolean disableAutoRename;
    private TOTorrent torrent;
    private long totalSize;
    private int iStartID;
    private int iQueueLocation;
    private boolean bSequentialDownload;
    public boolean isValid;
    private volatile boolean cancelDisabled;
    private boolean bDeleteFileOnCancel;
    private boolean bDeleteFileOnCancelSet;
    private TorrentOpenFileOptions[] files = null;
    public boolean disableIPFilter = false;
    private Map<Integer, File> initial_linkage_map = null;
    private final CopyOnWriteList<FileListener> fileListeners = new CopyOnWriteList(1);
    public Map<String, Boolean> peerSource = new HashMap<String, Boolean>();
    private Map<String, Boolean> enabledNetworks = new HashMap<String, Boolean>();
    private String userComment;
    private List<Tag> initialTags = new ArrayList<Tag>();
    private Set<Tag> autoTags = new HashSet<Tag>();
    private List<String> swarmTags = new ArrayList<String>();
    private boolean autoTaggingApplied;
    private Map<String, Object> initialMetadata;
    private List<List<String>> updatedTrackers;
    private int max_up;
    private int max_down;
    private File move_on_complete;
    private boolean hide_errors;
    public static final int CA_NONE = 0;
    public static final int CA_ACCEPT = 1;
    public static final int CA_REJECT = 2;
    private int complete_action = 0;
    private boolean dirty;

    static {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        STARTMODE_VALUES = nArray;
    }

    public TorrentOpenOptions(String sFileName, TOTorrent torrent, boolean bDeleteFileOnCancel, Map<String, Object> options) {
        this(options);
        this.bDeleteFileOnCancel = bDeleteFileOnCancel;
        this.bDeleteFileOnCancelSet = true;
        this.sFileName = sFileName;
        this.sOriginatingLocation = sFileName;
        this.setTorrent(torrent);
    }

    public TorrentOpenOptions(Map<String, Object> options) {
        this.iStartID = TorrentOpenOptions.getDefaultStartMode();
        this.iQueueLocation = this.getAutoQueuePositionTime() > 0L ? 2 : this.getDefaultQueueLocation();
        this.bSequentialDownload = false;
        this.isValid = true;
        if (options != null) {
            this.sDestDir = (String)options.get("defaultSavePath");
        }
        if (this.sDestDir == null) {
            this.sDestDir = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH);
        }
        int i = 0;
        while (i < AENetworkClassifier.AT_NETWORKS.length) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Network Selection Default." + nn;
            this.enabledNetworks.put(nn, COConfigurationManager.getBooleanParameter(config_name));
            ++i;
        }
    }

    private TorrentOpenOptions(Map<String, Object> map, boolean fake) {
        List init_tags;
        this.isValid = true;
        this.iStartID = MapUtils.getMapInt(map, "startid", 0);
        this.iQueueLocation = MapUtils.getMapInt(map, "qloc", 1);
        this.bSequentialDownload = MapUtils.getMapBoolean(map, "seqdl", false);
        this.sDestDir = MapUtils.getMapString(map, "destdir", COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH));
        int i = 0;
        while (i < AENetworkClassifier.AT_NETWORKS.length) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Network Selection Default." + nn;
            this.enabledNetworks.put(nn, COConfigurationManager.getBooleanParameter(config_name));
            ++i;
        }
        List l_networks = (List)map.get("networks");
        if (l_networks != null) {
            for (Map o_net : l_networks) {
                int val;
                String net = MapUtils.getMapString(o_net, "n", null);
                if ((net = AENetworkClassifier.internalise(net)) == null || (val = MapUtils.getMapInt(o_net, "e", -1)) < 0) continue;
                this.enabledNetworks.put(net, val > 0);
            }
        }
        this.bDeleteFileOnCancel = MapUtils.getMapBoolean(map, "dfoc", false);
        this.bDeleteFileOnCancelSet = MapUtils.getMapBoolean(map, "dfocs", false);
        this.sFileName = MapUtils.getMapString(map, "filename", null);
        this.sOriginatingLocation = MapUtils.getMapString(map, "origloc", null);
        Map t_map = (Map)map.get("torrent");
        if (t_map != null) {
            try {
                File file;
                this.torrent = TOTorrentFactory.deserialiseFromMap(t_map);
                String file_str = TorrentUtils.getTorrentFileName(this.torrent);
                if (file_str != null && !(file = FileUtil.newFile(file_str, new String[0])).exists()) {
                    TorrentUtils.writeToFile(this.torrent);
                }
                this.setTorrent(this.torrent);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if ((init_tags = (List)map.get("inittags")) != null) {
            TagManager tm = TagManagerFactory.getTagManager();
            for (Number n : init_tags) {
                Tag tag = tm.lookupTagByUID(n.longValue());
                if (tag == null) continue;
                this.initialTags.add(tag);
            }
        }
    }

    public Map<String, Object> exportToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MapUtils.setMapInt(map, "startid", this.iStartID);
        MapUtils.setMapInt(map, "qloc", this.iQueueLocation);
        MapUtils.setMapBoolean(map, "seqdl", this.bSequentialDownload);
        MapUtils.setMapString(map, "destdir", this.sDestDir);
        if (!this.enabledNetworks.isEmpty()) {
            ArrayList l_networks = new ArrayList(this.enabledNetworks.size());
            for (Map.Entry<String, Boolean> entry : this.enabledNetworks.entrySet()) {
                HashMap m = new HashMap();
                l_networks.add(m);
                MapUtils.setMapString(m, "n", entry.getKey());
                MapUtils.setMapBoolean(m, "e", entry.getValue());
            }
            map.put("networks", l_networks);
        }
        MapUtils.setMapBoolean(map, "dfoc", this.bDeleteFileOnCancel);
        MapUtils.setMapBoolean(map, "dfocs", this.bDeleteFileOnCancelSet);
        MapUtils.setMapString(map, "filename", this.sFileName);
        MapUtils.setMapString(map, "origloc", this.sOriginatingLocation);
        if (this.torrent == null) {
            Debug.out("derp");
        } else {
            try {
                map.put("torrent", this.torrent.serialiseToMap());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (!this.initialTags.isEmpty()) {
            ArrayList<Long> l_tags = new ArrayList<Long>();
            for (Tag tag : this.initialTags) {
                l_tags.add(tag.getTagUID());
            }
            map.put("inittags", l_tags);
        }
        return map;
    }

    public static TorrentOpenOptions importFromMap(Map<String, Object> map) {
        return new TorrentOpenOptions(map, true);
    }

    private TorrentOpenOptions(TorrentOpenOptions toBeCloned) {
        this.sOriginatingLocation = toBeCloned.sOriginatingLocation;
        this.sFileName = toBeCloned.sFileName;
        this.sDestDir = toBeCloned.sDestDir;
        this.sDestSubDir = toBeCloned.sDestSubDir;
        this.iStartID = toBeCloned.iStartID;
        this.iQueueLocation = toBeCloned.iQueueLocation;
        this.bSequentialDownload = toBeCloned.bSequentialDownload;
        this.isValid = toBeCloned.isValid;
        this.bDeleteFileOnCancel = toBeCloned.bDeleteFileOnCancel;
        this.bDeleteFileOnCancelSet = toBeCloned.bDeleteFileOnCancelSet;
        this.disableIPFilter = toBeCloned.disableIPFilter;
        this.peerSource = toBeCloned.peerSource == null ? null : new HashMap<String, Boolean>(toBeCloned.peerSource);
        this.enabledNetworks = toBeCloned.enabledNetworks == null ? null : new HashMap<String, Boolean>(toBeCloned.enabledNetworks);
        this.userComment = toBeCloned.userComment;
        this.initialTags = toBeCloned.initialTags == null ? null : new ArrayList<Tag>(toBeCloned.initialTags);
        this.autoTags = toBeCloned.autoTags == null ? null : new HashSet<Tag>(toBeCloned.autoTags);
        this.initialMetadata = BEncoder.cloneMap(toBeCloned.initialMetadata);
        if (toBeCloned.updatedTrackers != null) {
            this.updatedTrackers = new ArrayList<List<String>>();
            for (List<String> l : toBeCloned.updatedTrackers) {
                this.updatedTrackers.add(new ArrayList<String>(l));
            }
        }
        this.max_up = toBeCloned.max_up;
        this.max_down = toBeCloned.max_down;
        this.move_on_complete = toBeCloned.move_on_complete;
        this.hide_errors = toBeCloned.hide_errors;
    }

    public TorrentOpenOptions getClone() {
        return new TorrentOpenOptions(this);
    }

    public static int getDefaultStartMode() {
        return COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped") ? 1 : 0;
    }

    public File getInitialLinkage(int index) {
        return this.initial_linkage_map == null ? null : this.initial_linkage_map.get(index);
    }

    public String getParentDir() {
        return this.sDestDir;
    }

    public void setParentDir(String parentDir) {
        this.sDestDir = parentDir;
        this.parentDirChanged();
    }

    public void setManualRename(String manualRename) {
        this.manualRename = manualRename;
    }

    public String getManualRename() {
        return this.manualRename;
    }

    public void setDeleteFileOnCancel(boolean b) {
        this.bDeleteFileOnCancel = b;
        this.bDeleteFileOnCancelSet = true;
    }

    public void deleteTorrent() {
        if (this.bDeleteFileOnCancel) {
            File torrentFile = FileUtil.newFile(this.sFileName, new String[0]);
            TorrentUtils.delete(torrentFile, true);
        }
    }

    public String getDefaultSubDir() {
        if (this.isSimpleTorrent()) {
            return null;
        }
        return FileUtil.convertOSSpecificChars(this.getTorrentName(), true);
    }

    public String getSubDir() {
        return this.sDestSubDir;
    }

    public void setSubDir(String str) {
        this.sDestSubDir = str;
        if (str == null) {
            this.explicitDataDir = false;
        }
        this.parentDirChanged();
    }

    public void setExplicitDataDir(String parent_dir, String sub_dir, boolean _removedTopLevel) {
        this.sDestDir = parent_dir;
        this.sDestSubDir = sub_dir;
        this.explicitDataDir = true;
        this.removedTopLevel = _removedTopLevel;
        this.parentDirChanged();
    }

    public boolean isExplicitDataDir() {
        return this.explicitDataDir;
    }

    public boolean isRemovedTopLevel() {
        return this.removedTopLevel;
    }

    public void setDisableAutoRename(boolean b) {
        this.disableAutoRename = b;
    }

    public boolean isSimpleTorrent() {
        return this.torrent.isSimpleTorrent();
    }

    public int getStartMode() {
        return this.iStartID;
    }

    public void setStartMode(int m) {
        if (this.iStartID != m) {
            this.iStartID = m;
            this.startOptionsChanged();
        }
    }

    public int getDefaultQueueLocation() {
        return COConfigurationManager.getIntParameter(PARAM_QUEUEPOSITION, 1);
    }

    public int getQueueLocation() {
        return this.iQueueLocation;
    }

    public void setQueueLocation(int l) {
        if (this.iQueueLocation != l) {
            this.iQueueLocation = l;
            if (this.iQueueLocation != 2) {
                COConfigurationManager.setParameter(PARAM_QUEUEPOSITION, l);
            }
            this.startOptionsChanged();
        }
    }

    public boolean getSequentialDownload() {
        return this.bSequentialDownload;
    }

    public void setSequentialDownload(boolean b) {
        if (b != this.bSequentialDownload) {
            this.bSequentialDownload = b;
            this.startOptionsChanged();
        }
    }

    public Map<String, Boolean> getEnabledNetworks() {
        return new HashMap<String, Boolean>(this.enabledNetworks);
    }

    public boolean getNetworkEnabled(String net) {
        return this.enabledNetworks.get(net);
    }

    public void setNetworkEnabled(String net, boolean enabled) {
        this.enabledNetworks.put(net, enabled);
    }

    public String getUserComment() {
        return this.userComment;
    }

    public void setUserComment(String str) {
        this.userComment = str;
    }

    public String getDataDir() {
        if (this.torrent.isSimpleTorrent()) {
            return this.sDestDir;
        }
        return FileUtil.newFile(this.sDestDir, this.sDestSubDir == null ? this.getDefaultSubDir() : this.sDestSubDir).getPath();
    }

    private String getSmartDestDir() {
        String sSmartDir = this.sDestDir;
        try {
            int iMatchLevel;
            String name = this.getTorrentName();
            String torrentFileName = this.sFileName == null ? "" : FileUtil.newFile(this.sFileName, new String[0]).getName().replaceFirst("\\.torrent$", "");
            int totalSegmentsLengths = 0;
            String[][] segments = new String[][]{name.split("[^a-zA-Z]+"), torrentFileName.split("[^a-zA-Z]+")};
            List<DownloadManager> downloadManagers = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
            int x = 0;
            while (x < segments.length) {
                String[] segmentArray = segments[x];
                int i = 0;
                while (i < segmentArray.length) {
                    int l = segmentArray[i].length();
                    if (l > 1) {
                        segmentArray[i] = segmentArray[i].toLowerCase();
                        totalSegmentsLengths += l;
                    }
                    ++i;
                }
                ++x;
            }
            int maxMatches = 0;
            DownloadManager match = null;
            long scanStarted = SystemTime.getCurrentTime();
            for (DownloadManager dm : downloadManagers) {
                DownloadManagerState dms;
                if (dm.getState() == 100 || (dms = dm.getDownloadState()).getFlag(16L) || dms.getFlag(512L)) continue;
                int numMatches = 0;
                String dmName = dm.getDisplayName().toLowerCase();
                int x2 = 0;
                while (x2 < segments.length) {
                    String[] segmentArray = segments[x2];
                    int i = 0;
                    while (i < segmentArray.length) {
                        String segment;
                        int l = segmentArray[i].length();
                        if (l > 1 && dmName.contains(segment = segmentArray[i])) {
                            numMatches += l;
                        }
                        ++i;
                    }
                    ++x2;
                }
                if (numMatches > maxMatches) {
                    maxMatches = numMatches;
                    match = dm;
                }
                long scanTime = SystemTime.getCurrentTime() - scanStarted;
                if (match != null && scanTime > 500L || match == null && scanTime > 1000L) break;
            }
            if (match != null && (iMatchLevel = maxMatches * 100 / totalSegmentsLengths) >= 30) {
                File f = match.getSaveLocation();
                if (!f.isDirectory() || match.getDiskManagerFileInfo().length > 1) {
                    f = f.getParentFile();
                }
                if (f != null && f.isDirectory()) {
                    sSmartDir = f.getAbsolutePath();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sSmartDir.length() == 0) {
            try {
                return ConfigurationDefaults.getInstance().getStringParameter(PARAM_DEFSAVEPATH);
            }
            catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
                // empty catch block
            }
        }
        return sSmartDir;
    }

    public List<Tag> getInitialTags() {
        this.applyAutoTagging();
        return new ArrayList<Tag>(this.initialTags);
    }

    public void setInitialTags(List<Tag> tags) {
        this.initialTags = new ArrayList<Tag>(tags);
    }

    public void addSwarmTag(String tag) {
        if (TagUtils.isInternalTagName(tag)) {
            return;
        }
        if (!this.swarmTags.contains(tag)) {
            this.swarmTags.add(tag);
        }
    }

    public long getAutoQueuePositionTime() {
        Long addedTime;
        if (COConfigurationManager.getBooleanParameter("Plugin.Magnet URI Handler.MagnetPlugin.dl.position.from.mag.time") && this.initialMetadata != null && (addedTime = (Long)this.initialMetadata.get("added_time")) != null) {
            return addedTime;
        }
        return -1L;
    }

    public Map<String, Object> getInitialMetadata() {
        return this.initialMetadata;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean getAndClearDirt() {
        boolean result = this.dirty;
        this.dirty = false;
        return result;
    }

    public List<List<String>> getTrackers(boolean if_updated) {
        if (this.updatedTrackers != null) {
            return this.updatedTrackers;
        }
        if (if_updated) {
            return null;
        }
        if (this.torrent == null) {
            return new ArrayList<List<String>>(0);
        }
        return TorrentUtils.announceGroupsToList(this.torrent);
    }

    public void setTrackers(List<List<String>> trackers) {
        this.updatedTrackers = trackers;
    }

    public void setMaxUploadSpeed(int kbs) {
        this.max_up = kbs;
    }

    public int getMaxUploadSpeed() {
        return this.max_up;
    }

    public void setMaxDownloadSpeed(int kbs) {
        this.max_down = kbs;
    }

    public int getMaxDownloadSpeed() {
        return this.max_down;
    }

    public File getMoveOnComplete() {
        return this.move_on_complete;
    }

    public void setMoveOnComplete(File f) {
        this.move_on_complete = f;
    }

    public void setHideErrors(boolean h) {
        this.hide_errors = h;
    }

    public boolean getHideErrors() {
        return this.hide_errors;
    }

    public TorrentOpenFileOptions[] getFiles() {
        if (this.files == null && this.torrent != null) {
            this.files = new TorrentOpenFileOptions[this.torrent.getFiles().length];
            this.applyPriorityAndSkipConfig();
        }
        return this.files;
    }

    public void rebuildOriginalNames() {
        if (this.files == null) {
            return;
        }
        int i = 0;
        while (i < this.files.length) {
            if (this.files[i] != null) {
                this.files[i].setOriginalFileNames();
            }
            ++i;
        }
    }

    public void applyPriorityAndSkipConfig() {
        if (this.torrent == null) {
            return;
        }
        boolean[] skip = TorrentUtils.getSkipFiles(this.torrent);
        Set<String> priority_file_exts = TorrentUtils.getFilePriorityExtensions();
        boolean priority_file_exts_ignore_case = TorrentUtils.getFilePriorityExtensionsIgnoreCase();
        TOTorrentFile[] tfiles = this.torrent.getFiles();
        if (skip == null) {
            skip = new boolean[tfiles.length];
        }
        int i = 0;
        while (i < tfiles.length) {
            String ext;
            int separator;
            TOTorrentFile torrentFile = tfiles[i];
            boolean wanted = !skip[i];
            TorrentOpenFileOptions file = this.files[i];
            if (file == null) {
                file = this.files[i] = new TorrentOpenFileOptions(this, torrentFile, wanted);
            } else {
                file.setToDownload(wanted);
            }
            boolean auto = false;
            if (!priority_file_exts.isEmpty() && (separator = (ext = file.getOriginalFileName()).lastIndexOf(".")) != -1) {
                ext = ext.substring(separator);
                if (priority_file_exts_ignore_case) {
                    ext = ext.toLowerCase(Locale.US);
                }
                if (priority_file_exts.contains(ext)) {
                    file.setPriority(1, true);
                    auto = true;
                }
            }
            if (!auto && file.isPriorityAuto()) {
                file.setPriority(0, false);
            }
            ++i;
        }
        this.applyAutoTagging();
    }

    public boolean canDeselectTag(Tag tag) {
        if (this.autoTags.contains(tag)) {
            return COConfigurationManager.getBooleanParameter("Files Auto Tag Mod Enable");
        }
        return true;
    }

    public void applyAutoTagging() {
        Tag tag;
        TorrentOpenFileOptions[] files;
        if (!COConfigurationManager.getBooleanParameter("Files Auto Tag Enable")) {
            return;
        }
        if (COConfigurationManager.getBooleanParameter("Files Auto Tag Mod Enable") && this.autoTaggingApplied) {
            return;
        }
        this.autoTaggingApplied = true;
        HashMap<String, long[]> ext_map = new HashMap<String, long[]>();
        TorrentOpenFileOptions[] torrentOpenFileOptionsArray = files = this.getFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String ext;
            String name;
            int pos;
            TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
            if (file.isToDownload() && (pos = (name = file.getOriginalFileName()).lastIndexOf(46)) != -1 && !(ext = name.substring(pos + 1).trim().toLowerCase(Locale.US)).isEmpty()) {
                long file_size = file.getSize();
                long[] size = (long[])ext_map.get(ext);
                if (size == null) {
                    ext_map.put(ext, new long[]{file_size});
                } else {
                    size[0] = size[0] + file_size;
                }
            }
            ++n2;
        }
        int num = COConfigurationManager.getIntParameter("Files Auto Tag Count");
        TagManager tm = TagManagerFactory.getTagManager();
        TagType tag_type = tm.getTagType(3);
        ArrayList<Tag> matched_tags = new ArrayList<Tag>();
        Tag max_match_tag = null;
        long max_match_size = -1L;
        int i = 0;
        while (i < num) {
            String exts = COConfigurationManager.getStringParameter("File Auto Tag Exts " + (i == 0 ? "" : " " + i), "");
            if (!(exts = exts.trim().toLowerCase(Locale.US)).isEmpty()) {
                String tag_name = COConfigurationManager.getStringParameter("File Auto Tag Name " + (i == 0 ? "" : " " + i), "");
                if (!(tag_name = tag_name.trim()).isEmpty()) {
                    try {
                        tag = tag_type.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tag_type.createTag(tag_name, true);
                            tag.setPublic(false);
                        }
                        String[] bits = exts.replaceAll(",", ";").split(";");
                        boolean matched = false;
                        long max_match = 0L;
                        String[] stringArray = bits;
                        int n3 = bits.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            long[] size;
                            String bit = stringArray[n4];
                            if ((bit = bit.trim()).startsWith(".")) {
                                bit = bit.substring(1);
                            }
                            if ((size = (long[])ext_map.get(bit)) != null) {
                                matched = true;
                                if (size[0] > max_match) {
                                    max_match = size[0];
                                }
                            }
                            ++n4;
                        }
                        if (matched) {
                            matched_tags.add(tag);
                            if (max_match > max_match_size) {
                                max_match_size = max_match;
                                max_match_tag = tag;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            ++i;
        }
        this.initialTags.removeAll(this.autoTags);
        HashSet<Tag> oldAutoTags = new HashSet<Tag>(this.autoTags);
        this.autoTags.clear();
        ArrayList<Tag> selected_tags = new ArrayList<Tag>();
        if (matched_tags.isEmpty()) {
            String def_tag = COConfigurationManager.getStringParameter("File Auto Tag Name Default", "");
            if (!(def_tag = def_tag.trim()).isEmpty()) {
                try {
                    tag = tag_type.getTag(def_tag, true);
                    if (tag == null) {
                        tag = tag_type.createTag(def_tag, true);
                        tag.setPublic(false);
                    }
                    selected_tags.add(tag);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        } else {
            boolean tag_best = COConfigurationManager.getBooleanParameter("Files Auto Tag Best Size");
            if (tag_best) {
                selected_tags.add(max_match_tag);
            } else {
                selected_tags.addAll(matched_tags);
            }
        }
        for (Tag t : selected_tags) {
            if (this.initialTags.contains(t)) continue;
            this.initialTags.add(t);
        }
        this.autoTags.addAll(selected_tags);
        if (!oldAutoTags.equals(this.autoTags)) {
            this.initialTagsChanged();
        }
    }

    public long getTotalSize() {
        TorrentOpenFileOptions[] files;
        if (this.totalSize == 0L && (files = this.getFiles()) != null) {
            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
                this.totalSize += file.getSize();
                ++n2;
            }
        }
        return this.totalSize;
    }

    public String getTorrentName() {
        return TorrentUtils.getLocalisedName(this.torrent);
    }

    private void updateTorrentFileName(String name) {
        block6: {
            try {
                File existing = FileUtil.newFile(TorrentUtils.getTorrentFileName(this.torrent), new String[0]);
                File folder = existing.getParentFile();
                String old_name = existing.getName();
                String new_name = String.valueOf(FileUtil.convertOSSpecificChars(name, false)) + ".torrent";
                if (new_name.equals(old_name)) break block6;
                String prefix = "";
                int i = 0;
                while (i < 16) {
                    File new_file = FileUtil.newFile(folder, String.valueOf(prefix) + new_name);
                    if (!new_file.exists()) {
                        try {
                            TorrentUtils.writeToFile(this.torrent, new_file, false);
                            this.sFileName = new_file.getAbsolutePath();
                            TorrentUtils.delete(existing, true);
                            break;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    prefix = String.valueOf(prefix) + "_";
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public String getDisplayName() {
        String title = this.getTorrentName();
        if (this.torrent != null) {
            String str = TorrentUtils.getDisplayName(this.torrent);
            if (str == null) {
                str = PlatformTorrentUtils.getContentTitle(this.torrent);
            }
            if (str != null && str.length() > 0) {
                title = str;
            }
        }
        return title;
    }

    public void setDisplayName(String name) {
        if (this.torrent != null) {
            TorrentUtils.setDisplayName(this.torrent, name);
            this.updateTorrentFileName(name);
        } else {
            Debug.out("Can't update display name, no torrent");
        }
    }

    public boolean allFilesMoving() {
        TorrentOpenFileOptions[] files = this.getFiles();
        int j = 0;
        while (j < files.length) {
            if (files[j].isLinked()) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean allFilesExist() {
        TorrentOpenFileOptions[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            File file;
            TorrentOpenFileOptions fileInfo2 = files[i];
            if (fileInfo2.isToDownload() && (!(file = fileInfo2.getDestFileFullName()).exists() || file.length() != fileInfo2.getSize())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void renameDuplicates() {
        if (this.iStartID == 4 || !COConfigurationManager.getBooleanParameter("DefaultDir.AutoSave.AutoRename") || this.allFilesExist()) {
            return;
        }
        if (this.disableAutoRename) {
            return;
        }
        List<DownloadManager> managers = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        HashSet<String> toAvoid = new HashSet<String>();
        try {
            for (DownloadManager manager : managers) {
                File f = manager.getSaveLocation();
                if (f.exists()) continue;
                toAvoid.add(f.getAbsolutePath());
            }
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                List<TorrentOpenOptions> opts = uif.getTorrentOptions();
                for (TorrentOpenOptions opt : opts) {
                    if (opt == this) continue;
                    if (opt.isSimpleTorrent()) {
                        TorrentOpenFileOptions[] fileInfos = opt.getFiles();
                        toAvoid.add(fileInfos[0].getDestFileFullName().getAbsolutePath());
                        continue;
                    }
                    toAvoid.add(opt.getDataDir());
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (!this.torrent.isSimpleTorrent()) {
            String dataDir = this.getDataDir();
            if (FileUtil.newFile(dataDir, new String[0]).isDirectory() || toAvoid.contains(dataDir)) {
                File f;
                int idx = 0;
                while ((f = FileUtil.newFile(String.valueOf(dataDir) + "-" + ++idx, new String[0])).isDirectory() || toAvoid.contains(f.getAbsolutePath())) {
                }
                this.sDestSubDir = f.getName();
            }
        } else {
            TorrentOpenFileOptions[] fileInfos = this.getFiles();
            int i = 0;
            while (i < fileInfos.length) {
                TorrentOpenFileOptions info = fileInfos[i];
                File file = info.getDestFileFullName();
                int idx = 0;
                while (file.exists() || toAvoid.contains(file.getAbsolutePath())) {
                    file = FileUtil.newFile(info.getDestPathName(), String.valueOf(++idx) + "-" + info.getDestFileName());
                }
                info.setDestFileName(file.getName(), false);
                ++i;
            }
        }
    }

    public boolean okToDisableAll() {
        return true;
    }

    public String getTorrentFile() {
        return this.sFileName;
    }

    public void setTorrentFile(String str) {
        this.sFileName = str;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent torrent) {
        try {
            if (torrent.isSimpleTorrent() && COConfigurationManager.getBooleanParameter("Always Create Torrent Sub-Folder")) {
                String file = TorrentUtils.getTorrentFileName(torrent);
                torrent = torrent.setSimpleTorrentDisabled(true);
                if (file != null) {
                    TorrentUtils.writeToFile(torrent, new File(file), false);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this.torrent = torrent;
        if (COConfigurationManager.getBooleanParameter("DefaultDir.BestGuess") && !COConfigurationManager.getBooleanParameter(PARAM_MOVEWHENDONE)) {
            this.sDestDir = this.getSmartDestDir();
        }
        if (torrent == null) {
            this.initial_linkage_map = null;
        } else {
            List<String> it;
            int n;
            this.initial_linkage_map = TorrentUtils.getInitialLinkage(torrent);
            try {
                LocaleTorrentUtil.getTorrentEncoding(torrent, true, COConfigurationManager.getBooleanParameter("File.Decoder.Prompt"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Set<String> tracker_hosts = TorrentUtils.getUniqueTrackerHosts(torrent);
            HashSet<String> networks = new HashSet<String>();
            boolean decentralised = false;
            for (String host : tracker_hosts) {
                if (TorrentUtils.isDecentralised(host)) {
                    decentralised = true;
                    continue;
                }
                String network = AENetworkClassifier.categoriseAddress(host);
                networks.add(network);
            }
            boolean enable_i2p = networks.contains("I2P");
            List<String> network_cache = TorrentUtils.getNetworkCache(torrent);
            if (network_cache.size() > 0) {
                String to_remove = null;
                for (String net : this.enabledNetworks.keySet()) {
                    boolean enabled = network_cache.contains(net);
                    if (enabled || net != "Public") continue;
                    to_remove = net;
                }
                if (to_remove != null) {
                    this.enabledNetworks.put(to_remove, false);
                }
            }
            networks.addAll(network_cache);
            String enable_i2p_reason = null;
            if (enable_i2p) {
                enable_i2p_reason = MessageText.getString("azneti2phelper.install.reason.i2ptracker");
            } else if (tracker_hosts.size() == 1) {
                // empty if block
            }
            if (this.enabledNetworks.get("I2P").booleanValue()) {
                enable_i2p = true;
            }
            if (enable_i2p) {
                String[] providers = new String[]{"azneti2p", "azneti2phelper"};
                boolean found = false;
                String[] stringArray = providers;
                n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    String provider = stringArray[n2];
                    if (CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(provider) != null) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) {
                    this.enabledNetworks.put("I2P", true);
                    if (networks.contains("I2P") && networks.size() == 1) {
                        this.enabledNetworks.put("Public", false);
                    }
                } else {
                    final boolean[] install_outcome = new boolean[1];
                    if (I2PHelpers.installI2PHelper(enable_i2p_reason, "azneti2phelper.install.open.torrent", install_outcome, new Runnable(){

                        @Override
                        public void run() {
                            boolean cfr_ignored_0 = install_outcome[0];
                        }
                    })) {
                        this.enabledNetworks.put("I2P", true);
                        if (networks.contains("I2P") && networks.size() == 1) {
                            this.enabledNetworks.put("Public", false);
                        }
                    }
                }
            }
            boolean enable_tor = networks.contains("Tor");
            String[] providers = new String[]{"aznettor"};
            boolean tor_found = false;
            String[] stringArray = providers;
            int n3 = providers.length;
            n = 0;
            while (n < n3) {
                String provider = stringArray[n];
                if (CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(provider) != null) {
                    tor_found = true;
                    break;
                }
                ++n;
            }
            if (enable_tor) {
                if (tor_found) {
                    this.enabledNetworks.put("Tor", true);
                    if (!networks.contains("Public")) {
                        this.enabledNetworks.put("Public", false);
                    }
                }
            } else if (enable_i2p && tor_found) {
                this.enabledNetworks.put("Tor", true);
            }
            if (!(it = TorrentUtils.getInitialTags(torrent)).isEmpty()) {
                try {
                    TagManager tm = TagManagerFactory.getTagManager();
                    for (String tag : it) {
                        Tag t = tm.getTagType(3).getTag(tag, true);
                        if (t == null) continue;
                        this.initialTags.add(t);
                    }
                }
                catch (Throwable tm) {
                    // empty catch block
                }
            }
            this.initialMetadata = TorrentUtils.getInitialMetadata(torrent);
            if (this.getAutoQueuePositionTime() > 0L) {
                this.iQueueLocation = 2;
            }
            this.renameDuplicates();
            String display_name = TorrentUtils.getDisplayName(torrent);
            if (display_name != null && COConfigurationManager.getBooleanParameter("Plugin.Magnet URI Handler.MagnetPlugin.rename.using.dn") && !display_name.startsWith("urlencode(")) {
                boolean do_it = true;
                if (torrent.isSimpleTorrent()) {
                    if (COConfigurationManager.getBooleanParameter("Plugin.Magnet URI Handler.MagnetPlugin.rename.using.dn.only.with.ext")) {
                        String ext;
                        do_it = false;
                        int pos = display_name.lastIndexOf(".");
                        if (pos != -1 && !(ext = display_name.substring(pos + 1).trim()).isEmpty()) {
                            do_it = true;
                        }
                    }
                    if (do_it) {
                        this.getFiles()[0].setDestFileName(FileUtil.convertOSSpecificChars(display_name, false), true);
                    }
                } else {
                    this.setExplicitDataDir(FileUtil.newFile(this.getDataDir(), new String[0]).getParentFile().getAbsolutePath(), FileUtil.convertOSSpecificChars(display_name, true), false);
                }
                if (do_it) {
                    this.updateTorrentFileName(display_name);
                }
            }
        }
    }

    public void addListener(FileListener l) {
        this.fileListeners.add(l);
    }

    public void removeListener(FileListener l) {
        this.fileListeners.remove(l);
    }

    public void fileDownloadStateChanged(TorrentOpenFileOptions torrentOpenFileOptions, boolean toDownload) {
        for (FileListener l : this.fileListeners) {
            try {
                l.toDownloadChanged(torrentOpenFileOptions, toDownload);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void filePriorityStateChanged(TorrentOpenFileOptions torrentOpenFileOptions, int priority) {
        for (FileListener l : this.fileListeners) {
            try {
                l.priorityChanged(torrentOpenFileOptions, priority);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void parentDirChanged() {
        for (FileListener l : this.fileListeners) {
            try {
                l.parentDirChanged();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void initialTagsChanged() {
        for (FileListener l : this.fileListeners) {
            try {
                l.initialTagsChanged();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void startOptionsChanged() {
        for (FileListener l : this.fileListeners) {
            try {
                l.startOptionsChanged();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void setCompleteAction(int ca) {
        this.complete_action = ca;
    }

    public int getCompleteAction() {
        return this.complete_action;
    }

    public void setCancelDisabled(boolean b) {
        this.cancelDisabled = b;
    }

    public void cancel() {
        if (this.cancelDisabled) {
            Debug.out("Cancel is disabled");
            return;
        }
        if ((this.bDeleteFileOnCancel || !this.bDeleteFileOnCancelSet) && this.sFileName != null) {
            try {
                File torrentFile = FileUtil.newFile(this.sFileName, new String[0]);
                if (this.bDeleteFileOnCancel) {
                    TorrentUtils.delete(torrentFile, true);
                } else if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
                    String save_dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                    if (torrentFile.getParentFile().getAbsolutePath().equals(FileUtil.newFile(save_dir, new String[0]).getAbsolutePath())) {
                        TorrentUtils.delete(torrentFile, true);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int addModePreCreate(int startMode) {
        int iStartState = startMode == 1 || startMode == 2 ? 70 : 75;
        return iStartState;
    }

    public static void addModeDuringCreate(int startMode, final DownloadManager dm) {
        if (startMode == 5 || startMode == 6) {
            dm.getDownloadState().setLongAttribute("fas", 2L);
            if (startMode == 6) {
                dm.addListener(new DownloadManagerAdapter(){

                    @Override
                    public void stateChanged(DownloadManager manager, int state) {
                        if (state == 70) {
                            dm.removeListener(this);
                            new AEThread2("pauser"){

                                @Override
                                public void run() {
                                    long start = SystemTime.getMonotonousTime();
                                    while (true) {
                                        if (dm.getState() == 70) {
                                            dm.pause(false);
                                            break;
                                        }
                                        if (SystemTime.getMonotonousTime() - start > 10000L) {
                                            Debug.out("Abandoning pause-on-start, timeout");
                                            break;
                                        }
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                }
                            }.start();
                        } else if (state == 50 || state == 60 || state == 100) {
                            dm.removeListener(this);
                        }
                    }
                });
            }
        }
    }

    public static void addModePostCreate(int startMode, DownloadManager dm) {
        if (startMode == 3) {
            dm.setForceStart(true);
        } else if (startMode == 2) {
            dm.pause(false);
        }
    }

    public boolean addToDownloadManager() {
        block4: {
            try {
                if (this.getTorrent() != null) break block4;
                return false;
            }
            catch (Exception e) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.showErrorMessage("OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{this.sOriginatingLocation, e.getMessage()});
                }
                return false;
            }
        }
        CoreFactory.addCoreRunningListener(core -> {
            long addedTime;
            TorrentOpenFileOptions[] files;
            final TOTorrent torrent = this.getTorrent();
            byte[] hash = null;
            try {
                hash = torrent.getHash();
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
            final int startMode = this.getStartMode();
            int iStartState = TorrentOpenOptions.addModePreCreate(startMode);
            GlobalManager gm = core.getGlobalManager();
            final String parentDir = this.getParentDir();
            String subDirORFile = this.getSubDir();
            if (torrent.isSimpleTorrent() && (files = this.getFiles())[0].isLinked()) {
                subDirORFile = FileUtil.convertOSSpecificChars(files[0].getDestFileName(), false);
            }
            DownloadManagerInitialisationAdapter dmia = new DownloadManagerInitialisationAdapter(){

                @Override
                public int getActions() {
                    return 1;
                }

                @Override
                public void initialised(DownloadManager dm, boolean for_seeding) {
                    DiskManagerFileInfoSet file_info_set = dm.getDiskManagerFileInfoSet();
                    DiskManagerFileInfo[] fileInfos = file_info_set.getFiles();
                    boolean reorder_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                    int reorder_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
                    DownloadManagerState dms = dm.getDownloadState();
                    File currentParentDir = dm.getSaveLocation().getParentFile();
                    boolean updateLinks = false;
                    if (!currentParentDir.equals(FileUtil.newFile(parentDir, new String[0]))) {
                        updateLinks = true;
                    }
                    boolean forSeeding = startMode == 4;
                    long pieceSize = torrent.getPieceLength();
                    try {
                        Map<String, Object> md;
                        String user_comment;
                        Map<String, Boolean> enabledNetworks;
                        int maxDown;
                        dms.suppressStateSave(true);
                        boolean[] toSkip = new boolean[fileInfos.length];
                        boolean[] toCompact = new boolean[fileInfos.length];
                        boolean[] toReorderCompact = new boolean[fileInfos.length];
                        int[] priorities = null;
                        int comp_num = 0;
                        int reorder_comp_num = 0;
                        TorrentOpenFileOptions[] files = TorrentOpenOptions.this.getFiles();
                        int iIndex = 0;
                        while (iIndex < fileInfos.length) {
                            DiskManagerFileInfo fileInfo2 = fileInfos[iIndex];
                            if (iIndex < files.length && files[iIndex].getSize() == fileInfo2.getLength()) {
                                File fDest = fileInfo2.getFile(true);
                                if (files[iIndex].isLinked()) {
                                    Object path;
                                    fDest = files[iIndex].getDestFileFullName();
                                    File fDestParent = fDest.getParentFile();
                                    if (updateLinks && ((String)(path = fDestParent.getAbsolutePath())).startsWith(parentDir)) {
                                        fDestParent = FileUtil.newFile(currentParentDir, ((String)path).substring(parentDir.length()));
                                    }
                                    fDest = new File(fDestParent, FileUtil.convertOSSpecificChars(fDest.getName(), false));
                                    dms.setFileLink(iIndex, fileInfo2.getFile(false), fDest);
                                }
                                if (files[iIndex].isToDownload()) {
                                    int priority = files[iIndex].getPriority();
                                    if (priority != 0) {
                                        if (priorities == null) {
                                            priorities = new int[fileInfos.length];
                                        }
                                        priorities[iIndex] = priority;
                                    }
                                } else {
                                    toSkip[iIndex] = true;
                                    if (fDest.exists()) {
                                        if (forSeeding && fDest.length() < 2L * pieceSize) {
                                            toCompact[iIndex] = true;
                                            ++comp_num;
                                        }
                                    } else if (reorder_mode && fileInfo2.getLength() / 0x100000L >= (long)reorder_mode_min_mb) {
                                        toReorderCompact[iIndex] = true;
                                        ++reorder_comp_num;
                                    } else {
                                        toCompact[iIndex] = true;
                                        ++comp_num;
                                    }
                                }
                            }
                            ++iIndex;
                        }
                        if (files.length == 1) {
                            String fileRename;
                            TorrentOpenFileOptions file = files[0];
                            if (file.isManualRename() && (fileRename = file.getDestFileName()) != null && fileRename.length() > 0) {
                                dms.setDisplayName(fileRename);
                            }
                        } else {
                            String folderRename = TorrentOpenOptions.this.getManualRename();
                            if (folderRename != null && folderRename.length() > 0) {
                                dms.setDisplayName(folderRename);
                            }
                        }
                        if (comp_num > 0) {
                            file_info_set.setStorageTypes(toCompact, 2);
                        }
                        if (reorder_comp_num > 0) {
                            file_info_set.setStorageTypes(toReorderCompact, 4);
                        }
                        file_info_set.setSkipped(toSkip, true);
                        if (priorities != null) {
                            file_info_set.setPriority(priorities);
                        }
                        int maxUp = TorrentOpenOptions.this.getMaxUploadSpeed();
                        int kInB = DisplayFormatters.getKinB();
                        if (maxUp > 0) {
                            dm.getStats().setUploadRateLimitBytesPerSecond(maxUp * kInB);
                        }
                        if ((maxDown = TorrentOpenOptions.this.getMaxDownloadSpeed()) > 0) {
                            dm.getStats().setDownloadRateLimitBytesPerSecond(maxDown * kInB);
                        }
                        if (TorrentOpenOptions.this.disableIPFilter) {
                            dms.setFlag(256L, true);
                        }
                        if (TorrentOpenOptions.this.peerSource != null) {
                            for (String peerSourceID : TorrentOpenOptions.this.peerSource.keySet()) {
                                boolean enable = TorrentOpenOptions.this.peerSource.get(peerSourceID);
                                dms.setPeerSourceEnabled(peerSourceID, enable);
                            }
                        }
                        if ((enabledNetworks = TorrentOpenOptions.this.getEnabledNetworks()) != null && !dms.getFlag(4096L)) {
                            for (String net : enabledNetworks.keySet()) {
                                boolean enable = enabledNetworks.get(net);
                                dms.setNetworkEnabled(net, enable);
                            }
                        }
                        if ((user_comment = TorrentOpenOptions.this.getUserComment()) != null && !user_comment.isEmpty()) {
                            dms.setUserComment(user_comment);
                        }
                        List<Tag> initialTags = TorrentOpenOptions.this.getInitialTags();
                        for (Tag t : initialTags) {
                            t.addTaggable(dm);
                        }
                        List<List<String>> trackers = TorrentOpenOptions.this.getTrackers(true);
                        if (trackers != null) {
                            TOTorrent torrent2 = dm.getTorrent();
                            TorrentUtils.listToAnnounceGroups(trackers, torrent2);
                            try {
                                TorrentUtils.writeToFile(torrent2);
                            }
                            catch (Throwable e2) {
                                Debug.printStackTrace(e2);
                            }
                        }
                        if (!TorrentOpenOptions.this.swarmTags.isEmpty()) {
                            dms.setListAttribute("stag", TorrentOpenOptions.this.swarmTags.toArray(new String[0]));
                        }
                        if (TorrentOpenOptions.this.getSequentialDownload()) {
                            dms.setFlag(8192L, true);
                        }
                        TorrentOpenOptions.addModeDuringCreate(TorrentOpenOptions.this.getStartMode(), dm);
                        File moc = TorrentOpenOptions.this.getMoveOnComplete();
                        if (moc != null) {
                            dms.setAttribute("moc.dir", moc.getAbsolutePath());
                        }
                        if ((md = TorrentOpenOptions.this.getInitialMetadata()) != null) {
                            TorrentUtils.setInitialMetadata(dm, md, true);
                        }
                    }
                    finally {
                        dms.suppressStateSave(false);
                    }
                }
            };
            DownloadManager dm = gm.addDownloadManager(this.getTorrentFile(), hash, parentDir, subDirORFile, iStartState, true, startMode == 4, dmia);
            if (dm == null) {
                return;
            }
            boolean position_set = false;
            int queueLoc = this.getQueueLocation();
            if (queueLoc == 2 && (addedTime = this.getAutoQueuePositionTime()) > 0L) {
                dm.getDownloadState().setLongAttribute("rdmmt", addedTime);
                List<DownloadManager> dms = gm.getDownloadManagers();
                DownloadManager dmBefore = null;
                long dmBeforeTime = -1L;
                DownloadManager dmAfter = null;
                long dmAfterTime = Long.MAX_VALUE;
                for (DownloadManager d : dms) {
                    DownloadManagerState ds;
                    if (d == dm || d.isDownloadComplete(false) || (ds = d.getDownloadState()).getFlag(512L)) continue;
                    long t = ds.getLongAttribute("rdmmt");
                    if (t <= 0L) {
                        t = ds.getLongParameter("stats.download.added.time");
                    }
                    if (t < addedTime && t > dmBeforeTime) {
                        dmBefore = d;
                        dmBeforeTime = t;
                    }
                    if (t < addedTime || t >= dmAfterTime) continue;
                    dmAfter = d;
                    dmAfterTime = t;
                }
                position_set = true;
                int def_queue_loc = this.getDefaultQueueLocation();
                if (dmBefore != null || dmAfter != null) {
                    if (dmBefore == null) {
                        if (def_queue_loc == 1) {
                            gm.moveTop(new DownloadManager[]{dm});
                        } else {
                            gm.moveEnd(new DownloadManager[]{dm});
                        }
                    } else if (dmAfter == null) {
                        if (def_queue_loc == 1) {
                            gm.moveEnd(new DownloadManager[]{dm});
                        } else {
                            gm.moveTop(new DownloadManager[]{dm});
                        }
                    } else if (def_queue_loc == 1) {
                        gm.moveTo(dm, dmAfter.getPosition());
                    } else {
                        gm.moveTo(dm, dmBefore.getPosition());
                    }
                }
            }
            if (!position_set && this.getQueueLocation() == 0) {
                gm.moveTop(new DownloadManager[]{dm});
            }
            TorrentOpenOptions.addModePostCreate(startMode, dm);
        });
        return true;
    }

    public static interface FileListener {
        public void toDownloadChanged(TorrentOpenFileOptions var1, boolean var2);

        public void priorityChanged(TorrentOpenFileOptions var1, int var2);

        public void parentDirChanged();

        public void initialTagsChanged();

        default public void startOptionsChanged() {
        }
    }

    public static interface ParentDirChangedListener
    extends FileListener {
        @Override
        default public void toDownloadChanged(TorrentOpenFileOptions torrentOpenFileOptions, boolean toDownload) {
        }

        @Override
        default public void priorityChanged(TorrentOpenFileOptions torrentOpenFileOptions, int priority) {
        }

        @Override
        public void parentDirChanged();

        @Override
        default public void initialTagsChanged() {
        }
    }
}

