/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrentdownloader;

import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.torrentdownloader.impl.TorrentDownloaderImpl;
import com.biglybt.core.torrentdownloader.impl.TorrentDownloaderManager;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TorrentDownloaderFactory {
    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, Map request_properties, String fileordir) {
        return new TorrentDownloadRetrier(callback, url, referrer, request_properties, fileordir);
    }

    public static void initManager(GlobalManager gm, boolean autostart) {
        TorrentDownloaderManager.getInstance().init(gm, autostart);
    }

    public static TorrentDownloader downloadManaged(String url, String fileordir) {
        return TorrentDownloaderManager.getInstance().download(url, fileordir);
    }

    public static TorrentDownloader downloadManaged(String url) {
        return TorrentDownloaderManager.getInstance().download(url);
    }

    public static TorrentDownloader downloadToLocationManaged(String url, String save_path) {
        return TorrentDownloaderManager.getInstance().downloadToLocation(url, save_path);
    }

    private static class TorrentDownloadRetrier
    implements TorrentDownloader {
        private final String url;
        private final String referrer;
        private final Map request_properties;
        private final String fileordir;
        private volatile TorrentDownloaderImpl delegate;
        private volatile boolean cancelled;
        private volatile boolean sdp_set;
        private volatile String sdp_path;
        private volatile String sdp_file;
        private volatile boolean dfoc_set;
        private volatile boolean dfoc;
        private volatile boolean irc_set;
        private volatile boolean irc;
        private volatile String original_error;

        private TorrentDownloadRetrier(TorrentDownloaderCallBackInterface _callback, String _url, String _referrer, Map _request_properties, String _fileordir) {
            this.url = _url;
            this.referrer = _referrer;
            this.request_properties = _request_properties;
            this.fileordir = _fileordir;
            TorrentDownloaderCallBackInterface callback = new TorrentDownloaderCallBackInterface(_callback){
                private final TorrentDownloaderCallBackInterface original_callback;
                private boolean no_retry;
                private boolean init_reported;
                private boolean start_reported;
                private boolean finish_reported;
                private boolean proxy_tried;
                private AEProxyFactory.PluginProxy plugin_proxy;
                {
                    this.original_callback = torrentDownloaderCallBackInterface;
                    this.no_retry = this.original_callback == null;
                    this.init_reported = false;
                    this.start_reported = false;
                    this.finish_reported = false;
                    this.proxy_tried = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void TorrentDownloaderEvent(int state, TorrentDownloader _delegate) {
                    if (_delegate != delegate) {
                        return;
                    }
                    if (state == 4 && original_error == null) {
                        original_error = delegate.getError();
                    }
                    if (this.plugin_proxy != null && (state == 3 || state == 5 || state == 6 || state == 4)) {
                        this.plugin_proxy.setOK(state != 4);
                        this.plugin_proxy = null;
                    }
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (state == 0) {
                            if (this.init_reported) {
                                return;
                            }
                            this.init_reported = true;
                        }
                        if (state == 1) {
                            if (this.start_reported) {
                                return;
                            }
                            this.start_reported = true;
                        }
                        if (state == 3) {
                            if (this.finish_reported) {
                                return;
                            }
                            this.finish_reported = true;
                        }
                    }
                    if (cancelled) {
                        this.no_retry = true;
                    }
                    if (this.no_retry) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, this);
                        }
                        return;
                    }
                    if (state == 3 || state == 5 || state == 6) {
                        if (state == 3 && this.proxy_tried) {
                            TorrentUtils.setObtainedFrom(delegate.getFile(), url);
                        }
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, this);
                        }
                        this.no_retry = true;
                        return;
                    }
                    if (state == 4) {
                        String lc_url = url.toLowerCase().trim();
                        if (!this.proxy_tried) {
                            this.proxy_tried = true;
                            boolean tor_hack = lc_url.startsWith("tor:");
                            boolean i2p_hack = lc_url.startsWith("i2p:");
                            if (lc_url.startsWith("http") || tor_hack || i2p_hack) {
                                try {
                                    URL original_url;
                                    if (tor_hack || i2p_hack) {
                                        original_url = new URL(url.substring(4));
                                        HashMap<String, Object> options = new HashMap<String, Object>();
                                        options.put("peer_networks", new String[]{tor_hack ? "Tor" : "I2P"});
                                        if (i2p_hack) {
                                            options.put("preferred_proxy_type", "HTTP");
                                            options.put("force_proxy", true);
                                        }
                                        this.plugin_proxy = AEProxyFactory.getPluginProxy("torrent download", original_url, options, true);
                                    } else {
                                        original_url = new URL(url);
                                    }
                                    if (this.plugin_proxy == null) {
                                        this.plugin_proxy = AEProxyFactory.getPluginProxy("torrent download", original_url);
                                    }
                                    if (this.plugin_proxy != null) {
                                        delegate = new TorrentDownloaderImpl();
                                        if (sdp_set) {
                                            delegate.setDownloadPath(sdp_path, sdp_file);
                                        }
                                        if (dfoc_set) {
                                            delegate.setDeleteFileOnCancel(dfoc);
                                        }
                                        if (irc_set) {
                                            delegate.setIgnoreReponseCode(irc);
                                        }
                                        HashMap<String, String> props = new HashMap<String, String>();
                                        if (request_properties != null) {
                                            props.putAll(request_properties);
                                        }
                                        props.put("HOST", String.valueOf(this.plugin_proxy.getURLHostRewrite()) + (original_url.getPort() == -1 ? "" : ":" + original_url.getPort()));
                                        delegate.init(this, this.plugin_proxy.getURL().toExternalForm(), this.plugin_proxy.getProxy(), referrer == null ? original_url.toExternalForm() : referrer, props, fileordir);
                                        delegate.start();
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        String retry_url = null;
                        if (lc_url.startsWith("http")) {
                            retry_url = UrlUtils.parseTextForURL(url.substring(5), true);
                        }
                        if (retry_url != null) {
                            delegate = new TorrentDownloaderImpl();
                            if (sdp_set) {
                                delegate.setDownloadPath(sdp_path, sdp_file);
                            }
                            if (dfoc_set) {
                                delegate.setDeleteFileOnCancel(dfoc);
                            }
                            if (irc_set) {
                                delegate.setIgnoreReponseCode(irc);
                            }
                            delegate.init(this, retry_url, null, referrer, request_properties, fileordir);
                            this.no_retry = true;
                            delegate.start();
                            return;
                        }
                        this.no_retry = true;
                    }
                    if (this.original_callback != null) {
                        this.original_callback.TorrentDownloaderEvent(state, this);
                    }
                }
            };
            this.delegate = new TorrentDownloaderImpl();
            this.delegate.init(callback, this.url, null, this.referrer, this.request_properties, this.fileordir);
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.delegate.cancel();
        }

        @Override
        public void setDownloadPath(String path, String file) {
            this.sdp_set = true;
            this.sdp_path = path;
            this.sdp_file = file;
            this.delegate.setDownloadPath(path, file);
        }

        @Override
        public int getDownloadState() {
            return this.delegate.getDownloadState();
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public int getPercentDone() {
            return this.delegate.getPercentDone();
        }

        @Override
        public int getTotalRead() {
            return this.delegate.getTotalRead();
        }

        @Override
        public String getError() {
            if (this.original_error != null) {
                return this.original_error;
            }
            return this.delegate.getError();
        }

        @Override
        public String getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public String getURL() {
            return this.delegate.getURL();
        }

        @Override
        public int getLastReadCount() {
            return this.delegate.getLastReadCount();
        }

        @Override
        public byte[] getLastReadBytes() {
            return this.delegate.getLastReadBytes();
        }

        @Override
        public boolean getDeleteFileOnCancel() {
            return this.delegate.getDeleteFileOnCancel();
        }

        @Override
        public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
            this.dfoc_set = true;
            this.dfoc = deleteFileOnCancel;
            this.delegate.setDeleteFileOnCancel(deleteFileOnCancel);
        }

        @Override
        public boolean isIgnoreReponseCode() {
            return this.delegate.isIgnoreReponseCode();
        }

        @Override
        public void setIgnoreReponseCode(boolean ignoreReponseCode) {
            this.irc_set = true;
            this.irc = ignoreReponseCode;
            this.delegate.setIgnoreReponseCode(ignoreReponseCode);
        }
    }
}

