/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrentdownloader.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private static final AtomicLong uid = new AtomicLong(SystemTime.getCurrentTime());
    private String original_url;
    private String url_str;
    private Proxy proxy;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private URLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private final byte[] buf = new byte[131072];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    final AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface _iface, String _url, Proxy _proxy, String _referrer, Map _request_properties, String _file) {
        this.iface = _iface;
        this.original_url = _url;
        _url = _url.replace('\\', '/');
        _url = _url.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + _url);
        this.url_str = _url;
        this.proxy = _proxy;
        this.referrer = _referrer;
        this.request_properties = _request_properties;
        this.file_str = _file;
        if (this.referrer == null || this.referrer.length() == 0) {
            try {
                this.referrer = this.url_str;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    private void error(int errCode, String err) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(errCode, err);
            this.cleanUpFile();
            this.notifyListener();
        }
        finally {
            this.this_mon.exit();
            this.closeConnection();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void runSupport() {
        block136: {
            block130: {
                try {
                    new URL(this.url_str);
                }
                catch (Throwable t) {
                    magnet_uri = UrlUtils.normaliseMagnetURI(this.url_str);
                    if (magnet_uri == null) break block130;
                    this.url_str = magnet_uri;
                }
            }
            try {
                block139: {
                    block140: {
                        block141: {
                            block138: {
                                this.url = AddressUtils.adjustURL(new URL(this.url_str));
                                protocol = this.url.getProtocol().toLowerCase(Locale.US);
                                if (protocol.equals("magnet") || protocol.equals("maggot") || protocol.equals("dht")) {
                                    this.url = AddressUtils.adjustURL(new URL(String.valueOf(this.url_str) + (this.url_str.contains("?") != false ? "&" : "?") + "pause_on_error=true"));
                                }
                                redirect_urls = new HashSet<String>();
                                follow_redirect = true;
                                current_url = this.url;
                                current_proxy = this.proxy;
                                current_plugin_proxy = AEProxyFactory.getPluginProxy(current_proxy);
                                block58: while (follow_redirect) {
                                    follow_redirect = false;
                                    dh_hack = false;
                                    internal_error_hack = false;
                                    connect_loop = 0;
                                    while (connect_loop < 3) {
                                        block131: {
                                            protocol = current_url.getProtocol().toLowerCase(Locale.US);
                                            try {
                                                if (protocol.equals("https")) {
                                                    ssl_con = current_proxy == null ? (HttpsURLConnection)current_url.openConnection() : (HttpsURLConnection)current_url.openConnection(current_proxy);
                                                    if (!internal_error_hack) {
                                                        ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                                            @Override
                                                            public boolean verify(String host, SSLSession session) {
                                                                return true;
                                                            }
                                                        });
                                                    }
                                                    if (dh_hack) {
                                                        UrlUtils.DHHackIt(ssl_con);
                                                    }
                                                    if (connect_loop > 0) {
                                                        trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                                                        try {
                                                            sc = SSLContext.getInstance("SSL");
                                                            sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                                                            factory = sc.getSocketFactory();
                                                            ssl_con.setSSLSocketFactory(factory);
                                                        }
                                                        catch (Throwable sc) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (internal_error_hack && current_plugin_proxy != null) {
                                                        host = current_plugin_proxy.getURLHostRewrite();
                                                        UrlUtils.HTTPSURLConnectionSNIHack(host, ssl_con);
                                                    }
                                                    this.con = ssl_con;
                                                } else {
                                                    this.con = current_proxy == null ? current_url.openConnection() : current_url.openConnection(current_proxy);
                                                }
                                                if (this.con instanceof HttpURLConnection) {
                                                    ((HttpURLConnection)this.con).setInstanceFollowRedirects(this.proxy == null);
                                                }
                                                props = new Properties();
                                                ClientIDManagerImpl.getSingleton().getGenerator().generateHTTPProperties(null, props);
                                                ua = props.getProperty("User-Agent");
                                                this.con.setRequestProperty("User-Agent", ua);
                                                if (this.referrer != null && this.referrer.length() > 0) {
                                                    this.con.setRequestProperty("Referer", this.referrer);
                                                }
                                                if (this.request_properties != null) {
                                                    for (Map.Entry<K, V> entry : this.request_properties.entrySet()) {
                                                        key = (String)entry.getKey();
                                                        value = (String)entry.getValue();
                                                        if (key.equalsIgnoreCase("Accept-Encoding")) continue;
                                                        this.con.setRequestProperty(key, value);
                                                    }
                                                }
                                                this.con.connect();
                                                magnetURI = this.con.getHeaderField("Magnet-Uri");
                                                if (magnetURI != null) {
                                                    this.closeConnection();
                                                    this.url_str = magnetURI;
                                                    this.runSupport();
                                                    return;
                                                }
                                                v0 = response = this.con instanceof HttpURLConnection != false ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                                                if (response != 302 && response != 301 || (move_to = this.con.getHeaderField("location")) == null || redirect_urls.contains(move_to) || redirect_urls.size() > 32) continue block58;
                                                redirect_urls.add(move_to);
                                                try {
                                                    move_to_url = new URL(move_to);
                                                    follow = false;
                                                    if (current_plugin_proxy != null && (child = current_plugin_proxy.getChildProxy("redirect", move_to_url)) != null) {
                                                        this.request_properties.put("HOST", String.valueOf(child.getURLHostRewrite()) + (move_to_url.getPort() == -1 ? "" : ":" + move_to_url.getPort()));
                                                        current_proxy = child.getProxy();
                                                        move_to_url = child.getURL();
                                                        follow = true;
                                                    }
                                                    original_protocol = current_url.getProtocol().toLowerCase();
                                                    new_protocol = move_to_url.getProtocol().toLowerCase();
                                                    if (!follow && original_protocol.equals(new_protocol)) continue block58;
                                                    current_url = move_to_url;
                                                    try {
                                                        cookies_list = this.con.getHeaderFields().get("Set-cookie");
                                                        cookies_set = new ArrayList<String>();
                                                        if (cookies_list != null) {
                                                            i = 0;
                                                            while (i < cookies_list.size()) {
                                                                cookie_bits = cookies_list.get(i).split(";");
                                                                if (cookie_bits.length > 0) {
                                                                    cookies_set.add(cookie_bits[0]);
                                                                }
                                                                ++i;
                                                            }
                                                        }
                                                        if (cookies_set.size() > 0) {
                                                            new_cookies = "";
                                                            obj = this.request_properties.get("Cookie");
                                                            if (obj instanceof String) {
                                                                new_cookies = (String)obj;
                                                            }
                                                            for (String s : cookies_set) {
                                                                new_cookies = String.valueOf(new_cookies) + (new_cookies.length() == 0 ? "" : "; ") + s;
                                                            }
                                                            this.request_properties.put("Cookie", new_cookies);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.out(e);
                                                    }
                                                    follow_redirect = true;
                                                }
                                                catch (Throwable var15_60) {}
                                                continue block58;
                                            }
                                            catch (SSLException e) {
                                                if (connect_loop < 3) {
                                                    msg = Debug.getNestedExceptionMessage(e);
                                                    try_again = false;
                                                    if (msg.contains("DH keypair")) {
                                                        if (!dh_hack) {
                                                            dh_hack = true;
                                                            try_again = true;
                                                        }
                                                    } else if ((msg.contains("internal_error") || msg.contains("handshake_failure")) && !internal_error_hack) {
                                                        internal_error_hack = true;
                                                        try_again = true;
                                                    }
                                                    if (current_plugin_proxy == null && SESecurityManager.installServerCertificates(this.url) != null) {
                                                        try_again = true;
                                                    }
                                                    if (this.url != current_url && current_plugin_proxy == null && SESecurityManager.installServerCertificates(current_url) != null) {
                                                        try_again = true;
                                                    }
                                                    if (try_again) break block131;
                                                }
                                                throw e;
                                            }
                                            catch (IOException e) {
                                                if (connect_loop == 0) {
                                                    retry_url = UrlUtils.getIPV4Fallback(this.url);
                                                    if (retry_url != null) {
                                                        this.url = retry_url;
                                                    } else {
                                                        throw e;
                                                    }
                                                }
                                                if (!(e instanceof UnknownHostException)) break block131;
                                                throw e;
                                            }
                                        }
                                        ++connect_loop;
                                    }
                                }
                                v1 = response = this.con instanceof HttpURLConnection != false ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                                if (!this.ignoreReponseCode && response != 202 && response != 200) {
                                    this.error(response, String.valueOf(Integer.toString(response)) + ": " + ((HttpURLConnection)this.con).getResponseMessage());
                                    return;
                                }
                                this.filename = this.con.getHeaderField("Content-Disposition");
                                if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                                    while (this.filename.toLowerCase().charAt(0) != 'a') {
                                        this.filename = this.filename.substring(1);
                                    }
                                }
                                p = Pattern.compile(".*filename=\\\"(.*)\\\"");
                                m = null;
                                if (this.filename == null || (m = p.matcher(this.filename)) == null || !m.matches()) break block138;
                                this.filename = m.group(1).trim();
                                break block139;
                            }
                            if (this.filename != null && this.filename.toLowerCase().startsWith("attachment") && this.filename.indexOf(61) != -1) break block140;
                            tmp = this.url.getFile();
                            if (tmp.length() != 0 && !tmp.equals("/")) break block141;
                            this.filename = this.url.getHost();
                            break block139;
                        }
                        if (!tmp.startsWith("?")) ** GOTO lbl177
                        query = tmp.toUpperCase();
                        hash = UrlUtils.getTruncatedHashFromMagnetURI(query);
                        this.filename = hash != null ? Base32.encode(hash) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = String.valueOf(this.filename) + "_" + TorrentDownloaderImpl.uid.incrementAndGet();
                        this.filename = String.valueOf(this.filename) + ".tmp";
                        break block139;
lbl-1000:
                        // 1 sources

                        {
                            tmp = tmp.substring(0, tmp.length() - 1);
lbl177:
                            // 2 sources

                            ** while (tmp.endsWith((String)"/"))
                        }
lbl178:
                        // 1 sources

                        if (tmp.lastIndexOf(47) != -1) {
                            tmp = tmp.substring(tmp.lastIndexOf(47) + 1);
                        }
                        if ((param_pos = tmp.indexOf(63)) != -1) {
                            tmp = tmp.substring(0, param_pos);
                        }
                        this.filename = URLDecoder.decode(tmp, Constants.DEFAULT_ENCODING_CHARSET.name());
                        if (this.filename.length() == 0) {
                            this.filename = "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        }
                        break block139;
                    }
                    this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                    if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                        this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                    }
                    this.filename = URLDecoder.decode(this.filename, Constants.DEFAULT_ENCODING_CHARSET.name());
                    temp = FileUtil.newFile(this.filename, new String[0]);
                    this.filename = temp.getName();
                }
                this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
                this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                useTorrentSave = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                if (this.file_str != null) {
                    temp = FileUtil.newFile(this.file_str, new String[0]);
                    if (!useTorrentSave || this.directoryname.length() == 0) {
                        this.directoryname = temp.isDirectory() != false ? temp.getCanonicalPath() : temp.getCanonicalFile().getParent();
                    }
                    if (!temp.isDirectory()) {
                        this.filename = temp.getName();
                    }
                }
                this.state = 0;
                this.notifyListener();
            }
            catch (MalformedURLException e) {
                this.error(0, "Exception while parsing URL '" + this.url_str + "':" + e.getMessage());
            }
            catch (UnknownHostException e) {
                this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + e.getMessage() + "'");
            }
            catch (IOException ioe) {
                this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + ioe.toString());
            }
            catch (Throwable e) {
                this.error(0, "Exception while initializing download of '" + this.url + "':" + e.toString());
            }
            if (this.state == 4) {
                return;
            }
            try {
                status_reader_run = new boolean[]{true};
                this.state = 1;
                this.notifyListener();
                this.state = 2;
                this.notifyListener();
                if (this.con instanceof HttpURLConnection) {
                    ev = new TimerEventPeriodic[1];
                    try {
                        this.this_mon.enter();
                        ev[0] = SimpleTimer.addPeriodicEvent("TorrentDownloader:statusreader", 100L, new TimerEventPerformer(){
                            HttpURLConnection http_con;
                            boolean changed_status;
                            String last_status;
                            long last_progress_update;
                            {
                                this.http_con = (HttpURLConnection)TorrentDownloaderImpl.this.con;
                                this.changed_status = false;
                                this.last_status = "";
                                this.last_progress_update = SystemTime.getMonotonousTime();
                            }

                            @Override
                            public void perform(TimerEvent event2) {
                                TimerEventPeriodic to_cancel;
                                block23: {
                                    to_cancel = null;
                                    try {
                                        String s;
                                        try {
                                            TorrentDownloaderImpl.this.this_mon.enter();
                                            if (!status_reader_run[0]) {
                                                to_cancel = ev[0];
                                            }
                                        }
                                        finally {
                                            TorrentDownloaderImpl.this.this_mon.exit();
                                        }
                                        if (to_cancel != null || (s = this.http_con.getResponseMessage()).equals(this.last_status)) break block23;
                                        this.last_status = s;
                                        String lc_s = s.toLowerCase();
                                        if (!lc_s.startsWith("error:")) {
                                            if (s.toLowerCase().contains("alive") && TorrentDownloaderImpl.this.percentDone < 10) {
                                                TorrentDownloaderImpl torrentDownloaderImpl = TorrentDownloaderImpl.this;
                                                torrentDownloaderImpl.percentDone = torrentDownloaderImpl.percentDone + 1;
                                            }
                                            boolean progress_update = false;
                                            int pos = s.indexOf(37);
                                            if (pos != -1) {
                                                int i = pos - 1;
                                                while (i >= 0) {
                                                    char c = s.charAt(i);
                                                    if (!Character.isDigit(c) && c != ' ') {
                                                        ++i;
                                                        break;
                                                    }
                                                    --i;
                                                }
                                                try {
                                                    TorrentDownloaderImpl.this.percentDone = Math.min(99, Integer.parseInt(s.substring(i, pos).trim()));
                                                    progress_update = true;
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                            }
                                            if (lc_s.startsWith("received")) {
                                                progress_update = true;
                                            }
                                            if (progress_update) {
                                                long now = SystemTime.getMonotonousTime();
                                                if (now - this.last_progress_update < 250L) {
                                                    return;
                                                }
                                                this.last_progress_update = now;
                                            }
                                            TorrentDownloaderImpl.this.setStatus(s);
                                        } else {
                                            TorrentDownloaderImpl.this.error(this.http_con.getResponseCode(), s.substring(6));
                                        }
                                        this.changed_status = true;
                                    }
                                    catch (Throwable e) {
                                        try {
                                            TorrentDownloaderImpl.this.this_mon.enter();
                                            to_cancel = ev[0];
                                        }
                                        finally {
                                            TorrentDownloaderImpl.this.this_mon.exit();
                                        }
                                    }
                                }
                                if (to_cancel != null) {
                                    if (this.changed_status) {
                                        TorrentDownloaderImpl.this.setStatus("");
                                    }
                                    to_cancel.cancel();
                                }
                            }
                        });
                    }
                    finally {
                        this.this_mon.exit();
                    }
                }
                in = null;
                fileout = null;
                try {
                    block134: {
                        try {
                            try {
                                in = this.con.getInputStream();
                            }
                            catch (FileNotFoundException e) {
                                if (this.ignoreReponseCode) {
                                    in = this.con instanceof HttpURLConnection ? ((HttpURLConnection)this.con).getErrorStream() : null;
                                } else {
                                    throw e;
                                }
                                try {
                                    this.this_mon.enter();
                                    status_reader_run[0] = false;
                                    break block134;
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                            }
                        }
                        catch (Throwable current_proxy) {
                            try {
                                this.this_mon.enter();
                                status_reader_run[0] = false;
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            throw current_proxy;
                        }
                        try {
                            this.this_mon.enter();
                            status_reader_run[0] = false;
                        }
                        finally {
                            this.this_mon.exit();
                        }
                    }
                    encoding = this.con.getHeaderField("content-encoding");
                    if (encoding != null) {
                        if (encoding.equalsIgnoreCase("gzip")) {
                            in = new GZIPInputStream(in);
                        } else if (encoding.equalsIgnoreCase("deflate")) {
                            in = new InflaterInputStream(in);
                        }
                    }
                    if (this.state == 4) break block136;
                    this.file = FileUtil.newFile(this.directoryname, new String[]{this.filename});
                    useTempFile = this.file.exists();
                    if (!useTempFile) {
                        try {
                            this.file.createNewFile();
                            useTempFile = this.file.exists() == false;
                        }
                        catch (Throwable t) {
                            useTempFile = true;
                        }
                    }
                    if (useTempFile) {
                        this.file = File.createTempFile("AZU", ".tmp", FileUtil.newFile(this.directoryname, new String[0]));
                        this.file.createNewFile();
                    }
                    fileout = FileUtil.newFileOutputStream(this.file);
                    this.bufBytes = 0;
                    size = (int)UrlUtils.getContentLength(this.con);
                    this.percentDone = -1;
                    while (!this.cancel) {
                        try {
                            this.bufBytes = in.read(this.buf);
                            this.readTotal += this.bufBytes;
                            if (size > 0) {
                                this.percentDone = Math.min(99, 100 * this.readTotal / size);
                            }
                            this.notifyListener();
                        }
                        catch (IOException response) {
                            // empty catch block
                        }
                        if (this.bufBytes > 0) {
                            fileout.write(this.buf, 0, this.bufBytes);
                        }
                        if (this.bufBytes > 0) continue;
                    }
                    in.close();
                    fileout.flush();
                    fileout.close();
                    if (this.cancel) {
                        this.state = 6;
                        if (this.deleteFileOnCancel) {
                            this.cleanUpFile();
                        }
                    } else {
                        block137: {
                            if (this.readTotal <= 0) {
                                this.error(0, "No data contained in '" + this.url.toString() + "'");
                                return;
                            }
                            try {
                                if (this.filename.toLowerCase().endsWith(".torrent")) break block137;
                                torrent = TorrentUtils.readFromFile(this.file, false);
                                name = String.valueOf(TorrentUtils.getLocalisedName(torrent)) + ".torrent";
                                prefix = "";
                                i = 0;
                                while (i < 16) {
                                    new_file = FileUtil.newFile(this.directoryname, new String[]{String.valueOf(prefix) + name});
                                    if (this.file.renameTo(new_file)) {
                                        FileUtil.newFile(this.file.getParentFile(), new String[]{String.valueOf(this.file.getName()) + ".bak"}).delete();
                                        this.filename = name;
                                        this.file = new_file;
                                        break;
                                    }
                                    prefix = String.valueOf(prefix) + "_";
                                    ++i;
                                }
                            }
                            catch (Throwable e) {
                                is_vuze_file = false;
                                try {
                                    if (VuzeFileHandler.isAcceptedVuzeFileName(this.filename)) {
                                        is_vuze_file = true;
                                    } else if (VuzeFileHandler.getSingleton().loadVuzeFile(this.file) != null) {
                                        is_vuze_file = true;
                                        name = VuzeFileHandler.getVuzeFileName(this.filename);
                                        new_file = FileUtil.newFile(this.directoryname, new String[]{name});
                                        if (this.file.renameTo(new_file)) {
                                            FileUtil.newFile(this.file.getParentFile(), new String[]{String.valueOf(this.file.getName()) + ".bak"}).delete();
                                            this.filename = name;
                                            this.file = new_file;
                                        }
                                    }
                                }
                                catch (Throwable var9_34) {
                                    // empty catch block
                                }
                                if (is_vuze_file || RSSUtils.isRSSFeed(this.file)) break block137;
                                Debug.printStackTrace(e);
                            }
                        }
                        if (this.proxy == null) {
                            TorrentUtils.setObtainedFrom(this.file, this.original_url);
                        }
                        this.percentDone = 100;
                        this.state = 3;
                    }
                    this.notifyListener();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable var13_52) {}
                    }
                    if (fileout != null) {
                        try {
                            fileout.close();
                        }
                        catch (Throwable var13_53) {}
                    }
                }
            }
            catch (Throwable e) {
                url_log_string = this.url_str.toString().replaceAll("\\Q&pause_on_error=true\\E", "");
                log_msg = MessageText.getString("torrentdownload.error.dl_fail", new String[]{url_log_string, this.file == null ? this.filename : this.file.getAbsolutePath(), e.getMessage()});
                if (!this.cancel) {
                    Debug.out(log_msg, e);
                }
                this.error(0, log_msg);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl other = (TorrentDownloaderImpl)obj;
            if (other.original_url.equals(this.original_url)) {
                File this_file;
                File other_file = other.getFile();
                if (other_file == (this_file = this.file)) {
                    return true;
                }
                if (other_file == null || this_file == null) {
                    return false;
                }
                return other_file.getAbsolutePath().equals(this_file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.original_url.hashCode();
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(int errCode, String err) {
        this.error = err;
        this.errCode = errCode;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String str) {
        this.status = str;
        this.notifyListener();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = FileUtil.newFile(this.directoryname, this.filename);
        }
        return this.file;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int state) {
        this.state = state;
    }

    @Override
    public String getURL() {
        return this.url.toString();
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this.con instanceof HttpURLConnection) {
            ((HttpURLConnection)this.con).disconnect();
        }
    }

    @Override
    public void setDownloadPath(String path, String file) {
        if (!this.isAlive()) {
            if (path != null) {
                this.directoryname = path;
            }
            if (file != null) {
                this.filename = file;
            }
        }
    }

    @Override
    public int getTotalRead() {
        return this.readTotal;
    }

    @Override
    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, bytes, 0, this.bufBytes);
        return bytes;
    }

    @Override
    public int getLastReadCount() {
        return this.bufBytes;
    }

    @Override
    public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
        this.deleteFileOnCancel = deleteFileOnCancel;
    }

    @Override
    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    @Override
    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    @Override
    public void setIgnoreReponseCode(boolean ignoreReponseCode) {
        this.ignoreReponseCode = ignoreReponseCode;
    }
}

