/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.alltrackers;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingImmediateAverage;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class AllTrackersManagerImpl
implements AllTrackersManager.AllTrackers,
TOTorrentListener {
    static final int MAX_TRACKERS = 5000;
    static final int TICK_PERIOD = 2500;
    static final int SAVE_PERIOD = 300000;
    static final int SAVE_TICKS = 120;
    static final int LAG_CHECK_PERIOD = 60000;
    static final int LAG_CHECK_TICKS = 24;
    private static final String CONFIG_FILE = "alltrackers.config";
    private static final String CONFIG_PRIVATE_ACTIVE_AT_CLOSE = "alltrackers.close.private.active";
    private static final AllTrackersManagerImpl singleton = new AllTrackersManagerImpl();
    private final long start_time;
    private final Core core;
    private volatile boolean started;
    private volatile boolean stopping;
    private Map<String, AllTrackersTrackerImpl> host_map;
    private ConcurrentLinkedDeque<Object[]> update_queue;
    private CopyOnWriteList<AllTrackersManager.AllTrackersListener> listeners;
    private Map<TRTrackerAnnouncerRequest, String> active_requests;
    private boolean got_running;
    private final Object process_lock;
    private List<TOTorrent> pending_torrents;
    private Map<String, LoggerChannel> logging_keys;
    private Map<HashWrapper, String> dm_name_cache;
    private AtomicLong options_mutation_count;
    private MovingImmediateAverage lag_average;
    private boolean lag_logged;
    private static final List<String> active = Collections.emptyList();
    private final Average announce_rate;
    private final Average scrape_rate;
    private AllTrackersManager.AnnounceStats announce_stats;
    private volatile AllTrackersManager.ScrapeStats scrape_stats;
    private AllTrackersManager.AnnounceStatsProvider announce_provider;
    private AllTrackersManager.ScrapeStatsProvider scrape_provider;
    private final FrequencyLimitedDispatcher totalDisp;
    AsyncDispatcher asyncDisp;

    public static AllTrackersManager.AllTrackers getSingleton() {
        return singleton;
    }

    private AllTrackersManagerImpl() {
        block7: {
            this.start_time = SystemTime.getMonotonousTime();
            this.core = CoreFactory.getSingleton();
            this.host_map = new ConcurrentHashMap<String, AllTrackersTrackerImpl>();
            this.update_queue = new ConcurrentLinkedDeque();
            this.listeners = new CopyOnWriteList();
            this.active_requests = new ConcurrentHashMap<TRTrackerAnnouncerRequest, String>();
            this.process_lock = new Object();
            this.pending_torrents = new ArrayList<TOTorrent>();
            this.logging_keys = new HashMap<String, LoggerChannel>();
            this.dm_name_cache = new HashMap<HashWrapper, String>();
            this.options_mutation_count = new AtomicLong();
            this.lag_average = AverageFactory.MovingImmediateAverage(5);
            this.announce_rate = Average.getInstance(1000, 20);
            this.scrape_rate = Average.getInstance(1000, 20);
            this.announce_stats = new AllTrackersManager.AnnounceStats(){

                @Override
                public int getPublicScheduledCount() {
                    return 0;
                }

                @Override
                public long getPublicLagMillis() {
                    return 0L;
                }

                @Override
                public List<String> getPublicActive() {
                    return active;
                }

                @Override
                public List<String> getPrivateActive() {
                    return active;
                }

                @Override
                public int getPrivateScheduledCount() {
                    return 0;
                }

                @Override
                public long getPrivateLagMillis() {
                    return 0L;
                }

                @Override
                public int getPrivatePendingCount() {
                    return 0;
                }

                @Override
                public int getPublicPendingCount() {
                    return 0;
                }
            };
            this.scrape_stats = new AllTrackersManager.ScrapeStats(){

                @Override
                public long getLagMillis() {
                    return 0L;
                }
            };
            this.announce_provider = new AllTrackersManager.AnnounceStatsProvider(){

                @Override
                public AllTrackersManager.AnnounceStats getStats() {
                    return AllTrackersManagerImpl.this.announce_stats;
                }
            };
            this.scrape_provider = new AllTrackersManager.ScrapeStatsProvider(){

                @Override
                public AllTrackersManager.ScrapeStats getStats() {
                    return AllTrackersManagerImpl.this.scrape_stats;
                }
            };
            this.totalDisp = new FrequencyLimitedDispatcher(AERunnable.create(() -> {
                HashMap<String, int[]> counts = new HashMap<String, int[]>();
                for (DownloadManager dm : this.core.getGlobalManager().getDownloadManagers()) {
                    try {
                        TOTorrentAnnounceURLSet[] sets;
                        String announce_name;
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        boolean priv = torrent.getPrivate();
                        URL announce_url = torrent.getAnnounceURL();
                        if (announce_url != null) {
                            announce_name = this.ingestURL(announce_url);
                            if (announce_name == null) {
                                announce_name = "";
                            } else {
                                int[] c = (int[])counts.get(announce_name);
                                if (c == null) {
                                    c = new int[2];
                                    counts.put(announce_name, c);
                                }
                                if (priv) {
                                    c[0] = c[0] + 1;
                                } else {
                                    c[1] = c[1] + 1;
                                }
                            }
                        } else {
                            announce_name = "";
                        }
                        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
                        int n = sets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URL[] urls;
                            TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                            URL[] uRLArray = urls = set.getAnnounceURLs();
                            int n3 = urls.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                URL url = uRLArray[n4];
                                String name = this.ingestURL(url);
                                if (name != null && !name.equals(announce_name)) {
                                    int[] c = (int[])counts.get(name);
                                    if (c == null) {
                                        c = new int[2];
                                        counts.put(name, c);
                                    }
                                    if (priv) {
                                        c[0] = c[0] + 1;
                                    } else {
                                        c[1] = c[1] + 1;
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                ArrayList<AllTrackersTrackerImpl> updates = new ArrayList<AllTrackersTrackerImpl>();
                for (AllTrackersTrackerImpl tracker : this.host_map.values()) {
                    int[] c = (int[])counts.get(tracker.getTrackerName());
                    boolean changed = c != null ? tracker.updateCounts(c[1], c[0]) : tracker.updateCounts(0, 0);
                    if (!changed) continue;
                    updates.add(tracker);
                }
                if (!updates.isEmpty()) {
                    for (AllTrackersManager.AllTrackersListener listener : this.listeners) {
                        try {
                            listener.trackerEventOccurred(new AllTrackersEventImpl(1, updates));
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }), 5000);
            this.totalDisp.setSingleThreaded();
            this.asyncDisp = new AsyncDispatcher("recalctots");
            this.loadConfig();
            this.updateLogging();
            try {
                try {
                    List actives = BDecoder.decodeStrings(COConfigurationManager.getListParameter(CONFIG_PRIVATE_ACTIVE_AT_CLOSE, new ArrayList()));
                    if (!actives.isEmpty()) {
                        String trackers = "";
                        for (String t : actives) {
                            trackers = String.valueOf(trackers) + (trackers.isEmpty() ? "" : ", ") + t;
                        }
                        String text = MessageText.getString("alltorrents.updates.outstanding", new String[]{trackers});
                        Logger.log(new LogAlert(false, 1, text, 0));
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    COConfigurationManager.removeParameter(CONFIG_PRIVATE_ACTIVE_AT_CLOSE);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                COConfigurationManager.removeParameter(CONFIG_PRIVATE_ACTIVE_AT_CLOSE);
                throw throwable;
            }
            COConfigurationManager.removeParameter(CONFIG_PRIVATE_ACTIVE_AT_CLOSE);
        }
        this.core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void started(Core core) {
                AllTrackersManagerImpl.this.started = true;
                AllTrackersManagerImpl.this.recalcTotals();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopping(Core core) {
                AllTrackersManagerImpl.this.stopping = true;
                Object object = AllTrackersManagerImpl.this.process_lock;
                synchronized (object) {
                    if (!AllTrackersManagerImpl.this.logging_keys.isEmpty()) {
                        for (DownloadManager dm : core.getGlobalManager().getDownloadManagers()) {
                            try {
                                AllTrackersManagerImpl.this.dm_name_cache.put(dm.getTorrent().getHashWrapper(), dm.getDisplayName());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            }

            @Override
            public void stopped(Core core) {
                AllTrackersManagerImpl.this.processUpdates(true);
                AllTrackersManagerImpl.this.saveConfig(true);
            }
        });
        SimpleTimer.addPeriodicEvent("AllTrackers", 2500L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event2) {
                ++this.tick_count;
                AllTrackersManagerImpl.this.processUpdates(false);
                if (this.tick_count % 24 == 0) {
                    AllTrackersManagerImpl.this.checkLag();
                }
                if (this.tick_count % 120 == 0) {
                    AllTrackersManagerImpl.this.saveConfig(false);
                }
            }
        });
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    private void checkLag() {
        AllTrackersManager.AnnounceStats stats2 = this.getAnnounceStats();
        long max_lag = Math.max(stats2.getPrivateLagMillis(), stats2.getPublicLagMillis());
        this.lag_average.update(max_lag);
        if (!this.lag_logged && SystemTime.getMonotonousTime() - this.start_time > 600000L && this.lag_average.getAverage() > 120000.0) {
            this.lag_logged = true;
            String text = MessageText.getString("alltorrents.updates.lagging");
            Logger.log(new LogAlert(false, 1, text, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdates(boolean for_close) {
        Object object = this.process_lock;
        synchronized (object) {
            if (this.pending_torrents != null && CoreFactory.isCoreRunning()) {
                for (TOTorrent torrent : this.pending_torrents) {
                    torrent.addListener(this);
                }
                this.got_running = true;
                this.pending_torrents = null;
            }
            HashSet<AllTrackersTrackerImpl> updates = new HashSet<AllTrackersTrackerImpl>();
            while (!this.update_queue.isEmpty()) {
                Object[] entry = this.update_queue.remove();
                try {
                    Object obj;
                    Object e0 = entry[0];
                    if (e0 instanceof TOTorrent) {
                        TOTorrent torrent = (TOTorrent)e0;
                        if (this.pending_torrents == null) {
                            torrent.addListener(this);
                            continue;
                        }
                        this.pending_torrents.add(torrent);
                        continue;
                    }
                    if (e0 instanceof String) {
                        String cmd = (String)e0;
                        if (cmd.equals("logging_changed")) {
                            this.updateLogging();
                            continue;
                        }
                        Debug.out("eh?");
                        continue;
                    }
                    AllTrackersTrackerImpl tracker = (AllTrackersTrackerImpl)e0;
                    if (tracker == null) {
                        int dm_state;
                        DownloadManager dm;
                        boolean online;
                        obj = entry[1];
                        if (!(obj instanceof TRTrackerScraperResponse)) continue;
                        TRTrackerScraperResponse s_resp = (TRTrackerScraperResponse)obj;
                        boolean bl = online = s_resp.getStatus() == 2;
                        if (!online || (dm = this.core.getGlobalManager().getDownloadManager(s_resp.getHash())) == null || (dm_state = dm.getState()) == 60 || dm_state == 50) continue;
                        dm.getDownloadState().setLongAttribute("lastscrape", SystemTime.getCurrentTime());
                        continue;
                    }
                    if (!this.host_map.containsKey(tracker.getTrackerName())) continue;
                    obj = entry[1];
                    boolean updated = false;
                    if (obj instanceof String) {
                        String cmd = (String)obj;
                        if (cmd.equals("reset_stats")) {
                            tracker.resetReportedStatsSupport();
                            updated = true;
                        } else {
                            Debug.out("eh?");
                        }
                    } else if (obj instanceof TRTrackerAnnouncerResponse) {
                        TRTrackerAnnouncerResponsePeer[] peers;
                        TRTrackerAnnouncerResponse a_resp = (TRTrackerAnnouncerResponse)obj;
                        if (tracker.setOK(a_resp.getStatus() == 2)) {
                            updated = true;
                        }
                        if (tracker.setStatusString(a_resp.getStatusString())) {
                            updated = true;
                        }
                        if ((peers = a_resp.getPeers()) != null && peers.length > 0 && !peers[0].isCached()) {
                            tracker.peersReceived(peers.length);
                        }
                        if (updated) {
                            tracker.log(a_resp);
                        }
                    } else if (obj instanceof TRTrackerScraperResponse) {
                        int dm_state;
                        DownloadManager dm;
                        boolean online;
                        TRTrackerScraperResponse s_resp = (TRTrackerScraperResponse)obj;
                        boolean bl = online = s_resp.getStatus() == 2;
                        if (online && (dm = this.core.getGlobalManager().getDownloadManager(s_resp.getHash())) != null && (dm_state = dm.getState()) != 60 && dm_state != 50) {
                            dm.getDownloadState().setLongAttribute("lastscrape", SystemTime.getCurrentTime());
                        }
                        if (tracker.hasStatus()) continue;
                        if (online) {
                            updated = true;
                        }
                        if (tracker.setStatusString(s_resp.getStatusString())) {
                            updated = true;
                        }
                    } else if (obj instanceof TRTrackerAnnouncerRequest) {
                        TRTrackerAnnouncerRequest req = (TRTrackerAnnouncerRequest)obj;
                        tracker.updateSession(req);
                        tracker.log(req, false);
                        updated = true;
                    }
                    if (!updated) continue;
                    updates.add(tracker);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (for_close) {
                HashSet<String> active_privates = new HashSet<String>();
                for (TRTrackerAnnouncerRequest req : this.active_requests.keySet()) {
                    AllTrackersTrackerImpl existing_tracker;
                    String key = this.ingestURL(req.getURL());
                    if (key == null || (existing_tracker = this.host_map.get(key)) == null) continue;
                    existing_tracker.log(req, true);
                    if (existing_tracker.getPrivatePercentage() <= 80) continue;
                    active_privates.add(existing_tracker.getShortKey());
                }
                if (!active_privates.isEmpty()) {
                    COConfigurationManager.setParameter(CONFIG_PRIVATE_ACTIVE_AT_CLOSE, new ArrayList(active_privates));
                }
            } else if (!updates.isEmpty()) {
                ArrayList trackers = new ArrayList(updates);
                for (AllTrackersManager.AllTrackersListener listener : this.listeners) {
                    try {
                        listener.trackerEventOccurred(new AllTrackersEventImpl(1, trackers));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        Object object = this.process_lock;
        synchronized (object) {
            try {
                List logging;
                Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                List trackers = (List)map.get("trackers");
                if (trackers != null) {
                    for (Map t : trackers) {
                        try {
                            AllTrackersTrackerImpl tracker = new AllTrackersTrackerImpl(t);
                            this.host_map.put(tracker.getTrackerName(), tracker);
                            if (this.host_map.size() <= 5000) continue;
                            Debug.out("Too many trackers - " + trackers.size());
                            return;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                if ((logging = (List)map.get("logging")) != null) {
                    for (Map log : logging) {
                        String key = MapUtils.getMapString(log, "key", null);
                        if (key == null) continue;
                        this.logging_keys.put(key, this.getLogger(key));
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig(boolean closing) {
        Object object = this.process_lock;
        synchronized (object) {
            boolean skip_unregistered = closing && this.got_running;
            try {
                HashMap map = new HashMap();
                ArrayList<Map> trackers = new ArrayList<Map>(this.host_map.size() + 32);
                map.put("trackers", trackers);
                for (AllTrackersTrackerImpl tracker : this.host_map.values()) {
                    if (skip_unregistered && !tracker.isRegistered()) {
                        Map<String, Object> options = tracker.getOptions();
                        boolean has_non_def = false;
                        if (options != null) {
                            String[] stringArray = AllTrackersManager.AllTrackersTracker.OPT_ALL;
                            int n = AllTrackersManager.AllTrackersTracker.OPT_ALL.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String opt = stringArray[n2];
                                try {
                                    Number num = (Number)options.get(opt);
                                    if (num != null && num.intValue() != 0) {
                                        has_non_def = true;
                                        break;
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                ++n2;
                            }
                        }
                        if (!has_non_def) continue;
                    }
                    try {
                        trackers.add(tracker.exportToMap());
                        if (trackers.size() <= 5000) continue;
                        Debug.out("Too many trackers - " + trackers.size());
                        break;
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (!this.logging_keys.isEmpty()) {
                    ArrayList logging = new ArrayList(this.logging_keys.size() + 32);
                    map.put("logging", logging);
                    for (String key : this.logging_keys.keySet()) {
                        HashMap<String, String> m = new HashMap<String, String>();
                        logging.add(m);
                        m.put("key", key);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void updateLogging() {
        for (AllTrackersTrackerImpl tracker : this.host_map.values()) {
            tracker.updateLogger();
        }
    }

    @Override
    public void registerAnnounceStatsProvider(AllTrackersManager.AnnounceStatsProvider provider) {
        this.announce_provider = provider;
    }

    @Override
    public void registerScrapeStatsProvider(AllTrackersManager.ScrapeStatsProvider provider) {
        this.scrape_provider = provider;
    }

    @Override
    public void addActiveRequest(TRTrackerAnnouncerRequest request2) {
        this.active_requests.put(request2, "");
        String key = this.ingestURL(request2.getURL());
        AllTrackersTrackerImpl tracker = this.host_map.get(key);
        if (tracker != null) {
            tracker.addActiveRequest();
        }
    }

    @Override
    public void removeActiveRequest(TRTrackerAnnouncerRequest request2) {
        this.active_requests.remove(request2);
        this.announce_rate.addValue(100L);
        String key = this.ingestURL(request2.getURL());
        AllTrackersTrackerImpl tracker = this.host_map.get(key);
        if (tracker != null) {
            tracker.removeActiveRequest();
        }
    }

    @Override
    public void addScrapeRequest() {
    }

    @Override
    public void removeScrapeRequest() {
        this.scrape_rate.addValue(100L);
    }

    @Override
    public int getActiveRequestCount() {
        return this.active_requests.size();
    }

    @Override
    public float getAnnouncesPerSecond() {
        AllTrackersManager.AnnounceStats stats2;
        if (this.stopping && this.active_requests.size() == 0 && (stats2 = this.announce_provider.getStats()).getPrivateScheduledCount() + stats2.getPublicScheduledCount() == 0) {
            return 0.0f;
        }
        return (float)this.announce_rate.getAverage() / 100.0f;
    }

    @Override
    public float getScrapesPerSecond() {
        return (float)this.scrape_rate.getAverage() / 100.0f;
    }

    @Override
    public AllTrackersManager.AnnounceStats getAnnounceStats() {
        return this.announce_provider.getStats();
    }

    @Override
    public AllTrackersManager.ScrapeStats getScrapeStats() {
        return this.scrape_provider.getStats();
    }

    @Override
    public int getTrackerCount() {
        return this.host_map.size();
    }

    private void recalcTotals() {
        if (this.started) {
            this.asyncDisp.dispatch(() -> this.totalDisp.dispatch());
        }
    }

    @Override
    public void registerTorrent(TOTorrent torrent) {
        if (torrent == null) {
            return;
        }
        this.registerTorrentSupport(torrent);
        this.update_queue.add(new Object[]{torrent});
        this.recalcTotals();
    }

    @Override
    public void unregisterTorrent(TOTorrent torrent) {
        this.recalcTotals();
    }

    private void registerTorrentSupport(TOTorrent torrent) {
        TOTorrentAnnounceURLSet[] sets;
        this.registerTracker(torrent, torrent.getAnnounceURL());
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            URL[] urls;
            TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
            URL[] uRLArray = urls = set.getAnnounceURLs();
            int n3 = urls.length;
            int n4 = 0;
            while (n4 < n3) {
                URL url = uRLArray[n4];
                this.register(torrent, url);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void torrentChanged(TOTorrent torrent, int change_type, Object data) {
        this.registerTorrentSupport(torrent);
        this.recalcTotals();
    }

    @Override
    public void registerTracker(TOTorrent torrent, URL url) {
        if (url == null) {
            return;
        }
        this.register(torrent, url);
    }

    @Override
    public void registerTrackers(TOTorrent torrent, List<List<URL>> trackers) {
        for (List<URL> urls : trackers) {
            for (URL url : urls) {
                this.register(torrent, url);
            }
        }
    }

    @Override
    public long getOptionsMutationCount() {
        return this.options_mutation_count.get();
    }

    @Override
    public String ingestURL(URL url) {
        String name = url.getHost();
        if (name != null && !name.endsWith(".dht")) {
            name = name.toLowerCase(Locale.US);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            name = String.valueOf(url.getProtocol()) + "://" + name + (port > 0 ? ":" + port : "");
            return name;
        }
        return null;
    }

    private AllTrackersTrackerImpl register(TOTorrent torrent_maybe_null, URL url) {
        String name = this.ingestURL(url);
        if (name != null) {
            return this.register(torrent_maybe_null, name);
        }
        return null;
    }

    private AllTrackersTrackerImpl register(TOTorrent torrent_maybe_null, String name) {
        AllTrackersTrackerImpl new_tracker;
        AllTrackersTrackerImpl existing_tracker = this.host_map.get(name);
        if (existing_tracker == null && (existing_tracker = this.host_map.putIfAbsent(name, new_tracker = new AllTrackersTrackerImpl(name))) == null) {
            for (AllTrackersManager.AllTrackersListener listener : this.listeners) {
                ArrayList<AllTrackersTrackerImpl> trackers = new ArrayList<AllTrackersTrackerImpl>();
                trackers.add(new_tracker);
                try {
                    listener.trackerEventOccurred(new AllTrackersEventImpl(0, trackers));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            new_tracker.setRegistered();
            return new_tracker;
        }
        existing_tracker.setRegistered();
        return existing_tracker;
    }

    private void unregisterTracker(String name) {
        AllTrackersTrackerImpl existing_tracker = this.host_map.remove(name);
        if (existing_tracker != null) {
            for (AllTrackersManager.AllTrackersListener listener : this.listeners) {
                ArrayList<AllTrackersTrackerImpl> trackers = new ArrayList<AllTrackersTrackerImpl>();
                trackers.add(existing_tracker);
                try {
                    listener.trackerEventOccurred(new AllTrackersEventImpl(2, trackers));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public void updateTracker(URL url, TRTrackerAnnouncerResponse response) {
        AllTrackersTrackerImpl tracker = this.register(null, url);
        if (tracker != null) {
            this.update_queue.add(new Object[]{tracker, response});
        }
    }

    @Override
    public void updateTracker(String key, TRTrackerAnnouncerRequest request2) {
        AllTrackersTrackerImpl tracker = this.register(null, key);
        if (tracker != null) {
            this.update_queue.add(new Object[]{tracker, request2});
        }
    }

    @Override
    public void updateTracker(URL url, TRTrackerScraperResponse response) {
        int scrape_state = response.getStatus();
        if (scrape_state != 0 && scrape_state != 3 && response.getPeers() >= 0 && response.getSeeds() >= 0) {
            AllTrackersTrackerImpl tracker = this.register(null, url);
            this.update_queue.add(new Object[]{tracker, response});
        }
    }

    void queueCommand(AllTrackersTrackerImpl tracker, String cmd) {
        this.update_queue.add(new Object[]{tracker, cmd});
    }

    @Override
    public AllTrackersManager.AllTrackersTracker getTracker(String name) {
        if (name == null) {
            return null;
        }
        return this.host_map.get(name);
    }

    @Override
    public AllTrackersManager.AllTrackersTracker getTracker(URL url) {
        AllTrackersTrackerImpl tracker = this.register(null, url);
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getLoggingEnabled(String short_key) {
        Object object = this.process_lock;
        synchronized (object) {
            return this.logging_keys.containsKey(short_key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoggingEnabled(String short_key, boolean enabled) {
        Object object = this.process_lock;
        synchronized (object) {
            if (enabled) {
                if (!this.logging_keys.containsKey(short_key)) {
                    this.logging_keys.put(short_key, this.getLogger(short_key));
                }
            } else {
                this.logging_keys.remove(short_key);
            }
        }
        this.update_queue.add(new Object[]{"logging_changed"});
    }

    private LoggerChannel getLogger(String short_key) {
        PluginInterface plugin_interface = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
        LoggerChannel log = plugin_interface.getLogger().getChannel("TrackerLog_" + FileUtil.convertOSSpecificChars(short_key, false));
        log.setDiagnostic(-1L, true);
        log.setForce(true);
        return log;
    }

    @Override
    public File getLogFile(String short_key) {
        LoggerChannel log = this.getLogger(short_key);
        File f = log.getCurrentFile(true);
        if (f != null && !f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f;
    }

    @Override
    public void addListener(AllTrackersManager.AllTrackersListener listener, boolean fire_for_existing) {
        ArrayList<AllTrackersTrackerImpl> existing;
        this.listeners.add(listener);
        if (fire_for_existing && !(existing = new ArrayList<AllTrackersTrackerImpl>(this.host_map.values())).isEmpty()) {
            listener.trackerEventOccurred(new AllTrackersEventImpl(0, existing));
        }
    }

    @Override
    public void removeListener(AllTrackersManager.AllTrackersListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ Core access$5(AllTrackersManagerImpl allTrackersManagerImpl) {
        return allTrackersManagerImpl.core;
    }

    private static class AllTrackersEventImpl
    implements AllTrackersManager.AllTrackersEvent {
        private final int type;
        private final List<AllTrackersManager.AllTrackersTracker> trackers;

        private AllTrackersEventImpl(int _type, List<AllTrackersManager.AllTrackersTracker> _trackers) {
            this.type = _type;
            this.trackers = _trackers;
        }

        @Override
        public int getEventType() {
            return this.type;
        }

        @Override
        public List<AllTrackersManager.AllTrackersTracker> getTrackers() {
            return this.trackers;
        }
    }

    private class AllTrackersTrackerImpl
    implements AllTrackersManager.AllTrackersTracker {
        private final String name;
        private final String short_key;
        private String status = "";
        private long last_good;
        private long last_bad;
        private long bad_since;
        private long consec_fails;
        private Map<String, Object> options;
        private Map<Long, long[]> session_stats;
        private long total_up;
        private long total_down;
        private boolean registered;
        private int num_private;
        private int num_public;
        private LoggerChannel logger;
        private long peers_received;
        private AtomicInteger active_request_count = new AtomicInteger();
        private MovingImmediateAverage request_average = AverageFactory.MovingImmediateAverage(5);

        private AllTrackersTrackerImpl(String _name) {
            String sk;
            this.name = _name;
            try {
                sk = DNSUtils.getInterestingHostSuffix(new URL(this.name).getHost().toLowerCase(Locale.US));
            }
            catch (Throwable e) {
                sk = null;
            }
            this.short_key = sk;
            this.updateLogger();
        }

        private AllTrackersTrackerImpl(Map map) throws IOException {
            String sk;
            this.name = MapUtils.getMapString(map, "name", null);
            if (this.name == null) {
                throw new IOException("Invalid");
            }
            try {
                sk = DNSUtils.getInterestingHostSuffix(new URL(this.name).getHost().toLowerCase(Locale.US));
            }
            catch (Throwable e) {
                sk = null;
            }
            this.short_key = sk;
            this.updateLogger();
            this.status = MapUtils.getMapString(map, "status", "");
            this.last_good = MapUtils.getMapLong(map, "lg", 0L);
            this.last_bad = MapUtils.getMapLong(map, "lb", 0L);
            this.bad_since = MapUtils.getMapLong(map, "bs", 0L);
            this.consec_fails = MapUtils.getMapLong(map, "cf", 0L);
            this.options = (Map)map.get("op");
            Map ss = (Map)map.get("ss");
            if (ss != null) {
                this.session_stats = new HashMap<Long, long[]>();
                for (Map.Entry entry : ss.entrySet()) {
                    try {
                        long id = Long.parseLong((String)entry.getKey());
                        List nums = (List)entry.getValue();
                        long[] vals = new long[nums.size()];
                        int i = 0;
                        while (i < vals.length) {
                            vals[i] = ((Number)nums.get(i)).longValue();
                            ++i;
                        }
                        this.session_stats.put(id, vals);
                        this.total_up += vals[1];
                        this.total_down += vals[2];
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }

        private void updateLogger() {
            this.logger = (LoggerChannel)AllTrackersManagerImpl.this.logging_keys.get(this.short_key);
        }

        private Map<String, Object> exportToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", this.name);
            map.put("status", this.status);
            map.put("lg", this.last_good);
            map.put("lb", this.last_bad);
            map.put("bs", this.bad_since);
            map.put("cf", this.consec_fails);
            if (this.options != null) {
                map.put("op", this.options);
            }
            if (this.session_stats != null) {
                long[] consolidated = null;
                for (long[] lArray : this.session_stats.values()) {
                    if (consolidated == null) {
                        consolidated = (long[])lArray.clone();
                        continue;
                    }
                    int i = 1;
                    while (i < Math.min(lArray.length, consolidated.length)) {
                        consolidated[i] = consolidated[i] + lArray[i];
                        ++i;
                    }
                }
                if (consolidated != null) {
                    consolidated[0] = SystemTime.getCurrentTime();
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    long[] lArray = consolidated;
                    int n = consolidated.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long l = lArray[n2];
                        arrayList.add(l);
                        ++n2;
                    }
                    HashMap<String, ArrayList<Long>> ss = new HashMap<String, ArrayList<Long>>();
                    ss.put("0", arrayList);
                    map.put("ss", ss);
                }
            }
            return map;
        }

        private void setRegistered() {
            this.registered = true;
        }

        private boolean isRegistered() {
            return this.registered;
        }

        private boolean updateCounts(int _pub, int _priv) {
            if (this.num_private != _priv || this.num_public != _pub) {
                this.num_private = _priv;
                this.num_public = _pub;
                return true;
            }
            return false;
        }

        @Override
        public int getTorrentCount() {
            return this.num_private + this.num_public;
        }

        @Override
        public int getActiveRequestCount() {
            return this.active_request_count.get();
        }

        protected void addActiveRequest() {
            this.active_request_count.incrementAndGet();
        }

        protected void removeActiveRequest() {
            this.active_request_count.decrementAndGet();
        }

        @Override
        public boolean isRemovable() {
            return this.getTorrentCount() == 0;
        }

        private void peersReceived(int num) {
            this.peers_received += (long)num;
        }

        @Override
        public long getPeersReceived() {
            return this.peers_received;
        }

        @Override
        public void remove() {
            AllTrackersManagerImpl.this.unregisterTracker(this.name);
        }

        @Override
        public String getTrackerName() {
            return this.name;
        }

        @Override
        public String getShortKey() {
            return this.short_key;
        }

        @Override
        public int getPrivatePercentage() {
            int total = this.num_private + this.num_public;
            if (total == 0) {
                return 0;
            }
            return this.num_private * 100 / total;
        }

        @Override
        public String getStatusString() {
            return this.status;
        }

        protected boolean hasStatus() {
            return !this.status.isEmpty();
        }

        protected boolean setStatusString(String str) {
            if (str == null) {
                str = "";
            }
            if (str.equals(this.status)) {
                return false;
            }
            this.status = str;
            return true;
        }

        protected boolean setOK(boolean is_ok) {
            boolean was_ok;
            long now = SystemTime.getCurrentTime();
            boolean bl = was_ok = this.consec_fails == 0L && this.last_good > 0L;
            if (was_ok == is_ok) {
                now = now / 60000L * 60000L;
                if (is_ok) {
                    if (this.last_good == now) {
                        return false;
                    }
                } else if (this.last_bad == now) {
                    ++this.consec_fails;
                    return false;
                }
            }
            if (is_ok) {
                this.last_good = now;
                this.bad_since = 0L;
                this.consec_fails = 0L;
            } else {
                this.last_bad = now;
                if (this.consec_fails == 0L) {
                    this.bad_since = now;
                }
                ++this.consec_fails;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        protected void log(TRTrackerAnnouncerResponse resp) {
            block5: {
                block8: {
                    block6: {
                        block7: {
                            if (this.logger == null || (hw = resp.getHash()) == null || resp.getStatus() == 2) break block5;
                            dm = AllTrackersManagerImpl.access$5(AllTrackersManagerImpl.this).getGlobalManager().getDownloadManager(hw);
                            if (dm != null) {
                                dm_name = dm.getDisplayName();
                                AllTrackersManagerImpl.access$6(AllTrackersManagerImpl.this).put(hw, dm_name);
                            } else {
                                dm_name = (String)AllTrackersManagerImpl.access$6(AllTrackersManagerImpl.this).get(hw);
                            }
                            if (dm_name == null) {
                                dm_name = "[" + ByteFormatter.encodeString(hw.getBytes()) + "]";
                            }
                            if ((req = resp.getRequest()) == null) break block6;
                            session = req.getSessionID();
                            sid = Long.toHexString(session);
                            if (sid.length() <= 4) ** GOTO lbl18
                            sid = sid.substring(0, 4);
                            break block7;
lbl-1000:
                            // 1 sources

                            {
                                sid = "0" + sid;
lbl18:
                                // 2 sources

                                ** while (sid.length() < 4)
                            }
                        }
                        if (req.isStopRequest()) {
                            sid = String.valueOf(sid) + "$";
                        }
                        req_details = ", session=" + sid + " - pending_sent=" + req.getReportedUpload() + ", pending_received=" + req.getReportedDownload();
                        break block8;
                    }
                    req_details = "";
                }
                this.logger.log(String.valueOf(dm_name) + ", " + this.name + req_details + " - " + resp.getStatusString());
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void log(TRTrackerAnnouncerRequest req, boolean incomplete) {
            block6: {
                block7: {
                    if (this.logger == null || (hw = req.getHash()) == null) break block6;
                    dm = AllTrackersManagerImpl.access$5(AllTrackersManagerImpl.this).getGlobalManager().getDownloadManager(hw);
                    if (dm != null) {
                        dm_name = dm.getDisplayName();
                        AllTrackersManagerImpl.access$6(AllTrackersManagerImpl.this).put(hw, dm_name);
                    } else {
                        dm_name = (String)AllTrackersManagerImpl.access$6(AllTrackersManagerImpl.this).get(hw);
                    }
                    if (dm_name == null) {
                        dm_name = "[" + ByteFormatter.encodeString(hw.getBytes()) + "]";
                    }
                    if ((sid = Long.toHexString(session = req.getSessionID())).length() <= 4) ** GOTO lbl15
                    sid = sid.substring(0, 4);
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        sid = "0" + sid;
lbl15:
                        // 2 sources

                        ** while (sid.length() < 4)
                    }
                }
                if (req.isStopRequest()) {
                    sid = String.valueOf(sid) + "$";
                }
                if (incomplete) {
                    sid = String.valueOf(sid) + "[Success unknown]";
                }
                this.logger.log(String.valueOf(dm_name) + ", " + this.name + ", session=" + sid + " - sent=" + req.getReportedUpload() + ", received=" + req.getReportedDownload());
            }
        }

        protected void updateSession(TRTrackerAnnouncerRequest req) {
            long elapsed;
            long[] values;
            long session_id = req.getSessionID();
            long up = req.getReportedUpload();
            long down = req.getReportedDownload();
            long now = SystemTime.getCurrentTime();
            if (up > 0L || down > 0L) {
                if (this.session_stats == null) {
                    this.session_stats = new HashMap<Long, long[]>();
                }
                this.session_stats.put(session_id, new long[]{now, up, down});
                long new_up = 0L;
                long new_down = 0L;
                for (long[] entry : this.session_stats.values()) {
                    new_up += entry[1];
                    new_down += entry[2];
                }
                this.total_up = new_up;
                this.total_down = new_down;
            }
            if (req.isStopRequest() && this.session_stats != null && (values = this.session_stats.remove(session_id)) != null) {
                long[] consolidated = this.session_stats.get(0L);
                if (consolidated == null) {
                    consolidated = values;
                    this.session_stats.put(0L, consolidated);
                } else {
                    int i = 1;
                    while (i < Math.min(values.length, consolidated.length)) {
                        consolidated[i] = consolidated[i] + values[i];
                        ++i;
                    }
                }
                consolidated[0] = now;
            }
            if ((elapsed = req.getElapsed()) >= 0L) {
                this.request_average.update(elapsed);
            }
        }

        protected void resetReportedStatsSupport() {
            this.session_stats = null;
            this.total_up = 0L;
            this.total_down = 0L;
        }

        @Override
        public long getLastGoodTime() {
            return this.last_good;
        }

        @Override
        public long getLastFailTime() {
            return this.last_bad;
        }

        @Override
        public long getFailingSinceTime() {
            return this.bad_since;
        }

        @Override
        public long getConsecutiveFails() {
            return this.consec_fails;
        }

        @Override
        public void resetReportedStats() {
            AllTrackersManagerImpl.this.queueCommand(this, "reset_stats");
        }

        @Override
        public long getTotalReportedDown() {
            return this.total_down;
        }

        @Override
        public long getTotalReportedUp() {
            return this.total_up;
        }

        @Override
        public Map<String, Object> getOptions() {
            return this.options;
        }

        @Override
        public void setOptions(Map<String, Object> _options) {
            this.options = _options;
            AllTrackersManagerImpl.this.options_mutation_count.incrementAndGet();
        }

        @Override
        public long getAverageRequestDuration() {
            if (this.request_average.getSampleCount() == 0) {
                return -1L;
            }
            return (long)this.request_average.getAverage();
        }
    }
}

