/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.client.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerException;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerHelper;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.pif.clientid.ClientIDException;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TRTrackerAnnouncerImpl
implements TRTrackerAnnouncer {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int LDT_TRACKER_RESPONSE = 1;
    private static final int LDT_URL_CHANGED = 2;
    private static final int LDT_URL_REFRESH = 3;
    private static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int key_id_length = 8;
    private static AtomicLong session_id_next = new AtomicLong(0L);
    protected final ListenerManager<TRTrackerAnnouncerListener> listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher<TRTrackerAnnouncerListener>(){

        @Override
        public void dispatch(TRTrackerAnnouncerListener listener, int type, Object value) {
            if (type == 1) {
                Object[] temp = (Object[])value;
                listener.receivedTrackerResponse((TRTrackerAnnouncerRequest)temp[0], (TRTrackerAnnouncerResponse)temp[1]);
            } else if (type == 2) {
                Object[] x = (Object[])value;
                URL old_url = (URL)x[0];
                URL new_url = (URL)x[1];
                boolean explicit = (Boolean)x[2];
                listener.urlChanged(TRTrackerAnnouncerImpl.this, old_url, new_url, explicit);
            } else {
                listener.urlRefresh();
            }
        }
    });
    final Map<String, TRTrackerAnnouncerResponsePeer> tracker_peer_cache = new LinkedHashMap<String, TRTrackerAnnouncerResponsePeer>();
    private final AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");
    private int cache_peers_used;
    private final TOTorrent torrent;
    private final byte[] peer_id;
    private final long session_id;
    private final String tracker_key;
    private final int udp_key;

    private static String createKeyID() {
        String key_id = "";
        int i = 0;
        while (i < 8) {
            int pos = RandomUtils.nextInt(chars.length());
            key_id = String.valueOf(key_id) + chars.charAt(pos);
            ++i;
        }
        return key_id;
    }

    protected TRTrackerAnnouncerImpl(TOTorrent _torrent) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.session_id = session_id_next.incrementAndGet();
        this.tracker_key = TRTrackerAnnouncerImpl.createKeyID();
        this.udp_key = RandomUtils.nextInt();
        try {
            byte[] hash = null;
            try {
                hash = this.torrent.getHash();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(hash, false);
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public Helper getHelper() {
        return new Helper(){

            @Override
            public byte[] getPeerID() {
                return TRTrackerAnnouncerImpl.this.peer_id;
            }

            @Override
            public long getSessionID() {
                return TRTrackerAnnouncerImpl.this.session_id;
            }

            @Override
            public String getTrackerKey() {
                return TRTrackerAnnouncerImpl.this.tracker_key;
            }

            @Override
            public int getUDPKey() {
                return TRTrackerAnnouncerImpl.this.udp_key;
            }

            @Override
            public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] peers) {
                TRTrackerAnnouncerImpl.this.addToTrackerCache(peers);
            }

            @Override
            public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int num_want) {
                return TRTrackerAnnouncerImpl.this.getPeersFromCache(num_want);
            }

            @Override
            public void setTrackerResponseCache(Map map) {
                TRTrackerAnnouncerImpl.this.setTrackerResponseCache(map);
            }

            @Override
            public void removeFromTrackerResponseCache(String ip, int tcpPort) {
                TRTrackerAnnouncerImpl.this.removeFromTrackerResponseCache(ip, tcpPort);
            }

            @Override
            public Map getTrackerResponseCache() {
                return TRTrackerAnnouncerImpl.this.getTrackerResponseCache();
            }

            @Override
            public void clearTrackerResponseCache() {
                TRTrackerAnnouncerImpl.this.clearTrackerResponseCache();
            }

            @Override
            public void informResponse(TRTrackerAnnouncerHelper helper, TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
                TRTrackerAnnouncerImpl.this.informResponse(helper, request2, response);
            }

            @Override
            public void informURLChange(URL old_url, URL new_url, boolean explicit) {
                TRTrackerAnnouncerImpl.this.listeners.dispatch(2, new Object[]{old_url, new_url, explicit});
            }

            @Override
            public void informURLRefresh() {
                TRTrackerAnnouncerImpl.this.informURLRefresh();
            }

            @Override
            public void addListener(TRTrackerAnnouncerListener l) {
                TRTrackerAnnouncerImpl.this.addListener(l);
            }

            @Override
            public void removeListener(TRTrackerAnnouncerListener l) {
                TRTrackerAnnouncerImpl.this.removeListener(l);
            }
        };
    }

    @Override
    public byte[] getPeerId() {
        return this.peer_id;
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    @Override
    public void clearTrackerResponseCache() {
        try {
            this.tracker_peer_cache_mon.enter();
            this.tracker_peer_cache.clear();
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        int num = this.importTrackerCache(map);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: imported " + num + " cached peers"));
        }
    }

    protected Map exportTrackerCache() {
        LightHashMap res = new LightHashMap(1);
        try {
            this.tracker_peer_cache_mon.enter();
            if (!this.tracker_peer_cache.isEmpty()) {
                ArrayList peers = new ArrayList();
                res.put("tracker_peers", peers);
                for (TRTrackerAnnouncerResponsePeer peer : this.tracker_peer_cache.values()) {
                    int http_port;
                    LightHashMap entry = new LightHashMap();
                    entry.put("ip", peer.getAddress().getBytes());
                    entry.put("src", peer.getSource().getBytes());
                    entry.put("port", new Long(peer.getPort()));
                    int udp_port = peer.getUDPPort();
                    if (udp_port != 0) {
                        entry.put("udpport", new Long(udp_port));
                    }
                    if ((http_port = peer.getHTTPPort()) != 0) {
                        entry.put("httpport", new Long(http_port));
                    }
                    entry.put("prot", new Long(peer.getProtocol()));
                    byte az_ver = peer.getAZVersion();
                    if (az_ver != 1) {
                        entry.put("azver", new Long(az_ver));
                    }
                    entry.compactify(0.9f);
                    peers.add(entry);
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers"));
                }
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
        return res;
    }

    protected int importTrackerCache(Map map) {
        block12: {
            if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
                return 0;
            }
            if (map != null) break block12;
            return 0;
        }
        NetworkAdmin admin = NetworkAdmin.getSingleton();
        try {
            this.tracker_peer_cache_mon.enter();
            List<TRTrackerAnnouncerResponsePeer> peers = TRTrackerAnnouncerFactoryImpl.getCachedPeers(map);
            for (TRTrackerAnnouncerResponsePeer peer : peers) {
                String address = peer.getAddress();
                String network = AENetworkClassifier.categoriseAddress(address);
                if (network == "Public") {
                    try {
                        InetAddress ip = InetAddress.getByName(address);
                        if (admin.isRecentPublicIPAddress(ip)) {
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.tracker_peer_cache.put(peer.getKey(), peer);
            }
            int n = this.tracker_peer_cache.size();
            this.tracker_peer_cache_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return this.tracker_peer_cache.size();
            }
        }
    }

    protected void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] peers) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int max = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        NetworkAdmin admin = NetworkAdmin.getSingleton();
        try {
            this.tracker_peer_cache_mon.enter();
            int i = 0;
            while (i < peers.length) {
                block11: {
                    TRTrackerAnnouncerResponsePeerImpl peer;
                    block10: {
                        peer = peers[i];
                        String address = peer.getAddress();
                        String network = AENetworkClassifier.categoriseAddress(address);
                        if (network == "Public") {
                            try {
                                InetAddress ip = InetAddress.getByName(address);
                                if (!admin.isRecentPublicIPAddress(ip)) break block10;
                                break block11;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    peer = peer.getClone();
                    peer.setCached(true);
                    this.tracker_peer_cache.remove(peer.getKey());
                    this.tracker_peer_cache.put(peer.getKey(), peer);
                }
                ++i;
            }
            Iterator<String> it = this.tracker_peer_cache.keySet().iterator();
            if (max > 0) {
                while (this.tracker_peer_cache.size() > max) {
                    it.next();
                    it.remove();
                }
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    @Override
    public void removeFromTrackerResponseCache(String ip, int tcp_port) {
        try {
            this.tracker_peer_cache_mon.enter();
            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("", new byte[0], ip, tcp_port, 0, 0, 0, 0, 0);
            if (this.tracker_peer_cache.remove(peer.getKey()) != null && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "Explicit removal of peer cache for " + ip + ":" + tcp_port));
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        List p2;
        if (map1 == null && map2 == null) {
            return new HashMap();
        }
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        HashMap res = new HashMap();
        ArrayList peers = (ArrayList)map1.get("tracker_peers");
        if (peers == null) {
            peers = new ArrayList();
        }
        if ((p2 = (List)map2.get("tracker_peers")) != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TRTrackerClient: merged peer sets: p1 = " + peers.size() + ", p2 = " + p2.size()));
            }
            peers.addAll(p2);
        }
        res.put("tracker_peers", peers);
        return res;
    }

    protected abstract int getPeerCacheLimit();

    protected TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int num_want) {
        int limit = this.getPeerCacheLimit();
        if (limit <= 0) {
            return new TRTrackerAnnouncerResponsePeer[0];
        }
        num_want = Math.min(limit, num_want);
        try {
            TRTrackerAnnouncerResponsePeer[] res;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() <= num_want) {
                res = new TRTrackerAnnouncerResponsePeerImpl[this.tracker_peer_cache.size()];
                this.tracker_peer_cache.values().toArray(res);
            } else {
                res = new TRTrackerAnnouncerResponsePeerImpl[num_want];
                Iterator<String> it = this.tracker_peer_cache.keySet().iterator();
                int i = 0;
                while (i < num_want) {
                    String key = it.next();
                    res[i] = (TRTrackerAnnouncerResponsePeerImpl)this.tracker_peer_cache.get(key);
                    it.remove();
                    ++i;
                }
                i = 0;
                while (i < num_want) {
                    this.tracker_peer_cache.put(res[i].getKey(), res[i]);
                    ++i;
                }
            }
            if (Logger.isEnabled()) {
                int i = 0;
                while (i < res.length) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "CACHED PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)res[i]).getString()));
                    ++i;
                }
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: returned " + res.length + " cached peers"));
            }
            this.cache_peers_used += res.length;
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = res;
            return tRTrackerAnnouncerResponsePeerArray;
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            @Override
            public String getName() {
                return MessageText.getString("tps.tracker.cache1", new String[]{String.valueOf(TRTrackerAnnouncerImpl.this.cache_peers_used)});
            }

            @Override
            public int getPeers() {
                return TRTrackerAnnouncerImpl.this.tracker_peer_cache.size();
            }
        };
    }

    protected void informResponse(TRTrackerAnnouncerHelper helper, TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
        this.listeners.dispatch(1, new Object[]{request2, response});
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener l) {
        this.listeners.addListener(l);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener l) {
        this.listeners.removeListener(l);
    }

    public static interface Helper {
        public byte[] getPeerID();

        public long getSessionID();

        public String getTrackerKey();

        public int getUDPKey();

        public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] var1);

        public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int var1);

        public void setTrackerResponseCache(Map var1);

        public void clearTrackerResponseCache();

        public void removeFromTrackerResponseCache(String var1, int var2);

        public Map getTrackerResponseCache();

        public void informResponse(TRTrackerAnnouncerHelper var1, TRTrackerAnnouncerRequest var2, TRTrackerAnnouncerResponse var3);

        public void informURLChange(URL var1, URL var2, boolean var3);

        public void informURLRefresh();

        public void addListener(TRTrackerAnnouncerListener var1);

        public void removeListener(TRTrackerAnnouncerListener var1);
    }
}

