/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.client.impl.bt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.dht.netcoords.DHTNetworkPosition;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peermanager.utils.PeerClassifier;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerDataProvider;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerException;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.TRTrackerScraper;
import com.biglybt.core.tracker.client.TRTrackerScraperFactory;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerHelper;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerRequestImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerScraperResponseImpl;
import com.biglybt.core.tracker.protocol.PRHelpers;
import com.biglybt.core.tracker.protocol.udp.PRUDPTrackerCodecs;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.BoringException;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.Timer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.clientid.ClientIDException;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAnnounceResultPeer;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TRTrackerBTAnnouncerImpl
implements TRTrackerAnnouncerHelper {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int OVERRIDE_PERIOD = 10000;
    private static final Timer tracker_timer_public = new Timer("Tracker Announce Public Timer", COConfigurationManager.getIntParameter("Tracker Client Concurrent Announce"));
    private static final Timer tracker_timer_private = new Timer("Tracker Announce Private Timer", COConfigurationManager.getIntParameter("Tracker Client Concurrent Announce"));
    private static final AllTrackersManager.AllTrackers all_trackers = AllTrackersManager.getAllTrackers();
    public static final String UDP_REALM = "UDP Tracker";
    private static int userMinInterval;
    private static int userMaxNumwant;
    private static boolean tcpAnnounceEnabled;
    private static boolean udpAnnounceEnabled;
    private static boolean udpProbeEnabled;
    private static final AEMonitor class_mon;
    private static final Map tracker_report_map;
    private final Timer tracker_timer;
    private final TOTorrent torrent;
    private final TOTorrentAnnounceURLSet[] announce_urls;
    private TRTrackerAnnouncerImpl.Helper helper;
    private TimerEvent current_timer_event;
    private TimerEventPerformer timer_event_action;
    protected int tracker_state = 1;
    private String tracker_status_str = "";
    private TRTrackerAnnouncerResponseImpl last_response = null;
    private long last_update_time_secs;
    private long current_time_to_wait_secs;
    private final boolean manual_control;
    private final int dispersal_random = RandomUtils.nextInt(10);
    private long tracker_interval;
    private long tracker_min_interval;
    private long min_interval = 0L;
    private int failure_added_time = 0;
    private long failure_time_last_updated = 0L;
    private boolean stopped;
    private boolean stopped_for_queue;
    private boolean completed;
    private boolean complete_reported = false;
    private boolean update_in_progress = false;
    private long rd_last_override = 0L;
    private int rd_override_percentage = 100;
    private long min_interval_override = 0L;
    private List<List<URL>> trackerUrlLists;
    private URL lastUsedUrl;
    private URL lastAZTrackerCheckedURL;
    private final HashWrapper torrent_hash_actual;
    private final HashWrapper torrent_hash_target;
    private String last_tracker_message;
    private String info_hash = "info_hash=";
    private byte[] tracker_peer_id;
    private String tracker_peer_id_str = "&peer_id=";
    private byte[] data_peer_id;
    private int announceCount;
    private int announceFailCount;
    private byte autoUDPprobeEvery = 1;
    private int autoUDPProbeSuccessCount;
    private InetSocketAddress working_udp_ia;
    private String tracker_id = "";
    private String ip_override;
    private final String[] peer_networks;
    private TRTrackerAnnouncerDataProvider announce_data_provider;
    protected final AEMonitor this_mon = new AEMonitor("TRTrackerBTAnnouncer");
    private boolean az_tracker;
    private boolean enable_sni_hack;
    private boolean internal_error_hack;
    private boolean dh_hack;
    private boolean destroyed;

    static {
        all_trackers.registerAnnounceStatsProvider(new AllTrackersManager.AnnounceStatsProvider(){
            private volatile AllTrackersManager.AnnounceStats last_stats = null;
            private volatile long last_stats_time;

            @Override
            public AllTrackersManager.AnnounceStats getStats() {
                if (this.last_stats == null || SystemTime.getMonotonousTime() - this.last_stats_time > 900L) {
                    this.last_stats = new AllTrackersManager.AnnounceStats(){
                        private final long public_lag = TRTrackerBTAnnouncerImpl.access$0().getLag();
                        private final long private_lag = TRTrackerBTAnnouncerImpl.access$1().getLag();
                        private final int public_sched = TRTrackerBTAnnouncerImpl.access$0().getEventCount();
                        private final int private_sched = TRTrackerBTAnnouncerImpl.access$1().getEventCount();
                        private final int public_pending = TRTrackerBTAnnouncerImpl.access$0().getEventCount(SystemTime.getCurrentTime());
                        private final int private_pending = TRTrackerBTAnnouncerImpl.access$1().getEventCount(SystemTime.getCurrentTime());
                        final List<String> public_active;
                        final List<String> private_active;
                        {
                            List<TimerEvent> events = tracker_timer_public.getActiveEvents();
                            long mono_now = SystemTime.getMonotonousTime();
                            this.public_active = new ArrayList<String>(events.size());
                            for (TimerEvent e : events) {
                                this.public_active.add(String.valueOf(e.getName()) + " (" + (mono_now - e.getExecutionStartMonoTime()) + " " + MessageText.getString("ConfigView.section.stats.millis.short") + ")");
                            }
                            events = tracker_timer_private.getActiveEvents();
                            this.private_active = new ArrayList<String>(events.size());
                            for (TimerEvent e : events) {
                                this.private_active.add(String.valueOf(e.getName()) + " (" + (mono_now - e.getExecutionStartMonoTime()) + " " + MessageText.getString("ConfigView.section.stats.millis.short") + ")");
                            }
                        }

                        @Override
                        public long getPublicLagMillis() {
                            return this.public_lag;
                        }

                        @Override
                        public long getPrivateLagMillis() {
                            return this.private_lag;
                        }

                        @Override
                        public List<String> getPublicActive() {
                            return this.public_active;
                        }

                        @Override
                        public List<String> getPrivateActive() {
                            return this.private_active;
                        }

                        @Override
                        public int getPublicScheduledCount() {
                            return this.public_sched;
                        }

                        @Override
                        public int getPrivateScheduledCount() {
                            return this.private_sched;
                        }

                        @Override
                        public int getPublicPendingCount() {
                            return this.public_pending;
                        }

                        @Override
                        public int getPrivatePendingCount() {
                            return this.private_pending;
                        }
                    };
                    this.last_stats_time = SystemTime.getMonotonousTime();
                }
                return this.last_stats;
            }
        });
        SimpleTimer.addEvent("TA Timer Checker", SystemTime.getOffsetTime(60000L), e -> {
            TRTrackerBTAnnouncerImpl.analyseTimerEvents();
            SimpleTimer.addPeriodicEvent("TA Timer Checker", 120000L, ev -> TRTrackerBTAnnouncerImpl.analyseTimerEvents());
        });
        COConfigurationManager.addParameterListener("Tracker Client Concurrent Announce", name -> {
            tracker_timer_public.getThreadPool().setMaxThreads(COConfigurationManager.getIntParameter(name));
            tracker_timer_private.getThreadPool().setMaxThreads(COConfigurationManager.getIntParameter(name));
        });
        userMinInterval = 0;
        userMaxNumwant = 100;
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Min Announce Interval", "Tracker Client Numwant Limit", "Tracker Client Enable TCP", "Server Enable UDP", "Tracker UDP Probe Enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                userMinInterval = COConfigurationManager.getIntParameter("Tracker Client Min Announce Interval");
                userMaxNumwant = COConfigurationManager.getIntParameter("Tracker Client Numwant Limit");
                tcpAnnounceEnabled = COConfigurationManager.getBooleanParameter("Tracker Client Enable TCP");
                udpAnnounceEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
                udpProbeEnabled = COConfigurationManager.getBooleanParameter("Tracker UDP Probe Enable");
            }
        });
        class_mon = new AEMonitor("TRTrackerBTAnnouncer:class");
        tracker_report_map = new HashMap();
    }

    static void analyseTimerEvents() {
        TRTrackerBTAnnouncerImpl.analyseTimerEvents(tracker_timer_public);
        TRTrackerBTAnnouncerImpl.analyseTimerEvents(tracker_timer_private);
    }

    static void analyseTimerEvents(Timer timer) {
        if (all_trackers.isStopping()) {
            return;
        }
        int total_events = timer.getEventCount();
        if (total_events < 30 || total_events > 5000) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        int secs_to_check = 900;
        int bucket_secs = 60;
        List<TimerEvent> events = timer.getEvents(now + 900000L);
        List[] buckets = new List[15];
        int i = 0;
        while (i < buckets.length) {
            buckets[i] = new LinkedList();
            ++i;
        }
        for (TimerEvent ev : events) {
            long when = ev.getWhen();
            if (when < now) continue;
            int slot = (int)((when - now) / 60000L);
            if (slot >= buckets.length) break;
            buckets[slot].add(ev);
        }
        int max_size = 0;
        List[] slot = buckets;
        int n = buckets.length;
        int when = 0;
        while (when < n) {
            List l = slot[when];
            max_size = Math.max(max_size, l.size());
            ++when;
        }
        if (max_size < 10) {
            return;
        }
        int limit = max_size / 2;
        int i2 = 0;
        while (i2 < buckets.length) {
            List list = buckets[i2];
            int num_events = list.size();
            if (i2 != 0 && num_events >= limit) {
                long inc;
                long start = now + (long)(i2 * 60 * 1000);
                long end = start + 90000L;
                TimerEvent first = (TimerEvent)list.get(0);
                if (first.getWhen() > start) {
                    start = first.getWhen();
                }
                if ((inc = (end - start) / (long)num_events) > 100L) {
                    long new_time = start;
                    for (TimerEvent ev : list) {
                        long change = new_time - ev.getWhen();
                        if (change > 0L) {
                            timer.modifyWhen(ev, new_time);
                        }
                        new_time += inc;
                    }
                }
            }
            ++i2;
        }
    }

    public TRTrackerBTAnnouncerImpl(HashWrapper _torrent_hash_override, TOTorrent _torrent, TOTorrentAnnounceURLSet[] _announce_urls, String[] _peer_networks, boolean _manual, TRTrackerAnnouncerImpl.Helper _helper) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.announce_urls = _announce_urls;
        this.peer_networks = _peer_networks;
        this.manual_control = _manual;
        this.helper = _helper;
        this.tracker_timer = this.torrent.getPrivate() ? tracker_timer_private : tracker_timer_public;
        try {
            this.torrent_hash_actual = _torrent.getHashWrapper();
        }
        catch (TOTorrentException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Torrent hash retrieval fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Torrent hash retrieval fails");
        }
        this.torrent_hash_target = _torrent_hash_override == null ? this.torrent_hash_actual : _torrent_hash_override;
        this.constructTrackerUrlLists(true);
        try {
            this.data_peer_id = this.helper.getPeerID();
            this.tracker_peer_id = COConfigurationManager.getBooleanParameter("Tracker Separate Peer IDs") ? ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent_hash_target.getBytes(), true) : this.data_peer_id;
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        try {
            this.info_hash = String.valueOf(this.info_hash) + URLEncoder.encode(new String(this.torrent_hash_target.getBytes(), Constants.BYTE_ENCODING_CHARSET), Constants.BYTE_ENCODING_CHARSET.name()).replaceAll("\\+", "%20");
            this.tracker_peer_id_str = String.valueOf(this.tracker_peer_id_str) + URLEncoder.encode(new String(this.tracker_peer_id, Constants.BYTE_ENCODING_CHARSET), Constants.BYTE_ENCODING_CHARSET.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "URL encode fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        this.timer_event_action = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent this_event) {
                if (TRTrackerBTAnnouncerImpl.this.manual_control) {
                    TRTrackerBTAnnouncerImpl.this.requestUpdateSupport(this_event);
                    return;
                }
                long secs_to_wait = TRTrackerBTAnnouncerImpl.this.getErrorRetryInterval();
                try {
                    secs_to_wait = TRTrackerBTAnnouncerImpl.this.requestUpdateSupport(this_event);
                    if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4 && Logger.isEnabled()) {
                        Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.this.torrent, LOGID, "Next tracker announce (unadjusted) will be in " + secs_to_wait + "s"));
                    }
                }
                finally {
                    TRTrackerBTAnnouncerImpl.this.current_time_to_wait_secs = secs_to_wait;
                    if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                        try {
                            TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                            if (!this_event.isCancelled()) {
                                secs_to_wait = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.this.torrent, LOGID, "Next tracker announce (adjusted) will be in " + secs_to_wait + "s"));
                                }
                                long target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                                if (TRTrackerBTAnnouncerImpl.this.current_timer_event != null && !TRTrackerBTAnnouncerImpl.this.current_timer_event.isCancelled()) {
                                    if (TRTrackerBTAnnouncerImpl.this.current_timer_event != this_event && TRTrackerBTAnnouncerImpl.this.current_timer_event.getWhen() < target_time) {
                                        return;
                                    }
                                    TRTrackerBTAnnouncerImpl.this.current_timer_event.cancel();
                                }
                                if (!TRTrackerBTAnnouncerImpl.this.destroyed) {
                                    TRTrackerBTAnnouncerImpl.this.current_timer_event = TRTrackerBTAnnouncerImpl.this.tracker_timer.addEvent(target_time, this);
                                }
                            }
                        }
                        finally {
                            TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                        }
                    }
                }
            }
        };
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer Created using url : " + this.trackerURLListToString()));
        }
    }

    public void cloneFrom(TRTrackerBTAnnouncerImpl other) {
        this.helper = other.helper;
        this.data_peer_id = other.data_peer_id;
        this.tracker_peer_id = other.tracker_peer_id;
        this.tracker_peer_id_str = other.tracker_peer_id_str;
        this.tracker_id = other.tracker_id;
        this.announce_data_provider = other.announce_data_provider;
    }

    protected long getAdjustedSecsToWait() {
        long secs_to_wait = this.current_time_to_wait_secs;
        if (this.last_response != null && this.last_response.getStatus() != 2) {
            if (this.last_response.getStatus() == 1) {
                if (this.failure_added_time < 900) {
                    this.failure_added_time = 900;
                }
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker reported error, adjusting to error retry interval: " + secs_to_wait));
                }
            } else {
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker seems to be offline, adjusting to error retry interval: " + secs_to_wait));
                }
            }
        } else if (this.rd_override_percentage == 0) {
            secs_to_wait = 60L;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = 0: " + secs_to_wait));
            }
        } else {
            if (this.rd_override_percentage != 100) {
                secs_to_wait = secs_to_wait * (long)this.rd_override_percentage / 100L;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = " + this.rd_override_percentage + ": " + secs_to_wait));
                }
            }
            if (secs_to_wait < 60L) {
                secs_to_wait = 60L;
            }
            if (this.min_interval != 0L && secs_to_wait < this.min_interval) {
                float percentage;
                int added_secs;
                if ((secs_to_wait += (long)(added_secs = (int)((float)(this.min_interval - secs_to_wait) * (percentage = (float)this.min_interval / (float)secs_to_wait) / 100.0f))) > this.tracker_interval) {
                    secs_to_wait = this.tracker_interval;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: min_interval=" + this.min_interval + ", interval=" + this.current_time_to_wait_secs + ", orig=" + this.current_time_to_wait_secs + ", new=" + secs_to_wait + ", added=" + added_secs + ", perc=" + percentage));
                }
            }
        }
        return secs_to_wait += (long)this.dispersal_random;
    }

    @Override
    public int getStatus() {
        return this.tracker_state;
    }

    @Override
    public String getStatusString() {
        return this.tracker_status_str;
    }

    @Override
    public TRTrackerAnnouncer getBestAnnouncer() {
        return this;
    }

    @Override
    public void setRefreshDelayOverrides(int percentage) {
        boolean override_allowed;
        if (percentage > 100) {
            percentage = 100;
        } else if (percentage < 50) {
            percentage = 50;
        }
        long now = SystemTime.getCurrentTime();
        boolean bl = override_allowed = this.rd_last_override > 0L && now - this.rd_last_override > 10000L;
        if (now < this.rd_last_override) {
            override_allowed = true;
        }
        if (override_allowed && this.rd_override_percentage != percentage) {
            try {
                long expiry;
                this.this_mon.enter();
                this.rd_last_override = now;
                this.rd_override_percentage = percentage;
                if (this.current_timer_event != null && !this.current_timer_event.isCancelled() && (expiry = this.current_timer_event.getWhen()) >= now + 10000L) {
                    long secs_to_wait;
                    long start = this.current_timer_event.getCreatedTime();
                    long target_time = start + (secs_to_wait = this.getAdjustedSecsToWait()) * 1000L;
                    if (target_time < now) {
                        target_time = now;
                    }
                    if (target_time != expiry) {
                        this.current_timer_event.cancel();
                        if (!this.destroyed) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "Changed next tracker announce to " + secs_to_wait + "s via " + Debug.getStackTrace(true, false, 0, 3)));
                            }
                            this.current_timer_event = this.tracker_timer.addEvent(start, target_time, this.timer_event_action);
                        }
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public boolean isUpdating() {
        return this.update_in_progress;
    }

    @Override
    public long getInterval() {
        return this.tracker_interval;
    }

    @Override
    public long getMinInterval() {
        return this.tracker_min_interval;
    }

    @Override
    public int getTimeUntilNextUpdate() {
        try {
            int rem;
            this.this_mon.enter();
            if (this.current_timer_event == null) {
                int n = this.getErrorRetryInterval();
                return n;
            }
            int n = rem = (int)((this.current_timer_event.getWhen() - SystemTime.getCurrentTime()) / 1000L);
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getLastUpdateTime() {
        return (int)this.last_update_time_secs;
    }

    @Override
    public void update(boolean force) {
        long effective_min;
        long now = SystemTime.getCurrentTime() / 1000L;
        if (now < this.last_update_time_secs) {
            force = true;
        }
        long l = effective_min = this.min_interval_override > 0L ? this.min_interval_override : 60L;
        if (this.manual_control || force || now - this.last_update_time_secs >= effective_min) {
            this.requestUpdate();
        }
    }

    @Override
    public void complete(boolean already_reported) {
        this.complete_reported = this.complete_reported || already_reported;
        this.completed = true;
        this.requestUpdate();
    }

    @Override
    public void stop(boolean for_queue) {
        this.stopped = true;
        this.stopped_for_queue = for_queue;
        this.requestUpdate();
    }

    protected void requestUpdate() {
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null) {
                long now = SystemTime.getCurrentTime();
                if (this.current_timer_event.getWhen() <= now) {
                    return;
                }
                this.current_timer_event.cancel();
            }
            this.rd_last_override = SystemTime.getCurrentTime();
            if (!this.destroyed) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Forcing tracker announce now via " + Debug.getStackTrace(true, false, 0, 3)));
                }
                this.current_timer_event = this.tracker_timer.addEvent(SystemTime.getCurrentTime(), this.timer_event_action);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long requestUpdateSupport(TimerEvent timer_event) {
        boolean clear_progress = true;
        try {
            try {
                this.this_mon.enter();
                if (this.update_in_progress || this.announce_data_provider == null) {
                    clear_progress = false;
                    long l = this.getErrorRetryInterval();
                    return l;
                }
                this.update_in_progress = true;
            }
            finally {
                this.this_mon.exit();
            }
            this.last_update_time_secs = SystemTime.getCurrentTime() / 1000L;
            this.tracker_status_str = String.valueOf(MessageText.getString("PeerManager.status.checking")) + "...";
            TRTrackerAnnouncerResponseImpl response = null;
            if (this.stopped) {
                if (this.tracker_state == 1 && !this.manual_control) {
                    this.tracker_state = 4;
                } else if (this.tracker_state != 4) {
                    response = this.stopSupport(timer_event);
                    this.tracker_state = response.getStatus() == 2 ? 4 : 4;
                }
            } else if (this.tracker_state == 1) {
                response = this.startSupport(timer_event);
                if (response.getStatus() == 2) {
                    this.tracker_state = 2;
                }
            } else if (this.completed) {
                if (!this.complete_reported) {
                    response = this.completeSupport(timer_event);
                    if (response.getStatus() != 0) {
                        this.complete_reported = true;
                        this.tracker_state = 3;
                    }
                } else {
                    this.tracker_state = 3;
                    response = this.updateSupport(timer_event);
                }
            } else {
                response = this.updateSupport(timer_event);
            }
            if (response != null) {
                int rs = response.getStatus();
                if (rs == 0) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.offline");
                } else if (rs == 1) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.error");
                    this.tracker_state = 1;
                } else if (this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
                    if (response.wasProbe()) {
                        this.tracker_status_str = String.valueOf(this.tracker_status_str) + " (" + MessageText.getString("label.udp_probe") + ")";
                    }
                } else {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ps_disabled");
                    response.setPeers(new TRTrackerAnnouncerResponsePeerImpl[0]);
                }
                String reason = response.getAdditionalInfo();
                if (reason != null) {
                    this.tracker_status_str = String.valueOf(this.tracker_status_str) + " (" + reason + ")";
                }
                this.last_response = response;
                TRTrackerAnnouncerRequest request2 = response.getRequest();
                if (request2 == null) {
                    request2 = new TRTrackerAnnouncerRequestImpl();
                }
                this.helper.informResponse(this, request2, response);
                long l = response.getTimeToWait();
                return l;
            }
            this.tracker_status_str = "";
            long l = this.getErrorRetryInterval();
            return l;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            long l = this.getErrorRetryInterval();
            return l;
        }
        finally {
            try {
                this.this_mon.enter();
                if (clear_progress) {
                    this.update_in_progress = false;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected TRTrackerAnnouncerResponseImpl startSupport(TimerEvent timer_event) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a start Request"));
        }
        return this.update("started", timer_event);
    }

    protected TRTrackerAnnouncerResponseImpl completeSupport(TimerEvent timer_event) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a completed Request"));
        }
        return this.update("completed", timer_event);
    }

    protected TRTrackerAnnouncerResponseImpl stopSupport(TimerEvent timer_event) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a stopped Request"));
        }
        return this.update("stopped", timer_event);
    }

    protected TRTrackerAnnouncerResponseImpl updateSupport(TimerEvent timer_event) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending an update Request"));
        }
        return this.update("", timer_event);
    }

    private TRTrackerAnnouncerResponseImpl update(String evt, TimerEvent timer_event) {
        TRTrackerAnnouncerResponseImpl resp = this.update2(evt, timer_event);
        TRTrackerAnnouncerResponsePeer[] peers = resp.getPeers();
        if (peers != null) {
            ArrayList<TRTrackerAnnouncerResponsePeer> p = new ArrayList<TRTrackerAnnouncerResponsePeer>();
            int i = 0;
            while (i < peers.length) {
                TRTrackerAnnouncerResponsePeer peer = peers[i];
                if (this.peer_networks == null) {
                    p.add(peer);
                } else {
                    String peer_address = peer.getAddress();
                    String peer_network = AENetworkClassifier.categoriseAddress(peer_address);
                    boolean added = false;
                    int j = 0;
                    while (j < this.peer_networks.length) {
                        if (this.peer_networks[j] == peer_network) {
                            p.add(peer);
                            added = true;
                            break;
                        }
                        ++j;
                    }
                    if (!added && Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer dropped peer '" + peer_address + "' as incompatible " + "with network selection"));
                    }
                }
                ++i;
            }
            peers = new TRTrackerAnnouncerResponsePeer[p.size()];
            p.toArray(peers);
            resp.setPeers(peers);
        }
        return resp;
    }

    private TRTrackerAnnouncerResponseImpl update2(String evt, TimerEvent timer_event) {
        TRTrackerAnnouncerResponseImpl resp = this.update2Support(evt, timer_event);
        URL url = resp.getURL();
        if (url != null) {
            all_trackers.updateTracker(url, resp);
        }
        return resp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TRTrackerAnnouncerResponseImpl update2Support(String evt, TimerEvent event2) {
        int num_want;
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        TRTrackerAnnouncerResponseImpl last_failure_resp = null;
        String skip_host = null;
        int i = 0;
        block9: while (i < this.trackerUrlLists.size()) {
            List<URL> urls = this.trackerUrlLists.get(i);
            int j = 0;
            while (j < urls.size()) {
                URL original_url = urls.get(j);
                if (skip_host != null && skip_host.equals(original_url.getHost())) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer is ignoring '" + original_url + "' as already received overloaded response from this host"));
                    }
                } else {
                    block23: {
                        this.lastUsedUrl = original_url;
                        if (this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                            this.az_tracker = TRTrackerUtils.isAZTracker(this.lastUsedUrl);
                        }
                        URL request_url = null;
                        if (last_failure_resp != null) {
                            this.helper.informResponse(this, new TRTrackerAnnouncerRequestImpl(), last_failure_resp);
                        }
                        TRTrackerAnnouncerRequestImpl request_obj = null;
                        try {
                            request_obj = this.constructRequest(evt, original_url, event2);
                            all_trackers.addActiveRequest(request_obj);
                            long start = SystemTime.getMonotonousTime();
                            try {
                                request_url = request_obj.getURL();
                                URL[] tracker_url = new URL[]{original_url};
                                int prev_udp_probes_ok = this.autoUDPProbeSuccessCount;
                                byte[] result_bytes = this.updateOld(tracker_url, request_url);
                                this.lastUsedUrl = tracker_url[0];
                                TRTrackerAnnouncerResponseImpl resp = this.decodeTrackerResponse(this.lastUsedUrl, result_bytes);
                                resp.setRequest(request_obj);
                                int resp_status = resp.getStatus();
                                if (resp_status == 2) {
                                    if (this.autoUDPProbeSuccessCount > prev_udp_probes_ok) {
                                        resp.setWasProbe();
                                    }
                                    try {
                                        if (!original_url.toString().equals(this.lastUsedUrl.toString())) {
                                            if (Logger.isEnabled()) {
                                                Logger.log(new LogEvent(this.torrent, LOGID, "announce url permanently redirected: old = " + original_url + ", new = " + this.lastUsedUrl));
                                            }
                                            TorrentUtils.replaceAnnounceURL(this.torrent, original_url, this.lastUsedUrl);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                    urls.remove(j);
                                    urls.add(0, this.lastUsedUrl);
                                    this.trackerUrlLists.remove(i);
                                    this.trackerUrlLists.add(0, urls);
                                    this.informURLChange(original_url, this.lastUsedUrl, false);
                                    TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl = resp;
                                    return tRTrackerAnnouncerResponseImpl;
                                }
                                if (resp_status == 1) {
                                    last_failure_resp = resp;
                                    String reason = resp.getAdditionalInfo();
                                    if (reason != null && (reason.contains("too many seeds") || reason.contains("too many peers"))) {
                                        skip_host = original_url.getHost();
                                    }
                                    break block23;
                                }
                                ++this.announceFailCount;
                                last_failure_resp = resp;
                            }
                            finally {
                                request_obj.setElapsed(SystemTime.getMonotonousTime() - start);
                                all_trackers.removeActiveRequest(request_obj);
                            }
                        }
                        catch (MalformedURLException e) {
                            ++this.announceFailCount;
                            Debug.printStackTrace(e);
                            last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), "malformed URL '" + (request_url == null ? "<null>" : request_url.toString()) + "'");
                            last_failure_resp.setRequest(request_obj);
                        }
                        catch (Throwable e) {
                            ++this.announceFailCount;
                            last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), e.getMessage() == null ? e.toString() : e.getMessage());
                            last_failure_resp.setRequest(request_obj);
                        }
                    }
                    if (this.destroyed) break block9;
                }
                ++j;
            }
            ++i;
        }
        if (last_failure_resp == null) {
            last_failure_resp = new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), "Reason Unknown");
        }
        if ((cached_peers = this.helper.getPeersFromCache(num_want = this.calculateNumWant() * 4)).length <= 0) return last_failure_resp;
        last_failure_resp.setPeers(cached_peers);
        return last_failure_resp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] updateOld(URL[] tracker_url, URL reqUrl) throws Exception {
        errorLevel = true;
        try {
            TorrentUtils.setTLSTorrentHash(this.torrent_hash_actual);
            i = 0;
            if (true) ** GOTO lbl23
        }
        catch (Throwable var12_19) {
            TorrentUtils.setTLSTorrentHash(null);
            throw var12_19;
        }
lbl-1000:
        // 7 sources

        {
            while (true) {
                if (failure_reason != null) {
                    lcfr = failure_reason.toLowerCase(Locale.US);
                    if (lcfr.contains("401")) {
                        failure_reason = "Tracker authentication failed";
                        errorLevel = false;
                    } else if (lcfr.contains("unresolved") || lcfr.contains("no data")) {
                        errorLevel = false;
                    }
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this.torrent, TRTrackerBTAnnouncerImpl.LOGID, errorLevel != false ? 3 : 1, "Exception while processing the Tracker Request for " + reqUrl + ": " + failure_reason));
                }
                throw new Exception(failure_reason);
            }
            while (true) {
                ++i;
lbl23:
                // 2 sources

                if (i >= 2) {
                    throw new Exception("Internal Error: should never get here");
                }
                failure_reason = null;
                protocol = reqUrl.getProtocol();
                try {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, TRTrackerBTAnnouncerImpl.LOGID, "Tracker Announcer is Requesting: " + reqUrl));
                    }
                    message = new ByteArrayOutputStream();
                    udpAnnounceURL = null;
                    udp_probe = false;
                    if (protocol.equalsIgnoreCase("udp")) {
                        if (!TRTrackerBTAnnouncerImpl.udpAnnounceEnabled) {
                            throw new IOException("UDP Tracker protocol disabled");
                        }
                        udpAnnounceURL = reqUrl;
                    } else if (protocol.equalsIgnoreCase("http") && !this.az_tracker && !TorrentUtils.isReallyPrivate(this.torrent) && this.announceCount % this.autoUDPprobeEvery == 0 && TRTrackerBTAnnouncerImpl.udpProbeEnabled && TRTrackerBTAnnouncerImpl.udpAnnounceEnabled && (!this.stopped && this.announceCount != 0 && (this.announceCount >= this.trackerUrlLists.size() || this.announceFailCount != this.announceCount) || TRTrackerUtils.isUDPProbeOK(reqUrl)) && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                        udpAnnounceURL = new URL(reqUrl.toString().replaceFirst("^http", "udp"));
                        udp_probe = true;
                    }
                    if (udpAnnounceURL != null) {
                        failure_reason = this.announceUDP(reqUrl, message, udp_probe);
                        if ((failure_reason != null || message.size() == 0) && udp_probe) {
                            udpAnnounceURL = null;
                            if (this.autoUDPprobeEvery < 16) {
                                this.autoUDPprobeEvery = (byte)(this.autoUDPprobeEvery << 1);
                            } else {
                                TRTrackerUtils.setUDPProbeResult(reqUrl, false);
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, TRTrackerBTAnnouncerImpl.LOGID, 0, "redirection of http announce [" + tracker_url[0] + "] to udp failed, will retry in " + this.autoUDPprobeEvery + " announces"));
                            }
                        } else if (failure_reason == null && udp_probe) {
                            TRTrackerUtils.setUDPProbeResult(reqUrl, true);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, TRTrackerBTAnnouncerImpl.LOGID, 0, "redirection of http announce [" + tracker_url[0] + "] to udp successful"));
                            }
                            this.autoUDPprobeEvery = 1;
                            ++this.autoUDPProbeSuccessCount;
                        }
                    }
                    ++this.announceCount;
                    if (udpAnnounceURL == null) {
                        failed = false;
                        if (!this.az_tracker && !TRTrackerBTAnnouncerImpl.tcpAnnounceEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                            failure_reason = "HTTP Tracker protocol disabled";
                            failed = true;
                        }
                        if (!failed) {
                            failure_reason = this.announceHTTP(tracker_url, reqUrl, message, i == 0);
                        }
                    }
                    if ((size = message.size()) > 0) {
                        var13_17 = message.toByteArray();
                        break;
                    }
                    ** GOTO lbl-1000
                }
                catch (SSLException e) {
                    block36: {
                        if (i != 0) break block36;
                        if (SESecurityManager.installServerCertificates(reqUrl) != null) continue;
                        failure_reason = this.exceptionToString(e);
                        ** GOTO lbl-1000
                    }
                    failure_reason = this.exceptionToString(e);
                    ** GOTO lbl-1000
                }
                catch (IOException e) {
                    if (e instanceof UnknownHostException || e instanceof ConnectException) {
                        errorLevel = false;
                    }
                    if (i == 0 && protocol.toLowerCase().startsWith("http") && (retry_url = UrlUtils.getIPV4Fallback(reqUrl)) != null) {
                        reqUrl = retry_url;
                        continue;
                    }
                    failure_reason = this.exceptionToString(e);
                    ** GOTO lbl-1000
                }
                catch (Exception e) {
                    failure_reason = this.exceptionToString(e);
                    ** GOTO lbl-1000
                }
                break;
            }
            TorrentUtils.setTLSTorrentHash(null);
            return var13_17;
lbl-1000:
            // 1 sources

            {
                if (!this.stopped || failure_reason != null) ** GOTO lbl-1000
                var13_18 = BEncoder.encode(new HashMap<K, V>());
            }
            TorrentUtils.setTLSTorrentHash(null);
            return var13_18;
lbl-1000:
            // 1 sources

            {
                if (failure_reason != null) ** GOTO lbl-1000
                failure_reason = "No data received from tracker";
                if (!reqUrl.getProtocol().equalsIgnoreCase("udp")) ** GOTO lbl-1000
                errorLevel = false;
                ** continue;
            }
        }
    }

    private String announceHTTP(URL[] tracker_url, URL original_reqUrl, ByteArrayOutputStream message, boolean first_effort) throws Exception {
        try {
            return this.announceHTTPSupport(tracker_url, original_reqUrl, null, first_effort, message);
        }
        catch (Exception e) {
            if (first_effort && AENetworkClassifier.categoriseAddress(original_reqUrl.getHost()) != "Public") {
                AEProxyFactory.PluginProxy proxy;
                HashMap<String, Object> opts = new HashMap<String, Object>();
                if (this.peer_networks != null) {
                    opts.put("peer_networks", this.peer_networks);
                }
                if ((proxy = AEProxyFactory.getPluginProxy("Tracker update", original_reqUrl, opts, true)) != null) {
                    boolean ok = false;
                    try {
                        String result = this.announceHTTPSupport(tracker_url, proxy.getURL(), proxy.getProxy(), first_effort, message);
                        ok = true;
                        String string = result;
                        return string;
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        proxy.setOK(ok);
                    }
                }
            }
            throw e;
        }
    }

    private String announceHTTPSupport(URL[] tracker_url, URL original_reqUrl, Proxy proxy, boolean first_effort, ByteArrayOutputStream message) throws IOException {
        String failure_reason;
        block50: {
            HttpURLConnection con;
            TRTrackerUtils.checkForBlacklistedURLs(original_reqUrl);
            URL reqUrl = TRTrackerUtils.adjustURLForHosting(original_reqUrl);
            reqUrl = AddressUtils.adjustURL(reqUrl);
            if (reqUrl != original_reqUrl && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.torrent, LOGID, "    HTTP: url adjusted to " + reqUrl));
            }
            failure_reason = null;
            Properties http_properties = new Properties();
            http_properties.put("URL", reqUrl);
            if (proxy != null) {
                http_properties.put("Proxy", proxy);
            }
            if (this.enable_sni_hack) {
                http_properties.put("SNI-Hack", (Object)true);
            }
            try {
                ClientIDManagerImpl.getSingleton().generateHTTPProperties(this.torrent_hash_target.getBytes(), http_properties);
            }
            catch (ClientIDException e) {
                throw new IOException(e.getMessage());
            }
            reqUrl = (URL)http_properties.get("URL");
            boolean is_https = reqUrl.getProtocol().equalsIgnoreCase("https");
            if (is_https) {
                HttpsURLConnection ssl_con = proxy == null ? (HttpsURLConnection)reqUrl.openConnection() : (HttpsURLConnection)reqUrl.openConnection(proxy);
                if (!this.internal_error_hack) {
                    ssl_con.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String host, SSLSession session) {
                            return true;
                        }
                    });
                }
                if (this.dh_hack) {
                    UrlUtils.DHHackIt(ssl_con);
                }
                if (!first_effort) {
                    TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                    try {
                        SSLContext sc = SSLContext.getInstance("SSL");
                        sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                        SSLSocketFactory factory = sc.getSocketFactory();
                        ssl_con.setSSLSocketFactory(factory);
                    }
                    catch (Throwable sc) {
                        // empty catch block
                    }
                }
                con = ssl_con;
            } else {
                con = proxy == null ? (HttpURLConnection)reqUrl.openConnection() : (HttpURLConnection)reqUrl.openConnection(proxy);
            }
            con.setInstanceFollowRedirects(true);
            String user_agent = (String)http_properties.get("User-Agent");
            if (user_agent != null) {
                con.setRequestProperty("User-Agent", user_agent);
            }
            con.setRequestProperty("Connection", "close");
            con.addRequestProperty("Accept-Encoding", "gzip");
            try {
                try {
                    con.connect();
                }
                catch (AEProxyFactory.UnknownHostException e) {
                    throw new UnknownHostException(e.getMessage());
                }
                catch (IOException e) {
                    if (is_https) {
                        String msg = Debug.getNestedExceptionMessage(e);
                        if (msg.contains("unrecognized_name")) {
                            this.enable_sni_hack = true;
                        } else if (msg.contains("internal_error") || msg.contains("handshake_failure")) {
                            this.internal_error_hack = true;
                        } else if (msg.contains("DH keypair")) {
                            this.dh_hack = true;
                        }
                    }
                    throw e;
                }
                InputStream is = null;
                try {
                    try {
                        String encoding;
                        boolean gzip;
                        String marker;
                        int pos;
                        is = con.getInputStream();
                        String resulting_url_str = con.getURL().toString();
                        if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                            --pos;
                            try {
                                URL redirect_url;
                                tracker_url[0] = redirect_url = new URL(resulting_url_str.substring(0, pos));
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
                        if (gzip) {
                            is = new GZIPInputStream(is);
                        }
                        int content_length = -1;
                        byte[] data = new byte[1024];
                        int num_read = 0;
                        while (content_length <= 0 || num_read < content_length) {
                            try {
                                int len = is.read(data);
                                if (len > 0) {
                                    message.write(data, 0, len);
                                    if ((num_read += len) <= 131072) continue;
                                    message.reset();
                                    throw new Exception("Tracker response invalid (too large)");
                                }
                                if (len == 0) {
                                    Thread.sleep(20L);
                                    continue;
                                }
                                break;
                            }
                            catch (Exception e) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, "Exception while Requesting Tracker", (Throwable)e));
                                    String str = message.toString();
                                    if (str.length() > 128) {
                                        str = String.valueOf(str.substring(0, 128)) + "...";
                                    }
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Message received was : " + str));
                                }
                                failure_reason = this.exceptionToString(con, e);
                                break;
                            }
                        }
                    }
                    catch (SSLException e) {
                        throw e;
                    }
                    catch (Exception e2) {
                        FileNotFoundException e2;
                        if (e2 instanceof FileNotFoundException) {
                            e2 = new FileNotFoundException(original_reqUrl.toExternalForm());
                        }
                        failure_reason = this.exceptionToString(con, e2);
                        if (is == null) break block50;
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        is = null;
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                        is = null;
                    }
                }
            }
            finally {
                con.disconnect();
            }
        }
        return failure_reason;
    }

    /*
     * Exception decompiling
     */
    protected String announceUDP(URL original_reqUrl, ByteArrayOutputStream message, boolean is_probe) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLongURLParam(String url, String param) {
        String val = this.getURLParam(url, param);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(String.valueOf(param) + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected String exceptionToString(Throwable e) {
        return this.exceptionToString(null, e);
    }

    protected String exceptionToString(HttpURLConnection con, Throwable e) {
        String str;
        if (e instanceof BoringException || e instanceof FileNotFoundException || e instanceof UnknownHostException) {
            str = Debug.getNestedExceptionMessage(e);
        } else {
            String class_name = e.getClass().getName();
            int pos = class_name.lastIndexOf(46);
            if (pos != -1) {
                class_name = class_name.substring(pos + 1);
            }
            if ((pos = class_name.indexOf(36)) != -1) {
                class_name = class_name.substring(pos + 1);
            }
            str = String.valueOf(class_name) + ": " + Debug.getNestedExceptionMessage(e);
        }
        if (str.contains("timed out")) {
            str = "timeout";
        }
        if (con != null) {
            try {
                String error = FileUtil.readInputStreamAsString(con.getErrorStream(), 512).trim();
                if (!error.isEmpty()) {
                    str = String.valueOf(str) + " [error=" + error + "]";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return str;
    }

    private TRTrackerAnnouncerRequestImpl constructRequest(String evt, URL _url, TimerEvent timer_event) throws Exception {
        String ext;
        boolean stopped;
        String url = _url.toString();
        StringBuffer request2 = new StringBuffer(url);
        if (url.indexOf(63) != -1) {
            request2.append('&');
        } else {
            request2.append('?');
        }
        request2.append(this.info_hash);
        request2.append(this.tracker_peer_id_str);
        int tcp_port = this.announce_data_provider.getTCPListeningPortNumber();
        AllTrackersManager.AllTrackersTracker att = all_trackers.getTracker(_url);
        boolean disable_crypto_port = false;
        if (att != null) {
            Number cp;
            Map<String, Object> options;
            if (timer_event != null) {
                timer_event.setName(att.getTrackerName());
            }
            if ((options = att.getOptions()) != null && (cp = (Number)options.get("cp")) != null && cp.intValue() == 2) {
                disable_crypto_port = true;
            }
        }
        String port_details = this.announce_data_provider.getCryptoLevel() == 1 ? TRTrackerUtils.getPortsForURLFullCrypto(tcp_port) : TRTrackerUtils.getPortsForURL(tcp_port, disable_crypto_port);
        try {
            if (_url.getHost().endsWith(".amazonaws.com")) {
                port_details = port_details.replaceAll("&port=0", "&port=" + tcp_port);
            }
        }
        catch (Throwable cp) {
            // empty catch block
        }
        request2.append(port_details);
        long total_sent = this.announce_data_provider.getTotalSent();
        long total_received = this.announce_data_provider.getTotalReceived();
        request2.append("&uploaded=").append(total_sent);
        request2.append("&downloaded=").append(total_received);
        request2.append("&left=").append(this.announce_data_provider.getRemaining());
        request2.append("&corrupt=").append(this.announce_data_provider.getFailedHashCheck());
        if (this.tracker_id.length() > 0) {
            request2.append("&trackerid=").append(this.tracker_id);
        }
        if (evt.length() != 0) {
            request2.append("&event=").append(evt);
        }
        if (stopped = evt.equals("stopped")) {
            request2.append("&numwant=0");
            if (this.stopped_for_queue) {
                request2.append("&azq=1");
            }
        } else {
            int numwant = Math.min(this.calculateNumWant(), userMaxNumwant);
            request2.append("&numwant=").append(numwant);
        }
        request2.append("&no_peer_id=1");
        String tracker_network_host = _url.getHost();
        String tracker_network = AENetworkClassifier.categoriseAddress(tracker_network_host);
        request2.append("&compact=1");
        String explicit_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        String ip = null;
        boolean network_ok = false;
        boolean has_public_net = false;
        if (this.peer_networks == null) {
            network_ok = true;
            has_public_net = true;
        } else {
            int i = 0;
            while (i < this.peer_networks.length) {
                if (this.peer_networks[i] == "Public") {
                    has_public_net = true;
                }
                if (this.peer_networks[i] == tracker_network) {
                    network_ok = true;
                }
                ++i;
            }
        }
        if (!network_ok) {
            throw new Exception("Network not enabled for url '" + _url + "'");
        }
        String public_ip_override = null;
        if (explicit_ips.length() > 0) {
            boolean is_udp = _url.getProtocol().equalsIgnoreCase("udp");
            boolean found_invalid_udp = false;
            StringTokenizer tok = new StringTokenizer(explicit_ips, ";");
            while (tok.hasMoreTokens()) {
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0) continue;
                String cat = AENetworkClassifier.categoriseAddress(this_address);
                if (cat == "Public") {
                    if (is_udp) {
                        try {
                            InetAddress i_address = HostNameToIPResolver.syncResolve(this_address);
                            if (i_address.getAddress().length != 4) {
                                found_invalid_udp = true;
                                continue;
                            }
                        }
                        catch (Throwable i_address) {
                            // empty catch block
                        }
                    }
                    public_ip_override = this_address;
                }
                if (tracker_network != cat) continue;
                ip = this_address;
                break;
            }
            if (ip == null && found_invalid_udp && tracker_network == "Public" && Constants.IS_CVS_VERSION) {
                Debug.outNoStack("Announce for " + _url + ": no valid IPv4 override found");
            }
        }
        if (ip == null) {
            if (has_public_net && public_ip_override != null) {
                ip = public_ip_override;
            } else if (this.ip_override != null && !TorrentUtils.isDecentralised(this.ip_override)) {
                ip = this.ip_override;
            }
        }
        if (ip == null && tracker_network == "Tor") {
            InetSocketAddress tor_local = AEPluginProxyHandler.getLocalAddress(tracker_network_host, has_public_net ? 27657 : 27658);
            if (tor_local != null) {
                ip = tor_local.getHostString();
                request2 = new StringBuffer(request2.toString().replaceAll("&port=[0-9]+", "&port=" + tor_local.getPort()));
            } else {
                request2 = new StringBuffer(request2.toString().replaceAll("&port=[0-9]+", "&port=0"));
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "IP Override missing for Tor tracker, incoming connections disabled"));
                }
            }
        }
        if (ip != null) {
            block52: {
                if (tracker_network == "Public") {
                    try {
                        ip = PRHelpers.DNSToIPAddress(ip);
                    }
                    catch (UnknownHostException e) {
                        if (!Logger.isEnabled()) break block52;
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "IP Override host resolution of '" + ip + "' fails, using unresolved address"));
                    }
                }
            }
            request2.append("&ip=").append(ip);
        }
        if (COConfigurationManager.getBooleanParameter("Tracker Key Enable Client", true)) {
            request2.append("&key=").append(this.helper.getTrackerKey());
        }
        if ((ext = this.announce_data_provider.getExtensions()) != null) {
            while (ext.startsWith("&")) {
                ext = ext.substring(1);
            }
            request2.append("&");
            request2.append(ext);
        }
        request2.append("&azver=3");
        if (this.az_tracker && !stopped) {
            DHTNetworkPosition best_position;
            String as;
            int up = this.announce_data_provider.getUploadSpeedKBSec(evt.equals("started"));
            if (up > 0) {
                request2.append("&azup=").append(up);
            }
            if ((as = NetworkAdmin.getSingleton().getCurrentASN().getAS()).length() > 0) {
                request2.append("&azas=").append(URLEncoder.encode(as, "UTF8"));
            }
            if ((best_position = DHTNetworkPositionManager.getBestLocalPosition()) != null) {
                try {
                    byte[] bytes = DHTNetworkPositionManager.serialisePosition(best_position);
                    request2.append("&aznp=").append(Base32.encode(bytes));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (tracker_network == "I2P") {
            String temp = request2.toString();
            int pos = temp.indexOf(63);
            String head = temp.substring(0, pos);
            String tail = temp.substring(pos + 1);
            String[] bits = tail.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] arg = bit.split("=");
                map.put(arg[0], arg[1]);
                ++n2;
            }
            tail = "";
            stringArray = new String[]{"info_hash", "peer_id", "port", "ip", "uploaded", "downloaded", "left", "compact", "event", "numwant"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String val = (String)map.get(str);
                if (val != null) {
                    tail = String.valueOf(tail) + (tail.length() == 0 ? "" : "&") + str + "=" + (String)map.get(str);
                }
                ++n2;
            }
            request2 = new StringBuffer(String.valueOf(head) + "?" + tail);
        }
        return new TRTrackerAnnouncerRequestImpl(this.helper.getSessionID(), this.torrent_hash_target, stopped, new URL(request2.toString()), total_sent, total_received);
    }

    protected int calculateNumWant() {
        if (!this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
            return 0;
        }
        int MAX_PEERS = 100;
        int maxAllowed = 3 * this.announce_data_provider.getMaxNewConnectionsAllowed("") / 2;
        if (maxAllowed < 0 || maxAllowed > MAX_PEERS) {
            maxAllowed = MAX_PEERS;
        }
        return maxAllowed;
    }

    @Override
    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    @Override
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider _provider) {
        try {
            this.this_mon.enter();
            this.announce_data_provider = _provider;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public URL getTrackerURL() {
        return this.lastUsedUrl;
    }

    @Override
    public void setTrackerURL(URL new_url) {
        try {
            new_url = new URL(new_url.toString().replaceAll(" ", ""));
            ArrayList<URL> list = new ArrayList<URL>(1);
            list.add(new_url);
            this.trackerUrlLists.clear();
            this.trackerUrlLists.add(list);
            this.informURLChange(this.lastUsedUrl, new_url, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public TOTorrentAnnounceURLSet[] getAnnounceSets() {
        return this.announce_urls;
    }

    @Override
    public void resetTrackerUrl(boolean shuffle) {
        String old_list = this.trackerURLListToString();
        this.constructTrackerUrlLists(shuffle);
        if (this.trackerUrlLists.size() == 0) {
            return;
        }
        if (!old_list.equals(this.trackerURLListToString())) {
            URL first_url = this.trackerUrlLists.get(0).get(0);
            this.informURLChange(this.lastUsedUrl, first_url, true);
        }
    }

    @Override
    public void refreshListeners() {
        this.informURLRefresh();
    }

    @Override
    public void setIPOverride(String override) {
        this.ip_override = override;
    }

    @Override
    public void clearIPOverride() {
        this.ip_override = null;
    }

    private void constructTrackerUrlLists(boolean shuffle) {
        try {
            this.trackerUrlLists = new ArrayList<List<URL>>(1);
            if (this.announce_urls.length == 0) {
                URL url = this.torrent.getAnnounceURL();
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(url);
                this.trackerUrlLists.add(list);
            } else {
                int i = 0;
                while (i < this.announce_urls.length) {
                    URL[] urls = this.announce_urls[i].getAnnounceURLs();
                    ArrayList<URL> random_urls = new ArrayList<URL>();
                    int j = 0;
                    while (j < urls.length) {
                        URL url = urls[j];
                        int pos = shuffle ? (int)(Math.random() * (double)(random_urls.size() + 1)) : j;
                        random_urls.add(pos, url);
                        ++j;
                    }
                    this.trackerUrlLists.add(random_urls);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        all_trackers.registerTrackers(this.torrent, this.trackerUrlLists);
    }

    protected String trackerURLListToString() {
        String trackerUrlListString = "[";
        int i = 0;
        while (i < this.trackerUrlLists.size()) {
            List<URL> group = this.trackerUrlLists.get(i);
            trackerUrlListString = String.valueOf(trackerUrlListString) + (i == 0 ? "" : ",") + "[";
            int j = 0;
            while (j < group.size()) {
                URL u = group.get(j);
                trackerUrlListString = String.valueOf(trackerUrlListString) + (j == 0 ? "" : ",") + u.toString();
                ++j;
            }
            trackerUrlListString = String.valueOf(trackerUrlListString) + "]";
            ++i;
        }
        trackerUrlListString = String.valueOf(trackerUrlListString) + "]";
        return trackerUrlListString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TRTrackerAnnouncerResponseImpl decodeTrackerResponse(URL url, byte[] data) {
        String failure_reason;
        if (data == null) {
            failure_reason = "no response";
            return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), failure_reason);
        }
        try {
            Map<String, Object> metaData = null;
            try {
                int downloaded;
                ArrayList<TRTrackerAnnouncerResponsePeerImpl> valid_meta_peers;
                Long downloaded_l;
                Long complete_l;
                Long incomplete_l;
                long time_to_wait;
                String warning_message;
                block127: {
                    int ip4;
                    int i;
                    ArrayList meta_peers;
                    boolean this_is_az_tracker;
                    byte[] trackerid;
                    block124: {
                        metaData = BDecoder.decode(data);
                        Object o = metaData.get("az_ps");
                        if (o instanceof List) {
                            List peer_sources = (List)o;
                            ArrayList<String> x = new ArrayList<String>();
                            int i2 = 0;
                            while (i2 < peer_sources.size()) {
                                Object o1 = peer_sources.get(i2);
                                if (o1 instanceof byte[]) {
                                    x.add(new String((byte[])o1));
                                }
                                ++i2;
                            }
                            String[] y = new String[x.size()];
                            x.toArray(y);
                            this.announce_data_provider.setPeerSources(y);
                        }
                        warning_message = null;
                        try {
                            byte[] b_warning_message = (byte[])metaData.get("warning message");
                            if (b_warning_message == null) break block124;
                            warning_message = new String(b_warning_message);
                            if (!COConfigurationManager.getBooleanParameter("Tracker Client Show Warnings") || warning_message.equals(this.last_tracker_message)) break block124;
                            this.last_tracker_message = warning_message;
                            boolean log_it = false;
                            try {
                                class_mon.enter();
                                String last_warning_message = (String)tracker_report_map.get(url.getHost());
                                if (last_warning_message == null || !warning_message.equals(last_warning_message)) {
                                    log_it = true;
                                    tracker_report_map.put(url.getHost(), warning_message);
                                }
                            }
                            finally {
                                class_mon.exit();
                            }
                            if (log_it) {
                                Logger.logTextResource(new LogAlert((Object)this.torrent, false, 1, "TrackerClient.announce.warningmessage"), new String[]{String.valueOf(this.announce_data_provider.getName()) + " - " + UrlUtils.getBaseURL(url), warning_message});
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        if (!metaData.containsKey("interval")) {
                            if (!this.stopped) throw new Exception("interval missing");
                            time_to_wait = 60L;
                        } else {
                            this.tracker_interval = time_to_wait = ((Long)metaData.get("interval")).longValue();
                            Long raw_min_interval = (Long)metaData.get("min interval");
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Received from announce: 'interval' = " + time_to_wait + "; 'min interval' = " + raw_min_interval));
                            }
                            if (time_to_wait < 0L || time_to_wait > 0xFFFFFFFFL) {
                                time_to_wait = 0xFFFFFFFFL;
                            }
                            if (raw_min_interval != null) {
                                this.tracker_min_interval = this.min_interval = raw_min_interval.longValue();
                                if (this.min_interval < 1L) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' of less than 1 second (" + this.min_interval + ")"));
                                    }
                                    this.min_interval = 0L;
                                } else if (this.min_interval > time_to_wait) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' (" + this.min_interval + ") greater than recommended announce 'interval'" + " (" + time_to_wait + ")"));
                                    }
                                    this.min_interval = 0L;
                                }
                            } else {
                                long l = this.min_interval = time_to_wait > 30L ? time_to_wait - 10L : time_to_wait;
                            }
                            if (userMinInterval != 0) {
                                time_to_wait = Math.max((long)userMinInterval, time_to_wait);
                                this.min_interval = Math.max(this.min_interval, (long)userMinInterval);
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Overriding with user settings: 'interval' = " + time_to_wait + "; 'min interval' = " + this.min_interval));
                                }
                            }
                            if (time_to_wait > 30L) {
                                time_to_wait -= 10L;
                            }
                        }
                        if (metaData.containsKey("failure reason")) {
                            throw new Exception("Tracker reported 'failure reason'");
                        }
                    }
                    catch (Exception e) {
                        byte[] failure_reason_bytes = (byte[])metaData.get("failure reason");
                        if (failure_reason_bytes == null) {
                            if (!Logger.isEnabled()) return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), "Unknown cause: " + Debug.getNestedExceptionMessage(e));
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Problems with Tracker, will retry in " + this.getErrorRetryInterval() + "ms"));
                            return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), "Unknown cause: " + Debug.getNestedExceptionMessage(e));
                        }
                        String failure_reason2 = new String(failure_reason_bytes, Constants.DEFAULT_ENCODING_CHARSET);
                        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 1, (long)this.getErrorRetryInterval(), failure_reason2);
                    }
                    incomplete_l = this.getLong(metaData, "incomplete");
                    complete_l = this.getLong(metaData, "complete");
                    downloaded_l = this.getLong(metaData, "downloaded");
                    if ((incomplete_l != null || complete_l != null) && Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE1: seeds=" + complete_l + " peers=" + incomplete_l));
                    }
                    if ((trackerid = (byte[])metaData.get("tracker id")) != null) {
                        this.tracker_id = new String(trackerid);
                    }
                    byte[] crypto_flags = (byte[])metaData.get("crypto_flags");
                    valid_meta_peers = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>();
                    Object meta_peers_peek = metaData.get("peers");
                    Long az_compact_l = (Long)metaData.get("azcompact");
                    long az_compact = az_compact_l == null ? 0L : az_compact_l;
                    boolean bl = this_is_az_tracker = az_compact == 2L;
                    if (this.az_tracker != this_is_az_tracker || this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                        this.lastAZTrackerCheckedURL = this.lastUsedUrl;
                        this.az_tracker = this_is_az_tracker;
                        TRTrackerUtils.setAZTracker(url, this.az_tracker);
                    }
                    if (az_compact == 2L) {
                        meta_peers = (List)meta_peers_peek;
                        int peers_length = meta_peers.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers2: num=" + peers_length));
                        }
                        if (peers_length > 1) {
                            long total_rtt = 0L;
                            int rtt_count = 0;
                            int i3 = 0;
                            while (i3 < peers_length) {
                                Map peer = (Map)meta_peers.get(i3);
                                Long l_rtt = (Long)peer.get("r");
                                if (l_rtt != null) {
                                    long rtt = l_rtt;
                                    if (rtt <= 0L) {
                                        peer.remove("r");
                                    } else {
                                        total_rtt += rtt;
                                    }
                                    ++rtt_count;
                                }
                                ++i3;
                            }
                            final int average_rtt = (int)(rtt_count == 0 ? 0L : total_rtt / (long)rtt_count);
                            Collections.sort(meta_peers, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    boolean biased_2;
                                    Map map1 = (Map)o1;
                                    Map map2 = (Map)o2;
                                    Long l_rtt1 = (Long)map1.get("r");
                                    Long l_rtt2 = (Long)map2.get("r");
                                    boolean biased_1 = map1.containsKey("b");
                                    if (biased_1 == (biased_2 = map2.containsKey("b"))) {
                                        int rtt1 = l_rtt1 == null ? average_rtt : l_rtt1.intValue();
                                        int rtt2 = l_rtt2 == null ? average_rtt : l_rtt2.intValue();
                                        return rtt1 - rtt2;
                                    }
                                    if (biased_1) {
                                        return -1;
                                    }
                                    return 1;
                                }
                            });
                            int biased_pos = peers_length;
                            int non_biased_pos = peers_length;
                            int i4 = 0;
                            while (i4 < peers_length) {
                                Map peer = (Map)meta_peers.get(i4);
                                if (peer.containsKey("b")) {
                                    if (i4 == 0) {
                                        biased_pos = i4;
                                    }
                                } else {
                                    non_biased_pos = i4;
                                    break;
                                }
                                ++i4;
                            }
                            ArrayList new_peers = new ArrayList(peers_length);
                            int non_biased_start = non_biased_pos;
                            boolean last_biased = true;
                            while (biased_pos < non_biased_start || non_biased_pos < peers_length) {
                                if (biased_pos < non_biased_start) {
                                    if (non_biased_pos < peers_length) {
                                        boolean use_biased;
                                        Map biased = (Map)meta_peers.get(biased_pos);
                                        Map non_biased = (Map)meta_peers.get(non_biased_pos);
                                        if (!last_biased) {
                                            use_biased = true;
                                        } else {
                                            Long l_rtt_biased = (Long)biased.get("r");
                                            Long l_rtt_non_biased = (Long)non_biased.get("r");
                                            int biased_rtt = l_rtt_biased == null ? average_rtt : l_rtt_biased.intValue();
                                            int non_biased_rtt = l_rtt_non_biased == null ? average_rtt : l_rtt_non_biased.intValue();
                                            boolean bl2 = use_biased = non_biased_rtt >= biased_rtt;
                                        }
                                        if (use_biased) {
                                            new_peers.add(biased);
                                            ++biased_pos;
                                        } else {
                                            new_peers.add(non_biased);
                                            ++non_biased_pos;
                                        }
                                        last_biased = use_biased;
                                        continue;
                                    }
                                    new_peers.add(meta_peers.get(biased_pos++));
                                    continue;
                                }
                                new_peers.add(meta_peers.get(non_biased_pos++));
                            }
                            meta_peers = new_peers;
                        }
                        i = 0;
                        while (i < peers_length) {
                            block126: {
                                Map peer = (Map)meta_peers.get(i);
                                try {
                                    Long l_azver;
                                    String ip;
                                    byte[] ip_bytes = (byte[])peer.get("i");
                                    if (ip_bytes.length == 4) {
                                        int ip1 = 0xFF & ip_bytes[0];
                                        int ip2 = 0xFF & ip_bytes[1];
                                        int ip3 = 0xFF & ip_bytes[2];
                                        ip4 = 0xFF & ip_bytes[3];
                                        ip = String.valueOf(ip1) + "." + ip2 + "." + ip3 + "." + ip4;
                                    } else {
                                        StringBuilder sb = new StringBuilder(39);
                                        int j = 0;
                                        while (j < 16) {
                                            sb.append(Integer.toHexString(ip_bytes[j] << 8 & 0xFF00 | ip_bytes[j + 1] & 0xFF));
                                            if (j < 14) {
                                                sb.append(":");
                                            }
                                            j += 2;
                                        }
                                        ip = sb.toString();
                                    }
                                    byte[] tcp_bytes = (byte[])peer.get("t");
                                    int tcp_port = ((tcp_bytes[0] & 0xFF) << 8) + (tcp_bytes[1] & 0xFF);
                                    byte[] peer_peer_id = TRTrackerAnnouncerFactoryImpl.getAnonymousPeerId(ip, tcp_port);
                                    int udp_port = 0;
                                    byte[] udp_bytes = (byte[])peer.get("u");
                                    if (udp_bytes != null) {
                                        udp_port = udp_bytes.length == 0 ? tcp_port : ((udp_bytes[0] & 0xFF) << 8) + (udp_bytes[1] & 0xFF);
                                    }
                                    int http_port = 0;
                                    byte[] http_bytes = (byte[])peer.get("h");
                                    if (http_bytes != null) {
                                        http_port = ((http_bytes[0] & 0xFF) << 8) + (http_bytes[1] & 0xFF);
                                    }
                                    short protocol = 1;
                                    byte[] protocol_bytes = (byte[])peer.get("c");
                                    if (protocol_bytes != null) {
                                        protocol = (protocol_bytes[0] & 1) == 0 ? (short)1 : 2;
                                    }
                                    byte az_ver = (l_azver = (Long)peer.get("v")) == null ? (byte)1 : l_azver.byteValue();
                                    Long l_up_speed = (Long)peer.get("s");
                                    boolean biased = peer.containsKey("b");
                                    if (biased) {
                                        PeerClassifier.setAzureusIP(ip);
                                    }
                                    TRTrackerAnnouncerResponsePeerImpl new_peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, udp_port, http_port, protocol, az_ver, l_up_speed == null ? (short)0 : l_up_speed.shortValue());
                                    if (Logger.isEnabled()) {
                                        String extra = "";
                                        Long l_rtt = (Long)peer.get("r");
                                        if (l_rtt != null) {
                                            extra = ",rtt=" + l_rtt;
                                        }
                                        if (biased) {
                                            extra = String.valueOf(extra) + ",biased";
                                        }
                                        Logger.log(new LogEvent(this.torrent, LOGID, "AZ2-COMPACT PEER: " + new_peer.getString() + extra));
                                    }
                                    valid_meta_peers.add(new_peer);
                                }
                                catch (Throwable e) {
                                    if (!Logger.isEnabled()) break block126;
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid az2 peer received: " + peer));
                                }
                            }
                            ++i;
                        }
                    } else if (meta_peers_peek instanceof List) {
                        meta_peers = (List)meta_peers_peek;
                        int peers_length = meta_peers.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE old style non-compact: num=" + peers_length));
                        }
                        if (crypto_flags != null && peers_length != crypto_flags.length) {
                            crypto_flags = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        i = 0;
                        while (i < peers_length) {
                            Map peer = (Map)meta_peers.get(i);
                            Object s_peerid = peer.get("peer id");
                            Object s_ip = peer.get("ip");
                            Object s_port = peer.get("port");
                            if (s_ip != null && s_port != null) {
                                String base_ip = new String((byte[])s_ip, Constants.DEFAULT_ENCODING_CHARSET);
                                String ip = AddressUtils.convertToShortForm(base_ip);
                                if (ip == null) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Skipping invalid address: " + base_ip));
                                } else {
                                    int peer_port;
                                    int n = peer_port = s_port instanceof byte[] ? Integer.parseInt(new String((byte[])s_port)) : ((Long)s_port).intValue();
                                    if (peer_port > 65535) {
                                        peer_port -= 65536;
                                    }
                                    if (peer_port < 0) {
                                        peer_port += 65536;
                                    }
                                    if (peer_port < 0 || peer_port > 65535) {
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid peer port given: " + ip + ": " + peer_port));
                                        }
                                    } else {
                                        byte[] peer_peer_id = s_peerid == null ? TRTrackerAnnouncerFactoryImpl.getAnonymousPeerId(ip, peer_port) : (byte[])s_peerid;
                                        short protocol = crypto_flags == null ? (short)1 : (crypto_flags[i] == 0 ? (short)1 : 2);
                                        int udp_port = 0;
                                        int http_port = 0;
                                        TRTrackerAnnouncerResponsePeerImpl new_peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, peer_port, udp_port, http_port, protocol, 1, 0);
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(this.torrent, LOGID, "NON-COMPACT PEER: " + new_peer.getString()));
                                        }
                                        valid_meta_peers.add(new_peer);
                                    }
                                }
                            }
                            ++i;
                        }
                    } else if (meta_peers_peek instanceof byte[]) {
                        meta_peers = (ArrayList)((byte[])meta_peers_peek);
                        String tracker_network = AENetworkClassifier.categoriseAddress(url.getHost());
                        if (tracker_network == "I2P" && ((Object)meta_peers).length % 32 == 0) {
                            i = 0;
                            while (i < ((Object)meta_peers).length) {
                                byte[] i2p_id = new byte[32];
                                byte[] peer_peer_id = new byte[20];
                                System.arraycopy(meta_peers, i, i2p_id, 0, 32);
                                System.arraycopy(meta_peers, i, peer_peer_id, 0, 20);
                                String hostname = String.valueOf(Base32.encode(i2p_id).toLowerCase(Locale.US)) + ".b32.i2p";
                                TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, hostname, 6881, 0, 0, 1, 1, 0);
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(this.torrent, LOGID, "COMPACT PEER: " + peer.getString()));
                                }
                                valid_meta_peers.add(peer);
                                i += 32;
                            }
                        } else {
                            int entry_size;
                            int n = entry_size = az_compact == 1L ? 9 : 6;
                            if (crypto_flags != null && ((Object)meta_peers).length / entry_size != crypto_flags.length) {
                                crypto_flags = null;
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                                }
                            }
                            int peer_number = 0;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers: num=" + ((Object)meta_peers).length / entry_size));
                            }
                            int peers_length = ((Object)meta_peers).length;
                            int i5 = 0;
                            while (i5 < peers_length / entry_size * entry_size) {
                                ++peer_number;
                                int ip1 = 0xFF & meta_peers[i5];
                                int ip2 = 0xFF & meta_peers[i5 + 1];
                                int ip3 = 0xFF & meta_peers[i5 + 2];
                                ip4 = 0xFF & meta_peers[i5 + 3];
                                int po1 = 0xFF & meta_peers[i5 + 4];
                                int po2 = 0xFF & meta_peers[i5 + 5];
                                String ip = ip1 + "." + ip2 + "." + ip3 + "." + ip4;
                                int tcp_port = po1 * 256 + po2;
                                if (tcp_port < 0 || tcp_port > 65535) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compact peer port given: " + ip + ": " + tcp_port));
                                    }
                                } else {
                                    int protocol;
                                    int udp_port;
                                    byte[] peer_peer_id = TRTrackerAnnouncerFactoryImpl.getAnonymousPeerId(ip, tcp_port);
                                    if (az_compact == 1L) {
                                        int upo1 = 0xFF & meta_peers[i5 + 6];
                                        int upo2 = 0xFF & meta_peers[i5 + 7];
                                        udp_port = upo1 * 256 + upo2;
                                        ArrayList flags = meta_peers[i5 + 8];
                                        protocol = (flags & 1) == 0 ? 1 : 2;
                                    } else {
                                        protocol = crypto_flags == null ? 1 : (crypto_flags[peer_number - 1] == 0 ? 1 : 2);
                                        udp_port = 0;
                                    }
                                    int http_port = 0;
                                    TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, udp_port, http_port, (short)protocol, 1, 0);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(this.torrent, LOGID, "COMPACT PEER: " + peer.getString()));
                                    }
                                    valid_meta_peers.add(peer);
                                }
                                i5 += entry_size;
                            }
                        }
                    } else if (meta_peers_peek instanceof Map) {
                        if (((Map)meta_peers_peek).size() != 0) {
                            throw new IOException("peers missing from response");
                        }
                    } else {
                        metaData.containsKey("peers6");
                    }
                    byte[] v6peers = (byte[])metaData.get("peers6");
                    if (v6peers != null) {
                        try {
                            int entry_size = 18;
                            byte[] rawAddr = new byte[16];
                            int i6 = 0;
                            while (i6 < v6peers.length) {
                                System.arraycopy(v6peers, i6, rawAddr, 0, 16);
                                String ip = InetAddress.getByAddress(rawAddr).getHostAddress();
                                int po1 = 0xFF & v6peers[i6 + 16];
                                int po2 = 0xFF & v6peers[i6 + 17];
                                int tcp_port = po1 * 256 + po2;
                                if (tcp_port < 0 || tcp_port > 65535) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compactv6 peer port given: " + ip + ": " + tcp_port));
                                    }
                                } else {
                                    byte[] peer_peer_id = TRTrackerAnnouncerFactoryImpl.getAnonymousPeerId(ip, tcp_port);
                                    short protocol = 1;
                                    TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, 0, 0, protocol, 1, 0);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(this.torrent, LOGID, "COMPACTv6 PEER: " + peer.getString()));
                                    }
                                    valid_meta_peers.add(peer);
                                }
                                i6 += 18;
                            }
                        }
                        catch (Throwable e) {
                            if (!Logger.isEnabled()) break block127;
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compactv6: " + Base32.encode(v6peers)));
                        }
                    }
                }
                TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[valid_meta_peers.size()];
                valid_meta_peers.toArray(peers);
                this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
                TRTrackerAnnouncerResponseImpl resp = new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 2, time_to_wait, peers);
                if (warning_message != null) {
                    resp.setAdditionalInfo(warning_message);
                }
                this.failure_added_time = 0;
                Map extensions = (Map)metaData.get("extensions");
                resp.setExtensions(extensions);
                if (extensions != null) {
                    Object override;
                    if (complete_l == null) {
                        complete_l = (Long)extensions.get("complete");
                    }
                    if (incomplete_l == null) {
                        incomplete_l = (Long)extensions.get("incomplete");
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE2: seeds=" + complete_l + " peers=" + incomplete_l));
                    }
                    if ((override = extensions.get("min interval override")) != null && override instanceof Long) {
                        this.min_interval_override = (Long)override;
                    }
                }
                if (complete_l == null && incomplete_l == null && downloaded_l == null) return resp;
                int complete = complete_l == null ? 0 : complete_l.intValue();
                int incomplete = incomplete_l == null ? 0 : incomplete_l.intValue();
                int n = downloaded = downloaded_l == null ? -1 : downloaded_l.intValue();
                if (complete < 0 || incomplete < 0) {
                    resp.setAdditionalInfo(MessageText.getString("Tracker.announce.ignorePeerSeed", new String[]{String.valueOf(complete < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.seeds")) + " == " + complete + ". " : "") + (incomplete < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.peers")) + " == " + incomplete + ". " : "")}));
                    return resp;
                } else {
                    TRTrackerScraperResponse scrapeResponse;
                    resp.setScrapeResult(complete, incomplete, downloaded);
                    TRTrackerScraper scraper = TRTrackerScraperFactory.getSingleton();
                    if (scraper == null || (scrapeResponse = scraper.scrape(this.torrent, this.getTrackerURL())) == null) return resp;
                    long lNextScrapeTime = scrapeResponse.getNextScrapeStartTime();
                    long now = SystemTime.getCurrentTime();
                    long lNewNextScrapeTime = now + (long)TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(0, complete) * 1000L;
                    scrapeResponse.setScrapeStartTime(now);
                    if (lNextScrapeTime < lNewNextScrapeTime) {
                        scrapeResponse.setNextScrapeStartTime(lNewNextScrapeTime);
                    }
                    scrapeResponse.setSeedsPeers(complete, incomplete);
                    if (downloaded < 0) return resp;
                    scrapeResponse.setCompleted(downloaded);
                }
                return resp;
            }
            catch (IOException e) {
                if (metaData != null) {
                    String failure_reason3;
                    byte[] failure_reason_bytes = (byte[])metaData.get("failure reason");
                    if (failure_reason_bytes == null) {
                        Debug.printStackTrace(e);
                        failure_reason3 = "error: " + e.getMessage();
                        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 1, Math.max(this.tracker_interval, (long)this.getErrorRetryInterval()), failure_reason3);
                    } else {
                        failure_reason3 = new String(failure_reason_bytes, Constants.DEFAULT_ENCODING_CHARSET);
                    }
                    return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 1, Math.max(this.tracker_interval, (long)this.getErrorRetryInterval()), failure_reason3);
                }
                String trace_data = data.length <= 150 ? new String(data) : String.valueOf(new String(data, 0, 150)) + "...";
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "TRTrackerAnnouncer::invalid reply: " + trace_data));
                }
                failure_reason = "invalid reply: " + trace_data;
                return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), failure_reason);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            failure_reason = "error: " + e.getMessage();
        }
        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash_actual, 0, (long)this.getErrorRetryInterval(), failure_reason);
    }

    private Long getLong(Map map, String key) {
        Object o = map.get(key);
        if (o instanceof Long) {
            return (Long)o;
        }
        return null;
    }

    protected void informURLChange(URL old_url, URL new_url, boolean explicit) {
        if (old_url != new_url) {
            all_trackers.registerTracker(this.torrent, new_url);
        }
        this.helper.informURLChange(old_url, new_url, explicit);
    }

    protected void informURLRefresh() {
        this.helper.informURLRefresh();
    }

    @Override
    public TRTrackerAnnouncerResponse getLastResponse() {
        if (this.last_response == null) {
            return new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash_actual, 0, 60L, "Initialising");
        }
        return this.last_response;
    }

    @Override
    public boolean isManual() {
        return this.manual_control;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null && this.current_timer_event.getWhen() - SystemTime.getCurrentTime() > 10000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Canceling announce trigger"));
                }
                this.current_timer_event.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getErrorRetryInterval() {
        boolean is_seed;
        long currentTime = SystemTime.getCurrentTime() / 1000L;
        long diff = currentTime - this.failure_time_last_updated;
        if (diff < (long)this.failure_added_time && diff >= 0L) {
            return this.failure_added_time;
        }
        this.failure_time_last_updated = currentTime;
        this.failure_added_time = this.failure_added_time == 0 ? 10 : (this.failure_added_time < 30 ? (this.failure_added_time += 10) : (this.failure_added_time < 60 ? (this.failure_added_time += 15) : (this.failure_added_time < 120 ? (this.failure_added_time += 30) : (this.failure_added_time < 600 ? (this.failure_added_time += 60) : (this.failure_added_time += 120 + new Random().nextInt(60))))));
        boolean bl = this.announce_data_provider == null ? false : (is_seed = this.announce_data_provider.getRemaining() == 0L);
        if (is_seed) {
            this.failure_added_time *= 2;
        }
        if (!is_seed && this.failure_added_time > 1800) {
            this.failure_added_time = 1800;
        } else if (is_seed && this.failure_added_time > 3600) {
            this.failure_added_time = 3600;
        }
        return this.failure_added_time;
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponseImpl response;
        String status;
        if (result.getResponseType() == 2) {
            status = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                status = String.valueOf(status) + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash_actual, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            ArrayList<TRTrackerAnnouncerResponsePeerImpl> l_peers = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>(ext_peers.length);
            boolean ps_enabled = this.announce_data_provider != null && this.announce_data_provider.isPeerSourceEnabled("Tracker");
            int i = 0;
            while (i < ext_peers.length) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                String ps = ext_peer.getSource();
                if (ps_enabled || !ps.equals("Tracker")) {
                    int http_port = 0;
                    byte az_version = 1;
                    TRTrackerAnnouncerResponsePeerImpl p = new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getUDPPort(), http_port, ext_peer.getProtocol(), az_version, 0);
                    l_peers.add(p);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER: " + p.getString()));
                    }
                }
                ++i;
            }
            TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[l_peers.size()];
            l_peers.toArray(peers);
            this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
            if (ps_enabled || peers.length > 0 || ext_peers.length == 0) {
                status = MessageText.getString("PeerManager.status.ok");
            } else {
                status = MessageText.getString("PeerManager.status.ps_disabled");
                peers = new TRTrackerAnnouncerResponsePeerImpl[]{};
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash_actual, 2, result.getTimeToWait(), peers);
        }
        if (this.last_response == null || this.last_response.getStatus() != 2) {
            URL result_url = result.getURL();
            boolean update_is_dht = TorrentUtils.isDecentralised(result_url);
            this.tracker_status_str = String.valueOf(status) + " (" + (update_is_dht ? MessageText.getString("dht.backup.only") : (result_url == null ? "<null>" : result_url.getHost())) + ")";
        }
        this.helper.informResponse(this, new TRTrackerAnnouncerRequestImpl(), response);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener l) {
        this.helper.addListener(l);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener l) {
        this.helper.removeListener(l);
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        this.helper.setTrackerResponseCache(map);
    }

    @Override
    public void removeFromTrackerResponseCache(String ip, int tcpPort) {
        this.helper.removeFromTrackerResponseCache(ip, tcpPort);
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.helper.getTrackerResponseCache();
    }

    @Override
    public void clearTrackerResponseCache() {
        this.helper.clearTrackerResponseCache();
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet set) {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("BT announce:");
        try {
            writer.indent();
            writer.println("state: " + this.tracker_state + ", in_progress=" + this.update_in_progress);
            writer.println("current: " + (this.lastUsedUrl == null ? "null" : this.lastUsedUrl.toString()));
            writer.println("last: " + (this.last_response == null ? "null" : this.last_response.getString()));
            writer.println("last_update_secs: " + this.last_update_time_secs);
            writer.println("secs_to_wait: " + this.current_time_to_wait_secs + (this.manual_control ? " - manual" : ""));
            writer.println("t_interval: " + this.tracker_interval);
            writer.println("t_min_interval: " + this.tracker_min_interval);
            writer.println("min_interval: " + this.min_interval);
            writer.println("min_interval_override: " + this.min_interval_override);
            writer.println("rd: last_override=" + this.rd_last_override + ",percentage=" + this.rd_override_percentage);
            writer.println("event: " + (this.current_timer_event == null ? "null" : this.current_timer_event.getString()));
            writer.println("stopped: " + this.stopped + ", for_q=" + this.stopped_for_queue);
            writer.println("complete: " + this.completed + ", reported=" + this.complete_reported);
        }
        finally {
            writer.exdent();
        }
    }
}

