/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.client.impl.bt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.client.TRTrackerScraperClientResolver;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.tracker.client.impl.TRTrackerScraperImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerScraperResponseImpl;
import com.biglybt.core.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import com.biglybt.core.tracker.client.impl.bt.TrackerChecker;
import com.biglybt.core.tracker.protocol.udp.PRUDPTrackerCodecs;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncodingException;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerException;
import com.biglybt.pif.clientid.ClientIDException;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrackerStatus {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final String SS = "Scrape.status.";
    private static final String SSErr = "Scrape.status.error.";
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private static final int NOHASH_RETRY_INTERVAL = 10800000;
    private static final int GROUP_SCRAPES_MS = 900000;
    private static final int GROUP_SCRAPES_LIMIT = 20;
    private static boolean tcpScrapeEnabled;
    private static boolean udpScrapeEnabled;
    private static boolean udpProbeEnabled;
    private static final AllTrackersManager.AllTrackers all_trackers;
    private byte autoUDPscrapeEvery = 1;
    private int scrapeCount;
    private static final List logged_invalid_urls;
    private static final ThreadPool thread_pool;
    private final URL tracker_url;
    private final AllTrackersManager.AllTrackersTracker all_trackers_tracker;
    private boolean az_tracker;
    private boolean enable_sni_hack;
    private boolean internal_error_hack;
    private boolean dh_hack;
    private String scrapeURL = null;
    private final HashMap<HashWrapper, TRTrackerScraperResponseImpl> hashes;
    private final TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected final AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");
    private final TrackerChecker checker;
    private final AtomicInteger numActiveScrapes = new AtomicInteger(0);

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Enable TCP", "Server Enable UDP", "Tracker UDP Probe Enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                tcpScrapeEnabled = COConfigurationManager.getBooleanParameter("Tracker Client Enable TCP");
                udpScrapeEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
                udpProbeEnabled = COConfigurationManager.getBooleanParameter("Tracker UDP Probe Enable");
            }
        });
        all_trackers = AllTrackersManager.getAllTrackers();
        logged_invalid_urls = new ArrayList();
        thread_pool = new ThreadPool("TrackerStatus", 10, true);
        all_trackers.registerScrapeStatsProvider(new AllTrackersManager.ScrapeStatsProvider(){

            @Override
            public AllTrackersManager.ScrapeStats getStats() {
                return new AllTrackersManager.ScrapeStats(){

                    @Override
                    public long getLagMillis() {
                        ScrapeTask oldest = (ScrapeTask)thread_pool.getOldestQueuedTask();
                        return oldest == null ? 0L : SystemTime.getMonotonousTime() - oldest.create_time;
                    }
                };
            }
        });
    }

    public TrackerStatus(TrackerChecker _checker, TRTrackerScraperImpl _scraper, URL _tracker_url) {
        this.checker = _checker;
        this.scraper = _scraper;
        this.tracker_url = _tracker_url;
        this.all_trackers_tracker = all_trackers.getTracker(this.tracker_url);
        this.az_tracker = TRTrackerUtils.isAZTracker(this.tracker_url);
        this.bSingleHashScrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Single Only");
        String trackerUrl = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            trackerUrl = trackerUrl.replaceAll(" ", "");
            String lc_trackerUrl = trackerUrl.toLowerCase(Locale.US);
            int position = trackerUrl.lastIndexOf(47);
            ArrayList<String> replaces = new ArrayList<String>(2);
            replaces.add("announce");
            if (AENetworkClassifier.categoriseAddress(this.tracker_url.getHost()) == "I2P") {
                replaces.add("a");
            }
            for (String rep : replaces) {
                int repLen = rep.length();
                if (position < 0 || trackerUrl.length() < position + repLen + 1 || !trackerUrl.substring(position + 1, position + repLen + 1).equals(rep)) continue;
                this.scrapeURL = String.valueOf(trackerUrl.substring(0, position + 1)) + "scrape" + trackerUrl.substring(position + repLen + 1);
                break;
            }
            if (this.scrapeURL == null) {
                if (lc_trackerUrl.startsWith("udp:")) {
                    this.scrapeURL = trackerUrl;
                } else if (lc_trackerUrl.startsWith("ws:") || lc_trackerUrl.startsWith("wss:")) {
                    this.scrapeURL = trackerUrl;
                    this.bSingleHashScrapes = true;
                } else if (position >= 0 && trackerUrl.lastIndexOf(46) < position) {
                    this.scrapeURL = String.valueOf(trackerUrl) + (trackerUrl.endsWith("/") ? "" : "/") + "scrape";
                } else if (!logged_invalid_urls.contains(trackerUrl)) {
                    logged_invalid_urls.add(trackerUrl);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected boolean isTrackerScrapeUrlValid() {
        return this.scrapeURL != null;
    }

    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = this.hashes.get(hash);
            return tRTrackerScraperResponseImpl;
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected void updateSingleHash(HashWrapper hash, boolean force) {
        this.updateSingleHash(hash, force, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateSingleHash(HashWrapper hash, boolean force, boolean async) {
        if (this.scrapeURL == null) {
            if (!Logger.isEnabled()) return;
            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": scrape cancelled.. url null"));
            return;
        }
        try {
            TRTrackerScraperResponseImpl response;
            ArrayList<TRTrackerScraperResponseImpl> responsesToUpdate = new ArrayList<TRTrackerScraperResponseImpl>();
            try {
                this.hashes_mon.enter();
                response = this.hashes.get(hash);
            }
            finally {
                this.hashes_mon.exit();
            }
            if (response == null) {
                response = this.addHash(hash);
            }
            long lMainNextScrapeStartTime = response.getNextScrapeStartTime();
            if (!force && lMainNextScrapeStartTime > SystemTime.getCurrentTime()) {
                if (!Logger.isEnabled()) return;
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": scrape cancelled.. not forced and still " + (lMainNextScrapeStartTime - SystemTime.getCurrentTime()) + "ms"));
                return;
            }
            response.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: " + this.scrapeURL + ": setting to scraping"));
            }
            responsesToUpdate.add(response);
            if (!this.bSingleHashScrapes) {
                try {
                    this.hashes_mon.enter();
                    Iterator<TRTrackerScraperResponseImpl> iterHashes = this.hashes.values().iterator();
                    while (iterHashes.hasNext() && responsesToUpdate.size() < 20) {
                        long lTimeDiff;
                        TRTrackerScraperResponseImpl r = iterHashes.next();
                        if (r.getHash().equals(hash) || (lTimeDiff = Math.abs(lMainNextScrapeStartTime - r.getNextScrapeStartTime())) > 900000L || r.getStatus() == 3) continue;
                        r.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(r.getHash()), LOGID, "TrackerStatus:" + this.scrapeURL + ": setting to scraping via group scrape"));
                        }
                        responsesToUpdate.add(r);
                    }
                }
                finally {
                    this.hashes_mon.exit();
                }
            }
            this.runScrapes(responsesToUpdate, force, async);
            return;
        }
        catch (Throwable t) {
            Debug.out("updateSingleHash() exception", t);
        }
    }

    protected void runScrapes(final ArrayList<TRTrackerScraperResponseImpl> responses, final boolean force, boolean async) {
        this.numActiveScrapes.incrementAndGet();
        if (async) {
            thread_pool.run(new ScrapeTask(this){

                @Override
                public void runSupport() {
                    this.runScrapesSupport(responses, force);
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerStatus: queuing '" + this.scrapeURL + "', for " + responses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N") + ", queue size=" + thread_pool.getQueueSize()));
            }
        } else {
            this.runScrapesSupport(responses, force);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void runScrapesSupport(ArrayList<TRTrackerScraperResponseImpl> allResponses, boolean force) {
        block87: {
            block85: {
                block86: {
                    block84: {
                        block83: {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(TrackerStatus.LOGID, "TrackerStatus: scraping '" + this.scrapeURL + "', for " + allResponses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes != false ? "Y" : "N")));
                            }
                            original_bSingleHashScrapes = this.bSingleHashScrapes;
                            disable_scrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable") == false;
                            options = this.all_trackers_tracker.getOptions();
                            if (options != null && (n = (Number)options.get("sl")) != null) {
                                scrape_level = n.intValue();
                                if (scrape_level == 1) {
                                    disable_scrapes = false;
                                } else if (scrape_level == 2) {
                                    disable_scrapes = true;
                                }
                            }
                            scrape_reply = null;
                            hashesInQuery = new ArrayList<HashWrapper>(allResponses.size());
                            responsesInQuery = new ArrayList<TRTrackerScraperResponseImpl>(allResponses.size());
                            hashesForUDP = new ArrayList<HashWrapper>();
                            responsesForUDP = new ArrayList<TRTrackerScraperResponseImpl>();
                            activeResponses = responsesInQuery;
                            reqUrl = null;
                            one_of_the_hashes = null;
                            first_separator = this.scrapeURL.indexOf(63) == -1 ? '?' : '&';
                            info_hash = "";
                            flags = "";
                            for (TRTrackerScraperResponseImpl response : allResponses) {
                                hash = response.getHash();
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, "TrackerStatus: " + this.scrapeURL + ": scraping, single_hash_scrapes = " + this.bSingleHashScrapes));
                                }
                                if (!this.scraper.isNetworkEnabled(hash, this.tracker_url)) {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, MessageText.getString("Scrape.status.networkdisabled"));
                                    this.scraper.scrapeReceived(response);
                                    continue;
                                }
                                if (!(force || !disable_scrapes && this.scraper.isTorrentScrapable(hash))) {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, MessageText.getString("Scrape.status.disabled"));
                                    this.scraper.scrapeReceived(response);
                                    continue;
                                }
                                hashesInQuery.add(hash);
                                responsesInQuery.add(response);
                                response.setStatus(3, MessageText.getString("Scrape.status.scraping"));
                                this.scraper.scrapeReceived(response);
                                info_hash = String.valueOf(info_hash) + (one_of_the_hashes != null ? '&' : first_separator) + "info_hash=";
                                info_hash = String.valueOf(info_hash) + URLEncoder.encode(new String(hash.getBytes(), Constants.BYTE_ENCODING_CHARSET), Constants.BYTE_ENCODING_CHARSET.name()).replaceAll("\\+", "%20");
                                extensions = this.scraper.getExtensions(hash);
                                if (extensions != null) {
                                    if (extensions[0] != null) {
                                        info_hash = String.valueOf(info_hash) + (String)extensions[0];
                                    }
                                    flags = String.valueOf(flags) + (Character)extensions[1];
                                } else {
                                    flags = String.valueOf(flags) + TRTrackerScraperClientResolver.FL_NONE;
                                }
                                one_of_the_hashes = hash;
                                if (hashesForUDP.size() >= 70) continue;
                                hashesForUDP.add(hash);
                                responsesForUDP.add(response);
                            }
                            if (one_of_the_hashes != null) break block83;
                            this.numActiveScrapes.decrementAndGet();
                            return;
                        }
                        request = String.valueOf(this.scrapeURL) + (String)info_hash;
                        if (this.az_tracker) {
                            port_details = TRTrackerUtils.getPortsForURL(TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber(), false);
                            request = String.valueOf(request) + port_details;
                            request = String.valueOf(request) + "&azsf=" + flags + "&azver=" + 3;
                        }
                        reqUrl = new URL(request);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TrackerStatus.LOGID, "Accessing scrape interface using url : " + reqUrl));
                        }
                        message = new ByteArrayOutputStream();
                        scrapeStartTime = SystemTime.getCurrentTime();
                        redirect_url = null;
                        protocol = reqUrl.getProtocol();
                        udpScrapeURL = null;
                        auto_probe = false;
                        if (!protocol.equalsIgnoreCase("udp")) ** GOTO lbl87
                        if (TrackerStatus.udpScrapeEnabled) {
                            udpScrapeURL = reqUrl;
                        } else {
                            throw new IOException("UDP Tracker protocol disabled");
lbl87:
                            // 1 sources

                            if (protocol.equalsIgnoreCase("http") && !this.az_tracker && this.scrapeCount % this.autoUDPscrapeEvery == 0 && TrackerStatus.udpProbeEnabled && TrackerStatus.udpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                                udpScrapeURL = new URL(reqUrl.toString().replaceFirst("^http", "udp"));
                                auto_probe = true;
                            }
                        }
                        if (udpScrapeURL == null && !this.az_tracker && !TrackerStatus.tcpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                            throw new IOException("HTTP Tracker protocol disabled");
                        }
                        try {
                            TrackerStatus.all_trackers.addScrapeRequest();
                            TorrentUtils.setTLSTorrentHash(one_of_the_hashes);
                            if (udpScrapeURL != null) {
                                activeResponses = responsesForUDP;
                                success = this.scrapeUDP(reqUrl, message, hashesForUDP, auto_probe == false);
                                if (!(success && message.size() != 0 || protocol.equalsIgnoreCase("udp"))) {
                                    udpScrapeURL = null;
                                    message.reset();
                                    if (this.autoUDPscrapeEvery < 16) {
                                        this.autoUDPscrapeEvery = (byte)(this.autoUDPscrapeEvery << 1);
                                    }
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(TrackerStatus.LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp failed, will retry in " + this.autoUDPscrapeEvery + " scrapes"));
                                    }
                                } else if (success && !protocol.equalsIgnoreCase("udp")) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(TrackerStatus.LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp successful"));
                                    }
                                    this.autoUDPscrapeEvery = 1;
                                    TRTrackerUtils.setUDPProbeResult(reqUrl, true);
                                }
                            }
                            ++this.scrapeCount;
                            if (udpScrapeURL != null) break block84;
                            activeResponses = responsesInQuery;
                            _reqUrl = new URL[]{reqUrl};
                            try {
                                redirect_url = this.scrapeHTTP(hashesInQuery, _reqUrl, message);
                            }
                            finally {
                                reqUrl = _reqUrl[0];
                            }
                        }
                        finally {
                            TrackerStatus.all_trackers.removeScrapeRequest();
                            TorrentUtils.setTLSTorrentHash(null);
                        }
                    }
                    scrape_reply = message.toByteArray();
                    map = BDecoder.decode(scrape_reply);
                    v0 = this_is_az_tracker = map.get("aztracker") != null;
                    if (this.az_tracker != this_is_az_tracker) {
                        this.az_tracker = this_is_az_tracker;
                        TRTrackerUtils.setAZTracker(this.tracker_url, this.az_tracker);
                    }
                    mapFiles = (Map)map.get("files");
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, "Response from scrape interface " + this.scrapeURL + ": " + (mapFiles == null ? "null" : "" + mapFiles.size()) + " returned"));
                    }
                    iMinRequestInterval = 0;
                    if (map != null && (mapFlags = (Map)map.get("flags")) != null) {
                        longScrapeValue = (Long)mapFlags.get("min_request_interval");
                        if (longScrapeValue != null) {
                            iMinRequestInterval = longScrapeValue.intValue();
                        }
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TrackerStatus.LOGID, "Received min_request_interval of " + iMinRequestInterval));
                        }
                    }
                    if (mapFiles != null && mapFiles.size() != 0) break block85;
                    if (!this.bSingleHashScrapes || !map.containsKey("complete") || !map.containsKey("incomplete")) break block86;
                    complete = MapUtils.getMapInt(map, "complete", 0);
                    incomplete = MapUtils.getMapInt(map, "incomplete", 0);
                    response = (TRTrackerScraperResponseImpl)activeResponses.get(0);
                    response.setPeers(incomplete);
                    response.setSeeds(complete);
                    minRequestInterval = MapUtils.getMapInt(map, "interval", 600000);
                    scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(minRequestInterval, complete);
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setStatus(2, "Tracker returned Announce from scrape call");
                    response.setScrapeStartTime(scrapeStartTime);
                    this.scraper.scrapeReceived(response);
                    this.numActiveScrapes.decrementAndGet();
                    return;
                }
                v1 = failure_reason_bytes = map == null ? null : (byte[])map.get("failure reason");
                if (failure_reason_bytes != null) {
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 600000 : iMinRequestInterval * 1000);
                    for (TRTrackerScraperResponseImpl response : activeResponses) {
                        response.setNextScrapeStartTime(nextScrapeTime);
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + new String(failure_reason_bytes, Constants.DEFAULT_ENCODING_CHARSET));
                        this.scraper.scrapeReceived(response);
                    }
                } else if (activeResponses.size() > 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, 1, String.valueOf(this.scrapeURL) + " doesn't properly support " + "multi-hash scrapes"));
                    }
                    for (TRTrackerScraperResponseImpl response : activeResponses) {
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                        this.scraper.scrapeReceived(response);
                    }
                } else {
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 10800000 : iMinRequestInterval * 1000);
                    response = (TRTrackerScraperResponseImpl)activeResponses.get(0);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                    this.scraper.scrapeReceived(response);
                }
                this.numActiveScrapes.decrementAndGet();
                return;
            }
            try {
                if (!this.bSingleHashScrapes && activeResponses.size() > 1 && mapFiles.size() == 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, 1, String.valueOf(this.scrapeURL) + " only returned " + mapFiles.size() + " hash scrape(s), but we asked for " + activeResponses.size()));
                    }
                }
                for (TRTrackerScraperResponseImpl response : activeResponses) {
                    scrapeMap = (Map)mapFiles.get(new String(response.getHash().getBytes(), Constants.BYTE_ENCODING_CHARSET));
                    if (scrapeMap == null) {
                        if (activeResponses.size() == 1 || mapFiles.size() != 1) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 10800000L);
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.nohash"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        if (!this.scraper.isTorrentScrapable(response.getHash())) continue;
                        response.revertStatus();
                        if (response.getStatus() == 3) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                        } else {
                            this.bSingleHashScrapes = true;
                            if (original_bSingleHashScrapes) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            }
                        }
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    l_seeds = (Long)scrapeMap.get("complete");
                    l_peers = (Long)scrapeMap.get("incomplete");
                    l_comp = (Long)scrapeMap.get("downloaded");
                    seeds = l_seeds == null ? 0 : l_seeds.intValue();
                    peers = l_peers == null ? 0 : l_peers.intValue();
                    v2 = completed = l_comp == null ? -1 : l_comp.intValue();
                    if (seeds < 0 || peers < 0 || completed < -1) {
                        if (Logger.isEnabled()) {
                            hash = response.getHash();
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, "Invalid scrape response from '" + reqUrl + "': map = " + scrapeMap));
                        }
                        if (activeResponses.size() > 1 && this.bSingleHashScrapes) {
                            response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.invalid") + " " + (seeds < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.seeds")) + " == " + seeds + ". " : "") + (peers < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.peers")) + " == " + peers + ". " : "") + (completed < 0 ? String.valueOf(MessageText.getString("MyTorrentsView.completed")) + " == " + completed + ". " : ""));
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(iMinRequestInterval, seeds);
                    nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setScrapeStartTime(scrapeStartTime);
                    response.setSeeds(seeds);
                    response.setPeers(peers);
                    response.setCompleted(completed);
                    response.setStatus(2, MessageText.getString("Scrape.status.ok"));
                    this.scraper.scrapeReceived(response);
                    try {
                        if (activeResponses.size() != 1 || redirect_url == null || (s_pos = (redirect_str = redirect_url.toString()).indexOf("/scrape")) == -1) continue;
                        new_url = new URL(String.valueOf(redirect_str.substring(0, s_pos)) + "/announce" + redirect_str.substring(s_pos + 7));
                        if (!this.scraper.redirectTrackerUrl(response.getHash(), this.tracker_url, new_url)) continue;
                        this.removeHash(response.getHash());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                break block87;
                {
                    catch (NoClassDefFoundError ignoreSSL) {
                        ** for (response : activeResponses)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + ignoreSSL.getMessage());
                    this.scraper.scrapeReceived(response);
                    continue;
lbl256:
                    // 1 sources

                    break block87;
                }
                {
                    catch (FileNotFoundException e) {
                        ** for (response : activeResponses)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("DownloadManager.error.filenotfound"));
                    this.scraper.scrapeReceived(response);
                    continue;
lbl263:
                    // 1 sources

                    break block87;
                }
                {
                    catch (SocketException e) {
                        this.setAllError(reqUrl, activeResponses, e);
                    }
                    catch (SocketTimeoutException e) {
                        this.setAllError(reqUrl, activeResponses, e);
                    }
                    catch (UnknownHostException e) {
                        this.setAllError(reqUrl, activeResponses, e);
                    }
                    catch (PRUDPPacketHandlerException e) {
                        this.setAllError(reqUrl, activeResponses, e);
                    }
                    catch (BEncodingException e) {
                        this.setAllError(reqUrl, activeResponses, e);
                    }
                    catch (Exception e) {
                        block88: {
                            error_message = e.getMessage();
                            if (error_message != null) {
                                if (error_message.contains(" 500 ") || error_message.contains(" 400 ") || error_message.contains(" 403 ") || error_message.contains(" 404 ") || error_message.contains(" 501 ")) {
                                    this.setAllError(reqUrl, activeResponses, e);
                                    this.numActiveScrapes.decrementAndGet();
                                    return;
                                }
                                if (!error_message.contains("414") || this.bSingleHashScrapes) break block88;
                                this.bSingleHashScrapes = true;
                                this.numActiveScrapes.decrementAndGet();
                                return;
                            }
                        }
                        try {
                            msg = Debug.getNestedExceptionMessage(e);
                            if (scrape_reply != null) {
                                trace_data = scrape_reply.length <= 150 ? new String(scrape_reply) : String.valueOf(new String(scrape_reply, 0, 150)) + "...";
                                msg = String.valueOf(msg) + " [" + trace_data + "]";
                            }
                            for (TRTrackerScraperResponseImpl response : activeResponses) {
                                if (Logger.isEnabled()) {
                                    hash = response.getHash();
                                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, 3, this.formatScrapeErrorMessage(reqUrl, msg)));
                                }
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + msg);
                                this.scraper.scrapeReceived(response);
                            }
                        }
                        catch (Throwable t) {
                            Debug.out("runScrapesSupport failed", t);
                        }
                    }
                }
            }
            finally {
                this.numActiveScrapes.decrementAndGet();
            }
        }
    }

    private String formatScrapeErrorMessage(URL reqURL, String msg) {
        if (reqURL != null) {
            msg = msg.replace(reqURL.toExternalForm(), this.scrapeURL);
        }
        return "Error from scrape interface " + this.scrapeURL + " : " + msg;
    }

    private void setAllError(URL reqURL, List<TRTrackerScraperResponseImpl> responses, Exception e) {
        String msg;
        msg = e instanceof BEncodingException ? ((msg = e.getLocalizedMessage()).contains("html") ? "Could not decode response, appears to be a website instead of tracker scrape: " + msg.replace('\n', ' ') : "Bencoded response malformed: " + msg) : Debug.getNestedExceptionMessage(e);
        for (TRTrackerScraperResponseImpl response : responses) {
            if (Logger.isEnabled()) {
                HashWrapper hash = response.getHash();
                Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 1, this.formatScrapeErrorMessage(reqURL, msg)));
            }
            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
            response.setStatus(1, StringInterner.intern(String.valueOf(MessageText.getString("Scrape.status.error")) + msg));
            this.scraper.scrapeReceived(response);
        }
    }

    /*
     * Unable to fully structure code
     */
    private URL scrapeHTTP(List<HashWrapper> hashesInQuery, URL[] _reqUrl, ByteArrayOutputStream message) throws Exception {
        block19: {
            block20: {
                reqUrl = _reqUrl[0];
                example_hash = hashesInQuery.get(0).getBytes();
                try {
                    return this.scrapeHTTPSupport(_reqUrl, example_hash, null, message);
                }
                catch (Exception e) {
                    if (AENetworkClassifier.categoriseAddress(reqUrl.getHost()) == "Public") break block19;
                    opts = new HashMap<String, Object>();
                    if (hashesInQuery.size() == 1) {
                        opts.put("peer_networks", this.scraper.getEnabledNetworks(hashesInQuery.get(0)));
                        break block20;
                    }
                    current_nets = null;
                    ** for (hash : hashesInQuery)
                }
lbl-1000:
                // 1 sources

                {
                    nets = this.scraper.getEnabledNetworks(hash);
                    if (nets == null) {
                        nets = new String[]{};
                    }
                    if (current_nets == null) {
                        current_nets = nets;
                        continue;
                    }
                    ok = false;
                    if (nets.length == current_nets.length) {
                        ok = true;
                        var16_20 = nets;
                        var15_19 = nets.length;
                        var14_18 = 0;
                        while (var14_18 < var15_19) {
                            net1 = var16_20[var14_18];
                            match = false;
                            var21_25 = current_nets;
                            var20_24 = current_nets.length;
                            var19_23 = 0;
                            while (var19_23 < var20_24) {
                                net2 = var21_25[var19_23];
                                if (net1 == net2) {
                                    match = true;
                                    break;
                                }
                                ++var19_23;
                            }
                            if (!match) {
                                ok = false;
                                break;
                            }
                            ++var14_18;
                        }
                    } else {
                        ok = false;
                    }
                    if (ok) continue;
                    this.bSingleHashScrapes = true;
                    throw new Exception("Mixed networks, forcing single-hash scrapes");
                }
lbl50:
                // 1 sources

                if (current_nets != null) {
                    opts.put("peer_networks", current_nets);
                }
            }
            proxy = AEProxyFactory.getPluginProxy("Tracker scrape", reqUrl, opts, true);
            if (proxy != null) {
                ok = false;
                try {
                    result = this.scrapeHTTPSupport(new URL[]{proxy.getURL()}, example_hash, proxy.getProxy(), message);
                    ok = true;
                    var12_16 = result;
                    return var12_16;
                }
                catch (Throwable var10_10) {
                }
                finally {
                    proxy.setOK(ok);
                }
            }
        }
        throw e;
    }

    private URL scrapeHTTPSupport(URL[] _reqUrl, byte[] example_hash, Proxy proxy, ByteArrayOutputStream message) throws IOException {
        int connect_loop = 0;
        while (connect_loop < 3) {
            block53: {
                URL redirect_url = null;
                URL reqUrl = _reqUrl[0];
                TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
                reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
                reqUrl = AddressUtils.adjustURL(reqUrl);
                Properties http_properties = new Properties();
                http_properties.put("URL", reqUrl);
                if (proxy != null) {
                    http_properties.put("Proxy", proxy);
                }
                if (this.enable_sni_hack) {
                    http_properties.put("SNI-Hack", (Object)true);
                }
                try {
                    ClientIDManagerImpl.getSingleton().generateHTTPProperties(example_hash, http_properties);
                }
                catch (ClientIDException e) {
                    throw new IOException(e.getMessage());
                }
                _reqUrl[0] = reqUrl = (URL)http_properties.get("URL");
                InputStream is = null;
                try {
                    String encoding;
                    boolean gzip;
                    String marker;
                    int pos;
                    HttpURLConnection con = null;
                    if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
                        HttpsURLConnection ssl_con = proxy == null ? (HttpsURLConnection)reqUrl.openConnection() : (HttpsURLConnection)reqUrl.openConnection(proxy);
                        if (!this.internal_error_hack) {
                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                        }
                        if (this.dh_hack) {
                            UrlUtils.DHHackIt(ssl_con);
                        }
                        if (connect_loop > 0) {
                            TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                            try {
                                SSLContext sc = SSLContext.getInstance("SSL");
                                sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                                SSLSocketFactory factory = sc.getSocketFactory();
                                ssl_con.setSSLSocketFactory(factory);
                            }
                            catch (Throwable sc) {
                                // empty catch block
                            }
                        }
                        con = ssl_con;
                    } else {
                        con = proxy == null ? (HttpURLConnection)reqUrl.openConnection() : (HttpURLConnection)reqUrl.openConnection(proxy);
                    }
                    con.setInstanceFollowRedirects(true);
                    String user_agent = (String)http_properties.get("User-Agent");
                    if (user_agent != null) {
                        con.setRequestProperty("User-Agent", user_agent);
                    }
                    con.addRequestProperty("Accept-Encoding", "gzip");
                    con.setRequestProperty("Connection", "close");
                    try {
                        con.connect();
                    }
                    catch (AEProxyFactory.UnknownHostException e) {
                        throw new UnknownHostException(e.getMessage());
                    }
                    is = con.getInputStream();
                    String resulting_url_str = con.getURL().toString();
                    if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                        --pos;
                        try {
                            redirect_url = new URL(resulting_url_str.substring(0, pos));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
                    if (gzip) {
                        is = new GZIPInputStream(is);
                    }
                    byte[] data = new byte[1024];
                    int num_read = 0;
                    try {
                        while (true) {
                            int len;
                            if ((len = is.read(data)) > 0) {
                                message.write(data, 0, len);
                                if ((num_read += len) <= 131072) continue;
                                message.reset();
                                throw new Exception("Tracker response invalid (too large)");
                            }
                            if (len == 0) {
                                Thread.sleep(20L);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (Logger.isEnabled()) {
                            String msg = Debug.getNestedExceptionMessage(e);
                            Logger.log(new LogEvent(LOGID, 3, this.formatScrapeErrorMessage(reqUrl, msg)));
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }
                catch (SSLException e) {
                    if (connect_loop < 3) {
                        String msg = Debug.getNestedExceptionMessage(e);
                        boolean try_again = false;
                        if (msg.contains("unrecognized_name")) {
                            if (!this.enable_sni_hack) {
                                this.enable_sni_hack = true;
                                try_again = true;
                            }
                        } else if (msg.contains("internal_error") || msg.contains("handshake_failure")) {
                            if (!this.internal_error_hack) {
                                this.internal_error_hack = true;
                                try_again = true;
                            }
                        } else if (msg.contains("DH keypair") && !this.dh_hack) {
                            this.dh_hack = true;
                            try_again = true;
                        }
                        if (SESecurityManager.installServerCertificates(reqUrl) != null || connect_loop == 0) {
                            try_again = true;
                        }
                        if (try_again) break block53;
                    }
                    throw e;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return redirect_url;
            }
            ++connect_loop;
        }
        throw new IOException("Shouldn't get here");
    }

    /*
     * Exception decompiling
     */
    protected boolean scrapeUDP(URL reqUrl, ByteArrayOutputStream message, List hashes, boolean do_auth_test) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(String.valueOf(param) + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected TRTrackerScraperResponseImpl addHash(HashWrapper hash) {
        TRTrackerScraperResponseImpl response;
        try {
            this.hashes_mon.enter();
            response = this.hashes.get(hash);
            if (response == null) {
                response = new TRTrackerBTScraperResponseImpl(this, hash);
                if (this.scrapeURL == null) {
                    response.setStatus(1, String.valueOf(MessageText.getString("Scrape.status.error")) + MessageText.getString("Scrape.status.error.badURL"));
                } else {
                    response.setStatus(0, MessageText.getString("Scrape.status.initializing"));
                }
                response.setNextScrapeStartTime(this.checker.getNextScrapeCheckOn());
                this.hashes.put(hash, response);
            }
        }
        finally {
            this.hashes_mon.exit();
        }
        this.scraper.scrapeReceived(response);
        return response;
    }

    protected void removeHash(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hash);
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.scraper.scrapeReceived(response);
    }

    public boolean getSupportsMultipeHashScrapes() {
        return !this.bSingleHashScrapes;
    }

    protected String getString() {
        return this.tracker_url + ", " + this.scrapeURL + ", multi-scrape=" + !this.bSingleHashScrapes;
    }

    public int getNumActiveScrapes() {
        return this.numActiveScrapes.get();
    }

    private abstract class ScrapeTask
    extends AERunnable {
        final long create_time = SystemTime.getMonotonousTime();

        private ScrapeTask() {
        }
    }
}

