/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.host.impl;

import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilEncodingException;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.TorrentUtils;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TRHostExternalTorrent
implements TOTorrent {
    private final byte[] name;
    private final byte[] hash;
    private final HashWrapper hash_wrapper;
    private final URL announce_url;
    protected final Map additional_properties = new HashMap();
    protected final AEMonitor this_mon = new AEMonitor("TRHostExternalTorrent");

    protected TRHostExternalTorrent(byte[] _hash, URL _announce_url) {
        this.hash = _hash;
        this.hash_wrapper = new HashWrapper(this.hash);
        this.announce_url = _announce_url;
        this.name = ByteFormatter.nicePrint(this.hash, true).getBytes();
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this);
        }
        catch (LocaleUtilEncodingException e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public int getTorrentType() {
        return 1;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    public boolean updateExportability(TOTorrent from) {
        return true;
    }

    @Override
    public byte[] getName() {
        return this.name;
    }

    @Override
    public String getUTF8Name() {
        return null;
    }

    @Override
    public boolean isSimpleTorrent() {
        return true;
    }

    @Override
    public byte[] getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public long getCreationDate() {
        return 0L;
    }

    @Override
    public void setCreationDate(long date) {
    }

    @Override
    public byte[] getCreatedBy() {
        return null;
    }

    @Override
    public void setCreatedBy(byte[] cb) {
    }

    @Override
    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.getAnnounceURL());
    }

    @Override
    public URL getAnnounceURL() {
        return this.announce_url;
    }

    @Override
    public boolean setAnnounceURL(URL url) {
        return false;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return new TOTorrentAnnounceURLGroup(){
            private final long uid = TorrentUtils.getAnnounceGroupUID();

            @Override
            public long getUID() {
                return this.uid;
            }

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return new TOTorrentAnnounceURLSet[0];
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] sets) {
            }
        };
    }

    public void addTorrentAnnounceURLSet(URL[] urls) {
    }

    @Override
    public byte[][] getPieces() {
        return new byte[0][];
    }

    @Override
    public void setPieces(byte[][] b) {
    }

    @Override
    public int getNumberOfPieces() {
        return 0;
    }

    @Override
    public long getPieceLength() {
        return -1L;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public int getFileCount() {
        return 0;
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return new TOTorrentFile[0];
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    @Override
    public byte[] getFullHash(int type) throws TOTorrentException {
        if (type == 1) {
            return this.hash;
        }
        return null;
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.hash_wrapper;
    }

    @Override
    public TOTorrent selectHybridHashType(int type) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 10);
    }

    @Override
    public void setHashOverride(byte[] hash) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    @Override
    public TOTorrent setSimpleTorrentDisabled(boolean disabled) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 10);
    }

    @Override
    public boolean isSimpleTorrentDisabled() throws TOTorrentException {
        throw new TOTorrentException("Not supported", 10);
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public void setPrivate(boolean _private) throws TOTorrentException {
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public void setSource(String str) throws TOTorrentException {
    }

    @Override
    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.hash, other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    @Override
    public void setAdditionalStringProperty(String name, String value) {
        try {
            this.additional_properties.put(name, value.getBytes(Constants.DEFAULT_ENCODING_CHARSET));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public String getAdditionalStringProperty(String name) {
        Object obj;
        block5: {
            block4: {
                try {
                    obj = this.additional_properties.get(name);
                    if (obj != null) break block4;
                    return null;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }
            if (obj instanceof byte[]) break block5;
            Debug.out("property '" + name + "' is not a byte[]: " + obj);
            return null;
        }
        return new String((byte[])obj, Constants.DEFAULT_ENCODING_CHARSET);
    }

    @Override
    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String name) {
        return (byte[])this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalLongProperty(String name, Long value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (value instanceof String) {
            this.setAdditionalStringProperty(name, (String)value);
        } else {
            this.additional_properties.put(name, value);
        }
    }

    @Override
    public Long getAdditionalLongProperty(String name) {
        return (Long)this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalListProperty(String name, List value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public List getAdditionalListProperty(String name) {
        return (List)this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalMapProperty(String name, Map value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public Map getAdditionalMapProperty(String name) {
        return (Map)this.additional_properties.get(name);
    }

    @Override
    public Object getAdditionalProperty(String name) {
        return this.additional_properties.get(name);
    }

    @Override
    public void removeAdditionalProperty(String name) {
        this.additional_properties.remove(name);
    }

    @Override
    public void removeAdditionalProperties() {
        this.additional_properties.clear();
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void addListener(TOTorrentListener l) {
    }

    @Override
    public void removeListener(TOTorrentListener l) {
    }

    @Override
    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    @Override
    public void print() {
    }
}

