/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.protocol.udp;

import com.biglybt.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyAnnounce
extends PRUDPPacketReply {
    protected int interval;
    protected static final int BYTES_PER_ENTRY = 6;
    protected int[] addresses;
    protected short[] ports;

    public PRUDPPacketReplyAnnounce(int trans_id) {
        super(1, trans_id);
    }

    protected PRUDPPacketReplyAnnounce(DataInputStream is, int trans_id) throws IOException {
        super(1, trans_id);
        this.interval = is.readInt();
        this.addresses = new int[is.available() / 6];
        this.ports = new short[this.addresses.length];
        int i = 0;
        while (i < this.addresses.length) {
            this.addresses[i] = is.readInt();
            this.ports[i] = is.readShort();
            ++i;
        }
    }

    public void setInterval(int value) {
        this.interval = value;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setPeers(int[] _addresses, short[] _ports) {
        this.addresses = _addresses;
        this.ports = _ports;
    }

    public int[] getAddresses() {
        return this.addresses;
    }

    public short[] getPorts() {
        return this.ports;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.interval);
        if (this.addresses != null) {
            int i = 0;
            while (i < this.addresses.length) {
                os.writeInt(this.addresses[i]);
                os.writeShort(this.ports[i]);
                ++i;
            }
        }
    }

    @Override
    public String getString() {
        return super.getString().concat("[interval=").concat(String.valueOf(this.interval)).concat(", addresses=").concat(String.valueOf(this.addresses.length)).concat("]");
    }
}

