/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.server.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.tracker.server.TRTrackerServer;
import com.biglybt.core.tracker.server.TRTrackerServerException;
import com.biglybt.core.tracker.server.TRTrackerServerFactoryListener;
import com.biglybt.core.tracker.server.TRTrackerServerStats;
import com.biglybt.core.tracker.server.impl.TRTrackerServerImpl;
import com.biglybt.core.tracker.server.impl.dht.TRTrackerServerDHT;
import com.biglybt.core.tracker.server.impl.tcp.TRTrackerServerTCP;
import com.biglybt.core.tracker.server.impl.tcp.blocking.TRBlockingServer;
import com.biglybt.core.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import com.biglybt.core.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import com.biglybt.core.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import com.biglybt.core.tracker.server.impl.udp.TRTrackerServerUDP;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AsyncController;
import com.biglybt.core.util.CopyOnWriteList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TRTrackerServerFactoryImpl {
    protected static final CopyOnWriteList servers = new CopyOnWriteList();
    protected static final List listeners = new ArrayList();
    protected static final AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("tracker.read.bytes.total");
        types.add("tracker.write.bytes.total");
        types.add("tracker.announce.count");
        types.add("tracker.announce.time");
        types.add("tracker.scrape.count");
        types.add("tracker.scrape.time");
        CoreStats.registerProvider(types, new CoreStatsProvider(){

            public void updateStats(Set types, Map values) {
                long read_bytes = 0L;
                long write_bytes = 0L;
                long announce_count = 0L;
                long announce_time = 0L;
                long scrape_count = 0L;
                long scrape_time = 0L;
                Iterator it = servers.iterator();
                while (it.hasNext()) {
                    TRTrackerServerStats stats2 = ((TRTrackerServer)it.next()).getStats();
                    read_bytes += stats2.getBytesIn();
                    write_bytes += stats2.getBytesOut();
                    announce_count += stats2.getAnnounceCount();
                    announce_time += stats2.getAnnounceTime();
                    scrape_count += stats2.getScrapeCount();
                    scrape_time += stats2.getScrapeTime();
                }
                if (types.contains("tracker.read.bytes.total")) {
                    values.put("tracker.read.bytes.total", new Long(read_bytes));
                }
                if (types.contains("tracker.write.bytes.total")) {
                    values.put("tracker.write.bytes.total", new Long(write_bytes));
                }
                if (types.contains("tracker.announce.count")) {
                    values.put("tracker.announce.count", new Long(announce_count));
                }
                if (types.contains("tracker.announce.time")) {
                    values.put("tracker.announce.time", new Long(announce_time));
                }
                if (types.contains("tracker.scrape.count")) {
                    values.put("tracker.scrape.count", new Long(scrape_count));
                }
                if (types.contains("tracker.scrape.time")) {
                    values.put("tracker.scrape.time", new Long(scrape_time));
                }
            }
        });
    }

    public static TRTrackerServer create(String name, int protocol, int port, InetAddress bind_ip, boolean ssl, boolean apply_ip_filter, boolean main_tracker, boolean start_up_ready, Map<String, Object> properties) throws TRTrackerServerException {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        Boolean pr_non_blocking = (Boolean)properties.get("nonblocking");
        try {
            TRTrackerServerImpl server;
            class_mon.enter();
            if (protocol == 1) {
                boolean non_blocking;
                boolean explicit_non_blocking = pr_non_blocking != null && pr_non_blocking != false;
                boolean bl = non_blocking = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking") && main_tracker || explicit_non_blocking;
                if (non_blocking && !ssl) {
                    TRNonBlockingServer nb_server = new TRNonBlockingServer(name, port, bind_ip, apply_ip_filter, start_up_ready, properties, new TRNonBlockingServerProcessorFactory(){

                        @Override
                        public TRNonBlockingServerProcessor create(TRTrackerServerTCP _server, SocketChannel _socket) {
                            return new NonBlockingProcessor(_server, _socket);
                        }
                    });
                    server = nb_server;
                    if (explicit_non_blocking) {
                        nb_server.setRestrictNonBlocking(false);
                    }
                } else {
                    server = new TRBlockingServer(name, port, bind_ip, ssl, apply_ip_filter, start_up_ready, properties);
                }
            } else if (protocol == 2) {
                if (ssl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                server = new TRTrackerServerUDP(name, port, apply_ip_filter, start_up_ready, properties);
            } else {
                server = new TRTrackerServerDHT(name, apply_ip_filter, start_up_ready, properties);
            }
            servers.add(server);
            int i = 0;
            while (i < listeners.size()) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(server);
                ++i;
            }
            TRTrackerServerImpl tRTrackerServerImpl = server;
            return tRTrackerServerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected static void close(TRTrackerServerImpl server) {
        try {
            class_mon.enter();
            server.closeSupport();
            if (servers.remove(server)) {
                int i = 0;
                while (i < listeners.size()) {
                    ((TRTrackerServerFactoryListener)listeners.get(i)).serverDestroyed(server);
                    ++i;
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void addListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.add(l);
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                l.serverCreated((TRTrackerServer)it.next());
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void removeListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    protected static class NonBlockingProcessor
    extends TRNonBlockingServerProcessor {
        protected NonBlockingProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
            super(_server, _socket);
        }

        @Override
        protected ByteArrayOutputStream process(String input_header, String lowercase_input_header, String url_path, InetSocketAddress remote_address, boolean announce_and_scrape_only, InputStream is, AsyncController async) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            InetSocketAddress local_address = null;
            this.processRequest(input_header, lowercase_input_header, url_path, local_address, remote_address, announce_and_scrape_only, false, is, os, async);
            return os;
        }
    }
}

