/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.util.AENetworkClassifierListener;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Debug;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class AENetworkClassifier {
    public static final String AT_PUBLIC = "Public";
    public static final String AT_I2P = "I2P";
    public static final String AT_TOR = "Tor";
    public static final String[] AT_NETWORKS = new String[]{"Public", "I2P", "Tor"};
    public static final String[] AT_NON_PUBLIC = new String[]{"I2P", "Tor"};
    private static final List listeners = new ArrayList();

    public static String categoriseAddress(String str) {
        if (str == null) {
            return AT_PUBLIC;
        }
        int len = str.length();
        if (len < 4) {
            return AT_PUBLIC;
        }
        char[] chars = str.toCharArray();
        char last_char = chars[len - 1];
        if (last_char >= '0' && last_char <= '9') {
            return AT_PUBLIC;
        }
        if (last_char == 'p' || last_char == 'P') {
            char c;
            if (chars[len - 2] == '2' && chars[len - 4] == '.' && ((c = chars[len - 3]) == 'i' || c == 'I')) {
                return AT_I2P;
            }
            return AT_PUBLIC;
        }
        if (len >= 6 && last_char == 'n' || last_char == 'N') {
            String temp;
            if (chars[len - 6] == '.' && (temp = new String(chars, len - 5, 4).toLowerCase(Locale.US)).equals("onio")) {
                return AT_TOR;
            }
        } else if (len >= 8 && (last_char == 't' || last_char == 'T') && chars[len - 4] == '.') {
            char c1 = chars[len - 3];
            char c2 = chars[len - 2];
            if (!(c1 != 'a' && c1 != 'A' || c2 != 'l' && c2 != 'L')) {
                String temp;
                last_char = chars[(len -= 4) - 1];
                if (last_char >= '0' && last_char <= '9') {
                    return AT_PUBLIC;
                }
                if (last_char == 'p' || last_char == 'P') {
                    char c;
                    if (chars[len - 2] == '2' && chars[len - 4] == '.' && ((c = chars[len - 3]) == 'i' || c == 'I')) {
                        return AT_I2P;
                    }
                    return AT_PUBLIC;
                }
                if (len >= 6 && (last_char == 'n' || last_char == 'N') && chars[len - 6] == '.' && (temp = new String(chars, len - 5, 4).toLowerCase(Locale.US)).equals("onio")) {
                    return AT_TOR;
                }
            }
        }
        return AT_PUBLIC;
    }

    public static String internalise(String str) {
        if (str == null) {
            return null;
        }
        String[] stringArray = AT_NETWORKS;
        int n = AT_NETWORKS.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            if (str.equalsIgnoreCase(net)) {
                return net;
            }
            ++n2;
        }
        return null;
    }

    public static String categoriseAddress(InetSocketAddress isa) {
        return AENetworkClassifier.categoriseAddress(AddressUtils.getHostAddress(isa));
    }

    public static String[] getNetworks(TOTorrent torrent, String display_name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(torrent.getAnnounceURL());
        TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
        int i = 0;
        while (i < sets.length) {
            URL[] u = sets[i].getAnnounceURLs();
            Collections.addAll(urls, u);
            ++i;
        }
        ArrayList<String> available_networks = new ArrayList<String>();
        int i2 = 0;
        while (i2 < urls.size()) {
            URL u = (URL)urls.get(i2);
            String network = AENetworkClassifier.categoriseAddress(u.getHost());
            if (!available_networks.contains(network)) {
                available_networks.add(network);
            }
            ++i2;
        }
        if (available_networks.size() == 1 && available_networks.get(0) == AT_PUBLIC) {
            return new String[]{AT_PUBLIC};
        }
        boolean prompt = COConfigurationManager.getBooleanParameter("Network Selection Prompt");
        ArrayList<String> res = new ArrayList<String>();
        if (prompt && listeners.size() > 0) {
            String[] t_nets = new String[available_networks.size()];
            available_networks.toArray(t_nets);
            int i3 = 0;
            while (i3 < listeners.size()) {
                try {
                    String[] selected = ((AENetworkClassifierListener)listeners.get(i3)).selectNetworks(display_name, t_nets);
                    if (selected != null) {
                        Collections.addAll(res, selected);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < available_networks.size()) {
                if (COConfigurationManager.getBooleanParameter("Network Selection Default." + (String)available_networks.get(i4))) {
                    res.add((String)available_networks.get(i4));
                }
                ++i4;
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public static String[] getDefaultNetworks() {
        ArrayList<String> res = new ArrayList<String>();
        String[] stringArray = AT_NETWORKS;
        int n = AT_NETWORKS.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            if (COConfigurationManager.getBooleanParameter("Network Selection Default." + net)) {
                res.add(net);
            }
            ++n2;
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public static void addListener(AENetworkClassifierListener l) {
        listeners.add(l);
    }

    public static void removeListener(AENetworkClassifierListener l) {
        listeners.remove(l);
    }

    public static void main(String[] args) {
        String[] tests;
        String[] stringArray = new String[18];
        stringArray[1] = "12345";
        stringArray[2] = "5.alt";
        stringArray[3] = "12345.at";
        stringArray[4] = "12345.salt";
        stringArray[5] = "192.168.1.2";
        stringArray[6] = "f.i2";
        stringArray[7] = ".i2p";
        stringArray[8] = "f.i2p";
        stringArray[9] = ".i2p.alt";
        stringArray[10] = "f.i2.alt";
        stringArray[11] = "f.i2p.alt";
        stringArray[12] = "b.onio";
        stringArray[13] = ".onion";
        stringArray[14] = "b.onion";
        stringArray[15] = ".onion.alt";
        stringArray[16] = "b.onion.alt";
        stringArray[17] = "b.onio.alt";
        String[] stringArray2 = tests = stringArray;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray2[n2];
            System.out.println(String.valueOf(str) + " -> " + AENetworkClassifier.categoriseAddress(str));
            ++n2;
        }
    }
}

