/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.DebugLight;
import com.biglybt.core.util.SystemTime;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public abstract class AEThread2 {
    public static final boolean TRACE_TIMES = false;
    private static final int MIN_RETAINED = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private static final int MAX_RETAINED = Math.max(MIN_RETAINED * 4, 16);
    private static final int THREAD_TIMEOUT_CHECK_PERIOD = 10000;
    private static final int THREAD_TIMEOUT = 60000;
    private static final ConcurrentLinkedDeque<threadWrapper> daemon_threads = new ConcurrentLinkedDeque();
    private static final AtomicInteger daemon_thread_count = new AtomicInteger();
    private static final AEThread2 PENDING = new AEThread2("pending"){

        @Override
        public void run() {
        }
    };
    private static volatile long last_timeout_check;
    private threadWrapper wrapper;
    private String name;
    private final boolean daemon;
    private int priority = 5;
    private volatile JoinLock lock = new JoinLock();

    public static void createAndStartDaemon(String name, final Runnable r) {
        new AEThread2(name, true){

            @Override
            public void run() {
                r.run();
            }
        }.start();
    }

    public static AEThread2 createAndStartDaemon2(String name, final Runnable r) {
        AEThread2 thread = new AEThread2(name, true){

            @Override
            public void run() {
                r.run();
            }
        };
        thread.start();
        return thread;
    }

    public AEThread2(String _name) {
        this(_name, true);
    }

    public AEThread2(String _name, boolean _daemon) {
        this.name = _name;
        this.daemon = _daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JoinLock newLock;
        JoinLock currentLock;
        JoinLock joinLock = currentLock = this.lock;
        synchronized (joinLock) {
            newLock = currentLock.released ? (this.lock = new JoinLock()) : currentLock;
        }
        if (this.daemon) {
            this.wrapper = daemon_threads.pollLast();
            if (this.wrapper == null) {
                this.wrapper = new threadWrapper(this.name, true);
            } else {
                daemon_thread_count.decrementAndGet();
                this.wrapper.setName(this.name);
            }
        } else {
            this.wrapper = new threadWrapper(this.name, false);
        }
        if (this.priority != this.wrapper.getPriority()) {
            this.wrapper.setPriority(this.priority);
        }
        this.wrapper.currentLock = newLock;
        this.wrapper.start(this, this.name);
    }

    public void setPriority(int _priority) {
        this.priority = _priority;
        if (this.wrapper != null) {
            this.wrapper.setPriority(this.priority);
        }
    }

    public void setName(String s) {
        this.name = s;
        if (this.wrapper != null) {
            this.wrapper.setName(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Interrupted before started!");
        }
        this.wrapper.interrupt();
    }

    public boolean isAlive() {
        return this.wrapper == null ? false : this.wrapper.isAlive();
    }

    public boolean isCurrentThread() {
        return this.wrapper == Thread.currentThread();
    }

    public String toString() {
        if (this.wrapper == null) {
            return String.valueOf(this.name) + " [daemon=" + this.daemon + ",priority=" + this.priority + "]";
        }
        return this.wrapper.toString();
    }

    public abstract void run();

    public static boolean isOurThread(Thread thread) {
        return AEThread.isOurThread(thread);
    }

    public static void setOurThread() {
        AEThread.setOurThread();
    }

    public static void setOurThread(Thread thread) {
        AEThread.setOurThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join() {
        JoinLock currentLock;
        JoinLock joinLock = currentLock = this.lock;
        synchronized (joinLock) {
            while (true) {
                if (currentLock.released) {
                    return;
                }
                try {
                    currentLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static final class JoinLock {
        volatile boolean released = false;

        private JoinLock() {
        }
    }

    protected static class threadWrapper
    extends Thread {
        private volatile AEThread2 target = null;
        private JoinLock currentLock;
        private long last_active_time;

        protected threadWrapper(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                JoinLock joinLock = this.currentLock;
                synchronized (joinLock) {
                    block14: {
                        try {
                            try {
                                this.target.run();
                            }
                            catch (Throwable e) {
                                DebugLight.printStackTrace(e);
                                this.target = PENDING;
                                this.currentLock.released = true;
                                this.currentLock.notifyAll();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            this.target = PENDING;
                            this.currentLock.released = true;
                            this.currentLock.notifyAll();
                            throw throwable;
                        }
                        this.target = PENDING;
                        this.currentLock.released = true;
                        this.currentLock.notifyAll();
                    }
                }
                if (this.isInterrupted() || !Thread.currentThread().isDaemon()) break;
                this.last_active_time = SystemTime.getMonotonousTime();
                if (this.last_active_time < last_timeout_check || this.last_active_time - last_timeout_check > 10000L) {
                    threadWrapper thread;
                    last_timeout_check = this.last_active_time;
                    int count = daemon_thread_count.get();
                    int to_maybe_remove = count - MIN_RETAINED;
                    if (to_maybe_remove > 0 && (thread = (threadWrapper)daemon_threads.peek()) != null && this.last_active_time - thread.last_active_time < 60000L) {
                        to_maybe_remove = 0;
                    }
                    while (to_maybe_remove > 0) {
                        thread = (threadWrapper)daemon_threads.poll();
                        if (thread == null) break;
                        daemon_thread_count.decrementAndGet();
                        --to_maybe_remove;
                        thread.retire();
                        if (this.last_active_time - thread.last_active_time < 60000L) break;
                    }
                }
                if (daemon_thread_count.get() >= MAX_RETAINED) {
                    return;
                }
                daemon_threads.addLast(this);
                daemon_thread_count.incrementAndGet();
                this.setName("AEThread2:parked[" + daemon_threads.size() + "]");
                while (this.target == PENDING) {
                    LockSupport.park(this);
                }
            } while (this.target != null);
        }

        protected void start(AEThread2 _target, String _name) {
            this.setName(_name);
            if (this.target == null) {
                this.target = _target;
                super.start();
            } else {
                this.target = _target;
                LockSupport.unpark(this);
            }
        }

        protected void retire() {
            this.target = null;
            LockSupport.unpark(this);
        }
    }
}

