/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.instancemanager.ClientInstance;
import com.biglybt.core.instancemanager.ClientInstanceManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.bouncycastle.util.encoders.Base64;

public class AddressUtils {
    public static final byte LAN_LOCAL_MAYBE = 0;
    public static final byte LAN_LOCAL_YES = 1;
    public static final byte LAN_LOCAL_NO = 2;
    private static boolean i2p_is_lan_limit;
    private static volatile ClientInstanceManager instance_manager;
    private static Map host_map;
    private static Set<InetSocketAddress> pending_addresses;
    private static TimerEventPeriodic pa_timer;
    static volatile List<Object[]> extra_ipv6_globals;

    static {
        COConfigurationManager.addAndFireParameterListener("Plugin.azneti2phelper.azi2phelper.rates.use.lan", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                i2p_is_lan_limit = COConfigurationManager.getBooleanParameter("Plugin.azneti2phelper.azi2phelper.rates.use.lan", false);
            }
        });
        host_map = null;
        pending_addresses = new HashSet<InetSocketAddress>();
        COConfigurationManager.addAndFireParameterListener("IPV6 Extra Globals", n -> {
            String str = COConfigurationManager.getStringParameter("IPV6 Extra Globals", "").trim();
            if (!str.isEmpty()) {
                String[] bits;
                ArrayList<Object[]> extra = new ArrayList<Object[]>();
                String[] stringArray = bits = str.replace(';', ',').split(",");
                int n2 = bits.length;
                int n3 = 0;
                while (n3 < n2) {
                    String bit = stringArray[n3];
                    bit = bit.trim();
                    String[] temp = bit.split("/");
                    boolean ok = false;
                    if (temp.length == 2) {
                        String prefix = temp[0].trim();
                        String len = temp[1].trim();
                        try {
                            InetAddress address = InetAddress.getByName(prefix);
                            int l = Integer.parseInt(len);
                            byte[] bytes = address.getAddress();
                            if (bytes.length == 16) {
                                extra.add(new Object[]{bytes, l});
                                ok = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (!ok) {
                        LogAlert alert = new LogAlert(true, 3, "Additional IPv6 global address error: Invalid CIDR: " + bit);
                        alert.forceNotify = true;
                        Logger.log(alert);
                    }
                    ++n3;
                }
                extra_ipv6_globals = extra;
            }
        });
    }

    private static ClientInstanceManager getInstanceManager() {
        if (instance_manager == null && CoreFactory.isCoreAvailable()) {
            try {
                instance_manager = CoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return instance_manager;
    }

    public static URL adjustURL(URL url) {
        String rewrite;
        url = AEProxyFactory.getAddressMapper().internalise(url);
        if (host_map != null && (rewrite = (String)host_map.get(url.getHost())) != null) {
            String str = url.toExternalForm();
            try {
                int pos = str.indexOf("//") + 2;
                int pos2 = str.indexOf("/", pos);
                String host_bit = str.substring(pos, pos2);
                int pos3 = host_bit.indexOf(58);
                String port_bit = pos3 == -1 ? "" : host_bit.substring(pos3);
                String new_str = String.valueOf(str.substring(0, pos)) + rewrite + port_bit + str.substring(pos2);
                url = new URL(new_str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return url;
    }

    public static synchronized void addHostRedirect(String from_host, String to_host) {
        System.out.println("AddressUtils::addHostRedirect - " + from_host + " -> " + to_host);
        HashMap<String, String> new_map = host_map == null ? new HashMap<String, String>() : new HashMap(host_map);
        new_map.put(from_host, to_host);
        host_map = new_map;
    }

    public static InetSocketAddress adjustTCPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 1);
    }

    public static InetSocketAddress adjustUDPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 2);
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 3);
    }

    private static InetSocketAddress adjustAddress(InetSocketAddress address, boolean ext_to_lan, int port_type) {
        ClientInstanceManager im = AddressUtils.getInstanceManager();
        if (im == null || !im.isInitialized()) {
            return address;
        }
        InetSocketAddress adjusted_address = ext_to_lan ? im.getLANAddress(address, port_type) : im.getExternalAddress(address, port_type);
        if (adjusted_address == null) {
            adjusted_address = address;
        }
        return adjusted_address;
    }

    public static List<String> getLANAddresses(String address) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(address);
        try {
            InetAddress ad = InetAddress.getByName(address);
            if (AddressUtils.isLANLocalAddress(address) != 2) {
                ClientInstanceManager im = AddressUtils.getInstanceManager();
                if (im == null || !im.isInitialized()) {
                    return result;
                }
                ClientInstance[] instances = im.getOtherInstances();
                int i = 0;
                while (i < instances.length) {
                    ClientInstance instance = instances[i];
                    List<InetAddress> addresses = instance.getInternalAddresses();
                    if (addresses.contains(ad)) {
                        int j = 0;
                        while (j < addresses.size()) {
                            InetAddress ia = addresses.get(j);
                            String str = ia.getHostAddress();
                            if (!result.contains(str)) {
                                result.add(str);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static byte isLANLocalAddress(InetSocketAddress socket_address) {
        ClientInstanceManager im = AddressUtils.getInstanceManager();
        if (im == null || !im.isInitialized()) {
            return 0;
        }
        return im.isLANAddress(socket_address) ? (byte)1 : 2;
    }

    public static byte isLANLocalAddress(String address) {
        byte is_lan_local = 0;
        try {
            is_lan_local = AENetworkClassifier.categoriseAddress(address) == "Public" ? AddressUtils.isLANLocalAddress(new InetSocketAddress(HostNameToIPResolver.syncResolve(address), 0)) : AddressUtils.isLANLocalAddress(InetSocketAddress.createUnresolved(address, 0));
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return is_lan_local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExplicitLANRateLimitAddress(InetSocketAddress address) {
        Set<InetSocketAddress> set = pending_addresses;
        synchronized (set) {
            ClientInstanceManager im = AddressUtils.getInstanceManager();
            if (im == null || !im.isInitialized()) {
                pending_addresses.add(address);
                if (pa_timer == null) {
                    pa_timer = SimpleTimer.addPeriodicEvent("au:pa", 250L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            Set set = pending_addresses;
                            synchronized (set) {
                                ClientInstanceManager im = AddressUtils.getInstanceManager();
                                if (im != null && im.isInitialized()) {
                                    for (InetSocketAddress address : pending_addresses) {
                                        try {
                                            im.addExplicitLANAddress(address);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                    pending_addresses.clear();
                                    pa_timer.cancel();
                                    pa_timer = null;
                                }
                            }
                        }
                    });
                }
            } else {
                im.addExplicitLANAddress(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExplicitLANRateLimitAddress(InetSocketAddress address) {
        Set<InetSocketAddress> set = pending_addresses;
        synchronized (set) {
            block5: {
                if (!pending_addresses.contains(address)) break block5;
                return true;
            }
            ClientInstanceManager im = AddressUtils.getInstanceManager();
            if (im != null && im.isInitialized()) {
                return im.isExplicitLANAddress(address);
            }
            return false;
        }
    }

    public static boolean isExplicitLANRateLimitAddress(String ip) {
        try {
            return AddressUtils.isExplicitLANRateLimitAddress(AddressUtils.getSocketAddress(ip));
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExplicitLANRateLimitAddress(InetSocketAddress address) {
        Set<InetSocketAddress> set = pending_addresses;
        synchronized (set) {
            pending_addresses.remove(address);
            ClientInstanceManager im = AddressUtils.getInstanceManager();
            if (im != null && im.isInitialized()) {
                im.removeExplicitLANAddress(address);
            }
        }
    }

    public static boolean applyLANRateLimits(InetSocketAddress address) {
        if (i2p_is_lan_limit && address.isUnresolved()) {
            return AENetworkClassifier.categoriseAddress(address) == "I2P";
        }
        return false;
    }

    public static boolean isGlobalAddressV6(InetAddress addr) {
        List<Object[]> extra = extra_ipv6_globals;
        if (extra != null && addr != null) {
            byte[] bytes = addr.getAddress();
            for (Object[] e : extra) {
                int len;
                byte[] prefix = (byte[])e[0];
                if (!AddressUtils.matchesCIDR(prefix, len = ((Integer)e[1]).intValue(), bytes)) continue;
                return true;
            }
        }
        return addr instanceof Inet6Address && !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isMulticastAddress() && !addr.isSiteLocalAddress() && !((Inet6Address)addr).isIPv4CompatibleAddress();
    }

    public static boolean isTeredo(InetAddress addr) {
        if (!(addr instanceof Inet6Address)) {
            return false;
        }
        byte[] bytes = addr.getAddress();
        return bytes[0] == 32 && bytes[1] == 1 && bytes[2] == 0 && bytes[3] == 0;
    }

    public static boolean is6to4(InetAddress addr) {
        if (!(addr instanceof Inet6Address)) {
            return false;
        }
        byte[] bytes = addr.getAddress();
        return bytes[0] == 32 && bytes[1] == 2;
    }

    public static List<InetAddress> pickBestGlobalV6Addresses(List<InetAddress> addrs) {
        ArrayList<InetAddress> bestPicks = new ArrayList<InetAddress>();
        int currentRanking = 0;
        for (InetAddress addr : addrs) {
            if (!AddressUtils.isGlobalAddressV6(addr)) continue;
            int ranking = AddressUtils.isTeredo(addr) ? 1 : (AddressUtils.is6to4(addr) ? 2 : 3);
            if (ranking > currentRanking) {
                bestPicks.clear();
                bestPicks.add(addr);
                currentRanking = ranking;
                continue;
            }
            if (ranking != currentRanking) continue;
            bestPicks.add(addr);
        }
        return bestPicks;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            return InetAddress.getByName(host);
        }
        throw new UnknownHostException(host);
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            return InetAddress.getAllByName(host);
        }
        throw new UnknownHostException(host);
    }

    public static byte[] getAddressBytes(InetSocketAddress address) {
        if (address.isUnresolved()) {
            try {
                return address.getHostName().getBytes("ISO8859-1");
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        return address.getAddress().getAddress();
    }

    public static String getHostAddress(InetSocketAddress address) {
        if (address == null) {
            return "";
        }
        if (address.isUnresolved()) {
            return address.getHostName();
        }
        return address.getAddress().getHostAddress();
    }

    public static boolean sameHost(InetSocketAddress a1, InetSocketAddress a2) {
        return AddressUtils.getHostAddress(a1).equals(AddressUtils.getHostAddress(a2));
    }

    public static InetSocketAddress getSocketAddress(String host) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            return new InetSocketAddress(InetAddress.getByName(host), 0);
        }
        return InetSocketAddress.createUnresolved(host, 0);
    }

    public static String getHostAddressForURL(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return address.getHostName();
        }
        InetAddress a = address.getAddress();
        if (a instanceof Inet6Address) {
            return "[" + (a.isLoopbackAddress() ? "::1" : a.getHostAddress()) + "]";
        }
        return a.getHostAddress();
    }

    public static String getHostNameNoResolve(InetSocketAddress address) {
        InetAddress i_address = address.getAddress();
        if (i_address == null) {
            return address.getHostName();
        }
        String str = i_address.toString();
        int pos = str.indexOf(47);
        if (pos == -1) {
            System.out.println("InetAddress::toString not returning expected result: " + str);
            return i_address.getHostAddress();
        }
        if (pos > 0) {
            return str.substring(0, pos);
        }
        return str.substring(pos + 1);
    }

    public static String convertToShortForm(String address) {
        int address_length = address.length();
        if (address_length > 256) {
            String to_decode;
            if (address.endsWith(".i2p")) {
                to_decode = address.substring(0, address.length() - 4);
            } else if (address.endsWith(".i2p.alt")) {
                to_decode = address.substring(0, address.length() - 8);
            } else if (address.indexOf(46) == -1) {
                to_decode = address;
            } else {
                return address;
            }
            try {
                char[] encoded = to_decode.toCharArray();
                int i = 0;
                while (i < encoded.length) {
                    char c = encoded[i];
                    if (c == '~') {
                        encoded[i] = 47;
                    } else if (c == '-') {
                        encoded[i] = 43;
                    }
                    ++i;
                }
                byte[] decoded = Base64.decode(encoded);
                byte[] hash = MessageDigest.getInstance("SHA-256").digest(decoded);
                return String.valueOf(Base32.encode(hash).toLowerCase(Locale.US)) + ".b32.i2p";
            }
            catch (Throwable e) {
                return null;
            }
        }
        return address;
    }

    public static boolean isPotentialLiteralOrHostAddress(String str) {
        if (str.indexOf(46) != -1 || str.indexOf(58) != -1) {
            return !str.startsWith("(");
        }
        return false;
    }

    public static boolean matchesCIDR(String address_mask, int len, InetAddress address) {
        try {
            InetAddress a = InetAddress.getByName(address_mask);
            return AddressUtils.matchesCIDR(a.getAddress(), len, address.getAddress());
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public static boolean matchesCIDR(byte[] prefix, int len, byte[] bytes) {
        if (bytes.length != prefix.length || len > bytes.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            byte mask = (byte)(1 << 7 - i % 8);
            int b1 = prefix[i / 8] & mask;
            int b2 = bytes[i / 8] & mask;
            if (b1 != b2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getShortForm(Inet6Address a) {
        return AddressUtils.getShortForm(a.getHostAddress());
    }

    private static String getShortForm(String str) {
        char[] chars = str.toCharArray();
        int char_count = chars.length;
        char[] temp = new char[char_count];
        int pos = 0;
        boolean leading = true;
        int current_run_index = -1;
        int current_run_length = -1;
        int best_run_index = -1;
        int best_run_length = -1;
        int i = 0;
        while (i < char_count) {
            block13: {
                char c;
                block15: {
                    block14: {
                        block12: {
                            c = chars[i];
                            if (c != ':') break block12;
                            temp[pos++] = 58;
                            leading = true;
                            break block13;
                        }
                        if (c != '0') break block14;
                        if (!leading) break block15;
                        if (i == char_count - 1 || chars[i + 1] == ':') {
                            if (current_run_index == -1) {
                                current_run_index = pos;
                                current_run_length = 1;
                            } else {
                                ++current_run_length;
                            }
                            temp[pos++] = 48;
                        }
                        break block13;
                    }
                    leading = false;
                }
                if (current_run_index != -1) {
                    if (current_run_length > best_run_length) {
                        best_run_length = current_run_length;
                        best_run_index = current_run_index;
                    }
                    current_run_index = -1;
                }
                temp[pos++] = c;
            }
            ++i;
        }
        if (current_run_index != -1 && current_run_length > best_run_length) {
            best_run_length = current_run_length;
            best_run_index = current_run_index;
        }
        if (best_run_length > 1) {
            int copy_from = best_run_index + best_run_length * 2 - 1;
            if (copy_from >= pos) {
                temp[best_run_index] = 58;
                pos = best_run_index + 1;
            } else {
                int x = best_run_index;
                int i2 = copy_from;
                while (i2 < pos) {
                    temp[x++] = temp[i2];
                    ++i2;
                }
                pos = x;
            }
            if (best_run_index == 0) {
                return ":" + new String(temp, 0, pos);
            }
        }
        return new String(temp, 0, pos);
    }
}

