/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Debug;
import java.nio.ByteBuffer;

public class ByteFormatter {
    static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String nicePrint(byte[] data) {
        return ByteFormatter.nicePrint(data, false);
    }

    public static String nicePrint(byte[] data, int max) {
        return ByteFormatter.nicePrint(data, false, max);
    }

    public static String nicePrint(ByteBuffer data) {
        byte[] raw = new byte[data.limit()];
        int i = 0;
        while (i < raw.length) {
            raw[i] = data.get(i);
            ++i;
        }
        return ByteFormatter.nicePrint(raw);
    }

    public static String nicePrint(byte[] data, boolean tight) {
        return ByteFormatter.nicePrint(data, tight, 1024);
    }

    public static String nicePrint(byte[] data, boolean tight, int max_length) {
        if (data == null) {
            return "";
        }
        int dataLength = data.length;
        if (dataLength > max_length) {
            dataLength = max_length;
        }
        int size = dataLength * 2;
        if (!tight) {
            size += (dataLength - 1) / 4;
        }
        char[] out = new char[size];
        try {
            int pos = 0;
            int i = 0;
            while (i < dataLength) {
                if (!tight && i % 4 == 0 && i > 0) {
                    out[pos++] = 32;
                }
                out[pos++] = HEXDIGITS[(byte)(data[i] >> 4 & 0xF)];
                out[pos++] = HEXDIGITS[(byte)(data[i] & 0xF)];
                ++i;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        try {
            return String.valueOf(new String(out)) + (data.length > max_length ? "..." : "");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return "";
        }
    }

    public static String nicePrint(byte b) {
        byte b1 = (byte)(b >> 4 & 0xF);
        byte b2 = (byte)(b & 0xF);
        return String.valueOf(ByteFormatter.nicePrint2(b1)) + ByteFormatter.nicePrint2(b2);
    }

    public static String nicePrint2(byte b) {
        String out = "";
        switch (b) {
            case 0: {
                out = "0";
                break;
            }
            case 1: {
                out = "1";
                break;
            }
            case 2: {
                out = "2";
                break;
            }
            case 3: {
                out = "3";
                break;
            }
            case 4: {
                out = "4";
                break;
            }
            case 5: {
                out = "5";
                break;
            }
            case 6: {
                out = "6";
                break;
            }
            case 7: {
                out = "7";
                break;
            }
            case 8: {
                out = "8";
                break;
            }
            case 9: {
                out = "9";
                break;
            }
            case 10: {
                out = "A";
                break;
            }
            case 11: {
                out = "B";
                break;
            }
            case 12: {
                out = "C";
                break;
            }
            case 13: {
                out = "D";
                break;
            }
            case 14: {
                out = "E";
                break;
            }
            case 15: {
                out = "F";
            }
        }
        return out;
    }

    public static String encodeString(byte[] bytes) {
        return ByteFormatter.nicePrint(bytes, true);
    }

    public static String encodeStringFully(byte[] bytes) {
        return ByteFormatter.nicePrint(bytes, true, Integer.MAX_VALUE);
    }

    public static String encodeString(byte[] bytes, int offset, int len) {
        byte[] x = new byte[len];
        System.arraycopy(bytes, offset, x, 0, len);
        return ByteFormatter.nicePrint(x, true);
    }

    public static byte[] decodeString(String str) {
        char[] chars = str.toCharArray();
        int chars_length = chars.length - chars.length % 2;
        byte[] res = new byte[chars_length / 2];
        int i = 0;
        while (i < chars_length) {
            String b = new String(chars, i, 2);
            res[i / 2] = (byte)Integer.parseInt(b, 16);
            i += 2;
        }
        return res;
    }

    public static int byteArrayToInt(byte[] array) {
        return array[0] << 24 & 0xFF000000 | array[1] << 16 & 0xFF0000 | array[2] << 8 & 0xFF00 | array[3] & 0xFF;
    }

    public static byte[] intToByteArray(long v) {
        return new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
    }

    public static byte[] longToByteArray(long v) {
        return new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
    }
}

