/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CopyOnWriteList<T>
implements Iterable<T> {
    private static final boolean LOG_STATS = false;
    private List<T> list = Collections.EMPTY_LIST;
    private final boolean use_linked_list;
    private boolean visible = false;
    private int initialCapacity;
    private static CopyOnWriteList stats;

    public CopyOnWriteList(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.use_linked_list = false;
    }

    public CopyOnWriteList() {
        this.initialCapacity = 1;
        this.use_linked_list = false;
    }

    public CopyOnWriteList(boolean _use_linked_list) {
        this.initialCapacity = 1;
        this.use_linked_list = _use_linked_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                AbstractList new_list = this.use_linked_list ? new LinkedList<T>(this.list) : new ArrayList<T>(this.list);
                new_list.add(obj);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.EMPTY_LIST) {
                    this.list = this.use_linked_list ? new LinkedList() : new ArrayList(this.initialCapacity);
                }
                this.list.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfNotPresent(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            block4: {
                if (!this.list.contains(obj)) break block4;
                return false;
            }
            this.add(obj);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(T entry) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            for (T e : this.list) {
                if (!e.equals(entry)) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T obj) {
        if (Constants.IS_CVS_VERSION && this.use_linked_list) {
            Debug.out("hmm");
        }
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                AbstractList new_list = this.use_linked_list ? new LinkedList<T>(this.list) : new ArrayList<T>(this.list);
                new_list.add(index, obj);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.EMPTY_LIST) {
                    this.list = this.use_linked_list ? new LinkedList() : new ArrayList(this.initialCapacity);
                }
                this.list.add(index, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<T> c) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                AbstractList new_list = this.use_linked_list ? new LinkedList<T>(this.list) : new ArrayList<T>(this.list);
                new_list.addAll(c);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.EMPTY_LIST) {
                    this.list = this.use_linked_list ? new LinkedList() : new ArrayList(this.initialCapacity);
                }
                this.list.addAll(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(Collection<T> c) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                AbstractList new_list = this.use_linked_list ? new LinkedList<T>(c) : new ArrayList<T>(c);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.EMPTY_LIST) {
                    this.list = this.use_linked_list ? new LinkedList() : new ArrayList(this.initialCapacity);
                } else {
                    this.list.clear();
                }
                this.list.addAll(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        if (Constants.IS_CVS_VERSION && this.use_linked_list) {
            Debug.out("hmm");
        }
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.indexOf(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                AbstractList new_list = this.use_linked_list ? new LinkedList<T>(this.list) : new ArrayList<T>(this.list);
                boolean result = new_list.remove(obj);
                this.list = new_list;
                this.visible = false;
                return result;
            }
            return this.list.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.list = Collections.EMPTY_LIST;
            this.visible = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.contains(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return new CopyOnWriteListIterator(this.list.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            if (Constants.IS_CVS_VERSION) {
                return Collections.unmodifiableList(this.list);
            }
            return this.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] toArray(T[] x) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray(x);
        }
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    private class CopyOnWriteListIterator
    implements Iterator<T> {
        private final Iterator<T> it;
        private T last;

        protected CopyOnWriteListIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteList.this.remove(this.last);
        }
    }
}

