/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.devices.Device;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSourceResolver {
    public static final Object DEFAULT_DATASOURCE = new Object();
    private static Map<String, Object> importer_map = new HashMap<String, Object>();

    public static Map<String, Object> exportDataSource(Object data_source) {
        if (data_source instanceof List) {
            data_source = ((List)data_source).toArray(new Object[0]);
        }
        if (data_source instanceof ExportableDataSource) {
            ExportedDataSource e = ((ExportableDataSource)data_source).exportDataSource();
            if (e == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("exporter", e.getExporter().getCanonicalName());
            result.put("export", e.getExport());
            return result;
        }
        if (data_source instanceof Object[]) {
            Object[] sources = data_source;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("exports", list);
            Object[] objectArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Object ds = objectArray[n2];
                list.add(DataSourceResolver.exportDataSource(ds));
                ++n2;
            }
            return result;
        }
        if (data_source instanceof Device) {
            return null;
        }
        if (data_source instanceof Peer) {
            return DataSourceResolver.exportDataSource(((Peer)data_source).getDescriptor());
        }
        if (data_source instanceof PEPeer) {
            return DataSourceResolver.exportDataSource(((PEPeer)data_source).getDescriptor());
        }
        if (data_source == DEFAULT_DATASOURCE) {
            return null;
        }
        Object core_ds = PluginCoreUtils.convert(data_source, true);
        if (core_ds != null && core_ds != data_source) {
            return DataSourceResolver.exportDataSource(core_ds);
        }
        byte[] literal = null;
        int literal_type = 0;
        if (data_source instanceof String) {
            literal = ((String)data_source).getBytes(Constants.UTF_8);
            literal_type = 1;
        }
        if (literal != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("literal_type", new Long(literal_type));
            result.put("literal", literal);
            return result;
        }
        Debug.out("Can't export a " + data_source);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object importDataSource(Map<String, Object> map) {
        Object literal = map.get("literal");
        if (literal != null) {
            try {
                int literal_type = ((Number)map.get("literal_type")).intValue();
                if (literal_type == 1) {
                    if (literal instanceof String) {
                        return literal;
                    }
                    return new String((byte[])literal, Constants.UTF_8);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Runnable callback = (Runnable)map.get("callback");
        List list = (List)map.get("exports");
        if (list == null) {
            DataSourceImporter importer;
            String exporter_class = (String)map.get("exporter");
            Map<String, Object> map2 = importer_map;
            synchronized (map2) {
                ArrayList temp;
                block15: {
                    temp = importer_map.get(exporter_class);
                    if (temp != null && !(temp instanceof List)) break block15;
                    if (callback == null) {
                        Debug.out("No importer for '" + exporter_class + "'");
                    } else {
                        if (temp == null) {
                            temp = new ArrayList();
                            importer_map.put(exporter_class, temp);
                        }
                        ((List)temp).add(callback);
                    }
                    return null;
                }
                importer = (DataSourceImporter)((Object)temp);
            }
            HashMap<String, Object> i_map = new HashMap<String, Object>((Map)map.get("export"));
            if (callback != null) {
                i_map.put("callback", callback);
            }
            return importer.importDataSource(i_map);
        }
        Object[] data_sources = new Object[list.size()];
        int i = 0;
        while (i < data_sources.length) {
            Map m = (Map)list.get(i);
            data_sources[i] = DataSourceResolver.importDataSource(m);
            ++i;
        }
        return data_sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExporter(DataSourceImporter exporter) {
        List callbacks = null;
        Map<String, Object> map = importer_map;
        synchronized (map) {
            String name = exporter.getClass().getCanonicalName();
            Object temp = importer_map.get(name);
            if (temp instanceof List) {
                callbacks = (List)temp;
            }
            importer_map.put(name, exporter);
        }
        if (callbacks != null) {
            for (Runnable r : callbacks) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    public static interface DataSourceImporter {
        public Object importDataSource(Map<String, Object> var1);
    }

    public static interface ExportableDataSource {
        public static final int OPT_ON_TOP = 0;
        public static final int OPT_CAN_MINIMIZE = 1;

        public ExportedDataSource exportDataSource();

        default public Boolean getBooleanOption(int opt) {
            return null;
        }
    }

    public static interface ExportedDataSource {
        public Class<? extends DataSourceImporter> getExporter();

        public Map<String, Object> getExport();
    }
}

