/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.MD4Hasher;

public class ED2KHasher {
    public static final int BLOCK_SIZE = 9728000;
    protected MD4Hasher current_hasher = new MD4Hasher();
    protected MD4Hasher block_hasher;
    protected int current_bytes;

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public void update(byte[] data, int pos, int len) {
        int rem = len;
        while (rem > 0) {
            int space = 9728000 - this.current_bytes;
            if (rem <= space) {
                this.current_hasher.update(data, pos, rem);
                this.current_bytes += rem;
                break;
            }
            if (this.block_hasher == null) {
                this.block_hasher = new MD4Hasher();
            }
            if (space == 0) {
                this.block_hasher.update(this.current_hasher.getDigest());
                this.current_hasher = new MD4Hasher();
                this.current_bytes = 0;
                continue;
            }
            this.current_hasher.update(data, pos, space);
            pos += space;
            rem -= space;
            this.current_bytes += space;
        }
    }

    public byte[] getDigest() {
        if (this.current_bytes == 9728000) {
            if (this.block_hasher == null) {
                this.block_hasher = new MD4Hasher();
            }
            this.block_hasher.update(this.current_hasher.getDigest());
            this.current_hasher = new MD4Hasher();
        }
        if (this.block_hasher == null) {
            return this.current_hasher.getDigest();
        }
        if (this.current_bytes > 0) {
            this.block_hasher.update(this.current_hasher.getDigest());
        }
        return this.block_hasher.getDigest();
    }
}

