/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileAccessController;
import com.biglybt.core.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FileHandler {
    public File newFile(File parent, String ... subDirs) {
        if (subDirs == null || subDirs.length == 0) {
            return parent;
        }
        File file = parent;
        String[] stringArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String subDir = stringArray[n2];
            file = new File(file, subDir);
            ++n2;
        }
        return file;
    }

    public File newFile(String parent, String ... subDirs) {
        if (subDirs == null || subDirs.length == 0) {
            return new File(parent);
        }
        File file = new File(parent, subDirs[0]);
        int i = 1;
        while (i < subDirs.length) {
            file = new File(file, subDirs[i]);
            ++i;
        }
        return file;
    }

    public File newFile(URI uri) {
        return new File(uri);
    }

    public FileOutputStream newFileOutputStream(File file, boolean append) throws FileNotFoundException {
        return new FileOutputStream(file, append);
    }

    public FileInputStream newFileInputStream(File from_file) throws FileNotFoundException {
        return new FileInputStream(from_file);
    }

    public FMFileAccess.FileAccessor newFileAccessor(File file, String access_mode) throws FileNotFoundException {
        return new FMFileAccessController.FileAccessorRAF(file, access_mode);
    }

    public boolean containsPathSegment(File f, String path, boolean caseSensitive) {
        String absolutePath = f.getAbsolutePath();
        if (!caseSensitive) {
            absolutePath = absolutePath.toLowerCase(Locale.US);
            path = path.toLowerCase(Locale.US);
        }
        return absolutePath.contains(String.valueOf(File.separator) + path + File.separator);
    }

    public String getRelativePath(File parentDir, File file) {
        String file_path;
        String parentPath = this.getCanonicalPathSafe(parentDir);
        if (!parentPath.endsWith(File.separator)) {
            parentPath = String.valueOf(parentPath) + File.separator;
        }
        if ((file_path = this.getCanonicalPathSafe(file)).startsWith(parentPath)) {
            return file_path.substring(parentPath.length());
        }
        return FileUtil.areFilePathsIdentical(parentDir, file) ? "" : null;
    }

    public File getCanonicalFileSafe(File file) {
        try {
            if (file.exists()) {
                File parent = file.getParentFile();
                if (parent == null) {
                    return file;
                }
                return this.newFile(file.getParentFile().getCanonicalFile(), file.getName());
            }
            return file.getCanonicalFile();
        }
        catch (Throwable e) {
            return file.getAbsoluteFile();
        }
    }

    public String getCanonicalPathSafe(File file) {
        try {
            if (file.exists()) {
                File parent = file.getParentFile();
                if (parent == null) {
                    return file.getAbsolutePath();
                }
                return this.newFile(file.getParentFile().getCanonicalFile(), file.getName()).getAbsolutePath();
            }
            return file.getCanonicalPath();
        }
        catch (Throwable e) {
            return file.getAbsolutePath();
        }
    }

    public boolean isAncestorOf(File _parent, File _child) {
        File child;
        File parent = _parent.getAbsoluteFile();
        if (parent.equals(child = _child.getAbsoluteFile())) {
            return FileUtil.areFilePathsIdentical(_parent, _child);
        }
        String parent_s = parent.getPath();
        String child_s = child.getPath();
        if (parent_s.charAt(parent_s.length() - 1) != File.separatorChar) {
            parent_s = String.valueOf(parent_s) + File.separatorChar;
        }
        if (child_s.startsWith(parent_s)) {
            return true;
        }
        parent = FileUtil.getCanonicalFile(_parent);
        if (parent.equals(child = FileUtil.getCanonicalFile(_child))) {
            return FileUtil.areFilePathsIdentical(_parent, _child);
        }
        parent_s = parent.getPath();
        child_s = child.getPath();
        if (parent_s.charAt(parent_s.length() - 1) != File.separatorChar) {
            parent_s = String.valueOf(parent_s) + File.separatorChar;
        }
        return child_s.startsWith(parent_s);
    }

    public Object getFileStore(File file) {
        File temp = file;
        while (temp != null) {
            try {
                return Files.getFileStore(temp.toPath());
            }
            catch (Throwable throwable) {
                temp = temp.getParentFile();
            }
        }
        return null;
    }

    public List<Object> getFileStores() {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Iterable<FileStore> it = FileSystems.getDefault().getFileStores();
            it.forEach(result::add);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

