/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ConfigUtils;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileHandler;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String DIR_SEP = System.getProperty("file.separator");
    private static final int RESERVED_FILE_HANDLE_COUNT = 4;
    private static boolean first_reservation = true;
    private static boolean is_my_lock_file = false;
    private static final List reserved_file_handles = new ArrayList();
    private static final AEMonitor class_mon = new AEMonitor("FileUtil:class");
    private static char[] char_conversion_mapping = null;
    private static final FileHandler fileHandling;
    private static AEDiagnosticsLogger file_logger;
    private static final ThreadLocal<IdentityHashSet<CoreOperationTask>> tls;
    static final Map<String, String> clax_cache;
    static final Map<String, Map<Object, Object>> exists_dir_cache;
    static final Object CACHE_TIME_KEY;
    static final Map<String, Long> exists_cache;
    private static String[] fs_names;
    private static long fs_names_last;
    private static Object fs_names_lock;
    private static AsyncDispatcher fs_names_dispatcher;
    private static boolean fs_updating;
    private static List<Consumer<String[]>> fs_pending_callbacks;
    private static AsyncDispatcher recycler;
    private static boolean sce_checked;
    private static String script_encoding;
    private static Map<Path, int[]> bad_roots;
    private static AsyncDispatcher fot_dispatcher;
    private static volatile File[] last_roots;
    private static long last_roots_time;
    private static AsyncDispatcher root_updater;
    private static AESemaphore root_update_sem;

    static {
        AEDiagnostics.addEvidenceGenerator(writer -> {});
        tls = new ThreadLocal<IdentityHashSet<CoreOperationTask>>(){

            @Override
            public IdentityHashSet<CoreOperationTask> initialValue() {
                return new IdentityHashSet<CoreOperationTask>();
            }
        };
        String fileHandlingCN = System.getProperty("az.FileHandling.impl", "");
        FileHandler fileHandlingImpl = null;
        if (!fileHandlingCN.isEmpty()) {
            try {
                Class<?> cla = Class.forName(fileHandlingCN);
                fileHandlingImpl = (FileHandler)cla.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        fileHandling = fileHandlingImpl == null ? new FileHandler() : fileHandlingImpl;
        AEThread2.createAndStartDaemon("FileUtil:init", () -> FileUtil.listRootsWithTimeout());
        clax_cache = new LinkedHashMap<String, String>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > 16;
            }
        };
        exists_dir_cache = new LinkedHashMap<String, Map<Object, Object>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Map<Object, Object>> eldest) {
                return this.size() > 16;
            }
        };
        CACHE_TIME_KEY = new Object();
        exists_cache = new LinkedHashMap<String, Long>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
                return this.size() > 16;
            }
        };
        fs_names = null;
        fs_names_last = -1L;
        fs_names_lock = new Object();
        fs_names_dispatcher = null;
        fs_pending_callbacks = new ArrayList<Consumer<String[]>>();
        FileUtil.getFileStoreNames(new File[0]);
        recycler = new AsyncDispatcher("Recycler");
        bad_roots = new HashMap<Path, int[]>();
        fot_dispatcher = new AsyncDispatcher("FOT");
        last_roots = new File[0];
        last_roots_time = -1L;
        root_updater = new AsyncDispatcher("RootUpdater");
    }

    public static boolean areFilePathsIdentical(File f1, File f2) {
        if (f1.equals(f2)) {
            String p2;
            boolean same_parent;
            String p1 = f1.getParent();
            boolean bl = same_parent = p1 == (p2 = f2.getParent()) || p1 != null && p1.equals(p2);
            return !same_parent || f1.getName().equals(f2.getName()) || !f1.getName().equalsIgnoreCase(f2.getName());
        }
        return false;
    }

    public static boolean reallyExists(File file) {
        if (file.exists()) {
            try {
                return file.getCanonicalFile().getName().equals(file.getName());
            }
            catch (Throwable e) {
                return true;
            }
        }
        return false;
    }

    public static File getCanonicalFileSafe(File file) {
        return fileHandling.getCanonicalFileSafe(file);
    }

    public static String getCanonicalPathSafe(File file) {
        return fileHandling.getCanonicalPathSafe(file);
    }

    public static boolean isAncestorOf(File _parent, File _child) {
        return fileHandling.isAncestorOf(_parent, _child);
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ioe) {
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalPath(File file, boolean lax) throws IOException {
        if (lax) {
            String cano;
            File parent = file.getParentFile();
            if (parent == null || parent.getParentFile() == null) {
                return file.getCanonicalPath();
            }
            String key = parent.getAbsolutePath();
            Map<String, String> map = clax_cache;
            synchronized (map) {
                cano = clax_cache.get(key);
                if (cano != null) {
                    return String.valueOf(cano) + File.separator + file.getName();
                }
            }
            cano = parent.getCanonicalPath();
            map = clax_cache;
            synchronized (map) {
                clax_cache.put(key, cano);
            }
            return String.valueOf(cano) + File.separator + file.getName();
        }
        return file.getCanonicalPath();
    }

    public static final boolean exists(File file) {
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean existsWithCache(File parent, String name) {
        long now = SystemTime.getMonotonousTime();
        String key = parent.getAbsolutePath();
        Map<String, Map<Object, Object>> map = exists_dir_cache;
        synchronized (map) {
            long t;
            Map<Object, Object> map2 = exists_dir_cache.get(key);
            if (map2 != null && now - (t = ((Long)map2.get(CACHE_TIME_KEY)).longValue()) < 5000L) {
                return map2.containsKey(name);
            }
        }
        String[] files = parent.list();
        Map<String, Map<Object, Object>> map3 = exists_dir_cache;
        synchronized (map3) {
            HashMap<Object, Object> map4;
            block9: {
                map4 = new HashMap<Object, Object>();
                map4.put(CACHE_TIME_KEY, now);
                if (files != null) break block9;
                exists_dir_cache.put(key, map4);
                return false;
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                map4.put(f, "");
                ++n2;
            }
            exists_dir_cache.put(key, map4);
            return map4.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void existsWithCacheClear(File parent) {
        String key = parent.getAbsolutePath();
        Map<String, Map<Object, Object>> map = exists_dir_cache;
        synchronized (map) {
            exists_dir_cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsWithCache(File file) {
        long now = SystemTime.getMonotonousTime();
        String key = file.getAbsolutePath();
        Map<String, Long> map = exists_cache;
        synchronized (map) {
            Long t = exists_cache.get(key);
            if (t != null && now - t < 5000L) {
                return true;
            }
        }
        boolean res = file.exists();
        if (!res) return res;
        Map<String, Long> map2 = exists_cache;
        synchronized (map2) {
            exists_cache.put(key, now);
            return res;
        }
    }

    public static String getCanonicalFileName(String filename) {
        String canonicalFileName = filename;
        try {
            canonicalFileName = FileUtil.newFile(filename, new String[0]).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canonicalFileName;
    }

    public static File getUserFile(String filename) {
        return FileUtil.newFile(SystemProperties.getUserPath(), filename);
    }

    public static File getApplicationFile(String filename) {
        String path = SystemProperties.getApplicationPath();
        return FileUtil.newFile(path, filename);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean recursiveDelete(File f) {
        String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
        String moveToDir = ConfigUtils.getDefaultMoveOnCompleteFolder(true);
        try {
            moveToDir = FileUtil.newFile(moveToDir, new String[0]).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            defSaveDir = FileUtil.newFile(defSaveDir, new String[0]).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (f.getCanonicalPath().equals(moveToDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the MoveTo dir !");
                return false;
            }
            if (f.getCanonicalPath().equals(defSaveDir)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the default data dir !");
                return false;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (!FileUtil.recursiveDelete(files[i])) {
                        return false;
                    }
                    ++i;
                }
                if (!f.delete()) {
                    return false;
                }
            } else if (!f.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean recursiveDeleteNoCheck(File f) {
        try {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (!FileUtil.recursiveDeleteNoCheck(files[i])) {
                        return false;
                    }
                    ++i;
                }
                if (!f.delete()) {
                    return false;
                }
            } else if (!f.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static long getFileOrDirectorySize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        long res = 0L;
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                res += FileUtil.getFileOrDirectorySize(files[i]);
                ++i;
            }
        }
        return res;
    }

    protected static void recursiveEmptyDirDelete(File f, Set<String> ignore_set, boolean log_warnings) {
        FileUtil.recursiveEmptyDirDelete(f, ignore_set, 1, log_warnings);
    }

    private static void recursiveEmptyDirDelete(File f, Set<String> ignore_set, int level, boolean log_warnings) {
        if (f == null) {
            return;
        }
        try {
            File moveToDirFile;
            File defSaveDirFile;
            String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
            String moveToDir = ConfigUtils.getDefaultMoveOnCompleteFolder(true);
            if (defSaveDir.trim().length() > 0) {
                defSaveDirFile = FileUtil.newFile(defSaveDir, new String[0]);
                defSaveDir = defSaveDirFile.getCanonicalPath();
            } else {
                defSaveDirFile = null;
            }
            if (moveToDir.trim().length() > 0) {
                moveToDirFile = FileUtil.newFile(moveToDir, new String[0]);
                moveToDir = moveToDirFile.getCanonicalPath();
            } else {
                moveToDirFile = null;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files == null) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete:  failed to list contents of directory '" + f + "'");
                    }
                    return;
                }
                boolean hasIgnoreSet = ignore_set.size() > 0;
                ArrayList<File> sub_dirs = new ArrayList<File>();
                ArrayList<File> files_inside = new ArrayList<File>();
                int i = 0;
                while (i < files.length) {
                    File x = files[i];
                    if (x.isDirectory()) {
                        sub_dirs.add(x);
                    } else if (hasIgnoreSet && ignore_set.contains(x.getName().toLowerCase())) {
                        if (!x.delete()) {
                            files_inside.add(x);
                            if (log_warnings) {
                                Debug.out("Empty folder delete: failed to delete file '" + x + "'");
                            }
                        }
                    } else {
                        files_inside.add(x);
                    }
                    ++i;
                }
                if (level == 1 && !files_inside.isEmpty()) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete: abandoning as top level folder '" + f + "' isn't empty");
                    }
                    return;
                }
                for (File dir : sub_dirs) {
                    FileUtil.recursiveEmptyDirDelete(dir, ignore_set, level + 1, log_warnings);
                }
                if (moveToDirFile != null && (FileUtil.areFilePathsIdentical(f.getAbsoluteFile(), moveToDirFile) || f.getCanonicalPath().equals(moveToDir))) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete: not allowed to delete the Move-To dir!");
                    }
                    return;
                }
                if (defSaveDirFile != null && (FileUtil.areFilePathsIdentical(f.getAbsoluteFile(), defSaveDirFile) || f.getCanonicalPath().equals(defSaveDir))) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete: not allowed to delete the Default Data dir!");
                    }
                    return;
                }
                files = f.listFiles();
                if (files == null) {
                    if (log_warnings) {
                        Debug.out("Empty folder delete: failed to list contents of directory '" + f + "'");
                    }
                    return;
                }
                if (files.length == 0) {
                    if (!f.delete() && log_warnings) {
                        Debug.out("Empty folder delete: failed to delete directory '" + f + "'");
                    }
                } else if (log_warnings) {
                    Debug.out("Empty folder delete:  " + files.length + " file(s)/folder(s) still in '" + f + "' - first listed item is '" + files[0].getName() + "'. Not removing.");
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertOSSpecificChars(String file_name_in, boolean is_folder) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            char c;
            int i;
            if (char_conversion_mapping == null) {
                COConfigurationManager.addAndFireListener(new COConfigurationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void configurationSaved() {
                        Class<FileUtil> clazz = FileUtil.class;
                        synchronized (FileUtil.class) {
                            String map = COConfigurationManager.getStringParameter("File.Character.Conversions");
                            String[] bits = map.split(",");
                            ArrayList<Character> chars = new ArrayList<Character>();
                            String[] stringArray = bits;
                            int n = bits.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String bit = stringArray[n2];
                                if ((bit = bit.trim()).length() == 3) {
                                    char from = bit.charAt(0);
                                    char to = bit.charAt(2);
                                    chars.add(Character.valueOf(from));
                                    chars.add(Character.valueOf(to));
                                }
                                ++n2;
                            }
                            char[] new_map = new char[chars.size()];
                            int i = 0;
                            while (i < new_map.length) {
                                new_map[i] = ((Character)chars.get(i)).charValue();
                                ++i;
                            }
                            char_conversion_mapping = new_map;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            char[] mapping2 = char_conversion_mapping;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            char[] chars = file_name_in.toCharArray();
            if (mapping2.length == 2) {
                char from = mapping2[0];
                char to = mapping2[1];
                int i2 = 0;
                while (i2 < chars.length) {
                    if (chars[i2] == from) {
                        chars[i2] = to;
                    }
                    ++i2;
                }
            } else if (mapping2.length > 0) {
                i = 0;
                while (i < chars.length) {
                    c = chars[i];
                    int j = 0;
                    while (j < mapping2.length) {
                        if (c == mapping2[j]) {
                            chars[i] = mapping2[j + 1];
                        }
                        j += 2;
                    }
                    ++i;
                }
            }
            if (!Constants.isOSX) {
                if (Constants.isWindows) {
                    String not_allowed = "\\/:?*<>|";
                    int i3 = 0;
                    while (i3 < chars.length) {
                        if (not_allowed.indexOf(chars[i3]) != -1) {
                            chars[i3] = 95;
                        }
                        ++i3;
                    }
                    if (is_folder) {
                        i3 = chars.length - 1;
                        while (i3 >= 0 && (chars[i3] == '.' || chars[i3] == ' ')) {
                            chars[i3] = 95;
                            --i3;
                        }
                    }
                }
                i = 0;
                while (i < chars.length) {
                    c = chars[i];
                    if (c == '/' || c == '\r' || c == '\n') {
                        chars[i] = 32;
                    }
                    ++i;
                }
            }
            String file_name_out = new String(chars);
            try {
                if (Constants.isWindows) {
                    while (file_name_out.endsWith(" ")) {
                        file_name_out = file_name_out.substring(0, file_name_out.length() - 1);
                    }
                } else {
                    String str = FileUtil.newFile(file_name_out, new String[0]).getCanonicalFile().toString();
                    int p = str.lastIndexOf(File.separator);
                    file_name_out = str.substring(p + 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return file_name_out;
        }
    }

    public static void writeResilientConfigFile(String file_name, Map data) {
        File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backups);
    }

    public static void writeResilientFile(File file, Map data) {
        FileUtil.writeResilientFile(file.getParentFile(), file.getName(), data, false);
    }

    public static void writeResilientFileIncrementally(File file, Map data) {
        FileUtil.writeResilientFileIncrementally(file.getParentFile(), file.getName(), data);
    }

    public static boolean writeResilientFileWithResult(File parent_dir, String file_name, Map data) {
        return FileUtil.writeResilientFile(parent_dir, file_name, data);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup, true);
    }

    public static void writeResilientFile(File parent_dir, String file_name, Map data, boolean use_backup, boolean copy_to_backup) {
        File originator;
        if (use_backup && (originator = FileUtil.newFile(parent_dir, file_name)).exists()) {
            FileUtil.backupFile(originator, copy_to_backup);
        }
        FileUtil.writeResilientFile(parent_dir, file_name, data);
    }

    /*
     * Exception decompiling
     */
    private static boolean writeResilientFile(File parent_dir, String file_name, Map data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static boolean writeResilientFileIncrementally(File parent_dir, String file_name, Map data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean resilientConfigFileExists(String name) {
        File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return FileUtil.newFile(parent_dir, name).exists() || use_backups && FileUtil.newFile(parent_dir, String.valueOf(name) + ".bak").exists();
    }

    public static Map readResilientConfigFile(String file_name) {
        File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        boolean use_backups = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientConfigFile(String file_name, boolean use_backups) {
        File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        if (!use_backups && FileUtil.newFile(parent_dir, String.valueOf(file_name) + ".bak").exists()) {
            use_backups = true;
        }
        return FileUtil.readResilientFile(parent_dir, file_name, use_backups);
    }

    public static Map readResilientFile(File file) {
        return FileUtil.readResilientFile(file.getParentFile(), file.getName(), false, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup, true);
    }

    public static Map readResilientFile(File parent_dir, String file_name, boolean use_backup, boolean intern_keys) {
        Map res;
        File backup_file = FileUtil.newFile(parent_dir, String.valueOf(file_name) + ".bak");
        if (use_backup) {
            use_backup = backup_file.exists();
        }
        if ((res = FileUtil.readResilientFileSupport(parent_dir, file_name, !use_backup, intern_keys)) == null && use_backup) {
            res = FileUtil.readResilientFileSupport(parent_dir, String.valueOf(file_name) + ".bak", false, intern_keys);
            if (res != null) {
                Debug.out("Backup file '" + backup_file + "' has been used for recovery purposes");
                FileUtil.writeResilientFile(parent_dir, file_name, res, false);
            } else {
                res = FileUtil.readResilientFileSupport(parent_dir, file_name, true, true);
            }
        }
        if (res == null) {
            res = new HashMap();
        }
        return res;
    }

    private static Map readResilientFileSupport(File parent_dir, String file_name, boolean attempt_recovery, boolean intern_keys) {
        try {
            Map map;
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                Map res = null;
                try {
                    res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, false, intern_keys);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res == null && attempt_recovery && (res = FileUtil.readResilientFile(file_name, parent_dir, file_name, 0, true, intern_keys)) != null) {
                    Debug.out("File '" + file_name + "' has been partially recovered, information may have been lost!");
                }
                map = res;
            }
            catch (Throwable e) {
                try {
                    Debug.printStackTrace(e);
                }
                catch (Throwable throwable) {
                    FileUtil.releaseReservedFileHandles();
                    throw throwable;
                }
                FileUtil.releaseReservedFileHandles();
                class_mon.exit();
                return null;
            }
            FileUtil.releaseReservedFileHandles();
            return map;
        }
        finally {
            class_mon.exit();
        }
    }

    private static Map readResilientFile(String original_file_name, File parent_dir, String file_name, int fail_count, boolean recovery_mode, boolean skip_key_intern) {
        boolean using_backup = file_name.endsWith(".saving");
        File file = FileUtil.newFile(parent_dir, file_name);
        if (!file.exists() || file.length() <= 1L) {
            if (using_backup) {
                if (!recovery_mode && fail_count == 1) {
                    Debug.out("Load of '" + original_file_name + "' fails, no usable file or backup");
                }
                return null;
            }
            return FileUtil.readResilientFile(original_file_name, parent_dir, String.valueOf(file_name) + ".saving", 0, recovery_mode, true);
        }
        BufferedInputStream bin = null;
        try {
            int retry_limit = 5;
            while (true) {
                try {
                    bin = new BufferedInputStream(FileUtil.newFileInputStream(file), 16384);
                }
                catch (IOException e) {
                    if (--retry_limit == 0) {
                        throw e;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Failed to open '" + file.toString() + "', retrying", e));
                    }
                    Thread.sleep(500L);
                    continue;
                }
                break;
            }
            BDecoder decoder = new BDecoder();
            if (recovery_mode) {
                decoder.setRecoveryMode(true);
            }
            Map<String, Object> res = decoder.decodeStream(bin, !skip_key_intern);
            if (using_backup && !recovery_mode) {
                Debug.out("Load of '" + original_file_name + "' had to revert to backup file");
            }
            Map<String, Object> map = res;
            return map;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            try {
                if (bin != null) {
                    bin.close();
                    bin = null;
                }
            }
            catch (Exception x) {
                Debug.printStackTrace(x);
            }
            if (!recovery_mode) {
                File test;
                int bad_id = 0;
                while (true) {
                    if (!(test = FileUtil.newFile(parent_dir, String.valueOf(file.getName()) + ".bad" + (bad_id == 0 ? "" : "" + bad_id))).exists()) break;
                    ++bad_id;
                }
                File bad = test;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Read of '" + original_file_name + "' failed, decoding error. " + "Renaming to " + bad.getName()));
                }
                FileUtil.copyFile(file, bad);
            }
            if (using_backup) {
                if (!recovery_mode) {
                    Debug.out("Load of '" + original_file_name + "' fails, no usable file or backup");
                }
                return null;
            }
            Map map = FileUtil.readResilientFile(original_file_name, parent_dir, String.valueOf(file_name) + ".saving", 1, recovery_mode, true);
            return map;
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void deleteResilientFile(File file) {
        file.delete();
        FileUtil.newFile(file.getParentFile(), String.valueOf(file.getName()) + ".bak").delete();
    }

    public static void deleteResilientConfigFile(String name) {
        File parent_dir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        FileUtil.newFile(parent_dir, name).delete();
        FileUtil.newFile(parent_dir, String.valueOf(name) + ".bak").delete();
    }

    private static void getReservedFileHandles() {
        try {
            class_mon.enter();
            while (reserved_file_handles.size() > 0) {
                InputStream is = (InputStream)reserved_file_handles.remove(0);
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    private static void releaseReservedFileHandles() {
        try {
            try {
                class_mon.enter();
                File lock_file = FileUtil.newFile(String.valueOf(SystemProperties.getUserPath()) + ".lock", new String[0]);
                if (first_reservation) {
                    first_reservation = false;
                    lock_file.delete();
                    is_my_lock_file = lock_file.createNewFile();
                } else {
                    lock_file.createNewFile();
                }
                while (reserved_file_handles.size() < 4) {
                    FileInputStream is = FileUtil.newFileInputStream(lock_file);
                    reserved_file_handles.add(is);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                class_mon.exit();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isMyFileLock() {
        return is_my_lock_file;
    }

    public static void backupFile(String _filename, boolean _make_copy) {
        FileUtil.backupFile(FileUtil.newFile(_filename, new String[0]), _make_copy);
    }

    public static void backupFile(File _file, boolean _make_copy) {
        if (_file.length() > 0L) {
            File bakfile = FileUtil.newFile(String.valueOf(_file.getAbsolutePath()) + ".bak", new String[0]);
            if (bakfile.exists()) {
                bakfile.delete();
            }
            if (_make_copy) {
                FileUtil.copyFile(_file, bakfile);
            } else {
                _file.renameTo(bakfile);
            }
        }
    }

    public static boolean copyFileWithDates(File from_file, File to_file) {
        FileTime from_last_modified = null;
        FileTime from_last_access = null;
        FileTime from_created = null;
        try {
            BasicFileAttributeView from_attributes_view = Files.getFileAttributeView(from_file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            BasicFileAttributes from_attributes = from_attributes_view.readAttributes();
            from_last_modified = from_attributes.lastModifiedTime();
            from_last_access = from_attributes.lastAccessTime();
            from_created = from_attributes.creationTime();
        }
        catch (Throwable from_attributes_view) {
            // empty catch block
        }
        try {
            File parent = to_file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileUtil.copyFile((InputStream)FileUtil.newFileInputStream(from_file), FileUtil.newFileOutputStream(to_file));
            try {
                BasicFileAttributeView to_attributes_view = Files.getFileAttributeView(to_file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
                to_attributes_view.setTimes(from_last_modified, from_last_access, from_created);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        catch (Throwable e) {
            Debug.out("Copy failed for " + from_file, e);
            return false;
        }
    }

    public static boolean copyFile(File _source, File _dest) {
        try {
            File parent = _dest.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileUtil.copyFile((InputStream)FileUtil.newFileInputStream(_source), FileUtil.newFileOutputStream(_dest));
            return true;
        }
        catch (Throwable e) {
            Debug.out("Copy failed for " + _source, e);
            return false;
        }
    }

    public static void copyFileWithException(File _source, File _dest, ProgressListener pl) throws IOException {
        FileUtil.copyFile((InputStream)FileUtil.newFileInputStream(_source), (OutputStream)FileUtil.newFileOutputStream(_dest), pl);
    }

    public static boolean copyFile(File _source, OutputStream _dest, boolean closeInputStream) {
        try {
            FileUtil.copyFile((InputStream)FileUtil.newFileInputStream(_source), _dest, closeInputStream);
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public static void copyFile(InputStream _source, File _dest) throws IOException {
        File parent = _dest.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream dest = null;
        boolean close_input = true;
        try {
            dest = FileUtil.newFileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, true);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException iOException) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    public static void copyFile(InputStream _source, File _dest, boolean _close_input_stream) throws IOException {
        File parent = _dest.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream dest = null;
        boolean close_input = _close_input_stream;
        try {
            dest = FileUtil.newFileOutputStream(_dest);
            close_input = false;
            FileUtil.copyFile(_source, (OutputStream)dest, close_input);
        }
        finally {
            try {
                if (close_input) {
                    _source.close();
                }
            }
            catch (IOException iOException) {}
            if (dest != null) {
                dest.close();
            }
        }
    }

    public static void copyFile(InputStream is, OutputStream os) throws IOException {
        FileUtil.copyFile(is, os, true);
    }

    public static void copyFile(InputStream is, OutputStream os, ProgressListener pl) throws IOException {
        FileUtil.copyFile(is, os, true, pl);
    }

    public static void copyFile(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
        try {
            int len;
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is, 131072);
            }
            byte[] buffer = new byte[131072];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (closeInputStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            os.close();
        }
    }

    public static void copyFile(InputStream is, OutputStream os, boolean closeInputStream, ProgressListener pl) throws IOException {
        try {
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is, 131072);
            }
            byte[] buffer = new byte[131072];
            while (true) {
                int len;
                if (pl != null) {
                    int state;
                    while ((state = pl.getState()) == 2) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (state == 3) {
                        throw new IOException("Cancelled");
                    }
                }
                if ((len = is.read(buffer)) == -1) {
                    break;
                }
                os.write(buffer, 0, len);
                if (pl == null) continue;
                pl.bytesDone(len);
            }
        }
        finally {
            try {
                if (closeInputStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            os.close();
        }
    }

    public static void copyFileOrDirectory(File from_file_or_dir, File to_parent_dir) throws IOException {
        if (!from_file_or_dir.exists()) {
            throw new IOException("File '" + from_file_or_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.exists()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' doesn't exist");
        }
        if (!to_parent_dir.isDirectory()) {
            throw new IOException("File '" + to_parent_dir.toString() + "' is not a directory");
        }
        if (from_file_or_dir.isDirectory()) {
            File[] files = from_file_or_dir.listFiles();
            File new_parent = FileUtil.newFile(to_parent_dir, from_file_or_dir.getName());
            FileUtil.mkdirs(new_parent);
            int i = 0;
            while (i < files.length) {
                File from_file = files[i];
                FileUtil.copyFileOrDirectory(from_file, new_parent);
                ++i;
            }
        } else {
            File target = FileUtil.newFile(to_parent_dir, from_file_or_dir.getName());
            if (!FileUtil.copyFile(from_file_or_dir, target)) {
                throw new IOException("File copy from " + from_file_or_dir + " to " + target + " failed");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getFileOrBackup(String _filename) {
        File bakfile;
        block3: {
            try {
                File file = FileUtil.newFile(_filename, new String[0]);
                if (file.length() > 1L) return file;
                bakfile = FileUtil.newFile(String.valueOf(_filename) + ".bak", new String[0]);
                if (bakfile.length() > 1L) break block3;
                return null;
            }
            catch (Exception e) {
                Debug.out(e);
                return null;
            }
        }
        return bakfile;
    }

    public static File getJarFileFromClass(Class cla) {
        try {
            File jar_file;
            String url_str;
            String str = cla.getName();
            str = String.valueOf(str.replace('.', '/')) + ".class";
            URL url = cla.getClassLoader().getResource(str);
            if (url != null && (url_str = url.toExternalForm()).startsWith("jar:file:") && (jar_file = FileUtil.getJarFileFromURL(url_str)) != null && jar_file.exists()) {
                return jar_file;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static File getJarFileFromURL(String url_str) {
        if (url_str.startsWith("jar:file:")) {
            if (!(url_str = url_str.replaceAll(" ", "%20")).startsWith("jar:file:/")) {
                url_str = "jar:file:/".concat(url_str.substring(9));
            }
            try {
                URI uri;
                int posPling = url_str.lastIndexOf(33);
                String jarName = url_str.substring(4, posPling);
                try {
                    uri = URI.create(jarName);
                    if (!FileUtil.newFile(uri).exists()) {
                        throw new FileNotFoundException();
                    }
                }
                catch (Throwable e) {
                    jarName = "file:/" + UrlUtils.encode(jarName.substring(6));
                    uri = URI.create(jarName);
                }
                File jar = FileUtil.newFile(uri);
                return jar;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static boolean renameFile(File from_file, File to_file) {
        return FileUtil.renameFile(from_file, to_file, true) == null;
    }

    public static boolean renameFile(File from_file, File to_file, ProgressListener pl) {
        return FileUtil.renameFile(from_file, to_file, true, null, pl) == null;
    }

    private static String renameFile(File from_file, File to_file, boolean fail_on_existing_directory) {
        return FileUtil.renameFile(from_file, to_file, fail_on_existing_directory, null, null);
    }

    public static String renameFile(File from_file, File to_file, boolean fail_on_existing_directory, FileFilter file_filter, ProgressListener pl) {
        FileTime from_last_modified = null;
        FileTime from_last_access = null;
        FileTime from_created = null;
        try {
            BasicFileAttributeView from_attributes_view = Files.getFileAttributeView(from_file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            BasicFileAttributes from_attributes = from_attributes_view.readAttributes();
            from_last_modified = from_attributes.lastModifiedTime();
            from_last_access = from_attributes.lastAccessTime();
            from_created = from_attributes.creationTime();
        }
        catch (Throwable from_attributes_view) {
            // empty catch block
        }
        String result = FileUtil.renameFileSupport(from_file, to_file, fail_on_existing_directory, file_filter, pl);
        if (result == null) {
            try {
                BasicFileAttributeView to_attributes_view = Files.getFileAttributeView(to_file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
                BasicFileAttributes to_attributes = to_attributes_view.readAttributes();
                FileTime to_last_modified = to_attributes.lastModifiedTime();
                FileTime to_last_access = to_attributes.lastAccessTime();
                FileTime to_created = to_attributes.creationTime();
                if (!(from_last_modified.equals(to_last_modified) && from_last_access.equals(to_last_access) && from_created.equals(to_created))) {
                    to_attributes_view.setTimes(from_last_modified, from_last_access, from_created);
                }
            }
            catch (Throwable throwable) {}
        } else {
            Debug.out(result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String renameFileSupport(File from_file, File to_file, boolean fail_on_existing_directory, FileFilter file_filter, final ProgressListener pl) {
        boolean move_if_same_drive;
        boolean use_copy;
        File to_file_parent;
        if (!from_file.exists()) {
            return "renameFile: source file '" + from_file + "' doesn't exist, failing";
        }
        boolean to_file_exists = to_file.exists();
        if (to_file_exists) {
            if (from_file.equals(to_file)) {
                if (FileUtil.areFilePathsIdentical(from_file, to_file)) {
                    return null;
                }
                if (from_file.renameTo(to_file)) {
                    return null;
                }
            }
            String to_name = to_file.getName();
            String[] existing_files = to_file.getParentFile().list();
            if (!Arrays.asList(existing_files).contains(to_name)) {
                to_file_exists = false;
            }
        }
        if (to_file_exists && (fail_on_existing_directory || from_file.isFile() || to_file.isFile())) {
            return "renameFile: target file '" + to_file + "' already exists, failing";
        }
        if (pl != null) {
            int state;
            while ((state = pl.getState()) == 2) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable existing_files) {}
            }
            if (state == 3) {
                return "renameFile: Cancelled";
            }
        }
        if (!(to_file_parent = to_file.getParentFile()).exists()) {
            FileUtil.mkdirs(to_file_parent);
        }
        if (from_file.isDirectory()) {
            File tf;
            File ff;
            File[] files = null;
            files = file_filter != null ? from_file.listFiles(file_filter) : from_file.listFiles();
            if (files == null) {
                return null;
            }
            int last_ok = 0;
            String last_error = null;
            if (!to_file.exists()) {
                to_file.mkdir();
            }
            int i = 0;
            while (i < files.length) {
                block40: {
                    ff = files[i];
                    tf = FileUtil.newFile(to_file, ff.getName());
                    try {
                        String res = FileUtil.renameFile(ff, tf, fail_on_existing_directory, file_filter, pl);
                        if (res == null) {
                            ++last_ok;
                            break block40;
                        }
                        last_error = res;
                    }
                    catch (Throwable e) {
                        Debug.out("renameFile: failed to rename file '" + ff.toString() + "' to '" + tf.toString() + "'", e);
                    }
                    break;
                }
                ++i;
            }
            if (last_ok == files.length) {
                File[] remaining = from_file.listFiles();
                if (remaining != null && remaining.length > 0) {
                    if (file_filter != null) return null;
                    Debug.out("renameFile: files remain in '" + from_file.toString() + "', not deleting");
                    return null;
                } else {
                    if (from_file.delete()) return null;
                    Debug.out("renameFile: failed to delete '" + from_file.toString() + "'");
                }
                return null;
            }
            if (last_ok > 0) {
                FileUtil.log("Rename cancelled/failed, returning " + last_ok + " files to " + from_file.getAbsolutePath() + " from " + to_file.getAbsolutePath());
                i = 0;
                while (i < last_ok) {
                    ff = files[i];
                    tf = FileUtil.newFile(to_file, ff.getName());
                    try {
                        if (FileUtil.renameFile(tf, ff, false, null, new ProgressListener(){

                            @Override
                            public void setTotalSize(long size) {
                            }

                            @Override
                            public void setCurrentFile(File file) {
                                if (pl != null) {
                                    try {
                                        pl.setCurrentFile(file);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }

                            @Override
                            public void bytesDone(long num) {
                                if (pl != null) {
                                    try {
                                        pl.bytesDone(-num);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }

                            @Override
                            public int getState() {
                                return 1;
                            }

                            @Override
                            public void complete() {
                            }
                        }) != null) {
                            Debug.out("renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'");
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("renameFile: recovery - failed to move file '" + tf.toString() + "' to '" + ff.toString() + "'", e);
                    }
                    ++i;
                }
            }
            if (last_error == null) return "failed to move one or more files";
            return last_error;
        }
        boolean same_drive = false;
        FileStore fs1 = null;
        FileStore fs2 = null;
        try {
            fs1 = Files.getFileStore(from_file.toPath());
            fs2 = Files.getFileStore(to_file_parent.toPath());
            if (fs1.equals(fs2)) {
                same_drive = true;
            }
        }
        catch (Throwable e) {
            FileUtil.log("Failed to determine if files on same drive: " + from_file + " (" + fs1 + "), " + to_file_parent + " (" + fs2 + ")", e);
        }
        if ((use_copy = COConfigurationManager.getBooleanParameter("Copy And Delete Data Rather Than Move")) && (move_if_same_drive = COConfigurationManager.getBooleanParameter("Move If On Same Drive")) && same_drive) {
            use_copy = false;
        }
        if (!use_copy && pl != null && !same_drive) {
            use_copy = true;
            FileUtil.log("Copying file to get progress reports (" + fs1 + "/" + fs2 + ")");
        }
        if (use_copy) {
            return FileUtil.reallyCopyFile(from_file, to_file, pl);
        }
        if (pl != null) {
            try {
                pl.setCurrentFile(from_file);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (from_file.renameTo(to_file)) {
            if (pl == null) return null;
            try {
                pl.bytesDone(to_file.length());
                return null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            return null;
        }
        FileUtil.log("Failed to rename " + from_file + " to " + to_file + ", resorting to copy+delete");
        return FileUtil.reallyCopyFile(from_file, to_file, pl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFileStoreNames(Consumer<String[]> callback) {
        String[] existing_result;
        boolean do_update = false;
        Object object = fs_names_lock;
        synchronized (object) {
            if (fs_names_dispatcher == null) {
                fs_names_dispatcher = new AsyncDispatcher();
            }
            if ((existing_result = fs_names) == null || SystemTime.getMonotonousTime() - fs_names_last >= 30000L) {
                fs_pending_callbacks.add(callback);
                if (!fs_updating) {
                    fs_updating = true;
                    do_update = true;
                }
            }
        }
        if (existing_result != null) {
            try {
                callback.accept(existing_result);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (do_update) {
            fs_names_dispatcher.dispatch(() -> FileUtil.lambda$2(existing_result));
        }
    }

    public static String getFileStoreName(File file) {
        Object obj = fileHandling.getFileStore(file);
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static String[] getFileStoreNames(File ... files) {
        if (files == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fs;
            File f = fileArray[n2];
            if (f != null && (fs = FileUtil.getFileStoreName(f)) != null) {
                result.add(fs);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String reallyCopyFile(File from_file, File to_file, ProgressListener pl) {
        if (pl != null) {
            try {
                pl.setCurrentFile(from_file);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        boolean success = false;
        FileInputStream from_is = null;
        FileOutputStream to_os = null;
        DirectByteBuffer buffer = null;
        long total_reported = 0L;
        try {
            int BUFFER_SIZE = 131072;
            buffer = DirectByteBufferPool.getBuffer((byte)1, 131072);
            ByteBuffer bb = buffer.getBuffer((byte)1);
            from_is = FileUtil.newFileInputStream(from_file);
            to_os = FileUtil.newFileOutputStream(to_file);
            FileChannel from_fc = from_is.getChannel();
            FileChannel to_fc = to_os.getChannel();
            long rem = from_fc.size();
            while (rem > 0L) {
                if (pl != null) {
                    int state;
                    while ((state = pl.getState()) == 2) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (state == 3) {
                        throw new IOException("Cancelled");
                    }
                }
                int to_read = (int)Math.min(rem, 131072L);
                bb.position(0);
                bb.limit(to_read);
                while (bb.hasRemaining()) {
                    from_fc.read(bb);
                }
                bb.position(0);
                to_fc.write(bb);
                rem -= (long)to_read;
                if (pl == null) continue;
                try {
                    total_reported += (long)to_read;
                    pl.bytesDone(to_read);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            from_is.close();
            from_is = null;
            to_os.close();
            to_os = null;
            long del_retry_start = 0L;
            while (!from_file.delete()) {
                int state;
                long now = SystemTime.getMonotonousTime();
                if (del_retry_start == 0L) {
                    del_retry_start = now;
                } else if (now - del_retry_start < 10000L) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable throwable) {}
                } else {
                    if (COConfigurationManager.getBooleanParameter("Fail To Delete Origin File After Move Is Warning")) {
                        FileUtil.log("Warning: failed to delete " + from_file.getAbsolutePath() + " after moving via copy");
                        break;
                    }
                    Debug.out("renameFile: failed to delete '" + from_file.toString() + "'");
                    throw new Exception("Failed to delete '" + from_file.toString() + "'");
                }
                if (pl == null || (state = pl.getState()) != 3) continue;
                throw new IOException("Cancelled");
            }
            success = true;
            return null;
        }
        catch (Throwable e) {
            String string = "renameFile: failed to rename '" + from_file.toString() + "' to '" + to_file.toString() + "': " + Debug.getNestedExceptionMessage(e);
            return string;
        }
        finally {
            if (from_is != null) {
                try {
                    from_is.close();
                }
                catch (Throwable throwable) {}
            }
            if (to_os != null) {
                try {
                    to_os.close();
                }
                catch (Throwable throwable) {}
            }
            if (buffer != null) {
                buffer.returnToPool();
            }
            if (!success) {
                if (pl != null) {
                    try {
                        pl.bytesDone(-total_reported);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (to_file.exists()) {
                    to_file.delete();
                }
            }
        }
    }

    public static FileInputStream newFileInputStream(File from_file) throws FileNotFoundException {
        return fileHandling.newFileInputStream(from_file);
    }

    public static FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return fileHandling.newFileOutputStream(file, false);
    }

    public static FileOutputStream newFileOutputStream(File file, boolean append) throws FileNotFoundException {
        return fileHandling.newFileOutputStream(file, append);
    }

    public static boolean writeStringAsFile(File file, String text) {
        return FileUtil.writeStringAsFile(file, text, "UTF-8");
    }

    public static boolean writeStringAsFile(File file, String text, String charset) {
        try {
            return FileUtil.writeBytesAsFile2(file.getAbsolutePath(), text.getBytes(charset));
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public static void writeBytesAsFile(String filename, byte[] file_data) {
        FileUtil.writeBytesAsFile2(filename, file_data);
    }

    public static boolean writeBytesAsFile2(String filename, byte[] file_data) {
        try {
            File file = FileUtil.newFile(filename, new String[0]);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (FileOutputStream out = FileUtil.newFileOutputStream(file);){
                out.write(file_data);
            }
        }
        catch (Throwable t) {
            Debug.out("writeBytesAsFile:: error: ", t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteWithRecycle(File file, boolean force_no_recycle) {
        if (COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !force_no_recycle) {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                int QUEUE_LIMIT;
                int queued = recycler.getQueueSize();
                if (queued < (QUEUE_LIMIT = 1000)) {
                    boolean[] deleted = new boolean[1];
                    AESemaphore sem = new AESemaphore("Recycler");
                    recycler.dispatch(AERunnable.create(() -> {
                        try {
                            try {
                                platform.performRecoverableFileDelete(file.getAbsolutePath());
                                boolean[] blArray2 = deleted;
                                synchronized (deleted) {
                                    blArray[0] = true;
                                    // ** MonitorExit[var4_4] (shouldn't be in output)
                                }
                            }
                            catch (Throwable throwable) {
                                sem.release();
                            }
                        }
                        finally {
                            sem.release();
                        }
                        {
                            return;
                        }
                    }));
                    if (!sem.reserve(30000L)) {
                        Debug.out("Recycling of file '" + file + "' took too long, aborted");
                    }
                    boolean[] blArray = deleted;
                    synchronized (deleted) {
                        block9: {
                            if (!deleted[0]) break block9;
                            // ** MonitorExit[var7_7] (shouldn't be in output)
                            return true;
                        }
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                    }
                }
                if (queued == QUEUE_LIMIT) {
                    Debug.out("Recycler queue limit exceeded");
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    public static String translateMoveFilePath(String old_root, String new_root, String file_to_move) {
        if (!file_to_move.startsWith(old_root)) {
            return null;
        }
        if (old_root.equals(new_root)) {
            return file_to_move;
        }
        if (new_root.equals(file_to_move)) {
            return file_to_move;
        }
        String file_suffix = file_to_move.substring(old_root.length());
        if (file_suffix.startsWith(File.separator)) {
            file_suffix = file_suffix.substring(1);
        } else if (new_root.endsWith(File.separator)) {
            Debug.out("Hmm, this is not going to work out well... " + old_root + ", " + new_root + ", " + file_to_move);
        } else {
            if (new_root.endsWith(file_suffix)) {
                return new_root;
            }
            return String.valueOf(new_root) + file_suffix;
        }
        if (new_root.endsWith(File.separator)) {
            new_root = new_root.substring(0, new_root.length() - 1);
        }
        return String.valueOf(new_root) + File.separator + file_suffix;
    }

    public static boolean hasTask(DownloadManager dm) {
        Core core = CoreFactory.getSingleton();
        List<CoreOperation> ops = core.getOperations();
        for (CoreOperation op : ops) {
            CoreOperationTask task2;
            if (op.getOperationType() != 2 || (task2 = op.getTask()) == null || dm != task2.getDownload() || tls.get().contains(task2)) continue;
            return true;
        }
        return false;
    }

    public static void runAsTask(CoreOperationTask task2) {
        FileUtil.runAsTask(2, task2);
    }

    public static void runAsTask(int op_type, CoreOperationTask task2) {
        try {
            tls.get().add(task2);
            Core core = CoreFactory.getSingleton();
            core.executeOperation(op_type, task2);
        }
        finally {
            tls.get().remove(task2);
        }
    }

    public static boolean mkdirs(File f) {
        String sVolume;
        File fVolume;
        Pattern pat;
        Matcher matcher;
        if (Constants.isOSX && (matcher = (pat = Pattern.compile("^(/Volumes/[^/]+)")).matcher(f.getParent())).find() && !(fVolume = FileUtil.newFile(sVolume = matcher.group(), new String[0])).isDirectory()) {
            Logger.log(new LogEvent(LOGID, 1, String.valueOf(sVolume) + " is not mounted or not available."));
            return false;
        }
        return f.mkdirs();
    }

    public static String getExtension(String fName) {
        int fileSepIndex = fName.lastIndexOf(File.separator);
        int fileDotIndex = fName.lastIndexOf(46);
        if (fileSepIndex == fName.length() - 1 || fileDotIndex == -1 || fileSepIndex > fileDotIndex) {
            return "";
        }
        return fName.substring(fileDotIndex);
    }

    public static String readFileAsString(File file, int size_limit, String charset) throws IOException {
        try (FileInputStream fis = FileUtil.newFileInputStream(file);){
            String string = FileUtil.readInputStreamAsString(fis, size_limit, charset);
            return string;
        }
    }

    public static String readFileAsString(File file, int size_limit) throws IOException {
        try (FileInputStream fis = FileUtil.newFileInputStream(file);){
            String string = FileUtil.readInputStreamAsString(fis, size_limit);
            return string;
        }
    }

    public static String readGZippedFileAsString(File file, int size_limit) throws IOException {
        try (FileInputStream fis = FileUtil.newFileInputStream(file);){
            GZIPInputStream zis = new GZIPInputStream(fis);
            String string = FileUtil.readInputStreamAsString(zis, size_limit);
            return string;
        }
    }

    public static String readInputStreamAsString(InputStream is, int size_limit) throws IOException {
        return FileUtil.readInputStreamAsString(is, size_limit, "ISO-8859-1");
    }

    public static String readInputStreamAsString(InputStream is, int size_limit, String charSet) throws IOException {
        int len;
        StringBuilder result = new StringBuilder(1024);
        byte[] buffer = new byte[65536];
        while ((len = is.read(buffer)) > 0) {
            result.append(new String(buffer, 0, len, charSet));
            if (size_limit < 0 || result.length() <= size_limit) continue;
            result.setLength(size_limit);
            break;
        }
        return result.toString();
    }

    public static String readInputStreamAsString(InputStream is, int size_limit, int timeoutMillis, String charSet) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        long maxTimeMillis = System.currentTimeMillis() + (long)timeoutMillis;
        byte[] buffer = new byte[1024];
        while (System.currentTimeMillis() < maxTimeMillis) {
            int readLength = Math.min(is.available(), buffer.length);
            int len = is.read(buffer, 0, readLength);
            if (len == -1) break;
            result.append(new String(buffer, 0, len, charSet));
            if (size_limit < 0 || result.length() <= size_limit) continue;
            result.setLength(size_limit);
            break;
        }
        return result.toString();
    }

    public static String readInputStreamAsStringWithTruncation(InputStream is, int size_limit) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        byte[] buffer = new byte[65536];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, "ISO-8859-1"));
                if (size_limit < 0 || result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return result.toString();
    }

    public static String readFileEndAsString(File file, int size_limit, String charset) throws IOException {
        try (FileInputStream fis = FileUtil.newFileInputStream(file);){
            int len;
            if (file.length() > (long)size_limit) {
                fis.skip(file.length() - (long)size_limit);
            }
            StringBuilder result = new StringBuilder(1024);
            byte[] buffer = new byte[65536];
            while ((len = fis.read(buffer)) > 0) {
                result.append(new String(buffer, 0, len, charset));
                if (result.length() <= size_limit) continue;
                result.setLength(size_limit);
                break;
            }
            String string = result.toString();
            return string;
        }
    }

    public static byte[] readInputStreamAsByteArray(InputStream is) throws IOException {
        return FileUtil.readInputStreamAsByteArray(is, Integer.MAX_VALUE);
    }

    public static byte[] readInputStreamAsByteArray(InputStream is, int size_limit) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        byte[] buffer = new byte[32768];
        while ((len = is.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
            if (baos.size() <= size_limit) continue;
            throw new IOException("size limit exceeded");
        }
        return baos.toByteArray();
    }

    public static byte[] readFileAsByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        byte[] buffer = new byte[32768];
        try (FileInputStream is = FileUtil.newFileInputStream(file);){
            int len;
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static long getUsableSpace(File f) {
        try {
            return f.getUsableSpace();
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    public static boolean canReallyWriteToAppDirectory() {
        block16: {
            if (!FileUtil.getApplicationFile("bogus").getParentFile().canWrite()) {
                return false;
            }
            if (Constants.isWindowsVistaOrHigher) {
                try {
                    File[] files;
                    File write_test = FileUtil.getApplicationFile("_az_.dll");
                    try (FileOutputStream fos = FileUtil.newFileOutputStream(write_test);){
                        fos.write(32);
                    }
                    write_test.delete();
                    File rename_test = FileUtil.getApplicationFile("License.txt");
                    if (!rename_test.exists()) {
                        rename_test = FileUtil.getApplicationFile("GPL.txt");
                    }
                    if (!rename_test.exists() && (files = write_test.getParentFile().listFiles()) != null) {
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            String name = f.getName();
                            if (name.endsWith(".txt") || name.endsWith(".log")) {
                                rename_test = f;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (rename_test.exists()) {
                        File target = FileUtil.newFile(rename_test.getParentFile(), String.valueOf(rename_test.getName()) + ".bak");
                        target.delete();
                        rename_test.renameTo(target);
                        if (rename_test.exists()) {
                        }
                        target.renameTo(rename_test);
                        break block16;
                    }
                    Debug.out("Failed to find a suitable file for the rename test");
                }
                finally {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean canWriteToDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            File temp = AETemporaryFileHandler.createTempFileInDir(dir);
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void log(String str) {
        FileUtil.log(str, null);
    }

    public static void log(String str, boolean addLocation) {
        if (addLocation) {
            str = String.valueOf(str) + ": " + Debug.getStackTrace(true, false);
        }
        FileUtil.log(str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String str, Throwable error) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (file_logger == null) {
                file_logger = AEDiagnostics.getLogger("DiskOps");
                file_logger.enableTimeStamp(true);
                file_logger.setForced(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            file_logger.log(str);
            if (error != null) {
                file_logger.log(error);
            }
            return;
        }
    }

    public static String removeTrailingSeparators(String str) {
        int min_length = 1;
        if (Constants.isWindows && str.length() > 2 && str.charAt(1) == ':') {
            min_length = 3;
        }
        while (str.endsWith(File.separator) && str.length() > min_length) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptCharsetEncoding() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            String jvm_encoding;
            String file_encoding;
            block8: {
                if (sce_checked) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return script_encoding;
                }
                sce_checked = true;
                file_encoding = System.getProperty("file.encoding", null);
                jvm_encoding = System.getProperty("sun.jnu.encoding", null);
                if (file_encoding != null && jvm_encoding != null && !file_encoding.equals(jvm_encoding)) break block8;
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            try {
                String test_str = SystemProperties.getUserPath();
                if (!new String(test_str.getBytes(file_encoding), file_encoding).equals(test_str) && new String(test_str.getBytes(jvm_encoding), jvm_encoding).equals(test_str)) {
                    Debug.out("Script encoding determined to be " + jvm_encoding + " instead of " + file_encoding);
                    script_encoding = jvm_encoding;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return script_encoding;
        }
    }

    private static <T> T runFileOpWithTimeout(File file, FileOpWithTimeout<T> fo, T def, long strict_timeout) {
        try {
            return FileUtil.runFileOpWithTimeoutEx(file, fo, def, null, strict_timeout);
        }
        catch (Throwable e) {
            return def;
        }
    }

    private static <T> T runFileOpWithTimeoutEx(File file, FileOpWithTimeout<T> fo, IOException def_error, long strict_timeout) throws IOException {
        try {
            return FileUtil.runFileOpWithTimeoutEx(file, fo, null, def_error, strict_timeout);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw def_error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runFileOpWithTimeoutEx(File file, FileOpWithTimeout<T> fo, T def_result, IOException def_error, long strict_timeout) throws IOException {
        Map<Path, int[]> map = bad_roots;
        synchronized (map) {
            Path root_path;
            if (!bad_roots.isEmpty() && bad_roots.containsKey(root_path = file.toPath().getRoot())) {
                if (def_error == null) {
                    return def_result;
                }
                throw def_error;
            }
        }
        FileOpWithTimeout<Object> delegate = () -> {
            Object t;
            long start = SystemTime.getMonotonousTime();
            try {
                t = fo.run();
            }
            catch (Throwable throwable) {
                long elapsed = SystemTime.getMonotonousTime() - start;
                if (elapsed > 2500L) {
                    Path root_path = file.toPath().getRoot();
                    Map<Path, int[]> map = bad_roots;
                    synchronized (map) {
                        if (!bad_roots.containsKey(root_path)) {
                            if (bad_roots.size() > 1024) {
                                Debug.out("Bad roots size limit exceeded for " + root_path);
                            } else {
                                bad_roots.put(root_path, new int[1]);
                                if (bad_roots.size() == 1) {
                                    AEThread2.createAndStartDaemon("BadRootChecker", () -> {
                                        block18: while (true) {
                                            HashMap<Path, int[]> to_check;
                                            try {
                                                Thread.sleep(30000L);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            Map<Path, int[]> map = bad_roots;
                                            synchronized (map) {
                                                to_check = new HashMap<Path, int[]>(bad_roots);
                                            }
                                            Iterator iterator = to_check.entrySet().iterator();
                                            while (true) {
                                                if (!iterator.hasNext()) continue block18;
                                                Map.Entry entry = iterator.next();
                                                try {
                                                    long check_start = SystemTime.getMonotonousTime();
                                                    int limit = 250;
                                                    Path path = (Path)entry.getKey();
                                                    int[] oks = (int[])entry.getValue();
                                                    File check_file = path.toFile();
                                                    int i = 0;
                                                    block20: while (true) {
                                                        switch (i) {
                                                            case 0: {
                                                                check_file.getCanonicalPath();
                                                                break;
                                                            }
                                                            case 1: {
                                                                check_file.exists();
                                                                break;
                                                            }
                                                            case 2: {
                                                                check_file.length();
                                                                break;
                                                            }
                                                            case 3: {
                                                                check_file.isDirectory();
                                                                break;
                                                            }
                                                            case 4: {
                                                                File random_file = new File(check_file, "Test" + RandomUtils.nextAbsoluteLong() + ".dat");
                                                                if (!random_file.isFile()) break;
                                                                Thread.sleep(limit);
                                                                break;
                                                            }
                                                            case 5: {
                                                                check_file.listFiles();
                                                                break;
                                                            }
                                                            default: {
                                                                break block20;
                                                            }
                                                        }
                                                        if (SystemTime.getMonotonousTime() - check_start >= (long)limit) break;
                                                        ++i;
                                                    }
                                                    if (SystemTime.getMonotonousTime() - check_start < (long)limit) {
                                                        oks[0] = oks[0] + 1;
                                                        if (oks[0] <= 2) continue;
                                                        Debug.out("Root path " + path + " appears to be responding in a timely manner, enabling");
                                                        Map<Path, int[]> map2 = bad_roots;
                                                        synchronized (map2) {
                                                            bad_roots.remove(path);
                                                            if (bad_roots.isEmpty()) {
                                                                return;
                                                            }
                                                            continue;
                                                        }
                                                    }
                                                    oks[0] = 0;
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                            }
                                            break;
                                        }
                                    });
                                }
                                Debug.out("Root path " + root_path + " isn't responding in a timely manner, disabling");
                            }
                        }
                    }
                }
                throw throwable;
            }
            long elapsed = SystemTime.getMonotonousTime() - start;
            if (elapsed > 2500L) {
                Path root_path = file.toPath().getRoot();
                Map<Path, int[]> map = bad_roots;
                synchronized (map) {
                    if (!bad_roots.containsKey(root_path)) {
                        if (bad_roots.size() > 1024) {
                            Debug.out("Bad roots size limit exceeded for " + root_path);
                        } else {
                            bad_roots.put(root_path, new int[1]);
                            if (bad_roots.size() == 1) {
                                AEThread2.createAndStartDaemon("BadRootChecker", () -> {
                                    block18: while (true) {
                                        HashMap<Path, int[]> to_check;
                                        try {
                                            Thread.sleep(30000L);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        Map<Path, int[]> map = bad_roots;
                                        synchronized (map) {
                                            to_check = new HashMap<Path, int[]>(bad_roots);
                                        }
                                        Iterator iterator = to_check.entrySet().iterator();
                                        while (true) {
                                            if (!iterator.hasNext()) continue block18;
                                            Map.Entry entry = iterator.next();
                                            try {
                                                long check_start = SystemTime.getMonotonousTime();
                                                int limit = 250;
                                                Path path = (Path)entry.getKey();
                                                int[] oks = (int[])entry.getValue();
                                                File check_file = path.toFile();
                                                int i = 0;
                                                block20: while (true) {
                                                    switch (i) {
                                                        case 0: {
                                                            check_file.getCanonicalPath();
                                                            break;
                                                        }
                                                        case 1: {
                                                            check_file.exists();
                                                            break;
                                                        }
                                                        case 2: {
                                                            check_file.length();
                                                            break;
                                                        }
                                                        case 3: {
                                                            check_file.isDirectory();
                                                            break;
                                                        }
                                                        case 4: {
                                                            File random_file = new File(check_file, "Test" + RandomUtils.nextAbsoluteLong() + ".dat");
                                                            if (!random_file.isFile()) break;
                                                            Thread.sleep(limit);
                                                            break;
                                                        }
                                                        case 5: {
                                                            check_file.listFiles();
                                                            break;
                                                        }
                                                        default: {
                                                            break block20;
                                                        }
                                                    }
                                                    if (SystemTime.getMonotonousTime() - check_start >= (long)limit) break;
                                                    ++i;
                                                }
                                                if (SystemTime.getMonotonousTime() - check_start < (long)limit) {
                                                    oks[0] = oks[0] + 1;
                                                    if (oks[0] <= 2) continue;
                                                    Debug.out("Root path " + path + " appears to be responding in a timely manner, enabling");
                                                    Map<Path, int[]> map2 = bad_roots;
                                                    synchronized (map2) {
                                                        bad_roots.remove(path);
                                                        if (bad_roots.isEmpty()) {
                                                            return;
                                                        }
                                                        continue;
                                                    }
                                                }
                                                oks[0] = 0;
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        break;
                                    }
                                });
                            }
                            Debug.out("Root path " + root_path + " isn't responding in a timely manner, disabling");
                        }
                    }
                }
            }
            return t;
        };
        if (strict_timeout == -1L) {
            return (T)delegate.run();
        }
        AESemaphore sem = new AESemaphore("FOT");
        Object[] result = new Object[1];
        fot_dispatcher.dispatch(() -> {
            try {
                try {
                    Object r = delegate.run();
                    Object[] objectArray2 = result;
                    synchronized (result) {
                        objectArray[0] = r;
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return;
                    }
                }
                catch (IOException e) {
                    Object[] objectArray3 = result;
                    synchronized (result) {
                        objectArray[0] = e;
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        sem.release();
                        return;
                    }
                }
            }
            finally {
                sem.release();
            }
        });
        if (sem.reserve(strict_timeout)) {
            Object[] objectArray = result;
            synchronized (result) {
                Object r = result[0];
                if (r instanceof IOException) {
                    throw (IOException)r;
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return (T)r;
            }
        }
        return def_result;
    }

    public static long lengthWithTimeout(File file) {
        return FileUtil.lengthWithTimeout(file, -1L);
    }

    public static long lengthWithTimeout(File file, long strict_timeout) {
        return FileUtil.runFileOpWithTimeout(file, () -> file.length(), 0L, strict_timeout);
    }

    public static boolean canReadWithTimeout(File file) {
        return FileUtil.canReadWithTimeout(file, -1L);
    }

    public static boolean canReadWithTimeout(File file, long strict_timeout) {
        return FileUtil.runFileOpWithTimeout(file, () -> file.canRead(), false, strict_timeout);
    }

    public static boolean isDirectoryWithTimeout(File file) {
        return FileUtil.isDirectoryWithTimeout(file, -1L);
    }

    public static boolean isDirectoryWithTimeout(File file, long strict_timeout) {
        return FileUtil.runFileOpWithTimeout(file, () -> file.isDirectory(), false, strict_timeout);
    }

    public static boolean existsWithTimeout(File file) {
        return FileUtil.existsWithTimeout(file, -1L);
    }

    public static boolean existsWithTimeout(File file, long strict_timeout) {
        return FileUtil.runFileOpWithTimeout(file, () -> file.exists(), false, strict_timeout);
    }

    private static boolean existsWithTimeoutAndException(File file, long strict_timeout) throws IOException {
        return FileUtil.runFileOpWithTimeoutEx(file, () -> file.exists(), new IOException("File system not responding/slow"), strict_timeout);
    }

    public static boolean isResponding(File file, long strict_timeout) {
        try {
            long st = strict_timeout <= 1L ? strict_timeout : strict_timeout / 2L;
            FileUtil.getCanonicalPathWithTimeout(file, st);
            FileUtil.existsWithTimeoutAndException(file, st);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getCanonicalPathWithTimeout(File file) throws IOException {
        return FileUtil.getCanonicalPathWithTimeout(file, -1L);
    }

    public static String getCanonicalPathWithTimeout(File file, long strict_timeout) throws IOException {
        return FileUtil.runFileOpWithTimeoutEx(file, () -> file.getCanonicalPath(), new IOException("File system not responding/slow"), strict_timeout);
    }

    public static File[] listRootsWithTimeout() {
        return FileUtil.listRootsWithTimeout(250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] listRootsWithTimeout(long timeout) {
        AESemaphore sem;
        long now = SystemTime.getMonotonousTime();
        AsyncDispatcher asyncDispatcher = root_updater;
        synchronized (asyncDispatcher) {
            if (last_roots_time != -1L && now - last_roots_time < 10000L) {
                return last_roots;
            }
            sem = root_update_sem;
            if (sem == null) {
                last_roots_time = now;
                sem = root_update_sem = new AESemaphore("RootUpdate");
                root_updater.dispatch(() -> {
                    try {
                        File[] roots = File.listRoots();
                        if (roots != null) {
                            last_roots = roots;
                        }
                    }
                    catch (Throwable throwable) {
                        AsyncDispatcher asyncDispatcher = root_updater;
                        synchronized (asyncDispatcher) {
                            root_update_sem.releaseForever();
                            root_update_sem = null;
                        }
                        throw throwable;
                    }
                    AsyncDispatcher asyncDispatcher = root_updater;
                    synchronized (asyncDispatcher) {
                        root_update_sem.releaseForever();
                        root_update_sem = null;
                    }
                });
            }
        }
        sem.reserve(timeout);
        return last_roots;
    }

    public static File newFile(String parent, String ... subDirs) {
        return fileHandling.newFile(parent, subDirs);
    }

    public static File newFile(File parent_file, String ... subDirs) {
        return fileHandling.newFile(parent_file, subDirs);
    }

    public static File newFile(URI uri) {
        return fileHandling.newFile(uri);
    }

    public static FMFileAccess.FileAccessor newFileAccessor(File file, String access_mode) throws FileNotFoundException {
        return fileHandling.newFileAccessor(file, access_mode);
    }

    public static boolean containsPathSegment(File f, String path, boolean caseSensitive) {
        return fileHandling.containsPathSegment(f, path, caseSensitive);
    }

    public static String getRelativePath(File parentDir, File file) {
        return fileHandling.getRelativePath(parentDir, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$2(String[] var0) {
        block25: {
            block24: {
                block26: {
                    new_result = new String[]{};
                    try {
                        try {
                            fs = FileUtil.fileHandling.getFileStores();
                            new_result = new String[fs.size()];
                            pos = 0;
                            for (Object f : fs) {
                                new_result[pos++] = String.valueOf(f);
                            }
                            break block24;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            var8_7 = FileUtil.fs_names_lock;
                            synchronized (var8_7) {
                                FileUtil.fs_names = new_result;
                                FileUtil.fs_names_last = SystemTime.getMonotonousTime();
                                callbacks = FileUtil.fs_pending_callbacks;
                                FileUtil.fs_pending_callbacks = new ArrayList<Consumer<String[]>>();
                                FileUtil.fs_updating = false;
                            }
                            if (var0 != null && Arrays.deepEquals(var0, new_result)) break block25;
                            ** for (cb : callbacks)
                        }
                    }
                    catch (Throwable var6_19) {
                        cb = FileUtil.fs_names_lock;
                        synchronized (cb) {
                            FileUtil.fs_names = new_result;
                            FileUtil.fs_names_last = SystemTime.getMonotonousTime();
                            callbacks = FileUtil.fs_pending_callbacks;
                            FileUtil.fs_pending_callbacks = new ArrayList<Consumer<String[]>>();
                            FileUtil.fs_updating = false;
                        }
                        if (var0 != null && Arrays.deepEquals(var0, new_result)) break block26;
                        ** for (cb : callbacks)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            cb.accept((String[])new_result);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        continue;
lbl32:
                        // 1 sources

                        break block25;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            cb.accept((String[])new_result);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        continue;
                    }
                }
                throw var6_19;
            }
            cb = FileUtil.fs_names_lock;
            synchronized (cb) {
                FileUtil.fs_names = new_result;
                FileUtil.fs_names_last = SystemTime.getMonotonousTime();
                callbacks = FileUtil.fs_pending_callbacks;
                FileUtil.fs_pending_callbacks = new ArrayList<Consumer<String[]>>();
                FileUtil.fs_updating = false;
            }
            if (var0 == null || !Arrays.deepEquals(var0, new_result)) {
                for (Consumer<String[]> cb : callbacks) {
                    try {
                        cb.accept((String[])new_result);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    public static class FileHack
    extends File {
        private static final String hack_target = "C:\\Temp\\ContentStore";
        private static final String hack_prefix = "content://";
        private final String path;
        private final File target;

        private FileHack(String _path) {
            super(Base32.encode(_path.getBytes(Constants.UTF_8)));
            this.path = _path;
            this.target = new File(hack_target, this.path.substring(hack_prefix.length()));
        }

        private FileHack(FileHack path, String subPath) {
            this(new File(path.toString(), subPath.startsWith(DIR_SEP) ? subPath.substring(1) : subPath).toString());
        }

        public File getHackTarget() {
            return this.target;
        }

        @Override
        public File getAbsoluteFile() {
            return this;
        }

        @Override
        public String getAbsolutePath() {
            return this.path;
        }

        @Override
        public boolean exists() {
            return this.target.exists();
        }

        @Override
        public String getName() {
            int pos;
            String temp = this.path;
            if (temp.endsWith(DIR_SEP)) {
                temp = temp.substring(0, temp.length() - 1);
            }
            if ((pos = temp.lastIndexOf(DIR_SEP)) == -1) {
                return "";
            }
            return temp.substring(pos + 1);
        }

        @Override
        public String getParent() {
            return this.getParentFile().getAbsolutePath();
        }

        @Override
        public File getParentFile() {
            int pos;
            String temp = this.path;
            if (temp.endsWith(DIR_SEP)) {
                temp = temp.substring(0, temp.length() - 1);
            }
            if ((pos = temp.lastIndexOf(DIR_SEP)) == -1) {
                return null;
            }
            return new FileHack(temp.substring(0, pos + 1));
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isFile() {
            return this.target.isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.target.isDirectory();
        }

        @Override
        public int compareTo(File other) {
            if (other instanceof FileHack) {
                return this.path.compareTo(((FileHack)other).path);
            }
            return -1;
        }

        @Override
        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof FileHack) {
                return this.path.equals(((FileHack)other).path);
            }
            return false;
        }

        @Override
        public boolean createNewFile() throws IOException {
            return this.target.createNewFile();
        }

        @Override
        public boolean delete() {
            return this.target.delete();
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return this;
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.path;
        }

        @Override
        public long lastModified() {
            return this.target.lastModified();
        }

        @Override
        public String[] list() {
            File[] files = this.listFiles();
            if (files != null) {
                String[] result = new String[files.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = files[i].getAbsolutePath();
                    ++i;
                }
                return result;
            }
            return null;
        }

        @Override
        public long length() {
            return this.target.length();
        }

        @Override
        public File[] listFiles() {
            File[] files = this.target.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    files[i] = new FileHack(hack_prefix + files[i].getAbsolutePath().substring(hack_target.length() + 1));
                    ++i;
                }
            }
            return files;
        }

        @Override
        public boolean mkdir() {
            return this.target.mkdir();
        }

        @Override
        public boolean mkdirs() {
            return this.target.mkdirs();
        }

        @Override
        public String toString() {
            return this.path;
        }

        @Override
        public boolean canExecute() {
            Debug.out("!");
            return super.canExecute();
        }

        @Override
        public boolean canRead() {
            Debug.out("!");
            return super.canRead();
        }

        @Override
        public boolean canWrite() {
            Debug.out("!");
            return super.canWrite();
        }

        @Override
        public void deleteOnExit() {
            Debug.out("!");
            super.deleteOnExit();
        }

        @Override
        public long getFreeSpace() {
            Debug.out("!");
            return super.getFreeSpace();
        }

        @Override
        public long getTotalSpace() {
            Debug.out("!");
            return super.getTotalSpace();
        }

        @Override
        public long getUsableSpace() {
            Debug.out("!");
            return super.getUsableSpace();
        }

        @Override
        public boolean isAbsolute() {
            Debug.out("!");
            return super.isAbsolute();
        }

        @Override
        public boolean isHidden() {
            Debug.out("!");
            return super.isHidden();
        }

        @Override
        public String[] list(FilenameFilter filter2) {
            Debug.out("!");
            return super.list(filter2);
        }

        @Override
        public File[] listFiles(FileFilter filter2) {
            Debug.out("!");
            return super.listFiles(filter2);
        }

        @Override
        public File[] listFiles(FilenameFilter filter2) {
            Debug.out("!");
            return super.listFiles(filter2);
        }

        @Override
        public boolean renameTo(File dest) {
            Debug.out("!");
            return super.renameTo(dest);
        }

        @Override
        public boolean setExecutable(boolean executable) {
            Debug.out("!");
            return super.setExecutable(executable);
        }

        @Override
        public boolean setExecutable(boolean executable, boolean ownerOnly) {
            Debug.out("!");
            return super.setExecutable(executable, ownerOnly);
        }

        @Override
        public boolean setLastModified(long time) {
            Debug.out("!");
            return super.setLastModified(time);
        }

        @Override
        public boolean setReadable(boolean readable) {
            Debug.out("!");
            return super.setReadable(readable);
        }

        @Override
        public boolean setReadable(boolean readable, boolean ownerOnly) {
            Debug.out("!");
            return super.setReadable(readable, ownerOnly);
        }

        @Override
        public boolean setReadOnly() {
            Debug.out("!");
            return super.setReadOnly();
        }

        @Override
        public boolean setWritable(boolean writable) {
            Debug.out("!");
            return super.setWritable(writable);
        }

        @Override
        public boolean setWritable(boolean writable, boolean ownerOnly) {
            Debug.out("!");
            return super.setWritable(writable, ownerOnly);
        }

        @Override
        public Path toPath() {
            Debug.out("!");
            return super.toPath();
        }

        @Override
        public URI toURI() {
            Debug.out("!");
            return super.toURI();
        }

        @Override
        public URL toURL() throws MalformedURLException {
            Debug.out("!");
            return super.toURI().toURL();
        }
    }

    public static class FileHandlerHack
    extends FileHandler {
        @Override
        public File newFile(File parent, String ... subDirs) {
            if (!(parent instanceof FileHack)) {
                return super.newFile(parent, subDirs);
            }
            if (subDirs == null || subDirs.length == 0) {
                return parent;
            }
            FileHack file = new FileHack((FileHack)parent, subDirs[0]);
            int i = 1;
            int subDirsLength = subDirs.length;
            while (i < subDirsLength) {
                file = new FileHack(file, subDirs[i]);
                ++i;
            }
            return file;
        }

        @Override
        public File newFile(String parent, String ... subDirs) {
            if (parent != null && !parent.startsWith("content://")) {
                return super.newFile(parent, subDirs);
            }
            FileHack fileHack = new FileHack(parent);
            if (subDirs == null || subDirs.length == 0) {
                return fileHack;
            }
            FileHack file = new FileHack(fileHack, subDirs[0]);
            int i = 1;
            int subDirsLength = subDirs.length;
            while (i < subDirsLength) {
                file = new FileHack(file, subDirs[i]);
                ++i;
            }
            return file;
        }

        @Override
        public File getCanonicalFileSafe(File file) {
            if (file instanceof FileHack) {
                return file.getAbsoluteFile();
            }
            return super.getCanonicalFileSafe(file);
        }

        @Override
        public String getCanonicalPathSafe(File file) {
            try {
                if (file instanceof FileHack) {
                    return file.getCanonicalPath();
                }
            }
            catch (Throwable e) {
                return file.getAbsolutePath();
            }
            return super.getCanonicalPathSafe(file);
        }

        @Override
        public boolean isAncestorOf(File _parent, File _child) {
            if (_parent instanceof FileHack && _child instanceof FileHack) {
                return this.getRelativePath(_parent, _child) != null;
            }
            return super.isAncestorOf(_parent, _child);
        }

        @Override
        public FMFileAccess.FileAccessor newFileAccessor(File file, String access_mode) throws FileNotFoundException {
            if (file instanceof FileHack) {
                file = ((FileHack)file).getHackTarget();
            }
            return super.newFileAccessor(file, access_mode);
        }
    }

    static interface FileOpWithTimeout<T> {
        public T run() throws IOException;
    }

    public static interface ProgressListener {
        public static final int ST_NORMAL = 1;
        public static final int ST_PAUSED = 2;
        public static final int ST_CANCELLED = 3;

        public void setTotalSize(long var1);

        public void setCurrentFile(File var1);

        public void bytesDone(long var1);

        public int getState();

        public void complete();
    }
}

