/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.BEncodableObject;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.StringInterner;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LinkFileMap
implements BEncodableObject {
    private static final boolean STORE_FROM_KEY = true;
    private final IndexResolver resolver;
    private final Map<Integer, Entry> index_map = new ConcurrentHashMap<Integer, Entry>();

    public LinkFileMap(IndexResolver _resolver) {
        this.resolver = _resolver;
    }

    public File get(int index) {
        if (index >= 0) {
            Entry entry = this.index_map.get(index);
            if (entry != null) {
                StringInterner.FileKey to_fk = entry.getToFile();
                return to_fk == null ? null : to_fk.getFile();
            }
        } else {
            Debug.out("unexpected index: " + index);
        }
        return null;
    }

    public Entry getEntry(int index) {
        if (index >= 0) {
            Entry entry = this.index_map.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            Debug.out("unexpected index");
        }
        return null;
    }

    public void put(int index, StringInterner.FileKey from_fk_maybe_null, StringInterner.FileKey to_fk) {
        if (to_fk == null || from_fk_maybe_null != null && from_fk_maybe_null.equals(to_fk)) {
            this.index_map.remove(index);
        } else {
            Entry entry = new Entry(index, from_fk_maybe_null, to_fk);
            if (index >= 0) {
                this.index_map.put(index, entry);
            } else {
                Debug.out("unexpected index");
            }
        }
    }

    public void clear() {
        this.index_map.clear();
    }

    public Iterator<Entry> entryIterator() {
        return this.index_map.values().iterator();
    }

    public int size() {
        return this.index_map.size();
    }

    @Override
    public Object toBencodeObject() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Entry> it = this.entryIterator();
        while (it.hasNext()) {
            Entry entry = it.next();
            int index = entry.getIndex();
            StringInterner.FileKey source_maybe_null = entry.getFromFileMaybeNull();
            StringInterner.FileKey target = entry.getToFile();
            StringBuilder str = new StringBuilder(512);
            str.append(index);
            str.append("\n");
            if (source_maybe_null != null) {
                str.append(source_maybe_null.toString());
            }
            str.append("\n");
            str.append(target.toString());
            list.add(str.toString());
        }
        return list;
    }

    public void fromBencodeObject(List<String> list) {
        int i = 0;
        while (i < list.size()) {
            String entry = list.get(i);
            String[] bits = entry.split("\n");
            if (bits.length >= 2) {
                try {
                    StringInterner.FileKey target;
                    StringInterner.FileKey source_maybe_null;
                    int index = Integer.parseInt(bits[0].trim());
                    String from_str = bits[1];
                    StringInterner.FileKey fileKey = source_maybe_null = from_str.isEmpty() ? null : new StringInterner.FileKey(from_str);
                    if (bits.length < 3) {
                        target = null;
                    } else {
                        String to_str = bits[2];
                        target = new StringInterner.FileKey(to_str);
                    }
                    if (index >= 0) {
                        this.put(index, source_maybe_null, target);
                    } else {
                        if (this.resolver != null && (index = this.resolver.resolveFile(from_str)) >= 0) {
                            this.put(index, source_maybe_null, target);
                        }
                        if (index < 0) {
                            Debug.out("unexpected index");
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            ++i;
        }
    }

    public String getString() {
        String str = "";
        if (this.index_map.size() > 0) {
            String i_str = "";
            for (Entry e : this.index_map.values()) {
                i_str = String.valueOf(i_str) + (i_str.length() == 0 ? "" : ", ") + e.getString();
            }
            str = String.valueOf(str) + "i_map={ " + i_str + " }";
        }
        return str;
    }

    public static class Entry {
        private final int index;
        private final StringInterner.FileKey from_file_maybe_null;
        private final StringInterner.FileKey to_file;

        private Entry(int _index, StringInterner.FileKey _from_file_maybe_null, StringInterner.FileKey _to_file) {
            this.index = _index;
            this.from_file_maybe_null = _from_file_maybe_null;
            this.to_file = _to_file;
        }

        public int getIndex() {
            return this.index;
        }

        public StringInterner.FileKey getFromFileMaybeNull() {
            return this.from_file_maybe_null;
        }

        public StringInterner.FileKey getToFile() {
            return this.to_file;
        }

        public String getString() {
            return String.valueOf(this.index) + ": " + this.from_file_maybe_null + " -> " + this.to_file;
        }
    }

    public static interface IndexResolver {
        public int resolveFile(String var1);
    }
}

