/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NetUtils {
    private static final int MIN_NI_CHECK_MILLIS = 30000;
    private static final int INC1_NI_CHECK_MILLIS = 120000;
    private static final int INC2_NI_CHECK_MILLIS = 900000;
    private static int current_check_millis = 30000;
    private static long last_ni_check = -1L;
    private static volatile List<NetworkInterface> current_all_interfaces = new ArrayList<NetworkInterface>();
    private static volatile List<NetworkInterface> current_up_interfaces = new ArrayList<NetworkInterface>();
    private static boolean first_check = true;
    private static boolean check_in_progress;
    static final AESemaphore ni_sem;
    private static final Map<Object, Object[]> host_or_address_map;
    private static final Object RESULT_NULL;

    static {
        ni_sem = new AESemaphore("NetUtils:ni");
        host_or_address_map = new HashMap<Object, Object[]>();
        RESULT_NULL = new Object();
    }

    public static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return NetUtils.getNetworkInterfaces(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NetworkInterface> getNetworkInterfaces(boolean up_only) throws SocketException {
        long now = SystemTime.getMonotonousTime();
        boolean do_check = false;
        boolean is_first = false;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (!(check_in_progress || last_ni_check >= 0L && now - last_ni_check <= (long)current_check_millis)) {
                do_check = true;
                check_in_progress = true;
                if (first_check) {
                    first_check = false;
                    is_first = true;
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (do_check) {
                final UtilitiesImpl.runnableWithException<SocketException> do_it = new UtilitiesImpl.runnableWithException<SocketException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws SocketException {
                        ArrayList<NetworkInterface> result_up;
                        ArrayList<NetworkInterface> result_all;
                        block34: {
                            result_all = new ArrayList<NetworkInterface>();
                            result_up = new ArrayList<NetworkInterface>();
                            try {
                                long start = SystemTime.getHighPrecisionCounter();
                                Enumeration nis = NetUtils.NetworkInterface_getNetworkInterfaces();
                                long elapsed_millis = (SystemTime.getHighPrecisionCounter() - start) / 1000000L;
                                if (elapsed_millis > (long)(Constants.isAndroid ? 5000 : 1000)) {
                                    current_check_millis = 900000;
                                } else if (elapsed_millis > (long)(Constants.isAndroid ? 1000 : 250)) {
                                    current_check_millis = 120000;
                                } else {
                                    current_check_millis = 30000;
                                }
                                if (nis != null) {
                                    while (nis.hasMoreElements()) {
                                        NetworkInterface ni = (NetworkInterface)nis.nextElement();
                                        result_all.add(ni);
                                        try {
                                            if (!ni.isUp()) continue;
                                            result_up.add(ni);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                }
                                break block34;
                            }
                            catch (Throwable throwable) {
                                try {
                                    Class<NetUtils> clazz = NetUtils.class;
                                    synchronized (NetUtils.class) {
                                        boolean changed;
                                        boolean bl = changed = result_all.size() != current_all_interfaces.size();
                                        if (!changed) {
                                            int i = 0;
                                            while (i < result_all.size()) {
                                                if (!((NetworkInterface)result_all.get(i)).equals(current_all_interfaces.get(i))) {
                                                    changed = true;
                                                    break;
                                                }
                                                ++i;
                                            }
                                        }
                                        check_in_progress = false;
                                        current_all_interfaces = result_all;
                                        current_up_interfaces = result_up;
                                        last_ni_check = SystemTime.getMonotonousTime();
                                        try {
                                            changed = SESecurityManager.filterNetworkInterfaces(result_all);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                        if (changed) {
                                            host_or_address_map.clear();
                                        }
                                        // ** MonitorExit[var11_9] (shouldn't be in output)
                                    }
                                }
                                finally {
                                    ni_sem.releaseForever();
                                }
                            }
                            {
                                throw throwable;
                            }
                        }
                        try {
                            Class<NetUtils> clazz = NetUtils.class;
                            synchronized (NetUtils.class) {
                                boolean changed;
                                boolean bl = changed = result_all.size() != current_all_interfaces.size();
                                if (!changed) {
                                    int i = 0;
                                    while (i < result_all.size()) {
                                        if (!((NetworkInterface)result_all.get(i)).equals(current_all_interfaces.get(i))) {
                                            changed = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                check_in_progress = false;
                                current_all_interfaces = result_all;
                                current_up_interfaces = result_up;
                                last_ni_check = SystemTime.getMonotonousTime();
                                try {
                                    changed = SESecurityManager.filterNetworkInterfaces(result_all);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                if (changed) {
                                    host_or_address_map.clear();
                                }
                                // ** MonitorExit[var11_10] (shouldn't be in output)
                            }
                        }
                        finally {
                            ni_sem.releaseForever();
                        }
                        {
                            return;
                        }
                    }
                };
                if (is_first) {
                    final AESemaphore do_it_sem = new AESemaphore("getNIs");
                    final SocketException[] error = new SocketException[1];
                    new AEThread2("getNIAsync"){

                        @Override
                        public void run() {
                            try {
                                try {
                                    do_it.run();
                                }
                                catch (SocketException e) {
                                    error[0] = e;
                                    do_it_sem.release();
                                }
                                catch (Throwable e) {
                                    error[0] = new SocketException(Debug.getNestedExceptionMessage(e));
                                    do_it_sem.release();
                                }
                            }
                            finally {
                                do_it_sem.release();
                            }
                        }
                    }.start();
                    if (!do_it_sem.reserve(15000L)) {
                        Debug.out("Timeout obtaining network interfaces");
                        ni_sem.releaseForever();
                    } else if (error[0] != null) {
                        throw error[0];
                    }
                } else {
                    do_it.run();
                }
            }
            ni_sem.reserve();
            return up_only ? current_up_interfaces : current_all_interfaces;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            try {
                List<NetworkInterface> nis = NetUtils.getNetworkInterfaces();
                for (NetworkInterface ni : nis) {
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                        return address;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return InetAddress.getByName("127.0.0.1");
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        return NetUtils.getBySupport(name);
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        return NetUtils.getBySupport(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NetworkInterface getBySupport(Object name_or_address) throws SocketException {
        Object[] objectArray = NetUtils.class;
        synchronized (NetUtils.class) {
            Object[] entry = host_or_address_map.get(name_or_address);
            if (entry != null) {
                Object[] objectArray2 = entry;
                synchronized (entry) {
                    long now = SystemTime.getMonotonousTime();
                    Object result_or_error = entry[0];
                    if (result_or_error != null) {
                        if ((Long)entry[1] > now) {
                            if (result_or_error == RESULT_NULL) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                // ** MonitorExit[var2_1] (shouldn't be in output)
                                return null;
                            }
                            if (result_or_error instanceof NetworkInterface) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                // ** MonitorExit[var2_1] (shouldn't be in output)
                                return (NetworkInterface)result_or_error;
                            }
                            throw (SocketException)result_or_error;
                        }
                        entry[0] = null;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            } else {
                entry = new Object[2];
                host_or_address_map.put(name_or_address, entry);
            }
            {
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
            {
                objectArray = entry;
                synchronized (entry) {
                    Object result_or_error = entry[0];
                    if (result_or_error != null) {
                        if (result_or_error == RESULT_NULL) {
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return null;
                        }
                        if (result_or_error instanceof NetworkInterface) {
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return (NetworkInterface)result_or_error;
                        }
                        throw (SocketException)result_or_error;
                    }
                    long start = SystemTime.getHighPrecisionCounter();
                    Object result = null;
                    SocketException error = null;
                    try {
                        block36: {
                            block35: {
                                if (!(name_or_address instanceof String)) break block35;
                                String name = (String)name_or_address;
                                if (name.startsWith("(") && name.endsWith(")")) {
                                    String expr = name.substring(1, name.length() - 1);
                                    boolean failed = false;
                                    try {
                                        Pattern p = RegExUtil.getCachedPattern("NetUtils:display", expr, 66);
                                        List<NetworkInterface> ifs = current_all_interfaces;
                                        if (ifs != null) {
                                            NetworkInterface best = null;
                                            boolean best_has_ias = false;
                                            for (NetworkInterface x : ifs) {
                                                String dn = x.getDisplayName();
                                                if (dn == null || !p.matcher(dn).find()) continue;
                                                boolean has_ias = false;
                                                Enumeration<InetAddress> ias = x.getInetAddresses();
                                                while (ias.hasMoreElements()) {
                                                    InetAddress ia = ias.nextElement();
                                                    if (ia instanceof Inet4Address) {
                                                        has_ias = true;
                                                        break;
                                                    }
                                                    if (!AddressUtils.isGlobalAddressV6(ia)) continue;
                                                    has_ias = true;
                                                    break;
                                                }
                                                if (best == null) {
                                                    best = x;
                                                    best_has_ias = has_ias;
                                                    continue;
                                                }
                                                if (!has_ias) continue;
                                                if (best_has_ias) {
                                                    best = null;
                                                    Debug.out("Multiple network interface matches for regex " + expr);
                                                    failed = true;
                                                    break;
                                                }
                                                best = x;
                                                best_has_ias = has_ias;
                                            }
                                            result = best;
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out("Invalid network interface pattern: " + expr, e);
                                        failed = true;
                                    }
                                    if (result == null) {
                                        // empty if block
                                    }
                                    break block36;
                                } else {
                                    result = NetworkInterface.getByName(name);
                                }
                                break block36;
                            }
                            result = NetworkInterface.getByInetAddress((InetAddress)name_or_address);
                        }
                        if (result == null) {
                            result = RESULT_NULL;
                        }
                    }
                    catch (SocketException e) {
                        error = e;
                    }
                    long elapsed = (SystemTime.getHighPrecisionCounter() - start) / 1000000L;
                    entry[0] = result == null ? error : result;
                    long delay = 250L * elapsed;
                    if (delay > 300000L) {
                        delay = 300000L;
                    }
                    entry[1] = SystemTime.getMonotonousTime() + delay;
                    if (error != null) {
                        throw error;
                    }
                    if (result == RESULT_NULL) {
                        // ** MonitorExit[var2_1] (shouldn't be in output)
                        return null;
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return (NetworkInterface)result;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Enumeration<NetworkInterface> NetworkInterface_getNetworkInterfaces() throws SocketException {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            se = e;
            try {
                mGetByIndex = NetworkInterface.class.getDeclaredMethod("getByIndex", new Class[]{Integer.TYPE});
                list = new ArrayList<NetworkInterface>();
                i = 0;
                while (true) {
                    nif = null;
                    try {
                        nif = (NetworkInterface)mGetByIndex.invoke(null, new Object[]{i});
                    }
                    catch (IllegalAccessException e) {
                        break;
                    }
                    catch (InvocationTargetException var5_9) {
                        // empty catch block
                    }
                    if (nif != null) {
                        list.add(nif);
                    } else if (i > 0) break;
                    ++i;
                }
                if (list.size() > 0) {
                    return Collections.enumeration(list);
                }
            }
            catch (NoSuchMethodException mGetByIndex) {
                // empty catch block
            }
            list = new ArrayList<NetworkInterface>();
            var6_13 = commonNames = new String[]{"lo", "eth", "lan", "wlan", "en", "p2p", "net", "ppp"};
            var5_12 = commonNames.length;
            var4_8 = 0;
            ** while (var4_8 < var5_12)
        }
lbl-1000:
        // 1 sources

        {
            commonName = var6_13[var4_8];
            try {
                nif = NetworkInterface.getByName(commonName);
                if (nif != null) {
                    list.add(nif);
                }
                i = 0;
                while ((nif = NetworkInterface.getByName(String.valueOf(commonName) + i)) != null) {
                    list.add(nif);
                    ++i;
                }
            }
            catch (Throwable var7_15) {
                // empty catch block
            }
            ++var4_8;
            continue;
        }
lbl52:
        // 1 sources

        if (list.size() > 0) {
            return Collections.enumeration(list);
        }
        throw se;
    }

    public static List<String> getTestDomains() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String[] bits;
            String domains = COConfigurationManager.getStringParameter("Connection.Test.Domain");
            String[] stringArray = bits = domains.split("[,;]");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if (!(bit = bit.trim()).isEmpty()) {
                    result.add(bit);
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return result;
    }
}

