/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;

public class RegExUtil {
    public static final Pattern PAT_SPLIT_COMMAWORDS = Pattern.compile("\\s*,\\s*");
    public static final Pattern PAT_SPLIT_COMMA = Pattern.compile(",");
    public static final Pattern PAT_SPLIT_DOT = Pattern.compile("\\.");
    public static final Pattern PAT_SPLIT_SPACE = Pattern.compile(" ");
    public static final Pattern PAT_SPLIT_SLASH_N = Pattern.compile("\n");
    public static final String PAT_WHITE_SPACE = "(?:\\s|\\p{Z})+";
    private static final ThreadLocal<Map<String, Object[]>> tls = new ThreadLocal<Map<String, Object[]>>(){

        @Override
        public Map<String, Object[]> initialValue() {
            return new HashMap<String, Object[]>();
        }
    };

    public static Pattern getCachedPattern(String namespace, String pattern) {
        return RegExUtil.getCachedPattern(namespace, pattern, 0);
    }

    public static Pattern getCachedPattern(String namespace, String pattern, int flags) {
        Map<String, Object[]> map = tls.get();
        Object[] entry = map.get(namespace);
        if (entry == null || !pattern.equals((String)entry[0])) {
            Pattern result = Pattern.compile(pattern, flags);
            map.put(namespace, new Object[]{pattern, result});
            return result;
        }
        return (Pattern)entry[1];
    }

    public static String convertAndOrToExpr(String str) {
        if ((str = str.replaceAll("\\s*[|;]\\s*", "|")).contains(" ")) {
            String[] bits = str.split(" ");
            String s = "";
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if (!(bit = bit.trim()).isEmpty()) {
                    bit = RegExUtil.splitAndQuote(bit, "[|]");
                    s = String.valueOf(s) + "(?=.*" + bit + ")";
                }
                ++n2;
            }
            return s;
        }
        return RegExUtil.splitAndQuote(str, "[|]");
    }

    public static String splitAndQuote(String s, String splitterRegex) {
        CharSequence[] bits = s.split(splitterRegex);
        int i = 0;
        while (i < bits.length) {
            bits[i] = Pattern.quote((String)bits[i]);
            ++i;
        }
        return String.join((CharSequence)"|", bits);
    }

    public static boolean mightBeEvil(String str) {
        if (!str.contains(")")) {
            return false;
        }
        char[] chars = str.toCharArray();
        Stack<Integer> stack = new Stack<Integer>();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '(') {
                stack.push(i + 1);
            } else if (c == ')') {
                char next;
                if (stack.isEmpty()) {
                    Debug.out("bracket un-matched in " + str + " - treating as evil");
                    return true;
                }
                int start = (Integer)stack.pop();
                if (i < chars.length - 1 && ((next = chars[i + 1]) == '*' || next == '+' || next == '{')) {
                    int j = start;
                    while (j < i) {
                        c = chars[j];
                        if ("+*{|".indexOf(c) != -1) {
                            Debug.out("regular expression " + str + " might be evil due to '" + str.substring(start - 1, i + 2) + "'");
                            return true;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return false;
    }
}

