/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashSet;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class StringInterner {
    public static boolean DISABLE_INTERNING = System.getProperty("stringinterner.disable", "0").equals("1");
    private static final int SCHEDULED_CLEANUP_INTERVAL = 60000;
    private static final boolean TRACE_CLEANUP = false;
    private static final boolean TRACE_MULTIHITS = false;
    private static final int IMMEDIATE_CLEANUP_TRIGGER = 10000;
    private static final int IMMEDIATE_CLEANUP_GOAL = 8000;
    private static final int SCHEDULED_CLEANUP_TRIGGER = 8000;
    private static final int SCHEDULED_CLEANUP_GOAL = 7000;
    private static final int SCHEDULED_AGING_THRESHOLD = 750;
    private static final LightHashSet managedInterningSet = new LightHashSet(800);
    static final ReadWriteLock managedSetLock = new ReentrantReadWriteLock();
    private static final ReferenceQueue managedRefQueue = new ReferenceQueue();
    private static final String[] COMMON_KEYS = new String[]{"src", "port", "prot", "ip", "udpport", "azver", "httpport", "downloaded", "Content", "path", "path.utf-8", "uploaded", "completed", "persistent", "attributes", "encoding", "azureus_properties", "stats.download.added.time", "networks", "p1", "resume data", "dndflags", "blocks", "resume", "primaryfile", "resumecomplete", "data", "peersources", "name", "name.utf-8", "valid", "torrent filename", "parameters", "secrets", "timesincedl", "tracker_cache", "filedownloaded", "timesinceul", "tracker_peers", "trackerclientextensions", "GlobalRating", "comment.utf-8", "Count", "String", "Thumbnail", "Plugin.<internal>.DDBaseTTTorrent::sha1", "type", "Title", "displayname", "flags", "stats.download.completed.time", "Description", "hash", "ver", "id", "body", "seed", "eip", "rid", "iip", "dp2", "tp", "orig", "dp", "private", "dht_backup_enable", "max.uploads", "filelinks", "sha1", "ed2k", "dht_backup_requested", "ta", "size", "dateadded", "bytesin", "announces", "status", "bytesout", "scrapes", "passive", "pre", "seq", "nick", "msg", "zo"};
    private static final Comparator savingsComp;
    private static final boolean TRACK_FILE_KEYS;
    private static final ReferenceQueue<FileKey> file_key_ref_queue;
    private static final Map<WeakReference<FileKey>, String> file_key_map;

    static {
        try {
            int i = 0;
            while (i < COMMON_KEYS.length) {
                managedInterningSet.add(new WeakStringEntry(COMMON_KEYS[i], true));
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        new AEThread2("asyncify", true){

            @Override
            public void run() {
                SimpleTimer.addPeriodicEvent("StringInterner:cleaner", 60000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        managedSetLock.writeLock().lock();
                        try {
                            StringInterner.sanitize(true);
                        }
                        finally {
                            managedSetLock.writeLock().unlock();
                        }
                    }
                });
            }
        }.start();
        savingsComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                WeakWeightedEntry w1 = (WeakWeightedEntry)o1;
                WeakWeightedEntry w2 = (WeakWeightedEntry)o2;
                return w1.hits * w1.size - w2.hits * w2.size;
            }
        };
        TRACK_FILE_KEYS = Constants.IS_CVS_VERSION;
        if (TRACK_FILE_KEYS) {
            file_key_ref_queue = new ReferenceQueue();
            file_key_map = new ConcurrentHashMap<WeakReference<FileKey>, String>();
            new AEThread2("StringInterner:FileKey"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                WeakReference next = (WeakReference)file_key_ref_queue.remove(0L);
                                file_key_map.remove(next);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        } else {
            file_key_ref_queue = null;
            file_key_map = null;
        }
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            @Override
            public void generate(IndentWriter writer) {
                writer.println("String Interner");
                try {
                    writer.indent();
                    writer.println("Managed: " + managedInterningSet.size());
                    if (TRACK_FILE_KEYS) {
                        int fk_count = 0;
                        long fk_total = 0L;
                        long fk_actual = 0L;
                        long fk_dups = 0L;
                        Iterator it = file_key_map.keySet().iterator();
                        IdentityHashSet<String> strings = new IdentityHashSet<String>();
                        HashSet<String> strings2 = new HashSet<String>();
                        while (it.hasNext()) {
                            FileKey fk = (FileKey)((WeakReference)it.next()).get();
                            if (fk == null) continue;
                            ++fk_count;
                            String[] comps = fk.comps;
                            int comp_num = fk.comps.length;
                            int i = fk.isFile() ? 1 : 0;
                            while (i < comp_num) {
                                String str = comps[i];
                                int len = str.length();
                                fk_total += (long)len;
                                if (!strings.contains(str)) {
                                    strings.add(str);
                                    fk_actual += (long)len;
                                    if (!strings2.contains(str)) {
                                        strings2.add(str);
                                    } else {
                                        fk_dups += (long)len;
                                    }
                                }
                                ++i;
                            }
                        }
                        writer.println("File Keys: num=" + fk_count + ", total=" + DisplayFormatters.formatByteCountToKiBEtc(fk_total) + ", dups=" + DisplayFormatters.formatByteCountToKiBEtc(fk_dups) + ", actual=" + DisplayFormatters.formatByteCountToKiBEtc(fk_actual));
                    }
                }
                finally {
                    writer.exdent();
                }
            }
        });
    }

    public static String intern(String toIntern) {
        String internedString;
        boolean hit;
        WeakStringEntry internedEntry;
        WeakStringEntry checkEntry;
        block12: {
            if (DISABLE_INTERNING) {
                return toIntern;
            }
            if (toIntern == null) {
                return null;
            }
            checkEntry = new WeakStringEntry(toIntern);
            internedEntry = null;
            hit = false;
            managedSetLock.readLock().lock();
            try {
                internedEntry = (WeakStringEntry)managedInterningSet.get(checkEntry);
                if (internedEntry != null && (internedString = internedEntry.getString()) != null) {
                    hit = true;
                    break block12;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakStringEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedString = internedEntry.getString()) != null) {
                        hit = true;
                    } else {
                        toIntern = new String(toIntern);
                        checkEntry = new WeakStringEntry(toIntern);
                        managedInterningSet.add(checkEntry);
                        internedString = toIntern;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        return internedString;
    }

    public static URL internURL(URL toIntern) {
        URL internedURL;
        boolean hit;
        WeakURLEntry internedEntry;
        WeakURLEntry checkEntry;
        block13: {
            if (DISABLE_INTERNING) {
                return toIntern;
            }
            if (toIntern == null) {
                return null;
            }
            checkEntry = new WeakURLEntry(toIntern);
            internedEntry = null;
            hit = false;
            managedSetLock.readLock().lock();
            try {
                internedEntry = (WeakURLEntry)managedInterningSet.get(checkEntry);
                if (internedEntry != null && (internedURL = internedEntry.getURL()) != null) {
                    hit = true;
                    break block13;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    internedEntry = (WeakURLEntry)managedInterningSet.get(checkEntry);
                    if (internedEntry != null && (internedURL = internedEntry.getURL()) != null) {
                        hit = true;
                    } else {
                        managedInterningSet.add(checkEntry);
                        internedURL = toIntern;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (hit) {
            internedEntry.incHits();
            checkEntry.destroy();
        }
        if (!toIntern.toExternalForm().equals(internedURL.toExternalForm())) {
            System.err.println("mismatch");
        }
        return internedURL;
    }

    /*
     * Unable to fully structure code
     */
    private static void sanitize(boolean scheduled) {
        block14: {
            while ((ref = (WeakWeightedEntry)StringInterner.managedRefQueue.poll()) != null) {
                if (!ref.isDestroyed()) {
                    StringInterner.managedInterningSet.remove(ref);
                    continue;
                }
                System.err.println("double removal " + ref);
            }
            currentSetSize = StringInterner.managedInterningSet.size();
            if (currentSetSize >= 10000 || scheduled) {
                remaining = new ArrayList<WeakWeightedEntry>(currentSetSize);
                it = StringInterner.managedInterningSet.iterator();
                while (it.hasNext()) {
                    if (StringInterner.managedInterningSet.size() >= 8000 || scheduled) {
                        entry = (WeakWeightedEntry)it.next();
                        if (entry.isPermanent()) continue;
                        if (WeakWeightedEntry.access$0(entry) == 0) {
                            it.remove();
                            continue;
                        }
                        remaining.add(entry);
                        continue;
                    }
                    break block14;
                }
                currentSetSize = StringInterner.managedInterningSet.size();
                if (currentSetSize >= 8000 || !scheduled) {
                    if (currentSetSize >= 8000 || scheduled) {
                        Collections.sort(remaining, StringInterner.savingsComp);
                        i = 0;
                        while (i < remaining.size()) {
                            currentSetSize = StringInterner.managedInterningSet.size();
                            if (currentSetSize < 7000 && scheduled) ** break;
                            if (currentSetSize >= 8000 || scheduled) {
                                entry = (WeakWeightedEntry)remaining.get(i);
                                StringInterner.managedInterningSet.remove(entry);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (!((currentSetSize = StringInterner.managedInterningSet.size()) < 750 && scheduled || currentSetSize < 8000 && !scheduled)) {
                    it = StringInterner.managedInterningSet.iterator();
                    while (it.hasNext()) {
                        ((WeakWeightedEntry)it.next()).decHits();
                    }
                }
            }
        }
        if (scheduled) {
            StringInterner.managedInterningSet.compactify(-1.0f);
        }
    }

    public static class DirKey
    extends FileKey {
        public static final DirKey EMPTY_PATH = new DirKey("");

        public DirKey(File dir) {
            super(dir, true);
        }

        public DirKey(String str) {
            super((File)null, str, true);
        }

        public DirKey(DirKey dir, String str) {
            super(dir, str, true);
        }

        @Override
        public boolean isFile() {
            return false;
        }
    }

    public static class FileKey
    implements StringSupplier {
        public static final FileKey EMPTY_FILE = new FileKey("");
        private final int hash_code;
        private final String[] comps;

        public FileKey(File file) {
            this(file, false);
        }

        public FileKey(String str) {
            this((File)null, str, false);
        }

        public FileKey(File file, String tail) {
            this(file, tail, false);
        }

        protected FileKey(File file, boolean is_dir) {
            this(file, null, is_dir);
        }

        public FileKey(FileKey fk, String tail) {
            this(fk, tail, false);
        }

        protected FileKey(FileKey fk, String tail, boolean is_dir) {
            this(fk.getFile(), tail, is_dir);
        }

        protected FileKey(File original_file, String tail, boolean is_dir) {
            if (TRACK_FILE_KEYS) {
                file_key_map.put(new WeakReference<FileKey>(this, file_key_ref_queue), "");
            }
            ArrayList<String> l = null;
            int hc = 0;
            if (tail != null && !tail.isEmpty()) {
                int pos = tail.length();
                while (pos >= 0) {
                    int next = tail.lastIndexOf(File.separator, pos - 1);
                    String name = next < 0 ? tail.substring(0, pos) : tail.substring(next + 1, pos);
                    hc += name.hashCode();
                    if (l == null) {
                        l = new ArrayList(10);
                        l.add(is_dir ? StringInterner.intern(name) : name);
                    } else {
                        l.add(StringInterner.intern(name));
                    }
                    pos = next;
                }
            }
            File file = original_file;
            while (file != null) {
                String name = file.getName();
                if (name == null) break;
                if (name.isEmpty() && (name = file.getPath()).endsWith(File.separator) && l != null) {
                    name = name.substring(0, name.length() - 1);
                }
                hc += name.hashCode();
                if (l == null) {
                    l = new ArrayList<String>(10);
                    l.add(is_dir ? StringInterner.intern(name) : name);
                } else {
                    l.add(StringInterner.intern(name));
                }
                file = file.getParentFile();
            }
            this.hash_code = hc;
            this.comps = l == null ? new String[0] : l.toArray(new String[l.size()]);
        }

        public File getFile() {
            return FileUtil.newFile(this.toString(), new String[0]);
        }

        @Override
        public boolean isEmpty() {
            return this.comps.length == 0;
        }

        public String toString() {
            int pos = this.comps.length - 1;
            if (pos < 0) {
                return "";
            }
            StringBuilder result = new StringBuilder(this.comps[pos--]);
            while (pos >= 0) {
                result.append(File.separator);
                result.append(this.comps[pos--]);
            }
            return result.toString();
        }

        @Override
        public String get() {
            return this.toString();
        }

        public int hashCode() {
            return this.hash_code;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileKey) {
                FileKey other = (FileKey)obj;
                int num_comps = this.comps.length;
                String[] ocomps = other.comps;
                if (num_comps != ocomps.length) {
                    return false;
                }
                int i = 0;
                while (i < num_comps) {
                    if (!this.comps[i].equals(ocomps[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (obj instanceof StringSupplier) {
                return this.get().equals(((StringSupplier)obj).get());
            }
            return false;
        }

        @Override
        public int compareTo(StringSupplier o) {
            return this.get().compareTo((String)o.get());
        }

        public boolean isFile() {
            return true;
        }
    }

    public static interface StringSupplier
    extends Supplier<String>,
    Comparable<StringSupplier> {
        public boolean isEmpty();
    }

    public static class StringSupplierBasic
    implements StringSupplier {
        public static final StringSupplier EMPTY_STRING = new StringSupplierBasic("");
        private final String str;

        public StringSupplierBasic(String _str) {
            this.str = _str == null ? "" : _str;
        }

        @Override
        public boolean isEmpty() {
            return this.str.isEmpty();
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringSupplierBasic) {
                return this.str.equals(((StringSupplierBasic)obj).str);
            }
            if (obj instanceof StringSupplier) {
                return this.str.equals(((StringSupplier)obj).get());
            }
            return false;
        }

        @Override
        public int compareTo(StringSupplier o) {
            return this.get().compareTo((String)o.get());
        }

        @Override
        public String get() {
            return this.str;
        }
    }

    public static class StringSupplierGenerated
    implements StringSupplier {
        private final Supplier<String> supplier;

        public StringSupplierGenerated(Supplier<String> _supplier) {
            this.supplier = _supplier;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringSupplier) {
                return this.supplier.get().equals(((StringSupplier)obj).get());
            }
            return false;
        }

        @Override
        public int compareTo(StringSupplier o) {
            return this.get().compareTo((String)o.get());
        }

        @Override
        public String get() {
            if (Constants.IS_CVS_VERSION) {
                String value = this.supplier.get();
                if (value == null || value.isEmpty()) {
                    Debug.out("Unsupported");
                }
                return value;
            }
            return this.supplier.get();
        }
    }

    private static class WeakEntry
    extends WeakReference {
        private final int hash;

        protected WeakEntry(Object o, ReferenceQueue q, int hash) {
            super(o, q);
            this.hash = hash;
        }

        public WeakEntry(Object o, ReferenceQueue q) {
            super(o, q);
            this.hash = o.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakEntry) {
                Object myObj = this.get();
                Object otherObj = ((WeakEntry)obj).get();
                return myObj == null ? false : myObj.equals(otherObj);
            }
            return false;
        }

        public final int hashCode() {
            return this.hash;
        }
    }

    private static class WeakStringEntry
    extends WeakWeightedEntry {
        public WeakStringEntry(String entry) {
            super((Object)entry, entry.hashCode(), 24 + entry.length() * 2);
        }

        public WeakStringEntry(String entry, boolean perm) {
            super(entry, perm, entry.hashCode(), 24 + entry.length() * 2);
        }

        public String getString() {
            return (String)this.get();
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " " + this.getString();
        }
    }

    private static class WeakURLEntry
    extends WeakWeightedEntry {
        public WeakURLEntry(URL entry) {
            super((Object)entry, entry.toExternalForm().hashCode(), 176 + entry.toString().length() * 2);
        }

        public URL getURL() {
            return (URL)this.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeakURLEntry) {
                URL other;
                URL my = this.getURL();
                if (my == (other = ((WeakURLEntry)obj).getURL())) {
                    return true;
                }
                if (my == null || other == null) {
                    return false;
                }
                return my.toExternalForm().equals(other.toExternalForm());
            }
            return false;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " " + this.getURL();
        }
    }

    private static abstract class WeakWeightedEntry
    extends WeakEntry {
        private final short size;
        private short hits;

        public WeakWeightedEntry(Object o, int hash, int size) {
            super(o, managedRefQueue, hash);
            this.size = (short)(size & Short.MAX_VALUE);
        }

        public WeakWeightedEntry(Object o, boolean perm, int hash, int size) {
            super(o, managedRefQueue, hash);
            this.size = (short)(perm ? Short.MIN_VALUE : (short)(size & Short.MAX_VALUE));
        }

        public void incHits() {
            if (this.hits < Short.MAX_VALUE) {
                this.hits = (short)(this.hits + 1);
            }
        }

        public void decHits() {
            if (this.hits > 0) {
                this.hits = (short)(this.hits - 1);
            }
        }

        public int getHits() {
            return this.hits;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName().replaceAll("^.*\\..\\w+$", "")) + " h=" + this.hits + ";s=" + (this.size == Short.MIN_VALUE ? "p" : String.valueOf(this.size));
        }

        public boolean isPermanent() {
            return this.size == Short.MIN_VALUE;
        }

        public void destroy() {
            this.hits = (short)-1;
        }

        public boolean isDestroyed() {
            return this.hits == -1;
        }
    }
}

