/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.internat.LocaleUtil;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.FileUtil;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;

public class SystemProperties {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String SEP = System.getProperty("file.separator");
    public static final String AZ_APP_ID = "az";
    public static final String SYSPROP_PORTABLE_ENABLE = SystemProperties.migrate("azureus.portable.enable");
    public static final String SYSPROP_CONFIG_PATH = SystemProperties.migrate("azureus.config.path");
    public static final String SYSPROP_INSTALL_PATH = SystemProperties.migrate("azureus.install.path");
    public static final String SYSPROP_PORTABLE_ROOT = SystemProperties.migrate("azureus.portable.root");
    public static final String SYSPROP_JAVA_PROTOCOL_HANDLER_PKGS = SystemProperties.migrate("java.protocol.handler.pkgs");
    public static final String SYSPROP_INTERNAL_BROWSER_DISABLE = SystemProperties.migrate("azureus.internal.browser.disable");
    public static final String SYSPROP_RCM_PUBLISH_DISABLE = SystemProperties.migrate("azureus.rcm.publish.disable");
    public static final String SYSPROP_RCM_MAX_CONCURRENT_PUBLISH = SystemProperties.migrate("azureus.rcm.max.concurrent.publish");
    public static final String SYSPROP_RCM_SEARCH_CVS_ONLY = SystemProperties.migrate("azureus.rcm.search.cvs.only");
    public static final String SYSPROP_FILE_PIECE_REORDER_FORCE = SystemProperties.migrate("azureus.file.piece.reorder.force");
    public static final String SYSPROP_IO_USEMMAP = SystemProperties.migrate("azureus.io.usemmap");
    public static final String SYSPROP_DISABLEDOWNLOADS = SystemProperties.migrate("azureus.disabledownloads");
    public static final String SYSPROP_INSTANCE_LOCK_DISABLE = SystemProperties.migrate("azureus.instance.lock.disable");
    public static final String SYSPROP_LOADPLUGINS = SystemProperties.migrate("azureus.loadplugins");
    public static final String SYSPROP_SKIP_SWTCHECK = SystemProperties.migrate("azureus.skipSWTcheck");
    public static final String SYSPROP_OVERRIDELOG = SystemProperties.migrate("azureus.overridelog");
    public static final String SYSPROP_LOG_STDOUT = SystemProperties.migrate("azureus.log.stdout");
    public static final String SYSPROP_SPEED_TEST_CHALLENGE_JAR_PATH = SystemProperties.migrate("azureus.speed.test.challenge.jar.path");
    public static final String SYSPROP_LAZY_BITFIELD = SystemProperties.migrate("azureus.lazy.bitfield");
    public static final String SYSPROP_SECURITY_MANAGER_INSTALL = SystemProperties.migrate("azureus.security.manager.install");
    public static final String SYSPROP_SUBS_MAX_ASSOCIATIONS = SystemProperties.migrate("azureus.subs.max.associations");
    public static final String SYSPROP_SUBS_MAX_CONCURRENT_ASSOC_PUBLISH = SystemProperties.migrate("azureus.subs.max.concurrent.assoc.publish");
    public static final String SYSPROP_LOG_DOS = SystemProperties.migrate("azureus.log.dos");
    public static final String SYSPROP_NATIVELAUNCHER = SystemProperties.migrate("azureus.nativelauncher");
    public static final String SYSPROP_INSTANCE_PORT = SystemProperties.migrate("azureus.instance.port");
    public static final String SYSPROP_PRODUCT_NAME = SystemProperties.migrate("azureus.product.name");
    public static final String SYSPROP_INFER_APP_NAME = SystemProperties.migrate("azureus.infer.app.name");
    public static final String SYSPROP_JAVAWS = SystemProperties.migrate("azureus.javaws");
    public static final String SYSPROP_TIME_USE_RAW_PROVIDER = SystemProperties.migrate("azureus.time.use.raw.provider");
    public static final String SYSPROP_DYNAMIC_PLUGINS = SystemProperties.migrate("azureus.dynamic.plugins");
    public static final String SYSPROP_DOC_PATH = SystemProperties.migrate("azureus.doc.path");
    public static final String SYSPROP_PLATFORM_MANAGER_DISABLE = SystemProperties.migrate("azureus.platform.manager.disable");
    public static final String SYSPROP_CONSOLE_NOISY = SystemProperties.migrate("azureus.console.noisy");
    public static final String SYSPROP_LOW_RESOURCE_MODE = SystemProperties.migrate("azureus.low.resource.mode");
    public static final String SYSPROP_SAFEMODE = SystemProperties.migrate("azureus.safemode");
    public static final String SYSPROP_OVERRIDELOGDIR = SystemProperties.migrate("azureus.overridelogdir");
    public static final String SYSPROP_SECURITY_MANAGER_PERMITEXIT = SystemProperties.migrate("azureus.security.manager.permitexit");
    public static final String SYSPROP_SCRIPT_VERSION = SystemProperties.migrate("azureus.script.version");
    public static final String SYSPROP_APP_TIMEZONE = SystemProperties.migrate("azureus.timezone");
    public static final String SYSPROP_APP_NAME = SystemProperties.migrate("azureus.app.name");
    public static final String SYSPROP_APP_SCRIPT = SystemProperties.migrate("azureus.script");
    public static final String SYSPROP_WINDOW_TITLE = SystemProperties.migrate("azureus.window.title");
    public static final String SYSPROP_CONSOLE_MULTIUSER = SystemProperties.migrate("azureus.console.multiuser");
    public static final String SYSPROP_FOLDER_DOWNLOAD = SystemProperties.migrate("azureus.folder.download");
    public static final String SYSPROP_FOLDER_TORRENT = SystemProperties.migrate("azureus.folder.torrent");
    public static final String SYSPROP_THREAD_MON_ENABLE = SystemProperties.migrate("biglybt.thread.monitor.enable");
    public static final String SYSPROP_MEMORY_MON_ENABLE = SystemProperties.migrate("biglybt.memory.monitor.enable");
    public static final String SYSPROP_THREAD_MON_USERONLY = SystemProperties.migrate("biglybt.thread.monitor.user.time");
    public static final String SYSPROP_LOGGING_DISABLE_STOP_ON_SLOW_CLOSE = SystemProperties.migrate("biglybt.logging.disable.stop.on.slow.close");
    private static String APPLICATION_NAME = "BiglyBT";
    private static String APPLICATION_ID = "az";
    private static String APPLICATION_VERSION = "3.9.0.0";
    private static String APPLICATION_ENTRY_POINT = "com.biglybt.ui.Main";
    private static final boolean PORTABLE = System.getProperty(SYSPROP_PORTABLE_ROOT, "").length() > 0;
    private static String user_path;
    private static String app_path;

    private static String migrate(String prop) {
        String bbt_prop;
        String val;
        if (prop.startsWith("azureus.") && System.getProperty(prop) == null && (val = System.getProperty(bbt_prop = "biglybt." + prop.substring(8), null)) != null) {
            System.setProperty(prop, val);
        }
        return prop;
    }

    public static void determineApplicationName() {
        String explicit_name = System.getProperty(SYSPROP_APP_NAME, null);
        if (explicit_name != null && (explicit_name = explicit_name.trim()).length() > 0) {
            SystemProperties.setApplicationName(explicit_name);
        }
    }

    public static void setApplicationName(String name) {
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
            if (user_path != null && !name.equals(APPLICATION_NAME)) {
                System.out.println("**** SystemProperties::setApplicationName called too late! ****");
            }
            APPLICATION_NAME = name;
        }
    }

    public static void setApplicationIdentifier(String application_id) {
        if (application_id != null && application_id.trim().length() > 0) {
            APPLICATION_ID = application_id.trim();
        }
    }

    public static void setApplicationEntryPoint(String entry_point) {
        if (entry_point != null && entry_point.trim().length() > 0) {
            APPLICATION_ENTRY_POINT = entry_point.trim();
        }
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static void setApplicationVersion(String v) {
        APPLICATION_VERSION = v;
    }

    public static String getApplicationVersion() {
        return APPLICATION_VERSION;
    }

    public static String getApplicationIdentifier() {
        return APPLICATION_ID;
    }

    public static String getApplicationEntryPoint() {
        return APPLICATION_ENTRY_POINT;
    }

    public static void setUserPath(String _path) {
        user_path = _path;
    }

    public static String getUserPath() {
        if (user_path != null) {
            return user_path;
        }
        String temp_user_path = System.getProperty(SYSPROP_CONFIG_PATH);
        try {
            File dir;
            if (temp_user_path != null) {
                File dir2;
                if (!temp_user_path.endsWith(SEP)) {
                    temp_user_path = String.valueOf(temp_user_path) + SEP;
                }
                if (!(dir2 = new File(temp_user_path)).exists()) {
                    FileUtil.mkdirs(dir2);
                }
                String string = temp_user_path;
                return string;
            }
            try {
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                File loc = platformManager.getLocation(1L);
                if (loc != null) {
                    temp_user_path = String.valueOf(loc.getPath()) + SEP;
                }
            }
            catch (Throwable e) {
                System.err.println("Unable to retrieve user config path from the platform manager. Make sure aereg.dll is present.");
            }
            if (temp_user_path == null) {
                String userhome = System.getProperty("user.home");
                temp_user_path = String.valueOf(userhome) + SEP + "." + APPLICATION_NAME.toLowerCase() + SEP;
            }
            if (!(dir = new File(temp_user_path)).exists()) {
                FileUtil.mkdirs(dir);
            }
            String string = temp_user_path;
            return string;
        }
        finally {
            user_path = temp_user_path;
        }
    }

    public static String getApplicationPath() {
        String i4jAppDir;
        if (app_path != null) {
            return app_path;
        }
        String temp_app_path = System.getProperty(SYSPROP_INSTALL_PATH, System.getProperty("user.dir"));
        File jarFile = new File(app_path, "BiglyBT.jar");
        if (!jarFile.exists() && (i4jAppDir = System.getProperty("install4j.appDir", null)) != null && (jarFile = new File(i4jAppDir, "BiglyBT.jar")).exists()) {
            temp_app_path = i4jAppDir;
        }
        if (!temp_app_path.endsWith(SEP)) {
            temp_app_path = String.valueOf(temp_app_path) + SEP;
        }
        app_path = temp_app_path;
        return app_path;
    }

    public static boolean isJavaWebStartInstance() {
        try {
            String java_ws_prop = System.getProperty(SYSPROP_JAVAWS);
            return java_ws_prop != null && java_ws_prop.equals("true");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getEnvironmentalVariable(String _var) {
        Properties envVars;
        block8: {
            if (Constants.isWindows9598ME) {
                return "";
            }
            String res = System.getenv(_var);
            if (res != null) {
                return res;
            }
            envVars = new Properties();
            BufferedReader br = null;
            try {
                String line;
                Process p = null;
                Runtime r = Runtime.getRuntime();
                p = Constants.isWindows ? r.exec(new String[]{"cmd.exe", "/c", "set"}) : r.exec("env");
                Charset system_encoding = LocaleUtil.getSingleton().getSystemEncoding();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getEnvironmentalVariable - " + _var + ", system encoding = " + system_encoding));
                }
                br = new BufferedReader(new InputStreamReader(p.getInputStream(), system_encoding), 8192);
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                }
                br.close();
            }
            catch (Throwable t) {
                if (br == null) break block8;
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return envVars.getProperty(_var, "");
    }

    public static String getDocPath() {
        String explicit_dir = System.getProperty(SYSPROP_DOC_PATH, null);
        if (explicit_dir != null) {
            File temp = new File(explicit_dir);
            if (!temp.exists()) {
                if (!temp.mkdirs()) {
                    System.err.println("Failed to create document dir: " + temp);
                }
            } else if (!temp.isDirectory() || !temp.canWrite()) {
                System.err.println("Document dir is not a directory or not writable: " + temp);
            }
            return temp.getAbsolutePath();
        }
        if (PORTABLE) {
            return SystemProperties.getUserPath();
        }
        File fDocPath = null;
        try {
            PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
            fDocPath = platformManager.getLocation(3L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (fDocPath == null) {
            System.err.println("This is BAD - fix me!");
            new Throwable().printStackTrace();
            fDocPath = new File(SystemProperties.getUserPath(), "Documents");
        }
        return fDocPath.getAbsolutePath();
    }

    public static String getAzureusJarPath() {
        return String.valueOf(SystemProperties.getApplicationPath()) + "BiglyBT" + ".jar";
    }
}

