/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEJavaManagement;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DebugLight;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPoolTask;
import com.biglybt.core.util.TimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class ThreadPool<T extends AERunnable> {
    private static final boolean NAME_THREADS = Constants.IS_CVS_VERSION && System.getProperty("az.thread.pool.naming.enable", "true").equals("true");
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    private static final List<ThreadPool<?>> busy_pools = new ArrayList();
    private static boolean busy_pool_timer_set = false;
    private static boolean debug_thread_pool;
    private static boolean debug_thread_pool_log_on;
    static final ThreadLocal tls;
    private final String name;
    private int thread_name_index = 1;
    private long execution_limit;
    private final List<threadPoolWorker> busy;
    private final boolean queue_when_full;
    private final List<T> task_queue = new ArrayList<T>();
    private final AESemaphore thread_sem;
    private int target_permits;
    private int current_permits;
    private int thread_priority = 5;
    private boolean warn_when_full;
    private long task_total;
    private long task_total_last;
    private final Average task_average = Average.getInstance(10000, 120);
    private boolean log_cpu = false;

    static {
        if (System.getProperty("transitory.startup", "0").equals("0")) {
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void generate(IndentWriter writer) {
                    writer.println("Thread Pools");
                    try {
                        ArrayList pools;
                        writer.indent();
                        List list = busy_pools;
                        synchronized (list) {
                            pools = new ArrayList(busy_pools);
                        }
                        int i = 0;
                        while (i < pools.size()) {
                            ((ThreadPool)pools.get(i)).generateEvidence(writer);
                            ++i;
                        }
                    }
                    finally {
                        writer.exdent();
                    }
                }
            });
        }
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List<ThreadPool<?>> list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        int i = 0;
        while (i < pools.size()) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
            ++i;
        }
    }

    public ThreadPool(String _name, int _max_size) {
        this(_name, _max_size, false);
    }

    public ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        if (_max_size < 1) {
            Debug.out("Invalid thread pool max: " + _max_size);
            _max_size = 1;
        }
        this.target_permits = _max_size;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, this.target_permits);
        this.current_permits = this.target_permits;
        this.busy = new ArrayList<threadPoolWorker>(_max_size);
    }

    private void generateEvidence(IndentWriter writer) {
        writer.println(String.valueOf(this.name) + ": max=" + this.target_permits + ",qwf=" + this.queue_when_full + ",queue=" + this.task_queue.size() + ",busy=" + this.busy.size() + ",total=" + this.task_total + ":" + DisplayFormatters.formatDecimal(this.task_average.getDoubleAverage(), 2) + "/sec");
    }

    public void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public void setLogCPU() {
        this.log_cpu = true;
    }

    public int getMaxThreads() {
        return this.target_permits;
    }

    public void setThreadPriority(int _priority) {
        this.thread_priority = _priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutionLimit(long millis) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.execution_limit = millis;
        }
    }

    public threadPoolWorker run(T runnable) {
        return this.run(runnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(T runnable, boolean high_priority, boolean manualRelease) {
        threadPoolWorker allocated_worker;
        if (manualRelease && !(runnable instanceof ThreadPoolTask)) {
            throw new IllegalArgumentException("manual release only allowed for ThreadPoolTasks");
        }
        if (manualRelease) {
            ((ThreadPoolTask)runnable).setManualRelease();
        }
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (runnable instanceof ThreadPoolTask) {
                    ThreadPoolTask task2 = (ThreadPoolTask)runnable;
                    task2.worker = recursive_worker;
                    try {
                        task2.taskStarted();
                        this.runIt((AERunnable)runnable);
                        task2.join();
                    }
                    finally {
                        task2.taskCompleted();
                    }
                } else {
                    this.runIt((AERunnable)runnable);
                }
                return recursive_worker;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (high_priority) {
                this.task_queue.add(0, runnable);
            } else {
                this.task_queue.add(runnable);
            }
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                allocated_worker = null;
                this.checkWarning();
            } else {
                allocated_worker = new threadPoolWorker();
            }
        }
        return allocated_worker;
    }

    protected void runIt(AERunnable runnable) {
        if (this.log_cpu) {
            long start_cpu = this.log_cpu ? AEJavaManagement.getThreadCPUTime() : 0L;
            long start_time = SystemTime.getHighPrecisionCounter();
            runnable.run();
            if (start_cpu > 0L) {
                long end_cpu = this.log_cpu ? AEJavaManagement.getThreadCPUTime() : 0L;
                long diff_cpu = (end_cpu - start_cpu) / 1000000L;
                long end_time = SystemTime.getHighPrecisionCounter();
                long diff_millis = (end_time - start_time) / 1000000L;
                if (diff_cpu > 10L || diff_millis > 10L) {
                    System.out.println(String.valueOf(TimeFormatter.milliStamp()) + ": Thread: " + Thread.currentThread().getName() + ": " + runnable + " -> " + diff_cpu + "/" + diff_millis);
                }
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWarning() {
        if (this.warn_when_full) {
            String task_names = "";
            try {
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    int i = 0;
                    while (i < this.busy.size()) {
                        threadPoolWorker x = this.busy.get(i);
                        AERunnable r = x.runnable;
                        if (r != null) {
                            String name = r instanceof ThreadPoolTask ? ((ThreadPoolTask)r).getName() : (r instanceof AERunnable.AERunnableNamed ? ((AERunnable.AERunnableNamed)r).getName() : r.getClass().getName());
                            task_names = String.valueOf(task_names) + (task_names.length() == 0 ? "" : ",") + name;
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.out("Thread pool '" + this.getName() + "' is full (busy=" + task_names + ")");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] res = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable getOldestQueuedTask() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            int num = this.task_queue.size();
            if (num > 0) {
                return (AERunnable)this.task_queue.get(num - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable task2) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getRunningTasks() {
        ArrayList tasks;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            tasks = new ArrayList(this.busy.size());
            for (threadPoolWorker worker : this.busy) {
                Object runnable = worker.getRunnable();
                if (runnable == null) continue;
                tasks.add(runnable);
            }
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningCount() {
        int res = 0;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker worker : this.busy) {
                Object runnable = worker.getRunnable();
                if (runnable == null) continue;
                ++res;
            }
        }
        return res;
    }

    public boolean isFull() {
        return this.thread_sem.getValue() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(int max) {
        if (max < 1) {
            Debug.out("Invalid thread pool max: " + max);
            max = 1;
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (max == this.target_permits) {
                return;
            }
            this.target_permits = max;
            while (this.target_permits < this.current_permits) {
                if (!this.thread_sem.reserveIfAvailable()) break;
                --this.current_permits;
            }
            while (this.target_permits > this.current_permits) {
                this.thread_sem.release();
                ++this.current_permits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long diff = this.task_total - this.task_total_last;
            this.task_average.addValue(diff);
            this.task_total_last = this.task_total;
            if (debug_thread_pool_log_on) {
                System.out.println("ThreadPool '" + this.getName() + "'/" + this.thread_name_index + ": max=" + this.target_permits + ",sem=[" + this.thread_sem.getString() + "],busy=" + this.busy.size() + ",queue=" + this.task_queue.size());
            }
            long now = SystemTime.getMonotonousTime();
            int i = 0;
            while (i < this.busy.size()) {
                threadPoolWorker x = this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed > 10000L * (long)(x.warn_count + 1)) {
                    AERunnable r;
                    threadPoolWorker threadPoolWorker2 = x;
                    threadPoolWorker2.warn_count = threadPoolWorker2.warn_count + 1;
                    if (this.execution_limit > 0L && elapsed > this.execution_limit && (r = x.runnable) != null) {
                        try {
                            if (r instanceof ThreadPoolTask) {
                                ((ThreadPoolTask)r).interruptTask();
                            } else {
                                x.interrupt();
                            }
                        }
                        catch (Throwable e) {
                            DebugLight.printStackTrace(e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseManual(ThreadPoolTask toRelease) {
        if (!toRelease.canManualRelease()) {
            throw new IllegalStateException("task not manually releasable");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long elapsed = SystemTime.getMonotonousTime() - toRelease.worker.run_start_time;
            if (!this.busy.remove(toRelease.worker)) {
                throw new IllegalStateException("task already released");
            }
            if (this.busy.size() == 0 && !debug_thread_pool) {
                List<ThreadPool<?>> list = busy_pools;
                synchronized (list) {
                    busy_pools.remove(this);
                }
            }
            if (this.busy.size() == 0) {
                if (this.current_permits > this.target_permits) {
                    --this.current_permits;
                } else {
                    this.thread_sem.release();
                }
            } else {
                new threadPoolWorker();
            }
        }
    }

    public void registerThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != null && tls.get() != parent) {
            throw new IllegalStateException("another parent is already set for this thread");
        }
        tls.set(parent);
    }

    public void deregisterThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != parent) {
            throw new IllegalStateException("tls is not set to parent");
        }
        tls.set(null);
    }

    static /* synthetic */ int access$7(ThreadPool threadPool) {
        return threadPool.current_permits;
    }

    static /* synthetic */ int access$8(ThreadPool threadPool) {
        return threadPool.target_permits;
    }

    static /* synthetic */ void access$9(ThreadPool threadPool, int n) {
        threadPool.current_permits = n;
    }

    static /* synthetic */ AESemaphore access$10(ThreadPool threadPool) {
        return threadPool.thread_sem;
    }

    static /* synthetic */ List access$11(ThreadPool threadPool) {
        return threadPool.busy;
    }

    static /* synthetic */ boolean access$12() {
        return debug_thread_pool;
    }

    static /* synthetic */ List access$13(ThreadPool threadPool) {
        return threadPool.task_queue;
    }

    static /* synthetic */ long access$14(ThreadPool threadPool) {
        return threadPool.task_total;
    }

    static /* synthetic */ void access$15(ThreadPool threadPool, long l) {
        threadPool.task_total = l;
    }

    static /* synthetic */ boolean access$16() {
        return busy_pool_timer_set;
    }

    static /* synthetic */ void access$19(boolean bl) {
        busy_pool_timer_set = bl;
    }

    class threadPoolWorker
    extends AEThread2 {
        private final String worker_name;
        private volatile T runnable;
        private long run_start_time;
        private int warn_count;
        private String state;

        protected threadPoolWorker() {
            super(NAME_THREADS ? String.valueOf(ThreadPool.this.name) + " " + ThreadPool.this.thread_name_index : ThreadPool.this.name, true);
            this.state = "<none>";
            ThreadPool threadPool2 = ThreadPool.this;
            threadPool2.thread_name_index = threadPool2.thread_name_index + 1;
            this.setPriority(ThreadPool.this.thread_priority);
            this.worker_name = this.getName();
            this.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool<T> getOwner() {
            return ThreadPool.this;
        }

        protected T getRunnable() {
            return this.runnable;
        }
    }
}

