/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.ThreadPool;

public abstract class ThreadPoolTask
extends AERunnable {
    static final int RELEASE_AUTO = 0;
    static final int RELEASE_MANUAL = 1;
    static final int RELEASE_MANUAL_ALLOWED = 2;
    private int manualRelease;
    protected ThreadPool.threadPoolWorker worker;

    public void setTaskState(String state) {
        this.worker.setState(state);
    }

    public String getTaskState() {
        return this.worker == null ? "" : this.worker.getState();
    }

    public abstract void interruptTask();

    public void taskStarted() {
    }

    public void taskCompleted() {
    }

    final synchronized void join() {
        while (this.manualRelease != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    final synchronized void setManualRelease() {
        this.manualRelease = 1;
    }

    final synchronized boolean canManualRelease() {
        return this.manualRelease == 2;
    }

    final synchronized boolean isAutoReleaseAndAllowManual() {
        if (this.manualRelease == 1) {
            this.manualRelease = 2;
        }
        return this.manualRelease == 0;
    }

    public final synchronized void releaseToPool() {
        if (this.manualRelease == 1) {
            this.manualRelease = 0;
        } else if (this.manualRelease == 2) {
            this.taskCompleted();
            this.worker.getOwner().releaseManual(this);
            this.manualRelease = 0;
        } else if (this.manualRelease == 0) {
            Debug.out("this should not happen");
        }
        this.notifyAll();
    }
}

